// datafile.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
extern "C" {
#include <sys/stat.h>
#include <sys/types.h>
}
#include "datafile.h"
#include "filename.h"

DataFile::DataFile() 
	: headersize(0), offset(0), readBytes(0), skiptime(0), durtime(0) {
}

DataFile::DataFile(
		const char* filename, const char* mode, double skip, double dur
	)
	   : headersize(0), offset(0), readBytes(0), skiptime(skip), durtime(dur) {
	open(filename, mode);
}   

const char *
DataFile::name() {
	return (is_open() && good()) ? 
		FileName::segmentName(DiskFile::name(), skipTime(), duration())
		: DiskFile::name();
}

inline off_t omax(off_t x, off_t y) { return x > y ? x : y; }

off_t
DataFile::readSize() {
	off_t dsize = dataSize();
	dsize = omax(0, dsize - offset);
	return (readBytes > 0) ? min(dsize, (int)readBytes) : dsize;
}

off_t
DataFile::dataSize() const {
	struct stat s;
	off_t datasize = 0;
	if(readable()) {
		if(fstat(fdesc(), &s) < 0)
			((DataFile &)*this).error();
		else
			datasize = max(0, s.st_size - headersize);
	}
	return datasize;
}
