// controller_action.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// This class encapsulates the calling of the Controller method which
// determines which menu item has been selected (based upon a stored key
// symbol) and calls the appropriate command method in either the Editor, the
// View, or in the Controller itself.

#ifndef CONTROLLER_ACTION_H
#define CONTROLLER_ACTION_H

#include <InterViews/action.h>
#include "controller.h"

class ControllerKeyCommandAction : public Action {
public:
	ControllerKeyCommandAction(Controller *c, unsigned long key)
		: controller(c), keysym(key) {}
	redefined void execute() { controller->keyCommand(keysym); }
private:
	Controller* controller;
	unsigned long keysym;
};

#endif
