// cmdstate.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#include "cmdstate.h"

CommandState::CommandState() : _flags(Nothing_Selected) {}

CommandState::~CommandState() {}

void
CommandState::Set(unsigned int stateFlag, bool set) {
	unsigned newFlags = _flags;
	newFlags = (set) ? newFlags | stateFlag : newFlags & ~stateFlag;
	Reset(newFlags);
}

void
CommandState::Reset(unsigned int stateFlags) {
	if (_flags != stateFlags) {
		_flags = stateFlags;
		Notify();
	}
}
