/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun May 27 10:03:25 CEST 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "mutella.h"
#include "controller.h"
#include "mui.h"

//#include <stdio.h>
//#include <stdlib.h>

//#include <pthread.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/wait.h>

#if __GLIBC__ == 2 && __GLIBC_MINOR__ >= 1
#define HAVE_BACKTRACE
#endif

#ifdef HAVE_BACKTRACE
#include <execinfo.h>
#endif

extern "C" {

void mutella_handle_sigsegv(int s)
{
  if (s != SIGSEGV)
  {
    fprintf(stderr, "Unknown signal.\n");
    return;
  }

  fprintf(stderr, "Mutella Segmentation Violation Detected.\n");
  /*fprintf(stderr, "Fault Address: [0x%08lX]\n", (unsigned long)si->si_addr); */

#ifdef HAVE_BACKTRACE
  fprintf(stderr, "Backtrace:\n");
  {
    void *array[32];
    unsigned short i;
    int n = backtrace(array, 32);
    char **res = backtrace_symbols(array, n);
    for (i = 0; i < n; i++)
      fprintf(stderr, "  %s\n", res[i]);
  }
  fprintf(stderr, "Attempting to generate core file.\n");
  pthread_kill_other_threads_np();
#endif
  abort();
}

void mutella_handle_sigchld(int s)
{
  if (s != SIGCHLD)
  {
    fprintf(stderr, "Unknown signal.\n");
    return;
  }

  wait(NULL);
}

} /*extern "C"*/


MMutex g_LibcMutex;

// The program starts here
int main(int argc, char *argv[])
{
    // set ignore to the alarm clock
    struct sigaction sa;
    memset(&sa,0,sizeof(sa));
    sa.sa_handler=SIG_IGN;
    sa.sa_flags=SA_RESTART;
    VERIFY(0==sigaction(SIGALRM, &sa, NULL));
    memset(&sa,0,sizeof(sa));
    sa.sa_handler=SIG_IGN;
    sa.sa_flags=SA_RESTART;
    // quick hack to workaround 'crashes' on send
    VERIFY(0==sigaction(SIGPIPE, &sa, NULL));
    //
    //signal(SIGSEGV, &mutella_handle_sigsegv);
    //signal(SIGCHLD, &mutella_handle_sigchld);
    //
    MController controller;
	if (!controller.Init())
		return EXIT_FAILURE;

	// start the controller functionality
    controller.Do();

	return EXIT_SUCCESS;
}
