/*
 *  arch-tag: Header for rating renderer object
 *
 *  Copyright (C) 2002 Olivier Martin <oleevye@wanadoo.fr>
 *  Various changes to adapt code to Music Applet (C) 2006
 *      Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 * 
 */

#ifndef MA_RATING_H
#define MA_RATING_H

#include <gtk/gtkeventbox.h>

#define MA_TYPE_RATING		(ma_rating_get_type ())
#define MA_RATING(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_RATING, MaRating))
#define MA_RATING_CLASS(k)	(G_TYPE_CHECK_CLASS_CASE ((k), MA_TYPE_RATING, MaRatingClass))
#define MA_IS_RATING(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_RATING))
#define MA_IS_RATING_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_RATING))
#define MA_RATING_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_RATING, MaRatingClass))

typedef struct _MaRating	MaRating;
typedef struct _MaRatingClass	MaRatingClass;
typedef struct _MaRatingPrivate	MaRatingPrivate;

struct _MaRating
{
	GtkEventBox parent;

	MaRatingPrivate *priv;
};

struct _MaRatingClass
{
	GtkEventBoxClass parent;

	void (*rated) (double score);
};

GType ma_rating_get_type (void);

MaRating *ma_rating_new (void);

#endif /* MA_RATING_H */
