//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mididev.h,v 1.1.1.1 2003/10/29 10:06:13 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDIDEV_H__
#define __MIDIDEV_H__

#include <qstring.h>
#include <list>

class MidiPlayEvent;

//---------------------------------------------------------
//   MidiDevice
//---------------------------------------------------------

class MidiDevice {
   protected:
      int _rwFlags;           // 1 read, 2 write, 3 rw
      int _masterVol;
      QString _name;
      int _port;

      void init();

   public:
      MidiDevice();
      MidiDevice(const QString& name);

      virtual ~MidiDevice();

      virtual QString open(int) = 0;
      virtual void close() = 0;

      const QString& name() const      { return _name; }
      void setName(const QString& s)   { _name = s; }

      int port() const                 { return _port; }
      void setPort(int p)              { _port = p; }

      int rwFlags() const;
      void setrwFlags(int val);

      virtual int selectRfd()          { return -1; }
      virtual int selectWfd()          { return -1; }
      virtual int bytesToWrite()       { return 0; }
      virtual void flush()             {}
      virtual void processInput()      {}
      virtual void discardInput()      {}
      virtual void putClock() = 0;
      virtual void putStart() = 0;
      virtual void putStop() = 0;
      virtual void putContinue() = 0;
      virtual void putSongpos(int) = 0;

      virtual void putEvent(const MidiPlayEvent*) = 0;

      void setMasterVol(int val);
      int masterVol() const { return _masterVol; }
      };

class MidiDeviceList : public std::list<MidiDevice*> {
   public:
      void add(MidiDevice* dev) {
            push_back(dev);
            }
      MidiDevice* find(const QString& name);
      };

typedef MidiDeviceList::iterator iMidiDevice;

extern MidiDeviceList midiDevices;
extern void initMidiDevices();

#endif

