//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ttoolbar.cpp,v 1.1 2002/01/30 14:54:04 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include "ttoolbar.h"
#include <qmainwindow.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qbuttongroup.h>
#include <qwhatsthis.h>
#include "song.h"
#include "icons.h"
#include "globals.h"

void TransportToolbar::setPunchin(bool f)
      {
      punchinButton->setOn(f);
      }

void TransportToolbar::setPunchout(bool f)
      {
      punchoutButton->setOn(f);
      }

void TransportToolbar::setLoop(bool f)
      {
      loopButton->setOn(f);
      }

void TransportToolbar::setRecord(bool f)
      {
      recordButton->setOn(f);
      }

void TransportToolbar::setPlay(bool f)
      {
      stopButton->setOn(!f);
      playButton->setOn(f);
      }

const char* infoLoopButton     = "loop between left mark and right mark";
const char* infoPunchinButton  = "record starts at left mark";
const char* infoPunchoutButton = "record stops at right mark";
const char* infoStartButton    = "rewind to start position";
const char* infoRewindButton   = "rewind current position";
const char* infoForwardButton  = "move current position";
const char* infoStopButton     = "stop sequencer";
const char* infoPlayButton     = "start sequencer play";
const char* infoRecordButton   = "to record press record and then play";

//---------------------------------------------------------
//   TransportToolbar
//---------------------------------------------------------

TransportToolbar::TransportToolbar(MainWindow* parent, const char* name = 0)
   : ToolBar("Transport", parent, name)
      {
      loopButton = new QToolButton(this);
      loopButton->setPixmap(*loop1Icon);
      QToolTip::add(loopButton, tr("Loop"));
      QWhatsThis::add(loopButton, infoLoopButton);
      loopButton->setToggleButton(true);
      loopButton->setOn(song->loop());
      connect(loopButton, SIGNAL(toggled(bool)), SIGNAL(loopChanged(bool)));

      punchinButton = new QToolButton(this);
      punchinButton->setPixmap(*punchin1Icon);
      QToolTip::add(punchinButton, tr("Punchin"));
      QWhatsThis::add(punchinButton, infoPunchinButton);
      punchinButton->setToggleButton(true);
      punchinButton->setOn(song->punchin());
      connect(punchinButton, SIGNAL(toggled(bool)), SIGNAL(punchinChanged(bool)));

      punchoutButton = new QToolButton(this);
      punchoutButton->setPixmap(*punchout1Icon);
      QToolTip::add(punchoutButton, tr("Punchout"));
      QWhatsThis::add(punchoutButton, infoPunchoutButton);
      punchoutButton->setToggleButton(true);
      punchoutButton->setOn(song->punchout());
      connect(punchoutButton, SIGNAL(toggled(bool)), SIGNAL(punchoutChanged(bool)));

      this->addSeparator();

      startButton = new QToolButton(this);
      startButton->setPixmap(*startIcon);
      QToolTip::add(startButton, tr("GotoStart"));
      QWhatsThis::add(startButton, infoStartButton);
      connect(startButton, SIGNAL(clicked()), song, SLOT(rewindStart()));

      rewindButton = new QToolButton(this);
      rewindButton->setPixmap(*frewindIcon);
      QToolTip::add(rewindButton, tr("Rewind"));
      QWhatsThis::add(rewindButton, infoRewindButton);
      connect(rewindButton, SIGNAL(clicked()), song, SLOT(rewind()));
      rewindButton->setAutoRepeat(true);

      forwardButton = new QToolButton(this);
      forwardButton->setPixmap(*fforwardIcon);
      QToolTip::add(forwardButton, tr("Forward"));
      QWhatsThis::add(forwardButton, infoForwardButton);
      connect(forwardButton, SIGNAL(clicked()), song, SLOT(forward()));
      forwardButton->setAutoRepeat(true);

      stopButton = new QToolButton(this);
      stopButton->setPixmap(*stopIcon);
      QToolTip::add(stopButton, tr("Stop"));
      stopButton->setToggleButton(true);
      QWhatsThis::add(stopButton, infoStopButton);

      playButton = new QToolButton(this);
      playButton->setPixmap(*playIcon);
      QToolTip::add(playButton, tr("Play"));
      QWhatsThis::add(playButton, infoPlayButton);
      playButton->setToggleButton(true);
      connect(playButton, SIGNAL(toggled(bool)), SIGNAL(playChanged(bool)));

      recordButton = new QToolButton(this);
      recordButton->setPixmap(*recordIcon);
      QToolTip::add(recordButton, tr("Record"));
      QWhatsThis::add(recordButton, infoRecordButton);
      recordButton->setToggleButton(true);
      recordButton->setOn(song->record());
      connect(recordButton, SIGNAL(toggled(bool)), SIGNAL(recordChanged(bool)));

      playBg = new QButtonGroup(0);
      playBg->setExclusive(true);
      playBg->hide();
      playBg->insert(stopButton, 0);
      playBg->insert(playButton, 1);
      stopButton->setOn(!(song->play()));
      playButton->setOn(song->play());

      connect(this, SIGNAL(punchinChanged(bool)), song, SLOT(setPunchin(bool)));
      connect(song, SIGNAL(punchinChanged(bool)), this, SLOT(setPunchin(bool)));

      connect(this, SIGNAL(punchoutChanged(bool)), song, SLOT(setPunchout(bool)));
      connect(song, SIGNAL(punchoutChanged(bool)), this, SLOT(setPunchout(bool)));

      connect(this, SIGNAL(recordChanged(bool)), song, SLOT(setRecord(bool)));
      connect(song, SIGNAL(recordChanged(bool)), this, SLOT(setRecord(bool)));

      connect(this, SIGNAL(playChanged(bool)), song, SLOT(setPlay(bool)));
      connect(song, SIGNAL(playChanged(bool)), this, SLOT(setPlay(bool)));

      connect(this, SIGNAL(loopChanged(bool)), song, SLOT(setLoop(bool)));
      connect(song, SIGNAL(loopChanged(bool)), this, SLOT(setLoop(bool)));
      connect(&extSyncFlag, SIGNAL(valueChanged(bool)), SLOT(syncChanged(bool)));
      syncChanged(extSyncFlag.value());
      }

//---------------------------------------------------------
//   TransportToolbar
//---------------------------------------------------------

TransportToolbar::~TransportToolbar()
      {
      delete playBg;
      }

//---------------------------------------------------------
//   syncChanged
//---------------------------------------------------------

void TransportToolbar::syncChanged(bool flag)
      {
      startButton->setEnabled(!flag);
      forwardButton->setEnabled(!flag);
      rewindButton->setEnabled(!flag);
      stopButton->setEnabled(!flag);
      playButton->setEnabled(!flag);
      }


