//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: spinboxFP.h,v 1.2 2001/11/20 15:19:35 muse Exp $
//    (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SPINBOXFP_H__
#define __SPINBOXFP_H__

#include <qspinbox.h>

//---------------------------------------------------------
//   SpinBoxFP
//---------------------------------------------------------

class SpinBoxFP : public QSpinBox {
      Q_OBJECT
      Q_PROPERTY( int precision READ precision WRITE setPrecision )

      int _precision;

   protected:
      virtual QString mapValueToText(int value);
      virtual int mapTextToValue(bool* ok);

   public:
      SpinBoxFP(QWidget* parent=0, const char* name = 0);
      SpinBoxFP(int minValue, int maxValue, int step = 1, QWidget* parent=0, const char* name = 0);
      void setPrecision(int val);
      int precision() const { return _precision; }
      };

#endif

