//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: metronome.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include "metronome.h"
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include "globals.h"
// #include "seq.h"

//---------------------------------------------------------
//   MetronomeConfig
//---------------------------------------------------------

MetronomeConfig::MetronomeConfig(QWidget* parent, const char* name = 0)
   : MetronomeConfigBase(parent, name)
      {
      connect(buttonApply, SIGNAL(clicked()), SLOT(apply()));
      connect(midiClick, SIGNAL(toggled(bool)), SLOT(midiClickChanged(bool)));
      connect(precountEnable, SIGNAL(toggled(bool)), SLOT(precountEnableChanged(bool)));
      connect(precountFromMastertrack, SIGNAL(toggled(bool)),
         SLOT(precountFromMastertrackChanged(bool)));

      measureNote->setValue(measureClickNote);
      measureVelocity->setValue(measureClickVelo);
      beatNote->setValue(beatClickNote);
      beatVelocity->setValue(beatClickVelo);
      midiChannel->setValue(clickChan+1);
      midiPort->setValue(clickPort+1);
      precountBars->setValue(preMeasures);
      precountEnable->setDown(precountEnableFlag);
      precountFromMastertrack->setDown(precountFromMastertrackFlag);
      precountSigZ->setValue(::precountSigZ);
      precountSigN->setValue(::precountSigN);
      precountPrerecord->setDown(::precountPrerecord);
      precountPreroll->setDown(::precountPreroll);
      midiClick->setDown(midiClickFlag);
      audioBeep->setDown(audioClickFlag);
      }

//---------------------------------------------------------
//   accept
//---------------------------------------------------------

void MetronomeConfig::accept()
      {
      apply();
      MetronomeConfigBase::accept();
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void MetronomeConfig::apply()
      {
      measureClickNote = measureNote->value();
      measureClickVelo = measureVelocity->value();
      beatClickNote = beatNote->value();
      beatClickVelo = beatVelocity->value();
      clickChan = midiChannel->value() - 1;
      clickPort = midiPort->value() - 1;
      preMeasures = precountBars->value();
      precountEnableFlag = precountEnable->isOn();
      precountFromMastertrackFlag = precountFromMastertrack->isOn();
      ::precountSigZ = precountSigZ->value();
      ::precountSigN = precountSigN->value();
      ::precountPrerecord = precountPrerecord->isOn();
      ::precountPreroll = precountPreroll->isOn();
      midiClickFlag = midiClick->isOn();
      audioClickFlag = audioBeep->isOn();
      }

//---------------------------------------------------------
//   reject
//---------------------------------------------------------

void MetronomeConfig::reject()
      {
      MetronomeConfigBase::reject();
      }

//---------------------------------------------------------
//   midiClickChanged
//---------------------------------------------------------

void MetronomeConfig::midiClickChanged(bool flag)
      {
      measureNote->setEnabled(flag);
      measureVelocity->setEnabled(flag);
      beatNote->setEnabled(flag);
      beatVelocity->setEnabled(flag);
      midiChannel->setEnabled(flag);
      midiPort->setEnabled(flag);
      }

void MetronomeConfig::precountEnableChanged(bool flag)
      {
      precountBars->setEnabled(flag);
      precountFromMastertrack->setEnabled(flag);
      precountSigZ->setEnabled(flag && !precountFromMastertrack->isOn());
      precountSigN->setEnabled(flag && !precountFromMastertrack->isOn());
      }

void MetronomeConfig::precountFromMastertrackChanged(bool flag)
      {
      precountSigZ->setEnabled(!flag);
      precountSigN->setEnabled(!flag);
      }


