//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: dlist.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __DLIST_H__
#define __DLIST_H__

#include "view.h"

#define TH  18                // normale Track-Hhe

class QPainter;
class QHeader;
class ScrollScale;
class Device;
class QLineEdit;
class DrumMap;

//---------------------------------------------------------
//   DList
//---------------------------------------------------------

class DList : public View {
      QHeader* header;
      ScrollScale* scroll;
      QLineEdit* editor;
      DrumMap* editEntry;

      int startY;
      int curY;
      int sPitch;
      enum { NORMAL, START_DRAG, DRAG } drag;

      virtual void draw(QPainter& p, const QRect&);
      virtual void viewMousePressEvent(QMouseEvent* event);
      virtual void viewMouseReleaseEvent(QMouseEvent* event);
      virtual void viewMouseDoubleClickEvent(QMouseEvent*);
      virtual void viewMouseMoveEvent(QMouseEvent*);

      int x2col(int x) const;
      void devicesPopupMenu(DrumMap* t, int x, int y);
      Q_OBJECT
      void moveSelection(int n);

   private slots:
      void sizeChange(int, int, int);
      void returnPressed();
      void moved(int, int);

   signals:
      void selectionChanged();
      void channelChanged();
      void mapChanged();
      void keyPressed(int, bool);
      void keyReleased(int, bool);

   public slots:
      void tracklistChanged();

   public:
      DList(QHeader*, QWidget* parent, int ymag);
      void setScroll(ScrollScale* s) { scroll = s; }
      };

#endif // __DLIST_H_

