
#include <stdio.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qcolordialog.h>
#include <qlistbox.h>
#include "appearance.h"
#include "track.h"
#include "app.h"
#include "song.h"
#include "event.h"
#include "arranger.h"
#include "widgets/filedialog.h"
#include "waveedit/waveedit.h"

//---------------------------------------------------------
//   Appearance
//---------------------------------------------------------

Appearance::Appearance(MusE* s, Arranger* a, QWidget* parent=0, const char* name = 0)
   : AppearanceDialogBase(parent, name)
      {
      seq = s;
      arr = a;

	// ARRANGER

      currentBg = arr->bgPixmap();
      if (currentBg.isEmpty())
            currentBg = "<none>";
      currentBgLabel->setText(currentBg);

      int showPartEvent = arr->showPartEvent();
      int showPartType = arr->showPartType();
      partShowframes->setChecked(	showPartType == 0);
      partShownames->setChecked(	showPartType == 1);
      partShowevents->setChecked(	      showPartType == 2);
      partShowCakes->setChecked(          showPartType == 3);
      eventNoteon->setChecked(		showPartEvent & (1 << 0));
      eventPolypressure->setChecked(	showPartEvent & (1 << 1));
      eventController->setChecked(	showPartEvent & (1 << 2));
      eventProgramchange->setChecked(	showPartEvent & (1 << 3));
      eventAftertouch->setChecked(	showPartEvent & (1 << 4));
      eventPitchbend->setChecked(	showPartEvent & (1 << 5));
      eventSpecial->setChecked(		showPartEvent & (1 << 6));
      eventButtonGroup->setEnabled(showPartType == 2);
      arrGrid->setChecked(arr->hasGrid());

	// COLORS


      // 0
      color[itemListBox->count()] = arr->getSelectedTrackColor();
      itemListBox->insertItem("selected tracks in arranger");

      // 1
      color[itemListBox->count()] = seq->getTransportHandleColor();
      itemListBox->insertItem("handle of transport window");

      // 2
      color[itemListBox->count()] = arr->getActivityColor();
      itemListBox->insertItem("track activity in arranger");

      // 3
      color[itemListBox->count()] = seq->getBigTimeForegroundColor();
      itemListBox->insertItem("bigtime font color");

      // 4
      color[itemListBox->count()] = seq->getBigTimeBackgroundColor();
      itemListBox->insertItem("bigtime background color");

      // 5
      color[itemListBox->count()] = WaveEdit::configBg();
      itemListBox->insertItem("waveedit background color");

	/* more to come i hope... */


      colorSelectedGroupBox->setEnabled(false);

      useDynamicColors->setChecked(arr->getActivityMode() == 1);

      connect(itemListBox, SIGNAL(selectionChanged()), SLOT(colorItemSelectionChanged()));
      connect(colorSelectButton, SIGNAL(clicked()), SLOT(configColor()));


	// STYLE

      for(int i = 0; i < themeComboBox->count(); ++i)
            if( themeComboBox->text(i) == seq->currentTheme() )
                  themeComboBox->setCurrentItem(i);
      fontSize->setValue(QApplication::font().pointSize());

      connect(applyButton, SIGNAL(clicked()), SLOT(apply()));
      connect(okButton, SIGNAL(clicked()), SLOT(ok()));
      connect(cancelButton, SIGNAL(clicked()), SLOT(cancel()));
      connect(selectBgButton, SIGNAL(clicked()), SLOT(configBackground()));
      connect(partShowevents, SIGNAL(toggled(bool)), eventButtonGroup, SLOT(setEnabled(bool)));
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void Appearance::apply()
      {
	int showPartEvent = 0;
	int showPartType = 0;

	if(partShowframes->isChecked())		showPartType  = 0;
	if(partShownames->isChecked())		showPartType  = 1;
	if(partShowevents->isChecked())		showPartType  = 2;
 	if(partShowCakes->isChecked())		showPartType  = 3;

	if(eventNoteon->isChecked())		showPartEvent |= (1 << 0);
	if(eventPolypressure->isChecked())	showPartEvent |= (1 << 1);
	if(eventController->isChecked())	showPartEvent |= (1 << 2);
	if(eventProgramchange->isChecked())	showPartEvent |= (1 << 3);
	if(eventAftertouch->isChecked())	showPartEvent |= (1 << 4);
	if(eventPitchbend->isChecked())		showPartEvent |= (1 << 5);
	if(eventSpecial->isChecked())		showPartEvent |= (1 << 6);

      arr->setBgPixmap(currentBg);
	arr->setShowPartType(showPartType);
	arr->setShowPartEvent(showPartEvent);
      arr->setGrid(arrGrid->isChecked());

      QFont font = QApplication::font();
      configFontSize = fontSize->value();
      font.setPointSize(configFontSize);
	QApplication::setFont(font, true);

	seq->loadTheme(themeComboBox->currentText());
	// setting up a new theme might change the fontsize, so re-read
      fontSize->setValue(QApplication::font().pointSize());

	// set colors...
	arr->setSelectedTrackColor(color[0]);
	seq->setTransportHandleColor(color[1]);
	arr->setActivityColor(color[2]);
	seq->setBigTimeForegroundColor(color[3]);
	seq->setBigTimeBackgroundColor(color[4]);
//      seq->setWaveeditBGColor(color[5]);
      WaveEdit::setConfigBg(color[5]);
      seq->configChanged();
	
	arr->setActivityMode(useDynamicColors->isChecked()?1:0);
      }

void Appearance::ok()
      {
      apply();
      close(false);
      }

void Appearance::cancel()
      {
      close(false);
      }

//---------------------------------------------------------
//   configBackground
//---------------------------------------------------------

void Appearance::configBackground()
      {
      QString cur(currentBg);
      if (cur == "<none>")
            cur = museGlobalShare + "/wallpapers";
      currentBg = getImageFileName(cur, image_file_pattern, this);
      if (currentBg.isEmpty())
            currentBg = "<none>";
      currentBgLabel->setText(currentBg);
      }

//---------------------------------------------------------
//    selectionChanged
//---------------------------------------------------------

void Appearance::colorItemSelectionChanged()
      {
      int n = itemListBox->currentItem();
      bool b = (itemListBox->currentText() != "");
      colorFrame->setBackgroundColor(color[n]);
      colorSelectedGroupBox->setEnabled(b);
      }

//---------------------------------------------------------
//   configColor
//---------------------------------------------------------

void Appearance::configColor()
      {
      int n = itemListBox->currentItem();
      color[n] = QColorDialog::getColor( color[n], this );
      colorFrame->setBackgroundColor(color[n]);
      }
