/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: beep.c,v 3.1 2001/10/29 17:13:03 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 *  beep function is based on beep() in cardmgr.c(pcmcia-cs)
 */
#include	<sys/kd.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<sys/ioctl.h>

#include	"env.h"

#define	SLEEP_TIME	100
#define	BEEP_TIME	100
#define	BEEP_BASE	1200
#define	BEEP_GOOD_STEP	600
#define	BEEP_ERROR_STEP	1200

void
beep(int status)
{
	int fd;
	static unsigned int freq = BEEP_BASE;

	if (status == GOOD)
		freq -= BEEP_GOOD_STEP;
	else
		freq += BEEP_ERROR_STEP;

	fd = open("/dev/console",O_WRONLY);
	if (fd < 0)
		return;
	ioctl(fd,KDMKTONE,(BEEP_TIME << 16) | freq);
	close(fd);
/*
	usleep(SLEEP_TIME*1000);
*/
}
