#ifndef GUI_H
#define GUI_H
#include <glib.h>
#include <gtk/gtkmain.h>
#include <syncengine.h>

gboolean open_mainwindow(gpointer data);
void mainwindow_save_size(void);
void sync_pair_selected(GtkTreeSelection *selection, gpointer data);
sync_pair *get_selected_pair(void);
void async_set_multisync_status(char *status);
void async_set_pairlist_status(sync_pair *pair, char *status, 
			       gboolean realaction);
void async_add_pairlist_log(sync_pair *pair, char* logstring, 
			    sync_log_type type);
void clear_pairlist_log(void);
void open_syncpairwindow(sync_pair *pair);
void ok_syncpairwindow(void);
void cancel_syncpairwindow(void);
void new_pair(void);
void open_localplugin_window();
void open_remoteplugin_window();
void show_common_object_types(sync_plugin *loc, sync_plugin *rem);
gboolean do_open_syncpairwindow(gpointer data);
gboolean do_main_quit(gpointer data);
void main_quit(void);
gboolean sync_okcanceldialog(char *text, gboolean okcancel);
gboolean sync_do_ask_dbfull(gpointer arg);
void sync_ask_dbfull(changed_object *change, sync_pair *pair);
void open_logwindow(void);
void logwindow_show_log(void);
void close_logwindow(void);
void filter_rule_selected(GtkMenuItem *menuitem, gpointer user_data);
void filter_dir_selected(sync_direction dir);
void filter_data_changed(char *data);
void filter_show(sync_filter *filter);
sync_filter *filter_find(sync_object_type type, sync_direction dir);
void sync_now(void);
void resync_now(void);
gboolean sync_open_process_socket(void);
void sync_process_socket_connection(gpointer data, int fd, 
				    GdkInputCondition cond);
void sync_process_socket_stream(gpointer data, int fd, 
				GdkInputCondition cond);
void sync_show_gui(void);
void sync_hide_gui(void);
void sync_show_msg(char *msg);
gboolean sync_do_show_msg(gpointer msg);
void sync_async_msg(char *msg);
void sync_ask_duplicate(changed_object *firstobj,
			changed_object *secondobj, gboolean sameuid,
			sync_pair *pair);
void sync_duplicate_actionselected(GtkWidget *window,
				   sync_duplicate_action action);

void sync_set_pair_status(sync_pair *pair, char *status);
char* sync_pair_to_string(sync_pair *pair);


#endif
