/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000-2001 CodeFactory AB
 * Copyright (C) 2000-2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gdk/gdkkeysyms.h> /* for GDK_Escape */
#include <gtk/gtk.h>
#include "file-sel.h"


static void
file_sel_handle_cancel (GtkWidget *widget, gpointer user_data)
{
	GtkWidget *fsel;

	fsel = gtk_widget_get_ancestor (widget, GTK_TYPE_FILE_SELECTION);
	gtk_widget_hide (fsel);
	gtk_main_quit ();
}

static void
file_sel_handle_ok (GtkWidget *widget, gboolean *dialog_result)
{
	struct stat       sb;
	GtkFileSelection *file_sel;
	char             *name;

	file_sel = GTK_FILE_SELECTION (
		gtk_widget_get_ancestor (widget, GTK_TYPE_FILE_SELECTION));
	name = gtk_file_selection_get_filename (file_sel);

	/* Change into directory if that's what the user selected. */
	if ((stat (name, &sb) == 0) && S_ISDIR (sb.st_mode)) {
		char *last_slash = strrchr (name, '/');
		gchar *dirname;
		/* The file selector needs a '/' at the end of a
		 * directory name.
		 */
		if (!last_slash || *(last_slash + 1) != '\0')
			dirname = g_strconcat (name, "/", NULL);
		else
			dirname = g_strdup (name);
		gtk_file_selection_set_filename (file_sel, dirname);
		g_free (dirname);
	} else {
		*dialog_result = TRUE;
		gtk_main_quit ();
	}
}

static guint
file_sel_delete_event (GtkWidget *widget, GdkEventAny *event)
{
	gtk_widget_hide (widget);
	gtk_main_quit ();
	return TRUE;
}

static gboolean 
file_sel_key_event (GtkFileSelection *file_sel, GdkEventKey *event)
{
	if (event->keyval == GDK_Escape) {
		gtk_button_clicked (GTK_BUTTON (file_sel->cancel_button));
		return TRUE;
	} else
		return FALSE;
}

gchar *
file_sel_run (const gchar *title)
{
	GtkFileSelection *file_sel;
	gboolean          accepted = FALSE;
	gchar            *filename = NULL;
	
	file_sel =  GTK_FILE_SELECTION (gtk_file_selection_new (title));

	gtk_window_set_wmclass (GTK_WINDOW (file_sel),
				"FileSelector",
				"MrProject");

	gtk_window_set_modal (GTK_WINDOW (file_sel), TRUE);
	
	gtk_signal_connect (GTK_OBJECT (file_sel->ok_button),
			    "clicked",
			    GTK_SIGNAL_FUNC (file_sel_handle_ok),
			    &accepted);
	gtk_signal_connect (GTK_OBJECT (file_sel->cancel_button),
			    "clicked",
			    GTK_SIGNAL_FUNC (file_sel_handle_cancel),
			    NULL);
	gtk_signal_connect (GTK_OBJECT (file_sel),
			    "key_press_event",
			    GTK_SIGNAL_FUNC (file_sel_key_event),
			    NULL);

	/*gtk_window_set_position (GTK_WINDOW (file_sel), GTK_WIN_POS_MOUSE);*/

	gtk_signal_connect (GTK_OBJECT (file_sel), "delete_event",
			    GTK_SIGNAL_FUNC (file_sel_delete_event), NULL);
	
	gtk_widget_show (GTK_WIDGET (file_sel));
	gtk_grab_add (GTK_WIDGET (file_sel));
	gtk_main ();
	
	if (accepted) {
		filename = g_strdup (gtk_file_selection_get_filename (file_sel));
	}

	gtk_widget_destroy (GTK_WIDGET (file_sel));

	return filename;
}
