/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 */

#ifndef __MPX_FILE_FILTER_H__
#define __MPX_FILE_FILTER_H__

#include <gtk/gtk.h>
#include <bonobo/bonobo-xobject.h>
#include "libmrproject/GNOME_MrProject.h"
#include "file-filter.h"

#define TYPE_MPX_FILE_FILTER		(mpx_file_filter_get_type ())
#define MPX_FILE_FILTER(obj)		(GTK_CHECK_CAST ((obj), TYPE_MPX_FILE_FILTER, MpxFileFilter))
#define MPX_FILE_FILTER_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_MPX_FILE_FILTER, MpxFileFilterClass))
#define IS_MPX_FILE_FILTER(obj)		(GTK_CHECK_TYPE ((obj), TYPE_MPX_FILE_FILTER))
#define IS_MPX_FILE_FILTER_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_MPX_FILE_FILTER))


typedef struct _MpxFileFilter       MpxFileFilter;
typedef struct _MpxFileFilterClass  MpxFileFilterClass;

struct _MpxFileFilter
{
	FileFilter parent;
};

struct _MpxFileFilterClass
{
	FileFilterClass parent_class;
};


GtkType     mpx_file_filter_get_type (void);
FileFilter *mpx_file_filter_new      (void);


#endif /* __MPX_FILE_FILTER_H__ */

