/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __FILE_PROJECT_H__
#define __FILE_PROJECT_H__

#include <bonobo/bonobo-xobject.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"
#include "project-engine/project.h"

#define FILE_PROJECT_TYPE       (file_project_get_type ())
#define FILE_PROJECT(o)		(GTK_CHECK_CAST ((o), FILE_PROJECT_TYPE, FileProject))
#define FILE_PROJECT_CLASS(k)   (GTK_CHECK_CLASS_CAST((k), FILE_PROJECT_TYPE, FileProjectClass))
#define IS_FILE_PROJECT(o)	(GTK_CHECK_TYPE ((o), FILE_PROJECT_TYPE))
#define IS_FILE_PROJECT_CLASS(k)(GTK_CHECK_CLASS_TYPE ((k), FILE_PROJECT_TYPE))

typedef struct _FileProject       FileProject;
typedef struct _FileProjectPriv   FileProjectPriv;

struct _FileProject {
	Project      parent;
};

typedef struct {
	ProjectClass parent_class;
} FileProjectClass;


GtkType		 file_project_get_type             (void);
Project		*file_project_new                  (void);
 

#endif /* __FILE_PROJECT_H__ */

