/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __RESOURCE_MANAGER_CLIENT_H__
#define __RESOURCE_MANAGER_CLIENT_H__

#include <gtk/gtkobject.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"
#include "manager-client.h"

#define RESOURCE_MANAGER_CLIENT_TYPE        (resource_mc_get_type ())
#define RESOURCE_MANAGER_CLIENT(o)          (GTK_CHECK_CAST ((o), RESOURCE_MANAGER_CLIENT_TYPE, ResourceManagerClient))
#define RESOURCE_MANAGER_CLIENTCLASS(k)     (GTK_CHECK_CLASS_CAST((k), RESOURCE_MANAGER_CLIENT_TYPE, ResourceManagerClientClass))
#define IS_RESOURCE_MANAGER_CLIENT(o)       (GTK_CHECK_TYPE ((o), RESOURCE_MANAGER_CLIENT_TYPE))
#define IS_RESOURCE_MANAGER_CLIENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), RESOURCE_MANAGER_CLIENT_TYPE))

typedef struct _ResourceManagerClient      ResourceManagerClient;
typedef struct _ResourceManagerClientClass ResourceManagerClientClass;
typedef struct _ResourceManagerClientPriv  ResourceManagerClientPriv;

struct _ResourceManagerClient {
        ManagerClient              parent;

	ResourceManagerClientPriv *priv;
};

struct _ResourceManagerClientClass 
{
        ManagerClientClass         parent_class;

	/* Signals */
	void (*resource_inserted) (ResourceManagerClient   *rmc,
				   GM_Resource             *resource);
	void (*resource_updated)  (ResourceManagerClient   *rmc,
				   GM_Resource             *resource);
	void (*resources_removed) (ResourceManagerClient   *rmc,
				   GSList                  *resources);

	void (*group_inserted)    (ResourceManagerClient   *rmc,
				   GM_ResourceGroup        *group);
	void (*group_updated)     (ResourceManagerClient   *rmc,
				   GM_ResourceGroup        *group);
	void (*group_removed)     (ResourceManagerClient   *rmc,
				   GM_Id                    group_id);
	void (*group_default_set) (ResourceManagerClient   *rmc,
				   GM_Id                    group_id);
};

GtkType         resource_mc_get_type        (void);

ManagerClient * resource_mc_new             (GM_Shell                shell,
					     gboolean                set, 
					     CORBA_Environment      *ev);

GM_Resource *   resource_mc_create_resource (ResourceManagerClient  *rmc,
					     CORBA_Environment      *ev);

GM_Id           resource_mc_insert_resource (ResourceManagerClient  *rmc,
					     GM_Resource            *resource,
					     CORBA_Environment      *ev);

GM_Resource *   resource_mc_get_resource    (ResourceManagerClient  *rmc,
					     GM_Id                   res_id,
					     CORBA_Environment      *ev);

GSList *      resource_mc_get_all_resources (ResourceManagerClient  *rmc,
					     CORBA_Environment      *ev);

void            resource_mc_update_resource (ResourceManagerClient  *rmc,
					     GM_Resource            *resource,
					     CORBA_Environment      *ev);

void            resource_mc_remove_resources (ResourceManagerClient  *rmc,
					      GSList                 *res_ids,
					      CORBA_Environment      *ev);

GM_ResourceGroup * resource_mc_create_group (ResourceManagerClient  *rmc,
					     CORBA_Environment      *ev);

GM_Id           resource_mc_insert_group    (ResourceManagerClient  *rmc,
					     GM_ResourceGroup       *group,
					     CORBA_Environment      *ev);

GM_ResourceGroup *    resource_mc_get_group (ResourceManagerClient  *rmc,
					     GM_Id                   group_id,
					     CORBA_Environment      *ev);

GSList *        resource_mc_get_all_groups  (ResourceManagerClient  *rmc,
					     CORBA_Environment      *ev);

void            resource_mc_update_group    (ResourceManagerClient  *rmc,
					     GM_ResourceGroup       *group,
					     CORBA_Environment      *ev);

void            resource_mc_remove_group    (ResourceManagerClient  *rmc,
					     GM_Id                   group_id,
					     CORBA_Environment      *ev);

GM_Id          resource_mc_get_default_group (ResourceManagerClient *rmc,
					      CORBA_Environment      *ev);

void           resource_mc_set_default_group (ResourceManagerClient *rmc,
					      GM_Id                  group_id,
					      CORBA_Environment      *ev);

#endif /* __RESOURCE_MANAGER_CLIENT_H__ */
