/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __ALLOCATION_MANAGER_CLIENT_H__
#define __ALLOCATION_MANAGER_CLIENT_H__

#include <gtk/gtkobject.h>
#include "util/corba-utils.h"
#include "manager-client.h"

#define ALLOCATION_MANAGER_CLIENT_TYPE        (allocation_mc_get_type ())
#define ALLOCATION_MANAGER_CLIENT(o)          (GTK_CHECK_CAST ((o), ALLOCATION_MANAGER_CLIENT_TYPE, AllocationManagerClient))
#define ALLOCATION_MANAGER_CLIENTCLASS(k)     (GTK_CHECK_CLASS_CAST((k), ALLOCATION_MANAGER_CLIENT_TYPE, AllocationManagerClientClass))
#define IS_ALLOCATION_MANAGER_CLIENT(o)       (GTK_CHECK_TYPE ((o), ALLOCATION_MANAGER_CLIENT_TYPE))
#define IS_ALLOCATION_MANAGER_CLIENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), ALLOCATION_MANAGER_CLIENT_TYPE))

typedef struct _AllocationManagerClient      AllocationManagerClient;
typedef struct _AllocationManagerClientClass AllocationManagerClientClass;
typedef struct _AllocationManagerClientPriv  AllocationManagerClientPriv;

struct _AllocationManagerClient {
	ManagerClient                parent;

        AllocationManagerClientPriv *priv;
};

struct _AllocationManagerClientClass 
{
	ManagerClientClass           parent_class;

	/* Signals */
	void (*allocation_added)    (AllocationManagerClient   *amc,
				     GM_Allocation             *allocation);
	void (*allocations_removed) (AllocationManagerClient   *amc,
				     GSList                    *allocations);
};

GtkType               
allocation_mc_get_type                  (void);

ManagerClient *
allocation_mc_new                       (GM_Shell                 shell,
					 gboolean                 set,
					 CORBA_Environment        *ev);

void
allocation_mc_allocate                  (AllocationManagerClient *amc,
					 GM_Id                    task_id,
					 GM_Id                    resource_id,
					 short                    units,
					 CORBA_Environment       *ev);

void
allocation_mc_deallocate               (AllocationManagerClient  *amc,
					GM_Allocation            *allocation,
					CORBA_Environment        *ev);

void
allocation_mc_deallocate_ids           (AllocationManagerClient  *amc,
					GM_Id                    task_id,
					GM_Id                    resource_id,
					CORBA_Environment        *ev);

GSList *
allocation_mc_get_allocations_by_task  (AllocationManagerClient  *amc,
					GM_Id                     task_id,
					CORBA_Environment        *ev);

GSList *       
allocation_mc_get_allocations_by_resource (AllocationManagerClient  *amc,
					   GM_Id                     res_id,
					   CORBA_Environment        *ev);

GSList *           
allocation_mc_get_all_allocations      (AllocationManagerClient  *amc,
					CORBA_Environment        *ev);

void
allocation_mc_deallocate_all_resources (AllocationManagerClient  *amc,
					GM_Id                     task_id,
					CORBA_Environment        *ev);

void
allocation_mc_deallocate_all_tasks     (AllocationManagerClient  *amc,
					GM_Id                     resource_id,
					CORBA_Environment        *ev);

#endif /* __ALLOCATION_MANAGER_CLIENT_H__ */
