/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __M_CELL_MULTI_PIXBUF_H__
#define __M_CELL_MULTI_PIXBUF_H__

#include <gtk/gtkwidget.h>
#include <gtk/gtktypeutils.h>
#include <gal/e-table/e-cell.h>
#include <gal/e-table/e-cell-text.h>
#include <gal/e-table/e-cell-popup.h>

#define M_CELL_MULTI_PIXBUF_TYPE        (m_cell_multi_pixbuf_get_type ())
#define M_CELL_MULTI_PIXBUF(o)          (GTK_CHECK_CAST ((o), M_CELL_MULTI_PIXBUF_TYPE, MCellMultiPixbuf))
#define M_CELL_MULTI_PIXBUF_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), M_CELL_MULTI_PIXBUF_TYPE, MCellMultiPixbufClass))

typedef struct {
	ECell parent_instance;

	gint n_images;
	GdkPixbuf **images;
	gint height;
	
} MCellMultiPixbuf;

typedef struct {
	ECellClass parent_class;
} MCellMultiPixbufClass;

GtkType    m_cell_multi_pixbuf_get_type (void);
ECell     *m_cell_multi_pixbuf_new (gint n_images, GdkPixbuf **images);

#endif /* __M_CELL_MULTI_PIXBUF_H__ */
