/* 
 * Copyright (C) 2001 Johan Dahlin <zilch.am@home.se>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <glib.h>
#include <bonobo/bonobo-object.h>

#include "libmrproject/GNOME_MrProject.h"
#include "python.h"

#define TERMINAL "gnome-terminal"

static GNOME_MrProject_Shell mrproject_shell;

static PyObject *
mr_project_shell (PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple (args, "")) {
		return NULL;
	}
	
	return (PyObject *) PyORBit_Object_New (mrproject_shell);
}

static PyMethodDef mr_project_methods[] = {
	{ "shell", mr_project_shell, METH_VARARGS },
	{ NULL,    NULL }
};

static gboolean
my_init_orbit_python (void)
{
	PyObject *orbpy = PyImport_ImportModule ("CORBA");
        if (PyErr_Occurred ()) {
                PyErr_Print ();
                return FALSE;
	}
	if (orbpy != NULL) {
		PyObject *module_dict = PyModule_GetDict (orbpy);
		PyObject *cobj = PyDict_GetItemString (module_dict, "_ORBitPython_API");
		if (PyCObject_Check (cobj))
			_ORBitPython_API = PyCObject_AsVoidPtr (cobj);
		else {
			Py_FatalError ("Could not find _ORBitPython_API object");
                        return FALSE;
                }
	} else {
		Py_FatalError ("Could not import CORBA");
                return FALSE;
	}
        return TRUE;
}

gboolean
init_python_script (GNOME_MrProject_Shell shell)
{
	gchar    *str;
	gboolean  retval;

	mrproject_shell = CORBA_Object_duplicate (shell, NULL);;
	
	Py_Initialize ();
	Py_InitModule ("__shell", mr_project_methods);

	if (!my_init_orbit_python ()) {
		return FALSE;
	}

	/* Fix path */
	str = g_strdup_printf ("import sys; sys.path.insert (0, '%spython')",
			       MRPROJECT_DATADIR);
	retval = PyRun_SimpleString (str);
	g_free (str);

	if (retval) {
		return FALSE;
	}
	
	/* Import IDL */
	return !PyRun_SimpleString ("from GNOME import MrProject");
}

void 
open_python_script (char *filename)
{
	FILE  *fp;
	
	fp = fopen (filename, "r");
	if (fp == NULL) {
		g_message ("Can't open %s. The file does not exist.",
			   filename);
		return;
	}

	PyRun_SimpleFile (fp, filename);
	fclose (fp);
}

void 
launch_python_shell (void)
{
	gchar *cmd;

	cmd = g_strdup_printf ("cd %spython && %s -e \"python MrProjectShell.py\"",
			       MRPROJECT_DATADIR, TERMINAL);

	system (cmd);
	g_free (cmd);
	
}
