/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* 
 * Author : 
 *  Damon Chaplin <damon@ximian.com>
 *
 * Copyright 1999, Ximian, Inc.
 * Copyright 2001, Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
/*
 * This code was taken from Evolution and
 * modified by Thomas Nyberg <thomas@codefactory.se>
 */
#ifndef __MONTH_VIEW_TITLES_ITEM_H__
#define __MONTH_VIEW_TITLES_ITEM_H__

#include "month-view.h"

/*
 * EWeekViewTitlesItem - displays the 'Monday', 'Tuesday' etc. at the top of
 * the Month calendar view.
 */

#define MONTH_VIEW_TITLES_ITEM(obj)     (GTK_CHECK_CAST((obj), \
        month_view_titles_item_get_type (), MonthViewTitlesItem))
#define MONTH_VIEW_TITLES_ITEM_CLASS(k) (GTK_CHECK_CLASS_CAST ((k),\
	month_view_titles_item_get_type (), MonthViewTitlesItemClass))
#define IS_MONTH_VIEW_TITLES_ITEM(o)    (GTK_CHECK_TYPE((o), \
	month_view_titles_item_get_type ()))

typedef struct _MonthViewTitlesItem MonthViewTitlesItem;
typedef struct _MonthViewTitlesItemClass MonthViewTitlesItemClass;

struct _MonthViewTitlesItem {
	GnomeCanvasItem parent;

	/* The parent MonthView widget. */
	MonthView *month_view;
};

struct _MonthViewTitlesItemClass {
	GnomeCanvasItemClass parent_class;
};


GtkType  month_view_titles_item_get_type      (void);


#endif /* __MONTH_VIEW_TITLES_ITEM_H__ */
