#ifndef OUTPUTTER_BASE_H_
#define OUTPUTTER_BASE_H_

#include "OutputList.h"
#include "SeriesHandler.h"

#include <map>
#include <string>

#include <wx/filename.h>

namespace jcs {

class Options 
{
public:
	std::string pathname;
	std::map <std::string, bool> boolOptions;
	std::map <std::string, int> intOptions;
	std::map <std::string, wxString> stringOptions;
	std::map <std::string, double> doubleOptions;
};


class OutputterBase {

public :

	OutputterBase(const Options& options);
	virtual ~OutputterBase();

	virtual void UpdateOutputForSeries(SeriesHandler* handler) = 0;
	virtual void RemoveSeries(const std::string& seriesUid) = 0;

	virtual int ConvertSeries(SeriesHandler* handler) = 0;

	OutputList mOutputList;

	ImageFileName GetImageFileName(const std::string& series_uid, const std::string& name);

	wxFileName GetFileName(const std::string& series_uid);

	void ChangeFileName(const std::string& series_uid, const std::string& new_name);
	void ChangeDirName(const std::vector<std::string>& series_uids, const std::string& new_name, 
		int position);

	bool mSplitDirsFlag;

	virtual void SetOption(const std::string& name, int value) {}
	virtual void SetOption(const std::string& name, bool value);

	struct NameField
	{
	  std::string name;
	  bool value;
	  int idx;
	  NameField(std::string n, bool v) : name(n), value(v) {}
	  NameField(std::string n, bool v, int i) : name(n), value(v), idx(i) {}
	  NameField() {}
	};

	enum {
	  PatientName,
	  PatientId,
	  SeriesDate,
	  SeriesTime,
	  StudyId,
	  StudyDescription,
	  SeriesNumber,
	  SequenceName,
	  ProtocolName,
	  SeriesDescription
	};

	typedef std::map<int, NameField> FieldMap;
	FieldMap defaultNameFields;

protected :
	virtual void FillInDefaultDirs(ImageFileName& name, SeriesHandler* series);

	std::string GenerateDefaultPrefix(SeriesHandler* series);

	std::map<VolId, std::string> volKeyMap;

	Options mOptions;

	static Options GetBaseOptions();

	std::map<std::string, Options> overrides;
	

private :

};

}

#endif

