/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import java.awt.Color;
import java.awt.Graphics2D;

public abstract class StateBorder {
    public static final StateBorder EMPTY_BORDER = new EmptyBorder();
    public static final StateBorder WHITE_PLAIN_BORDER = new WhitePlainBorder();
    public static final StateBorder WHITE_LOWERED_BORDER = new WhiteLoweredBorder();
    public static final StateBorder WHITE_RAISED_BORDER = new WhiteRaisedBorder();
    public static final StateBorder COLOR_LOWERED_BORDER = new ColorLoweredBorder();
    public static final StateBorder COLOR_RAISED_BORDER = new ColorRaisedBorder();
    public static final StateBorder COLOR_XOR_BORDER = new ColorXORBorder();

    public static StateBorder parseString(String string) {
        if (string.equalsIgnoreCase(COLOR_XOR_BORDER.toString())) {
            return COLOR_XOR_BORDER;
        }
        if (string.equalsIgnoreCase(COLOR_RAISED_BORDER.toString())) {
            return COLOR_RAISED_BORDER;
        }
        if (string.equalsIgnoreCase(COLOR_LOWERED_BORDER.toString())) {
            return COLOR_LOWERED_BORDER;
        }
        if (string.equalsIgnoreCase(WHITE_RAISED_BORDER.toString())) {
            return WHITE_RAISED_BORDER;
        }
        if (string.equalsIgnoreCase(WHITE_LOWERED_BORDER.toString())) {
            return WHITE_LOWERED_BORDER;
        }
        if (string.equalsIgnoreCase(WHITE_PLAIN_BORDER.toString())) {
            return WHITE_PLAIN_BORDER;
        }
        if (string.equalsIgnoreCase(EMPTY_BORDER.toString())) {
            return EMPTY_BORDER;
        }
        return null;
    }

    public abstract void paintStateBorder(Graphics2D var1, Color var2, int var3, int var4, boolean var5, int var6, int var7, boolean var8);

    public abstract String toString();

    public static class ColorXORBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
            int n5 = n3 - n + 1;
            int n6 = n4 - n2 + 1;
            graphics2D.setXORMode(color);
            graphics2D.fillRect(n, n4, n5, 1);
            if (bl2) {
                graphics2D.fillRect(n3, n2, 1, n6);
            }
            graphics2D.fillRect(n, n2, n5, 1);
            if (bl) {
                graphics2D.fillRect(n, n2, 1, n6);
            }
            graphics2D.setPaintMode();
        }

        @Override
        public String toString() {
            return "ColorXOR";
        }
    }

    public static class ColorRaisedBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
            int n5 = n3 - n + 1;
            int n6 = n4 - n2 + 1;
            graphics2D.setColor(color.darker());
            graphics2D.fillRect(n, n4, n5, 1);
            if (bl2) {
                graphics2D.fillRect(n3, n2, 1, n6);
            }
            graphics2D.setColor(color.brighter());
            graphics2D.fillRect(n, n2, n5, 1);
            if (bl) {
                graphics2D.fillRect(n, n2, 1, n6);
            }
        }

        @Override
        public String toString() {
            return "ColorRaised";
        }
    }

    public static class ColorLoweredBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
            int n5 = n3 - n + 1;
            int n6 = n4 - n2 + 1;
            graphics2D.setColor(color.brighter());
            graphics2D.fillRect(n, n4, n5, 1);
            if (bl2) {
                graphics2D.fillRect(n3, n2, 1, n6);
            }
            graphics2D.setColor(color.darker());
            graphics2D.fillRect(n, n2, n5, 1);
            if (bl) {
                graphics2D.fillRect(n, n2, 1, n6);
            }
        }

        @Override
        public String toString() {
            return "ColorLowered";
        }
    }

    public static class WhiteRaisedBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
            int n5 = n3 - n + 1;
            int n6 = n4 - n2 + 1;
            graphics2D.setColor(Color.gray);
            graphics2D.fillRect(n, n4, n5, 1);
            if (bl2) {
                graphics2D.fillRect(n3, n2, 1, n6);
            }
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n, n2, n5, 1);
            if (bl) {
                graphics2D.fillRect(n, n2, 1, n6);
            }
        }

        @Override
        public String toString() {
            return "WhiteRaised";
        }
    }

    public static class WhiteLoweredBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
            int n5 = n3 - n + 1;
            int n6 = n4 - n2 + 1;
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n, n4, n5, 1);
            if (bl2) {
                graphics2D.fillRect(n3, n2, 1, n6);
            }
            graphics2D.setColor(Color.gray);
            graphics2D.fillRect(n, n2, n5, 1);
            if (bl) {
                graphics2D.fillRect(n, n2, 1, n6);
            }
        }

        @Override
        public String toString() {
            return "WhiteLowered";
        }
    }

    public static class WhitePlainBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
            int n5 = n3 - n + 1;
            int n6 = n4 - n2 + 1;
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n, n4, n5, 1);
            if (bl2) {
                graphics2D.fillRect(n3, n2, 1, n6);
            }
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(n, n2, n5, 1);
            if (bl) {
                graphics2D.fillRect(n, n2, 1, n6);
            }
        }

        @Override
        public String toString() {
            return "WhitePlain";
        }
    }

    public static class EmptyBorder
    extends StateBorder {
        @Override
        public void paintStateBorder(Graphics2D graphics2D, Color color, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
        }

        @Override
        public String toString() {
            return "Empty";
        }
    }
}

