/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;

public class RecHeader {
    private static final int BYTESIZE = 16;
    public double timestamp;
    public int rectype;
    public int taskID;

    public RecHeader() {
        this.timestamp = Double.MIN_VALUE;
        this.rectype = Integer.MIN_VALUE;
        this.taskID = Integer.MIN_VALUE;
    }

    public RecHeader(DataInputStream dataInputStream) {
        this.readFromDataStream(dataInputStream);
    }

    public int readFromDataStream(DataInputStream dataInputStream) {
        try {
            this.timestamp = dataInputStream.readDouble();
            this.rectype = dataInputStream.readInt();
            this.taskID = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 16;
    }

    public int skipBytesFromDataStream(DataInputStream dataInputStream) {
        try {
            dataInputStream.skipBytes(16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 16;
    }

    public int getRecType() {
        return this.rectype;
    }

    public String toString() {
        return "RecHeader[ timestamp=" + this.timestamp + ", rectype=" + this.rectype + ", taskID=" + this.taskID + " ]";
    }
}

