/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JTree;
import com.sun.java.swing.Timer;
import com.sun.java.swing.event.CellEditorListener;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.plaf.basic.BasicTreeCellEditorContainer;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import com.sun.java.swing.plaf.basic.BasicTreeUI;
import com.sun.java.swing.tree.TreePath;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class BasicTreeCellEditor
extends BasicTreeCellEditorContainer
implements ActionListener,
TreeSelectionListener {
    protected boolean canEdit;
    protected JTree changeTree;
    protected TreePath lastPath;
    protected Timer timer;

    public BasicTreeCellEditor(BasicTreeCellRenderer basicTreeCellRenderer) {
        super(null, basicTreeCellRenderer);
        JTextField jTextField = new JTextField();
        this.realEditor = new DefaultCellEditor(jTextField);
        ((DefaultCellEditor)this.realEditor).setClickCountToStart(1);
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        TreePath treePath = jTree.getPathForRow(n);
        Component component = super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        boolean bl4 = this.canEdit = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
        if (this.timer != null) {
            this.timer.stop();
        }
        return component;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject == null || eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() > 2) {
            return super.isCellEditable(eventObject);
        }
        if (this.canEdit && ((MouseEvent)eventObject).getClickCount() == 1) {
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }
        return false;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        super.addCellEditorListener(cellEditorListener);
        if (cellEditorListener instanceof BasicTreeUI) {
            this.setChangeTree(((BasicTreeUI)cellEditorListener).tree);
            return;
        }
        this.setChangeTree(null);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        super.removeCellEditorListener(cellEditorListener);
        if (cellEditorListener instanceof BasicTreeUI) {
            this.setChangeTree(null);
        }
    }

    protected void setChangeTree(JTree jTree) {
        if (this.changeTree != null) {
            this.changeTree.removeTreeSelectionListener(this);
        }
        this.changeTree = jTree;
        if (this.changeTree != null) {
            this.changeTree.addTreeSelectionListener(this);
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.changeTree != null) {
            this.lastPath = this.changeTree.getSelectionCount() == 1 ? this.changeTree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.changeTree != null && this.lastPath != null) {
            this.changeTree.startEditingAtPath(this.lastPath);
        }
    }
}

