/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "frmjava.h"

#define JAVA_DB_NAME "/a/mobile/kjava/J2MEST"
#define JAVA_DB_SIZE 20460
#define JAVA_DB_ATTR 0x07
#define JAVA_DB_TEMP "/tmp/moto4lin/J2MEST"
#define JAVA_STD_ICON "/a/j2me15x15icon.png"
#define PAT_FILE "/usr/share/moto4lin/j2me.pat"
#define PAT_FULLFILE "/usr/share/moto4lin/full.pat"

#include <qlistview.h>
#include <string.h>
#include <qurloperator.h>
#include <qpixmap.h>
#include <qfiledialog.h>
#include <qcstring.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qpushbutton.h>

#include "unzip/qzip.h"
#include "phoneman.h"
#include "appconfig.h"
#include "custmsg.h"
#include "javalistviewitem.h"
#include "javamanifest.h"

#define EXT_COUNT 5
char * javaExt[EXT_COUNT]={"jad", "jar", "pat", "rms", "png"};

frmJava::frmJava(QWidget *parent, PhoneMan * ph, appConfig * cfg, const char *name)
 : frmJava_base(parent, name)
{
	phone=ph;
	host=parent;
	myCfg=cfg;
	connect(phone, SIGNAL(nfoComplete(int, const QString& )), this, SLOT(onComplete(int, const QString& )));
	connect(phone, SIGNAL(nfoFileList(int, P2kFile *, int)), this, SLOT(onFileList(int, P2kFile*, int )));
	updateRequested=0;
	fileCount=0;
	files = 0L;
	iconsCount=0;
	icons = 0L;
	reqID=-1;
	
	btnUpdateList->setEnabled(TRUE);
	btnAdd->setEnabled(FALSE);
	btnRemove->setEnabled(FALSE);
	btnSetPat->setEnabled(FALSE);
	btnSave->setEnabled(FALSE);
}

frmJava::~frmJava()
{
}

void frmJava::checkIcon(int n)
{
	QString fn=QString("/tmp/moto4lin/j2me%1.png").arg(n);
	QImage img;
	img.load(fn, "PNG");
	QImage scaled=img.smoothScale(15,15);	
	scaled.save(fn, "PNG");
}

void frmJava::onComplete(int act, const QString& s)
{
	if (updateRequested!=act) return;
	updateRequested=0;	

	if (act==TASK_DOWNLOADFILES && s==JAVA_DB_NAME)
		parseMidletList();
	if (act==TASK_DOWNLOADFILES && s==JAVA_STD_ICON)
		parseIcons();
	if (act==TASK_DELETEFILES && s==JAVA_DB_NAME)
		writeJ2MEST();
		
}

void frmJava::onFileList(int req, P2kFile * lst, int count)
{
	if (req!=reqID) return;
	if (files) free(files);
	fileCount=count;
	files=(P2kFile *) malloc (sizeof(P2kFile)*count);
	memcpy(files, lst, sizeof(P2kFile)*count);
	if (updateRequested==TASK_FILELIST)
	{
		updateRequested=0;
		P2kFile * file = fileByName(JAVA_DB_NAME,files, count);
		if (file == 0L)
			postLogMessage(phone, MSGSTYLE_ERROR, QString("Unable to get J2MEST"));
		else
		{
			updateRequested=TASK_DOWNLOADFILES;
			phone->downloadFiles(file, 1, JAVA_DB_TEMP);
		}
// 		if (file==NULL)
	}
}

void frmJava::onUpdateList()
{
	updateRequested=TASK_FILELIST;
	reqID=phone->search("/a/|*");
}

void frmJava::parseMidletList()
{
	FILE * fp;
	lstJava->clear();
	
	fp=fopen(JAVA_DB_TEMP, "r");
	if (fp==NULL) return;
	qDebug("Rec: %d",sizeof(int));
	Midlet midlets[31];
	fread(midlets,sizeof(Midlet),31, fp);
	fclose(fp);
	
	int i;
	P2kFile * f1;
	char s[256];

	
	if (icons!=0L) free(icons);
	icons = (P2kFile *) malloc (sizeof(P2kFile)*30); // Download 30 files as default
	iconsCount=0;
	
	QListViewItem * tmp;
	
	for (i=0; i<30; i++) 
		if (midlets[i].showInMenu)
		{
			midlets[i].idx=i+1;
			tmp = new JavaListViewItem (lstJava, &midlets[i]);
			if (midlets[i].ico1)
			{
				sprintf(s,"/a/mobile/kjava/j2me%d.png", midlets[i].idx-1);
				f1=fileByName(s,files, fileCount);
				if (f1)
					memcpy(&icons[iconsCount++], f1, sizeof(P2kFile));
			}
		}
		
	f1=fileByName(JAVA_STD_ICON,files, fileCount);
	if (f1)
		memcpy(&icons[iconsCount++], f1, sizeof(P2kFile));
	updateRequested=TASK_DOWNLOADFILES;
	phone->downloadFiles(icons, iconsCount , "/tmp/moto4lin/");
	
	btnAdd->setEnabled(TRUE);
	btnRemove->setEnabled(TRUE);
	btnSetPat->setEnabled(TRUE);
	btnSave->setEnabled(TRUE);
}

void frmJava::parseIcons()
{
	if (!iconsCount) return;
	
	QListViewItem * item;
	item=lstJava->firstChild();
	int i;
	int idx;
	char s[200];
	QString s1;
	QString s2;
// 	QPixmap * pix;
	
	while (item)
	{
		sprintf(s,"/a/mobile/kjava/j2me%d.png", item->text(0).toInt()-1);
		idx=-1;
		for (i=0; i<iconsCount; i++)
			if (!strcmp(s, icons[i].name))
			{
				idx=i;
				break;
			}
	
		if (idx==-1) idx=iconsCount-1;
			
		if (idx>=0)
		{
			s1=icons[idx].name;
			s1=s1.section('/',-1,-1);
			s2=QString("/tmp/moto4lin/%1").arg(s1);

			item->setPixmap(0, *(new QPixmap(s2)));
			qDebug(s2);
		}
		
		item=item->nextSibling();	
	}
	
}

P2kFile frmJava::writeJ2MEST(char justCreate)
{
	JavaListViewItem * item;
	Midlet midlets[31];
	Midlet mid;
	memset(midlets, 0, sizeof(midlets));
	
	item=(JavaListViewItem * ) (lstJava->firstChild());
	while (item)
	{
// 		memcpy(&midlets[i], &item->getMidlet(), sizeof(Midlet));
		
		item->getMidlet(&mid);
		memcpy(&midlets[mid.idx-1], &mid, sizeof(Midlet));
		item=(JavaListViewItem*) (item->nextSibling());
	}
	FILE * fp;
	fp=fopen("/tmp/moto4lin/J2MEST","w");
	fwrite(midlets,sizeof(Midlet),31, fp);
	fclose(fp);

	P2kFile f1;
	f1.size=0;
		
	P2kFile *fl;
	fl=fileByName(JAVA_DB_NAME,files, fileCount);
	if (fl==0L)
	{
		qDebug("J2MEST not found");
		postLogMessage(phone, MSGSTYLE_ERROR, QString("J2MEST not found. Possible phone is not supported"));
		return f1 ;
	}
	memcpy(&f1, fl, sizeof(P2kFile));
	strcpy(f1.name,"J2MEST");
	
	if (justCreate) return f1;
	
	phone->uploadFiles(&f1, 1, "/tmp/moto4lin/","/a/mobile/kjava/");
	
	return f1;
}

void frmJava::onRemove()
{
	if (!lstJava->selectedItem()) return;
	
	P2kFile flst[10];
	P2kFile * fl;
	int cnt=0;
	char s[256];
	int i;
		
	for (i=0; i<EXT_COUNT; i++)
	{
		sprintf(s,"/a/mobile/kjava/j2me%d.%s", lstJava->selectedItem()->text(0).toInt()-1, javaExt[i]);
		fl=fileByName(s, files, fileCount);
			if (fl)
				memcpy(&flst[cnt++], fl, sizeof(P2kFile));
	}
	lstJava->removeItem(lstJava->selectedItem());	

	fl=fileByName(JAVA_DB_NAME,files, fileCount);
	if (fl==0L)
	{
		qDebug("J2MEST not found");
		postLogMessage(phone, MSGSTYLE_ERROR, QString("J2MEST not found. Possible phone is not supported"));
		return;
	}
	memcpy(&flst[cnt++], fl, sizeof(P2kFile));
	updateRequested=TASK_DELETEFILES;
	phone->deleteFiles(flst, cnt);
}

int frmJava::freeNumber()
{
	char arr[31];
	int i;
	for (i=1; i<31; i++) arr[i]=0;
	arr[0]=1;
	
	QListViewItem * item = lstJava->firstChild();
	while (item)
	{
		arr[item->text(0).toInt()]=1;
		item=item->nextSibling();
	}
	for (i=1; i<31; i++)
	{
		if (!arr[i]) return i;
	}
	return -1;
}

void frmJava::onAdd()
{
	QString fn;
	
	P2kFile fl[5];
	int flCount=0;
	
	fn=QFileDialog::getOpenFileName(QString::null, "Java Midlets (*.jar)");
	if (fn.isNull()) return;
	UnZip zip(fn);
	zip.open();

	QString dir=fn.section('/',0,fn.contains('/')-1);
	QString localName=fn.section('/',-1,-1);
	
	QByteArray arr1;
	
	if (!zip.readFile("META-INF/MANIFEST.MF", &arr1))
	{
		qDebug("Error");
		return;
	}
	
	JavaManifest manifest(arr1, this, "Manifest");
	QString mName = manifest.getMidletName();
	QString mVendor = manifest.getMidletVendor();
	QString mVersion = manifest.getMidletVersion();
	QString mIcon = manifest.getMidletIcon();
	QString mCaption = manifest.getMidletCaption();
	QString mStartup = manifest.getStartupClass();
	if (mCaption.isNull()) mCaption=mName;
	
	if (mName.isNull() || mVendor.isNull() || mVersion.isNull() || mStartup.isNull())
	{
		QMessageBox::critical(this, "Invalid MIDlet", QString("MIDlet is invalid"), "Ok");
		return;
	}
	
	int number=freeNumber();

	if (number<0)
	{
		QMessageBox::critical(this, "Error", QString("No slots avaiable. Please remove some midlet before"), "Ok");
		return;
	}
	number--;

	QFile fp(fn);
	int size=fp.size();
	fp.open(IO_ReadOnly);
	QByteArray arr3=fp.readAll();
	fp.close();
	QFile fp_target(QString("/tmp/moto4lin/j2me%1.jar").arg(number));
	fp_target.open(IO_WriteOnly | IO_Truncate);
	fp_target.writeBlock(arr3.data(), arr3.size());
	fp_target.close();
	
	sprintf(fl[flCount].name, "j2me%d.jar", number);
	fl[flCount].attr=0x04;
	flCount++;
		
	QString ico1=(mIcon.isNull() || mIcon.length()==0)?"No": "Yes";
		
	if (ico1[0] == 'Y')
	{
		QByteArray arr2;
		if (mIcon[0]=='/')
			mIcon.remove(0,1);
		if (!zip.readFile(mIcon, &arr2))
			ico1="No";
		else
		{
			QFile fp(QString("/tmp/moto4lin/j2me%1.png").arg(number));
			fp.open(IO_WriteOnly | IO_Truncate);
			fp.writeBlock(arr2.data(), arr2.size());
			fp.close();
			
			checkIcon(number);
			
			sprintf(fl[flCount].name, "j2me%d.png", number);
			fl[flCount].attr=0x04;
			flCount++;
		}
	}
	
	// PAT file
	QFile patFile(PAT_FILE);
	patFile.open(IO_ReadOnly);
	QByteArray patData = patFile.readAll();
	patFile.close();
	patFile.setName(QString("/tmp/moto4lin/j2me%1.pat").arg(number));
	patFile.open(IO_WriteOnly | IO_Truncate);
	patFile.writeBlock(patData.data(), patData.size());
	patFile.close();	
	
	sprintf(fl[flCount].name, "j2me%d.pat", number);
	fl[flCount].attr=0x04;
	flCount++;
	
	
	new QListViewItem(lstJava, QString::number(number+1), mName, mVendor, mVersion, QString::number(size),
		ico1, mCaption, mStartup);
		
	fl[flCount++]=writeJ2MEST(TRUE);
	
	phone->uploadFiles(fl, flCount, "/tmp/moto4lin/","/a/mobile/kjava/");
	
	btnRemove->setEnabled(FALSE);
	btnSetPat->setEnabled(TRUE);
	btnSave->setEnabled(FALSE);
}

void frmJava::onSetPat()
{
	if (!lstJava->selectedItem()) return;
	int number = lstJava->selectedItem()->text(0).toInt()-1;
	QFile patFile(PAT_FULLFILE);
	patFile.open(IO_ReadOnly);
	QByteArray patData = patFile.readAll();
	patFile.close();
	patFile.setName(QString("/tmp/moto4lin/j2me%1.pat").arg(number));
	patFile.open(IO_WriteOnly | IO_Truncate);
	patFile.writeBlock(patData.data(), patData.size());
	patFile.close();	
	
	P2kFile pf;
	sprintf(pf.name, "j2me%d.pat", number);
	pf.attr=0x04;
	
	phone->uploadFiles(&pf, 1, "/tmp/moto4lin/", "/a/mobile/kjava/");
}

void frmJava::onSave()
{
	if (!lstJava->selectedItem()) return;
	QString fn=QFileDialog::getSaveFileName(lstJava->selectedItem()->text(1)+".jar");
	if (fn.isNull()) return;
	
	char s[256];
	sprintf(s,"/a/mobile/kjava/j2me%d.jar",lstJava->selectedItem()->text(0).toInt()-1);
	
	P2kFile * file = fileByName(s, files, fileCount);
	if (file==0)
	{
		QMessageBox::information(this, "Error","File not found","Ok");
		return;
	}
	phone->downloadFiles(file, 1, fn);	
}


