# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Fernando Casanova <fcasanova@fluendo.com>

"""
setuptools script for the plugin.
"""

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-lastfm',
    version='0.3',
    description='Last.FM services support',
    long_description='Last.FM album cover art resource provider for Moovida.',
    license='GPLv3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    entry_points="""\
    [elisa.core.components.resource_provider]
    LastFMResourceProvider = elisa.plugins.lastfm.resource_provider:LastFMResourceProvider
    """,
    cmdclass=cmdclass)
