#!/usr/bin/env python
#
# Test script for checking how TV show files are processed.
# by Paul van Tilburg <paul@luon.net>

import sys
from elisa.plugins.database.video_parser import VideoParser
from elisa.plugins.thetvdb.utils import *

if len(sys.argv) == 2:
  file = sys.argv[1]
else:
  print "Usage: %s [video file]"
  exit(1)

vp = VideoParser()
match = vp.try_tvshow_match(file)
if match:
    name, season, episode, remain = match.groups()
    cleaned_name = vp.clean_video_name(name)
    print "Found possible TV show '%s', season %s, episode %s" % (cleaned_name, season, episode)
    print "(Remaining cruft: %s)" % remain
else:
   cleaned_name = vp.clean_video_name(file)
   print "Found possible movie '%s'" % cleaned_name

# TODO: lookups, using SearchTVEpisodes/SearchMovies mixins?
