# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-coherence',
      version='0.3',
      description='UPnP related services',
      long_description='UPnP related services',
      license='GPLv3',
      author='Moovida Developers',
      author_email='elisa@lists.fluendo.com',
      keywords='',
      install_requires=['coherence>=0.5.7'],
      namespace_packages=['elisa', 'elisa.plugins'],
      packages=packages,
      package_dir=package_dir,
      cmdclass=cmdclass,
      entry_points="""
      [elisa.core.components.resource_provider]
      CoherenceResource = elisa.plugins.coherence.coherence_resource:CoherenceResource
      UpnpResource = elisa.plugins.coherence.upnp_resource:UpnpResource
      """)
