# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: datagraf.tcl,v 2.19 2001/02/04 11:32:23 jfontain Exp $}


class dataGraph {

    proc dataGraph {this parentPath args} composite {[new frame $parentPath] $args} blt2DViewer {
        $widget::($this,path) [blt::stripchart $widget::($this,path).graph\
            -title {} -topmargin 3 -bufferelements 0 -plotborderwidth 1 -plotbackground black\
        ] 5
    } {
        set path $widget::($this,path).graph
        $path pen create void -linewidth 0 -symbol none                                                       ;# pen for void values
        set graph [new bltGraph $path]
        pack $path -side left -fill both -expand 1
        set ($this,graph) $graph
        composite::complete $this
    }

    proc ~dataGraph {this} {
        delete $($this,graph)
        if {[string length $composite::($this,-deletecommand)]>0} {
            uplevel #0 $composite::($this,-deletecommand)                                   ;# always invoke command at global level
        }
    }

    proc iconData {} {
        return {
            R0lGODdhJAAkAKUAAPj8+Hh4eDBgIDBgGKDscJDcaIjQYHjAWDg4OHC0UGikSFiYQHh8eHBIAPDcSODQQNjEONC8MMiwMMCoKLicIAAAABBgeICEgKjU4JCY
            kLi8uIiQiJjI2IjA0NDY0KCkoIC4yKisqHCwwGikuMDEwFicsMjQyODk4Ojs6AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
            AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAJAAkAAAG/kCAcCgMEI/G4zBZVBKZSijy6VxWAVKqFRsICL7dsNgrGAjGAbMZLRQQ3gKs0v0mxId0eBNf
            6BfORF9+fl+Cg4BQAgaLi3cAioyRkoxnRklhAgeamoWbnJmem18IpGKBCaipqmAIX6tnCExZjwq1trWVAbFkYF0IWnMCC8PDlXtje8dovL1jDMvQVbthwFHV
            Sg3Z2VNVULMA2Q7i4g3X1ZdiDQ/r7OsNaNrv0F1EDRD3+PnbAdn65d5HGkQYOFAbwYICDxLctkVIAwkQIcrjF7GixYrllDWYwHFCA1Igs3XsGG+kx2lJGlBY
            +e7XE5UrKUzkF1OmpYDZfEWJF4DBzxKeN5HQcxkllk8iz3btqcC0qdOnUKNKZUDVglWqWLMysHpVK1cLWhlcuGABg1kLGdKqTVvWLAYLGuJqaHtW7NgLGzZY
            4MCXA1y5c/f25ft1sF8GefOy7cCYsQUPkC00nkx5MlgGaz9otgCic2eunkF8De25q+bTIVKHsCCitevXXa3CvsxAtWrAc0fo3q2btoaqXLHilkuiuHGrJZIn
            v2y8uNbm0EmYmE7dxNavVKtr374dsnfvYb+LH0/+hPnz6NOrX88ehfv38OPLn08/CAA7
        }
    }

    proc options {this} {
        set samples [expr {$global::graphNumberOfIntervals+1}]
        # force size and interval values
        return [list\
            [list -deletecommand {} {}]\
            [list -draggable 0 0]\
            [list -height $global::viewerHeight]\
            [list -interval 5]\
            [list -samples $samples $samples]\
            [list -width $global::viewerWidth]\
        ]
    }

    proc set-deletecommand {this value} {}

    foreach option {-height -width} {
        proc set$option {this value} "\$widget::(\$this,path) configure $option \$value"
    }

    proc set-draggable {this value} {
        if {$composite::($this,complete)} {
            error {option -draggable cannot be set dynamically}
        }
        if {$value} {
            blt2DViewer::allowDrag $this
        }
    }

    proc set-interval {this value} {
        bltGraph::setRange $($this,graph) [expr {($composite::($this,-samples)-1)*$value}]
        bltGraph::updateGraduations $($this,graph)
    }

    proc set-samples {this value} {                                                                     ;# stored at composite level
        if {$composite::($this,complete)} {
            error {option -samples cannot be set dynamically}
        }
        bltGraph::setRange $($this,graph) [expr {($value-1)*$composite::($this,-interval)}]
    }

    proc newElement {this path args} {                                                          ;# invoked from 2D viewer base class
        return [eval new element $path $composite::($this,-interval) $args]
    }

    proc updateTimeDisplay {this seconds} {
        bltGraph::xAxisUpdate $($this,graph) $seconds
    }

    proc updateElement {this element seconds value} {                           ;# value is either a valid number or the ? character
        element::update $element $seconds $value
    }

}


class dataGraph {

    class element {

        proc element {this path interval args} switched {$args} {                ;# interval is required to properly draw fist point
            variable x$this
            variable y$this
            variable weight$this

            set dots [expr {$global::graphNumberOfIntervals+1}]
            blt::vector create x${this}($dots)                                                                 ;# x axis data vector
            blt::vector create y${this}($dots)                                                                 ;# y axis data vector
            blt::vector create weight${this}($dots)                                                           ;# weights data vector
            # use object identifier as element identifier, and handle void values
            $path element create $this -label {} -symbol none -xdata x$this -ydata y$this -weight weight$this -styles {{void 0 0}}
            set ($this,path) $path
            set ($this,interval) $interval
            switched::complete $this
        }

        proc ~element {this} {
            variable x$this
            variable y$this
            variable weight$this

            blt::vector destroy x$this y$this weight$this
            $($this,path) element delete $this
            if {[string length $switched::($this,-deletecommand)]>0} {
                uplevel #0 $switched::($this,-deletecommand)                                ;# always invoke command at global level
            }
        }

        proc options {this} {
            return [list\
                [list -color black black]\
                [list -deletecommand {} {}]\
            ]
        }

        proc set-color {this value} {
            $($this,path) element configure $this -color $value
        }

        proc set-deletecommand {this value} {}                                                   ;# data is stored at switched level

        proc update {this x y} {                                                    ;# y is either a valid number or the ? character
            variable x$this
            variable y$this
            variable weight$this

            if {[set x${this}(end)]==0} {                                                                            ;# first update
                if {[string equal $y ?]} return                                              ;# do nothing till we get a valid value
                # make an horizontal line as short as possible so that first point is visible
                set x${this}(end) [expr {$x-$($this,interval)}]
                set y${this}(end) $y
                unset ($this,interval)                                                                           ;# free some memory
            }
            x$this delete 0                                                           ;# achieve scrolling by deleting first element
            y$this delete 0
            weight$this delete 0
            x$this append $x                                                                              ;# and appending new value
            if {[string equal $y ?]} {                                                                             ;# void new value
                y$this append [set y${this}(end)]                                                         ;# append last known value
                weight$this append 0                                                                  ;# and display with void style
            } else {                                                                                              ;# valid new value
                y$this append $y
                weight$this append 1                                                                                 ;# normal style
            }
        }

    }

}
