/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeAction
extends AbstractSelectedAction {
    protected Map<AttributeKey, Object> attributes;

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object) {
        this(drawingEditor, attributeKey, object, null, null);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, Icon icon) {
        this(drawingEditor, attributeKey, object, null, icon);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string) {
        this(drawingEditor, attributeKey, object, string, null);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string, Icon icon) {
        this(drawingEditor, attributeKey, object, string, icon, null);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string, Icon icon, Action action) {
        super(drawingEditor);
        this.attributes = new HashMap<AttributeKey, Object>();
        this.attributes.put(attributeKey, object);
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.putValue("undoPresentationName", attributeKey.getPresentationName());
        this.setEnabled(true);
    }

    public AttributeAction(DrawingEditor drawingEditor, Map<AttributeKey, Object> hashMap, String string, Icon icon) {
        super(drawingEditor);
        this.attributes = hashMap == null ? new HashMap() : hashMap;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.applyAttributesTo(this.attributes, this.getView().getSelectedFigures());
    }

    public void applyAttributesTo(final Map<AttributeKey, Object> map, Set<Figure> set) {
        for (Map.Entry<AttributeKey, Object> object2 : map.entrySet()) {
            this.getEditor().setDefaultAttribute(object2.getKey(), object2.getValue());
        }
        final ArrayList<Figure> arrayList = new ArrayList<Figure>(set);
        final ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Figure figure = (Figure)object.next();
            arrayList2.add(figure.getAttributesRestoreData());
            figure.willChange();
            for (Map.Entry<AttributeKey, Object> entry : map.entrySet()) {
                figure.set(entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        object = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                String string = (String)AttributeAction.this.getValue("undoPresentationName");
                if (string == null) {
                    string = (String)AttributeAction.this.getValue("Name");
                }
                if (string == null) {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    string = resourceBundleUtil.getString("attribute.text");
                }
                return string;
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iterator = arrayList2.iterator();
                for (Figure figure : arrayList) {
                    figure.willChange();
                    figure.restoreAttributesTo(iterator.next());
                    figure.changed();
                }
            }

            @Override
            public void redo() {
                super.redo();
                for (Figure figure : arrayList) {
                    arrayList2.add(figure.getAttributesRestoreData());
                    figure.willChange();
                    for (Map.Entry entry : map.entrySet()) {
                        figure.set((AttributeKey)entry.getKey(), entry.getValue());
                    }
                    figure.changed();
                }
            }
        };
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)object);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getEditor() != null) {
            this.setEnabled(this.getEditor().isEnabled());
        }
    }
}

