/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: parse.c,v 1.8 2003/05/17 18:53:52 miham Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "config.h"
#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"


#ifdef HAVE_FLOWTOOLS
#include "ftlib.h"

typedef union {
	struct fts3rec_v1 v1;
	struct fts3rec_v5 v5;
	struct fts3rec_v6 v6;
	struct fts3rec_v7 v7;
	struct fts3rec_v8_1 v8_1;
	struct fts3rec_v8_2 v8_2;
	struct fts3rec_v8_3 v8_3;
	struct fts3rec_v8_4 v8_4;
	struct fts3rec_v8_5 v8_5;
	struct fts3rec_gen gen;
} ftrecord;

int parse_record(mconfig *ext_conf, mlogrec *record, ftrecord *buf) {
	config_input *conf = ext_conf->plugin_conf;
	mlogrec_traffic *rectrf = NULL;
	mlogrec_traffic_flow *recflw = NULL;

	record->ext_type = M_RECORD_TYPE_TRAFFIC;
	record->ext = mrecord_init_traffic();

	rectrf = record->ext;

	if (rectrf == NULL) return -1;

	rectrf->ext = mrecord_init_traffic_flow();
	rectrf->ext_type = M_RECORD_TYPE_TRAFFIC_FLOW;

	recflw = rectrf->ext;

	if (recflw == NULL) return -1;

	record->timestamp = buf->gen.unix_secs;
	rectrf->src = malloc(16);
	sprintf(rectrf->src, "%d.%d.%d.%d",
		(buf->gen.srcaddr >> 24) & 0xff,
		(buf->gen.srcaddr >> 16) & 0xff,
		(buf->gen.srcaddr >>  8) & 0xff,
		(buf->gen.srcaddr >>  0) & 0xff
		);
	rectrf->dst = malloc(16);
	sprintf(rectrf->dst, "%d.%d.%d.%d",
		(buf->gen.dstaddr >> 24) & 0xff,
		(buf->gen.dstaddr >> 16) & 0xff,
		(buf->gen.dstaddr >>  8) & 0xff,
		(buf->gen.dstaddr >>  0) & 0xff
		);
	recflw->protocol =  buf->gen.prot;
	recflw->src_port = buf->gen.srcport;
	recflw->dst_port = buf->gen.dstport;
	rectrf->xfer_incoming = buf->gen.dOctets;
	recflw->packets = buf->gen.dPkts;
	recflw->src_as = buf->v5.src_as;
	recflw->dst_as = buf->v5.dst_as;

	recflw->src_interface = buf->v5.input;
	recflw->dst_interface = buf->v5.output;

	return 0;
}

#endif
int mplugins_input_flowraw_get_next_record(mconfig *ext_conf, mlogrec *record) {
	int ret = 0;
#ifdef HAVE_FLOWTOOLS
	config_input *conf = ext_conf->plugin_conf;
	void *rec;

	if ((rec = ftio_read(&(conf->ftio)))) {
		ret = parse_record(ext_conf, record, rec);
		/* free(rec); */
	} else {
		ret = M_RECORD_EOF;
	}
#else
	ret = M_RECORD_EOF;
#endif

	return ret;
}
