#ifndef _STRUCTS_H
#  define _STRUCTS_H

typedef struct ml_flags
{
  int verbose;          /* verbose flag */
  int quiet;            /* quiet flag */
  int guess;            /* guess flag */
  int widescreen;       /* widescreen flag */
  int warn;             /* initial warning flag */
  int gotmem;           /* flag set when memory first read */
  int doublescan;       /* doublescan flag */
  int interlaced;       /* interlaced flag */
} ml_flags;

typedef struct ml_params
{
  double fp;            /* front porch */
  double bp;            /* back porch */
  double sw;            /* sync width */
  double sw_min;        /* minimum sync width */
  double sw_max;        /* maximum sync width */
} ml_params;

typedef struct ml_sess
{
  ml_params h;          /* horizontal params */
  ml_params v;          /* vertical params */
  ml_flags flags;       /* flag structure */
  
  double max_dot;       /* maximum dot clock */
  
  int aspect_x;         /* horizontal part of the aspect ratio */
  int aspect_y;         /* vertical part of the aspect ratio */
  int output;           /* output type (1 = XFree86, 2 = Framebuffer, 3 = MatroxFB) */
  
  unsigned int Memory;  /* amount of memory on the Video adapter (in bytes) */
  
  int width;            /* screen width (in pixels) */
  int heigth;           /* screen heigth (in pixels) */
  int refresh;          /* refreshrate (in Hz) */
  int depth;            /* colordepth (in bits, for framebuffer output) */
  
  char *File;           /* config file */
} ml_sess;

extern ml_sess ml;

#endif
