#include "udm_config.h"

#ifdef HAVE_SQL

/*
#define DEBUG_SEARCH
*/

/*
#define DEBUG_SQL
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#if (WIN32|WINNT)
#include <time.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#include "udm_utils.h"
#include "udm_common.h"
#include "udm_spell.h"
#include "udm_robots.h"
#include "udm_mutex.h"
#include "udm_db.h"
#include "udm_charset.h"
#include "udm_parseurl.h"
#include "udm_log.h"
#include "udm_proto.h"
#include "udm_conf.h"
#include "udm_crc32.h"
#include "udm_xmalloc.h"
#include "udm_cache.h"
#include "udm_indexer.h"
#include "udm_boolean.h"
#include "udm_searchtool.h"
#include "udm_server.h"
#include "udm_stopwords.h"


#if (HAVE_MYSQL)
#include "mysql.h"
#define DBVER "MySQL"
#define DB_DEFAULT	"mysql"
#define HAVE_SQL_LIMIT
#define HAVE_SQL_IN
#elif (HAVE_PGSQL)
#include "libpq-fe.h"
#define DBVER "PgSQL"
#define DB_DEFAULT	"pgsql"
#define HAVE_SQL_LIMIT
#define HAVE_SQL_IN
#elif HAVE_MSQL
#define DBVER "mSQL"
#define DB_DEFAULT	"msql"
#include "msql.h"
#elif HAVE_IODBC
#define DBVER "iODBC"
#define DB_DEFAULT	""
#include "iodbc.h"
#include "isql.h"
#include "isqlext.h"
#elif HAVE_EASYSOFT
#define DBVER "EasySoft"
#define DB_DEFAULT	""
#include "sql.h"
#include "sqlext.h"
#elif HAVE_VIRT
#define DBVER "Virtuoso"
#define DB_DEFAULT	"virt"
#include "iodbc.h"
#include "isql.h"
#include "isqlext.h"
#elif HAVE_UNIXODBC
#define DBVER "unixODBC"
#define DB_DEFAULT	""
#include "sql.h"
#include "sqlext.h"
#elif HAVE_SAPDB
#define DBVER "SAPDB"
#define DB_DEFAULT	"sapdb"
#include "WINDOWS.H"
#include "sql.h"
#include "sqlext.h"
#elif HAVE_SOLID
#define DBVER "Solid"
#define DB_DEFAULT	"solid"
#include "cli0cli.h"
#elif HAVE_IBASE
#include "ibase.h"
#define DBVER "InterBase"
#define DB_DEFAULT	"ibase"
#elif HAVE_ORACLE8
#include "oci.h"
#define DBVER "Oracle8"
#define DB_DEFAULT	"oracle"
#define HAVE_SQL_IN
#elif HAVE_ORACLE7
#include "ocidfn.h"
#include "oratypes.h"
#define HAVE_SQL_IN
#ifdef __STDC__
#include <ociapr.h>
#else
#include <ocikpr.h>
#endif
#define DBVER "Oracle7"
#define DB_DEFAULT	"oracle"
#define HAVE_SQL_IN
#else
#define DBVER ""
#define DB_DEFAULT	""
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif


/* Multi-dict mode defines */
#define NDICTS	18
#define MINDICT	2
#define MAXDICT	NDICTS
static const int dictlen[NDICTS]={2,2,2,3,4,5,6,7,8,9,10,11,12,16,16,16,16,32};
#define	DICTNUM(l)	((l>16)?dictlen[17]:dictlen[l])

#define	URL_DELETE_CACHE 128
#define	URL_SELECT_CACHE 250
#define URL_LOCK_TIME    4*60*60

#define NDOCS_QUERY "SELECT count(*) FROM url"

static const int search_cache_size=1000;
static const char udmver[]= PACKAGE "-" VERSION "/" DBVER;
static char emptystr[]="";


__INDLIB__ const char * UdmVersion(void){
	return(udmver);
}

static time_t now(void){ /* FIXME !!! is it reentrant? */
time_t tloc;
	return(time(&tloc));
}

char * UdmDBEscStr(int DBType,char *x,const char *y){
char *s;
#ifdef HAVE_MYSQL
	if(DBType==UDM_DB_MYSQL){
		mysql_escape_string(x,y,strlen(y));
		return(x);
	}
#endif
	s=x;
	if (DBType == UDM_DB_ORACLE || DBType == UDM_DB_ORACLE8  ||
	    DBType == UDM_DB_MSSQL || DBType == UDM_DB_ORACLE7 || 
	    DBType == UDM_DB_IBASE || DBType == UDM_DB_SAPDB)
	 {
	    while(*y){
		switch(*y){
			case '\'':
				/* Note that no break here!*/
				*x=*y;x++;
			default:
				*x=*y;
		}
		x++;y++;
	    }
	} else {
	    while(*y){
		switch(*y){
			case '\'':
			case '\\':
				*x='\\';x++;
			default:*x=*y;
		}
		x++;y++;
	    }
	}
	*x=0;return(s);
}


/************************ MYSQL **************************************/
#if   (HAVE_MYSQL)
#define ER_DUP_ENTRY            1062
#define ER_DUP_KEY		1022
#define CR_SERVER_LOST          2013
#define CR_SERVER_GONE_ERROR    2006
#define ER_SERVER_SHUTDOWN      1053
typedef struct struct_db {
	MYSQL mysql;
	MYSQL_RES *res;
	MYSQL_RES *res1;
	int connected;
	int res_limit;
	int commit_fl;
	int errcode;
	char errstr[UDMSTRSIZ];
} DB;
typedef MYSQL_RES UDB_RES;
#define SQL_NUM_ROWS(x)	mysql_num_rows(x)
#define SQL_FREE(x)	mysql_free_result(x)

static int InitDB(UDM_AGENT * Indexer){
	DB * db;
	db=(DB*)Indexer->db;

	if (!mysql_init(&(db->mysql))) {
	  db->errcode = 1;
	  return 1;
	}
	if(!(mysql_real_connect(&(db->mysql),Indexer->Conf->DBHost,Indexer->Conf->DBUser,Indexer->Conf->DBPass,Indexer->Conf->DBName?Indexer->Conf->DBName:"mnogosearch",(unsigned)Indexer->Conf->DBPort,NULL,0))){
		db->errcode=1;
		mysql_close(&(db->mysql));
		return(1);
	}
	db->connected=1;
	return(0);
}
static char * sql_value(MYSQL_RES *res,int i,int j){
	MYSQL_ROW row;
	if(i>=mysql_num_rows(res))return(0);		
	mysql_data_seek(res,(my_ulonglong)i);
	row=mysql_fetch_row(res);
	if(row)return(row[j]?row[j]:emptystr);
	else	return(0);
}
static void CloseDB(DB *db){
	if(db->connected)mysql_close(&(db->mysql));
	db->connected=0;
}
static void displayError(DB * db){
	sprintf(db->errstr,"#%d: %s",
		mysql_errno(&((DB*)db)->mysql),
		mysql_error(&((DB*)db)->mysql));
}
static int safe_mysql_query(UDM_AGENT * Indexer,const char *query){
int err,i;
DB * db;
	db=(DB*)Indexer->db;
	if(!db->connected){
		InitDB(Indexer);
		if(db->errcode)
			return(db->errcode);
	}
	for(i=0;i<2;i++){
		if((err=mysql_query(&db->mysql,query))){
			if((mysql_errno(&db->mysql)==CR_SERVER_LOST)||
			(mysql_errno(&db->mysql)==CR_SERVER_GONE_ERROR)||
			(mysql_errno(&db->mysql)==ER_SERVER_SHUTDOWN)){
				UDMSLEEP(5);
			}else
				return(err);
		}else
			return(err);
	}
	return(err);
}
static MYSQL_RES * sql_query(UDM_AGENT * Indexer,const char *query){
int res;
DB *db;
#ifdef DEBUG_SQL
unsigned long ticks;
	ticks=UdmStartTimer();
#endif

	db=(DB*)Indexer->db;
	db->errcode=0;
	res=safe_mysql_query(Indexer,query);
#ifdef DEBUG_SQL
	ticks=UdmStartTimer()-ticks;
	fprintf(stderr,"[%d] SQL %.2fs: %s\n",getpid(),(float)ticks/1000,query);
#endif
	if(res){
		displayError(db);
		if((mysql_errno(&(db->mysql))!=ER_DUP_ENTRY) &&
			(mysql_errno(&(db->mysql))!=ER_DUP_KEY)){
			db->errcode=1;
		}
		return(0);
	}
	return(mysql_store_result(&db->mysql));
}
/*********************************** POSTGRESQL *********************/
#elif (HAVE_PGSQL)
typedef struct struct_db {
	PGconn     *pgsql;
	PGresult   *res;
	PGresult   *res1;
	int res_limit;
	int commit_fl;
	int connected;
	int errcode;
	char errstr[UDMSTRSIZ];
} DB;
typedef PGresult UDB_RES;
#define SQL_NUM_ROWS(x)	PQntuples(x)
#define SQL_FREE(x)	PQclear(x)
#define sql_value(x,y,z) PQgetvalue(x,y,z)

static int InitDB(UDM_AGENT * Indexer){
char port[8];
DB * db;
	db=(DB*)Indexer->db;
	sprintf(port,"%d",Indexer->Conf->DBPort);
	db->pgsql = PQsetdbLogin(Indexer->Conf->DBHost, Indexer->Conf->DBPort?port:0, 0, 0, Indexer->Conf->DBName, Indexer->Conf->DBUser, Indexer->Conf->DBPass);
	if (PQstatus(db->pgsql) == CONNECTION_BAD){
		db->errcode=1;
		return(1);
	}
	db->connected=1;
	return(0);
}
static void CloseDB(DB *db){
	if(db->connected)PQfinish(db->pgsql);
	db->connected=0;
}
static void displayError(DB * db){
	sprintf(db->errstr, "%s", PQerrorMessage(db->pgsql));
}
static PGresult * safe_pgsql_query(UDM_AGENT * Indexer, const char *q){
DB * db;
	db=(DB*)Indexer->db;
	if(!(db->connected)){
		InitDB(Indexer);
		if(db->errcode)return(0);
	}
	return(PQexec(db->pgsql,q));
}
static PGresult * sql_query(UDM_AGENT * Indexer, const char *q){
PGresult * res;
DB * db;
#ifdef DEBUG_SQL
unsigned long ticks;
	ticks=UdmStartTimer();
#endif

	db=(DB*)Indexer->db;
	db->errcode=0;
	res=safe_pgsql_query(Indexer,q);
	if(!res){
		displayError(db);
		((DB*)db)->errcode=1;
		return(0);
	}
	if(PQresultStatus(res)==PGRES_COMMAND_OK){
		/* Free non-SELECT query */
		PQclear(res);
	}
	if((PQresultStatus(res)!=PGRES_COMMAND_OK)&&(PQresultStatus(res)!=PGRES_TUPLES_OK)){
		displayError(db);
		if(!strstr(PQerrorMessage(((DB*)db)->pgsql),"duplicate"))
			((DB*)db)->errcode=1;
		PQclear(res);
		return(0);
	}
#ifdef DEBUG_SQL
	ticks=UdmStartTimer()-ticks;
	fprintf(stderr,"[%d] SQL %.2fs: %s\n",getpid(),(float)ticks/1000,q);
#endif
	return(res);
}
/*****************************  miniSQL *******************************/
#elif (HAVE_MSQL)
typedef struct struct_db {
	int		msql;
	m_result	*res;
	int res_limit;
	int commit_fl;
	int connected;
	int errcode;
	char errstr[UDMSTRSIZ];
} DB;
typedef m_result UDB_RES;
#define SQL_NUM_ROWS(x)	msqlNumRows((x))
#define SQL_FREE(x)	msqlFreeResult((x))

static char * sql_value(m_result *res,int i,int j){
m_row row;

	if(i>=msqlNumRows(res))return(NULL);
	msqlDataSeek(res,i);
	row=msqlFetchRow(res);
	if(row)return(row[j]?row[j]:emptystr);
	else	return(0);
}
static int InitDB(UDM_AGENT * Indexer){
char *host;
DB * db;
	db=(DB*)Indexer->db;
	if((host=Indexer->Conf->DBHost))
		if(!strcmp(Indexer->Conf->DBHost,"localhost"))
			host=NULL;
	if((db->msql=msqlConnect(host))<0){
		db->errcode=1;
		return(1);
	}
	if(msqlSelectDB(db->msql,Indexer->Conf->DBName)==-1){
		db->errcode=1;
		return(1);
	}
	db->connected=1;
	return(0);
}
static void CloseDB(DB *db){
	if(db->connected)msqlClose(db->msql);
	db->connected=0;
}
static void displayError(DB *db){
	sprintf(db->errstr,"%s",msqlErrMsg);
}
static int safe_msql_query(UDM_AGENT * Indexer,const char *query){
int err;
DB * db;
	db=(DB*)Indexer->db;
	if(!(db->connected)){
		InitDB(Indexer);
		if(db->errcode)
			return(db->errcode);
	}
	if((err=msqlQuery(db->msql,query))==-1){
		if(!strstr(msqlErrMsg,"Non unique")){
			db->errcode=1;
			return(err);
		}
		return(0);
	}
	return(0);
}
static m_result * sql_query(UDM_AGENT * Indexer,const char *query){
int err;
DB * db;
	db=(DB*)Indexer->db;
	db->errcode=0;
	if((err=safe_msql_query(Indexer,query))){
		displayError(db);
		return(0);
	}
	return(msqlStoreResult());
}
/************************** ODBC ***********************************/
#elif (HAVE_IODBC || HAVE_UNIXODBC || HAVE_SOLID || HAVE_VIRT || HAVE_EASYSOFT || HAVE_SAPDB)
typedef struct or_struct{
	int nRows;
	int nCols;
	int freeme;
	char **items;
} iODBC_RES;
typedef iODBC_RES UDB_RES;
typedef struct struct_db {
	HDBC	hDbc;
	HENV	hEnv;
	HSTMT	hstmt;
	iODBC_RES * res;
	int res_limit;
	int commit_fl;
	int connected;
	int errcode;
	char errstr[UDMSTRSIZ];
} DB;

#define SQL_NUM_ROWS(x)	((x)?(x)->nRows:0)
#define SQL_FREE(x)	iodbc_free_result((x))
#define sql_val(x,y,z)	((x)->items[y*x->nCols+z])
#define sql_value(x,y,z) ((x)?(sql_val((x),y,z)?sql_val((x),y,z):""):"")
#define SQL_OK(rc)	((rc==SQL_SUCCESS)||(rc==SQL_SUCCESS_WITH_INFO))

static int iodbc_free_result(iODBC_RES *res){
int i;
	if(res){
		if(res->freeme){
			if(res->items){
				for(i=0;i<res->nCols*res->nRows;i++)
					if(res->items[i])
						free(res->items[i]);
				free(res->items);
			}
			free(res);
		}
	}
	return(0);
}
static int displayError(DB * db){
	UCHAR szSqlState[6];
	UCHAR szErrMsg[256];
	SDWORD naterr;
	SWORD length;
	
	db->errstr[0]=0;
	while (SQL_SUCCESS == SQLError(db->hEnv,db->hDbc,db->hstmt,szSqlState,&naterr,szErrMsg,sizeof(szErrMsg),&length))
		strcat(db->errstr, szErrMsg);
	return(0);
}
static iODBC_RES * execDB(DB*db,char* sqlstr){
	RETCODE rc;
	SWORD iResColumns;
	SDWORD iRowCount;
	int i,res_count;
	char* p;
	UCHAR szColName[32];
	SWORD pcbColName;
	SWORD pfSQLType;
	UDWORD pcbColDef;
	SWORD pibScale;
	SWORD pfNullable;
	iODBC_RES *result;
	SDWORD	pcbValue;
	static char	bindbuf[(int)(32L * 1024L - 16L)];

	/* -------- 
	p=sqlstr;
	while(*p){
		if(*p=='?')*p='.';
		p++;
	}
	*/

	rc=SQLAllocStmt(db->hDbc, &(db->hstmt));
	if (!SQL_OK(rc)){
		db->errcode=1;
		return(NULL);
	}
	rc=SQLExecDirect(db->hstmt,(UCHAR*)sqlstr, SQL_NTS);
	if (!SQL_OK(rc)){
		db->errcode=1;
		return(NULL); 
	}
	rc=SQLNumResultCols(db->hstmt, &iResColumns);
	if(!SQL_OK(rc)){
		db->errcode=1;
		return(NULL);
	}
	if(!iResColumns) {
		rc=SQLRowCount(db->hstmt, &iRowCount);
		if (!SQL_OK(rc)){
			db->errcode=1;
			return(NULL);
		}
		result=NULL;
	}else{
		result=(iODBC_RES*)UdmXmalloc(sizeof(iODBC_RES));
		result->nRows = 0;
		result->nCols = iResColumns;
		result->items=NULL;
		result->freeme=1;

		rc = SQL_NO_DATA_FOUND;
		for (res_count=0;(db->res_limit?(res_count<db->res_limit):1);res_count++){
			rc=SQLFetch(db->hstmt);
			if (!SQL_OK(rc)) {
				if (rc!=SQL_NO_DATA_FOUND){
					db->errcode=1;
				}
				break;
			}
			if(!result->nRows){
				result->items=(char **)UdmXmalloc(1*iResColumns*sizeof(char*));
			}else{
				result->items=(char **)UdmXrealloc(result->items,((result->nRows+1)*iResColumns*sizeof(char*)));
			}
			for (i = 0; i < iResColumns; i++) {
				SQLDescribeCol(db->hstmt, i+1, szColName, sizeof(szColName),
					&pcbColName, &pfSQLType, &pcbColDef,&pibScale, &pfNullable);
				SQLGetData(db->hstmt,i+1,SQL_C_CHAR,bindbuf,sizeof(bindbuf),&pcbValue);
				if (pcbValue==SQL_NULL_DATA) p = NULL;
				else p = bindbuf;
				if(p)UdmRTrim(p," ");
				sql_val(result,result->nRows,i)=strdup(p?p:"");
			}
			result->nRows++;
		}
	}
	db->res_limit=0;
	SQLFreeStmt(db->hstmt, SQL_DROP);
	db->errcode=0;
	return(result);
}
static int InitDB(UDM_AGENT * Indexer){
char DSN[UDMSTRSIZ]="";
DB * db;
	db=(DB*)Indexer->db;
#if (HAVE_SOLID)
	sprintf(DSN,"tcp %s %d",Indexer->Conf->DBHost?Indexer->Conf->DBHost:"localhost",Indexer->Conf->DBPort?Indexer->Conf->DBPort:1313);
#elif (HAVE_SAPDB)
	sprintf(DSN,"%s:%s",Indexer->Conf->DBHost?Indexer->Conf->DBHost:"localhost",Indexer->Conf->DBName?Indexer->Conf->DBName:"");
#else
	strcpy(DSN,Indexer->Conf->DBName?Indexer->Conf->DBName:"");
#endif
	db->errcode = SQLAllocEnv( &(db->hEnv) );
	if( SQL_SUCCESS != db->errcode )return -2;
	db->errcode = SQLAllocConnect( db->hEnv, &(db->hDbc) );
	if( SQL_SUCCESS != db->errcode )return -3;
	db->errcode = SQLSetConnectOption( db->hDbc, SQL_AUTOCOMMIT, SQL_AUTOCOMMIT_ON);
	if( SQL_SUCCESS != db->errcode )return -4;
	db->errcode = SQLConnect( db->hDbc, DSN, SQL_NTS, Indexer->Conf->DBUser, SQL_NTS, Indexer->Conf->DBPass, SQL_NTS);
	if( !SQL_OK(db->errcode)) return(-5);
	else db->errcode=0;
	db->connected=1;
	return 0;
}
static void CloseDB(DB * db){
	if(db->connected){
		db->connected=0;
		db->errcode = SQLTransact( db->hEnv, db->hDbc, SQL_COMMIT);
		if( SQL_SUCCESS != db->errcode )return;
		db->errcode = SQLDisconnect( db->hDbc );
		if( SQL_SUCCESS != db->errcode )return;
		db->errcode = SQLFreeConnect( db->hDbc );
		if( SQL_SUCCESS != db->errcode )return;
		else	db->hDbc = SQL_NULL_HDBC;
		db->errcode = SQLFreeEnv( db->hEnv );
		if( SQL_SUCCESS != db->errcode )return;
		else	db->hEnv = SQL_NULL_HENV;
	}
}
static iODBC_RES * sql_query(UDM_AGENT * Indexer,char *qbuf){
	iODBC_RES * res;
	DB * db=(DB*)Indexer->db;

	if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_LOCK,UDM_LOCK_QUERY);
	if(!db->connected){
		InitDB(Indexer);
		if(db->errcode){
			displayError(db);
			if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_UNLOCK,UDM_LOCK_QUERY);
			return(0);
		}else{
			db->connected=1;
		}
	}
	res=execDB(db,qbuf);
	if((db->errcode)){
		displayError(db);
		if(strstr(db->errstr,"uplicat")){ /* PgSQL,MySQL*/
			db->errcode=0;
		}else
		if(strstr(db->errstr,"nique")){ /* Solid, Virtuoso */
			db->errcode=0;
		}else{
			db->errcode=1;
			res=NULL;
		}
		SQLFreeStmt(db->hstmt, SQL_DROP);
	}
	if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_UNLOCK,UDM_LOCK_QUERY);
	return(res);
}
#elif HAVE_IBASE

typedef struct or_struct{
	int nRows;
	int nCols;
	int freeme;
	char **items;
} iBASE_RES;
typedef iBASE_RES UDB_RES;

#define SQL_NUM_ROWS(x)	((x)->nRows)
#define SQL_FREE(x)	ibase_free_result((x))
#define sql_val(x,y,z)	((x)->items[y*(x)->nCols+z])
#define sql_value(x,y,z) sql_val((x),y,z)?sql_val((x),y,z):""

#define SQL_VARCHAR(len) struct {short vary_length; char vary_string[(len)+1];}
typedef struct ibase_db {
	int		connected;
	int		errcode;
	isc_db_handle	DBH;		/* database handle */
	ISC_STATUS	status[20];	/* status vector */
	char		errstr[UDMSTRSIZ]; /* error buffer */
	UDB_RES		* res;
	int		res_limit;
	int		commit_fl;
} DB;

static void displayError(DB * db){
char *s;
ISC_STATUS * stat;
	stat=(db->status);
	s=db->errstr;
	while(isc_interprete(s ,&stat)){
		strcat(db->errstr," ");
		s=db->errstr+strlen(db->errstr);
	}
}

static int ibase_free_result(iBASE_RES *res){
int i;
	if(res){
		if(res->freeme){
			if(res->items){
				for(i=0;i<res->nCols*res->nRows;i++)
					if(res->items[i])
						free(res->items[i]);
				free(res->items);
			}
			free(res);
		}
	}
	return(0);
}
static int InitDB(UDM_AGENT * Indexer){
	DB * db;	
	char dpb_buffer[256], *dpb, *p;
	int dpb_length, len;

	db=(DB*)(Indexer->db);

	dpb = dpb_buffer;
	*dpb++ = isc_dpb_version1;

	if (Indexer->Conf->DBUser != NULL && (len = strlen(Indexer->Conf->DBUser))) {
		*dpb++ = isc_dpb_user_name;
		*dpb++ = len;
		for (p = Indexer->Conf->DBUser; *p;) {
			*dpb++ = *p++;
		}
	}

	if (Indexer->Conf->DBPass != NULL && (len = strlen(Indexer->Conf->DBPass))) {
		*dpb++ = isc_dpb_password;
		*dpb++ = strlen(Indexer->Conf->DBPass);
		for (p = Indexer->Conf->DBPass; *p;) {
			*dpb++ = *p++;
		}
	}
	/*
	if (charset != NULL && (len = strlen(charset))) {
		*dpb++ = isc_dpb_lc_ctype;
		*dpb++ = strlen(charset);
		for (p = charset; *p;) {
			*dpb++ = *p++;
		}
	}
#ifdef isc_dpb_sql_role_name
	if (role != NULL && (len = strlen(role))) {
		*dpb++ = isc_dpb_sql_role_name;
		*dpb++ = strlen(role);
		for (p = role; *p;) {
			*dpb++ = *p++;
		}
	}
#endif
	*/

	dpb_length = dpb - dpb_buffer;

	if(isc_attach_database(db->status, strlen(Indexer->Conf->DBName), Indexer->Conf->DBName, &(db->DBH), dpb_length, dpb_buffer)){
		db->errcode=1;
		return(1);
	}
	return(0);
}
static void CloseDB(DB*db){
	if(db->connected){
		if (isc_detach_database(db->status, &(db->DBH))){
			db->errcode=1;
		}
	}
}
static iBASE_RES empty_res;
static iBASE_RES * sql_ibase_query(UDM_AGENT * Indexer, char *query){
	DB * db;
	iBASE_RES *result=NULL;

	char query_info[] = { isc_info_sql_stmt_type };
	char info_buffer[18];
	long query_type;
	isc_tr_handle tr_handle = NULL;
	isc_stmt_handle query_handle = NULL;
	ISC_STATUS	status[20];
	db=(DB*)(Indexer->db);
	if(!db->connected){
		InitDB(Indexer);
		if(db->errcode){
			displayError(db);
			db->errcode=1;
			return NULL;
		}else{
			db->connected=1;
		}
	}
	if (isc_start_transaction(db->status, &tr_handle, 1, &(db->DBH), 0, NULL)){
		db->errcode=1;
		return(0);
	}
	if (isc_dsql_allocate_statement(db->status, &(db->DBH), &query_handle)){
		db->errcode=1; 
		return(0);
	}
	if (isc_dsql_prepare(db->status, &tr_handle, &query_handle, 0, query, 1, NULL)){
		db->errcode=1; 
		return(0);
	}
	if (!isc_dsql_sql_info(db->status, &query_handle, sizeof(query_info), query_info, sizeof(info_buffer), info_buffer)) {
		short l;
		l = (short) isc_vax_integer((char ISC_FAR *) info_buffer + 1, 2);
		query_type = isc_vax_integer((char ISC_FAR *) info_buffer + 3, l);
	}

	/* Find out what kind of query is to be executed */
	if (query_type == isc_info_sql_stmt_select || query_type == isc_info_sql_stmt_select_for_upd) {
		XSQLDA *osqlda=NULL;
		long fetch_stat;
		int i;
		
		/*
		 * Select, need to allocate output sqlda and and prepare it for use.
		 */
		osqlda = (XSQLDA *) UdmXmalloc(XSQLDA_LENGTH(0));
		osqlda->sqln = 0;
		osqlda->version = SQLDA_VERSION1;

		if (isc_dsql_describe(db->status, &query_handle, 1, osqlda)) {
			free(osqlda);
			db->errcode=1;
			isc_rollback_transaction(status, &tr_handle);
			return NULL;
		}

		if (osqlda->sqld) {
			osqlda = (XSQLDA *) UdmXrealloc(osqlda, XSQLDA_LENGTH(osqlda->sqld));
			osqlda->sqln = osqlda->sqld;
			osqlda->version = SQLDA_VERSION1;
			if (isc_dsql_describe(db->status, &query_handle, 1, osqlda)) {
				free(osqlda);
				db->errcode=1;
				isc_rollback_transaction(status, &tr_handle);
				return NULL;
			}
		}
		for (i = 0; i < osqlda->sqld; i++) {
			int coltype;
			
			osqlda->sqlvar[i].sqlind = (short *) UdmXmalloc(sizeof(short));
			coltype = osqlda->sqlvar[i].sqltype & ~1;
			switch(coltype)
				{
				case SQL_TEXT:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(char)*(osqlda->sqlvar[i].sqllen));
					break;
				case SQL_VARYING:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(char)*(osqlda->sqlvar[i].sqllen+2));
					break;
				case SQL_SHORT:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(short));
					break;
				case SQL_LONG:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(long));
					break;
				case SQL_FLOAT:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(float));
					break;
				case SQL_DOUBLE:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(double));
					break;
				case SQL_DATE:
				case SQL_BLOB:
				case SQL_ARRAY:
					osqlda->sqlvar[i].sqldata = (char *) UdmXmalloc(sizeof(ISC_QUAD));
					break;
				}
		}
		if (isc_dsql_execute(db->status, &tr_handle, &query_handle, 1, NULL)) {
			free(osqlda);
			db->errcode=1;
			isc_rollback_transaction(status, &tr_handle);
			return NULL;
		}
		result=(iBASE_RES*)UdmXmalloc(sizeof(iBASE_RES));
		result->nRows = 0;
		result->nCols = osqlda->sqld;
		result->items=NULL;
		result->freeme=1;

		while ((fetch_stat = isc_dsql_fetch(db->status, &query_handle, 1, osqlda)) == 0){
			int i;char buf[UDMSTRSIZ]="";
			XSQLVAR *var;
			
			var=osqlda->sqlvar;

			if(!result->nRows){
				result->items=(char **)UdmXmalloc(1*osqlda->sqld*sizeof(char*));
			}else{
				result->items=(char **)UdmXrealloc(result->items,((result->nRows+1)*osqlda->sqld*sizeof(char*)));
			}
			for(i=0;i<osqlda->sqld; i++, var++){
				if(*var->sqlind==-1)
					 buf[0]=0;  /* NULL data */
				else
				switch(var->sqltype & ~1){
					case SQL_TEXT:
					strncpy(buf,(char*)var->sqldata,var->sqllen);
					buf[var->sqllen]=0;
					break;
					case SQL_LONG:
					sprintf(buf,"%ld",*(long*)(var->sqldata));
					break;
					case SQL_SHORT:
					sprintf(buf,"%d",*(short*)(var->sqldata));
					break;
					default:
					sprintf(buf,"Unknown SQL type\n");
					buf[0]=0;
					break; 
				}
				UdmRTrim(buf," ");
				sql_val(result,result->nRows,i)=strdup(buf);
			}
			result->nRows++;
		}
		/* Free fetch buffer */
		for (i = 0; i < osqlda->sqld; i++) {
			free(osqlda->sqlvar[i].sqlind);
			free(osqlda->sqlvar[i].sqldata);
		}
		free(osqlda);

		if (fetch_stat != 100L){
			db->errcode=1; 
			isc_rollback_transaction(status, &tr_handle);
			return NULL;
		}
	} else {
		/* Not select */
		if (isc_dsql_execute(db->status, &tr_handle, &query_handle, 1, NULL)) {
			db->errcode=1;
			isc_rollback_transaction(status, &tr_handle);
			isc_dsql_free_statement(status, &query_handle, DSQL_drop);
			return NULL;
		}
		empty_res.nRows=0;
		empty_res.nCols=0;
		empty_res.items=NULL;
		empty_res.freeme=0;
		result=&empty_res;
	}
	if (isc_dsql_free_statement(db->status, &query_handle, DSQL_drop)){
		db->errcode=1; 
		isc_rollback_transaction(status, &tr_handle);
		return NULL;
	}
	
	if (isc_commit_transaction(db->status, &tr_handle)){
		db->errcode=1; 
		return NULL;
	}
	return result;
}
static iBASE_RES * sql_query(UDM_AGENT * Indexer, char *query){
	iBASE_RES * res;
	DB * db;

#ifdef DEBUG_SQL
	fprintf(stderr,"%s\n",query);
#endif
	db=(DB*)(Indexer->db);

	res=sql_ibase_query(Indexer,query);
	if(db->errcode){
		displayError(db);
		if(strstr(db->errstr,"uplicat")){
			db->errcode=0;
		}else{
			/*strcat(db->errstr," ");
			strcat(db->errstr,query);*/
		}
		return(NULL);
	}
	return(res);
}

#elif HAVE_ORACLE8
/******************** Oracle8 OCI - native support driver ******************/
/* (C) copyleft 2000 Anton Zemlyanov, az@hotmail.ru */
/* TODO: efficient transactions, multi-row fetch, limits stuff */
 
#define	MAX_COLS_IN_TABLE	32
#define BUF_OUT_SIZE		128
#define MAX_BIND_PARAM		3

typedef struct or_struct {
	int	nRows;
	int	nCols;
	int	freeme;
	char    *defbuff[MAX_COLS_IN_TABLE]; /* Buffers for OCIStmtFetch */
	int     col_size[MAX_COLS_IN_TABLE]; /* Size of column */
	sb2	indbuff[MAX_COLS_IN_TABLE][BUF_OUT_SIZE];  /* Indicators for NULLs */
	char	**items;
} ORACLE_RES;
typedef ORACLE_RES UDB_RES;

struct param_struct{
	int out_rec;
	int out_pos[MAX_BIND_PARAM];
	int out_pos_val[MAX_BIND_PARAM][BUF_OUT_SIZE];
};

typedef struct struct_db {
	OCIEnv     *envhp;
	OCIError   *errhp;
	OCISvcCtx  *svchp;
	OCIStmt	   *stmthp;
	OCIParam   *param;
	OCIDefine  *defb[MAX_COLS_IN_TABLE];
	ORACLE_RES *res;
	OCIBind    *bndhp[MAX_BIND_PARAM];
	int        res_limit;
	int	commit_fl;
	int        connected;
	ub4        errcode;
	char       errstr[UDMSTRSIZ];
	struct param_struct *par;
} DB;

#define SQL_NUM_ROWS(x)	(x?x->nRows:0)
#define SQL_FREE(x)	oci_free_result(x)
#define sql_val(x,y,z)	x->items[y*x->nCols+z]
#define sql_value(x,y,z) x?(sql_val(x,y,z)?sql_val(x,y,z):""):""
#define SQL_OK(rc)	((rc==OCI_SUCCESS)||(rc==OCI_SUCCESS_WITH_INFO))

static int oci_free_result(ORACLE_RES *res)
{
	int i;
	if(res){
		if(res->freeme){
			if(res->items){
				for(i=0;i<res->nCols*res->nRows;i++)
					if(res->items[i])
						free(res->items[i]);
				free(res->items);
			}
			if(res->defbuff){
				for(i=0;i<res->nCols;i++)
					if(res->defbuff[i])
						free(res->defbuff[i]);
			}
			free(res);
		}
	}
	return(0);
}

static int displayError(DB *db)
{
	sb4	errcode=0;
	text	errbuf[512];
	char	*ptr;

	db->errstr[0]='\0';

	switch (db->errcode)
	{
	case OCI_SUCCESS:
		sprintf(db->errstr,"Oracle - OCI_SUCCESS");
		break;
	case OCI_SUCCESS_WITH_INFO:
		sprintf(db->errstr,"Oracle - OCI_SUCCESS_WITH_INFO");
		break;
	case OCI_NEED_DATA:
		sprintf(db->errstr,"Oracle - OCI_NEED_DATA");
		break;
	case OCI_NO_DATA:
		sprintf(db->errstr,"Oracle - OCI_NODATA");
		break;
	case OCI_ERROR:
		OCIErrorGet((dvoid *)db->errhp, (ub4) 1, (text *) NULL, &errcode,
			errbuf, (ub4) sizeof(errbuf), OCI_HTYPE_ERROR);
		ptr=errbuf;
		while(*ptr) {
			if(*ptr=='\n')
				*ptr='!';
			++ptr;
		}
		sprintf(db->errstr,"Oracle - %.*s", 512, errbuf);
		break;
	case OCI_INVALID_HANDLE:
		sprintf(db->errstr,"Oracle - OCI_INVALID_HANDLE");
		break;
	case OCI_STILL_EXECUTING:
		sprintf(db->errstr,"Oracle - OCI_STILL_EXECUTE");
		break;
	case OCI_CONTINUE:
		sprintf(db->errstr,"Oracle - OCI_CONTINUE");
		break;
	default:
		sprintf(db->errstr,"Oracle - unknown internal bug");
		break;
	}
	return 0;
}


static void CloseDB(DB *db)
{
	if(!db->connected)
		return;
	db->errcode=OCILogoff(db->svchp,db->errhp);
	db->connected=0;
}

static int oci_bind(DB *db){
int i,pos;
sword   rc;

        for (i=0; i<MAX_BIND_PARAM; i++)
                db->bndhp[i] = (OCIBind *) 0;

        for( i=0; i<MAX_BIND_PARAM; i++){
                if ((pos=db->par->out_pos[i])>0){
                        if ( (rc = OCIBindByPos(db->stmthp, &db->bndhp[pos-1], db->errhp, (ub4) pos,
				(dvoid *) &db->par->out_pos_val[pos-1][0],
                                (sb4) sizeof(db->par->out_pos_val[pos-1][0]), SQLT_INT,                                
				(dvoid *) 0, (ub2 *)0, (ub2 *)0,
                                (ub4) 0, (ub4 *) 0, (ub4) OCI_DEFAULT))){

                                return rc;
                        }
                        /*  bind array  */
                        if ((rc = OCIBindArrayOfStruct(db->bndhp[pos-1], db->errhp,                                
				sizeof(db->par->out_pos_val[pos-1][0]),0, 0, 0))){

                                return rc;
                        }
                }
        }
        return 0;
}

void param_add(DB *db, int pos_out_1, int pos_out_2, int pos_out_3){
        db->par->out_pos_val[0][db->par->out_rec] = pos_out_1;
        db->par->out_pos_val[1][db->par->out_rec] = pos_out_2;
        db->par->out_pos_val[2][db->par->out_rec] = pos_out_3;
        db->par->out_rec++;
}

void param_init(DB *db, int pos1, int pos2, int pos3){
        db->par->out_pos[0]=pos1;
        db->par->out_pos[1]=pos2;
        db->par->out_pos[2]=pos3;
}

void param_free(DB *db){
        db->par->out_rec = 0;

}

static int InitDB(UDM_AGENT * Indexer){
DB * db;
        db=(DB*)Indexer->db;

	OCIInitialize( OCI_DEFAULT, NULL, NULL, NULL, NULL );
	OCIEnvInit( &(db->envhp), OCI_DEFAULT, 0, NULL );
	OCIHandleAlloc( db->envhp, (dvoid **)&(db->errhp), OCI_HTYPE_ERROR,
		0, NULL );
	db->errcode=OCILogon(db->envhp, db->errhp, &(db->svchp),
		Indexer->Conf->DBUser, strlen(Indexer->Conf->DBUser),
		Indexer->Conf->DBPass, strlen(Indexer->Conf->DBPass),
		Indexer->Conf->DBName, strlen(Indexer->Conf->DBName) );
	if(db->errcode!=OCI_SUCCESS)
		return -1;

	db->errcode=0;
	db->connected=1;
	db->commit_fl=0;
	param_free(db);

/*        sql_query(((DB*)(db)), "ALTER SESSION SET SQL_TRACE=TRUE"); */

	return 0;
}

/* Empty set for non-select queries */
static ORACLE_RES empty_res;
static ORACLE_RES* sql_oracle_query(UDM_AGENT * Indexer, char *qbuf)
{
	ORACLE_RES *result;
	sword	rc;
	ub2	stmt_type;
	int	cnt, buf_nRows, row;

	int	colcnt;
	ub2	coltype;
	ub2	colsize;
	int	oci_fl;
	sb4	errcode=0;
	text	errbuf[512];
	int	num_rec;
	DB * db;

        db=(DB*)Indexer->db;

	rc=OCIHandleAlloc(db->envhp, (dvoid *)&(db->stmthp), OCI_HTYPE_STMT,0,NULL);
	if(!SQL_OK(rc)){
		db->errcode=rc;
		return NULL;
	}
	rc=OCIStmtPrepare(db->stmthp,db->errhp,qbuf,strlen(qbuf),
			OCI_NTV_SYNTAX,OCI_DEFAULT);
	if(!SQL_OK(rc)){
		db->errcode=rc;
		return NULL;
	}

        if (db->par->out_rec){
                oci_bind(db);
                num_rec = db->par->out_rec;
                param_free(db);
        }else{
                num_rec = 1;
        }
    
	rc=OCIAttrGet(db->stmthp,OCI_HTYPE_STMT,&stmt_type,0,
			OCI_ATTR_STMT_TYPE,db->errhp);
	if(!SQL_OK(rc)){
		db->errcode=rc;
		return NULL;
	}

	if(stmt_type!=OCI_STMT_SELECT) {
		/* non-select statements */
		/* COMMIT_ON_SUCCESS in inefficient */
		if (db->commit_fl)
			oci_fl=OCI_DEFAULT;
		else
			oci_fl=OCI_COMMIT_ON_SUCCESS;

		rc=OCIStmtExecute(db->svchp,db->stmthp,db->errhp, num_rec,0,
				NULL,NULL,oci_fl);

		if (num_rec>1)
			  (void) OCITransCommit(db->svchp, db->errhp, (ub4) 0);

		if(!SQL_OK(rc)){
			db->errcode=rc;
			OCIErrorGet((dvoid *)db->errhp, (ub4) 1, (text *) NULL, &errcode,
				errbuf, (ub4) sizeof(errbuf), OCI_HTYPE_ERROR);
			if(strncmp(errbuf,"ORA-00001",9)) /* ignore ORA-00001 */
				return NULL;
			else 
				db->errcode=OCI_SUCCESS;
		}
		/* OCI_ATTR_ROW_COUNT of db->stmthp - Rows affected */
		rc=OCIHandleFree(db->stmthp,OCI_HTYPE_STMT);
		if(!SQL_OK(rc)){
			db->errcode=rc;
			return NULL;
		}
		empty_res.nRows=0;
		empty_res.nCols=0;
		empty_res.items=0;
		empty_res.freeme=0;
		return (ORACLE_RES*)&empty_res;
	}

	/* select statements */
	/*Allocate result Set*/
	result=(ORACLE_RES*)UdmXmalloc(sizeof(ORACLE_RES));
	result->nRows=0;
	result->nCols=0;
	result->items=NULL;
	result->freeme=1;

	rc=OCIStmtExecute(db->svchp,db->stmthp,db->errhp,0,0,
			NULL,NULL,OCI_DEFAULT);
	if(!SQL_OK(rc)){
		db->errcode=rc;
		return NULL;
	}

	/*describe the select list and define buffers for the select list */
	colcnt=0;
	while(OCIParamGet(db->stmthp,OCI_HTYPE_STMT,db->errhp,(dvoid *)&(db->param),
			colcnt+1 ) == OCI_SUCCESS) {
		rc=OCIAttrGet(db->param,OCI_DTYPE_PARAM,&(coltype),0,
				OCI_ATTR_DATA_TYPE,db->errhp);
		if(!SQL_OK(rc)){
			db->errcode=rc;
			return NULL;
		}
		rc=OCIAttrGet(db->param,OCI_DTYPE_PARAM,&colsize,0,
			OCI_ATTR_DATA_SIZE,db->errhp);
		if(!SQL_OK(rc)){
			db->errcode=rc;
			return NULL;
		}

		/* OCIStmtFetch do not terminate data with \0 -
		add a byte for terminator to define buffers - insurance*/

		switch(coltype) {
		case SQLT_CHR: /* variable length string */
		case SQLT_AFC: /* fixed length string */
                        result->col_size[colcnt]=colsize;
                        result->defbuff[colcnt]=(char *)UdmXmalloc(result->col_size[colcnt]*BUF_OUT_SIZE+1);
			break;
		case SQLT_NUM: /* numbers up to 14 digits now */
                        result->col_size[colcnt]=14;
                        result->defbuff[colcnt]=(char *)UdmXmalloc(result->col_size[colcnt]*BUF_OUT_SIZE+1);
			break;
		default:
			printf("<P>Unknown datatype: %d\n",coltype);
			return (ORACLE_RES*)NULL;
		}
		rc=OCIDefineByPos(db->stmthp,&(db->defb[colcnt]),db->errhp,
			colcnt+1,result->defbuff[colcnt],result->col_size[colcnt],SQLT_CHR,
			&(result->indbuff[colcnt]),0,0,OCI_DEFAULT);
		if(!SQL_OK(rc)){
			db->errcode=rc;
	 		return NULL;
		}
                rc=OCIDefineArrayOfStruct(db->defb[colcnt], db->errhp,
                         result->col_size[colcnt], sizeof(result->indbuff[0][0]), 0, 0);
		if(!SQL_OK(rc)){
                        db->errcode=rc;
                        return NULL;
                }
		colcnt++;
	}
	result->nCols=colcnt;

	/* Now fetching the selected rows into the memory */
	while(1) {
		if (db->res_limit)
			if (db->res_limit == result->nRows)
				break;
                /*Fix me: Process of determine real fetched rows
                 Fill indicator buffer for value -6 to */
                for(row=0; row<BUF_OUT_SIZE; row++)
                        result->indbuff[result->nCols-1][row]=-6;

		rc=OCIStmtFetch(db->stmthp,db->errhp,BUF_OUT_SIZE,
			OCI_FETCH_NEXT,OCI_DEFAULT);

                if((rc!=OCI_NO_DATA) && !SQL_OK(rc)) {
                        db->errcode=rc;
                        return NULL;
                }

                /* Find number of fetched rows */
                for(buf_nRows=0; buf_nRows<BUF_OUT_SIZE; buf_nRows++){
                        if(result->indbuff[result->nCols-1][buf_nRows]==-6)
                                break;
                }

                if(!buf_nRows)
                        break;

		if(!result->nRows)  /* first row - allocate */
			result->items=(char **)UdmXmalloc(buf_nRows*result->nCols*sizeof(char*));
		else
			result->items=(char **)UdmXrealloc(result->items,
				((result->nRows+buf_nRows)*result->nCols*sizeof(char*)) );
		/* Limit rows */	
	        if (db->res_limit)
            		buf_nRows=result->nRows+buf_nRows<=db->res_limit?buf_nRows:(db->res_limit-result->nRows);
		for(row=0; row<buf_nRows; row++){
			for(cnt=0; cnt<result->nCols; ++cnt) {
                    		if(result->indbuff[cnt][row]==OCI_IND_NULL) {
                            		sql_val(result,(result->nRows+row),cnt) = strdup("");
                                }else{
                                        char *val=UdmXmalloc(result->col_size[cnt]+1);
                                        int offset=row*result->col_size[cnt];

                                        udm_snprintf(val, result->col_size[cnt]+1, "%s",
						result->defbuff[cnt]+offset);
                                        sql_val(result,(result->nRows+row),cnt)=
                                    		strdup( UdmRTrim(val," "));
                                        UDM_FREE(val);
                                }
                        }
                }
		result->nRows+=row;
		if(rc==OCI_NO_DATA)
                        break;
                if(!SQL_OK(rc)) {
                        db->errcode=rc;
                        return NULL;
                }

	}
	rc=OCIHandleFree(db->stmthp,OCI_HTYPE_STMT);
	db->res_limit = 0;
	if(!SQL_OK(rc)){
		db->errcode=rc;
		return NULL;
	}

	return (ORACLE_RES*)result;
}

static ORACLE_RES* sql_query(UDM_AGENT * Indexer, char *qbuf) {
ORACLE_RES *res;
DB *db;
#ifdef DEBUG_SQL
int row_num;
unsigned long ticks;
	ticks=UdmStartTimer();
	row_num = ((DB*)Indexer->db)->par->out_rec;
#endif
	db=(DB*)Indexer->db;

	if(!db->connected) {
		InitDB(Indexer);
		if(db->errcode) {
			displayError(db);
			return NULL;
		} else
			db->connected=1;
 	}
	res=sql_oracle_query(Indexer,qbuf);

#ifdef DEBUG_SQL
	ticks=UdmStartTimer()-ticks;
	fprintf(stderr,"[%d] SQL %.2fs: %s ->%d\n",getpid(),(float)ticks/1000,qbuf, 
		res?(res->nRows?res->nRows:row_num):0);
#endif


	if(db->errcode) {
		displayError(db);
		return NULL;
	}

	return (ORACLE_RES*)res;
}

#elif HAVE_ORACLE7
/******************** Oracle7 OCI - native support driver ******************
 * (C) 2000 Kir Maximov, maxkir@email.com 
 * 
 * Without transactions ...
 */

#define MAX_COLS_IN_TABLE    32
#define HDA_SIZE 256
#define MAX_ITEM_BUFFER_SIZE 32

/* Query result structure */
typedef struct or_struct {
    int nRows;
    int nCols;
    int dont_free_me;
    char    **items;
} ORACLE_RES;
typedef ORACLE_RES UDB_RES;

/* For results of non-SELECT queries: */
static ORACLE_RES empty_res;

/* Database structure */
typedef struct struct_db {
    ORACLE_RES *res;
    int        res_limit;
    int        commit_fl;
    int        connected;
    ub4        errcode;
    char       errstr[UDMSTRSIZ];

    Lda_Def     lda;
    ub1 hda[HDA_SIZE];

    Cda_Def     cursor;
    
} DB;

#define UDM_OCI_UNIQUE 1

#define SQL_NUM_ROWS(x) (x?x->nRows:0)
#define SQL_FREE(x) oci_free_result(x)
#define sql_val(x,y,z)  x->items[y*x->nCols+z]
#define sql_value(x,y,z) (x?(sql_val(x,y,z)?sql_val(x,y,z):""):"")

#define ORA_VERSION_7 2

/*  some SQL and OCI function codes */
#define FT_INSERT                3
#define FT_SELECT                4
#define FT_UPDATE                5
#define FT_DELETE                9

/* Declare structures for query information. */
struct describe
{
    sb4             dbsize;
    sb2             dbtype;
    sb1             buf[MAX_ITEM_BUFFER_SIZE];
    sb4             buflen;
    sb4             dsize;
};

struct define 
{
    ub1             buf[UDMSTRSIZ];
    sb2             indp;
    ub2             col_retlen, col_retcode;
};
    

/*-------------------------------------------------------*/
static int oci_free_result(ORACLE_RES *res)
{
    int i;

    if(res && !res->dont_free_me)
    {
        if(res->items)
        {
            for(i=0;i<res->nCols*res->nRows;i++)
            {
                if(res->items[i])
                    free(res->items[i]);
            }
            free(res->items);
        }
        free(res);
    }
    return(0);
}
/*-------------------------------------------------------*/
static int displayError(DB *db)
{
    sword n;
    text msg[512];

    db->errstr[0]='\0';
    if (!db->errcode) 
        return 0; 

    n = oerhms(&db->lda, db->cursor.rc, msg, (sword) sizeof msg);
    
    strcpy(db->errstr, "ORACLE - ");
    strcat(db->errstr, msg);

    printf("displayError: %p %s\n", db, msg);

    return 0;
}
/*-------------------------------------------------------*/
static int InitDB(UDM_AGENT * Indexer)
{
    DB * db;
    Cda_Def *cda = &db->cursor;
    Lda_Def *lda = &db->lda;
    char buff[1024];

    db=(DB*)Indexer->db;

    udm_snprintf(buff, sizeof(buff)-1, "%s/%s@%s", 
	    Indexer->Conf->DBUser,
	    Indexer->Conf->DBPass,
	    Indexer->Conf->DBName);
    
    db->errcode = olog(lda, db->hda,
                       buff, -1,
                       (text *)0, -1,
                       0, -1, OCI_LM_DEF);

    if ( db->errcode )
    {
        /* Error happened */
        return -1;
    }

    /* Now, open a cursor to be used in all queries*/
    oopen(cda, lda, (text*)0, -1, -1, (text*)0, -1);
    db->errcode = cda->rc;
    if (db->errcode)
    {
        displayError(db);
        return 0;
    }
    
    db->errcode = 0;
    db->connected = 1;

    empty_res.dont_free_me = 1;
   
    return 0;
}
/*-------------------------------------------------------*/
static void CloseDB(DB *db)
{
    if(!db->connected)
        return;
    
    /* First, close a cursor */
    oclose(&db->cursor);

    /* Logout */
    db->errcode = ologof(&db->lda);
    db->connected = 0;
}
/*-------------------------------------------------------*/
static ORACLE_RES* fetch_data(DB *db)
{
    /* Real feching of data for SELECT statements */
    ORACLE_RES *res = NULL;
    int col, deflen;
    struct describe desc[MAX_COLS_IN_TABLE];
    struct define   def[MAX_COLS_IN_TABLE];
    Cda_Def *cda = &db->cursor;
    char *buf_ptr;
   

    /* Now, get column desriptions */
    for(col = 0; col < MAX_COLS_IN_TABLE; col ++)
    {
        desc[col].buflen = MAX_ITEM_BUFFER_SIZE;
        if ( odescr( cda, col+1, &desc[col].dbsize,
                     &desc[col].dbtype, desc[col].buf,
                     &desc[col].buflen, &desc[col].dsize,
                     0,0,0
                   )
           )
        {
            if ( cda->rc == 1007 ) /* No more variables */
                break;
            db->errcode = cda->rc;
            if (db->errcode)
            {
                displayError(db);
                return NULL;
            }
            
        }
        
        switch(desc[col].dbtype)
        {
        case 2: /* NUMBER */
            deflen = 14;
            break;
        case 96: /* CHAR */
        case 1:  /* VARCHAR2 */
        default:
            deflen = (desc[col].dbsize > UDMSTRSIZ ? UDMSTRSIZ : desc[col].dbsize + 1);
        }
       
        if (odefin(cda, col + 1,
                    def[col].buf, deflen, 5, /* 5 - null terminated string */
                    -1, &def[col].indp, (text*)0, -1, -1,
                    &def[col].col_retlen,
                    &def[col].col_retcode ))
        {
            db->errcode = cda->rc;
            if (db->errcode)
            {
                displayError(db);
                return NULL;
            }
        }
    }
    /* Now col contains a number of columns */

    /* Get memory for resulting data */
    res = (ORACLE_RES*)UdmXmalloc(sizeof(ORACLE_RES));
    if (!res)
        return NULL;

    /* Clear all structure data */
    memset(res, 0, sizeof(ORACLE_RES));

    res->nCols = col;

    /* Now, fetching the data */
    for (;;)
    {
        /* Fetch a row, break on end of fetch, */
        /* disregard null fetch "error" */
        
        if (ofetch(cda))
        {
            if ( cda->rc == 1403 ) /* No data found */
                break;
            if ( cda->rc != 1405 && cda->rc ) /* Null value returned */
            {
               SQL_FREE(res);
               db->errcode = cda->rc;
               displayError(db);
               return NULL;
            }
        }
        /* Next row: */
        
        /* [Re]allocate memory for data */
        if (!res->items)
        {
            res->items = (char**) UdmXmalloc( res->nCols * sizeof(char*));
        }
        else
        {
            res->items = (char**) UdmXrealloc(res->items, 
                             (res->nRows + 1) * res->nCols * sizeof(char*));
        }
                
        for (col = 0; col < res->nCols; col++)
        {
            if (def[col].indp < 0) /* NULL value */
            {
                buf_ptr = strdup("");
            }
            else
            {
                buf_ptr = strdup((char*)def[col].buf);
                UdmRTrim(buf_ptr, " ");
            }
            /* sql_val(res, res->nRows, col)*/
            res->items[res->nRows*res->nCols + col] = buf_ptr;
            /*printf( "\n<P>Field %d Val '%s' Null '%d'",col,sql_value(res,res->nRows,col), def[col].indp );*/

        }
        res->nRows ++;
    }

    return res;    
}
/*-------------------------------------------------------*/
static ORACLE_RES* sql_oracle_query(UDM_AGENT * Indexer, char *query)
{
    /* Make real query and store result */
    ORACLE_RES* res = NULL;
    DB * db=(DB*)Indexer->db;
    Cda_Def *cda = &db->cursor;
    
    /* Parse SQL statement */
    oparse(cda, (text*) query,
                            (sb4)-1, (sword) 0, (ub4)ORA_VERSION_7 );
    if ( cda->rc )
    {
        db->errcode = cda->rc;
        displayError(db);
        return NULL;
    }
    /* Save sql function */

    /* Exec */
    oexec(cda);
    if (cda->rc)
    {
        if (cda->rc != UDM_OCI_UNIQUE)  /* ignore unique constraint violation */
        {
            displayError(db);
            return NULL;
        }
        db->errcode = 0;
    }
    
    switch (cda->ft)
     {
        case FT_DELETE:
        case FT_INSERT:
        case FT_UPDATE:
            /* Empty result */
            res = &empty_res;

            /* commit */
            ocom(&db->lda);

            break;
        case FT_SELECT:
            /* Fetch data needed */
            res = fetch_data(db);
            break;
        default:
            res = NULL;
            break;
    }
    
    return res;
}

/*-------------------------------------------------------*/
static ORACLE_RES* sql_query(UDM_AGENT * Indexer, char *qbuf) 
{
    ORACLE_RES *res;
    DB * db;

    db=(DB*)Indexer->db;

    if(!db->connected) 
    {
        InitDB(Indexer);
        if(db->errcode) 
        {
            displayError(db);
            return NULL;
        }
    }
    
    /* Make real query */
    res = sql_oracle_query(Indexer, qbuf);
/*    printf("\nQ: '%s'\n", qbuf); */
    
    if(!res) 
    {
        if (db->errcode)
        {
            displayError(db);
        }
        else
        {
            fprintf(stderr, "sql_query: this should never happen.\n");   
        }
    }
    return res;
}


/******************************** Template  ************************/
#else
typedef int UDB_RES;
typedef struct struct_db {
	int   *res;
	int   *res1;
	int res_limit;
	int commit_fl;
	int connected;
	int errcode;
	char errstr[UDMSTRSIZ];
	int log[256];
} DB;
#define SQL_NUM_ROWS(x)	0
#define SQL_FREE(x)
#define sql_value(x,y,z) 0

static int InitDB(DB *db){
	db->connected=1;return(0);
}
static int * sql_query(DB * db,char *query){
	return(0);
}
void CloseDB(DB * db){
}
#endif

/********************************************************************/
/* --------------------------------------------------------------- */
/* Almost Unified code for all supported SQL backends              */
/* --------------------------------------------------------------- */
/*******************************************************************/


void * UdmAllocDB(UDM_AGENT * Indexer,int mode){
	DB * db;

	db=(DB*)UdmXmalloc(sizeof(DB));
#if (HAVE_IODBC || HAVE_UNIXODBC || HAVE_SOLID || HAVE_VIRT || HAVE_EASYSOFT || HAVE_SAPDB)
	db->hDbc=SQL_NULL_HDBC;
	db->hEnv=SQL_NULL_HENV;
	db->hstmt=SQL_NULL_HSTMT;
#endif
#if (HAVE_IBASE)
	db->DBH=NULL;
#endif
	db->res=NULL;
	db->res_limit=0;
	db->connected=0;
	db->errcode=0;
	db->errstr[0]=0;
	db->commit_fl=0;
#if (HAVE_ORACLE8)
	db->par = UdmXmalloc(sizeof(struct param_struct));
#endif
	return((void*)(db));
}
void UdmFreeDB(UDM_AGENT * Indexer){
	if(Indexer->db){
		CloseDB((DB*)(Indexer->db));
		free(Indexer->db);
	}
}
int UdmDBErrorCode(void *db){
	return(((DB*)(db))->errcode);
}
char * UdmDBErrorMsg(void *db){
	return(((DB*)(db))->errstr);
}


/******************** Limits stuff *********************************/

__INDLIB__ int UdmAddTagLimit(UDM_ENV * Conf,char * tag){
	strcpy(Conf->taglimit,tag?tag:"");
	if(Conf->tagstr[0])strcpy(UDM_STREND(Conf->tagstr)-1," OR ");
	else	strcat(Conf->tagstr," AND (");
	if(Conf->DBType==UDM_DB_PGSQL)
		sprintf(UDM_STREND(Conf->tagstr),"(url.tag || '') LIKE '%s')",tag);
	else
		sprintf(UDM_STREND(Conf->tagstr),"url.tag LIKE '%s')",tag);
	return(0);
}

__INDLIB__ int UdmAddStatusLimit(UDM_ENV *c,int status){
#ifdef  HAVE_SQL_IN
	if(c->statusstr[0])sprintf(UDM_STREND(c->statusstr)-1,",%d)",status);
	else	sprintf(c->statusstr," AND url.status IN (%d)",status);
#else
	if(c->statusstr[0])strcpy(UDM_STREND(c->statusstr)-1," OR ");
	else	strcat(c->statusstr," AND (");
	sprintf(UDM_STREND(c->statusstr),"url.status=%d)",status);
#endif
	return(0);
}

__INDLIB__ int UdmAddURLLimit(UDM_ENV *c,char *URL){
	UDM_URL urlstruct;
	char site_id_str[UDMSTRSIZ];

	UdmParseURL(&urlstruct,URL);
	if(urlstruct.schema[0]&&urlstruct.hostinfo[0]){
		sprintf(site_id_str,"%s://%s/",urlstruct.schema,urlstruct.hostinfo);
		c->sitelimit=UdmStrCRC32(site_id_str);
	}else{
		c->sitelimit=0;
	}
	if(c->urlstr[0])strcpy(UDM_STREND(c->urlstr)-1," OR ");
	else	strcat(c->urlstr," AND (");
	if(c->DBType==UDM_DB_PGSQL)
		sprintf(UDM_STREND(c->urlstr),"(url.url || '') LIKE '%s')",URL);
	else
		sprintf(UDM_STREND(c->urlstr),"url.url LIKE '%s')",URL);
	return(0);
}

__INDLIB__ int UdmAddLangLimit(UDM_ENV *c,char * lang){
	if(c->langstr[0])strcpy(UDM_STREND(c->langstr)-1," OR ");
	else	strcat(c->langstr," AND (");
	sprintf(UDM_STREND(c->langstr),"url.lang LIKE '%s')",lang);
	return(0);
}

__INDLIB__ int UdmAddCatLimit(UDM_ENV *c,char * cat){
	strcpy(c->catlimit,cat?cat:"");
	if(c->catstr[0])strcpy(UDM_STREND(c->catstr)-1," OR ");
	else    strcat(c->catstr," AND (");
	sprintf(UDM_STREND(c->catstr),"url.category LIKE '%s%%')",cat);
	return(0);
}



__INDLIB__ int UdmAddTimeLimit(UDM_ENV *c,struct udm_stl_info_t * stl){
	char lt_gt;
	
	switch(stl->type){
		case 1: case -1:
			if (stl->type==1)
				lt_gt='>';
			else
				lt_gt='<';
			sprintf(c->timestr, " AND (url.last_mod_time%c%li)", lt_gt, stl->t1);
			break;
		case 2: /* between */
			sprintf(c->timestr, " AND (url.last_mod_time BETWEEN %li AND %li)", stl->t1, stl->t2);
			break;
		default:
			return -1;
	}
	return(0);
}

__INDLIB__ int UdmClearLimits(UDM_ENV *c){
	c->urlstr[0]='\0';
	c->tagstr[0]='\0';
	c->statusstr[0]='\0';
	c->langstr[0]='\0';
	c->timestr[0]='\0';
	c->catstr[0]='\0';
	c->catlimit[0]='\0';
	c->taglimit[0]='\0';
	c->sitelimit=0;
	return(0);
}
__INDLIB__ int UdmClearURLLimit(UDM_ENV *c){
	c->urlstr[0]=0;
	return(0);
}
/************* Servers ******************************************/

int UdmLoadServerTable(UDM_AGENT * Indexer, char * name, int flags){
	int rows,i;
	UDM_SERVER Server;
	char qbuf[UDMSTRSIZ];

	sprintf(qbuf,"\
SELECT rec_id,url,period,tag,category,charset,lang,basic_auth,\
proxy,proxy_port,proxy_auth,\
maxhops,gindex,follow,deletebad,use_robots,delete_no_srv,use_clones,\
descweight,keywordweight,titleweight,bodyweight,\
urlweight,urlhostweight,urlpathweight,urlfileweight,\
correct_factor,incorrect_factor,number_factor,alnum_factor,\
max_net_errors,net_delay_time,read_timeout \
FROM %s WHERE active=1",name);

	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db)){
		return(IND_ERROR);
	}
	rows=SQL_NUM_ROWS(((DB*)(Indexer->db))->res);
	for(i=0;i<rows;i++){
		DB * db;

		db=(DB*)(Indexer->db);
		UdmInitServer(&Server);

		Server.url		=sql_value(db->res,i,1);
		Server.period		=UDM_ATOI(sql_value(db->res,i,2));
		Server.tag		=sql_value(db->res,i,3);
		Server.category		=sql_value(db->res,i,4);
		Server.charset		=sql_value(db->res,i,5);
		strncpy(Server.lang,UDM_NULL2EMPTY(sql_value(db->res,i,6)),2);Server.lang[2]='\0';
		Server.basic_auth	=UDM_EMPTY2NULL(sql_value(db->res,i,7));
		
		if(Server.basic_auth){
			char * basic_auth;
			
			basic_auth=(char*) UdmXmalloc(BASE64_LEN(strlen(Server.basic_auth)));
			udm_base64_encode(Server.basic_auth,basic_auth,strlen(Server.basic_auth));
			Server.basic_auth=basic_auth;
		}
		
		Server.proxy		=UDM_EMPTY2NULL(sql_value(db->res,i,8));
		Server.proxy_port	=UDM_ATOI(sql_value(db->res,i,9));
		Server.proxy_basic_auth	=UDM_EMPTY2NULL(sql_value(db->res,i,10));
		Server.maxhops		=UDM_ATOI(sql_value(db->res,i,11));
		Server.index		=UDM_ATOI(sql_value(db->res,i,12));
		Server.follow		=UDM_ATOI(sql_value(db->res,i,13));
		Server.deletebad	=UDM_ATOI(sql_value(db->res,i,14));
		Server.use_robots	=UDM_ATOI(sql_value(db->res,i,15));
		Server.delete_no_server	=UDM_ATOI(sql_value(db->res,i,16));
		Server.use_clones	=UDM_ATOI(sql_value(db->res,i,17));
		Server.descweight	=UDM_ATOI(sql_value(db->res,i,18));
		Server.keywordweight	=UDM_ATOI(sql_value(db->res,i,19));
		Server.titleweight	=UDM_ATOI(sql_value(db->res,i,20));
		Server.bodyweight	=UDM_ATOI(sql_value(db->res,i,21));
		Server.urlweight	=UDM_ATOI(sql_value(db->res,i,22));
		Server.urlhostweight	=UDM_ATOI(sql_value(db->res,i,23));
		Server.urlpathweight	=UDM_ATOI(sql_value(db->res,i,24));
		Server.urlfileweight	=UDM_ATOI(sql_value(db->res,i,25));
		Server.correct_factor	=UDM_ATOI(sql_value(db->res,i,26));
		Server.incorrect_factor	=UDM_ATOI(sql_value(db->res,i,27));
		Server.number_factor	=UDM_ATOI(sql_value(db->res,i,28));
		Server.alnum_factor	=UDM_ATOI(sql_value(db->res,i,29));
		Server.max_net_errors	=UDM_ATOI(sql_value(db->res,i,30));
		Server.net_error_delay_time=UDM_ATOI(sql_value(db->res,i,31));
		Server.read_timeout	=UDM_ATOI(sql_value(db->res,i,32));
		        
		UdmAddServer(Indexer->Conf,&Server,flags,UDM_SERVER_SUBSTR|UDM_SERVER_MATCH);
		
		UDM_FREE(Server.basic_auth);
	}
	SQL_FREE(((DB*)(Indexer->db))->res);
	return(IND_OK);
}


/************* robots.txt stuff *********************************/
int  UdmLoadRobots(UDM_AGENT *Indexer){
	int i;

	if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_LOCK,UDM_LOCK_ROBOTS);
	
	UdmFreeRobots(&Indexer->Conf->Robots);
	((DB*)(Indexer->db))->res=sql_query(Indexer,"SELECT hostinfo,path FROM robots");
	if(UdmDBErrorCode(Indexer->db)){
		if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_UNLOCK,UDM_LOCK_ROBOTS);
		return(IND_ERROR);
	}
	if((Indexer->Conf->Robots.nrobots=SQL_NUM_ROWS(((DB*)(Indexer->db))->res))){
		Indexer->Conf->Robots.robots=(UDM_ROBOT *)UdmXmalloc((Indexer->Conf->Robots.nrobots)*sizeof(UDM_ROBOT));
		for(i=0;i<Indexer->Conf->Robots.nrobots;i++){
			Indexer->Conf->Robots.robots[i].hostinfo=strdup(sql_value(((DB*)(Indexer->db))->res,i,0));
			Indexer->Conf->Robots.robots[i].path=strdup(sql_value(((DB*)(Indexer->db))->res,i,1));
		}
	}
	SQL_FREE(((DB*)(Indexer->db))->res);
	if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_UNLOCK,UDM_LOCK_ROBOTS);
	return(IND_OK);
}
int UdmDeleteRobotsFromHost(UDM_AGENT *Indexer,char *hostinfo){
char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"DELETE FROM robots WHERE hostinfo='%s'",hostinfo);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
int UdmAddRobotsToHost(UDM_AGENT *Indexer,char *hostinfo,char *s){
char qbuf[UDMSTRSIZ];
char path[1024];
	if(strlen(s)*2>sizeof(path))return(IND_OK);
	UdmDBEscStr(Indexer->Conf->DBType,path,s);
	sprintf(qbuf,"INSERT INTO robots (hostinfo,path) VALUES ('%s','%s')",hostinfo,path);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
static int UdmDeleteAllFromRobots(UDM_AGENT *Indexer){
char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"DELETE FROM robots");
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db)){
		return(IND_ERROR);
	}
	return(IND_OK);
}


/************************* stopwords *******************************/

int  UdmLoadStopList(UDM_AGENT * Indexer, const char * table){
	int i,rows=0;
	void * db;
	UDM_STOPWORD stopword;
	char query[128];

	sprintf(query,"SELECT word,lang FROM %s",table);
	db=Indexer->db;
	((DB*)db)->res=sql_query(Indexer,query);
	if(((DB*)db)->errcode)return(IND_ERROR);
	rows=SQL_NUM_ROWS(((DB*)db)->res);

	for(i=0;i<rows;i++){
		stopword.word=sql_value(((DB*)db)->res,i,0);
		strncpy(stopword.lang,sql_value(((DB*)db)->res,i,1),2);
		stopword.lang[2]=0;
		UdmAddStopWord(Indexer->Conf,&stopword);
	} 
	SQL_FREE(((DB*)db)->res);
	UdmSortStopList(Indexer->Conf);
	return(IND_OK);
}



/********************** Words ***********************************/

int UdmDeleteWordFromURL(UDM_AGENT *Indexer,int url_id){
char qbuf[UDMSTRSIZ];
int i,last=0;
	switch(Indexer->Conf->DBMode){
	
	case UDM_DBMODE_MULTI:
		for(i=MINDICT;i<MAXDICT;i++){
			if(last!=DICTNUM(i)){
				sprintf(qbuf,"DELETE FROM dict%d WHERE url_id=%d",
					DICTNUM(i),url_id);
				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
				last=DICTNUM(i);
			}
		}
		break;
	case UDM_DBMODE_MULTI_CRC:
		for(i=MINDICT;i<MAXDICT;i++){
			if(last!=DICTNUM(i)){
#ifdef HAVE_ORACLE8
				sprintf(qbuf,"DELETE FROM ndict%d WHERE url_id=:1", DICTNUM(i));
					param_init(Indexer->db, 1, 0, 0);
					param_add(Indexer->db, url_id, 0, 0);
#else
				sprintf(qbuf,"DELETE FROM ndict%d WHERE url_id=%d",DICTNUM(i),url_id);
#endif
				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
				last=DICTNUM(i);
			}
		}
		break;
	case UDM_DBMODE_SINGLE_CRC:
		sprintf(qbuf,"DELETE FROM ndict WHERE url_id=%d",url_id);
		sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
		break;
	case UDM_DBMODE_CACHE:
		/* Let's lock it */
		if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_LOCK,UDM_LOCK_CACHE);
		i=UdmDeleteURLFromCache(Indexer,url_id);
		if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_UNLOCK,UDM_LOCK_CACHE);
		return(i);
		break;
	default:  /* UDM_DBMODE_SINGLE */
		sprintf(qbuf,"DELETE FROM dict WHERE url_id=%d",url_id);
		sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
		break;
	}
	return(IND_OK);
}

static int StoreWordsMulti(UDM_AGENT * Indexer,int url_id, int status){
	char qbuf[UDMSTRSIZ];
	char tablename[64]="dict";
	char tbl_nm[64];
	int  n,prev_dictlen=0;

	if(Indexer->Conf->DBMode==UDM_DBMODE_MULTI){
		strcpy(tablename,"dict");
	}else{
		strcpy(tablename,"ndict");
	}

	for(n=0;n<NDICTS;n++){
		if(prev_dictlen==dictlen[n])continue;
		prev_dictlen=dictlen[n];

		sprintf(tbl_nm, "%s%d", tablename, dictlen[n]);
		if(Indexer->Conf->DBUseLock){
			switch(Indexer->Conf->DBType){
				case UDM_DB_PGSQL:
					sql_query(Indexer,"BEGIN WORK");
					break;
				case UDM_DB_ORACLE:
				case UDM_DB_SAPDB:
					sql_query(Indexer,"COMMIT");
					((DB*)(Indexer->db))->commit_fl = 1;
					break;
				default:
					break;
			}
			if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
		}

		/* Delete old words */
		sprintf(qbuf,"DELETE FROM %s WHERE url_id=%d",tbl_nm,url_id);
		sql_query(Indexer,qbuf);
                if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);

		/* Insert new word */
		if(Indexer->Conf->DBType==UDM_DB_MYSQL){
			int have_words=0;
			char * qb,*qe;
			size_t step=1024,mlen=1024,len,i;

			qb=(char*)malloc(mlen);
			if(Indexer->Conf->DBMode==UDM_DBMODE_MULTI){
				sprintf(qb,"INSERT INTO %s (url_id,word,intag) VALUES ",tbl_nm);
			}else{
				sprintf(qb,"INSERT INTO %s (url_id,word_id,intag) VALUES ",tbl_nm);
			}
			qe=qb+strlen(qb);

			for(i=0;i<Indexer->nwords;i++){
				if (Indexer->Word[i].count && (DICTNUM(strlen(Indexer->Word[i].word)) == dictlen[n])){
					len=qe-qb;
					/* UDM_MAXWORDSIZE+100 should be enough */
					if((len+UDM_MAXWORDSIZE+100)>=mlen){
						mlen+=step;
						qb=(char*)realloc(qb,mlen);
						qe=qb+len;
					}
					if(have_words)strcpy(qe++,",");
					have_words++;
					if(Indexer->Conf->DBMode==UDM_DBMODE_MULTI){
						sprintf(qe,"(%d,'%s',%d)",url_id,Indexer->Word[i].word,Indexer->Word[i].count);
					}else{
						sprintf(qe,"(%d,%d,%d)",url_id,UdmStrCRC32(Indexer->Word[i].word),Indexer->Word[i].count);
					}
					qe=qe+strlen(qe);
					
					/* Insert 64k packets max to stay */
					/* under MySQL's default limit. */
					if((qe-qb)>=64*1024){
						sql_query(Indexer,qb);
						if(UdmDBErrorCode(Indexer->db)){
							free(qb);
							return(IND_ERROR);
						}
						/* Init query again */
						if(Indexer->Conf->DBMode==UDM_DBMODE_MULTI){
							sprintf(qb,"INSERT INTO %s (url_id,word,intag) VALUES ",tbl_nm);
						}else{
							sprintf(qb,"INSERT INTO %s (url_id,word_id,intag) VALUES ",tbl_nm);
						}
						qe=qb+strlen(qb);
						have_words = 0;
					}
				}
			}
			if(have_words){
				sql_query(Indexer,qb);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
			}
			free(qb);
		}else{
			size_t i;
			for(i=0;i<Indexer->nwords;i++){
				int len;
				len=strlen(Indexer->Word[i].word);
				if (Indexer->Word[i].count && (DICTNUM(len) == dictlen[n])){
					if(Indexer->Conf->DBMode==UDM_DBMODE_MULTI){
						sprintf(qbuf,"INSERT INTO %s (url_id,word,intag) VALUES(%d,'%s',%d)",tbl_nm,url_id,Indexer->Word[i].word,Indexer->Word[i].count);
					}else{
						sprintf(qbuf,"INSERT INTO %s (url_id,word_id,intag) VALUES(%d,%d,%d)",tbl_nm,url_id,UdmStrCRC32(Indexer->Word[i].word),Indexer->Word[i].count);
					}
					sql_query(Indexer,qbuf);
					if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
				}
			}
		}

		if(Indexer->Conf->DBUseLock){
			switch(Indexer->Conf->DBType){
				case UDM_DB_PGSQL:
					sql_query(Indexer,"END WORK");
					break;
				case UDM_DB_ORACLE:
				case UDM_DB_SAPDB:
					sql_query(Indexer,"COMMIT");
					((DB*)(Indexer->db))->commit_fl = 0;
					break;
				default:
					break;
			}
			if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
		}
	}
	return(IND_OK);
}

static int StoreWordsSingle(UDM_AGENT * Indexer,int url_id, int status){
	size_t i;
	char qbuf[256]="";

	/* Start transaction if supported */
	/* This is to make stuff faster   */

	if(Indexer->Conf->DBUseLock){
		switch(Indexer->Conf->DBType){
			case UDM_DB_PGSQL:
				sql_query(Indexer,"BEGIN WORK");
				break;
			case UDM_DB_ORACLE:
			case UDM_DB_SAPDB:
				sql_query(Indexer,"COMMIT");
				((DB*)(Indexer->db))->commit_fl = 1;
				break;
			default:
				break;
		}
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	}

	/* Delete old words */
	if(Indexer->Conf->DBMode==UDM_DBMODE_SINGLE){
		sprintf(qbuf,"DELETE FROM dict WHERE url_id=%d",url_id);
	}else{
		sprintf(qbuf,"DELETE FROM ndict WHERE url_id=%d",url_id);
	}

	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);

	/* Insert new words */
	if(Indexer->Conf->DBType==UDM_DB_MYSQL){
		if(Indexer->nwords){
			char * qb,*qe;
			size_t step=1024,mlen=1024,len;

			qb=(char*)malloc(mlen);
			if(Indexer->Conf->DBMode==UDM_DBMODE_SINGLE){
				strcpy(qb,"INSERT INTO dict (url_id,word,intag) VALUES ");
			}else{
				strcpy(qb,"INSERT INTO ndict (url_id,word_id,intag) VALUES ");
			}
			qe=qb+strlen(qb);

			for(i=0;i<Indexer->nwords;i++){
				len=qe-qb;
				/* UDM_MAXWORDSIZE+100 should be enough */
				if((len+UDM_MAXWORDSIZE+100)>=mlen){
					mlen+=step;
					qb=(char*)realloc(qb,mlen);
					qe=qb+len;
				}
				if(i>0)strcpy(qe++,",");
				if(Indexer->Conf->DBMode==UDM_DBMODE_SINGLE){
					sprintf(qe,"(%d,'%s',%d)",url_id,Indexer->Word[i].word,Indexer->Word[i].count);
				}else{
					sprintf(qe,"(%d,%d,%d)",url_id,UdmStrCRC32(Indexer->Word[i].word),Indexer->Word[i].count);
				}
				qe=qe+strlen(qe);
			}
			sql_query(Indexer,qb);
			if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
			free(qb);
		}
	}else{
		for(i=0;i<Indexer->nwords;i++){
			if(Indexer->Word[i].count){
				if(Indexer->Conf->DBMode==UDM_DBMODE_SINGLE){
					sprintf(qbuf,"INSERT INTO dict (url_id,word,intag) VALUES(%d,'%s',%d)",url_id,Indexer->Word[i].word,Indexer->Word[i].count);
				}else{
					sprintf(qbuf,"INSERT INTO ndict (url_id,word_id,intag) VALUES(%d,%d,%d)",url_id,UdmStrCRC32(Indexer->Word[i].word),Indexer->Word[i].count);
				}
				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
			}
		}
	}

	/* Commit */
	if(Indexer->Conf->DBUseLock){
		switch(Indexer->Conf->DBType){
			case UDM_DB_PGSQL:
				sql_query(Indexer,"END WORK");
				break;
			case UDM_DB_ORACLE:
			case UDM_DB_SAPDB:
				((DB*)(Indexer->db))->commit_fl = 0;
				sql_query(Indexer,"COMMIT");
				break;
			default:
				break;
		}
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	}
	return(IND_OK);
}


int UdmStoreWords(UDM_AGENT * Indexer,int url_id, int site_id, const char * cat, const char * tag, int status){
	int res;
	switch(Indexer->Conf->DBMode){
		case UDM_DBMODE_CACHE:
			/* It's not reentrant, let's lock it */
			if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_LOCK,UDM_LOCK_CACHE);
			res=UdmStoreWordsCache(Indexer,url_id,site_id,cat,tag);
			if(Indexer->Conf->LockProc)Indexer->Conf->LockProc(UDM_UNLOCK,UDM_LOCK_CACHE);
			break;
		case UDM_DBMODE_MULTI:
		case UDM_DBMODE_MULTI_CRC:
			res=StoreWordsMulti(Indexer,url_id,status);
			break;
		case UDM_DBMODE_SINGLE:
		case UDM_DBMODE_SINGLE_CRC:
		default:
			res=StoreWordsSingle(Indexer,url_id,status);
			break;
	}
	return(res);
}

int UdmDeleteAllFromDict(UDM_AGENT *Indexer){
char qbuf[UDMSTRSIZ];
int i,last=0;
	switch(Indexer->Conf->DBMode){
	case UDM_DBMODE_MULTI:
		for(i=MINDICT;i<MAXDICT;i++){
			if(last!=DICTNUM(i)){
				if (Indexer->Conf->DBType == UDM_DB_ORACLE)
					sprintf(qbuf,"TRUNCATE TABLE dict%d",DICTNUM(i));
				else
					sprintf(qbuf,"DELETE FROM dict%d",DICTNUM(i));

				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
				last=DICTNUM(i);
			}
		}
		break;
	case UDM_DBMODE_MULTI_CRC:
		for(i=MINDICT;i<MAXDICT;i++){
			if(last!=DICTNUM(i)){
				if (Indexer->Conf->DBType == UDM_DB_ORACLE)
					sprintf(qbuf,"TRUNCATE TABLE ndict%d",DICTNUM(i));
				else
					sprintf(qbuf,"DELETE FROM ndict%d",DICTNUM(i));
	
				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
				last=DICTNUM(i);
			}
		}
		break;
	case UDM_DBMODE_SINGLE_CRC:
		if (Indexer->Conf->DBType == UDM_DB_ORACLE)
			sprintf(qbuf,"TRUNCATE TABLE ndict");
		else
			sprintf(qbuf,"DELETE FROM ndict");
    	
		sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
		break;
	default:
		if (Indexer->Conf->DBType == UDM_DB_ORACLE)
			sprintf(qbuf,"TRUNCATE TABLE dict");
		else
			sprintf(qbuf,"DELETE FROM dict");

		sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
		break;
	}
	return(IND_OK);
}


/***************** CrossWords *******************************/

static int UdmDeleteAllFromCrossDict(UDM_AGENT * Indexer){
	char qbuf[1024];
	char table[64]="ncrossdict";
	int crcmode=1;

	if((Indexer->Conf->DBMode==UDM_DBMODE_SINGLE)||(Indexer->Conf->DBMode==UDM_DBMODE_MULTI)){
		strcpy(table,"crossdict");
		crcmode=0;
	}
	sprintf(qbuf,"DELETE FROM %s",table);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}


int UdmDeleteCrossWordFromURL(UDM_AGENT * Indexer,int url_id,int ref_id){
	char qbuf[1024];
	char table[64]="ncrossdict";
	int crcmode=1;

	if((!url_id)&&(!ref_id))
		return(0);

	if((Indexer->Conf->DBMode==UDM_DBMODE_SINGLE)||(Indexer->Conf->DBMode==UDM_DBMODE_MULTI)){
		strcpy(table,"crossdict");
		crcmode=0;
	}

	if(url_id){
		sprintf(qbuf,"DELETE FROM %s WHERE url_id=%d",table,url_id);
	}else{
		sprintf(qbuf,"DELETE FROM %s WHERE ref_id=%d",table,ref_id);
	}
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}


int UdmStoreCrossWords(UDM_AGENT * Indexer,int url_id){
	size_t i;
	char qbuf[1024];
	char table[64]="ncrossdict";
	int crcmode=1;
	const char * lasturl="scrap";

	UdmDeleteCrossWordFromURL(Indexer,0,url_id);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	if(Indexer->ncrosswords==0)return(IND_OK);

	if((Indexer->Conf->DBMode==UDM_DBMODE_SINGLE)||(Indexer->Conf->DBMode==UDM_DBMODE_MULTI)){
		strcpy(table,"crossdict");
		crcmode=0;
	}
	
	for(i=0;i<Indexer->ncrosswords;i++){
		if(strcmp(lasturl,Indexer->CrossWord[i].url)){
			Indexer->CrossWord[i].referree_id=UdmFindURL(Indexer,Indexer->CrossWord[i].url);
			if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
			lasturl=Indexer->CrossWord[i].url;
		}
	}

	/* Begin transacttion/lock */
	if(Indexer->Conf->DBUseLock){
		switch(Indexer->Conf->DBType){
			case UDM_DB_MYSQL:
				sprintf(qbuf,"LOCK TABLES %s WRITE",table);
				sql_query(Indexer,qbuf);
				break;
			case UDM_DB_PGSQL:
				sql_query(Indexer,"BEGIN WORK");
				break;
			case UDM_DB_ORACLE:
			case UDM_DB_SAPDB:
				((DB*)(Indexer->db))->commit_fl = 1;
				sql_query(Indexer,"COMMIT");
				break;
			default:
				break;
		}
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	}

	/* Insert new words */
	for(i=0;i<Indexer->ncrosswords;i++){
		if(Indexer->CrossWord[i].count){
			if(Indexer->CrossWord[i].referree_id){
				if(crcmode){
					sprintf(qbuf,"INSERT INTO %s (ref_id,url_id,word_id,intag) VALUES(%d,%d,%d,%d)",table,url_id,Indexer->CrossWord[i].referree_id,UdmStrCRC32(Indexer->CrossWord[i].word),Indexer->CrossWord[i].count);
				}else{
					sprintf(qbuf,"INSERT INTO %s (ref_id,url_id,word,intag) VALUES(%d,%d,'%s',%d)",table,url_id,Indexer->CrossWord[i].referree_id,Indexer->CrossWord[i].word,Indexer->CrossWord[i].count);
				}
				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
			}		
		}
	}

	/* COMMIT/UNLOCK */
	if(Indexer->Conf->DBUseLock){
		switch(Indexer->Conf->DBType){
			case UDM_DB_MYSQL:
				sql_query(Indexer,"UNLOCK TABLES");
				break;
			case UDM_DB_PGSQL:
				sql_query(Indexer,"END WORK");
				break;
			case UDM_DB_ORACLE:
			case UDM_DB_SAPDB:
				((DB*)(Indexer->db))->commit_fl = 0;
				sql_query(Indexer,"COMMIT");
				break;
			default:
				break;
		}
		if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	}
	return(IND_OK);
}




/************************ URLs ***********************************/

int UdmFindURL(UDM_AGENT *Indexer, char * url){
	int i,res=0;
	char *o;
	char qbuf[1024];
	char e_url[UDM_URLSIZE*4];

	if(Indexer->Conf->use_crc32_url_id){
		/* Auto generation of rec_id */
		/* using CRC32 algorythm     */
		res=UdmStrCRC32(url);
	}else{
		/* Escape URL string */
		UdmDBEscStr(Indexer->Conf->DBType,e_url,url);
		sprintf(qbuf,"SELECT rec_id FROM url WHERE url='%s'",e_url);
		((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db))return(0);
		for(i=0;i<SQL_NUM_ROWS(((DB*)(Indexer->db))->res);i++){
			if((o=sql_value(((DB*)(Indexer->db))->res,i,0))){
				res=atoi(o);
				break;
			}
		}
		SQL_FREE(((DB*)(Indexer->db))->res);
	}
	return(res);
}


int UdmAddURL(UDM_AGENT *Indexer,char *url,int referrer,int hops, char * msg_id, char * tag, char * category){
	char e_url[UDM_URLSIZE*4]="";
	int next_url_id=0;
	char qbuf[UDMSTRSIZ]="AddURL";
	char emp[]="";

	if(!tag)tag=emp;
	if(!category)category=emp;

	/* Escape URL string */
	UdmDBEscStr(Indexer->Conf->DBType,e_url,url);
	
	if(Indexer->Conf->use_crc32_url_id){
		/* Auto generation of rec_id */
		/* using CRC32 algorythm     */
		int rec_id=UdmStrCRC32(url);
#ifdef NEWS_EXT
		sprintf(qbuf,"INSERT INTO url (rec_id,url,referrer,hops,crc32,last_index_time,next_index_time,status,msg_id,tag,category) VALUES (%d,'%s',%d,%d,0,%d,%d,0,'%s','%s','%s')",rec_id,e_url,referrer,hops,(int)now(),(int)now(),msg_id,tag,category);
#else	
		sprintf(qbuf,"INSERT INTO url (rec_id,url,referrer,hops,crc32,last_index_time,next_index_time,status,tag,category) VALUES (%d,'%s',%d,%d,0,%d,%d,0,'%s','%s')",rec_id,e_url,referrer,hops,(int)now(),(int)now(),tag,category);
#endif
	}else{
		/* Use dabatase generated rec_id */
		/* It depends on used DBType     */
		switch(Indexer->Conf->DBType){
		case UDM_DB_MSQL:
			/* miniSQL has _seq as autoincrement value */
			((DB*)(Indexer->db))->res=sql_query(Indexer,"SELECT _seq FROM url");
			if(UdmDBErrorCode(Indexer->db)){
				return(IND_ERROR);
			}
			next_url_id=atoi(sql_value(((DB*)(Indexer->db))->res,0,0));
			SQL_FREE(((DB*)(Indexer->db))->res);
#ifdef NEWS_EXT
			sprintf(qbuf,"INSERT INTO url (url,referrer,hops,rec_id,crc32,last_index_time,next_index_time,status,msg_id,tag,category) VALUES ('%s',%d,%d,%d,0,%d,%d,0,'%s','%s','%s')",e_url,referrer,hops,next_url_id,(int)now(),(int)now(),msg_id,tag,category);
#else
			sprintf(qbuf,"INSERT INTO url (url,referrer,hops,rec_id,crc32,last_index_time,next_index_time,status,tag,category) VALUES ('%s',%d,%d,%d,0,%d,%d,0,'%s','%s')",e_url,referrer,hops,next_url_id,(int)now(),(int)now(),tag,category);
#endif
			break;

		case UDM_DB_SOLID:
		case UDM_DB_ORACLE:
		case UDM_DB_ORACLE7:
		case UDM_DB_ORACLE8:
		case UDM_DB_SAPDB:
			if (strlen(e_url)>UDM_URLSIZE)
				e_url[UDM_URLSIZE]=0;
			/* Use sequence next_url_id.nextval */
#ifdef NEWS_EXT
			sprintf(qbuf,"INSERT INTO url (url,referrer,hops,rec_id,crc32,last_index_time,next_index_time,status,msg_id,tag,category) VALUES ('%s',%d,%d,next_url_id.nextval,0,%d,%d,0,'%s','%s','%s')",e_url,referrer,hops,(int)now(),(int)now(),msg_id,tag,category);
#else
			sprintf(qbuf,"INSERT INTO url (url,referrer,hops,rec_id,crc32,last_index_time,next_index_time,status,tag,category) VALUES ('%s',%d,%d,next_url_id.nextval,0,%d,%d,0,'%s','%s')",e_url,referrer,hops,(int)now(),(int)now(),tag,category);
#endif
			break;

		case UDM_DB_MYSQL:
			/* MySQL generates itself */
		default:	
#ifdef NEWS_EXT
			sprintf(qbuf,"INSERT INTO url (url,referrer,hops,crc32,last_index_time,next_index_time,status,msg_id,tag,category) VALUES ('%s',%d,%d,0,%d,%d,0,'%s','%s','%s')",e_url,referrer,hops,(int)now(),(int)now(),msg_id,tag,category);
#else	
			sprintf(qbuf,"INSERT INTO url (url,referrer,hops,crc32,last_index_time,next_index_time,status,tag,category) VALUES ('%s',%d,%d,0,%d,%d,0,'%s','%s')",e_url,referrer,hops,(int)now(),(int)now(),tag,category);
#endif
		}
	}

	/* Exec INSERT now */
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))
		return(IND_ERROR);
	else
		return(IND_OK);
}
int UdmDeleteUrl(UDM_AGENT *Indexer,int url_id){
	char qbuf[UDMSTRSIZ];
	int res;

	if(Indexer->Conf->use_crossword&&Indexer->Conf->DBMode!=UDM_DBMODE_CACHE){
		if((res=UdmDeleteCrossWordFromURL(Indexer,0,url_id))!=IND_OK)return(res);
		if((res=UdmDeleteCrossWordFromURL(Indexer,url_id,0))!=IND_OK)return(res);
	}
	if((res=UdmDeleteWordFromURL(Indexer,url_id))!=IND_OK)return(res);
	sprintf(qbuf,"DELETE FROM url WHERE rec_id=%d",url_id);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
__INDLIB__ int UdmMarkForReindex(UDM_AGENT *Indexer){
char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"UPDATE url SET next_index_time=%d WHERE rec_id<>0 %s%s%s%s%s",(int)now(),
		Indexer->Conf->tagstr,Indexer->Conf->urlstr,Indexer->Conf->statusstr,Indexer->Conf->langstr,Indexer->Conf->catstr);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
int UdmUpdateUrl(UDM_AGENT *Indexer,int url_id,int status,int period){
char qbuf[UDMSTRSIZ];
#ifdef HAVE_ORACLE8
	sprintf(qbuf,"UPDATE url SET status=:1,next_index_time=:2 WHERE rec_id=:3");
	param_init(Indexer->db, 1, 2, 3);
	param_add(Indexer->db, status, (int)(now()+period), url_id);
#else
	sprintf(qbuf,"UPDATE url SET status=%d,next_index_time=%d WHERE rec_id=%d",status,(int)(now()+period),url_id);
#endif
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}

#ifdef NEWS_EXT
int UdmRegisterChild(UDM_AGENT *Indexer, int parent_id, int child_id)
{
	char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"insert into thread values(%d,%d)",parent_id,child_id);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
	return 0;
}
int UdmFindMsgID(UDM_AGENT *Indexer, const char * msg_id)
{
#ifdef HEIKODEBUG
FILE * inn_f = NULL;
#endif
	int i;
	int num_rows;
	char * idstring;
	char qbuf[UDMSTRSIZ];
	char msg_id_stripped[UDMSTRSIZ];
	int rec_id = -1;
	
	strncpy(msg_id_stripped,msg_id+1,strlen(msg_id)-2);
	msg_id_stripped[strlen(msg_id)-2]=0;
	/* msg_id still has the leading < and trailing > characters */
	sprintf(qbuf,"SELECT rec_id from url where msg_id='%s'",msg_id_stripped);
#ifdef HEIKODEBUG	
if((inn_f = fopen("/tmp/inn_qbuf.tmp","a")))
{
	fprintf (inn_f,"\n%s\n",qbuf);
	fclose(inn_f);
}
else
{
	fprintf(stderr,"\nCould not open file\n");
	fflush(stderr);
}
#endif
	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(0);
	num_rows = SQL_NUM_ROWS(((DB*)(Indexer->db))->res);
	for(i = 0; i < num_rows; i++)
		if((idstring=sql_value(((DB*)(Indexer->db))->res,i,0)))
			rec_id=atoi(idstring);
	SQL_FREE(((DB*)(Indexer->db))->res);
	return(rec_id);
}
int UdmDeleteAllFromThread(UDM_AGENT *Indexer){
char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"DELETE FROM thread");
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
int UdmLongUpdateUrl(UDM_AGENT *Indexer,
int url_id,int status,int changed,int size,int period,
char *tag,
time_t last_mod_time,
char *text_escaped,
char *title_escaped,
char *content_type,
char *keywords_escaped,
char *descript_escaped,
udmcrc32_t crc32,
char *lang,
char *category,
char *hd_date,
char *hd_subj,
char *hd_from,
char *hd_group,
char *hd_ref,
char *msg_id
){
/* I know, writing 8192 there is not cool... :-| */
char qbuf[UDMSTRSIZ + 8192 + (UDM_MAXTEXTSIZE*2)];
char last_index_time[64]="";

#ifdef HEIKODEBUG
FILE * inn_f = NULL;
#endif

	if(changed)sprintf(last_index_time,",last_index_time=%d",(int)now());
sprintf(qbuf,"\
UPDATE url SET \
status=%d,last_mod_time=%li,\
next_index_time=%d,\
tag='%s',txt='%s',title='%s',content_type='%s',docsize=%d,\
keywords='%s',description='%s',crc32=%d,lang='%s',\
header_date='%s',header_subj='%s',header_from='%s',header_group='%s',\
header_refs='%s',msg_id='%s' \
WHERE rec_id=%d",
	status,last_mod_time,(int)(now()+period),
	tag, text_escaped, title_escaped, UdmRTrim(content_type, " "), size,
	keywords_escaped,descript_escaped,crc32,lang,
	hd_date,hd_subj,hd_from,hd_group,hd_ref,msg_id,
	url_id);
#ifdef HEIKODEBUG	
	if((inn_f = fopen("/tmp/inn_qbuf.tmp","a")))
	{
		fprintf (inn_f,"\n-------------------------\n%s\n",qbuf);
		fclose(inn_f);
	}
	else
	{
		fprintf(stderr,"\nCould not open file\n");
		fflush(stderr);
	}
#endif
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
#else
int UdmLongUpdateUrl(UDM_AGENT *Indexer,
int url_id,int status,int changed,int size,int period,
char * tag,time_t last_mod_time,
char *text_escaped,
char *title_escaped,
char *content_type,
char *keywords_escaped,
char *descript_escaped,
udmcrc32_t crc32,
char *lang,
char *category){
char qbuf[UDMSTRSIZ];
char last_index_time[64]="";

	if(changed)sprintf(last_index_time,",last_index_time=%d",(int)now());
sprintf(qbuf,"\
UPDATE url SET \
status=%d,last_mod_time=%li,\
next_index_time=%d,\
tag='%s',txt='%s',title='%s',content_type='%s',docsize=%d,\
keywords='%s',description='%s',crc32=%d,lang='%s',category='%s' \
WHERE rec_id=%d",
	status,last_mod_time,(int)(now()+period),
	tag, text_escaped, title_escaped, UdmRTrim(content_type, " "), size,
	keywords_escaped,descript_escaped,crc32,lang,category,url_id);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}
#endif

int UdmDeleteAllFromUrl(UDM_AGENT *Indexer){
char qbuf[UDMSTRSIZ];
#ifdef HAVE_ORACLE8
	sprintf(qbuf,"TRUNCATE TABLE url");
#else
	sprintf(qbuf,"DELETE FROM url");
#endif
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}



/************************ Clones stuff ***************************/
int UdmFindOrigin(UDM_AGENT *Indexer, udmcrc32_t crc32, int size){
	int i=0,origin=0;
	char *o;
	char qbuf[UDMSTRSIZ];
	
	if (crc32==0)
		return 0;
#ifdef HAVE_ORACLE8
	sprintf(qbuf,"SELECT rec_id FROM url WHERE crc32=:1 AND (status=200 OR status=304 OR status=206) AND docsize=:2");
	param_init(Indexer->db, 1, 2, 0);
	param_add(Indexer->db, crc32, size, 0);
#else
	sprintf(qbuf,"SELECT rec_id FROM url WHERE crc32=%d AND (status=200 OR status=304 OR status=206) AND docsize=%d",crc32, size);
#endif
	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(0);
	for(i=0;i<SQL_NUM_ROWS(((DB*)(Indexer->db))->res);i++)
		if((o=sql_value(((DB*)(Indexer->db))->res,i,0)))
			if((!origin)||(origin>atoi(o)))
				origin=atoi(o);
	SQL_FREE(((DB*)(Indexer->db))->res);
	return(origin);
}


int  UdmUpdateClone(UDM_AGENT *Indexer, int url_id, int status, int period,
		char *content_type, time_t last_mod_time, udmcrc32_t crc32){

	char qbuf[UDMSTRSIZ];
	
sprintf(qbuf,
"UPDATE url \
SET crc32=%d,status=%d,content_type='%s',\
last_mod_time=%li,next_index_time=%d \
WHERE rec_id=%d", crc32, status, UdmRTrim(content_type, " ") ,\
last_mod_time,(int)(now()+period),url_id);
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	return(IND_OK);
}

static int cmpurlidint(const void *s1,const void *s2){
	return(*((const int*)s1)-*((const int*)s2));
}

int * UdmGetURLList(UDM_AGENT * query){
#ifdef HAVE_MYSQL
	MYSQL_ROW row;
#endif
	int * res,num,i;
	char qbuf[UDMSTRSIZ];

	if(query->Conf->tagstr[0] || query->Conf->statusstr[0] || query->Conf->urlstr[0] || query->Conf->langstr[0] || query->Conf->timestr[0] || query->Conf->catstr[0]){
		sprintf(qbuf,"\
SELECT rec_id \
FROM url \
WHERE (rec_id<>0) %s%s%s%s%s%s",
		query->Conf->tagstr,
		query->Conf->statusstr,
		query->Conf->urlstr,
		query->Conf->langstr,
		query->Conf->timestr,
		query->Conf->catstr);

		((DB*)(query->db))->res=sql_query(query,qbuf);
		if(UdmDBErrorCode(query->db))return(NULL);
		num=SQL_NUM_ROWS(((DB*)(query->db))->res);
		res=(int*)UdmXmalloc((num+1)*sizeof(int));
		res[0]=num;
		for(i=0;i<num;i++){
#ifdef HAVE_MYSQL
			/* mysql_data_seek is slow */
			/* We will use sequential fetch instead*/
			row=mysql_fetch_row(((DB*)(query->db))->res);
			res[i+1]=atoi(row[0]);
#else
			res[i+1]=atoi(sql_value(((DB*)(query->db))->res,i,0));
#endif
		}
		SQL_FREE(((DB*)(query->db))->res);

		qsort((void*)&res[1],(size_t)num,sizeof(int),cmpurlidint);
	}else{
		res=NULL;
	}
	return(res);
}

typedef struct {
	int url_id;
	int site_id;
} UDM_SITELIST;

static int cmpsiteid(const void *s1,const void *s2){
unsigned int n1,n2;
	n1=((const UDM_SITELIST*)s1)->site_id;
	n2=((const UDM_SITELIST*)s2)->site_id;
	if(n1==n2){
		n1=((const UDM_SITELIST*)s1)->url_id;
		n2=((const UDM_SITELIST*)s2)->url_id;
	}
	if(n1<n2)return(-1);
	if(n1>n2)return(1);
	return(0);
}


int UdmBuildExtIndex(UDM_AGENT * query){
#ifdef HAVE_MYSQL
	MYSQL_ROW row;
#endif
	int  num,i,prev,new,count;
	UDM_SITELIST * res;
	UDM_URL url_struct;
	char qbuf[UDMSTRSIZ];

	sprintf(qbuf,"SELECT rec_id,url FROM url");

	((DB*)(query->db))->res=sql_query(query,qbuf);
	if(UdmDBErrorCode(query->db))return(IND_ERROR);
	num=SQL_NUM_ROWS(((DB*)(query->db))->res);
	res=(UDM_SITELIST*)UdmXmalloc((num+1)*sizeof(UDM_SITELIST));
	for(i=0;i<num;i++){
		register char * url;
#ifdef HAVE_MYSQL
		/* mysql_data_seek is slow */
		/* We will use sequential fetch instead*/
		row=mysql_fetch_row(((DB*)(query->db))->res);
		res[i].url_id=atoi(row[0]);
		url=row[1];
#else
		res[i].url_id=atoi(sql_value(((DB*)(query->db))->res,i,0));
		url=sql_value(((DB*)(query->db))->res,i,1);
#endif
		UdmParseURL(&url_struct,url);
		res[i].site_id=UdmStrCRC32(url_struct.hostinfo);
	}
	SQL_FREE(((DB*)(query->db))->res);
	if(num==0)return(IND_OK);
	res[num].site_id=0;
	count=0;

	qsort((void*)res,(size_t)num,sizeof(UDM_SITELIST),cmpsiteid);
	prev=res[0].site_id;
	for(i=1;i<num+1;i++){
		new=res[i].site_id;
		if(new!=prev){
			printf("%08X %d/%d\n",prev,i-count,num);
			prev=new;
			count=i;
		}
	}
	return(IND_OK);
}




UDM_DOCUMENT * UdmGetDocInfo(UDM_AGENT *Indexer,int index_flags){
char urlin[UDMSTRSIZ*10]="";
char sortstr[64]="";
char updstr[64]="";
char lmtstr[64]="";
int i=0,url_num;
UDM_DOCUMENT * Result=NULL;
char qbuf[UDMSTRSIZ*10];

	if(Indexer->Conf->currow>=Indexer->Conf->nrows){
		if(Indexer->Conf->urlres)SQL_FREE(Indexer->Conf->urlres);

		url_num=URL_SELECT_CACHE;

		if(Indexer->Conf->DBUseLock){
			switch(Indexer->Conf->DBType){
				case UDM_DB_MYSQL:
					sql_query(Indexer,"LOCK TABLES url WRITE");
					break;
				case UDM_DB_PGSQL:
					sql_query(Indexer,"BEGIN WORK");
					sql_query(Indexer,"LOCK url");
					break;
				case UDM_DB_ORACLE:
					sprintf(updstr, " FOR UPDATE ");
#if HAVE_ORACLE8
					sprintf(lmtstr, " AND ROWNUM <=:2"); 
#else
					sprintf(lmtstr, " AND ROWNUM <=%d", url_num); 
#endif
					break;
				case UDM_DB_SAPDB:
					sprintf(updstr, " WITH LOCK ");
					strcpy(lmtstr, "");
					break;
				default:
					break;
			}
			if(UdmDBErrorCode(Indexer->db))return(NULL);
		}


		sprintf(sortstr,(index_flags&UDM_FLAG_EXP_FIRST)?" ORDER BY next_index_time":"");
		if (index_flags & UDM_FLAG_SORT_HOPS) {
			if (strlen(sortstr) == 0) {
				sprintf(sortstr," ORDER BY hops ASC ");
			} else {
				strcat(sortstr,", hops ASC ");
			}
		}

#ifdef HAVE_SQL_LIMIT
		sprintf(qbuf,
		"SELECT url,rec_id,docsize,status,last_index_time,hops,crc32,last_mod_time FROM url WHERE next_index_time<=%d %s%s%s%s%s%s LIMIT %d",
			(int)now(),
			Indexer->Conf->tagstr,
			Indexer->Conf->urlstr,
			Indexer->Conf->statusstr,
			Indexer->Conf->langstr,
			Indexer->Conf->catstr,
			sortstr,url_num);
#else
		((DB*)(Indexer->db))->res_limit=url_num;
#if HAVE_ORACLE8
		param_init(Indexer->db, 1, 2, 0);
		param_add(Indexer->db, (int)now(), url_num, 0);
		sprintf(qbuf,
		"SELECT url,rec_id,docsize,status,last_index_time,hops,crc32,last_mod_time FROM url WHERE next_index_time<=:1 %s%s%s%s%s%s%s%s",
			Indexer->Conf->tagstr,
			Indexer->Conf->urlstr,
			Indexer->Conf->statusstr,
			Indexer->Conf->langstr,
			Indexer->Conf->catstr,
			lmtstr,sortstr,updstr);
#else
		sprintf(qbuf,
		"SELECT url,rec_id,docsize,status,last_index_time,hops,crc32,last_mod_time FROM url WHERE next_index_time<=%d %s%s%s%s%s%s%s%s",
			(int)now(),
			Indexer->Conf->tagstr,
			Indexer->Conf->urlstr,
			Indexer->Conf->statusstr,
			Indexer->Conf->langstr,
			lmtstr,sortstr,
			Indexer->Conf->catstr,
			updstr);
#endif
#endif
		Indexer->Conf->urlres=(void*)sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db)){
			return(NULL);
		}
		Indexer->Conf->nrows=SQL_NUM_ROWS(((UDB_RES*)(Indexer->Conf->urlres)));
		Indexer->Conf->currow=0;
		if(!Indexer->Conf->nrows){
			if(Indexer->Conf->DBUseLock){
				switch(Indexer->Conf->DBType){
					case UDM_DB_MYSQL:
						sql_query(Indexer,"UNLOCK TABLES");
						break;
					case UDM_DB_PGSQL:
						sql_query(Indexer,"END WORK");
						break;
					default:
						break;
				}
			}
			return(NULL);
		}
		urlin[0]=0;
		
		for(i=0;i<Indexer->Conf->nrows;i++){
#ifdef  HAVE_SQL_IN
			if(urlin[0])strcat(urlin,",");
			strcat(urlin,sql_value(((UDB_RES*)(Indexer->Conf->urlres)),i,1));
#else
			sprintf(qbuf,"UPDATE url SET next_index_time=%d WHERE rec_id=%d",(int)(now()+URL_LOCK_TIME),
				atoi(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),i,1)));
			sql_query(Indexer,qbuf);
			if(UdmDBErrorCode(Indexer->db)){
				return(NULL);
			}
#endif
		}
#ifdef HAVE_SQL_IN
		sprintf(qbuf,"UPDATE url SET next_index_time=%d WHERE rec_id in (%s)",(int)(now()+URL_LOCK_TIME),urlin);
		sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(Indexer->db)){
			return(NULL);
		}
#endif
		if(Indexer->Conf->DBUseLock){
			switch(Indexer->Conf->DBType){
				case UDM_DB_MYSQL:
					sql_query(Indexer,"UNLOCK TABLES");
					break;
				case UDM_DB_PGSQL:
					sql_query(Indexer,"END WORK");
					break;
				default:
					break;
			}
			if(UdmDBErrorCode(Indexer->db))return(NULL);
		}
	}
	Result=(UDM_DOCUMENT *)UdmXmalloc(sizeof(UDM_DOCUMENT));
	Result->content_type=NULL;
	Result->title=NULL;
	Result->text=NULL;
	Result->last_index_time=0;
	Result->next_index_time=0;
	Result->keywords=NULL;
	Result->description=NULL;
	Result->content=NULL;
	Result->crc32=0;
	Result->url=strdup(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,0));
	Result->url_id=atoi(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,1));
	Result->size=atoi(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,2));
	Result->status=atoi(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,3));
	Result->last_index_time=atoi(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,4));
	Result->hops=atoi(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,5));
	Result->crc32=strtol(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,6), NULL, 10);
	Result->last_mod_time=atol(sql_value(((UDB_RES*)(Indexer->Conf->urlres)),Indexer->Conf->currow,7));
	Indexer->Conf->currow++;
	return(Result);
}


void UdmFreeUrlRes(UDM_ENV *Conf) {
  if(Conf->urlres)SQL_FREE(Conf->urlres);
  return;
}


/************************************************************/
/* Misc functions                                           */
/************************************************************/

typedef struct stat_struct {
	int status;
	int expired;
	int total;
} UDM_STAT;

int UdmDBImportAffixes(UDM_AGENT * Indexer, int LCharset){
int suffixes,i;
void *db;
    db=Indexer->db;
    ((DB*)db)->res=sql_query(Indexer,"SELECT flag,type,lang,mask,find,repl FROM affix");
    if(((DB*)db)->errcode)return(((DB*)db)->errcode);

    suffixes=SQL_NUM_ROWS(((DB*)db)->res);
    for(i=0;i<suffixes;i++){
        char *t_type;
	char *t_flag;
	char *t_lang;
	char *t_mask;
	char *t_find;
	char *t_repl;

	t_flag=sql_value(((DB*)db)->res,i,0);		
	t_type=UdmRTrim(sql_value(((DB*)db)->res,i,1), " ");		
	t_lang=UdmRTrim(sql_value(((DB*)db)->res,i,2), " ");
	t_mask=UdmRTrim(sql_value(((DB*)db)->res,i,3), " ");
	t_find=UdmRTrim(sql_value(((DB*)db)->res,i,4), " ");
	t_repl=UdmRTrim(sql_value(((DB*)db)->res,i,5), " ");
	
	UdmAddAffix(Indexer->Conf,*t_flag,t_lang,t_mask,t_find,t_repl,*t_type);
    }
    SQL_FREE(((DB*)db)->res);
    return(0);
}

int UdmImportDictionaryFromDB(UDM_AGENT * Indexer){
char qbuf[UDMSTRSIZ];
int found;
int i;
void * db;

#ifdef HAVE_MYSQL
	MYSQL_ROW row;
#endif

	db=Indexer->db;
	sprintf(qbuf,"SELECT word,flag,lang FROM spell");
	((DB*)db)->res=sql_query(Indexer,qbuf);
	if(((DB*)db)->errcode) return(((DB*)db)->errcode);

	found=SQL_NUM_ROWS(((DB*)db)->res);
	
	for (i=0; i<found; i++) {
#ifdef HAVE_MYSQL
	    /* mysql_data_seek is slow */
	    /* We will use sequential fetch instead*/
	    row=mysql_fetch_row(((DB*)db)->res);
	    UdmAddSpell(Indexer->Conf,row[0],row[1],row[2]);
#else
	    UdmAddSpell(Indexer->Conf,
			sql_value(((DB*)db)->res,i,0),
			sql_value(((DB*)db)->res,i,1),
			sql_value(((DB*)db)->res,i,2));
#endif
	}
	    
	SQL_FREE(((DB*)db)->res);	

	return(0);
}

UDM_SPELL * UdmFindWordDB(UDM_AGENT * Indexer,const char *word){
	char qbuf[UDMSTRSIZ];
	int found;
	int i;
	void * db;
	char *c_flag=NULL;
	char *c_lang=NULL;
	char *t_flag=NULL;
	char *t_lang=NULL;

	db=Indexer->db;
	sprintf(qbuf,"SELECT flag,lang FROM spell WHERE word='%s'", word);
	((DB*)db)->res=sql_query(Indexer,qbuf);
	if(((DB*)db)->errcode) {
	    printf("Warning: %s<br>Ispell mode cannot work properly<br>\n",UdmDBErrorMsg(db));
	    return(NULL);
	}

	found=SQL_NUM_ROWS(((DB*)db)->res);
	
	for (i=0; i<found; i++) {
	    c_flag=sql_value(((DB*)db)->res,i,0);		
	    c_lang=sql_value(((DB*)db)->res,i,1);
	    if (strlen(c_flag) || (!i)) {
		t_flag=c_flag;
		t_lang=c_lang;
	    }
	}
	    
	SQL_FREE(((DB*)db)->res);
	    
	if (found) {
	    Indexer->t_Spell.word=strdup(word);
	    strncpy(Indexer->t_Spell.flag,t_flag,10);
	    strncpy(Indexer->t_Spell.lang,t_lang,2);
	    return (&Indexer->t_Spell);
	} else return(NULL);
}

int UdmInsertAffix(UDM_AGENT *Indexer,int flag,const char *lang,const char *mask,const char *find,const char *repl,const char *type){
	char qbuf[UDMSTRSIZ];
	char escmask[UDMSTRSIZ];
	char escfind[UDMSTRSIZ];
	char escrepl[UDMSTRSIZ];

	UdmDBEscStr(Indexer->Conf->DBType,escmask,mask);
	UdmDBEscStr(Indexer->Conf->DBType,escfind,find);
	UdmDBEscStr(Indexer->Conf->DBType,escrepl,repl);
	sprintf(qbuf,"INSERT INTO affix (flag,type,lang,mask,find,repl) VALUES ('%c','%s','%s','%s','%s','%s')",flag,type,lang,escmask,escfind,escrepl);
	sql_query(Indexer,qbuf);
	return(UdmDBErrorCode(Indexer->db));
}

int UdmInsertSpell(UDM_AGENT *Indexer,const char *flag,const char *lang,const char *word){
	char qbuf[UDMSTRSIZ];
	char escword[UDMSTRSIZ];

	UdmDBEscStr(Indexer->Conf->DBType,escword,word);

	sprintf(qbuf,"INSERT INTO spell (word,flag,lang) VALUES ('%s','%s','%s')",escword,flag,lang);
	sql_query(Indexer,qbuf);return(UdmDBErrorCode(Indexer->db));
}

__INDLIB__ int UdmClearSpell(UDM_AGENT * Indexer){
	char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"DELETE FROM spell");
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db)){
		return(IND_ERROR);
	}
	sprintf(qbuf,"DELETE FROM affix");
	sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db)){
		return(IND_ERROR);
	}
	return(IND_OK);
}

__INDLIB__ int UdmGetDocCount(UDM_AGENT * Indexer){
	char qbuf[200]="";
	int j,res=0;
	char * s;

	sprintf(qbuf,NDOCS_QUERY);
	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(0);
	j=SQL_NUM_ROWS(((DB*)(Indexer->db))->res);
	if(j){
		s=sql_value(((DB*)(Indexer->db))->res,0,0);
		if(s)res=atoi(s);
	}
	SQL_FREE(((DB*)(Indexer->db))->res);
	return(res);
}


__INDLIB__ int UdmGetStatistics(UDM_AGENT *Indexer){
	int i,j;
	char qbuf[UDMSTRSIZ];
	int expired_total=0;
	int total_total=0;

	if(!Indexer->Conf->StatInfo)return(IND_OK);

#if (HAVE_MYSQL || HAVE_PGSQL || HAVE_ORACLE8 || HAVE_ORACLE7 || HAVE_SAPDB)
#if   (HAVE_MYSQL)
	sprintf(qbuf,"SELECT status,sum(next_index_time<=%d),count(*) FROM url WHERE rec_id<>0 %s%s%s%s%s GROUP BY status",(int)now(),
		Indexer->Conf->tagstr,
		Indexer->Conf->urlstr,
		Indexer->Conf->statusstr,
		Indexer->Conf->langstr,
		Indexer->Conf->catstr);
#elif (HAVE_PGSQL)
	sprintf(qbuf,"SELECT status,sum(case when next_index_time<=%d then 1 else 0 end),count(*) FROM url WHERE rec_id<>0 %s%s%s%s%s GROUP BY status",(int)now(),
		Indexer->Conf->tagstr,
		Indexer->Conf->urlstr,
		Indexer->Conf->statusstr,
		Indexer->Conf->langstr,
		Indexer->Conf->catstr);
#elif (HAVE_ORACLE8 || HAVE_ORACLE7 || HAVE_SAPDB)
	sprintf(qbuf,"SELECT status, SUM(DECODE(SIGN(%d-next_index_time),-1,0,1,1)), count(*) FROM url WHERE rec_id<>0 %s%s%s%s%s GROUP BY status",(int)now(),
		Indexer->Conf->tagstr,
		Indexer->Conf->urlstr,
		Indexer->Conf->statusstr,
		Indexer->Conf->langstr,
		Indexer->Conf->catstr);

#endif
	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	if((j=SQL_NUM_ROWS(((DB*)(Indexer->db))->res))){
		for(i=0;i<j;i++){
			int status,expired,total;
			status=atoi(sql_value(((DB*)(Indexer->db))->res,i,0));
			expired=atoi(sql_value(((DB*)(Indexer->db))->res,i,1));
			total=atoi(sql_value(((DB*)(Indexer->db))->res,i,2));
			total_total+=total;
			expired_total+=expired;
			Indexer->Conf->StatInfo(Indexer->handle,status,expired,total,UdmHTTPErrMsg(status));
		}
	}
	SQL_FREE(((DB*)(Indexer->db))->res);
#elif (HAVE_IBASE||HAVE_MSQL || HAVE_IODBC || HAVE_UNIXODBC || HAVE_SOLID || HAVE_VIRT || HAVE_EASYSOFT)
	sprintf(qbuf,"SELECT status,next_index_time FROM url WHERE rec_id>0 %s%s%s%s%s",
		Indexer->Conf->tagstr,
		Indexer->Conf->urlstr,
		Indexer->Conf->statusstr,
		Indexer->Conf->langstr,
		Indexer->Conf->catstr);

	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	if(SQL_NUM_ROWS(((DB*)(Indexer->db))->res)){
		UDM_STAT *udmstat=NULL;
		int n,num=0;
		
		n=now();
		for(i=0;i<SQL_NUM_ROWS(((DB*)(Indexer->db))->res);i++){
			for(j=0;j<num;j++){
				if(udmstat[j].status==atoi(sql_value(((DB*)(Indexer->db))->res,i,0))){
					if(atoi(sql_value(((DB*)(Indexer->db))->res,i,1))<=n)
						udmstat[j].expired++;
					udmstat[j].total++;
					break;
				}
			}
			if(j==num){
			
				if(!num)
					udmstat=(UDM_STAT *)UdmXmalloc(sizeof(UDM_STAT)*(num+1));
				else
					udmstat=(UDM_STAT *)UdmXrealloc(udmstat,sizeof(UDM_STAT)*(num+1));
				udmstat[j].status=atoi(sql_value(((DB*)(Indexer->db))->res,i,0));
				udmstat[j].expired=0;
				if(atoi(sql_value(((DB*)(Indexer->db))->res,i,1))<=n)
					udmstat[j].expired++;
				udmstat[j].total=1;
				num++;
			}
		}
		for(i=0; i<num; i++){
			Indexer->Conf->StatInfo(Indexer->handle,
				udmstat->status,udmstat->expired,udmstat->total,
				UdmHTTPErrMsg(udmstat->status));
			total_total+=udmstat->total;
			expired_total+=udmstat->expired;
			udmstat++;
		}
	}
	SQL_FREE(((DB*)(Indexer->db))->res);
#endif		
	Indexer->Conf->StatInfo(Indexer->handle,-1,expired_total,total_total,"");
	return(IND_OK);
}



__INDLIB__ int UdmGetReferers(UDM_AGENT *Indexer){
int i,j;
char qbuf[UDMSTRSIZ];
	sprintf(qbuf,"SELECT url.status,url2.url,url.url FROM url,url url2 WHERE url.referrer=url2.rec_id %s%s%s%s%s",
		Indexer->Conf->tagstr,
		Indexer->Conf->urlstr,
		Indexer->Conf->statusstr,
		Indexer->Conf->langstr,
		Indexer->Conf->catstr);
	((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
	j=SQL_NUM_ROWS(((DB*)(Indexer->db))->res);
	for(i=0;i<j;i++){
		if(Indexer->Conf->RefInfo)Indexer->Conf->RefInfo(
			atoi(sql_value(((DB*)(Indexer->db))->res,i,0)),
			sql_value(((DB*)(Indexer->db))->res,i,2),
			sql_value(((DB*)(Indexer->db))->res,i,1)
		);
	}
	SQL_FREE(((DB*)(Indexer->db))->res);
	return(IND_OK);
}

int UdmClearDB(UDM_AGENT *Indexer){
int i,j,err;
char qbuf[UDMSTRSIZ];

	if(!Indexer->Conf->tagstr[0]&&!Indexer->Conf->urlstr[0]&&!Indexer->Conf->statusstr[0]&&!Indexer->Conf->langstr[0]&&!Indexer->Conf->catstr[0]){
#ifdef NEWS_EXT
		if((IND_OK!=(err=UdmDeleteAllFromThread(Indexer))))return(err);
#endif
		/*
		if(Indexer->Conf->DBMode==UDM_DBMODE_CACHE){
				UdmClearCacheTree();
		}
		*/

		if(Indexer->Conf->use_crossword&&Indexer->Conf->DBMode!=UDM_DBMODE_CACHE){
			if((IND_OK!=(err=UdmDeleteAllFromCrossDict(Indexer))))return(err);
		}
		if((IND_OK!=(err=UdmDeleteAllFromDict(Indexer))))return(err);
		if((IND_OK!=(err=UdmDeleteAllFromUrl(Indexer))))return(err);
		if((IND_OK!=(err=UdmDeleteAllFromRobots(Indexer))))return(err);
	}else{
		j=0;
		while(1){
			int last=0;
			char urlin[UDMSTRSIZ]="";
			char limit[100]="";
#ifdef HAVE_SQL_LIMIT
			sprintf(limit," LIMIT %d",URL_DELETE_CACHE);
#endif
			sprintf(qbuf,"SELECT rec_id FROM url WHERE rec_id<>0 %s%s%s%s%s%s",
				Indexer->Conf->tagstr,
				Indexer->Conf->urlstr,
				Indexer->Conf->statusstr,
				Indexer->Conf->langstr,
				Indexer->Conf->catstr,
				limit);

			((DB*)(Indexer->db))->res=sql_query(Indexer,qbuf);
			if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
			if(SQL_NUM_ROWS(((DB*)(Indexer->db))->res)){
				if(Indexer->Conf->DBMode==UDM_DBMODE_CACHE){
					if(IND_OK!=UdmOpenCache(Indexer->Conf,UdmDBErrorMsg(Indexer->db))){
						return(IND_ERROR);
					}
					for(i=0;i<SQL_NUM_ROWS(((DB*)(Indexer->db))->res);i++){
						if(IND_OK!=UdmDeleteUrl(Indexer,atoi(sql_value(((DB*)(Indexer->db))->res,i,0))))
							return(IND_ERROR);
					}
					continue;
				}
#ifdef HAVE_SQL_IN
				urlin[0]=0;
				for(i=0;i<SQL_NUM_ROWS(((DB*)(Indexer->db))->res);i++){
					if(i)strcat(urlin,",");
					strcat(urlin,sql_value(((DB*)(Indexer->db))->res,i,0));
				}
				j+=i;
				switch(Indexer->Conf->DBMode){
				case UDM_DBMODE_MULTI:
					for(i=MINDICT;i<MAXDICT;i++){
						if(last!=DICTNUM(i)){
							sprintf(qbuf,"DELETE FROM dict%d WHERE url_id in (%s)",DICTNUM(i),urlin);
							sql_query(Indexer,qbuf);
							if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
							last=DICTNUM(i);
						}
					}
					break;
				case UDM_DBMODE_MULTI_CRC:
					for(i=MINDICT;i<MAXDICT;i++){
						if(last!=DICTNUM(i)){
							sprintf(qbuf,"DELETE FROM ndict%d WHERE url_id in (%s)",
								DICTNUM(i),urlin);
							sql_query(Indexer,qbuf);
							if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
							last=DICTNUM(i);
						}
					}
					break;
				case UDM_DBMODE_CACHE:
				
					break;
				default:
					sprintf(qbuf,"DELETE FROM dict WHERE url_id in (%s)",urlin);
					sql_query(Indexer,qbuf);
					if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);
					break;
				}
				sprintf(qbuf,"DELETE FROM url WHERE rec_id in (%s)",urlin);
				sql_query(Indexer,qbuf);
				if(UdmDBErrorCode(Indexer->db))return(IND_ERROR);

				SQL_FREE(((DB*)(Indexer->db))->res);
#else
				for(i=0;i<SQL_NUM_ROWS(((DB*)(Indexer->db))->res);i++)
					if(IND_OK!=UdmDeleteUrl(Indexer,atoi(sql_value(((DB*)(Indexer->db))->res,i,0))))
						return(IND_ERROR);
				j+=i;
#endif
				sprintf(qbuf,"%d",j);
			}else{
				SQL_FREE(((DB*)(Indexer->db))->res);
				break;
			}
		}
	}
	return(IND_OK);
}

/********************* Categories ************************************/
UDM_CATEGORY * UdmCatList(UDM_AGENT * Indexer,const char * addr){
	UDM_CATEGORY * r=NULL;
	int i;
	char qbuf[UDMSTRSIZ];
	DB * db;

	db=(DB*)Indexer->db;
	if(!addr)addr="";
#ifdef  HAVE_SAPDB
	sprintf(qbuf,"SELECT rec_id,path,lnk,name FROM categories WHERE path LIKE '%s__'",addr);
#else
	sprintf(qbuf,"SELECT rec_id,path,link,name FROM categories WHERE path LIKE '%s__'",addr);
#endif
	((DB*)db)->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(db))return(NULL);
	if(SQL_NUM_ROWS(((DB*)db)->res)){
		size_t nbytes;
		
		nbytes=sizeof(UDM_CATEGORY)*(SQL_NUM_ROWS(((DB*)db)->res)+1);
		r=(UDM_CATEGORY*)UdmXmalloc(nbytes);
		for(i=0;i<SQL_NUM_ROWS(((DB*)db)->res);i++){
			r[i].rec_id=atoi(sql_value(((DB*)db)->res,i,0));
			strcpy(r[i].path,sql_value(((DB*)db)->res,i,1));
			strcpy(r[i].link,sql_value(((DB*)db)->res,i,2));
			strcpy(r[i].name,sql_value(((DB*)db)->res,i,3));
			r[i+1].rec_id=0;
		}
	}
	SQL_FREE(((DB*)db)->res);
	return(r);
}

UDM_CATEGORY * UdmCatPath(UDM_AGENT * Indexer,const char * addr){
	UDM_CATEGORY * r=NULL;
	size_t i,l;
	char qbuf[UDMSTRSIZ];
	void *  db;

	db=Indexer->db;
	if(!addr)addr="";
	l=(strlen(addr)/2)+1;

	r=(UDM_CATEGORY*)UdmXmalloc(sizeof(UDM_CATEGORY)*(l+1));
	r[0].rec_id=0;

	for(i=0;i<l;i++){
		char head[128];
		r[i+1].rec_id=0;
		strncpy(head,addr,i*2);head[i*2]=0;
#ifdef  HAVE_SAPDB
		sprintf(qbuf,"SELECT rec_id,path,lnk,name FROM categories WHERE path='%s'",head);
#else
		sprintf(qbuf,"SELECT rec_id,path,link,name FROM categories WHERE path='%s'",head);
#endif
		((DB*)db)->res=sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(db))return(NULL);
		if(SQL_NUM_ROWS(((DB*)db)->res)){
			r[i].rec_id=atoi(sql_value(((DB*)db)->res,0,0));
			strcpy(r[i].path,sql_value(((DB*)db)->res,0,1));
			strcpy(r[i].link,sql_value(((DB*)db)->res,0,2));
			strcpy(r[i].name,sql_value(((DB*)db)->res,0,3));
		}
		SQL_FREE(((DB*)db)->res);
	}
	return(r);
}


/******************* Search stuff ************************************/

UDM_RESULT * UdmCloneList(UDM_AGENT * Indexer,udmcrc32_t crc32){
UDM_RESULT * Res;
int i;
char qbuf[UDMSTRSIZ];
void * db;

	db=Indexer->db;
	sprintf(qbuf,"SELECT rec_id,url,content_type,last_mod_time FROM url WHERE crc32=%d AND (status=200 OR status=304 OR status=206)",crc32);
	((DB*)db)->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(db))return(NULL);
	
	Res=(UDM_RESULT*)UdmXmalloc(sizeof(UDM_RESULT));
	Res->Doc=NULL;
	Res->num_rows=SQL_NUM_ROWS(((DB*)db)->res);

	if(!(Res->num_rows))return(Res);
	
	Res->Doc=(UDM_DOCUMENT*)UdmXmalloc(sizeof(UDM_DOCUMENT)*(Res->num_rows));

	for(i=0;i<SQL_NUM_ROWS(((DB*)db)->res);i++){
		Res->Doc[i].title=NULL;
		Res->Doc[i].text=NULL;
		Res->Doc[i].keywords=NULL;
		Res->Doc[i].description=NULL;

		Res->Doc[i].url_id=atoi(sql_value(((DB*)db)->res,i,0));
		Res->Doc[i].url=strdup(sql_value(((DB*)db)->res,i,1));
		Res->Doc[i].content_type=strdup(sql_value(((DB*)db)->res,i,2));
		Res->Doc[i].last_mod_time=atol(sql_value(((DB*)db)->res,i,3));
	}
	SQL_FREE(((DB*)db)->res);
	return(Res);
}
/********************************************************/


static UDM_SEARCHWORD * UdmFindSQL(UDM_AGENT * query,char * text){
	char qbuf[UDMSTRSIZ];
	UDM_SEARCHWORD * wrd=NULL;	
	size_t wordnum;
	int has_crosswrd=0;
	int wcounts[UDM_MAXWORDPERQUERY];

#ifdef HAVE_MYSQL
	MYSQL_ROW row;
#endif
#ifdef DEBUG_SEARCH
	unsigned long ticks;
	ticks=UdmStartTimer();
#endif

	UdmPrepare(query,text);
	bzero(wcounts,sizeof(wcounts));

	/* Now find each word */
	for(wordnum=0;wordnum<query->words_in_query;wordnum++){
		int numrows,firstnum,curnum,tnum,i,tmin,tmax,tlst=-1;
		char tablename[32]="dict";

		if((query->Conf->DBMode==UDM_DBMODE_MULTI)&&(query->word_match!=UDM_MATCH_WORD)){
			/* This is for substring search!  */
			/* In Multi mode: we have to scan */
			/* almost all tables except those */
			/* with to short words            */
			
			tmin=DICTNUM(strlen(query->words[wordnum]));
			tmax=MAXDICT;
		}else{
			tmin=tmax=DICTNUM(strlen(query->words[wordnum]));
		}

		for(tnum=tmin;tnum<=tmax;tnum++){

			if(tlst!=DICTNUM(tnum)){
				tlst=DICTNUM(tnum);		
#ifdef DEBUG_SEARCH
				ticks=UdmStartTimer();
				fprintf(stderr,"Start search for '%s'\n",query->words[wordnum]);
#endif
				switch(query->Conf->DBMode){
				case UDM_DBMODE_MULTI:
					sprintf(tablename,"dict%d",DICTNUM(tnum));
					break;
				case UDM_DBMODE_MULTI_CRC:
					sprintf(tablename,"ndict%d",DICTNUM(tnum));
					break;
				case UDM_DBMODE_SINGLE_CRC:
					strcpy(tablename,"ndict");
					break;
				default:
					break;
				}
				if((query->Conf->DBMode==UDM_DBMODE_SINGLE_CRC)||(query->Conf->DBMode==UDM_DBMODE_MULTI_CRC)){
					udmcrc32_t crc;
					crc=query->cwords[wordnum];
					if(query->Conf->tagstr[0] || query->Conf->statusstr[0] || query->Conf->urlstr[0] || query->Conf->langstr[0] || query->Conf->timestr[0] || query->Conf->catstr[0]){
						sprintf(qbuf,"\
SELECT %s.url_id,%s.intag \
FROM %s,url \
WHERE %s.word_id=%d \
AND url.rec_id=%s.url_id %s%s%s%s%s%s",
						tablename,tablename,
						tablename,tablename,
						crc,tablename,
						query->Conf->tagstr,
						query->Conf->statusstr,
						query->Conf->urlstr,
						query->Conf->langstr,
						query->Conf->timestr,
						query->Conf->catstr);
					}else{
						sprintf(qbuf,"SELECT url_id,intag FROM %s WHERE word_id=%d",tablename,crc);
					}
				}else{
					char cmparg[256];
					switch(query->word_match){	
						case UDM_MATCH_BEGIN:
							sprintf(cmparg," LIKE '%s%%'",query->words[wordnum]);
							break;
						case UDM_MATCH_END:
							sprintf(cmparg," LIKE '%%%s'",query->words[wordnum]);
							break;
						case UDM_MATCH_SUBSTR:
							sprintf(cmparg," LIKE '%%%s%%'",query->words[wordnum]);
							break;
						case UDM_MATCH_WORD:
						default:
							sprintf(cmparg,"='%s'",query->words[wordnum]);
							break;
					}
					if(query->Conf->tagstr[0]||query->Conf->statusstr[0]||query->Conf->urlstr[0]||query->Conf->langstr[0]||query->Conf->catstr[0]||query->Conf->timestr[0]){
						sprintf(qbuf,"\
SELECT %s.url_id,%s.intag \
FROM %s,url \
WHERE %s.word%s \
AND url.rec_id=%s.url_id %s%s%s%s%s%s",
						tablename,tablename,
						tablename,tablename,
						cmparg,tablename,
						query->Conf->tagstr,
						query->Conf->statusstr,
						query->Conf->urlstr,
						query->Conf->langstr,
						query->Conf->timestr,
						query->Conf->catstr);
					}else{
						sprintf(qbuf,"SELECT url_id,intag FROM %s WHERE word%s",tablename,cmparg);
					}
				}
				((DB*)(query->db))->res=sql_query(query,qbuf);
				if(UdmDBErrorCode(query->db))return(NULL);
				numrows=SQL_NUM_ROWS(((DB*)(query->db))->res);

#ifdef DEBUG_SEARCH
				ticks=UdmStartTimer()-ticks;
				fprintf(stderr,"Stop search for '%s'\t%.2f  %d found\n",query->words[wordnum],(float)ticks/1000,numrows);
#endif

				/* Add new found word to the list */
				if(!query->total_found){
					wrd=(UDM_SEARCHWORD*)UdmXmalloc((query->total_found+numrows)*sizeof(UDM_SEARCHWORD));
				}else{
					wrd=(UDM_SEARCHWORD*)UdmXrealloc(wrd,(query->total_found+numrows)*sizeof(UDM_SEARCHWORD));
				}

				firstnum=curnum=query->total_found;
				for(i=0;i<numrows;i++){
					int url_id;
					int weight;
					int fweight=0;
#ifdef HAVE_MYSQL
					/* mysql_data_seek is slow */
					/* We will use sequential fetch instead*/
					row=mysql_fetch_row(((DB*)(query->db))->res);
					url_id=atoi(row[0]);
					weight=atoi(row[1]);
#else
					url_id=atoi(sql_value(((DB*)(query->db))->res,i,0));
					weight=atoi(sql_value(((DB*)(query->db))->res,i,1));
#endif

					/* Check weight factors */
					if(query->weight_factor){
						int f;
						for(f=0;f<8;f++)fweight+=(((weight>>f)&0x01)*query->wf[f]);
					}else{
						fweight=weight&0xFFFF;
					}
					if(fweight){
						wrd[curnum].url_id=url_id;
						wrd[curnum].count=1<<query->wordorders[wordnum];
						wrd[curnum].weight=fweight;
						wrd[curnum].pos=((unsigned int)weight)>>16;;
						curnum++;
					}
				}
				SQL_FREE(((DB*)(query->db))->res);
				wcounts[wordnum]+=curnum-firstnum;
				query->total_found=curnum;
				wrd=(UDM_SEARCHWORD*)UdmXrealloc(wrd,query->total_found*sizeof(UDM_SEARCHWORD));
			}
		}	
	}




	/* Now find each word in crosstable */
	has_crosswrd=((query->Conf->use_crossword)&&(query->Conf->DBMode!=UDM_DBMODE_CACHE));
	for(wordnum=0;((has_crosswrd)&&(wordnum<query->words_in_query));wordnum++){
		int numrows,firstnum,curnum,i;
		char tablename[32]="";
#ifdef DEBUG_SEARCH
		ticks=UdmStartTimer();
		/*fprintf(stderr,"Start search for '%s'\n",rw);*/
#endif
		switch(query->Conf->DBMode){
		case UDM_DBMODE_SINGLE_CRC:
		case UDM_DBMODE_MULTI_CRC:
			strcpy(tablename,"ncrossdict");
			break;
		case UDM_DBMODE_MULTI:
		default:
			strcpy(tablename,"crossdict");
			break;
		}
		if((query->Conf->DBMode==UDM_DBMODE_SINGLE_CRC)||
			(query->Conf->DBMode==UDM_DBMODE_MULTI_CRC)){
			udmcrc32_t crc;
			crc=query->cwords[wordnum];
			if(query->Conf->tagstr[0] || query->Conf->statusstr[0] || query->Conf->urlstr[0] || query->Conf->langstr[0] || query->Conf->timestr[0] || query->Conf->catstr[0]){
				sprintf(qbuf,"\
SELECT %s.url_id,%s.intag \
FROM %s,url \
WHERE %s.word_id=%d \
AND url.rec_id=%s.url_id %s%s%s%s%s%s",
				tablename,tablename,
				tablename,tablename,
				crc,tablename,
				query->Conf->tagstr,
				query->Conf->statusstr,
				query->Conf->urlstr,
				query->Conf->langstr,
				query->Conf->timestr,
				query->Conf->catstr);
			}else{
				sprintf(qbuf,"SELECT url_id,intag FROM %s WHERE word_id=%d",tablename,crc);
			}
		}else{
			char cmparg[256];
			switch(query->word_match){	
				case UDM_MATCH_BEGIN:
					sprintf(cmparg," LIKE '%s%%'",query->words[wordnum]);
					break;
				case UDM_MATCH_END:
					sprintf(cmparg," LIKE '%%%s'",query->words[wordnum]);
					break;
				case UDM_MATCH_SUBSTR:
					sprintf(cmparg," LIKE '%%%s%%'",query->words[wordnum]);
					break;
				case UDM_MATCH_WORD:
				default:
					sprintf(cmparg,"='%s'",query->words[wordnum]);
					break;
			}
			if(query->Conf->tagstr[0]||query->Conf->statusstr[0]||query->Conf->urlstr[0]||query->Conf->langstr[0]||query->Conf->catstr[0]||query->Conf->timestr[0]){
		
				sprintf(qbuf,"\
SELECT %s.url_id,%s.intag \
FROM %s,url \
WHERE %s.word%s \
AND url.rec_id=%s.url_id %s%s%s%s%s%s",
				tablename,tablename,
				tablename,tablename,
				cmparg,tablename,
				query->Conf->tagstr,
				query->Conf->statusstr,
				query->Conf->urlstr,
				query->Conf->langstr,
				query->Conf->timestr,
				query->Conf->catstr);
			}else{
				sprintf(qbuf,"SELECT url_id,intag FROM %s WHERE word%s",tablename,cmparg);
			}
		}
		((DB*)(query->db))->res=sql_query(query,qbuf);
		if(UdmDBErrorCode(query->db))return(NULL);
		numrows=SQL_NUM_ROWS(((DB*)(query->db))->res);

#ifdef DEBUG_SEARCH
		ticks=UdmStartTimer()-ticks;
		/*fprintf(stderr,"Stop search for '%s'\t%.2f  %d found\n",rw,(float)ticks/1000,num);*/
#endif

		/* Add new found word to the list */
		if(!query->total_found){
			wrd=(UDM_SEARCHWORD*)UdmXmalloc((query->total_found+numrows)*sizeof(UDM_SEARCHWORD));
		}else{
			wrd=(UDM_SEARCHWORD*)UdmXrealloc(wrd,(query->total_found+numrows)*sizeof(UDM_SEARCHWORD));
		}

		firstnum=curnum=query->total_found;
		for(i=0;i<numrows;i++){
			int url_id;
			int weight;
			int fweight=0;
#ifdef HAVE_MYSQL
			/* mysql_data_seek is slow */
			/* We will use sequential fetch instead*/
			row=mysql_fetch_row(((DB*)(query->db))->res);
			url_id=atoi(row[0]);
			weight=atoi(row[1]);
#else
			url_id=atoi(sql_value(((DB*)(query->db))->res,i,0));
			weight=atoi(sql_value(((DB*)(query->db))->res,i,1));
#endif

			/* Check weight factors */
	
			if(query->weight_factor){
				int f;
				for(f=0;f<8;f++)fweight+=(((weight>>f)&0x01)*query->wf[f]);
			}else{
				fweight=weight&0xFFFF;
			}
			if(fweight){
				wrd[curnum].url_id=url_id;
				wrd[curnum].count=1<<query->wordorders[wordnum];
				wrd[curnum].weight=fweight;
				wrd[curnum].pos=((unsigned int)weight)>>16;;
				curnum++;
			}
		}
		SQL_FREE(((DB*)(query->db))->res);
		query->total_found=curnum;
		wcounts[wordnum]+=curnum-firstnum;
		wrd=(UDM_SEARCHWORD*)UdmXrealloc(wrd,query->total_found*sizeof(UDM_SEARCHWORD));
	}

	for(wordnum=0;wordnum<query->words_in_query;wordnum++){
		if(query->wordinfo[0])strcat(query->wordinfo,", ");
		sprintf(UDM_STREND(query->wordinfo)," %s : %d",query->words[wordnum],wcounts[wordnum]);
	}

	if(query->total_found){
		/* Sort in URL order */			
		UdmSortSearchWordsByURL(wrd,query->total_found);

		/* Group words by URL */
		UdmGroupByURL(query,wrd);
	}
	return(wrd);
}



UDM_RESULT * UdmFind(UDM_AGENT * query,char * words){
	UDM_RESULT * Res=NULL;
	int    i,j;
	size_t first=0;
	UDM_SEARCHWORD * wrd=NULL;
	char qbuf[UDMSTRSIZ];
	char text_escaped[UDMSTRSIZ];
	char text[UDMSTRSIZ];
	unsigned long ticks;
	char instr[UDMSTRSIZ]="";
	char param[UDMSTRSIZ]="";
	int hit=0;
	int display_docs=0;
#ifdef DEBUG_SEARCH
	 unsigned long debug_search_ticks;
#endif

	ticks=UdmStartTimer();
	/* Prepare search */
	/* Load all stopword tables from database                */
	/* Their names are in Indexer->Conf->stop_tables string  */

	if(query->Conf->stop_tables[0]){
		char * lt, * tok;
		char stoptables[UDMSTRSIZ]="";
		strcpy(stoptables,query->Conf->stop_tables);
		tok=UdmGetToken(stoptables," \r\n\t",&lt);
		while(tok){
			/* hidden for search.cgi */
			/* UdmLog(query,UDM_LOG_DEBUG,"Load stopword table '%s'",tok);*/
			if(UdmLoadStopList(query,tok)!=IND_OK)
				return(NULL);
			tok=UdmGetToken(NULL," \r\n\t",&lt);
		}
	}

	strncpy(text,words,sizeof(text));
	text[sizeof(text)-1]='\0';
	query->wordinfo[0]='\0';
	query->total_found=0;

	/* Escape text to track it later */
	UdmDBEscStr(query->Conf->DBType,text_escaped,words);

	/* Compose search cache file name   */
	/* taking in account all parameters */
	/* and query words themself         */
	if(query->cache_mode==UDM_CACHE_ENABLED){
		sprintf(param,"%s %s %s %s %s %s %s %s %d %d",
			query->Conf->catstr,
			query->Conf->langstr,
			query->Conf->tagstr,
			query->Conf->statusstr,
			query->Conf->urlstr,
			query->Conf->timestr,
			query->Conf->catlimit,
			query->Conf->taglimit,
			query->Conf->sitelimit,
			query->search_mode);
#ifdef DEBUG_CACHE
			fprintf(stderr,"Param: '%s'\n",param);
#endif
		/* Compose result cache file name */
		sprintf(param,"%s%s%s%08X.%08X",query->Conf->vardir,"cache",UDMSLASHSTR,UdmStrCRC32(param),UdmStrCRC32(words));
		if((wrd=UdmFindInCache(query,param,&display_docs))){
			first=0;
			hit=1;
		}
	}

	/* If not found in search cache       */
	/* Let's do actual search now:        */
	/* Get groupped by url_id words array */

	if(!hit){
		if(query->Conf->DBMode==UDM_DBMODE_CACHE){
			wrd=UdmFindCache(query,words);
		}else{
			wrd=UdmFindSQL(query,words);
			if(UdmDBErrorCode(query->db))return(NULL);
		}
	}

	/* Track query if required */
	if((query->track_mode)&UDM_TRACK_QUERIES){
		sprintf(qbuf,"INSERT INTO qtrack (qwords,qtime,found) VALUES ('%s',%d,%d)",text_escaped,(int)now(),query->total_found);
		((DB*)(query->db))->res=sql_query(query,qbuf);
		if(UdmDBErrorCode(query->db))return(NULL);
	}

	/* Allocate result*/
	Res=(UDM_RESULT*)UdmXmalloc(sizeof(UDM_RESULT));
	Res->num_rows=display_docs;
	Res->total_found=query->total_found;
	Res->Doc=NULL;
	strcpy(Res->wordinfo,query->wordinfo);

	/* Return if no words found   */
	if(!query->total_found){
		Res->work_time=UdmStartTimer()-ticks;
		return(Res);
	}
	
	/* Find curent page offsets */
	/* And If there was a request for */
	/* too large page number we will  */
	/* display the only one last doc  */
	Res->first=query->page_number*query->page_size;	
	if(Res->first>=query->total_found)Res->first=query->total_found-1;

	/* If results more than 1 page */
	/* we must cut the tail        */
	if((Res->first+query->page_size)>query->total_found){
		display_docs=query->total_found-Res->first;
	}else{
		display_docs=query->page_size;
	}
	Res->last=Res->first+display_docs-1;


	if(!hit){
#ifdef DEBUG_SEARCH
		fprintf(stderr,"Start sort by weight %d docs\n",query->total_found);
		debug_search_ticks=UdmStartTimer();
#endif
		/* Sort by the weight */
		if(query->page_number<FAST_PRESORT_PAGES){
			size_t topcount;
			topcount=query->page_size*(query->page_number+1)-1;
			if(topcount>=query->total_found)topcount=query->total_found-1;
			UdmWrdTopSort(wrd,query->total_found,topcount);
		}else{
			UdmSortSearchWordsByWeight(wrd,query->total_found);
		}
#ifdef DEBUG_SEARCH
		debug_search_ticks=UdmStartTimer()-debug_search_ticks;
		fprintf(stderr,"Stop sort by weight:\t%.2f\n",(float)debug_search_ticks/1000);
#endif
		/* Store into search result cache */
#if (WIN32|WINNT)
#else
		if((query->cache_mode==UDM_CACHE_ENABLED)&&(search_cache_size>-1)){
			fflush(stdout);
			fflush(stderr);
			if(fork()==0){
				/* Store to cache and exit program */
				UdmStoreToCache(query,param,wrd,query->total_found);
				exit(0);
			}
		}
#endif		
		first=Res->first;
	}



#ifdef DEBUG_SEARCH
	fprintf(stderr,"First: %d Found: %d Display: %d\n",first,query->total_found,display_docs);
#endif
#ifdef DEBUG_SEARCH
	fprintf(stderr,"Start URL stuff\n");
	debug_search_ticks=UdmStartTimer();
#endif

	/* Allocate an array for documents information */
	Res->num_rows=display_docs;
	Res->Doc=(UDM_DOCUMENT*)UdmXmalloc(sizeof(UDM_DOCUMENT)*(display_docs));

	instr[0]=0;
#ifdef HAVE_SQL_IN
	/* Compose IN string and set to zero url_id field */
	for(i=0;i<display_docs;i++){
		sprintf(UDM_STREND(instr),"%s%d",i?",":"",wrd[i+first].url_id);
	}

	sprintf(qbuf,"\
SELECT rec_id,url,content_type,last_mod_time,title,txt,docsize,last_index_time,next_index_time,referrer,keywords,description,crc32,category \
FROM url \
WHERE rec_id IN (%s) ORDER BY rec_id",
	instr);

	((DB*)(query->db))->res=sql_query(query,qbuf);
	if(UdmDBErrorCode(query->db)){
		UdmFreeResult(Res);
		return(NULL);
	}

	for(j=0;j<display_docs;j++) {
		for(i=0;i<SQL_NUM_ROWS(((DB*)(query->db))->res);i++) {
			if(wrd[j+first].url_id == atoi(sql_value(((DB*)(query->db))->res,i,0))) {
				Res->Doc[j].order=j+Res->first+1;
				Res->Doc[j].url_id=wrd[j+first].url_id;
				Res->Doc[j].rating=wrd[j+first].pos;
				Res->Doc[j].url=strdup(sql_value(((DB*)(query->db))->res,i,1));
				Res->Doc[j].content_type=strdup(sql_value(((DB*)(query->db))->res,i,2));
				Res->Doc[j].last_mod_time=atol(sql_value(((DB*)(query->db))->res,i,3));
				Res->Doc[j].title=strdup(sql_value(((DB*)(query->db))->res,i,4));
				Res->Doc[j].text=strdup(sql_value(((DB*)(query->db))->res,i,5));
				Res->Doc[j].size=atoi(sql_value(((DB*)(query->db))->res,i,6));
				Res->Doc[j].last_index_time=atoi(sql_value(((DB*)(query->db))->res,i,7));
				Res->Doc[j].next_index_time=atoi(sql_value(((DB*)(query->db))->res,i,8));
				Res->Doc[j].referrer=atoi(sql_value(((DB*)(query->db))->res,i,9));
				Res->Doc[j].keywords=strdup(sql_value(((DB*)(query->db))->res,i,10));
				Res->Doc[j].description=strdup(sql_value(((DB*)(query->db))->res,i,11));
				Res->Doc[j].crc32=(udmcrc32_t)strtol(sql_value(((DB*)(query->db))->res,i,12), NULL, 10);
				Res->Doc[j].category=strdup(sql_value(((DB*)(query->db))->res,i,13));
				break;
			}
		}
	}
	SQL_FREE(((DB*)(query->db))->res);
#else
	for(i=0;i<display_docs;i++){

		sprintf(qbuf,"SELECT \
rec_id,url,content_type,last_mod_time,title,txt, \
docsize,last_index_time,next_index_time, \
referrer,keywords,description,crc32 FROM url \
WHERE rec_id=%d",wrd[i+first].url_id);
		((DB*)(query->db))->res=sql_query(query,qbuf);
		if(UdmDBErrorCode((query->db))){
			/* FIXME !!! Res may be uncompleted */
			UdmFreeResult(Res);
			return(NULL);
		}
		if(SQL_NUM_ROWS(((DB*)(query->db))->res)){
			Res->Doc[i].order=i+Res->first+1;
			Res->Doc[i].url_id=wrd[i+first].url_id;
			Res->Doc[i].rating=wrd[i+first].pos;
			Res->Doc[i].url=strdup(sql_value(((DB*)(query->db))->res,0,1));
			Res->Doc[i].content_type=strdup(sql_value(((DB*)(query->db))->res,0,2));
			Res->Doc[i].last_mod_time=atol(sql_value(((DB*)(query->db))->res,0,3));
			Res->Doc[i].title=strdup(sql_value(((DB*)(query->db))->res,0,4));
			Res->Doc[i].text=strdup(sql_value(((DB*)(query->db))->res,0,5));
			Res->Doc[i].size=atoi(sql_value(((DB*)(query->db))->res,0,6));
			Res->Doc[i].last_index_time=atoi(sql_value(((DB*)(query->db))->res,0,7));
			Res->Doc[i].next_index_time=atoi(sql_value(((DB*)(query->db))->res,0,8));
			Res->Doc[i].referrer=atoi(sql_value(((DB*)(query->db))->res,0,9));
			Res->Doc[i].keywords=strdup(sql_value(((DB*)(query->db))->res,0,10));
			Res->Doc[i].description=strdup(sql_value(((DB*)(query->db))->res,0,11));
			Res->Doc[i].crc32=(udmcrc32_t)strtol(sql_value(((DB*)(query->db))->res,0,12), NULL, 10);
		}
		SQL_FREE(((DB*)(query->db))->res);
	}
#endif
	UDM_FREE(wrd);	
#ifdef DEBUG_SEARCH
	debug_search_ticks=UdmStartTimer()-debug_search_ticks;
	fprintf(stderr,"Stop URL stuff:\t\t%.2f\n",(float)debug_search_ticks/1000);
#endif
	/* first and last begins from 0, make it begin from 1 */
	Res->first++;
	Res->last++;
	Res->work_time=UdmStartTimer()-ticks;
	return(Res);
}



/***********************************************************/
/*  HTDB stuff:  Indexing of database content              */
/***********************************************************/


#ifdef USE_HTDB
static char * get_path_part(char *path,char *dst,int part){
	const char *s;
	char *e;
	int i=0;

	s=path;
	while(*s){
		if(i==part){
			if((e=strchr(s,'/')))strncpy(dst,s,(unsigned)(e-s));
			else	strcpy(dst,s);
			return(dst);
		}
		if(*s=='/')i++;
		s++;
	}
	*dst=0;
	return(dst);
}
static char * include_params(const char *src,char *path,char *dst){
	const char *s;
	char *e;
	int i;
	
	s=src;e=dst;*e=0;
	while(*s){
		if((*s=='\\')){
			*e=*(s+1);e++;*e=0;s+=2;
			continue;
		}
		if(*s!='$'){
			*e=*s;
			s++;e++;*e=0;
			continue;
		}
		s++;i=atoi(s);
		while((*s>='0')&&(*s<='9'))s++;
		get_path_part(path,e,i);
		while(*e)e++;
	}
	return(dst);
}


int UdmHTDBGet(UDM_AGENT * Indexer,char *path,char *filename,char * htdb_list, char * htdb_doc){
	char qbuf[UDMSTRSIZ]="";
	DB * db;


	db=(DB*)Indexer->db;
	Indexer->buf[0]=0;
	if(*filename){
		char real_path[UDMSTRSIZ]="";
		sprintf(real_path,"%s%s",path,filename);
		include_params(htdb_doc?htdb_doc:"",real_path,qbuf);
		db->res=sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(db))return(0);
		if(SQL_NUM_ROWS(db->res)==1){
			sprintf(Indexer->buf,"%s",sql_value(db->res,0,0));
		}else{
			sprintf(Indexer->buf,"HTTP/1.0 404 Not Found\r\n\r\n");
		}
		SQL_FREE(db->res);
	}else{
		char *s;
		int len,i;

		include_params(htdb_list,path,qbuf);
		db->res=sql_query(Indexer,qbuf);
		if(UdmDBErrorCode(db))return(0);
		sprintf(Indexer->buf,"HTTP/1.0 200 OK\r\nContent-type: text/html\r\n\r\n<HTML><BODY>\n");
		
		if(db->res){
			s=UDM_STREND(Indexer->buf);
			len=SQL_NUM_ROWS(db->res);
			for(i=0;i<SQL_NUM_ROWS(db->res);i++){
#ifdef HAVE_MYSQL
				MYSQL_ROW row;
				row=mysql_fetch_row(db->res);
				sprintf(s,"<a href=\"%s\"></a><br>\n",*row);
				s=UDM_STREND(s);
#else
				sprintf(UDM_STREND(s),"<a href=\"%s\"></a><br>\n",sql_value(db->res,i,0));
#endif
			}
			SQL_FREE(db->res);
		}
		strcat(Indexer->buf,"</BODY></HTML>\n");
	}
	return(strlen(Indexer->buf));
}
#endif


__INDLIB__ UDM_URLSTATE * UdmGetURLState(UDM_AGENT * Indexer, const char * hostinfo,time_t lmt){
	char qbuf[1024]="";
	int rows,i;
	UDM_URLSTATE * Res=NULL;
	DB * db;

	db=(DB*)Indexer->db;
	
	sprintf(qbuf,"SELECT status,url FROM url WHERE last_mod_time>=%li AND url LIKE '%s%%'",lmt,hostinfo);
	db->res=sql_query(Indexer,qbuf);
	if(UdmDBErrorCode(db))return(NULL);
	if(db->res){
		rows=SQL_NUM_ROWS(db->res);
		Res=(UDM_URLSTATE *)malloc((rows+1)*sizeof(UDM_URLSTATE));
		for(i=0;i<SQL_NUM_ROWS(db->res);i++){
#ifdef HAVE_MYSQL
			MYSQL_ROW row;
			row=mysql_fetch_row(db->res);
			Res[i].status=atoi(row[0]);
			Res[i].url=strdup(row[1]);
#else
			Res[i].status=atoi(sql_value(db->res,i,0));
			Res[i].url=strdup(sql_value(db->res,i,0));
#endif
		}
		SQL_FREE(db->res);
		Res[i].status=0;
		Res[i].url=NULL;
	}
	return(Res);
}


#endif /* HAVE_SQL */
