#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "udm_config.h"
#include "udmsearch.h"

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif


static void usage(void){

	fprintf(stderr,
"\n\
splitter from %s\n\
http://search.mnogo.ru (C) 1998-2001, LavTech Corp.\n\
\n\
Usage: splitter [OPTIONS]\n\
\n\
Options are:\n\
  -w /path      choose alternative working /var directory\n\
  -p            prepare cachelogd logs for splitter\n\
  -f xxx        start at xxx.log, where xxx is a hex number \n\
  -t xxx        stop  at xxx.log, where xxx is a hex number\n\
  -h,-?         print this help page and exit\n\
\n\
Please mail bug reports and suggestions to <general@mnogosearch.org>.\n",UdmVersion());

	return;
}


int main(int argc,char **argv){
	int ch,log;
	int from=0;
	int to=0xFFF;
	int presplit=0;
	UDM_ENV * Env;

	Env=UdmAllocEnv();

	while ((ch = getopt(argc, argv, "pt:f:w:h?")) != -1){
		printf("ch=%c\n",ch);
		switch (ch) {
			case 'p':
				presplit=1;
				break;
			case 'f':
				sscanf(optarg,"%x",&from);
				if(from<0)from=0;
				if(from>0xFFF)from=0xFFF;
				break;	
			case 't': 
				sscanf(optarg,"%x",&to);
				if(to<0)to=0;
				if(to>0xFFF)to=0xFFF;
				break;
			case 'w':
				sprintf(Env->vardir,"%s%s",optarg,UDMSLASHSTR);
				break;
			case 'h':
			case '?':
			default:
				usage();
				return 1;
				break;
		}
	}
	argc -= optind;argv += optind;

	if(argc>0){
		usage();
		return 1;
	}

	if(presplit){
		UdmPreSplitCacheLog(Env);
	}else{
		for(log=from;log<=to;log++){
			UdmSplitCacheLog(Env,log);
		}
	}
	return 0;
}
