#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>


#ifdef HAVE_WINSOCK_H
#include <winsock.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#include "udm_common.h"
#include "udm_socket.h"
#include "udm_host.h"
#include "udm_proto.h"
#include "udm_utils.h"
#include "udm_xmalloc.h"
#include "udm_mutex.h"
#include "udm_parseurl.h"

#ifndef INADDR_NONE
#define INADDR_NONE ((unsigned long) -1)
#endif

#define MAX_HOST_ADDR_SIZE	512


static int cmphost(const void * v1, const void * v2){
	return(strcmp(((const UDM_HOST_ADDR*)v1)->hostname,((const UDM_HOST_ADDR*)v2)->hostname));
}


static int host_addr_add(UDM_ENV * Conf,char *hostname, struct in_addr *addr){
	int min_id;
	size_t len;

	if((Conf->nhost_addr>=Conf->mhost_addr)&&(Conf->mhost_addr<MAX_HOST_ADDR_SIZE)){
		Conf->mhost_addr+=32;
		Conf->host_addr = UdmXrealloc(Conf->host_addr, Conf->mhost_addr*sizeof(UDM_HOST_ADDR));
		bzero(&Conf->host_addr[Conf->nhost_addr],(Conf->mhost_addr-Conf->nhost_addr)*sizeof(UDM_HOST_ADDR));
	}

	if((Conf->nhost_addr<Conf->mhost_addr)&&(Conf->mhost_addr<=MAX_HOST_ADDR_SIZE)){
		min_id = Conf->nhost_addr;
		Conf->nhost_addr++;
	}else{
		int min;
		size_t i;

		min = Conf->host_addr[0].last_used;
		min_id=0;
		/* find last used host */
		for (i=0; i<Conf->nhost_addr; i++)
			if(Conf->host_addr[i].last_used < Conf->host_addr[min_id].last_used){
				min = Conf->host_addr[i].last_used;
				min_id=i;
			}
	}

	Conf->host_addr[min_id].last_used = time(NULL);

	if(addr)
		memcpy(&Conf->host_addr[min_id].addr, addr, sizeof( struct in_addr));
	
	len = strlen(hostname);
	UDM_FREE(Conf->host_addr[min_id].hostname);
	Conf->host_addr[min_id].hostname=UdmXmalloc(len+1);
	udm_snprintf(Conf->host_addr[min_id].hostname, len+1, "%s", hostname);
	Conf->host_addr[min_id].net_errors=0;

	qsort(Conf->host_addr, Conf->nhost_addr, sizeof(UDM_HOST_ADDR), cmphost);
	return 0;
}

static int host_addr_find(UDM_ENV * Conf,char *hostname){
int l,c,r,res;

	if(!Conf->host_addr)
		return -1;
        /* Find current URL in sorted part of list */
        l=0;r=Conf->nhost_addr-1;
        while(l<=r){
                c=(l+r)/2;
		if(!(res=strcmp(Conf->host_addr[c].hostname, hostname)))
                        return(c);
                
                if(res<0)
                        l=c+1;
                else
                        r=c-1;
        }
	return -1;
}


int UdmHostLookup(UDM_ENV * Conf, UDM_CONN *connp ){
struct hostent *he;
int host_id;

	if (!connp->hostname)
		return -1;

	/*	Set port	*/
	if (connp->port) 
		connp->sin.sin_port = htons(connp->port);
	else{
		connp->err = UDM_NET_ERROR;
		return -1;
	}

	/* Check if hostname in standard numbers-and-dots notation */ 
	if ((connp->sin.sin_addr.s_addr = inet_addr(connp->hostname)) == INADDR_NONE) {

		if((host_id=host_addr_find(Conf,connp->hostname))!=-1){
			Conf->host_addr[host_id].last_used=time(NULL);
			if(Conf->host_addr[host_id].addr.s_addr){
				memcpy(&connp->sin.sin_addr, &Conf->host_addr[host_id].addr, sizeof( struct in_addr));
			}else{
				connp->err = UDM_NET_CANT_RESOLVE;
				return -1;
			}
			return 0;
		}
		
		/* Locking because gethostbyname() isn't reentrant */
		if(Conf->LockProc)Conf->LockProc(UDM_LOCK,UDM_LOCK_RESOLVE);
		he=gethostbyname(connp->hostname);

    		if (he == NULL) {
			host_addr_add(Conf,connp->hostname, NULL);
			if(Conf->LockProc)Conf->LockProc(UDM_UNLOCK,UDM_LOCK_RESOLVE);
			connp->err = UDM_NET_CANT_RESOLVE;
			return -1;
		}
		memcpy((char *)&(connp->sin.sin_addr), he->h_addr, (size_t)he->h_length);
		host_addr_add(Conf,connp->hostname, &connp->sin.sin_addr);
		if(Conf->LockProc)Conf->LockProc(UDM_UNLOCK,UDM_LOCK_RESOLVE);

	}else{
		if((host_id=host_addr_find(Conf,connp->hostname))==-1){
			if(Conf->LockProc)
				Conf->LockProc(UDM_LOCK,UDM_LOCK_RESOLVE);
			host_addr_add(Conf,connp->hostname, &connp->sin.sin_addr);
			if(Conf->LockProc)
				Conf->LockProc(UDM_UNLOCK,UDM_LOCK_RESOLVE);
		}
	}
	return 0;
}

void UdmAddServerErr(UDM_ENV * Conf,char *hostname){
int id;

	if((id=host_addr_find(Conf,hostname))!=-1)
		Conf->host_addr[id].net_errors++;
	return;
}


int UdmGetServerErr(UDM_ENV * Conf,char *hostname){
int id;

        if((id=host_addr_find(Conf,hostname))!=-1)
		return Conf->host_addr[id].net_errors;
	return 0;
}

void UdmFreeHost_addr(UDM_ENV * Conf){
	size_t i;

        if(!Conf->host_addr)
                return;

	for(i=0; i<Conf->nhost_addr; i++){
		UDM_FREE(Conf->host_addr[i].hostname);
	}
	UDM_FREE(Conf->host_addr);

	return;
}
