#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_config.h"
#include "udm_xmalloc.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_db.h"
#include "udm_env.h"
#include "udm_charset.h"
#include "udm_parser.h"
#include "udm_robots.h"
#include "udm_host.h"
#include "udm_hrefs.h"
#include "udm_server.h"
#include "udm_filter.h"
#include "udm_parseurl.h"
#include "udm_proto.h"
#include "udm_alias.h"
#include "udm_log.h"
#include "udm_mimetype.h"
#include "udm_cache.h"
#include "udm_stopwords.h"

/**************************** DBAddr ***********************************/
static int UdmStr2DBMode(char * str1){
int m;
	m = UDM_DBMODE_SINGLE;
	if(!UDM_STRNCASECMP(str1,"multi-crc"))m=UDM_DBMODE_MULTI_CRC;
	else
	if(!UDM_STRNCASECMP(str1,"crc-multi"))m=UDM_DBMODE_MULTI_CRC;
	else
	if(!UDM_STRNCASECMP(str1,"single"))m=UDM_DBMODE_SINGLE;
	else
	if(!UDM_STRNCASECMP(str1,"crc"))m=UDM_DBMODE_SINGLE_CRC;
	else
	if(!UDM_STRNCASECMP(str1,"multi"))m=UDM_DBMODE_MULTI;
	else
	if(!UDM_STRNCASECMP(str1,"word2url"))m=UDM_DBMODE_WORD2URL;
	else
	if(!UDM_STRNCASECMP(str1,"cache"))m=UDM_DBMODE_CACHE;
	return(m);
}
__INDLIB__ int UdmEnvSetDBMode(UDM_ENV * Conf,char *str){
	Conf->DBMode=UdmStr2DBMode(str);
	return(Conf->DBMode);
}
static int UdmStr2DBType(char *str1) {
int t=UDM_DB_UNK;
	if(!UDM_STRNCASECMP(str1,"msql"))t=UDM_DB_MSQL;
	else
	if(!UDM_STRNCASECMP(str1,"solid"))t=UDM_DB_SOLID;
	else
	if(!UDM_STRNCASECMP(str1,"oracle"))t=UDM_DB_ORACLE;
	else
	if(!UDM_STRNCASECMP(str1,"mssql"))t=UDM_DB_MSSQL;
	else
	if(!UDM_STRNCASECMP(str1,"mysql"))t=UDM_DB_MYSQL;
	else
	if(!UDM_STRNCASECMP(str1,"pgsql"))t=UDM_DB_PGSQL;
	else
	if(!UDM_STRNCASECMP(str1,"ibase"))t=UDM_DB_IBASE;
	else
	if(!UDM_STRNCASECMP(str1,"sapdb"))t=UDM_DB_SAPDB;
	return(t);
}
__INDLIB__ int UdmEnvSetDBAddr(UDM_ENV * Conf,char * addr){
	UDM_URL url;
	char buf[1024];
	char *s;
	int res;

	strncpy(buf,addr,sizeof(buf));
	buf[sizeof(buf)-1]=0;

	if((res=UdmParseURL(&url,buf)))
		return(res);

	Conf->DBHost=strdup(url.hostname);
	Conf->DBType=UdmStr2DBType(url.schema);
#if (WIN32|WINNT)
#else
	if(Conf->DBType==UDM_DB_IBASE){
		/* Ibase is a special case        */
		/* It's database name consists of */
		/* full path and file name        */ 
		Conf->DBName=UdmXmalloc(strlen(url.path)+1+strlen(url.filename));
		sprintf(Conf->DBName,"%s%s",url.path,url.filename);
	}else
#endif
	{
		Conf->DBName=strdup(url.path);
		sscanf(url.path,"/%[^/]s",Conf->DBName);
	}
	Conf->DBPort=url.port;
	if((s=strchr(url.auth,':'))){
		*s=0;
		Conf->DBUser=strdup(url.auth);
		Conf->DBPass=strdup(s+1);
		*s=':';
	}else{
		Conf->DBUser=strdup(url.auth);
	}
	return(0);
}


__INDLIB__ UDM_ENV * UdmAllocEnv(void){
	UDM_ENV * Conf;

	Conf=(UDM_ENV *)UdmXmalloc(sizeof(UDM_ENV));
	sprintf(Conf->vardir,"%s%s",UDM_VAR_DIR,UDMSLASHSTR);
	Conf->errcode=0;
	Conf->errstr[0]=0;
	Conf->local_charset=UDM_CHARSET_USASCII;
	Conf->force1251=0;
	Conf->max_doc_size=UDM_MAXDOCSIZE;
	Conf->user_agent[0]=0;
	Conf->extra_headers[0]=0;
	Conf->url_file_name=NULL;
	Conf->nservers=0;
	Conf->mservers=0;
	Conf->Server=NULL;
	Conf->csrv=NULL;
	Conf->naliases=0;
	Conf->maliases=0;
	Conf->Alias=NULL;
	Conf->alias_prog=NULL;
	Conf->mhrefs=0;
	Conf->nhrefs=0;
	Conf->shrefs=0;
	Conf->dhrefs=0;
	Conf->Href=NULL;	            
	Conf->have_targets=1;
	Conf->nrows=0;
	Conf->currow=0;
	Conf->Filter=NULL;
	Conf->nfilters=0;
	Conf->mfilters=0;	
	Conf->Mime=NULL;
	Conf->nmimes=0;
	Conf->nmimes=0;
	Conf->nparsers=0;
	Conf->parsers=NULL;
	Conf->nhost_addr=0;
	Conf->mhost_addr=0;
	Conf->host_addr=NULL;
	Conf->naffixes=0;
	Conf->maffixes=0;
	Conf->Affix=NULL;
	Conf->nspell=0;
	Conf->mspell=0;
	Conf->Spell=NULL;
	Conf->nstoplist=0;
	Conf->stoplist=NULL;
	Conf->use_remote_cont_type=1;
	Conf->ispell_mode=0;
	Conf->Robots.nrobots=0;
	Conf->DBHost=NULL;
	Conf->DBName=NULL;
	Conf->DBUser=NULL;
	Conf->DBPass=NULL;
	Conf->DBPort=0;
	Conf->DBType=UDM_DB_UNK;
	Conf->DBMode=UDM_DBMODE_SINGLE;
	Conf->DBUseLock=1;
	Conf->catstr[0]=0;
	Conf->langstr[0]=0;
	Conf->tagstr[0]=0;
	Conf->statusstr[0]=0;
	Conf->urlstr[0]=0;
	Conf->timestr[0]=0;

	Conf->catlimit[0]=0;
	Conf->taglimit[0]=0;
	Conf->sitelimit=0;

	Conf->ul=NULL;
	Conf->ttag=NULL;
	Conf->n_urls=0;
	Conf->URLs=0;
	Conf->urlres=0;
	Conf->ThreadInfo=NULL;
	Conf->StatInfo=NULL;
	Conf->RefInfo=NULL;
	Conf->LockProc=NULL;
	Conf->srv_tables[0]=0;
	Conf->stop_tables[0]=0;

	/* for logger */
	/* Set default facility & loglevel */                                       
	Conf->logFacility=LOG_FACILITY;                                              
	Conf->logLevel=UDM_LOG_INFO;                                                 
	Conf->is_log_open=0;
	Conf->logFD=(FILE *)NULL;
	Conf->wrd_fd=0;
	Conf->del_fd=0;
	Conf->logd_addr=NULL;
	Conf->logd_fd=0;
	Conf->use_crc32_url_id=0;
	Conf->nLang = 0;

	Conf->min_word_len=1;
	Conf->max_word_len=32;
	Conf->use_phrases=0;
	Conf->use_crossword=0;
	Conf->spellhost = NULL;
	return(Conf);
}
__INDLIB__ void UdmFreeEnv(UDM_ENV * Env){
  size_t i;
  UDM_AFFIX *Affix;

	if(Env){
	  for(i = 0; i < Env->nspell; i++) {
	    UDM_FREE(Env->Spell[i].word);
	  }
	  Affix = (UDM_AFFIX *)Env->Affix;
	  for (i = 0; i < Env->naffixes; i++) {
	    if (Affix[i].compile == 0) {
	      regfree(&(Affix[i].reg));
	    }
	  }
		UDM_FREE(Env->DBHost);
		UDM_FREE(Env->DBName);
		UDM_FREE(Env->DBUser);
		UDM_FREE(Env->DBPass);

		if (Env->csrv) {
		  if(Env->csrv->regexp)regfree(Env->csrv->regexp);
		  UDM_FREE(Env->csrv->url);
		  UDM_FREE(Env->csrv->alias);
		  UDM_FREE(Env->csrv->charset);
		  UDM_FREE(Env->csrv->category);
		  UDM_FREE(Env->csrv->tag);
		  UDM_FREE(Env->csrv->basic_auth);
		  UDM_FREE(Env->csrv->user);
		  UDM_FREE(Env->csrv->passwd);
		  UDM_FREE(Env->csrv->proxy);
		  UDM_FREE(Env->csrv->proxy_basic_auth);
		  UDM_FREE(Env->csrv->htdb_list);
		  UDM_FREE(Env->csrv->htdb_doc);
		  UDM_FREE(Env->csrv->mirror_root);
		  UDM_FREE(Env->csrv->mirror_headers);
		  UDM_FREE(Env->csrv);
		}

		UDM_FREE(Env->logd_addr);
		UDM_FREE(Env->alias_prog);
		UDM_FREE(Env->spellhost);
		UDM_FREE(Env->Affix);
		UDM_FREE(Env->Spell);
		
		UdmFreeUrlRes(Env);
		UdmFreeParsers(Env);
		UdmFreeStopList(Env);
		UdmFreeRobots(&Env->Robots);
		UdmFreeHost_addr(Env);
		UdmFreeTypes(Env);
		UdmFreeHrefs(Env);
		UdmFreeServers(Env);
		UdmFreeAliases(Env);
		UdmFreeFilters(Env);
		UdmCloseCache(Env);

		free(Env);
	}
}
__INDLIB__ int UdmEnvErrCode(UDM_ENV * Conf){
	return(Conf->errcode);
}
__INDLIB__ char * UdmEnvErrMsg(UDM_ENV * Conf){
	return(Conf->errstr);
}
