#ifndef _UDM_LOG_H
#define _UDM_LOG_H

#include "udm_config.h"
#include "udm_common.h" /* for UDM_ENV etc. */
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

/* Define default log facility */
#ifdef HAVE_SYSLOG_H
#ifndef LOG_FACILITY
#define LOG_FACILITY LOG_LOCAL7
#endif /* LOG_FACILITY */
#else
#define LOG_FACILITY 0
#endif

/* According to some recommendations, try not to exceed about 800 bytes 
   or you might have problems with old syslog implementations */
#define UDM_LOG_BUF_LEN 255

/* Verbose levels */
#define UDM_LOG_NONE	0
#define UDM_LOG_ERROR	1
#define UDM_LOG_WARN	2
#define UDM_LOG_INFO	3
#define UDM_LOG_EXTRA	4
#define UDM_LOG_DEBUG	5

extern int UdmOpenLog(UDM_ENV *Env, int log2stderr);
extern void UdmLog(UDM_AGENT *Agent, int level, const char *fmt, ...);
/* if you do not have UDM_AGENT struct yet, use UdmLog_noagent */
extern void UdmLog_noagent(UDM_ENV *Env, int level, const char *fmt, ...);
extern __INDLIB__ void UdmSetLogLevel(UDM_ENV *Env, int level);
extern __INDLIB__ void UdmSetLogFacility(UDM_ENV *Env, const char * facility);

extern __INDLIB__ int  UdmSetThreadProc(UDM_ENV * Conf,void (*_ThreadInfo)(int handle,const char *state, const char* str));
extern __INDLIB__ int  UdmSetStatProc(UDM_ENV * Conf,void (*_StatInfo)(int handle,int code, int expired, int total, const char* str));
extern __INDLIB__ int  UdmSetRefProc(UDM_ENV * Conf,void (*_RefProc)(int code,const char *url, const char *ref));


#endif /* _UDM_LOG_H */
