#!/usr/local/bin/php -q
<?php
//udmsoundex by artwells 20000815 
// me@artwells.com
// modified by Sergey Kartashoff gluke@biosys.net
// copyright GPL 
//

//a php shell script used to create a table "soundex" in the "mnoGoSearch" database
//and populate it with soundex entries and corresponding words from the dict databases

//requires multi, non-crc indexing, mysql and php 4x

//perhaps this can be incorporated into the master indexer?

//set time out high--may need adjusting for larger databases
set_time_limit(30000);

$allwords=array();

//connect to the database
// $lnk=mysql_pconnect("localhost","user","password");
$lnk=mysql_pconnect("localhost","root","");

$res=mysql_list_tables("udm",$lnk);

//step through each word in each 
// ignores words shorter than 3 characters

while($i<mysql_num_rows($res)){
	$tbl=mysql_tablename($res,$i);
	//the '3' ignores tables containing words shorter than three characters
	if(preg_match("/^dict(\d*)/",$tbl,$regs) && (($regs[1] > 3) || ($regs[1] == ''))){
		print "Checking ".$tbl."\n";
		//read the table if it passes
		if(!soundexReader($tbl)){
			print "Failed to open ".$tbl."\n";
			exit;
		}
	}
	//remember if a soundex table is found, so that it can be cleared
	//or created if it doesn't exist
	elseif($tbl=="soundex"){
		$soundex_found="yup";
	}
	$i++;
}

//make or create soundex as necessary
if(!$soundex_found){
	makeSoundex();
}
else{	
	clearSoundex();
}

unset($soundex_found);

print "Processing Words\n";

//insert each soundex into the soundex table 
while($word=array_pop($allwords)){
	if(!preg_match("/\d/",$word)){
		$sdx=soundex($word);
		if ($sdx == '0000') continue;
		print "$word: $sdx<br>\n";
		flush();

		$query="INSERT INTO soundex (soundex,word) VALUES ('$sdx','$word')";
		$res=mysql_db_query("udm",$query,$GLOBALS['lnk']);
		if(!$res){
			print mysql_error();
			exit;
		}
	}
}


print "Done\n\n";
exit;
//////////////////////////////////////////

function makeSoundex(){
	//here's what the soundex table should look like
	$query="CREATE TABLE soundex (soundex CHAR(4) default '' not null , word varchar(32) not null , PRIMARY KEY (soundex,word))";
	$res=mysql_db_query("udm",$query,$GLOBALS['lnk']);
	if(!$res){
		print mysql_error();
		exit;
	}
}

function clearSoundex(){
	//eliminate all soundex entries.  I suppose using in_array with the $all_words array
	//would make this less destructive
	$query="DELETE FROM soundex";
	$res=mysql_db_query("udm",$query,$GLOBALS['lnk']);
	if(!$res){
		print mysql_error();
		exit;
	}
}


function soundexReader($tbl){
	//from each table create an array of distinct words
	$query = "SELECT DISTINCT word from ".$tbl;
	$res=mysql_db_query("udm",$query,$GLOBALS['lnk']);
	if($err=mysql_error()){
		print $err;
		exit;
	}
	while($i<mysql_num_rows($res)){
		$arr= mysql_fetch_row($res);
		if(strlen($arr[0])>3) array_push($GLOBALS['allwords'],$arr[0]); 
		$i++;	
	}
	return true;
}

?>
