      SUBROUTINE MN_DSI
C
C     Subroutine to initialize the parameters needed for the
C     various L3 online or ZEUS displays
C
      IMPLICIT NONE
C
#if ( defined(L3DSP_SRC) || defined(ZEUSDSP_SRC) )
#include "mnpar.inc"
#include "mndsp.inc"
#endif

C
#if ( defined(L3DSP_SRC) )
C
C     Parameters for the whole L3 detector
C
      DETNAM(1) = 'L3'
      TPARL3(1) = ' '
      IPARL3(1) = 0
      PRD_L3(1) = 0.0
C
C     Parameters for the TEC
C
      DETNAM(2) = 'TECH'
C
C     Parameters for the BGO electromagnetic calorimeter
C
      DETNAM(3) = 'ECAL'
      TPAREC(1) = 'Mode'
      IPAREC(1) = 2
      PRD_EC(1) = 1
      TPAREC(2) = 'Phi low'
      IPAREC(2) = 2
      PRD_EC(2) = 0
      TPAREC(3) = 'Phi high'
      IPAREC(3) = 2
      PRD_EC(3) = 0
      TPAREC(4) = 'Theta low'
      IPAREC(4) = 2
      PRD_EC(4) = 0
      TPAREC(5) = 'Theta high'
      IPAREC(5) = 2
      PRD_EC(5) = 0
      TPAREC(6) = 'Symbol'
      IPAREC(6) = 1
      PRD_EC(6) = 0
      TPAREC(7) = 'Resolution'
      IPAREC(7) = 1
      PRD_EC(7) = 100
      TPAREC(8) = ' '
      IPAREC(8) = 0
      CALL TZERO(TKYSEC,MDSKEY)
C
C     Parameters for the hadron calorimeter
C
      DETNAM(4) = 'HCAL'
C
C     Parameters for the muon chamber
C
      DETNAM(5) = 'MUCH'
C
C     Parameters for the luminosity monitor
C
      DETNAM(6) = 'FBGO'
      TPARFB(1) = 'Mode'
      IPARFB(1) = 2
      PRD_FB(1) = 1
      TPARFB(2) = 'Side'
      IPARFB(2) = 2
      PRD_FB(2) = 0
      TPARFB(3) = 'Sector'
      IPARFB(3) = 2
      PRD_FB(3) = 0
      TPARFB(4) = 'Min Energy'
      IPARFB(4) = 1
      PRD_FB(4) = 0
      TPARFB(5) = 'Max Energy'
      IPARFB(5) = 1
      PRD_FB(5) = 0
      TPARFB(6) = ' '
      IPARFB(6) = 0
      CALL TZERO(TKYSFB,MDSKEY)
C
C     Parameters for the luminosity monitor chambers
C
      DETNAM(7) = 'FWCH'
      TPARFW(1) = 'Mode'
      IPARFW(1) = 2
      PRD_FW(1) = 1
      TPARFW(2) = 'Side'
      IPARFW(2) = 2
      PRD_FW(2) = 0
      TPARFW(3) = 'Chamber'
      IPARFW(3) = 2
      PRD_FW(3) = 0
      TPARFW(4) = 'Strip Type'
      IPARFW(4) = 2
      PRD_FW(4) = 0
      TPARFW(5) = 'Min ph'
      IPARFW(5) = 1
      PRD_FW(5) = 0
      TPARFW(6) = 'Max ph'
      IPARFW(6) = 1
      PRD_FW(6) = 0
      TPARFW(7) = ' '
      IPARFW(7) = 0
      CALL TZERO(TKYSFW,MDSKEY)
C
C     Parameters for the luminosity monitor silicon
C
      DETNAM(8) = 'FSIL'
      TPARFS(1) = 'Mode'
      IPARFS(1) = 2
      PRD_FS(1) = 1
      TPARFS(2) = 'Side'
      IPARFS(2) = 2
      PRD_FS(2) = 0
      TPARFS(3) = 'Layer'
      IPARFS(3) = 2
      PRD_FS(3) = 0
      TPARFS(4) = 'Sector'
      IPARFS(4) = 2
      PRD_FS(4) = 0
      TPARFS(5) = 'Min ph'
      IPARFS(5) = 1
      PRD_FS(5) = 0
      TPARFS(6) = 'Max ph'
      IPARFS(6) = 1
      PRD_FS(6) = 0
      TPARFS(7) = ' '
      IPARFS(7) = 0
      CALL TZERO(TKYSFS,MDSKEY)
C
      DETNAM(9) = ' '
C
#endif
#if ( defined(ZEUSDSP_SRC) )
C
C     Parameters for the whole forward detector
C
      DETNAM(1) = 'FDET'
      TPARFD(1) = 'Mode'
      IPARFD(1) = 2
      PRD_FD(1) = 1
      TPARFD(2) = 'Chambers'
      IPARFD(2) = 2
      PRD_FD(2) = 0
      TPARFD(3) = ' '
      IPARFD(3) = 0
      PRD_FD(3) = 0.0
C
C     Parameters for FTD
C
      DETNAM(2) = 'FTD'
      TPARFT(1) = 'Mode'
      IPARFT(1) = 2
      PRD_FT(1) = 3
      TPARFT(2) = 'Chamber'
      IPARFT(2) = 2
      PRD_FT(2) = 0
      TPARFT(3) = 'Layer'
      IPARFT(3) = 2
      PRD_FT(3) = 0
      TPARFT(4) = ' '
      IPARFT(4) = 0
C
C     Parameters for TRD
C
      DETNAM(3) = 'TRD'
      TPARTR(1) = 'Mode'
      IPARTR(1) = 2
      PRD_TR(1) = 1
      TPARTR(2) = 'Chamber'
      IPARTR(2) = 2
      PRD_TR(2) = 0
      TPARTR(3) = 'Anode/Cathode'
      IPARTR(3) = 2
      PRD_TR(3) = 3
      TPARTR(4) = 'Total Charge'
      IPARTR(4) = 1
      PRD_TR(4) = 0
      TPARTR(5) = 'Time above threshold'
      IPARTR(5) = 1
      PRD_TR(5) = 0
      TPARTR(6) = 'Clusters'
      IPARTR(6) = 2
      PRD_TR(6) = 0
      TPARTR(7) = ' '
      IPARTR(7) = 0
C
      DETNAM(4) = ' '
C
#endif

9000  CONTINUE
      END
