# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Define application toolbar.

# load libs
import wx

# load modules
from ids import *
from icons import mIcons
import commfce


class toolBar(wx.ToolBar):
    """ Make toolbar. """

    # ----
    def __init__(self, parent, config):
        wx.ToolBar.__init__(self, parent, style=wx.TB_FLAT|wx.TB_NODIVIDER|wx.TB_HORIZONTAL)

        self.config = config
        self.SetToolBitmapSize(wx.Size(16, 16))
        if wx.Platform == '__WXMAC__':
            self.SetMargins(wx.Size(5, 4))

        # load icons
        icons = mIcons()

        # file
        self.AddSimpleTool(ID_fileOpen, icons.fileOpen, "Open Document...", " Open document")
        self.AddSimpleTool(ID_fileSave, icons.fileSave, "Save Document", " Save current document")
        self.AddSimpleTool(ID_fileClose, icons.fileClose, "Close Document", " Close current document")
        self.AddSimpleTool(ID_filePrintSpectrum, icons.filePrintSpectrum, "Print Spectrum...", " Print current spectrum view")
        self.AddSimpleTool(ID_filePrintReport, icons.filePrintReport, "Print Report...", " Print annotated peaklist")
        self.AddSimpleTool(ID_fileInfo, icons.fileInfo, "Document Information", " Show information about current document")

        # tools
        self.AddSeparator()
        self.AddRadioTool(ID_toolsMSpec, icons.toolsMSpec, shortHelp="Mass Spectrum", longHelp=" Analyse mass spectrum")
        self.AddRadioTool(ID_toolsMSeq, icons.toolsMSeq, shortHelp="Sequence Editor", longHelp=" Protein / peptide sequence editing")
        self.AddRadioTool(ID_toolsMCut, icons.toolsMCut, shortHelp="Protein Digest", longHelp=" Generate list of digestion peptides")
        self.AddRadioTool(ID_toolsMFrag, icons.toolsMFrag, shortHelp="Peptide Fragmentation", longHelp=" Generate list of peptide fragments")
        self.AddRadioTool(ID_toolsMDiff, icons.toolsMDiff, shortHelp="Check Differences", longHelp=" Check differences for all peaks")
        self.AddRadioTool(ID_toolsMComp, icons.toolsMComp, shortHelp="Compare Peaklists", longHelp=" Compare loaded peaklists with the main peaklist")

        # spectrum
        self.AddSeparator()
        self.AddRadioTool(ID_spectrumLabelPoint, icons.spectrumLabelPoint, shortHelp="Label Point", longHelp=" Label point in spectrum")
        self.AddRadioTool(ID_spectrumLabelPeak, icons.spectrumLabelPeak, shortHelp="Label Peak", longHelp=" Label peak by centroid")
        self.AddRadioTool(ID_spectrumDeleteLabel, icons.spectrumDeleteLabel, shortHelp="Delete Label", longHelp=" Delete selected labels")
        self.AddRadioTool(ID_spectrumMeasureDistance, icons.spectrumMeasureDistance, shortHelp="Distance Measurement", longHelp=" Measure distance between two peaks")

        # processing
        self.AddSeparator()
        self.AddSimpleTool(ID_processingInternalCalibration, icons.processingInternalCalibration, "Internal Callibration...", " Internal standard calibration")
        self.AddSimpleTool(ID_processingStatisticalCalibration, icons.processingStatisticalCalibration, "Statistical Calibration...", " Statistical calibration for protein digest spectrum")

        # peaklist
        self.AddSeparator()
        self.AddSimpleTool(ID_peaklistAddPeak, icons.peaklistAddPeak, "Add Peak...", " Add new peak to the peaklist manually")
        self.AddSimpleTool(ID_peaklistClearAllAnnots, icons.peaklistClearAllAnnots, "Clear All Annotations", " Clear all peaklist's annotations")
        self.AddSimpleTool(ID_peaklistDeleteAllPeaks, icons.peaklistDeleteAllPeaks, "Delete All Peaks", " Delete all labeled peaks")

        # matching
        self.AddSeparator()
        self.AddSimpleTool(ID_matchingMatchData, icons.matchingMatchData, "Match Data", " Match current data to peaklist")
        self.AddSimpleTool(ID_matchingMatchInfo, icons.matchingMatchInfo, "Match Info", " Show current match info")
        self.AddSimpleTool(ID_matchingAnnotate, icons.matchingAnnotate, "Annotate Peaklist", " Annotate matched peaks in peaklist by current data")

        # mascot tools
        self.AddSeparator()
        self.AddSimpleTool(ID_toolsMMascotPMF, icons.toolsMMascotPMF, "Mascot PMF Search...", " Send peaklist data to Mascot Peptide Mass Fingerprint")
        self.AddSimpleTool(ID_toolsMMascotSeq, icons.toolsMMascotSeq, "Mascot Sequence Query...", " Send peaklist data to Mascot Sequence Query")
        self.AddSimpleTool(ID_toolsMMascotMSMS, icons.toolsMMascotMSMS, "Mascot MS/MS Ion Search...", " Send peaklist data to Mascot MS/MS Ion Search")

        # sequence
        self.AddSeparator()
        self.AddSimpleTool(ID_sequenceEditMod, icons.sequenceEditMod, "Modifications...", " Edit sequence modifications")
        self.AddSimpleTool(ID_sequenceSearchMass, icons.sequenceSearchMass, "Search for Mass...", " Search for specified mass in sequence")
        self.AddSimpleTool(ID_sequenceSearchSeq, icons.sequenceSearchSeq, "Search for Sequence...", " Search for specified sub-sequence in sequence")
        self.AddSimpleTool(ID_fileImportSequence, icons.fileImportSequence, "Import Sequence...", " Import sequence from ASCII file")

        # masstype and tolerance
        self.AddSeparator()
        self.AddRadioTool(ID_configMonoisotopic, icons.configMonoisotopic, shortHelp="Monoisotopic Masses", longHelp=" Use monoisotopic masses")
        self.AddRadioTool(ID_configAverage, icons.configAverage, shortHelp="Average Masses", longHelp=" Use average masses")
        self.AddSimpleTool(ID_configTolerance, icons.configTolerance, "Tolerance...", " Set tolerance value for data matching")

        # config
        self.AddSeparator()
        self.AddCheckTool(ID_configShowPeaklist, icons.configShowPeaklist, shortHelp="Show Peaklist", longHelp=" Split window to peaklist and tool frame")
        self.AddCheckTool(ID_configPeaklistBottom, icons.configPeaklistBottom, shortHelp="Peaklist Bottom", longHelp=" Split document window horizontally")
        self.AddSimpleTool(ID_configPreferences, icons.configPreferences, "Preferences...", " Set application defaults")
    # ----
