# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Dialog to edit params of loaded spectra.

# load libs
import wx

# load modules
from nucleus import mwx


class dlgEditSpecParams(wx.Dialog):
    """ Set compared spectrum name and offset. """

    # ----
    def __init__(self, parent, title, offset):
        wx.Dialog.__init__(self, parent, -1, "Spectrum Parameters", style=wx.DEFAULT_DIALOG_STYLE)

        self.title = title
        self.offset = offset

        # pack main frame
        mainBox = wx.BoxSizer(wx.VERTICAL)
        if wx.Platform == '__WXMAC__':
            mainBox.Add(self.makeParamsBox(), 0, wx.TOP|wx.LEFT|wx.RIGHT, 20)
            mainBox.Add(self.makeButtonBox(), 0, wx.ALIGN_CENTER|wx.ALL, 10)
        else:
            mainBox.Add(self.makeParamsBox(), 0, wx.ALL, 5)
            mainBox.Add(self.makeButtonBox(), 0, wx.ALIGN_CENTER|wx.ALL, 5)

        # fit layout
        mainBox.Fit(self)
        self.SetSizer(mainBox)
        self.Centre()
    # ----


    # ----
    def makeParamsBox(self):
        """ Make box for spectrum parameters. """

        # make items
        grid = mwx.GridBagSizer()

        title_label = wx.StaticText(self, -1, "Spectrum title: ")
        self.title_value = wx.TextCtrl(self, -1, self.title, size=(120, -1))
        offset_label = wx.StaticText(self, -1, "Intensity offset: ")
        self.offset_value = wx.TextCtrl(self, -1, str(self.offset), size=(120, -1), validator=mwx.txtValidator('int'))

        # pack items
        grid.Add(title_label, (0, 0), flag=wx.ALIGN_CENTER_VERTICAL|wx.ALIGN_RIGHT)
        grid.Add(self.title_value, (0, 1))
        grid.Add(offset_label, (1, 0), flag=wx.ALIGN_CENTER_VERTICAL|wx.ALIGN_RIGHT)
        grid.Add(self.offset_value, (1, 1))

        return grid
    # ----


    # ----
    def makeButtonBox(self):
        """ Make box for main buttons. """

        # make items
        OK_button = wx.Button(self, wx.ID_OK, "OK")
        Cancel_button = wx.Button(self, wx.ID_CANCEL, "Cancel")

        # pack items
        buttonBox = wx.BoxSizer(wx.HORIZONTAL)
        buttonBox.Add(OK_button, 0, wx.ALL, 5)
        buttonBox.Add(Cancel_button, 0, wx.ALL, 5)

        # set events
        wx.EVT_BUTTON(self, wx.ID_OK, self.onDlgOK)

        # set defaults
        OK_button.SetDefault()

        return buttonBox
    # ----


    # ----
    def onDlgOK(self, evt):
        """ Get parameters. """

        # get params
        self.title = self.title_value.GetValue()
        self.offset = self.offset_value.GetValue()

        # test params
        if self.title == '':
            return
        try:
            self.offset = int(self.offset)
        except ValueError:
            return

        # end dialog
        self.EndModal(wx.ID_OK)
    # ----


    # ----
    def getParams(self):
        """ Get dialog data. """
        return self.title, self.offset
    # ----
