# This file should be included if the command line reads like this:
# x86_64-w64-mingw32.shared-cmake -DCMAKE_BUILD_TYPE=Release -DMXE=1 ..

MESSAGE("MXE (M cross environment) https://mxe.cc/")
message("Please run the configuration like this:")
message("x86_64-w64-mingw32.shared-cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../../development")


set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /home/rusconi/devel/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /home/rusconi/devel/mxe/usr/x86_64-w64-mingw32.shared/include)


# No more used as now this code belongs to the PappsoMSppWidget library.
set(CustomPwiz_FOUND 1)
set(CustomPwiz_INCLUDE_DIR "/home/rusconi/devel/custompwiz/development/src")
set(CustomPwiz_LIBRARY "/home/rusconi/devel/custompwiz/build-area/src/libcustompwiz.dll")
if(NOT TARGET CustomPwiz::CustomPwiz)
	add_library(CustomPwiz::CustomPwiz UNKNOWN IMPORTED)
	set_target_properties(CustomPwiz::CustomPwiz PROPERTIES
		IMPORTED_LOCATION             "${CustomPwiz_LIBRARY}"
		INTERFACE_INCLUDE_DIRECTORIES "${CustomPwiz_INCLUDE_DIR}")
endif()


set(QCustomPlot_FOUND 1)
set(QCustomPlot_INCLUDE_DIR "/home/rusconi/devel/qcustomplot/development")
set(QCustomPlot_LIBRARY "/home/rusconi/devel/qcustomplot/build-area/mxe/libqcustomplot.dll")
if(NOT TARGET QCustomPlot::QCustomPlot)
	add_library(QCustomPlot::QCustomPlot UNKNOWN IMPORTED)
	set_target_properties(QCustomPlot::QCustomPlot PROPERTIES
		IMPORTED_LOCATION             "${QCustomPlot_LIBRARY}"
		INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlot_INCLUDE_DIR}")
endif()


set(IsoSpec_FOUND 1)
set(IsoSpec_INCLUDE_DIR "/home/rusconi/devel/isospec/development")
set(IsoSpec_LIBRARY "/home/rusconi/devel/isospec/build-area/mxe/libIsoSpec.dll")
if(NOT TARGET IsoSpec::IsoSpec)
	add_library(IsoSpec::IsoSpec UNKNOWN IMPORTED)
	set_target_properties(IsoSpec::IsoSpec PROPERTIES
		IMPORTED_LOCATION             "${IsoSpec_LIBRARY}"
		INTERFACE_INCLUDE_DIRECTORIES "${IsoSpec_INCLUDE_DIR}")
endif()


set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIR "/home/rusconi/devel/pappsomspp/development/src")
set(PappsoMSpp_LIBRARY "/home/rusconi/devel/pappsomspp/build-area/mxe/src/libpappsomspp-qt5.dll")
if(NOT TARGET PappsoMSpp::PappsoMSpp)
	add_library(PappsoMSpp::PappsoMSpp UNKNOWN IMPORTED)
	set_target_properties(PappsoMSpp::PappsoMSpp PROPERTIES
		IMPORTED_LOCATION             "${PappsoMSpp_LIBRARY}"
		INTERFACE_INCLUDE_DIRECTORIES "${PappsoMSpp_INCLUDE_DIR}")
endif()


set(PappsoMSppWidget_FOUND 1)
set(PappsoMSppWidget_INCLUDE_DIR "/home/rusconi/devel/pappsomspp/development/src")
set(PappsoMSppWidget_LIBRARY
	"/home/rusconi/devel/pappsomspp/build-area/mxe/src/pappsomspp/widget/libpappsomspp-widget-qt5.dll")
if(NOT TARGET PappsoMSppWidget::PappsoMSppWidget)
	add_library(PappsoMSppWidget::PappsoMSppWidget UNKNOWN IMPORTED)
	set_target_properties(PappsoMSppWidget::PappsoMSppWidget PROPERTIES
		IMPORTED_LOCATION             "${PappsoMSppWidget_LIBRARY}"
		INTERFACE_INCLUDE_DIRECTORIES "${PappsoMSppWidget_INCLUDE_DIR}")
endif()


add_definitions(-fPIC)

