/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap
	  from Unihan.txt (version 4.0.1), kCangjie entries
	* supplemented with punctuation mappings
*/
struct keymap keymap_Cangjie [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￥"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"a", "日 曰"},
	{"aa", "昌 昍"},
	{"aaa", "晶"},
	{"aaaa", "𣊫 𣊭"},
	{"aahaf", "鷼 𪂇"},
	{"aahm", "暒"},
	{"aahu", "𣈲"},
	{"aamg", "𤦉"},
	{"aamh", "暘"},
	{"aaph", "晹"},
	{"aapv", "暍"},
	{"aate", "曝"},
	{"aayf", "暻"},
	{"ab", "明"},
	{"abac", "暝"},
	{"abbe", "曖"},
	{"abbq", "𣊬"},
	{"abbt", "盟"},
	{"abhaf", "鷳"},
	{"abik", "猒"},
	{"abjcm", "曌"},
	{"abjj", "暈 暉"},
	{"abme", "暖"},
	{"abmgi", "琞"},
	{"abms", "勗"},
	{"abof", "暩"},
	{"abou", "暚"},
	{"abu", "冒"},
	{"abuu", "晛"},
	{"acim", "暡"},
	{"acnh", "晜"},
	{"acsh", "昐"},
	{"ad", "杲"},
	{"add", "晽"},
	{"adhaf", "鷴"},
	{"adhl", "晰"},
	{"admq", "暐"},
	{"adwf", "暕"},
	{"aedhe", "㿺"},
	{"aenl", "鄤"},
	{"af", "炅 炚"},
	{"afbf", "曭"},
	{"afdq", "暽"},
	{"aff", "晱"},
	{"afhhh", "影"},
	{"afmbc", "顥 顯"},
	{"afmu", "晃 晄"},
	{"afno", "歞"},
	{"afq", "㫠"},
	{"agbt", "曀"},
	{"agdi", "時"},
	{"aggu", "曉"},
	{"agrr", "暿"},
	{"ahaj", "暤 暭"},
	{"ahbr", "晌 晑"},
	{"ahbu", "眉"},
	{"ahe", "昄"},
	{"ahf", "𤋁"},
	{"ahgf", "曛"},
	{"ahgr", "晧"},
	{"ahhd", "𥟟"},
	{"ahhl", "昴"},
	{"ahln", "剔"},
	{"ahml", "昕"},
	{"ahog", "暀"},
	{"ahok", "敭"},
	{"ahoo", "暰"},
	{"ahor", "晷"},
	{"ahqm", "星"},
	{"ahqo", "昳"},
	{"ahs", "昈 昨"},
	{"ahsk", "曒"},
	{"aht", "昇"},
	{"ahuj", "曍"},
	{"ahum", "𣊊"},
	{"ahvl", "昂"},
	{"ahxu", "晲"},
	{"aiav", "㫰"},
	{"aice", "晙"},
	{"aihs", "晟"},
	{"aijb", "晡"},
	{"aikf", "㬙"},
	{"aimu", "𣇈"},
	{"aimvu", "既"},
	{"aine", "昹"},
	{"aisl", "即"},
	{"aislf", "䳭"},
	{"aitc", "曠"},
	{"aj", "早"},
	{"ajbd", "㫲"},
	{"ajbj", "暔"},
	{"ajd", "昧"},
	{"ajii", "暷"},
	{"ajka", "暑"},
	{"ajmm", "暄"},
	{"ajmu", "晥"},
	{"ajnu", "晼"},
	{"ajv", "晏"},
	{"ak", "旲"},
	{"akcf", "暸"},
	{"akkb", "晞"},
	{"akll", "昦"},
	{"aklu", "晻"},
	{"akms", "晇"},
	{"akn", "旯"},
	{"al", "曱"},
	{"albk", "映"},
	{"albo", "𣋡"},
	{"alg", "堲"},
	{"alln", "昲"},
	{"almo", "晁"},
	{"alnc", "曊"},
	{"am", "旦"},
	{"amam", "晅"},
	{"ambb", "曘"},
	{"ambc", "暊"},
	{"ambe", "𣌊"},
	{"ambg", "曤"},
	{"ambi", "曇"},
	{"ambm", "𣌟"},
	{"ambuu", "𧡰"},
	{"amcw", "晒"},
	{"amd", "旴"},
	{"amg", "旺"},
	{"amhaf", "鴠"},
	{"amhqu", "毾"},
	{"ami", "戥"},
	{"amig", "晊"},
	{"amj", "旰 旱"},
	{"amk", "昊"},
	{"amks", "昮"},
	{"amlk", "𣆳"},
	{"ammk", "晸"},
	{"ammp", "曬"},
	{"ammr", "晤"},
	{"ammv", "晨"},
	{"amo", "昃"},
	{"amob", "昞 昺"},
	{"amrxu", "鼂"},
	{"amsh", "昜"},
	{"amtb", "曞"},
	{"amwg", "量"},
	{"amwj", "曋"},
	{"amym", "昰"},
	{"amyo", "是"},
	{"an", "門"},
	{"ana", "間"},
	{"anaa", "閶"},
	{"anasm", "闒"},
	{"anau", "冕 晚"},
	{"anayk", "閺"},
	{"anb", "閒"},
	{"anbbe", "閿"},
	{"anbue", "闅"},
	{"anbuk", "闃"},
	{"ancru", "閱"},
	{"and", "閑"},
	{"andh", "閉"},
	{"andmq", "闈"},
	{"andwf", "闌"},
	{"ane", "閖"},
	{"anehr", "闊"},
	{"anf", "焛 𨳒"},
	{"anfbg", "闛"},
	{"anfbw", "闣"},
	{"angg", "閨"},
	{"angit", "闔"},
	{"anhe", "昅"},
	{"anher", "閣"},
	{"anhpa", "閽"},
	{"anhqu", "閐"},
	{"anhud", "闑"},
	{"anhx", "閰"},
	{"anhxh", "𨉖"},
	{"anhxu", "䦧"},
	{"aniav", "閬"},
	{"anibp", "𨶙"},
	{"anirm", "閾"},
	{"anit", "閞"},
	{"anjbc", "闐"},
	{"anjka", "闍"},
	{"anjrr", "䦡"},
	{"anki", "閎"},
	{"anklu", "閹"},
	{"ankn", "𨳊"},
	{"anlmc", "闠"},
	{"anlmi", "閩"},
	{"anm", "閂"},
	{"anmcw", "閪"},
	{"anmfj", "閛"},
	{"anmg", "閏"},
	{"anmgi", "閠"},
	{"anmj", "閈"},
	{"anmjk", "闞"},
	{"anmmm", "閆"},
	{"anmn", "閅"},
	{"anmnr", "閜"},
	{"anmt", "開"},
	{"anmwg", "闉"},
	{"annhx", "閻"},
	{"annkg", "閮"},
	{"annok", "闋"},
	{"ano", "欥 閃"},
	{"anog", "閵"},
	{"anoi", "閥"},
	{"anok", "暌"},
	{"anomc", "𨴴"},
	{"anomm", "闟"},
	{"anomr", "閤"},
	{"anooo", "閦"},
	{"anp", "悶 𨳍"},
	{"anph", "閟"},
	{"anqou", "闚"},
	{"anr", "問"},
	{"anrhr", "閭"},
	{"anrrj", "闡"},
	{"anrrr", "闆"},
	{"ansj", "聞"},
	{"ansqf", "闖"},
	{"ansrj", "闢"},
	{"antc", "閧"},
	{"antcu", "闀"},
	{"antk", "関"},
	{"antuo", "闕"},
	{"anumt", "闓"},
	{"anus", "𣈳"},
	{"anvff", "𨶹"},
	{"anvit", "關"},
	{"anwd", "閫"},
	{"anwl", "閘"},
	{"anwlv", "闤"},
	{"anygq", "闥"},
	{"anyhn", "閌"},
	{"anyhs", "閍"},
	{"anyj", "閗"},
	{"anyk", "閔"},
	{"anylb", "閙"},
	{"anymr", "誾"},
	{"anysy", "閼"},
	{"anyta", "闇"},
	{"anyvo", "閡"},
	{"aodmq", "韙"},
	{"aofh", "尟"},
	{"aohaf", "鶗"},
	{"aohh", "昣"},
	{"aoii", "昤"},
	{"aoin", "昑"},
	{"aoir", "晗"},
	{"aoj", "旿"},
	{"aomb", "㫻"},
	{"aombc", "題"},
	{"aomn", "𣈥 𣈯"},
	{"aop", "匙"},
	{"aowy", "晦"},
	{"aphaf", "鵾"},
	{"aphh", "昒 易"},
	{"aphu", "晓"},
	{"api", "旳"},
	{"apim", "昀"},
	{"apmm", "暅"},
	{"app", "昆"},
	{"apr", "昫"},
	{"apu", "旽"},
	{"apvo", "曷"},
	{"aqhl", "晣"},
	{"aqjm", "暳"},
	{"aqka", "暙"},
	{"aqmb", "晴"},
	{"arf", "煦 照"},
	{"armd", "冔"},
	{"arrj", "暺"},
	{"arrk", "曮"},
	{"arye", "暇"},
	{"asf", "煝"},
	{"ashr", "昭"},
	{"asje", "最"},
	{"asjs", "朂"},
	{"askr", "𣇉"},
	{"asmg", "曜"},
	{"asp", "昵"},
	{"astr", "暱"},
	{"ata", "𣈏"},
	{"atak", "暯"},
	{"atbc", "晪"},
	{"atbo", "曚"},
	{"atce", "暴"},
	{"atcr", "謈"},
	{"atgi", "㬢"},
	{"atgs", "曦 𣌀"},
	{"atlb", "暪"},
	{"atlf", "曣"},
	{"atlk", "暎"},
	{"atlo", "暵"},
	{"atmj", "曄"},
	{"atnk", "𣋒"},
	{"atw", "𣈴"},
	{"atys", "𣇷"},
	{"au", "巴 旵"},
	{"auam", "暨"},
	{"aud", "槩"},
	{"aue", "㫞"},
	{"aug", "塈"},
	{"auhaf", "鶥"},
	{"auhqu", "毷"},
	{"auks", "勖"},
	{"aumt", "暟"},
	{"aunl", "郿"},
	{"aunwf", "鱀"},
	{"auu", "岊 昢 𣅽"},
	{"av", "妟 艮"},
	{"avhaf", "鶡 鷃 鷐"},
	{"avhl", "曏"},
	{"avhqu", "毼"},
	{"avif", "㬎"},
	{"avii", "𣊉"},
	{"avno", "歇"},
	{"awla", "曙"},
	{"awle", "曼"},
	{"awlj", "曎"},
	{"ayaj", "晫"},
	{"aybp", "曨"},
	{"ayck", "晈"},
	{"aydk", "暾"},
	{"ayfd", "𣉢"},
	{"ayhs", "昉 昘"},
	{"ayk", "旻 旼"},
	{"ayoj", "晬"},
	{"ayrb", "暠"},
	{"ayrf", "景 晾"},
	{"ayrv", "曩"},
	{"aysd", "暆"},
	{"ayso", "暶"},
	{"ayt", "昱"},
	{"ayta", "暗"},
	{"aytg", "曈"},
	{"aytj", "暲"},
	{"ayvi", "昡 𣆂"},
	{"ayx", "𣋠"},
	{"b", "月"},
	{"bahm", "腥"},
	{"bakb", "幂"},
	{"bam", "胆"},
	{"bamh", "腸"},
	{"bang", "膶"},
	{"bate", "𦢊"},
	{"bau", "肥"},
	{"bayc", "冥"},
	{"bb", "朋"},
	{"bbb", "骨"},
	{"bbbr", "腡"},
	{"bbbuu", "覶"},
	{"bbbv", "骽"},
	{"bbdhe", "骳"},
	{"bbdi", "脟"},
	{"bbe", "受"},
	{"bbggu", "髐"},
	{"bbhaf", "鶻"},
	{"bbher", "骼"},
	{"bbhf", "鵬"},
	{"bbhhj", "髀"},
	{"bbhmr", "骺"},
	{"bbhne", "骰"},
	{"bbhpm", "骶"},
	{"bbibi", "髆"},
	{"bbijc", "髍"},
	{"bbjhr", "髂"},
	{"bbjmc", "髕"},
	{"bbjr", "骷"},
	{"bbjti", "髖"},
	{"bbkms", "骻"},
	{"bbkni", "骫"},
	{"bbln", "剮"},
	{"bblws", "𩩍"},
	{"bblwv", "髏"},
	{"bbmbc", "顝"},
	{"bbmj", "骭"},
	{"bbmlk", "骾"},
	{"bbmr", "胴"},
	{"bbnd", "脬"},
	{"bbnq", "舜"},
	{"bboll", "骱"},
	{"bbpe", "愛"},
	{"bbpp", "𩨨"},
	{"bbpru", "骲"},
	{"bbr", "咼"},
	{"bbsd", "㬹"},
	{"bbtmt", "髒"},
	{"bbtqm", "髊"},
	{"bbtwt", "體"},
	{"bbu", "亂"},
	{"bbug", "臞"},
	{"bbul", "鼏"},
	{"bbuu", "覓"},
	{"bbwd", "髁"},
	{"bbwli", "髑"},
	{"bbyck", "骹"},
	{"bbyhn", "骯"},
	{"bbykb", "髓"},
	{"bbymp", "骴"},
	{"bbypt", "髗"},
	{"bbyrb", "髇"},
	{"bbytj", "辭"},
	{"bbyvo", "骸"},
	{"bc", "㓁 𦉪"},
	{"bcabu", "賵"},
	{"bcamh", "𧶽"},
	{"bcaph", "賜"},
	{"bcbcc", "贔"},
	{"bcbcd", "賝"},
	{"bcbgr", "賙"},
	{"bcbjj", "賱"},
	{"bcbsd", "𧶄"},
	{"bcbuc", "賏"},
	{"bcbuu", "覭"},
	{"bcc", "鑍"},
	{"bccim", "𧷜"},
	{"bccwa", "贈"},
	{"bcdh", "財"},
	{"bcfbc", "贘"},
	{"bcff", "賧"},
	{"bcfmu", "𧵦"},
	{"bcgwc", "贖"},
	{"bchaf", "鵙 鸎"},
	{"bche", "販"},
	{"bcher", "賂"},
	{"bchio", "貶"},
	{"bchjr", "𧵳"},
	{"bchpm", "貾"},
	{"bchqm", "貹"},
	{"bchuc", "𧹏"},
	{"bcibi", "賻"},
	{"bcig", "賍"},
	{"bcii", "賤"},
	{"bciih", "贂"},
	{"bcij", "賊"},
	{"bcije", "賕"},
	{"bcikk", "贆"},
	{"bcim", "䐥"},
	{"bcims", "贓"},
	{"bcir", "貽"},
	{"bcj", "肸"},
	{"bcjir", "賳"},
	{"bcjka", "賭"},
	{"bcjmf", "賩"},
	{"bcjmn", "貯"},
	{"bckb", "賄"},
	{"bcll", "賗"},
	{"bcllp", "贃"},
	{"bclmt", "贐"},
	{"bcln", "則"},
	{"bcmbc", "䫤"},
	{"bcmj", "罕"},
	{"bcmmv", "賑"},
	{"bcmpm", "賦"},
	{"bcmvn", "甖"},
	{"bcmwj", "贉"},
	{"bcncr", "贍"},
	{"bcnd", "𧴯"},
	{"bcnh", "䏲"},
	{"bcnl", "郥 鄍"},
	{"bcoju", "罌"},
	{"bcok", "敗"},
	{"bcomd", "賖"},
	{"bcomf", "賒"},
	{"bcpd", "貤"},
	{"bcqka", "賰"},
	{"bcqmb", "䝼"},
	{"bcr", "冏"},
	{"bcrhu", "貺"},
	{"bcrl", "腳"},
	{"bcru", "脫"},
	{"bcrxu", "鼆"},
	{"bcsh", "朌"},
	{"bcshr", "𧵓"},
	{"bcsmv", "賬"},
	{"bctbc", "賟"},
	{"bctco", "贌"},
	{"bctct", "賹"},
	{"bctis", "贜"},
	{"bcttb", "購"},
	{"bctxc", "賺"},
	{"bcv", "嬰"},
	{"bcyaj", "𦋐"},
	{"bcyhn", "貥"},
	{"bcymr", "譻"},
	{"bcyoj", "賥"},
	{"bcyr", "貼"},
	{"bcytr", "賠"},
	{"bcyvo", "賅"},
	{"bd", "采"},
	{"bdd", "冧"},
	{"bddf", "𦡞"},
	{"bdhhh", "彩"},
	{"bdi", "肘"},
	{"bdnl", "郛"},
	{"bdoe", "膝"},
	{"bdu", "乳"},
	{"bdw", "腖"},
	{"beee", "腏 𠖎"},
	{"behaf", "鶢"},
	{"bf", "炙"},
	{"bfbg", "膛"},
	{"bfcb", "膌"},
	{"bfd", "冞 脒"},
	{"bfdq", "膦"},
	{"bffs", "朥"},
	{"bfhvf", "縣"},
	{"bfmu", "胱"},
	{"bfp", "懸"},
	{"bfq", "胖"},
	{"bfqc", "賸"},
	{"bfqe", "滕"},
	{"bfqf", "縢 騰 黱"},
	{"bfqg", "塍"},
	{"bfqi", "螣"},
	{"bfqr", "謄"},
	{"bfqs", "勝"},
	{"bfqu", "腃"},
	{"bfqv", "媵"},
	{"bfu", "乿"},
	{"bg", "肚"},
	{"bggu", "膮"},
	{"bghaf", "鸜"},
	{"bghqu", "氍"},
	{"bgi", "胠"},
	{"bgil", "脚"},
	{"bgr", "周"},
	{"bgte", "臌"},
	{"bgth", "膨"},
	{"bha", "胉"},
	{"bhae", "腺"},
	{"bhbue", "貜"},
	{"bhbvk", "貕"},
	{"bhdh", "豺"},
	{"bhdn", "脷"},
	{"bhdv", "腇"},
	{"bhdw", "膰"},
	{"bher", "胳"},
	{"bhgf", "臐"},
	{"bhhau", "貌"},
	{"bhher", "貉"},
	{"bhhh", "肜"},
	{"bhhhj", "貏"},
	{"bhhj", "脾"},
	{"bhhv", "脈"},
	{"bhhwp", "貔"},
	{"bhi", "𦞙"},
	{"bhjc", "貁"},
	{"bhjd", "䏭"},
	{"bhje", "腶"},
	{"bhjg", "腫"},
	{"bhjm", "腄"},
	{"bhju", "腯"},
	{"bhlq", "貄"},
	{"bhlwv", "貗"},
	{"bhma", "貊"},
	{"bhmam", "貆"},
	{"bhmj", "豻"},
	{"bhml", "肵"},
	{"bhn", "冗 肌"},
	{"bhne", "股"},
	{"bhob", "豽"},
	{"bhod", "貅"},
	{"bhomn", "貐"},
	{"bhon", "胻"},
	{"bhpi", "豹"},
	{"bhpm", "胝"},
	{"bhqm", "胜"},
	{"bhqo", "胅"},
	{"bhrrj", "貚"},
	{"bhrye", "貑"},
	{"bhs", "胙"},
	{"bhshr", "貂"},
	{"bhsrr", "貙"},
	{"bhtak", "貘"},
	{"bhtrg", "貛"},
	{"bhtw", "貓"},
	{"bhuc", "臢"},
	{"bhumb", "貒"},
	{"bhuu", "膬 貀"},
	{"bhvo", "胍"},
	{"bhwg", "貍"},
	{"bhwp", "膍"},
	{"bhx", "舀"},
	{"bhxe", "膄"},
	{"bhxo", "腴"},
	{"biav", "朖"},
	{"bibi", "膊"},
	{"bice", "朘 脧"},
	{"bijb", "脯"},
	{"bije", "脙"},
	{"bikf", "𤔡"},
	{"bikk", "胈"},
	{"bine", "脉"},
	{"bioi", "腑"},
	{"bipc", "膩"},
	{"bipf", "臕"},
	{"bir", "胎"},
	{"bitc", "臁"},
	{"biypu", "虢"},
	{"bjb", "肺"},
	{"bjbd", "脖"},
	{"bjbj", "腩"},
	{"bjcg", "膣"},
	{"bjcm", "腔"},
	{"bjcr", "𦞳"},
	{"bjcu", "𦡆"},
	{"bjdhe", "皸"},
	{"bje", "肢"},
	{"bjhaf", "鶤"},
	{"bjii", "膞"},
	{"bjkp", "𦚱"},
	{"bjlmi", "蠈"},
	{"bjmbc", "顐"},
	{"bjmc", "臏"},
	{"bjmf", "腙"},
	{"bjmo", "腚"},
	{"bjmu", "脘"},
	{"bjnl", "鄆"},
	{"bjnu", "腕"},
	{"bjtc", "膹"},
	{"bjti", "臗"},
	{"bjv", "胺"},
	{"bjwj", "軍"},
	{"bk", "冈 罓"},
	{"bkcf", "膫"},
	{"bkcor", "谿"},
	{"bkcu", "𦞴"},
	{"bkf", "然 𤉷"},
	{"bkhaf", "鶪 鷄"},
	{"bki", "肱 肽"},
	{"bkic", "脎"},
	{"bkk", "网"},
	{"bkkb", "脪"},
	{"bklu", "腌"},
	{"bkms", "胯"},
	{"bkn", "胰"},
	{"bkni", "肒"},
	{"bknl", "郹"},
	{"bkog", "雞"},
	{"bkoo", "脥"},
	{"bkpb", "䐭"},
	{"bks", "肋"},
	{"bkss", "脇"},
	{"blbk", "胦"},
	{"blbu", "䏙"},
	{"bll", "𦉫"},
	{"blln", "胇"},
	{"blmo", "朓 脁"},
	{"blmy", "腓"},
	{"bln", "刖"},
	{"blu", "见"},
	{"blwl", "胂"},
	{"blwv", "膢"},
	{"blxh", "胏"},
	{"bm", "且 囗 肛"},
	{"bmbb", "臑"},
	{"bmbc", "䐓"},
	{"bmbg", "臛"},
	{"bmbl", "胹"},
	{"bmcw", "𦚵"},
	{"bmf", "肧"},
	{"bmfb", "𦢈"},
	{"bmfm", "胚"},
	{"bmfr", "脴"},
	{"bmhaf", "鴡"},
	{"bmig", "胵"},
	{"bmj", "肝"},
	{"bmke", "爰"},
	{"bmks", "助"},
	{"bmlm", "𦜖"},
	{"bmln", "刞"},
	{"bmmc", "具"},
	{"bmmo", "冢"},
	{"bmms", "肟"},
	{"bmmu", "朊"},
	{"bmmv", "脤"},
	{"bmog", "雎"},
	{"bmr", "同"},
	{"bmrb", "膈"},
	{"bmrt", "脰"},
	{"bmrw", "冨 腷"},
	{"bmso", "豚 䐁"},
	{"bmui", "冠"},
	{"bmvm", "脛"},
	{"bmwf", "膘"},
	{"bmwl", "腼"},
	{"bmwv", "腰"},
	{"bn", "肊"},
	{"bnau", "脃 脕"},
	{"bncr", "膽"},
	{"bnd", "孚"},
	{"bnii", "膙"},
	{"bnkg", "脡"},
	{"bnkq", "腱"},
	{"bnlii", "蠫"},
	{"bnmu", "脆"},
	{"bno", "肷"},
	{"bnui", "冤"},
	{"bo", "贝"},
	{"boae", "腹"},
	{"boah", "膓"},
	{"bob", "肭"},
	{"bobo", "朒"},
	{"bobr", "𦛚"},
	{"bodi", "胕"},
	{"bog", "脽"},
	{"bogf", "膲"},
	{"bogs", "臇"},
	{"bohh", "胗"},
	{"boii", "朎"},
	{"boin", "肣"},
	{"boip", "腍"},
	{"boma", "膾"},
	{"bomc", "𦛼"},
	{"bommf", "祭"},
	{"bomn", "腧"},
	{"bomo", "臉"},
	{"bomrt", "豋"},
	{"bon", "肐"},
	{"boog", "脞"},
	{"bopd", "胣"},
	{"boq", "脌"},
	{"botf", "膴"},
	{"bowy", "脢"},
	{"boymr", "詧"},
	{"bpa", "脂"},
	{"bph", "䏟"},
	{"bphr", "脗"},
	{"bpp", "肶"},
	{"bpr", "朐 胊"},
	{"bpru", "胞"},
	{"bpu", "肫"},
	{"bpuk", "胸"},
	{"bq", "用"},
	{"bqkk", "腠"},
	{"bqmb", "腈"},
	{"bqmf", "膆"},
	{"bqu", "甩"},
	{"brc", "胑"},
	{"brhaf", "鵰"},
	{"brhg", "脭"},
	{"brhhh", "彫"},
	{"brhvf", "𦅚"},
	{"bri", "戙"},
	{"brog", "雕"},
	{"brrd", "臊"},
	{"brrs", "腭"},
	{"brsmm", "翢"},
	{"bsd", "爭"},
	{"bse", "脲"},
	{"bsef", "鵩"},
	{"bshh", "豸"},
	{"bshi", "肕"},
	{"bsjr", "腒"},
	{"bsle", "服"},
	{"bsmg", "腛"},
	{"bsmh", "膠"},
	{"bsmv", "脹"},
	{"bss", "凸"},
	{"bstv", "𦟌"},
	{"bt", "冊 皿"},
	{"bta", "腊"},
	{"btab", "冪"},
	{"btak", "膜"},
	{"btav", "臈"},
	{"btbc", "腆"},
	{"btbo", "朦"},
	{"btbs", "𦛨"},
	{"btca", "𦡮"},
	{"btct", "膉"},
	{"btgr", "膳"},
	{"btis", "臟"},
	{"btk", "朕"},
	{"btlf", "臙"},
	{"btlk", "朠"},
	{"btln", "删 刪"},
	{"btmbc", "頯 𩓚"},
	{"btmc", "𦝁"},
	{"btmd", "腜"},
	{"btmj", "𦠜"},
	{"btoe", "臒"},
	{"btt", "肼 胼"},
	{"btu", "岡"},
	{"btwv", "膿"},
	{"btyj", "膵"},
	{"btyv", "罔"},
	{"bu", "冚 目"},
	{"buahm", "睲"},
	{"buahu", "睸"},
	{"buamj", "睅"},
	{"buamo", "睼"},
	{"buana", "瞷"},
	{"buanb", "瞯"},
	{"buank", "矙"},
	{"buav", "眼"},
	{"bubac", "瞑"},
	{"bubbe", "瞹"},
	{"bubbq", "瞬"},
	{"bubd", "睬"},
	{"bubgr", "睭"},
	{"bubsd", "睜"},
	{"bubuk", "瞁"},
	{"bubuu", "睍 覞"},
	{"bubvk", "𥉐"},
	{"buc", "貝"},
	{"buce", "朡"},
	{"bucim", "瞈"},
	{"bucms", "盻"},
	{"bucnh", "睇"},
	{"bucsh", "盼"},
	{"budhl", "𥇦"},
	{"budmf", "𥈡"},
	{"budoo", "睞"},
	{"bufb", "睄"},
	{"bufbf", "矘"},
	{"bufbg", "瞠"},
	{"bufbq", "𥋇"},
	{"bufd", "眯"},
	{"bufdq", "瞵"},
	{"buff", "睒"},
	{"bufh", "眇"},
	{"bufq", "眫"},
	{"bufqu", "睠"},
	{"bugce", "睖"},
	{"bugcg", "睦"},
	{"bugg", "眭"},
	{"buggu", "䁱"},
	{"bugit", "瞌"},
	{"buhaf", "瞗 鷂"},
	{"buhce", "𥊙"},
	{"buhdf", "瞅"},
	{"buhe", "眅"},
	{"buhfb", "𥋘"},
	{"buhgf", "矄"},
	{"buhhj", "睥"},
	{"buhhv", "眽"},
	{"buhio", "眨"},
	{"buhjm", "睡"},
	{"buhju", "瞃"},
	{"buhml", "盺"},
	{"buhni", "颻"},
	{"buhok", "覹"},
	{"buhoo", "瞛"},
	{"buhpa", "睧"},
	{"buhqi", "睋"},
	{"buhqo", "眣"},
	{"buhqu", "眊"},
	{"buhsk", "睙"},
	{"buhu", "見"},
	{"buhus", "矏"},
	{"buhvf", "繇"},
	{"buhxe", "瞍"},
	{"buhxu", "睨"},
	{"buice", "睃"},
	{"buig", "𥅾"},
	{"buihq", "眸"},
	{"buik", "狊"},
	{"buir", "眙"},
	{"buitc", "矌"},
	{"buiv", "眓"},
	{"bujbc", "瞋"},
	{"bujcm", "瞾"},
	{"bujd", "眛"},
	{"bujjl", "䁪"},
	{"bujka", "睹"},
	{"bujlo", "睫"},
	{"bujmc", "瞚 矉"},
	{"bujmm", "睻"},
	{"bujmn", "眝"},
	{"bujmu", "睆"},
	{"bujnu", "睕"},
	{"bujpn", "矃"},
	{"bujqr", "瞎"},
	{"bukcf", "瞭"},
	{"bukkb", "睎"},
	{"bukmf", "𥇧"},
	{"bukn", "眱"},
	{"bukoo", "䀹"},
	{"bulbk", "眏"},
	{"bulbu", "眈"},
	{"bullp", "瞣"},
	{"bulmc", "瞶"},
	{"bulmi", "蜰"},
	{"bulmo", "眺"},
	{"buln", "剛"},
	{"bulwl", "眒"},
	{"bulwv", "瞜"},
	{"bumbb", "𥌎"},
	{"bumbg", "矐"},
	{"bumd", "盱"},
	{"bumgg", "睚"},
	{"bumj", "盰"},
	{"bumjk", "瞰"},
	{"bumls", "眄"},
	{"bummf", "眎"},
	{"bummi", "眃"},
	{"bumn", "盯"},
	{"bumtb", "矋"},
	{"bumwf", "瞟"},
	{"bumwj", "瞫"},
	{"bumym", "眐"},
	{"bunau", "睌"},
	{"bunbe", "矎"},
	{"buncr", "瞻"},
	{"bundt", "䁅"},
	{"bunhb", "瞲"},
	{"bunhe", "𥄫"},
	{"bunin", "眵"},
	{"bunir", "眳"},
	{"bunkq", "睷"},
	{"bunok", "睽"},
	{"bunot", "瞪"},
	{"buog", "睢 瞿 膗"},
	{"buoge", "矍"},
	{"buogf", "瞧"},
	{"buohh", "眕"},
	{"buoma", "瞺"},
	{"buomb", "睔"},
	{"buomm", "䁯"},
	{"buomn", "睮"},
	{"buomo", "瞼"},
	{"buon", "盵"},
	{"buonk", "睺"},
	{"buoq", "𢆡"},
	{"buotf", "瞴"},
	{"bupa", "眴"},
	{"bupim", "盷"},
	{"bupp", "䀝"},
	{"bupu", "盹"},
	{"buqmb", "睛"},
	{"buqou", "瞡"},
	{"burb", "睊"},
	{"burrd", "矂"},
	{"burvp", "眠"},
	{"bushr", "眧"},
	{"busj", "眲"},
	{"busmg", "眶 矅"},
	{"busp", "眤"},
	{"busrr", "瞘"},
	{"bustr", "䁥"},
	{"busuu", "𥇣"},
	{"busyi", "矚"},
	{"butak", "瞙"},
	{"butbo", "矇"},
	{"butco", "瞨"},
	{"butk", "眹"},
	{"butlb", "瞞"},
	{"butmj", "瞱"},
	{"butq", "眻"},
	{"butrg", "矔"},
	{"butw", "瞄"},
	{"buu", "朏 胐"},
	{"buuce", "䁓"},
	{"buumt", "䁗"},
	{"buvf", "県"},
	{"buvfb", "矊"},
	{"buvis", "眑"},
	{"buvml", "鼎"},
	{"buvne", "睩"},
	{"buwd", "睏"},
	{"buwla", "𥌓"},
	{"buyaj", "𥇍"},
	{"buybp", "矓"},
	{"buybu", "𥌑"},
	{"buyfd", "瞇"},
	{"buymp", "眦"},
	{"buyoj", "睟"},
	{"buyrl", "瞓"},
	{"buyso", "䁢"},
	{"buyt", "𥅈"},
	{"buytg", "瞳"},
	{"buytj", "瞕"},
	{"buyub", "瞝"},
	{"buyv", "盳"},
	{"buyvi", "眩"},
	{"bv", "妥"},
	{"bvg", "墾"},
	{"bvhaf", "鵎 鸚"},
	{"bvhl", "膷"},
	{"bvik", "奚"},
	{"bvne", "䐂"},
	{"bvnl", "郻"},
	{"bvno", "腞"},
	{"bvp", "懇"},
	{"bvvv", "臘"},
	{"bvvw", "腦"},
	{"bwd", "腂"},
	{"bwgg", "𦢓"},
	{"bwim", "膕"},
	{"bwk", "胭"},
	{"bwl", "胛"},
	{"bwlb", "腢"},
	{"bwlg", "𦣇"},
	{"bwli", "爵 臅"},
	{"bwmv", "腲"},
	{"bwot", "膃"},
	{"bwp", "腮"},
	{"bxff", "𦦨"},
	{"by", "丹 円"},
	{"byav", "腿"},
	{"bybb", "膼"},
	{"bybp", "朧 𠖥"},
	{"bybr", "膪"},
	{"bybs", "膀"},
	{"byck", "胶"},
	{"byhaf", "鴅"},
	{"byhhh", "彤"},
	{"byhn", "肮"},
	{"byhr", "膇"},
	{"byhs", "肪"},
	{"byia", "膱"},
	{"byij", "膟"},
	{"byln", "刐"},
	{"bymy", "胩"},
	{"byoj", "脺"},
	{"byok", "腋"},
	{"bypo", "臄"},
	{"bypt", "臚"},
	{"byrn", "脝"},
	{"byta", "腤"},
	{"bytg", "朣 膧"},
	{"bytoe", "雘"},
	{"bytp", "臆"},
	{"byvg", "臃"},
	{"byvi", "胘"},
	{"byvo", "胲"},
	{"bywm", "膻"},
	{"byx", "臍"},
	{"c", "金"},
	{"ca", "鈤"},
	{"caa", "錩"},
	{"cab", "𨧹"},
	{"cafu", "鎤"},
	{"cahm", "鍟"},
	{"cahu", "鎇"},
	{"cam", "鉭"},
	{"camh", "鍚"},
	{"cami", "鍀"},
	{"camj", "銲"},
	{"camo", "鍉"},
	{"camvn", "甑"},
	{"can", "鍆"},
	{"cana", "鐧"},
	{"canau", "䒏"},
	{"canb", "鐗"},
	{"canl", "鄫"},
	{"cant", "鐦"},
	{"canw", "鑭"},
	{"caop", "𨫞"},
	{"caph", "錫"},
	{"capp", "鋼"},
	{"capv", "鍻"},
	{"casm", "鎉"},
	{"cate", "鑤"},
	{"cau", "鈀"},
	{"cav", "銀"},
	{"cavf", "䥪"},
	{"cawe", "鏝"},
	{"cayf", "鐛"},
	{"cayt", "𨩄"},
	{"cb", "鈅"},
	{"cbb", "錋"},
	{"cbbe", "鑀"},
	{"cbbr", "鍋"},
	{"cbcd", "𨨥"},
	{"cbcn", "鍘"},
	{"cbcv", "𨰃"},
	{"cbdi", "鋝"},
	{"cbgr", "錭"},
	{"cbhx", "䤾"},
	{"cbjj", "鍕"},
	{"cbm", "鉏"},
	{"cbme", "鍰"},
	{"cbmr", "銅 𥖹"},
	{"cbms", "鋤"},
	{"cbou", "鎐"},
	{"cbsd", "錚"},
	{"cbt", "銏"},
	{"cbu", "鉬"},
	{"cbuc", "鋇"},
	{"cbue", "钁"},
	{"cbul", "鐤"},
	{"cbuu", "鋧"},
	{"cbwi", "𨰜"},
	{"cc", "釟 鍂"},
	{"ccc", "鑫"},
	{"cccc", "𨰻"},
	{"cchaf", "𪄇"},
	{"cci", "鈆"},
	{"ccnh", "銻"},
	{"ccor", "鋊"},
	{"ccr", "鉛"},
	{"ccru", "銳"},
	{"ccsh", "鈖"},
	{"ccwa", "鏳"},
	{"cdb", "𨦉"},
	{"cddo", "𨭣"},
	{"cddq", "鑻"},
	{"cdf", "錰"},
	{"cdg", "𨧀"},
	{"cdh", "釮"},
	{"cdhe", "鈹"},
	{"cdk", "鈌"},
	{"cdl", "鋉"},
	{"cdm", "鉢"},
	{"cdmq", "鍏"},
	{"cdoo", "錸"},
	{"cdw", "錬"},
	{"cdwf", "鍊"},
	{"ce", "淾"},
	{"cea", "錔"},
	{"ceah", "鐋"},
	{"cede", "𨨏"},
	{"cee", "𨥖"},
	{"ceed", "鎟"},
	{"ceee", "錣"},
	{"cegi", "鍅"},
	{"cehv", "鎃"},
	{"cei", "釵"},
	{"ceid", "𨫟"},
	{"cesd", "𨬡"},
	{"cetc", "𨩅"},
	{"cf", "釥 鈥"},
	{"cfb", "銷"},
	{"cfbb", "鏛"},
	{"cfbc", "鎖"},
	{"cfbd", "鏿"},
	{"cfbf", "钂"},
	{"cfbg", "鏜"},
	{"cfbr", "鋿"},
	{"cfbu", "鎲"},
	{"cfbw", "鐺"},
	{"cfd", "銤"},
	{"cfdq", "鏻"},
	{"cff", "錟"},
	{"cffd", "鑅"},
	{"cffg", "𨯗"},
	{"cffs", "鐒"},
	{"cfh", "鈔"},
	{"cfmu", "銧"},
	{"cfog", "𨫠"},
	{"cfq", "鉡"},
	{"cfqu", "錈"},
	{"cg", "釷"},
	{"cgbn", "𨧣"},
	{"cgce", "錂"},
	{"cgcg", "錴"},
	{"cgg", "銈"},
	{"cggu", "鐃"},
	{"cgi", "鉣"},
	{"cgit", "鎑"},
	{"cgni", "鑄"},
	{"cgov", "𨬓"},
	{"cgp", "鋕"},
	{"cgr", "銡"},
	{"cgrf", "𨯨"},
	{"cgrr", "𨭎"},
	{"cgrv", "鎱"},
	{"cgsk", "𨫼"},
	{"cgth", "𨭌"},
	{"cha", "鉑"},
	{"chaa", "𨰝"},
	{"chab", "錦"},
	{"chae", "䤼"},
	{"chaf", "鵭"},
	{"chag", "鍠"},
	{"chbk", "鐭"},
	{"chbr", "銄"},
	{"chd", "鉌"},
	{"chdb", "鏼"},
	{"chdf", "鍬"},
	{"chdh", "銹"},
	{"chdl", "𨧺"},
	{"chdn", "鋓"},
	{"chdw", "鐇"},
	{"che", "鈑"},
	{"chej", "鋒"},
	{"cher", "鉻"},
	{"chey", "鉖"},
	{"chg", "鈓"},
	{"chgf", "鑂"},
	{"chgi", "銩"},
	{"chgr", "鋯"},
	{"chgu", "銑"},
	{"chhaf", "鳻 鵜"},
	{"chhe", "鑗"},
	{"chhh", "釤"},
	{"chhj", "錍"},
	{"chhl", "鉚"},
	{"chhw", "鎦"},
	{"chixp", "麄"},
	{"chj", "釺"},
	{"chjd", "銖"},
	{"chje", "鍛"},
	{"chjg", "鍾"},
	{"chjm", "錘"},
	{"chjr", "銛"},
	{"chju", "鍎"},
	{"chjx", "鍤"},
	{"chkb", "鐈"},
	{"chlc", "鑕"},
	{"chlmi", "蚠"},
	{"chln", "剃"},
	{"chlo", "釽 鍁"},
	{"chmbc", "頒"},
	{"chml", "釿"},
	{"chmr", "銗"},
	{"chn", "𡯂"},
	{"chnb", "𨦨"},
	{"chnd", "䤪"},
	{"chni", "釩 𩗩"},
	{"chnl", "邠"},
	{"chok", "攽"},
	{"choo", "鏦"},
	{"chp", "𢚖"},
	{"chpa", "錉"},
	{"chqi", "鋨"},
	{"chqm", "鉎"},
	{"chqo", "鉄"},
	{"chrf", "鎢"},
	{"chs", "鈼"},
	{"chtl", "𨰉"},
	{"chu", "尣"},
	{"chua", "𨯩"},
	{"chuc", "鑽"},
	{"chud", "鎳"},
	{"chup", "鎴"},
	{"chvo", "鈲"},
	{"chwp", "鎞 鏓"},
	{"chxc", "𨯵"},
	{"chxe", "鎪"},
	{"chxh", "銵"},
	{"ci", "公"},
	{"ciav", "鋃"},
	{"cibi", "鎛"},
	{"cice", "鋑"},
	{"cihf", "鏚"},
	{"cihm", "銊"},
	{"cihq", "鉾"},
	{"cihr", "鍼"},
	{"cihs", "鋮"},
	{"cihu", "鈗"},
	{"cihv", "𨩆"},
	{"cii", "錢"},
	{"ciih", "鏒"},
	{"ciil", "鎯"},
	{"cijb", "鋪"},
	{"cijc", "鉥"},
	{"cije", "銶"},
	{"cikk", "鈸"},
	{"ciku", "䤞"},
	{"cilb", "鏞"},
	{"cile", "鏮"},
	{"cill", "銂"},
	{"cilr", "鎕"},
	{"cimbc", "頌"},
	{"cimn", "瓮"},
	{"cimr", "𥗛"},
	{"cine", "銢"},
	{"cing", "𨫆"},
	{"cip", "釴"},
	{"cipf", "鑣"},
	{"cipm", "鉽"},
	{"cipp", "鋱"},
	{"cir", "鈶"},
	{"cisb", "鍽"},
	{"cism", "翁"},
	{"citc", "鐮 鑛"},
	{"cite", "鍍"},
	{"citf", "鏣"},
	{"civ", "鉞"},
	{"cixe", "𨯙"},
	{"cixp", "鏕"},
	{"cixq", "𨭤"},
	{"cj", "針"},
	{"cjbc", "鎮"},
	{"cjbd", "鋍"},
	{"cjbf", "鎍 鑔"},
	{"cjbj", "𨩇"},
	{"cjcr", "鎔"},
	{"cjcv", "鑹"},
	{"cjig", "鐵"},
	{"cjii", "鏄"},
	{"cjip", "鏸"},
	{"cjjj", "𨪚"},
	{"cjjm", "𨯪"},
	{"cjka", "鍺"},
	{"cjki", "鋐"},
	{"cjkp", "銠"},
	{"cjks", "銬"},
	{"cjmc", "鏔 鑌 𨰦 𨰰"},
	{"cjmf", "錝"},
	{"cjmm", "鍹"},
	{"cjmo", "錠 鎵"},
	{"cjmu", "鋎"},
	{"cjmw", "𨬬"},
	{"cjnu", "鋺"},
	{"cjon", "䥑"},
	{"cjp", "鉈"},
	{"cjpn", "鑏"},
	{"cjr", "鈷"},
	{"cjrb", "鍸"},
	{"cjrr", "錧"},
	{"cjru", "鋴"},
	{"cjtc", "鐼"},
	{"cjti", "鑧"},
	{"cjto", "鑳"},
	{"cjv", "銨"},
	{"ck", "父 釱"},
	{"ckau", "爸"},
	{"ckb", "銪"},
	{"ckce", "鎩"},
	{"ckcf", "鐐"},
	{"ckgg", "鍷"},
	{"ckhml", "斧"},
	{"cki", "鈜 鈦"},
	{"ckjt", "錛"},
	{"ckkb", "䤭"},
	{"cklb", "鈽"},
	{"ckld", "銌"},
	{"ckmf", "錼"},
	{"ckmgc", "釜"},
	{"ckmr", "錡"},
	{"ckms", "銙"},
	{"ckn", "釚 銕"},
	{"cknin", "爹"},
	{"ckoo", "鋏"},
	{"cksjl", "爺"},
	{"cksr", "鉫"},
	{"cl", "丫 鈡"},
	{"clbk", "鉠"},
	{"clbu", "鈂"},
	{"cll", "鋛"},
	{"clll", "釧"},
	{"clln", "鉘"},
	{"clmc", "鐀"},
	{"clmo", "銚"},
	{"clmy", "䤵"},
	{"cln", "釗"},
	{"clnc", "鐨"},
	{"clp", "𨨩"},
	{"clpb", "𨩈"},
	{"clq", "銉"},
	{"clw", "鈾"},
	{"clwl", "鉮"},
	{"clwv", "鏤"},
	{"clx", "鏽"},
	{"cm", "釭"},
	{"cma", "銆"},
	{"cmbb", "鑐"},
	{"cmbc", "顉 𨫋"},
	{"cmbv", "𨯂"},
	{"cmbw", "鐳"},
	{"cmd", "釪"},
	{"cme", "銾"},
	{"cmf", "鈈"},
	{"cmfb", "鑈"},
	{"cmfe", "鋄"},
	{"cmfj", "銔 𨥾"},
	{"cmfm", "鉟"},
	{"cmgg", "錱"},
	{"cmgi", "鈺"},
	{"cmgr", "鑩"},
	{"cmhaf", "鶲"},
	{"cmhf", "𨪛"},
	{"cmhl", "鋣"},
	{"cmia", "𨫌"},
	{"cmig", "銍"},
	{"cmii", "𨫎"},
	{"cmj", "釬"},
	{"cmlm", "錏"},
	{"cmmp", "𨰣"},
	{"cmmr", "鋙"},
	{"cmms", "釫"},
	{"cmmu", "鈨"},
	{"cmmv", "鋠"},
	{"cmn", "釘"},
	{"cmnr", "鈳"},
	{"cmob", "鈵"},
	{"cmp", "憌"},
	{"cmr", "鉐"},
	{"cmrb", "鎘"},
	{"cmrt", "鋀"},
	{"cmrw", "鍢"},
	{"cmso", "𨧧"},
	{"cmsu", "鈪"},
	{"cmt", "鈃"},
	{"cmtb", "𨯅"},
	{"cmtn", "鉶"},
	{"cmto", "鐝"},
	{"cmua", "鐕"},
	{"cmvh", "釾"},
	{"cmvi", "鎒"},
	{"cmvm", "鋞"},
	{"cmvs", "兮"},
	{"cmwf", "鏢"},
	{"cmwj", "鐔"},
	{"cmwv", "𨪁"},
	{"cmym", "鉦"},
	{"cmys", "鈣"},
	{"cn", "釔"},
	{"cnao", "鐌"},
	{"cnau", "銫 鋔"},
	{"cnbk", "𨩉"},
	{"cnd", "釨"},
	{"cndt", "錳"},
	{"cng", "鈕"},
	{"cnhb", "鐍"},
	{"cnhd", "鍒"},
	{"cnhe", "鈒"},
	{"cnhs", "釢"},
	{"cnhx", "錎"},
	{"cni", "釸"},
	{"cnib", "銿"},
	{"cnih", "𨥨"},
	{"cnii", "鏹"},
	{"cnin", "鉹 𨥤"},
	{"cnir", "銘"},
	{"cnkg", "鋌"},
	{"cnkl", "𨧞"},
	{"cnkm", "鋋"},
	{"cnkq", "鍵"},
	{"cnl", "弚 鈏"},
	{"cnlh", "弟 鐊"},
	{"cnlr", "錒"},
	{"cnmu", "䤥"},
	{"cnn", "釕"},
	{"cno", "欽"},
	{"cnoe", "鏺"},
	{"cnok", "鍨"},
	{"cnot", "鐙"},
	{"cnri", "鑱"},
	{"cnst", "𨩙"},
	{"cnwa", "鑥"},
	{"cnyi", "𨧻"},
	{"coae", "鍑"},
	{"cob", "鈉"},
	{"cod", "銝"},
	{"cog", "錐"},
	{"cogd", "鏶"},
	{"cogf", "鐎"},
	{"cogj", "鎨"},
	{"cogs", "鎸 鐫"},
	{"cohg", "銋"},
	{"cohh", "鉁"},
	{"cohl", "𨦪"},
	{"coii", "鈴"},
	{"coim", "鑯"},
	{"coin", "鈐"},
	{"coir", "鋡 鎗"},
	{"colb", "鉓"},
	{"colh", "鎀"},
	{"colmi", "螸"},
	{"comb", "錀 鑰"},
	{"comc", "鋲"},
	{"comg", "銓"},
	{"coml", "𨨶"},
	{"comn", "鍮"},
	{"como", "鐱"},
	{"comq", "鎿"},
	{"comr", "鉿"},
	{"con", "釳"},
	{"cond", "鎎"},
	{"conk", "鍭"},
	{"conq", "𨫡"},
	{"coog", "銼"},
	{"cop", "慾"},
	{"cor", "谷"},
	{"cord", "𨩚"},
	{"cowy", "鋂"},
	{"cp", "鈊"},
	{"cpa", "銁"},
	{"cpbc", "鎭"},
	{"cpd", "釶"},
	{"cph", "鉍"},
	{"cphp", "鍃"},
	{"cpi", "釣 鈎"},
	{"cpim", "鈞"},
	{"cpou", "鋾"},
	{"cpp", "鈚"},
	{"cppa", "鍇"},
	{"cpr", "鉤"},
	{"cpru", "鉋"},
	{"cptd", "鍱"},
	{"cpu", "鈍"},
	{"cpyr", "鍧"},
	{"cqd", "銇"},
	{"cqgi", "𨨲"},
	{"cqhk", "鍥"},
	{"cqjl", "𨧜"},
	{"cqjm", "鏏"},
	{"cqjp", "𨯚"},
	{"cqki", "鋳"},
	{"cqmb", "錆"},
	{"cqmv", "錶"},
	{"cqo", "鈇"},
	{"cr", "釦"},
	{"crb", "鋗"},
	{"crhaf", "鵒"},
	{"crhg", "鋥"},
	{"crhr", "鋁"},
	{"crhu", "兌"},
	{"crjcm", "谾"},
	{"crki", "谹"},
	{"crlb", "銱"},
	{"crmjk", "豃"},
	{"crmr", "鏴"},
	{"crnl", "郤"},
	{"crno", "欲"},
	{"crnq", "谻"},
	{"croir", "谽"},
	{"crp", "总 懖 𢤹"},
	{"crrd", "鐰"},
	{"crrj", "𨭐"},
	{"crrk", "𨰫"},
	{"crrs", "鍔"},
	{"crsl", "卻"},
	{"crsmh", "豂"},
	{"crtc", "谼"},
	{"cruc", "鐉"},
	{"crvk", "鋘"},
	{"crvp", "鈱"},
	{"crybp", "豅"},
	{"crye", "鍜"},
	{"cseg", "鏗"},
	{"csh", "分 釖"},
	{"cshc", "貧"},
	{"cshf", "炃"},
	{"cshg", "坌"},
	{"cshp", "忿"},
	{"cshr", "鉊"},
	{"csht", "弅 盆"},
	{"cshu", "岔"},
	{"csic", "𨯿"},
	{"csit", "鑑"},
	{"csiu", "鑬"},
	{"csj", "鉺"},
	{"csje", "鋷"},
	{"csjj", "鑷"},
	{"csjl", "鎁"},
	{"csjr", "鋸"},
	{"cskr", "𨧡"},
	{"cslb", "鉔"},
	{"csme", "鋟"},
	{"csmg", "鑃"},
	{"csmh", "鏐"},
	{"csmm", "𨦫"},
	{"csmr", "鉰"},
	{"csmv", "鋹"},
	{"csp", "鈮"},
	{"csqf", "鎷"},
	{"csr", "鉕"},
	{"csro", "䥲"},
	{"csrr", "鏂"},
	{"css", "鉅"},
	{"cssr", "鋦"},
	{"cstv", "𨫀"},
	{"csu", "𨥈"},
	{"cswc", "𨰹"},
	{"csyi", "钃"},
	{"csyq", "𨬯"},
	{"cta", "錯"},
	{"ctak", "鏌"},
	{"ctbc", "錪"},
	{"ctbk", "鏾"},
	{"ctbn", "鎆"},
	{"ctc", "鉷"},
	{"ctca", "鐠"},
	{"ctcd", "𨭥"},
	{"ctcg", "䥓"},
	{"ctch", "𨧼"},
	{"ctcl", "鐁"},
	{"ctco", "鏷"},
	{"ctct", "鎰"},
	{"ctcu", "𨬭"},
	{"ctcw", "𨩊"},
	{"ctei", "鑮"},
	{"ctgi", "鑆"},
	{"ctgk", "鎂"},
	{"ctgo", "𨬢"},
	{"ctgr", "鐥"},
	{"ctgt", "鑉"},
	{"ctgu", "錓"},
	{"ctis", "鑶"},
	{"ctkr", "鍩"},
	{"ctlb", "鏋"},
	{"ctlf", "𨯧"},
	{"ctlk", "鍈"},
	{"ctlo", "𨫪"},
	{"ctm", "鉗"},
	{"ctmc", "錤 鐄"},
	{"ctmj", "鏵"},
	{"ctmv", "鍖"},
	{"ctob", "𨧨"},
	{"ctoe", "鑊"},
	{"ctop", "錵"},
	{"ctor", "鎝"},
	{"ctpd", "鐷"},
	{"ctpo", "𨪂"},
	{"ctqm", "鎈"},
	{"ctrg", "鑵"},
	{"ctrs", "𨯫"},
	{"ctsr", "鍣"},
	{"ctt", "鉼"},
	{"ctub", "鎙"},
	{"ctvi", "鎡"},
	{"ctw", "錨"},
	{"ctwb", "𨭬"},
	{"ctwi", "鐏"},
	{"ctxc", "鎌"},
	{"ctyj", "鑝"},
	{"ctyv", "鋩"},
	{"cu", "釓 𨥉"},
	{"cuap", "𨬌"},
	{"cubb", "鏰"},
	{"cuce", "鍐"},
	{"cuhj", "鎽"},
	{"cuhqu", "毤"},
	{"cumb", "鍴"},
	{"cumj", "錌"},
	{"cumt", "鎧"},
	{"cuob", "鑴"},
	{"cuog", "鏙"},
	{"cuok", "敓"},
	{"cutn", "𨬫"},
	{"cv", "釹"},
	{"cvfr", "鐑"},
	{"cvid", "鑠"},
	{"cvii", "鐖"},
	{"cvio", "鉯"},
	{"cvmi", "鏘"},
	{"cvne", "錄"},
	{"cvr", "銣"},
	{"cvvc", "鎻"},
	{"cvvv", "鑞"},
	{"cvvw", "錙"},
	{"cw", "鈿"},
	{"cwa", "曾"},
	{"cwb", "𨩋"},
	{"cwd", "錁"},
	{"cwg", "鋰"},
	{"cwgf", "𨭆"},
	{"cwjc", "鏆"},
	{"cwjr", "錮"},
	{"cwk", "銦"},
	{"cwkp", "𨪜"},
	{"cwl", "鉀"},
	{"cwlg", "鑼"},
	{"cwli", "鐲"},
	{"cwlj", "鐸"},
	{"cwlm", "鎠"},
	{"cwlv", "鐶"},
	{"cwmv", "鍡"},
	{"cwol", "鎅"},
	{"cwp", "鍶"},
	{"cwrc", "𨭦"},
	{"cwtj", "鏎"},
	{"cwvf", "鏍"},
	{"cwwg", "鑸"},
	{"cwwv", "𨯬"},
	{"cwww", "鑘"},
	{"cwyi", "鉧"},
	{"cy", "釙"},
	{"cyaj", "鋽"},
	{"cybb", "鍗 鐹"},
	{"cybc", "鍞"},
	{"cybk", "钀"},
	{"cybp", "鑨"},
	{"cybs", "鎊"},
	{"cycb", "鏑 𨫢"},
	{"cyck", "鉸"},
	{"cydk", "鐓"},
	{"cye", "鈙"},
	{"cyed", "𨮏"},
	{"cyg", "鉒"},
	{"cygq", "鐽"},
	{"cyhc", "䥥"},
	{"cyhj", "鏠"},
	{"cyhm", "鏟"},
	{"cyhn", "鈧"},
	{"cyhr", "鎚"},
	{"cyhs", "鈁"},
	{"cyhv", "銥"},
	{"cyib", "錥"},
	{"cyiu", "銃 鋶"},
	{"cyj", "鈄"},
	{"cyjj", "鏈"},
	{"cyk", "鈫"},
	{"cylb", "鈰"},
	{"cymb", "錹"},
	{"cymh", "鐬"},
	{"cymr", "𨦼"},
	{"cymy", "鉲"},
	{"cypd", "鏬"},
	{"cypo", "鐻"},
	{"cypp", "鑢"},
	{"cyps", "鐪"},
	{"cypt", "鑪"},
	{"cyr", "鉆"},
	{"cyrb", "鎬"},
	{"cyrd", "錞"},
	{"cyrf", "鍄"},
	{"cyrn", "𨧤 𨪃"},
	{"cyro", "𨮙"},
	{"cyru", "𨦸"},
	{"cyrv", "鎄 鑲"},
	{"cysd", "鍦"},
	{"cysk", "鏃"},
	{"cyso", "鏇"},
	{"cyt", "鉝"},
	{"cytg", "鐘"},
	{"cytj", "鋅 鏱"},
	{"cyto", "鐩"},
	{"cytp", "鐿"},
	{"cytr", "錇"},
	{"cytu", "鏡"},
	{"cyvi", "鉉"},
	{"cywi", "鏀"},
	{"cyx", "鑇"},
	{"d", "木"},
	{"da", "杳"},
	{"daa", "椙"},
	{"dabt", "榅"},
	{"dafu", "榥"},
	{"dagi", "榯"},
	{"dahu", "楣"},
	{"dail", "楖"},
	{"daiu", "概"},
	{"dam", "查 柦"},
	{"damh", "楊"},
	{"damj", "桿"},
	{"dan", "椚"},
	{"dana", "橺"},
	{"danb", "橌"},
	{"dand", "㯗"},
	{"dang", "橍"},
	{"danr", "櫊 櫚"},
	{"danw", "欄"},
	{"dapp", "棍"},
	{"dapv", "楬"},
	{"dasm", "榻"},
	{"dau", "杷"},
	{"dav", "根"},
	{"dawe", "槾"},
	{"db", "朿"},
	{"dbac", "榠"},
	{"dbb", "棚"},
	{"dbbb", "榾"},
	{"dbbq", "橓"},
	{"dbcd", "棎"},
	{"dbcv", "櫻"},
	{"dbd", "棌"},
	{"dbdb", "棗 棘"},
	{"dbgr", "椆"},
	{"dbhx", "槄"},
	{"dbjj", "楎"},
	{"dbkf", "橪"},
	{"dbln", "刺"},
	{"dbm", "柤"},
	{"dbmc", "椇"},
	{"dbme", "楥"},
	{"dbmm", "枏 𣏵"},
	{"dbmr", "桐"},
	{"dbnd", "桴"},
	{"dbo", "僰"},
	{"dbou", "榣"},
	{"dbsd", "棦"},
	{"dbse", "棴"},
	{"dbt", "柵"},
	{"dbtu", "棡"},
	{"dbu", "相"},
	{"dbuc", "梖"},
	{"dbug", "欋"},
	{"dbul", "檙"},
	{"dbuu", "梘"},
	{"dbv", "桵"},
	{"dbvk", "榽"},
	{"dby", "枬"},
	{"dc", "朳"},
	{"dcav", "檭"},
	{"dchd", "椕"},
	{"dci", "松"},
	{"dcip", "棇"},
	{"dcms", "枍"},
	{"dcnh", "梯"},
	{"dcor", "㭲"},
	{"dcr", "柗"},
	{"dcru", "梲"},
	{"dcsh", "枌"},
	{"dcwa", "橧"},
	{"dd", "林"},
	{"ddam", "楂"},
	{"ddb", "栜"},
	{"ddbuh", "鬱"},
	{"ddcsh", "棼"},
	{"ddd", "森"},
	{"dddf", "㯲"},
	{"dddo", "檚"},
	{"ddec", "櫇"},
	{"ddf", "焚"},
	{"ddg", "埜"},
	{"ddh", "材"},
	{"ddhe", "柀"},
	{"ddhh", "彬"},
	{"ddhmu", "㯄"},
	{"ddhni", "梵 檒"},
	{"ddi", "村"},
	{"ddino", "椘"},
	{"ddixp", "麓"},
	{"ddj", "枺"},
	{"ddk", "樊"},
	{"ddkli", "蠜"},
	{"ddkmr", "礬"},
	{"ddkq", "攀"},
	{"ddl", "梀"},
	{"ddlk", "𣙙"},
	{"ddln", "楋"},
	{"ddlo", "樕"},
	{"ddmmf", "禁"},
	{"ddmmv", "辳"},
	{"ddmq", "椲"},
	{"ddmrt", "𧯴"},
	{"ddmwg", "𨤳"},
	{"ddni", "梦"},
	{"ddnkq", "㯬"},
	{"ddnl", "郴"},
	{"ddnyo", "楚"},
	{"ddoin", "棽"},
	{"ddoo", "棶"},
	{"ddp", "懋 𢡟"},
	{"ddv", "婪"},
	{"ddw", "棟 瑍"},
	{"ddwf", "楝"},
	{"ddwli", "欝"},
	{"dea", "㭼"},
	{"deed", "槡"},
	{"deee", "棳"},
	{"deem", "𣜖"},
	{"defh", "桫"},
	{"dei", "杈"},
	{"deid", "樑"},
	{"deln", "㓟"},
	{"dembc", "頗"},
	{"demj", "皯"},
	{"depru", "皰"},
	{"deygq", "㿹"},
	{"df", "杰 㭂 𣏹"},
	{"dfb", "梢"},
	{"dfbb", "𣙟"},
	{"dfbd", "橖"},
	{"dfbf", "欓"},
	{"dfbg", "樘"},
	{"dfbh", "橕"},
	{"dfbq", "𣛟"},
	{"dfbr", "㭻"},
	{"dfbw", "檔"},
	{"dfdq", "橉"},
	{"dff", "棪"},
	{"dffd", "𣞁 𣟕"},
	{"dffn", "橩"},
	{"dffs", "橯"},
	{"dfh", "杪"},
	{"dfle", "隸"},
	{"dfmu", "桄"},
	{"dfq", "柈"},
	{"dfqu", "棬"},
	{"dg", "杜"},
	{"dgb", "柟"},
	{"dgce", "棱"},
	{"dgg", "桂"},
	{"dggi", "槸"},
	{"dggu", "橈"},
	{"dgit", "榼"},
	{"dgji", "𣙀"},
	{"dgni", "檮"},
	{"dgov", "樾"},
	{"dgow", "檣"},
	{"dgp", "梽"},
	{"dgr", "桔"},
	{"dgrg", "檯"},
	{"dgrv", "榬"},
	{"dgti", "樹"},
	{"dgwc", "櫝"},
	{"dh", "才"},
	{"dha", "柏"},
	{"dhab", "棉"},
	{"dhag", "楻"},
	{"dhaj", "槔 槹"},
	{"dhal", "櫛"},
	{"dhbt", "桖"},
	{"dhbul", "鼒"},
	{"dhcq", "櫸 欅"},
	{"dhdf", "楸"},
	{"dhdl", "棅"},
	{"dhdw", "橎"},
	{"dhe", "板 皮"},
	{"dhej", "桻"},
	{"dher", "格"},
	{"dhey", "柊"},
	{"dhge", "檓"},
	{"dhgr", "梏"},
	{"dhgu", "㭠"},
	{"dhhaf", "鸉"},
	{"dhhh", "杉"},
	{"dhhi", "榭"},
	{"dhhj", "椑"},
	{"dhhl", "柳"},
	{"dhhw", "榴"},
	{"dhi", "槐"},
	{"dhij", "櫆"},
	{"dhio", "柉"},
	{"dhj", "杄"},
	{"dhja", "櫡"},
	{"dhjd", "株"},
	{"dhje", "椴"},
	{"dhjm", "棰"},
	{"dhjr", "栝"},
	{"dhju", "楯"},
	{"dhkb", "橋"},
	{"dhkl", "桥"},
	{"dhlb", "楀"},
	{"dhlc", "櫍"},
	{"dhlo", "𣔙"},
	{"dhml", "析"},
	{"dhms", "栃"},
	{"dhmu", "栀 梔"},
	{"dhmy", "柝"},
	{"dhn", "机"},
	{"dhnb", "𣑲"},
	{"dhne", "杸"},
	{"dhni", "杋 楓"},
	{"dhon", "桁 椼"},
	{"dhoo", "樅 𣠺"},
	{"dhpa", "棔 橁"},
	{"dhpm", "柢"},
	{"dhqm", "栍"},
	{"dhqo", "柣"},
	{"dhqu", "枆"},
	{"dhs", "柞"},
	{"dhsb", "楄"},
	{"dhsk", "檄"},
	{"dhsu", "槴"},
	{"dhtc", "檱"},
	{"dhuc", "欑"},
	{"dhus", "櫋"},
	{"dhuu", "橇"},
	{"dhvo", "柧"},
	{"dhwp", "樬"},
	{"dhx", "桕"},
	{"dhxo", "楰"},
	{"dhyg", "樦"},
	{"dhyu", "榹"},
	{"di", "寸 𣏾"},
	{"diav", "桹"},
	{"dibi", "榑"},
	{"dice", "梭"},
	{"didr", "𣟖"},
	{"difl", "榊"},
	{"digi", "櫥"},
	{"dihf", "槭"},
	{"dihr", "椷"},
	{"dihv", "楲"},
	{"dii", "棧"},
	{"diib", "樃"},
	{"diih", "槮"},
	{"diil", "榔"},
	{"dije", "梂"},
	{"dik", "枤"},
	{"dikk", "柭"},
	{"diku", "𣏞"},
	{"dilb", "槦"},
	{"dile", "槺"},
	{"dill", "栦"},
	{"diln", "刌"},
	{"dilr", "榶"},
	{"dimo", "栨"},
	{"dine", "栐 櫠"},
	{"ding", "榳"},
	{"dip", "杙"},
	{"dipc", "樲"},
	{"dipm", "栻"},
	{"dir", "枱"},
	{"dirm", "棫"},
	{"dism", "㮼"},
	{"dist", "𣛮"},
	{"dit", "械"},
	{"ditf", "樜"},
	{"dixp", "樚"},
	{"dj", "末"},
	{"djbc", "槙"},
	{"djbd", "桲"},
	{"djbf", "檫"},
	{"djbj", "楠"},
	{"djbm", "植 椬"},
	{"djc", "柼"},
	{"djcm", "椌"},
	{"djcr", "榕"},
	{"djcs", "榨"},
	{"dje", "枝"},
	{"djhr", "楁"},
	{"djii", "槫"},
	{"djip", "橞"},
	{"djji", "橶"},
	{"djjj", "檊"},
	{"djk", "杖"},
	{"djka", "楮"},
	{"djkp", "栳"},
	{"djks", "栲"},
	{"djlv", "棲"},
	{"djmc", "檳"},
	{"djmf", "棕"},
	{"djmm", "楦"},
	{"djmo", "椗 榢"},
	{"djmu", "梡"},
	{"djnu", "椀"},
	{"djp", "柁"},
	{"djpa", "榰"},
	{"djpb", "橣"},
	{"djpn", "檸"},
	{"djqp", "櫶"},
	{"djr", "枯"},
	{"djrb", "楜"},
	{"djrj", "橭"},
	{"djrr", "棺"},
	{"djt", "枿"},
	{"djtc", "橨"},
	{"djti", "𣟂"},
	{"djv", "桉"},
	{"djyj", "榟"},
	{"dk", "夬 杕"},
	{"dkb", "栯"},
	{"dkce", "樧"},
	{"dkcf", "橑"},
	{"dkgg", "楏"},
	{"dkhaf", "鴂 鷘"},
	{"dkhf", "梑"},
	{"dkkb", "桸"},
	{"dkkk", "樉"},
	{"dkld", "栫"},
	{"dkmb", "楕"},
	{"dkmr", "椅"},
	{"dkms", "桍"},
	{"dkmym", "整"},
	{"dkn", "朹 桋"},
	{"dknj", "枠"},
	{"dkok", "槉"},
	{"dkoo", "梜"},
	{"dkp", "憖"},
	{"dkpb", "㯂"},
	{"dkrd", "𣕧"},
	{"dks", "朸"},
	{"dkso", "槬"},
	{"dksr", "枷 檶"},
	{"dkss", "栛"},
	{"dl", "束"},
	{"dla", "晳"},
	{"dlbk", "柍"},
	{"dlbu", "枕"},
	{"dld", "梊"},
	{"dle", "棣"},
	{"dlks", "勅"},
	{"dlksf", "鶒"},
	{"dllmi", "蜤"},
	{"dlln", "剌 柫"},
	{"dlmc", "樻"},
	{"dlmo", "桃 𣑯"},
	{"dlmy", "棑"},
	{"dlno", "欶"},
	{"dlok", "敕"},
	{"dlp", "惁"},
	{"dlr", "𠵍"},
	{"dlshc", "賴"},
	{"dlw", "柚"},
	{"dlwl", "柛"},
	{"dlws", "梬"},
	{"dlwv", "樓"},
	{"dlx", "橚"},
	{"dlxh", "柹"},
	{"dlxl", "棩"},
	{"dm", "本 杠 杢"},
	{"dma", "栢"},
	{"dmam", "桓"},
	{"dmbb", "檽"},
	{"dmbc", "槓"},
	{"dmbe", "櫌"},
	{"dmbi", "橒"},
	{"dmbl", "栭"},
	{"dmbm", "欞"},
	{"dmbr", "櫺"},
	{"dmbs", "樗"},
	{"dmbw", "檑"},
	{"dmcw", "栖 梄"},
	{"dmd", "杅"},
	{"dmdm", "櫪"},
	{"dmem", "極"},
	{"dmf", "杯"},
	{"dmfb", "檷"},
	{"dmfj", "枰"},
	{"dmfm", "柸"},
	{"dmfn", "檦"},
	{"dmfr", "桮"},
	{"dmg", "枉"},
	{"dmgi", "櫉"},
	{"dmgr", "櫮"},
	{"dmgt", "梇"},
	{"dmhf", "榞"},
	{"dmia", "榗"},
	{"dmig", "桎"},
	{"dmj", "杆"},
	{"dmjk", "橄"},
	{"dmlk", "梗"},
	{"dmlm", "椏"},
	{"dmmf", "柰"},
	{"dmmi", "枟 橱"},
	{"dmmp", "欐"},
	{"dmmr", "梧"},
	{"dmms", "杇"},
	{"dmmu", "杬"},
	{"dmmv", "桭"},
	{"dmn", "朾"},
	{"dmnl", "桏"},
	{"dmnn", "栵"},
	{"dmnr", "柯"},
	{"dmob", "柄"},
	{"dmr", "柘"},
	{"dmrq", "韋"},
	{"dmrt", "梪"},
	{"dmrw", "楅"},
	{"dmsmm", "翉"},
	{"dmso", "椓"},
	{"dmsu", "枙"},
	{"dmt", "枅"},
	{"dmtb", "櫔"},
	{"dmti", "𣗳"},
	{"dmto", "橛"},
	{"dmu", "杌"},
	{"dmue", "榎"},
	{"dmvh", "枒"},
	{"dmvm", "枑 桱"},
	{"dmvs", "朽"},
	{"dmvvq", "舝"},
	{"dmwc", "檟"},
	{"dmwf", "槱 標"},
	{"dmwj", "橝"},
	{"dmwm", "橿"},
	{"dmwv", "楆"},
	{"dmym", "柾"},
	{"dnao", "橡"},
	{"dnbg", "桷"},
	{"dnbj", "槲"},
	{"dnbq", "檞"},
	{"dncr", "檐"},
	{"dnd", "杍 李"},
	{"dndf", "槂"},
	{"dndu", "𣏺"},
	{"dnfd", "櫯"},
	{"dng", "杻"},
	{"dnhb", "橘"},
	{"dnhd", "楙 楺"},
	{"dnhe", "极"},
	{"dnib", "桶"},
	{"dnii", "𣚦"},
	{"dnil", "栁"},
	{"dnin", "杼 栘"},
	{"dniq", "桝"},
	{"dnkg", "梃"},
	{"dnkm", "梴"},
	{"dnkq", "楗"},
	{"dnlb", "橢"},
	{"dnlw", "樄"},
	{"dnmu", "桅"},
	{"dno", "杴"},
	{"dnob", "楈"},
	{"dnoe", "橃"},
	{"dnok", "楑"},
	{"dnon", "櫈"},
	{"dnot", "橙"},
	{"dnq", "揧"},
	{"dnqd", "榤"},
	{"dnri", "欃"},
	{"dnst", "楹"},
	{"dnue", "㮀"},
	{"dnwa", "櫓"},
	{"doau", "𠌊"},
	{"dob", "枘"},
	{"dobg", "榷"},
	{"dobuc", "賚"},
	{"doby", "栴"},
	{"dodi", "柎"},
	{"doe", "桼"},
	{"dog", "椎"},
	{"dogf", "樵"},
	{"dogj", "榫"},
	{"dogs", "檇"},
	{"dohaf", "鶆"},
	{"doii", "柃"},
	{"doik", "猌"},
	{"doim", "櫼"},
	{"doin", "枔"},
	{"doip", "棯"},
	{"doir", "梒 槍"},
	{"doj", "杵"},
	{"dok", "枚"},
	{"dokr", "椥"},
	{"doks", "勑"},
	{"dolb", "樇"},
	{"dolh", "𣘀"},
	{"doma", "檜"},
	{"domb", "棆"},
	{"domc", "梹"},
	{"domd", "梌"},
	{"domg", "栓"},
	{"domk", "楩"},
	{"domm", "𣏴"},
	{"domn", "榆"},
	{"domo", "檢"},
	{"domr", "㭘"},
	{"domv", "楡"},
	{"don", "杚"},
	{"donl", "郲"},
	{"doo", "來"},
	{"doog", "桽"},
	{"dop", "杹"},
	{"dopd", "柂"},
	{"dotc", "𣗍"},
	{"dotf", "橅"},
	{"dowy", "梅"},
	{"doyb", "檎"},
	{"dp", "朼 杺"},
	{"dpa", "栒 栺"},
	{"dpd", "杝"},
	{"dpfd", "椈"},
	{"dph", "柲"},
	{"dpht", "榓"},
	{"dpi", "杓 构"},
	{"dpim", "枃"},
	{"dpkp", "楤"},
	{"dpp", "枇"},
	{"dppa", "楷"},
	{"dppd", "㰑"},
	{"dppg", "梐"},
	{"dpr", "枸"},
	{"dpru", "枹"},
	{"dpt", "枻"},
	{"dptd", "楪"},
	{"dpu", "杶"},
	{"dq", "杽"},
	{"dqbhx", "韜"},
	{"dqbjj", "韗"},
	{"dqdj", "韎"},
	{"dqfb", "韒"},
	{"dqgwc", "韥"},
	{"dqhaj", "韟"},
	{"dqhk", "楔"},
	{"dqikk", "韍"},
	{"dqjl", "梆"},
	{"dqjm", "槥"},
	{"dqjp", "櫘"},
	{"dqka", "椿"},
	{"dqkd", "榛"},
	{"dqkk", "楱"},
	{"dqkq", "棒"},
	{"dqkx", "樁"},
	{"dqmb", "棈"},
	{"dqmc", "樍"},
	{"dqmf", "榡"},
	{"dqnhd", "韖"},
	{"dqnl", "郼"},
	{"dqo", "枎"},
	{"dqoae", "䪖"},
	{"dqomr", "韐"},
	{"dqou", "槻"},
	{"dqptd", "韘"},
	{"dqshi", "韌"},
	{"dqsmv", "韔"},
	{"dqtmj", "韡"},
	{"dqttb", "韝"},
	{"dqwli", "韣"},
	{"dqwot", "韞"},
	{"dqwtj", "韠"},
	{"dqyrd", "韕"},
	{"dr", "杏"},
	{"drb", "梋"},
	{"drc", "枳"},
	{"drhg", "桯"},
	{"drhr", "梠"},
	{"drhs", "柺"},
	{"drhu", "柷"},
	{"drji", "檝"},
	{"drlb", "𣑐"},
	{"drmr", "㯝"},
	{"drms", "枵"},
	{"drrd", "橾"},
	{"drrj", "樿"},
	{"drrr", "榀"},
	{"drrs", "㮙"},
	{"drsh", "枴"},
	{"drsj", "楫"},
	{"dru", "𣏌"},
	{"drye", "椵"},
	{"dsav", "椻"},
	{"dseg", "樫"},
	{"dsfb", "榍"},
	{"dshr", "柖"},
	{"dshu", "梶"},
	{"dsit", "檻"},
	{"dsj", "栮"},
	{"dsje", "棷"},
	{"dsjl", "椰"},
	{"dsjr", "椐"},
	{"dskr", "桾"},
	{"dslc", "櫃"},
	{"dsly", "榧"},
	{"dsma", "槢"},
	{"dsme", "梫"},
	{"dsmg", "框 楃 櫂"},
	{"dsmh", "樛"},
	{"dsmi", "樳"},
	{"dsmj", "𣝦"},
	{"dsmm", "栩"},
	{"dsmr", "柌"},
	{"dsmv", "棖"},
	{"dsnd", "樼"},
	{"dsno", "柩"},
	{"dsp", "柅"},
	{"dsqf", "榪"},
	{"dsql", "梛"},
	{"dsrg", "檉"},
	{"dsrr", "樞"},
	{"dss", "柜"},
	{"dssr", "梮"},
	{"dstt", "𣖕"},
	{"dstv", "榐"},
	{"dsu", "杞"},
	{"dsuf", "𣜠"},
	{"dswl", "㭱"},
	{"dswu", "欖"},
	{"dsyi", "欘"},
	{"dsyq", "樨"},
	{"dta", "棤"},
	{"dtab", "橗"},
	{"dtak", "模"},
	{"dtaw", "欗"},
	{"dtbf", "𣜭"},
	{"dtbn", "椾"},
	{"dtbo", "檬"},
	{"dtc", "栱"},
	{"dtcd", "檏"},
	{"dtce", "欉"},
	{"dtcg", "樭"},
	{"dtco", "樸"},
	{"dtcw", "楢"},
	{"dtei", "欂"},
	{"dtge", "樣"},
	{"dtgf", "榚"},
	{"dtgi", "檥"},
	{"dtgk", "𣖙"},
	{"dtgo", "檨"},
	{"dtgr", "橏"},
	{"dtgs", "㰕"},
	{"dthj", "樥"},
	{"dtif", "𣞢"},
	{"dtih", "𣕚"},
	{"dtio", "𣔰"},
	{"dtit", "𣙷"},
	{"dtjm", "𣜯"},
	{"dtjr", "楛 㯴"},
	{"dtk", "栚"},
	{"dtkr", "楉"},
	{"dtlb", "樠"},
	{"dtlj", "㮖"},
	{"dtlk", "楧"},
	{"dtlm", "槿"},
	{"dtlx", "櫹"},
	{"dtm", "柑"},
	{"dtmc", "棋 橫"},
	{"dtmd", "楳"},
	{"dtmj", "樺"},
	{"dtmv", "椹"},
	{"dtoe", "檴"},
	{"dtog", "𣗎"},
	{"dtop", "椛"},
	{"dtor", "榙"},
	{"dtov", "𣞼"},
	{"dtpa", "槆"},
	{"dtpd", "𣚭 𣜿"},
	{"dtpp", "檧"},
	{"dtq", "样"},
	{"dtqm", "槎"},
	{"dtrg", "權"},
	{"dtrk", "㯳"},
	{"dtsj", "榵"},
	{"dtsr", "櫙"},
	{"dtt", "栟"},
	{"dttb", "構"},
	{"dttc", "椪"},
	{"dtwa", "槽"},
	{"dtwf", "𣜃"},
	{"dtwi", "樽"},
	{"dtwv", "檂"},
	{"dtxc", "槏"},
	{"du", "札"},
	{"duce", "椶"},
	{"duch", "梤"},
	{"duhj", "𣗏"},
	{"dulmi", "蚻"},
	{"dumb", "椯"},
	{"dumt", "榿"},
	{"duob", "欈"},
	{"duon", "梣"},
	{"dup", "想"},
	{"duu", "柮"},
	{"duvif", "紮"},
	{"dvfo", "櫞"},
	{"dvid", "櫟"},
	{"dvii", "機"},
	{"dvis", "柪"},
	{"dvl", "朻"},
	{"dvmg", "梉"},
	{"dvmt", "㰘 𣟗"},
	{"dvne", "椂"},
	{"dvno", "椽"},
	{"dvoi", "欚"},
	{"dvvd", "樔"},
	{"dvvi", "檵"},
	{"dvvw", "椔"},
	{"dw", "東"},
	{"dwb", "𣖜"},
	{"dwc", "柶"},
	{"dwd", "梱 棵"},
	{"dwf", "柬"},
	{"dwg", "梩"},
	{"dwhaf", "鶇 鶫"},
	{"dwhd", "棞"},
	{"dwim", "槶"},
	{"dwjc", "樌"},
	{"dwji", "檲"},
	{"dwjr", "棝"},
	{"dwk", "栶"},
	{"dwl", "柙"},
	{"dwlg", "欏"},
	{"dwlj", "檡"},
	{"dwls", "楞"},
	{"dwly", "檌"},
	{"dwmv", "椳"},
	{"dwot", "榲"},
	{"dwp", "楒"},
	{"dwvf", "樏"},
	{"dww", "榃"},
	{"dwwf", "欙"},
	{"dwww", "櫑"},
	{"dwyi", "栂"},
	{"dy", "朴"},
	{"dyad", "槕"},
	{"dyaj", "棹"},
	{"dybb", "楴 檛"},
	{"dybc", "楨"},
	{"dybp", "櫳"},
	{"dybs", "榜"},
	{"dycb", "樀"},
	{"dyck", "校"},
	{"dydk", "橔"},
	{"dydl", "槨"},
	{"dydu", "櫬"},
	{"dyfe", "椒"},
	{"dyg", "柱"},
	{"dyhh", "楌"},
	{"dyhn", "杭"},
	{"dyhr", "槌"},
	{"dyhs", "枋"},
	{"dyhv", "𣐿"},
	{"dyia", "樴"},
	{"dyij", "𣘚"},
	{"dyiu", "梳"},
	{"dyj", "枓"},
	{"dyjj", "槤"},
	{"dyk", "𣐀"},
	{"dylb", "柿"},
	{"dylm", "杫"},
	{"dymh", "檅"},
	{"dymu", "櫏"},
	{"dynb", "樋"},
	{"dynv", "橠"},
	{"dyoj", "椊"},
	{"dypf", "橴"},
	{"dypk", "榩"},
	{"dypm", "樝"},
	{"dypt", "櫨"},
	{"dypu", "椃"},
	{"dyr", "枮"},
	{"dyra", "櫧"},
	{"dyrb", "槁"},
	{"dyrd", "椁"},
	{"dyrf", "椋"},
	{"dyrn", "梈 楟"},
	{"dyro", "檺"},
	{"dyrv", "欀"},
	{"dysd", "椸"},
	{"dysr", "檹"},
	{"dysy", "棜"},
	{"dyt", "柆"},
	{"dytg", "橦"},
	{"dytj", "梓 樟"},
	{"dyto", "檖"},
	{"dytp", "檍"},
	{"dytr", "棓"},
	{"dytu", "樈 檤"},
	{"dytv", "椄"},
	{"dyub", "樆"},
	{"dyut", "橀"},
	{"dyv", "杧"},
	{"dyvo", "核"},
	{"dywd", "檁"},
	{"dywm", "檀"},
	{"dywv", "榱 櫰"},
	{"dyx", "櫅"},
	{"e", "水"},
	{"ea", "汨 汩 沓"},
	{"eaa", "淐"},
	{"eabt", "温"},
	{"eafc", "灝 灦"},
	{"eafu", "滉"},
	{"eag", "涅"},
	{"eagi", "溾"},
	{"eahm", "湦"},
	{"eahr", "㵆"},
	{"eahu", "湄"},
	{"eaiu", "溉"},
	{"eam", "泹 𣵀"},
	{"eamh", "湯"},
	{"eami", "淂"},
	{"eamj", "涆"},
	{"eamk", "淏"},
	{"eamo", "湜"},
	{"eana", "澗"},
	{"eanb", "㵎"},
	{"eand", "澖"},
	{"eane", "灁"},
	{"eang", "潤"},
	{"eanj", "灛"},
	{"eank", "潣"},
	{"eano", "灍"},
	{"eanr", "濶"},
	{"eanw", "瀾"},
	{"eapp", "混"},
	{"eapv", "渴"},
	{"easm", "溻"},
	{"easr", "𣸬"},
	{"eate", "瀑"},
	{"eav", "泿"},
	{"eavf", "濕"},
	{"eawe", "漫"},
	{"eayf", "澋"},
	{"eayk", "渂"},
	{"eayt", "𣸭"},
	{"ebac", "溟"},
	{"ebau", "淝"},
	{"ebb", "淜"},
	{"ebbb", "滑"},
	{"ebbr", "渦"},
	{"ebbu", "漞"},
	{"ebcd", "深"},
	{"ebch", "瀃"},
	{"ebci", "濺"},
	{"ebcn", "測"},
	{"ebcr", "浻"},
	{"ebcv", "瀴"},
	{"ebd", "𣶶"},
	{"ebdd", "𣺉"},
	{"ebg", "𡒗"},
	{"ebgr", "淍"},
	{"ebhg", "淫"},
	{"ebhu", "沉"},
	{"ebhx", "滔"},
	{"ebjj", "渾"},
	{"ebkf", "鸂"},
	{"ebm", "沮"},
	{"ebme", "湲"},
	{"ebmp", "濦"},
	{"ebmr", "洞"},
	{"ebnd", "浮"},
	{"eboe", "𣿀"},
	{"ebof", "漈"},
	{"ebou", "滛"},
	{"ebp", "慂 懘 懣"},
	{"ebr", "泂"},
	{"ebsd", "淨"},
	{"ebt", "㳑"},
	{"ebtu", "𣷣"},
	{"ebu", "泪"},
	{"ebuc", "浿"},
	{"ebug", "濉 灈"},
	{"ebuh", "渺"},
	{"ebuk", "湨"},
	{"ebul", "濎"},
	{"ebuu", "涀"},
	{"ebv", "浽"},
	{"ebvk", "溪"},
	{"ebwi", "灂"},
	{"ebyh", "浵"},
	{"ebyj", "𣂎"},
	{"ec", "汃 淦"},
	{"ecc", "鍙"},
	{"eccc", "𤅺"},
	{"ecnh", "涕"},
	{"ecor", "浴"},
	{"ecr", "沿"},
	{"ecru", "涗"},
	{"ecsh", "汾"},
	{"ecst", "湓"},
	{"ecwa", "潧"},
	{"ed", "沐"},
	{"edam", "渣"},
	{"edbt", "盓"},
	{"edbu", "湘"},
	{"edci", "淞"},
	{"edd", "淋"},
	{"eddd", "潹"},
	{"eddf", "澿"},
	{"eddg", "漜"},
	{"eddh", "灪"},
	{"eddn", "滼"},
	{"eddo", "濋"},
	{"eddv", "漤 𤂑"},
	{"edg", "塗"},
	{"edgg", "溦"},
	{"edha", "湐"},
	{"edhe", "波"},
	{"edhh", "涁"},
	{"edhl", "淅"},
	{"edj", "沫"},
	{"edk", "決"},
	{"edl", "涑"},
	{"edlc", "瀨 瀬"},
	{"edlk", "潄"},
	{"edlo", "漱"},
	{"edm", "泍"},
	{"edmbc", "顙"},
	{"edmd", "𣸑"},
	{"edmf", "渿"},
	{"edmq", "湋"},
	{"ednf", "𤄄"},
	{"edod", "𣸯"},
	{"edoe", "漆"},
	{"edoo", "淶"},
	{"edvd", "𤄿"},
	{"edw", "涷"},
	{"edwf", "湅"},
	{"ee", "双 汉 沝 𣲙"},
	{"eea", "涾"},
	{"eec", "錃"},
	{"eee", "叒 淼"},
	{"eeed", "桑"},
	{"eeeee", "敪"},
	{"eeeef", "鵽"},
	{"eeeen", "剟"},
	{"eeeeo", "欼"},
	{"eeeeu", "毲"},
	{"eeem", "叠 𣿫"},
	{"eei", "汊"},
	{"eeii", "溞"},
	{"eemr", "碆"},
	{"eeog", "滩"},
	{"eetb", "濷"},
	{"eev", "婆"},
	{"efb", "消"},
	{"efbb", "𣻸"},
	{"efbg", "漟"},
	{"efbk", "潎"},
	{"efbr", "淌"},
	{"efbw", "澢"},
	{"efdc", "瀵"},
	{"efdq", "潾"},
	{"eff", "淡 𣶷"},
	{"effc", "灐"},
	{"effd", "濚"},
	{"effe", "濴"},
	{"efff", "濙 瀠"},
	{"effg", "瀅"},
	{"effr", "瀯"},
	{"effs", "澇"},
	{"efh", "沙"},
	{"efhu", "渻"},
	{"efmu", "洸"},
	{"efq", "泮"},
	{"efqf", "潫"},
	{"eg", "圣 坔"},
	{"egce", "淩"},
	{"egcg", "淕"},
	{"egde", "濲 瀔"},
	{"egfe", "瀫"},
	{"egg", "塣 洼"},
	{"eggu", "澆"},
	{"egi", "法"},
	{"egit", "溘"},
	{"egj", "準"},
	{"eglc", "浾"},
	{"egni", "濤"},
	{"egow", "濇"},
	{"egr", "洁"},
	{"egrc", "𤂌"},
	{"egrr", "𤀺"},
	{"egrv", "滍"},
	{"egsk", "滶"},
	{"egth", "澎"},
	{"egti", "澍"},
	{"egtj", "涬"},
	{"egwc", "瀆"},
	{"eha", "泊"},
	{"ehae", "湶"},
	{"ehag", "湟"},
	{"ehal", "瀄"},
	{"ehar", "澔"},
	{"ehbd", "㶅"},
	{"ehbk", "澳"},
	{"ehbn", "淛"},
	{"ehbt", "洫 盪"},
	{"ehbu", "洎 灚"},
	{"ehby", "洀"},
	{"ehcn", "瀏"},
	{"ehd", "𣓥"},
	{"ehdb", "潲"},
	{"ehde", "潻"},
	{"ehdf", "湫"},
	{"ehdg", "𣽿"},
	{"ehdl", "𣶸"},
	{"ehdn", "浰 𣻗"},
	{"ehdp", "溒"},
	{"ehds", "𣵛"},
	{"ehdv", "涹"},
	{"ehdw", "潘"},
	{"ehe", "汳"},
	{"ehed", "涤"},
	{"ehej", "浲"},
	{"eheq", "洚"},
	{"eher", "洛"},
	{"ehet", "瀊"},
	{"ehf", "燙"},
	{"ehg", "𡌂"},
	{"ehgi", "𤅕"},
	{"ehgr", "浩"},
	{"ehgu", "洗"},
	{"ehhl", "泖"},
	{"ehhv", "派"},
	{"ehhw", "溜"},
	{"ehic", "𤅄"},
	{"ehio", "泛"},
	{"ehj", "汘"},
	{"ehjd", "洙"},
	{"ehjg", "湩"},
	{"ehjr", "活"},
	{"ehk", "沃"},
	{"ehkb", "𣾷"},
	{"ehkp", "添"},
	{"ehlb", "渪"},
	{"ehlq", "潷"},
	{"ehlx", "𤄙"},
	{"ehmgi", "璗"},
	{"ehml", "沂"},
	{"ehmo", "澨"},
	{"ehmr", "洉 硰"},
	{"ehmy", "泝"},
	{"ehnb", "𣳽"},
	{"ehnd", "𣳼"},
	{"ehnf", "㵯"},
	{"ehni", "汎 渢"},
	{"ehnn", "洬"},
	{"ehnwf", "鯊"},
	{"ehoe", "澓"},
	{"ehok", "㵟"},
	{"ehon", "洐 𣶹"},
	{"ehoo", "漇 漎"},
	{"ehou", "㵌"},
	{"ehpa", "涽"},
	{"ehpm", "泜"},
	{"ehq", "挲"},
	{"ehqi", "涐"},
	{"ehqj", "湃"},
	{"ehqm", "泩"},
	{"ehqo", "泆"},
	{"ehrb", "溎"},
	{"ehrf", "𪄣"},
	{"ehs", "泎"},
	{"ehsd", "淭"},
	{"ehse", "溵"},
	{"ehsk", "淚 激"},
	{"ehsu", "滬"},
	{"ehuc", "瀩 灒"},
	{"ehuk", "溴"},
	{"ehul", "濞"},
	{"ehv", "娑"},
	{"ehvo", "泒"},
	{"ehvp", "汦"},
	{"ehwp", "漗"},
	{"ehx", "㳫"},
	{"ehxf", "潟"},
	{"ehxm", "湼"},
	{"ehxu", "淣"},
	{"ehyhv", "裟"},
	{"ehyu", "㴲"},
	{"ei", "叉"},
	{"eiav", "浪"},
	{"eibi", "溥"},
	{"eice", "浚"},
	{"eid", "梁"},
	{"eidy", "灖"},
	{"eifd", "粱"},
	{"eihf", "滅"},
	{"eihq", "洠"},
	{"eihr", "減"},
	{"eihu", "沇"},
	{"eii", "淺"},
	{"eiih", "滲"},
	{"eijb", "浦"},
	{"eijc", "沭"},
	{"eije", "浗"},
	{"eik", "汱"},
	{"eikf", "溈"},
	{"eikk", "沷"},
	{"eiku", "沋"},
	{"eilb", "滽"},
	{"eile", "漮"},
	{"eill", "洲"},
	{"eilmi", "蚤"},
	{"eilr", "溏"},
	{"eine", "泳"},
	{"eioc", "澬"},
	{"eiok", "涘"},
	{"eipf", "瀌"},
	{"eir", "治"},
	{"eirm", "淢"},
	{"eirp", "澸"},
	{"eis", "沪"},
	{"eitc", "濂 瀇"},
	{"eite", "渡"},
	{"eiv", "泧"},
	{"eiwg", "瀍"},
	{"eixi", "灋"},
	{"eixp", "漉"},
	{"ej", "汁"},
	{"ejb", "沛"},
	{"ejbc", "滇"},
	{"ejbd", "浡"},
	{"ejbj", "湳"},
	{"ejbm", "淔 𣶺"},
	{"ejbv", "灢"},
	{"ejc", "泬"},
	{"ejcb", "潸"},
	{"ejck", "湥"},
	{"ejcm", "涳"},
	{"ejco", "溛"},
	{"ejcr", "溶"},
	{"ejd", "沬 浨"},
	{"ejdk", "漖"},
	{"ejds", "渤"},
	{"eje", "汥"},
	{"ejhf", "瀉"},
	{"ejhq", "浶"},
	{"ejhw", "瀋"},
	{"ejic", "瀻"},
	{"ejii", "漙"},
	{"ejik", "涋"},
	{"ejip", "潓"},
	{"ejir", "渽"},
	{"ejjb", "潮"},
	{"ejjj", "澣 濣"},
	{"ejjl", "漸"},
	{"ejjm", "瀚"},
	{"ejjn", "漧"},
	{"ejka", "渚"},
	{"ejkd", "涍"},
	{"ejki", "浤"},
	{"ejks", "洘"},
	{"ejlo", "𣶏"},
	{"ejlv", "淒"},
	{"ejmc", "演 濱"},
	{"ejmd", "𣳿"},
	{"ejme", "滱"},
	{"ejmf", "淙"},
	{"ejmm", "渲"},
	{"ejmn", "泞"},
	{"ejmo", "淀 𣺊"},
	{"ejmu", "浣"},
	{"ejnu", "涴"},
	{"ejoc", "滨"},
	{"ejp", "沱"},
	{"ejpb", "澝 𤀑"},
	{"ejpn", "濘"},
	{"ejpu", "滵"},
	{"ejqp", "瀗"},
	{"ejr", "沽"},
	{"ejrb", "湖"},
	{"ejrr", "涫"},
	{"ejt", "泋"},
	{"ejtc", "濆"},
	{"ejv", "洝"},
	{"ejye", "漃"},
	{"ejyj", "滓"},
	{"ek", "汏"},
	{"ekb", "洧"},
	{"ekc", "鋈"},
	{"ekcf", "潦"},
	{"ekf", "洃"},
	{"ekha", "潴"},
	{"ekhr", "漪"},
	{"eki", "汯 汰"},
	{"ekjt", "渀"},
	{"ekkb", "浠 淆"},
	{"ekkk", "漺"},
	{"eklb", "㳍"},
	{"ekld", "洊"},
	{"eklu", "淹"},
	{"ekm", "𣳇"},
	{"ekmr", "渏"},
	{"ekms", "洿"},
	{"ekn", "氿 洟"},
	{"ekni", "汍"},
	{"ekoo", "浹"},
	{"ekpb", "滯"},
	{"ekrc", "㵑"},
	{"eks", "氻"},
	{"eksr", "泇"},
	{"el", "沖"},
	{"elbk", "泱"},
	{"elbu", "沈"},
	{"elc", "𨮜"},
	{"elfl", "渊"},
	{"elg", "垽"},
	{"elgm", "澅"},
	{"elhi", "魙"},
	{"elim", "渱 灗"},
	{"elll", "汌 沜"},
	{"elln", "沸"},
	{"ellp", "漶"},
	{"elmc", "潰"},
	{"elmo", "洮"},
	{"elmt", "濜"},
	{"elmy", "渄"},
	{"elq", "津"},
	{"elvu", "湚"},
	{"elw", "油"},
	{"elwp", "洩"},
	{"elws", "涄"},
	{"elwv", "漊"},
	{"elx", "潚"},
	{"elxh", "泲"},
	{"elxl", "淵"},
	{"em", "江"},
	{"ema", "洦"},
	{"emam", "洹"},
	{"embb", "濡 灞"},
	{"embc", "湏"},
	{"embe", "瀀"},
	{"embg", "瀖"},
	{"embi", "澐 澪 瀜"},
	{"embk", "渜"},
	{"embl", "洏"},
	{"embm", "𤅷"},
	{"embr", "𤅟"},
	{"embu", "灀"},
	{"embw", "㵢"},
	{"emcw", "洒 酒"},
	{"emd", "汙"},
	{"emdm", "瀝"},
	{"emdp", "𤃉"},
	{"emfb", "濔"},
	{"emfi", "𤅜"},
	{"emfj", "泙"},
	{"emg", "汪"},
	{"emgb", "洅"},
	{"emgg", "涯"},
	{"emgh", "濏"},
	{"emgr", "𣾏"},
	{"emgu", "潖"},
	{"emhf", "源 鴻"},
	{"emia", "滏"},
	{"emig", "洷"},
	{"emj", "汗"},
	{"emjk", "澉"},
	{"emjs", "汚"},
	{"emlk", "浭"},
	{"emlm", "𣵾"},
	{"emls", "沔"},
	{"emmc", "澒"},
	{"emmf", "沶"},
	{"emmi", "沄"},
	{"emmp", "灑"},
	{"emmr", "浯"},
	{"emms", "污"},
	{"emmu", "沅"},
	{"emmv", "浱"},
	{"emn", "汀"},
	{"emnn", "洌"},
	{"emnr", "河"},
	{"emoa", "瀦"},
	{"emr", "沯 沰"},
	{"emrb", "滆"},
	{"emrr", "滒"},
	{"emrt", "浢"},
	{"emru", "𣸰"},
	{"emrw", "湢"},
	{"emso", "涿"},
	{"emt", "汧"},
	{"emtb", "濿"},
	{"emti", "㴻"},
	{"emua", "潛"},
	{"emub", "灊"},
	{"emvb", "漘"},
	{"emvg", "溼"},
	{"emvi", "溽"},
	{"emvm", "沍 涇"},
	{"emwd", "溧"},
	{"emwf", "漂"},
	{"emwg", "湮 湹"},
	{"emwj", "潭"},
	{"emwl", "湎"},
	{"emyf", "漹"},
	{"emym", "泟"},
	{"enao", "潒"},
	{"enau", "浼"},
	{"enbk", "渙"},
	{"enbq", "澥"},
	{"enbs", "湧"},
	{"encr", "澹"},
	{"end", "染"},
	{"ene", "沒"},
	{"enem", "洆"},
	{"enff", "𤄏"},
	{"enhb", "潏"},
	{"enhd", "渘"},
	{"enhe", "汲"},
	{"enhx", "淊"},
	{"eni", "汐 泓"},
	{"enib", "涌"},
	{"enii", "漒"},
	{"enin", "汿 沀"},
	{"enir", "洺"},
	{"enj", "汛"},
	{"enkg", "涏"},
	{"enkm", "涎"},
	{"enkq", "湕"},
	{"enkw", "𣶻"},
	{"enla", "𣾂"},
	{"enlb", "瀡"},
	{"enlc", "濻"},
	{"enld", "滁"},
	{"enlm", "漋"},
	{"enlp", "㶏"},
	{"enls", "泐"},
	{"enmb", "瀰"},
	{"enmm", "溺"},
	{"enmu", "洈"},
	{"ennc", "澦"},
	{"enob", "湑"},
	{"enoe", "潑"},
	{"enok", "湀"},
	{"enot", "澄"},
	{"enqd", "滘"},
	{"enri", "瀺"},
	{"ensj", "渳"},
	{"enst", "溋"},
	{"ensv", "漲"},
	{"enue", "涵"},
	{"enwf", "漁"},
	{"eoah", "漡"},
	{"eob", "汭"},
	{"eobt", "盜"},
	{"eod", "㳜"},
	{"eode", "溆"},
	{"eodi", "泭"},
	{"eodk", "漵"},
	{"eog", "淮"},
	{"eogd", "潗"},
	{"eogf", "潐"},
	{"eohh", "沴"},
	{"eoii", "泠 𣸮"},
	{"eoik", "洑"},
	{"eoim", "瀸"},
	{"eoin", "汵"},
	{"eoip", "淰"},
	{"eoir", "浛 滄"},
	{"eoj", "汻"},
	{"eokf", "瀿"},
	{"eokp", "滺"},
	{"eokr", "𣺈"},
	{"eolb", "滫 潃"},
	{"eold", "滌"},
	{"eolk", "浟"},
	{"eom", "㳋"},
	{"eoma", "澮"},
	{"eomb", "淪 瀹"},
	{"eomc", "浜"},
	{"eomd", "涂"},
	{"eomg", "洤"},
	{"eomm", "潝 𣲚"},
	{"eomn", "汽 渝"},
	{"eomo", "澰"},
	{"eomr", "洽 涻"},
	{"eomt", "渰"},
	{"eon", "汔"},
	{"eond", "溙"},
	{"eoob", "溍"},
	{"eook", "瀲"},
	{"eooo", "㶑"},
	{"eop", "沎"},
	{"eopd", "沲"},
	{"eora", "潪"},
	{"eosk", "洢"},
	{"eotf", "潕"},
	{"eoto", "濮"},
	{"eou", "𣳈"},
	{"eowy", "海"},
	{"eoyt", "涖"},
	{"ep", "沁"},
	{"epa", "洵 𣇹"},
	{"epd", "柒 池"},
	{"epdc", "𤃡"},
	{"epfd", "淗"},
	{"eph", "泌"},
	{"ephh", "沕"},
	{"ephp", "淴"},
	{"ephr", "湉"},
	{"epi", "汋 沟"},
	{"epim", "汮"},
	{"epl", "浺"},
	{"epou", "淘"},
	{"epp", "沘"},
	{"eppa", "湝"},
	{"epr", "泃"},
	{"epru", "泡"},
	{"epsh", "沏"},
	{"ept", "泄"},
	{"eptd", "渫"},
	{"epu", "沌"},
	{"epuk", "洶"},
	{"epyr", "渹"},
	{"eqbd", "瀞"},
	{"eqbi", "𤂅"},
	{"eqg", "堻"},
	{"eqhf", "潔"},
	{"eqhl", "浙"},
	{"eqjr", "湱"},
	{"eqka", "湷"},
	{"eqkd", "溱"},
	{"eqke", "溰"},
	{"eqkk", "湊"},
	{"eqmb", "清"},
	{"eqmc", "漬"},
	{"eqmf", "溸 溹"},
	{"eqoa", "潜"},
	{"eqor", "湁"},
	{"er", "呇"},
	{"erau", "浥"},
	{"erb", "涓"},
	{"erbc", "滜"},
	{"erc", "𣲵"},
	{"erhg", "浧"},
	{"erhu", "況"},
	{"erji", "濈"},
	{"ermr", "潞"},
	{"erp", "惉"},
	{"erpa", "湣"},
	{"errd", "澡"},
	{"errj", "潬"},
	{"ersj", "湒"},
	{"eru", "汜"},
	{"eruc", "潠"},
	{"ervk", "洖"},
	{"ervp", "泯"},
	{"erxu", "澠"},
	{"eryo", "浞"},
	{"esbn", "涮"},
	{"esce", "澱"},
	{"esd", "渠"},
	{"eseg", "𣻹 𣿬"},
	{"eseo", "㵵"},
	{"esfi", "𣻷"},
	{"eshr", "沼"},
	{"eshu", "浘"},
	{"esim", "澀"},
	{"esip", "涊"},
	{"esit", "濫"},
	{"esj", "洱"},
	{"esja", "潳"},
	{"esjj", "灄"},
	{"esjr", "涺"},
	{"eskr", "涒"},
	{"eslc", "㶊"},
	{"esll", "洍"},
	{"esmb", "漏"},
	{"esmc", "瀷"},
	{"esme", "浸"},
	{"esmg", "洭 渥 濯"},
	{"esmh", "漻"},
	{"esmi", "潯"},
	{"esmj", "濢"},
	{"esmr", "泀"},
	{"esmv", "涱"},
	{"esnd", "潺"},
	{"eso", "沢"},
	{"esog", "滙 𣾀"},
	{"esp", "泥"},
	{"esqf", "溲"},
	{"esrj", "澼"},
	{"esrr", "漚"},
	{"ess", "洰"},
	{"estt", "𣸹"},
	{"estv", "𣺹"},
	{"esu", "氾"},
	{"esuf", "𤏁"},
	{"esuu", "淈"},
	{"eswu", "灠"},
	{"esyi", "灟"},
	{"esyq", "漽"},
	{"etak", "漠"},
	{"etaw", "灡"},
	{"etbc", "淟 𤅎"},
	{"etbg", "滢"},
	{"etbn", "湔"},
	{"etbo", "濛"},
	{"etc", "洪"},
	{"etca", "潽"},
	{"etcd", "澲"},
	{"etcf", "濝 𪃡"},
	{"etcg", "𣻺"},
	{"etch", "𣶼"},
	{"etcl", "澌"},
	{"etco", "𣾴"},
	{"etct", "溢"},
	{"etcu", "港"},
	{"etge", "漾"},
	{"etgf", "溔"},
	{"etgi", "濧 𣿭"},
	{"etgk", "渼"},
	{"etgo", "㵪"},
	{"etgt", "濭"},
	{"ethg", "𣿅"},
	{"ethn", "𣼵"},
	{"etif", "瀳"},
	{"etio", "𣷸"},
	{"etit", "漭"},
	{"etju", "𣻻"},
	{"etk", "浂"},
	{"etkn", "渕"},
	{"etkr", "渃"},
	{"etlb", "滿"},
	{"etlk", "渶"},
	{"etlm", "漌"},
	{"etlo", "漢"},
	{"etlx", "瀟"},
	{"etm", "泔"},
	{"etmbc", "頮"},
	{"etmc", "淇 潢"},
	{"etmi", "𣶽"},
	{"etmj", "澕"},
	{"etmr", "渮"},
	{"etmv", "湛"},
	{"etmw", "𣺋"},
	{"etnk", "𣿮"},
	{"etnu", "𣸱"},
	{"etoe", "濩"},
	{"etog", "灘"},
	{"etor", "溚 濸"},
	{"etov", "瀁"},
	{"etpd", "㵩"},
	{"etpp", "濍"},
	{"etq", "洋"},
	{"etqm", "溠"},
	{"etrg", "灌"},
	{"etse", "𣿯"},
	{"etst", "灆"},
	{"ett", "汫 洴"},
	{"ettb", "溝"},
	{"ettc", "湴 𣾁"},
	{"ettu", "灔"},
	{"etub", "溯"},
	{"etvd", "𤂋"},
	{"etvi", "滋"},
	{"etvp", "濨"},
	{"etw", "浀 渵"},
	{"etwa", "漕"},
	{"etwb", "澫"},
	{"etwi", "澊 瀎"},
	{"etwt", "澧"},
	{"etwv", "濃"},
	{"etxc", "溓"},
	{"etyc", "𤅖"},
	{"etyj", "𤂍"},
	{"etym", "淽"},
	{"etys", "淓"},
	{"eu", "汕"},
	{"eubb", "漰"},
	{"euc", "鍌 鎏"},
	{"eugk", "澂"},
	{"euhj", "𣺿"},
	{"eujf", "漴"},
	{"eujt", "灃"},
	{"euk", "汹"},
	{"eumb", "湍"},
	{"eumf", "湠"},
	{"eumg", "漄"},
	{"eumgi", "瑬"},
	{"euog", "漼"},
	{"euon", "涔"},
	{"eutt", "灩"},
	{"eutu", "灧"},
	{"euu", "泏"},
	{"euud", "𤀻"},
	{"ev", "汝"},
	{"evfb", "𤁗"},
	{"evfd", "灤"},
	{"evfe", "𤀼"},
	{"evfg", "濰"},
	{"evfn", "灣"},
	{"evfr", "𤀽"},
	{"evid", "濼"},
	{"evis", "泑"},
	{"evne", "淥"},
	{"evr", "洳"},
	{"evug", "灉"},
	{"evvd", "漅"},
	{"evvw", "淄"},
	{"ew", "沺 畓"},
	{"ewb", "渭"},
	{"ewc", "泗 𣳉"},
	{"ewd", "涃 淉"},
	{"ewdq", "潿"},
	{"ewe", "𣲷"},
	{"ewfq", "滃"},
	{"ewg", "浬"},
	{"ewgf", "潶"},
	{"ewim", "漍"},
	{"ewjr", "涸"},
	{"ewk", "洇"},
	{"ewlb", "湡"},
	{"ewli", "濁"},
	{"ewlj", "澤"},
	{"ewln", "瀱"},
	{"ewlo", "潀 𣽁"},
	{"ewlv", "澴"},
	{"ewml", "淠"},
	{"ewmo", "溷"},
	{"ewmv", "渨"},
	{"ewno", "歠"},
	{"ewo", "泅"},
	{"ewot", "溫"},
	{"ewp", "㴓"},
	{"ewr", "洄"},
	{"ewtc", "潩"},
	{"ewtj", "滭"},
	{"ewvf", "漯"},
	{"ewwg", "灅"},
	{"ewww", "㵽"},
	{"eyaj", "淖"},
	{"eybb", "渧 濄"},
	{"eybc", "湞"},
	{"eybg", "灕"},
	{"eybk", "澈"},
	{"eybp", "瀧"},
	{"eybr", "𣽊"},
	{"eybs", "滂"},
	{"eybu", "濬 𣿰"},
	{"eycb", "滴"},
	{"eyck", "洨 湙"},
	{"eycv", "滚 滾"},
	{"eydk", "潡"},
	{"eydl", "漷 澵"},
	{"eydu", "瀙"},
	{"eyed", "澯"},
	{"eyem", "瀣"},
	{"eyfe", "淑"},
	{"eyg", "注"},
	{"eygq", "澾"},
	{"eyhc", "濓 瀕"},
	{"eyhm", "滻"},
	{"eyhn", "沆"},
	{"eyhs", "汸"},
	{"eyhv", "㳖"},
	{"eyib", "淯"},
	{"eyiu", "流"},
	{"eyjc", "灨"},
	{"eyjj", "漣"},
	{"eyk", "汶"},
	{"eykl", "济"},
	{"eylc", "洂 瀢"},
	{"eylh", "涉"},
	{"eylm", "沚"},
	{"eymh", "濊"},
	{"eymm", "澁"},
	{"eymp", "泚"},
	{"eymu", "𤀹"},
	{"eyoj", "淬"},
	{"eyok", "液"},
	{"eypd", "滹"},
	{"eypk", "澞"},
	{"eypo", "澽"},
	{"eypp", "濾"},
	{"eypt", "瀘"},
	{"eypu", "淲"},
	{"eyr", "沾"},
	{"eyrb", "滈"},
	{"eyrd", "淳"},
	{"eyrf", "涼"},
	{"eyrj", "滸"},
	{"eyrn", "涥 渟 瀛 灜 𤅀 𤅗"},
	{"eyro", "濠"},
	{"eyru", "湸 𣻼"},
	{"eyrv", "瀼"},
	{"eysd", "游 湤"},
	{"eyso", "漩"},
	{"eysy", "淤"},
	{"eyt", "泣"},
	{"eyta", "湆"},
	{"eytb", "湇"},
	{"eytg", "潼"},
	{"eytj", "漳 㳯"},
	{"eyto", "澻"},
	{"eytp", "澺"},
	{"eytr", "涪"},
	{"eytu", "滝"},
	{"eyub", "漓"},
	{"eyuh", "滮"},
	{"eyv", "汒"},
	{"eyvg", "澭"},
	{"eyvi", "泫"},
	{"eyvw", "滀"},
	{"eywd", "澟"},
	{"eywi", "滷"},
	{"eywm", "澶"},
	{"eywv", "滖 瀤"},
	{"eyx", "濟"},
	{"eyy", "汴"},
	{"f", "火"},
	{"faa", "焻"},
	{"fab", "焨"},
	{"fafu", "熀"},
	{"faht", "焺"},
	{"fahu", "溗"},
	{"fam", "炟"},
	{"famh", "煬"},
	{"famj", "焊"},
	{"famo", "煶"},
	{"fank", "燘"},
	{"fano", "熌"},
	{"fanp", "燜"},
	{"fanw", "爛"},
	{"fanx", "爓"},
	{"faph", "焬"},
	{"fapp", "焜"},
	{"fate", "爆"},
	{"fatj", "爗"},
	{"fau", "𤆵"},
	{"fawe", "熳"},
	{"fayf", "燝"},
	{"fayi", "𤋉"},
	{"fayt", "煜"},
	{"fb", "肖"},
	{"fbac", "熐"},
	{"fbb", "焩"},
	{"fbbe", "燰"},
	{"fbbr", "煱"},
	{"fbcr", "烱"},
	{"fbd", "栄 𤊕"},
	{"fbhaf", "鶺"},
	{"fbhn", "𤆤"},
	{"fbhx", "熖"},
	{"fbjj", "溤"},
	{"fbkf", "燃"},
	{"fbln", "削"},
	{"fbme", "煖"},
	{"fbmr", "烔"},
	{"fbnd", "学 烰"},
	{"fbok", "敝 敞"},
	{"fbou", "熎"},
	{"fbr", "尚 炯"},
	{"fbrbc", "賞"},
	{"fbrd", "棠"},
	{"fbrg", "堂"},
	{"fbrhu", "党"},
	{"fbrlb", "常"},
	{"fbrmh", "牚"},
	{"fbrmn", "瑐 瓽"},
	{"fbrpa", "嘗"},
	{"fbrq", "掌"},
	{"fbrtm", "甞"},
	{"fbrw", "當"},
	{"fbrwf", "黨"},
	{"fbryv", "裳"},
	{"fbtu", "焵"},
	{"fbuu", "䙺"},
	{"fbwi", "爝"},
	{"fbyh", "烿"},
	{"fcb", "脊"},
	{"fci", "炂"},
	{"fcnh", "焍"},
	{"fcor", "焀"},
	{"fcwa", "熷"},
	{"fd", "炑 米 𣏦"},
	{"fdamg", "糧"},
	{"fdamh", "糃"},
	{"fdau", "粑"},
	{"fdbcr", "𥺂"},
	{"fdbm", "粗"},
	{"fdbmr", "粡"},
	{"fdbt", "粣"},
	{"fdbuu", "粯"},
	{"fdcsh", "粉"},
	{"fddam", "𥻗"},
	{"fddh", "爩"},
	{"fddi", "籿"},
	{"fddj", "粖"},
	{"fdeii", "糔"},
	{"fdfh", "粆"},
	{"fdgp", "𥺃"},
	{"fdgrr", "糦"},
	{"fdha", "粕"},
	{"fdhe", "粄"},
	{"fdhhj", "粺"},
	{"fdhj", "粁"},
	{"fdhoa", "糌"},
	{"fdhqu", "粍"},
	{"fdhuk", "糗"},
	{"fdiav", "粮"},
	{"fdibi", "糐"},
	{"fdig", "粧"},
	{"fdigi", "𥺁"},
	{"fdiih", "糝"},
	{"fdile", "糠"},
	{"fdilr", "糖"},
	{"fdipp", "䊌"},
	{"fdixp", "麊"},
	{"fdiyr", "𥺦"},
	{"fdj", "籵"},
	{"fdjk", "粀"},
	{"fdjmf", "粽"},
	{"fdjrb", "糊"},
	{"fdk", "炔 类"},
	{"fdm", "䉺"},
	{"fdma", "粨"},
	{"fdmbb", "糯"},
	{"fdmcw", "粞"},
	{"fdmlk", "粳"},
	{"fdmlm", "𥺼"},
	{"fdmq", "溿"},
	{"fdmtb", "糲"},
	{"fdnd", "籽"},
	{"fdng", "粈"},
	{"fdnhd", "糅"},
	{"fdnii", "糨"},
	{"fdniq", "粦"},
	{"fdnj", "籸"},
	{"fdnl", "粌"},
	{"fdnmm", "糑"},
	{"fdnob", "糈"},
	{"fdogf", "𥼚"},
	{"fdok", "敉"},
	{"fdomo", "𥽋"},
	{"fdon", "籺"},
	{"fdonk", "糇"},
	{"fdphh", "粅"},
	{"fdpp", "粃"},
	{"fdqmb", "精"},
	{"fdshi", "籾"},
	{"fdsit", "糮"},
	{"fdsmv", "粻"},
	{"fdso", "粎"},
	{"fdss", "粔"},
	{"fdtak", "糢"},
	{"fdtaw", "糷"},
	{"fdtbn", "糋"},
	{"fdtgf", "糕"},
	{"fdthb", "糒"},
	{"fdtlk", "䊔"},
	{"fdtmc", "粸"},
	{"fdtmv", "糂"},
	{"fdtvg", "糚"},
	{"fdtvi", "糍"},
	{"fdtw", "粬"},
	{"fdtwa", "糟"},
	{"fdu", "籼"},
	{"fduce", "糉 糭"},
	{"fdv", "籹"},
	{"fdwd", "粿"},
	{"fdwe", "𥹉"},
	{"fdwf", "煉"},
	{"fdwg", "粴"},
	{"fdwji", "糰"},
	{"fdwla", "糬"},
	{"fdwtc", "糞"},
	{"fdy", "烞"},
	{"fdyhr", "糙"},
	{"fdyj", "料"},
	{"fdyoj", "粹"},
	{"fdyr", "粘"},
	{"fdyt", "粒"},
	{"ff", "炎 炏"},
	{"ffbb", "膋"},
	{"ffbbu", "覮"},
	{"ffbc", "鎣"},
	{"ffbd", "榮"},
	{"ffbdd", "檾"},
	{"ffbe", "滎"},
	{"ffbf", "熒 爣"},
	{"ffbg", "塋 𤎌"},
	{"ffbhf", "鶯"},
	{"ffbhm", "𤯵"},
	{"ffbhq", "犖"},
	{"ffbks", "勞"},
	{"ffbli", "螢"},
	{"ffbmf", "禜"},
	{"ffbmg", "瑩"},
	{"ffbmn", "甇"},
	{"ffbmw", "醟"},
	{"ffbnd", "𡦃"},
	{"ffbnj", "溮"},
	{"ffbou", "罃"},
	{"ffbrr", "營"},
	{"ffbuu", "覢"},
	{"ffbv", "嫈"},
	{"ffbvf", "縈"},
	{"ffbyr", "謍"},
	{"ffbyv", "褮"},
	{"ffdq", "燐"},
	{"ffe", "燮"},
	{"fff", "焱 爕"},
	{"fffd", "燊 爃 𤒇"},
	{"ffff", "燚"},
	{"fffg", "𤍢"},
	{"fffi", "𤑚"},
	{"fffs", "𤏪"},
	{"ffg", "烾"},
	{"ffh", "炒"},
	{"ffhe", "夑"},
	{"ffhni", "飊"},
	{"ffjv", "𡠺"},
	{"ffln", "剡"},
	{"ffmbc", "纇 顃"},
	{"ffmu", "𤈛"},
	{"ffnl", "郯"},
	{"ffno", "欻"},
	{"ffye", "敥"},
	{"ffypu", "虩"},
	{"ffyr", "溡"},
	{"fg", "灶"},
	{"fgcc", "爀"},
	{"fgce", "𤊥"},
	{"fgg", "烓"},
	{"fggu", "燒"},
	{"fgit", "熆"},
	{"fgni", "燽"},
	{"fgrr", "熺 𤐵"},
	{"fh", "少"},
	{"fha", "𤇢"},
	{"fhag", "煌"},
	{"fhbi", "烐"},
	{"fhbk", "燠"},
	{"fhbt", "烅"},
	{"fhbu", "省"},
	{"fhd", "秌"},
	{"fhdf", "煂"},
	{"fhdn", "熪"},
	{"fhdw", "燔"},
	{"fhej", "烽"},
	{"fher", "烙"},
	{"fhey", "炵"},
	{"fhfd", "烀"},
	{"fhge", "燬"},
	{"fhgf", "燻"},
	{"fhgr", "焅"},
	{"fhgu", "烍"},
	{"fhgy", "㸆"},
	{"fhhw", "熘"},
	{"fhje", "煅"},
	{"fhjg", "煡"},
	{"fhkb", "燆"},
	{"fhks", "劣"},
	{"fhlo", "焮"},
	{"fhml", "炘"},
	{"fhon", "烆"},
	{"fhp", "灹"},
	{"fhpa", "焝"},
	{"fhrj", "㷆"},
	{"fhs", "炸"},
	{"fhsb", "煇"},
	{"fhsf", "𤑛"},
	{"fhsm", "煽"},
	{"fhsu", "熩"},
	{"fhuc", "𤓎"},
	{"fhup", "熄"},
	{"fhwp", "熜"},
	{"fhxu", "𤊓"},
	{"fiav", "烺"},
	{"fice", "焌"},
	{"fihr", "煠"},
	{"fiib", "𤎜"},
	{"fijb", "烳"},
	{"fikk", "炦"},
	{"file", "𤎖"},
	{"filii", "蠽"},
	{"filr", "煻"},
	{"fipf", "爊"},
	{"fipm", "烒"},
	{"fis", "炉"},
	{"fitc", "燫 爌"},
	{"fixp", "熝"},
	{"fjbd", "㶿"},
	{"fjbj", "煵"},
	{"fjcm", "焢"},
	{"fjcr", "熔"},
	{"fjhp", "烢"},
	{"fjkf", "爎"},
	{"fjks", "烤"},
	{"fjmm", "煊"},
	{"fjmu", "烷"},
	{"fjnu", "焥"},
	{"fjrb", "煳"},
	{"fjv", "𤇼"},
	{"fjvd", "炼"},
	{"fjwj", "𤉖"},
	{"fk", "尖"},
	{"fkb", "烠"},
	{"fkbu", "瞥"},
	{"fkcf", "燎"},
	{"fkf", "尜"},
	{"fkgg", "煁"},
	{"fkhaf", "鷩"},
	{"fkhqu", "氅"},
	{"fkik", "獘"},
	{"fkkb", "烯 𤉶"},
	{"fklb", "幣"},
	{"fklmi", "蟞"},
	{"fkmbc", "類"},
	{"fkmnp", "斃"},
	{"fkn", "彆"},
	{"fknwf", "鱉"},
	{"fkp", "憋"},
	{"fkrau", "鄨"},
	{"fkrxu", "鼈"},
	{"fkryo", "蹩"},
	{"fksb", "熁"},
	{"fksc", "燲"},
	{"fkt", "弊"},
	{"fkv", "嫳"},
	{"flbk", "炴"},
	{"flii", "爞"},
	{"flln", "炥"},
	{"flmo", "烑"},
	{"flmt", "燼"},
	{"flwv", "熡"},
	{"flx", "熽"},
	{"fm", "灴"},
	{"fmam", "烜"},
	{"fmbb", "燸"},
	{"fmbc", "煩"},
	{"fmbm", "爧"},
	{"fmc", "兴"},
	{"fmdm", "爏"},
	{"fmf", "炋"},
	{"fmhf", "㷧"},
	{"fmj", "㶥"},
	{"fmmr", "焐"},
	{"fmn", "灯"},
	{"fmnr", "炣"},
	{"fmob", "炳"},
	{"fmr", "炻"},
	{"fmrw", "煏"},
	{"fmso", "烼"},
	{"fmu", "光"},
	{"fmua", "熸"},
	{"fmvm", "烴"},
	{"fmwf", "熛"},
	{"fmwg", "煙"},
	{"fmwj", "燂"},
	{"fmym", "炡"},
	{"fnbk", "煥"},
	{"fng", "炄"},
	{"fnhb", "燏"},
	{"fnhd", "溳"},
	{"fnhe", "𤆣"},
	{"fnhx", "焰"},
	{"fnin", "㶴"},
	{"fnkg", "烶"},
	{"fnkm", "烻"},
	{"fnkq", "煒"},
	{"fno", "炊"},
	{"fnot", "燈"},
	{"fnq", "揱"},
	{"fnqd", "𤌴"},
	{"fnvif", "𦂗"},
	{"fo", "尐"},
	{"fobg", "𤌍"},
	{"fod", "烌"},
	{"fog", "焳 雀"},
	{"fogf", "燋"},
	{"foii", "炩"},
	{"foip", "焾"},
	{"foir", "焓 熗"},
	{"foma", "燴"},
	{"fomb", "爚 㷍"},
	{"fomg", "烇"},
	{"fomr", "烚"},
	{"fond", "熂"},
	{"fopd", "炧"},
	{"fowy", "烸"},
	{"fpd", "灺"},
	{"fpi", "灼"},
	{"fpim", "𤆥"},
	{"fpkp", "㷓"},
	{"fpru", "炮"},
	{"fptd", "滐"},
	{"fpu", "炖"},
	{"fpuu", "煼"},
	{"fq", "半"},
	{"fqbu", "眷"},
	{"fqd", "桊"},
	{"fqdmq", "韏"},
	{"fqe", "𣳾"},
	{"fqhe", "叛"},
	{"fqhq", "牶"},
	{"fqiav", "飬"},
	{"fqks", "劵"},
	{"fqlb", "帣"},
	{"fqln", "判"},
	{"fqmbc", "頖"},
	{"fqmso", "豢"},
	{"fqmvn", "甐"},
	{"fqn", "弮"},
	{"fqnbg", "觠"},
	{"fqnl", "鄰"},
	{"fqnwf", "鮝"},
	{"fqq", "拳"},
	{"fqsh", "券"},
	{"fqsmm", "翷"},
	{"fqsqf", "駦"},
	{"fqsu", "卷"},
	{"fqu", "亃"},
	{"fqvif", "絭"},
	{"fqvv", "粼"},
	{"fqvvv", "𥻘"},
	{"fqymu", "齤"},
	{"frb", "焆"},
	{"frbc", "熉"},
	{"frc", "炽"},
	{"frhu", "炾"},
	{"frrd", "燥"},
	{"frrj", "燀"},
	{"frrr", "煢"},
	{"fruc", "㷷"},
	{"frye", "煆"},
	{"fsd", "㮡"},
	{"fseg", "熞"},
	{"fsh", "灱"},
	{"fshr", "炤"},
	{"fsit", "爁"},
	{"fsjr", "𤉸"},
	{"fskr", "𤉙"},
	{"fsma", "熠"},
	{"fsmb", "㷌"},
	{"fsmg", "燿"},
	{"fsmi", "燖"},
	{"fsmt", "熤"},
	{"fsrr", "熰"},
	{"fss", "炬"},
	{"fssr", "焗"},
	{"fstt", "𤋊"},
	{"fsuu", "煀"},
	{"fswu", "爦"},
	{"ft", "灷"},
	{"fta", "焟"},
	{"ftaw", "爤"},
	{"ftbf", "𤐄"},
	{"ftc", "烘 烡"},
	{"ftcw", "煔"},
	{"ftgi", "燨"},
	{"ftgr", "㷽"},
	{"ftgs", "爔"},
	{"ftja", "𤏸"},
	{"ftlf", "𤒈"},
	{"ftlj", "煣"},
	{"ftlk", "煸"},
	{"ftlo", "熯"},
	{"ftlx", "𤑳"},
	{"ftmc", "熿 𤊄"},
	{"ftmd", "煤"},
	{"ftmj", "燁"},
	{"ftmv", "滊"},
	{"ftob", "焫"},
	{"ftpi", "烵"},
	{"ftpo", "煫"},
	{"ftq", "烊"},
	{"ftqu", "𤏲"},
	{"ftrg", "爟"},
	{"ftwb", "燤"},
	{"ftwi", "燇"},
	{"ftwr", "𤌚"},
	{"ftwv", "燶"},
	{"ftxc", "熑"},
	{"fu", "灿"},
	{"fua", "𣆤 𣆥"},
	{"fuap", "熴"},
	{"fubjj", "輝"},
	{"fuhag", "𤾗"},
	{"fuhj", "㷨"},
	{"fuhuc", "𧹍"},
	{"fuks", "勌"},
	{"fumb", "煪"},
	{"fumt", "𤍈"},
	{"fuog", "熣"},
	{"fusma", "𦒉"},
	{"fusmg", "耀"},
	{"futmj", "㒯"},
	{"fvid", "爍"},
	{"fvis", "㶭"},
	{"fvvv", "爉"},
	{"fw", "畑"},
	{"fwb", "煲"},
	{"fwgg", "爅"},
	{"fwjc", "𤎽"},
	{"fwk", "烟"},
	{"fwkp", "煾"},
	{"fwl", "炠"},
	{"fwlg", "𤓓"},
	{"fwli", "燭"},
	{"fwlj", "燡"},
	{"fwln", "劏"},
	{"fwmbc", "顲"},
	{"fwmv", "煨"},
	{"fwot", "熅"},
	{"fwtc", "熼"},
	{"fwtj", "熚 𤒹"},
	{"fyaj", "焯"},
	{"fyav", "煺"},
	{"fybc", "𤋺"},
	{"fybp", "爖"},
	{"fycb", "熵"},
	{"fyck", "烄"},
	{"fydk", "燉"},
	{"fyed", "燦"},
	{"fyg", "炷"},
	{"fygq", "燵"},
	{"fyhj", "熢"},
	{"fyhn", "炕"},
	{"fyia", "熾"},
	{"fyib", "焴"},
	{"fyj", "炓"},
	{"fyk", "炆"},
	{"fynb", "熥"},
	{"fyoj", "焠"},
	{"fyok", "焲"},
	{"fypt", "爐"},
	{"fyrb", "熇"},
	{"fyrd", "焞"},
	{"fyro", "𤐶"},
	{"fyru", "煷"},
	{"fyrv", "爙"},
	{"fysg", "𤍣"},
	{"fytg", "燑"},
	{"fytj", "𤍤"},
	{"fyto", "燧"},
	{"fytp", "燱"},
	{"fytr", "焙"},
	{"fyvi", "炫"},
	{"fyvo", "烗"},
	{"g", "土"},
	{"gaai3", "悈"},
	{"gagi", "塒"},
	{"gah", "声"},
	{"gahu", "堳"},
	{"gam", "坦"},
	{"gamh", "場"},
	{"gami", "壜"},
	{"gamj", "垾"},
	{"gamo", "堤"},
	{"ganx", "壛"},
	{"gaph", "埸"},
	{"gapp", "堒"},
	{"gapv", "堨"},
	{"gasm", "塌"},
	{"gav", "垠"},
	{"gawe", "墁"},
	{"gb", "冉"},
	{"gbac", "塓"},
	{"gbb", "堋"},
	{"gbbr", "堝"},
	{"gbcd", "堔 𡑕"},
	{"gbd", "埰"},
	{"gbdi", "埒"},
	{"gbhn", "壳"},
	{"gbhne", "觳"},
	{"gbhu", "売"},
	{"gblm", "壺"},
	{"gbmc", "埧"},
	{"gbmd", "槖"},
	{"gbmm", "壼"},
	{"gbmo", "塚 塜"},
	{"gbmr", "垌"},
	{"gbmri", "蠧"},
	{"gbmt", "壹"},
	{"gbnd", "垺"},
	{"gbr", "坰"},
	{"gbsd", "埩"},
	{"gbtu", "堈"},
	{"gbuc", "垻"},
	{"gby", "坍"},
	{"gcbuu", "覿"},
	{"gcdhe", "皾"},
	{"gcg", "坴"},
	{"gcglc", "赫"},
	{"gche", "夌"},
	{"gcilr", "赯"},
	{"gcim", "塕"},
	{"gcjka", "赭"},
	{"gclmi", "赨"},
	{"gcmbc", "頳"},
	{"gcnau", "赩"},
	{"gcnl", "郝"},
	{"gcok", "赦"},
	{"gcrxu", "鼀"},
	{"gcrye", "赮"},
	{"gcsh", "坋"},
	{"gcsle", "赧"},
	{"gcwa", "增"},
	{"gcybc", "赬"},
	{"gdhe", "坡"},
	{"gdhne", "榖 穀 糓"},
	{"gdi", "寺"},
	{"gdk", "块"},
	{"gdw", "埬"},
	{"gdwf", "堜"},
	{"gebu", "瞽"},
	{"gec", "鏧"},
	{"gee", "漀"},
	{"geeii", "鼜"},
	{"gef", "㷫"},
	{"gefbg", "鼞"},
	{"gehda", "馨"},
	{"gehey", "鼕"},
	{"gehhj", "鼙"},
	{"gehkb", "毊"},
	{"gehor", "鼛"},
	{"geid", "墚"},
	{"gelmi", "螜"},
	{"gelxl", "鼘"},
	{"gemr", "磬"},
	{"geoju", "罄"},
	{"gep", "愨 慤 𢡱"},
	{"gesj", "聲"},
	{"gesmv", "鼚"},
	{"geymr", "謦"},
	{"geyta", "韾"},
	{"gfbuu", "𧡘"},
	{"gfbw", "壋"},
	{"gfcb", "塉"},
	{"gff", "埮"},
	{"gfhne", "縠 鷇"},
	{"gfmu", "垙"},
	{"gfno", "款"},
	{"gfq", "坢"},
	{"gfqu", "埢"},
	{"gg", "圭"},
	{"ggce", "堎"},
	{"ggcw", "墙"},
	{"ggdi", "封"},
	{"ggff", "燅"},
	{"ggg", "垚 𡋣"},
	{"gggog", "𡓨"},
	{"gggu", "堯 墝"},
	{"gghaf", "鵱"},
	{"gghne", "瑴"},
	{"ggkni", "埶"},
	{"ggln", "刲"},
	{"ggni", "壔"},
	{"ggnl", "邽"},
	{"ggow", "墻"},
	{"ggp", "恚"},
	{"ggy", "卦"},
	{"ghad", "𡏭"},
	{"ghag", "堭"},
	{"ghbk", "墺"},
	{"ghbr", "垧"},
	{"ghbu", "垍"},
	{"ghdw", "墦"},
	{"ghe", "坂"},
	{"ghej", "埄"},
	{"ghfd", "垀"},
	{"ghgf", "壎"},
	{"ghgr", "𡌃"},
	{"ghhj", "埤"},
	{"ghhw", "塯"},
	{"ghi", "塊"},
	{"ghj", "圲"},
	{"ghjg", "堹"},
	{"ghjm", "埵"},
	{"ghkb", "墧"},
	{"ghlmi", "蟚"},
	{"ghml", "圻"},
	{"ghmr", "垢"},
	{"ghmvn", "甏"},
	{"ghmy", "坼"},
	{"ghnd", "垛"},
	{"ghni", "堸"},
	{"ghpm", "坻"},
	{"ghrf", "塢"},
	{"ghrj", "埠"},
	{"ghsk", "墽"},
	{"ghvp", "坁"},
	{"ghxu", "堄"},
	{"gi", "去"},
	{"giapv", "朅"},
	{"giav", "埌"},
	{"gibt", "盍"},
	{"gibuc", "贄"},
	{"gice", "埈"},
	{"gid", "槷"},
	{"gif", "熱"},
	{"gig", "墊"},
	{"gihab", "幫"},
	{"gihaf", "鷙"},
	{"gihq", "煓"},
	{"gihr", "堿"},
	{"gihs", "城"},
	{"gihv", "㙎"},
	{"giib", "㙟"},
	{"giih", "墋"},
	{"gijb", "埔"},
	{"gikk", "坺"},
	{"giks", "劫 勢"},
	{"gilb", "墉"},
	{"gile", "𡐓"},
	{"gili", "𡌺"},
	{"gilmi", "蟄"},
	{"giln", "刦"},
	{"gilr", "塘"},
	{"ginl", "邿 𨚫"},
	{"ginn", "垿"},
	{"giok", "埃"},
	{"gip", "慹"},
	{"giq", "摯 摰"},
	{"girm", "域"},
	{"girxu", "鼁"},
	{"gish", "刧"},
	{"gishi", "刼"},
	{"gisl", "却"},
	{"gismm", "翿"},
	{"gisqf", "騺"},
	{"gitc", "壙"},
	{"gitlj", "鞤"},
	{"givif", "縶"},
	{"gixp", "塶"},
	{"giymr", "謺"},
	{"gjbc", "填"},
	{"gjbj", "𡎜"},
	{"gjbm", "埴"},
	{"gjcr", "塎"},
	{"gjhne", "轂"},
	{"gjhp", "垞"},
	{"gjhvo", "瑗"},
	{"gjii", "塼"},
	{"gjjn", "墘"},
	{"gjka", "堵"},
	{"gjkni", "執"},
	{"gjkr", "𡏾"},
	{"gjmd", "㘾"},
	{"gjmm", "塇"},
	{"gjmn", "坾"},
	{"gjmo", "埞"},
	{"gjmu", "垸"},
	{"gjnu", "埦"},
	{"gjp", "坨"},
	{"gjsle", "報"},
	{"gjtc", "墳"},
	{"gjv", "垵"},
	{"gjwj", "𡌄"},
	{"gka", "𣊁"},
	{"gkbt", "盩"},
	{"gkbuc", "贅"},
	{"gkc", "鏊"},
	{"gkf", "熬"},
	{"gkhaf", "鷔"},
	{"gkik", "獒"},
	{"gkkk", "塽"},
	{"gklb", "㘵"},
	{"gklmi", "螫 螯"},
	{"gklu", "埯"},
	{"gkmb", "堶"},
	{"gkmr", "埼"},
	{"gkms", "垮"},
	{"gknwf", "鰲"},
	{"gkpb", "墆"},
	{"gkq", "摮"},
	{"gkrxu", "鼇"},
	{"gksj", "聱"},
	{"gksqf", "驁"},
	{"gku", "嶅"},
	{"gkymr", "謷"},
	{"glbk", "坱"},
	{"gle", "埭"},
	{"glll", "圳"},
	{"glln", "坲"},
	{"glmo", "垗"},
	{"glnc", "赤"},
	{"glq", "垏"},
	{"glwl", "坤"},
	{"glwv", "塿"},
	{"gmam", "垣"},
	{"gmbb", "壖 壩"},
	{"gmbi", "墵"},
	{"gmbk", "堧"},
	{"gmc", "鋆"},
	{"gmd", "圩"},
	{"gmdm", "壢"},
	{"gmf", "坏"},
	{"gmfj", "坪"},
	{"gmfm", "坯"},
	{"gmgg", "堐"},
	{"gmgi", "𡊩"},
	{"gmhf", "塬"},
	{"gmig", "垤"},
	{"gmjk", "𡑒"},
	{"gmlk", "埂"},
	{"gmlm", "埡"},
	{"gmmi", "坛"},
	{"gmms", "圬"},
	{"gmmu", "坃"},
	{"gmn", "圢"},
	{"gmnr", "坷"},
	{"gmr", "坧"},
	{"gmrb", "塥"},
	{"gmrw", "堛"},
	{"gmso", "㙇"},
	{"gmwd", "塛"},
	{"gmwf", "墂"},
	{"gmwg", "堙"},
	{"gmwj", "墰"},
	{"gnbg", "埆"},
	{"gnhe", "圾"},
	{"gnhne", "彀 殼"},
	{"gnhx", "埳"},
	{"gnib", "埇"},
	{"gnkm", "埏"},
	{"gnmf", "燾"},
	{"gnmi", "壽"},
	{"gnmu", "垝"},
	{"gno", "坎"},
	{"gnob", "壻"},
	{"gnot", "墱"},
	{"gnsd", "垜"},
	{"gnui", "堍"},
	{"goah", "塲"},
	{"goamh", "䞶"},
	{"goamj", "趕"},
	{"goamo", "趧"},
	{"gobm", "趄"},
	{"goc", "趛"},
	{"godi", "坿"},
	{"godk", "赽"},
	{"gofb", "趙"},
	{"gofbr", "趟"},
	{"gofh", "赻"},
	{"gog", "堆"},
	{"goggu", "趬"},
	{"gogr", "趌"},
	{"goher", "䞦"},
	{"gohjd", "趎"},
	{"gohjr", "趏"},
	{"gohkb", "趫"},
	{"gohnd", "趓"},
	{"gohne", "豰"},
	{"gohuc", "趲"},
	{"goii", "坽"},
	{"goik", "垘"},
	{"goimo", "趑"},
	{"goin", "坅"},
	{"goior", "趦"},
	{"goip", "埝"},
	{"goiv", "越"},
	{"gok", "坆"},
	{"goks", "赲"},
	{"goll", "圿"},
	{"golmo", "趒"},
	{"golxh", "趀"},
	{"gom", "坵"},
	{"gomj", "赶"},
	{"gomn", "堬"},
	{"gomnn", "趔"},
	{"gomr", "垥"},
	{"gon", "圪"},
	{"gonf", "趂"},
	{"gonin", "趍"},
	{"gonk", "堠"},
	{"goog", "趡"},
	{"googf", "趭"},
	{"goohh", "趁"},
	{"gooin", "赺"},
	{"goon", "䞘"},
	{"gooog", "趖"},
	{"gopfd", "趜"},
	{"gopim", "赹"},
	{"gopuu", "趨"},
	{"gord", "堢"},
	{"gorrd", "趮"},
	{"gort", "塩"},
	{"goru", "起"},
	{"goshr", "超"},
	{"gosje", "趣"},
	{"gosmg", "趯"},
	{"gosmm", "趐"},
	{"gotcw", "趥"},
	{"gotmc", "趪"},
	{"gou", "赸"},
	{"gouu", "趉"},
	{"govl", "赳"},
	{"gowr", "嗇"},
	{"gowtc", "趩"},
	{"goy", "赴"},
	{"goyaj", "趠"},
	{"gp", "志"},
	{"gpbuu", "覟"},
	{"gpd", "地"},
	{"gphh", "圽"},
	{"gpi", "圴"},
	{"gpim", "均"},
	{"gpmm", "堩"},
	{"gppa", "堦"},
	{"gptd", "堞"},
	{"gpu", "坉"},
	{"gqhf", "𡐤"},
	{"gqjl", "垹"},
	{"gqkq", "埲"},
	{"gqmb", "埥"},
	{"gr", "吉"},
	{"grbc", "塤"},
	{"grbg", "臺"},
	{"grgr", "喆"},
	{"grgrr", "嚞 囍"},
	{"grhaf", "鴶 𪇟"},
	{"grhg", "埕"},
	{"grhne", "嗀 嗀"},
	{"grhv", "袁"},
	{"grks", "劼"},
	{"grln", "㓤"},
	{"grmbc", "頡"},
	{"grmfr", "嚭"},
	{"grno", "欯 歖"},
	{"grp", "憙"},
	{"grrj", "墠"},
	{"grrk", "壧"},
	{"grrs", "堮"},
	{"grrv", "喪"},
	{"grsj", "𡎎"},
	{"grt", "壴"},
	{"grtf", "熹"},
	{"grtr", "喜 嘉"},
	{"gru", "圯"},
	{"grvp", "垊"},
	{"grye", "敼"},
	{"gsav", "堰"},
	{"gseg", "𡐖"},
	{"gsit", "壏"},
	{"gsjt", "壣"},
	{"gslc", "㙺"},
	{"gsmb", "埽"},
	{"gsme", "埐"},
	{"gsok", "敖"},
	{"gsp", "坭"},
	{"gstt", "塀"},
	{"gsu", "圮 𡉏"},
	{"gsuu", "堀"},
	{"gsyq", "墀"},
	{"gtak", "塻"},
	{"gtbc", "㙉"},
	{"gtco", "墣"},
	{"gtcp", "塨"},
	{"gtdhe", "皷"},
	{"gtdi", "尌"},
	{"gtgr", "墡"},
	{"gtgt", "壒"},
	{"gthf", "𡓽"},
	{"gthhh", "彭"},
	{"gtiop", "懿"},
	{"gtior", "𡄻"},
	{"gtiov", "𡤜"},
	{"gtj", "幸"},
	{"gtje", "鼓"},
	{"gtlk", "𡎘"},
	{"gtlm", "墐"},
	{"gtm", "坩"},
	{"gtmv", "堪"},
	{"gtnop", "㦤"},
	{"gtol", "𡏆"},
	{"gtor", "塔"},
	{"gtov", "𡒶"},
	{"gtq", "垟"},
	{"gtss", "壾"},
	{"gtt", "垪"},
	{"gttc", "𡌶"},
	{"gtu", "亄"},
	{"gtvs", "墈"},
	{"gtwi", "墫 壿"},
	{"gtwim", "𧰒"},
	{"gu", "圠"},
	{"gubb", "塴"},
	{"gudi", "𡭄"},
	{"guggu", "㚁"},
	{"guhne", "瞉"},
	{"gumbc", "顤"},
	{"gumt", "塏"},
	{"guog", "墔"},
	{"guon", "埁"},
	{"gusmm", "翹"},
	{"guye", "𢿣"},
	{"gvis", "坳 㘭"},
	{"gw", "𡊰"},
	{"gwd", "堁"},
	{"gwg", "埋"},
	{"gwj", "毐"},
	{"gwjr", "堌"},
	{"gwlb", "堣"},
	{"gwlc", "賣"},
	{"gwlj", "墿"},
	{"gwlm", "堽"},
	{"gwls", "塄"},
	{"gwol", "堺"},
	{"gwot", "塭"},
	{"gwyi", "坶"},
	{"gybp", "壠"},
	{"gybs", "塝"},
	{"gycb", "墑 墒"},
	{"gydk", "墩"},
	{"gydl", "墎"},
	{"gyfe", "埱"},
	{"gygj", "𡐿"},
	{"gygq", "墶"},
	{"gyhj", "塳"},
	{"gyhn", "坑"},
	{"gyhs", "坊"},
	{"gyib", "堉"},
	{"gyk", "坟"},
	{"gylc", "壝"},
	{"gylh", "埗"},
	{"gylm", "址"},
	{"gyo", "走"},
	{"gyoj", "埣"},
	{"gypm", "墟"},
	{"gypo", "壉"},
	{"gypt", "壚"},
	{"gypu", "㙈"},
	{"gyr", "坫"},
	{"gyrb", "塙"},
	{"gyrd", "埻"},
	{"gyro", "壕"},
	{"gyrv", "壤"},
	{"gyt", "垃"},
	{"gyta", "堷"},
	{"gytg", "墥"},
	{"gytj", "垶 墇"},
	{"gytr", "培"},
	{"gytu", "境"},
	{"gyuk", "垴"},
	{"gyvi", "𡊨"},
	{"gyvo", "垓"},
	{"gywd", "壈"},
	{"gywm", "壇"},
	{"gywv", "壞"},
	{"h", "竹"},
	{"ha", "白"},
	{"haapv", "馤"},
	{"habwi", "皭"},
	{"hae", "泉"},
	{"hahaa", "皛 馫"},
	{"hahaj", "皞 皡"},
	{"hahdw", "皤"},
	{"hahe", "皈"},
	{"hahgr", "皓"},
	{"hahi", "魄"},
	{"hahqi", "皒"},
	{"hahsk", "皦"},
	{"hahud", "𤾚"},
	{"hahuj", "皥"},
	{"hahuk", "𩡗"},
	{"hahxu", "𤾆"},
	{"haikk", "馛"},
	{"hail", "節"},
	{"haioj", "皐"},
	{"haipf", "皫"},
	{"haj", "皁"},
	{"hajbd", "馞"},
	{"hajd", "𤽜"},
	{"hajmc", "馪"},
	{"hajmu", "皖"},
	{"hajnu", "𤾂"},
	{"hakj", "皋"},
	{"haklu", "馣"},
	{"hakmr", "䭲"},
	{"halb", "帛"},
	{"halmy", "馡"},
	{"ham", "笪"},
	{"hambi", "𤿂"},
	{"hamg", "皇"},
	{"hamj", "筸"},
	{"hana", "簡"},
	{"hank", "簢"},
	{"hanw", "籣"},
	{"haoae", "馥"},
	{"haobg", "㿥"},
	{"haoii", "皊"},
	{"hap", "皂"},
	{"haph", "馝"},
	{"hapi", "的"},
	{"haqkq", "䭰"},
	{"hasp", "馜"},
	{"hatif", "𤾸"},
	{"hatt", "皏"},
	{"hatxc", "馦"},
	{"hau", "癿 笆"},
	{"haumt", "皚"},
	{"hauu", "䭯"},
	{"havid", "皪"},
	{"havt", "簋"},
	{"haw", "畠"},
	{"hawe", "𥲑"},
	{"hawot", "馧"},
	{"hayck", "皎"},
	{"hayd", "梟"},
	{"hayf", "鳥"},
	{"haymp", "皉"},
	{"hayrb", "皜"},
	{"hayu", "島"},
	{"hayv", "裊"},
	{"hbbm", "舋"},
	{"hbbr", "䈑"},
	{"hbbt", "䀉"},
	{"hbbuu", "覺"},
	{"hbdci", "𦦵"},
	{"hbddf", "爨"},
	{"hbe", "澩"},
	{"hbf", "燢 爂"},
	{"hbfe", "籐"},
	{"hbff", "𥸎"},
	{"hbg", "壆"},
	{"hbhaf", "鵳 鶣 鷮 鷽"},
	{"hbhgr", "嚳"},
	{"hbhvf", "緜"},
	{"hbk", "奥 奧"},
	{"hbks", "筋"},
	{"hblmp", "𠤣"},
	{"hbln", "制"},
	{"hbmbc", "顅"},
	{"hbmch", "釁"},
	{"hbmgi", "璺"},
	{"hbmr", "礐 筒"},
	{"hbms", "筯"},
	{"hbmvn", "甂"},
	{"hbnbg", "觷"},
	{"hbnd", "學"},
	{"hbnl", "鄅"},
	{"hbnwf", "鱟"},
	{"hbok", "敿"},
	{"hbq", "甪"},
	{"hbr", "向 𠿟"},
	{"hbsd", "箏"},
	{"hbse", "箙"},
	{"hbsmm", "翩 䎗"},
	{"hbt", "笧 血"},
	{"hbtmc", "黌"},
	{"hbu", "嶨 自"},
	{"hbue", "籰 𥴠"},
	{"hbuf", "纂"},
	{"hbuh", "篎"},
	{"hbui", "篡 簒"},
	{"hbut", "算"},
	{"hbuu", "筧 篹"},
	{"hbuv", "籑"},
	{"hbyi", "舟"},
	{"hcg", "𡒊"},
	{"hchaf", "鸒"},
	{"hchg", "籦"},
	{"hcii", "籛"},
	{"hcjwj", "轝"},
	{"hcln", "劉 劗"},
	{"hcmr", "礜"},
	{"hcnl", "鄮 酇"},
	{"hcno", "歟"},
	{"hcp", "㦛"},
	{"hcpm", "𥳾"},
	{"hcq", "擧 舉"},
	{"hcv", "嬃"},
	{"hcve", "籙"},
	{"hcymr", "譽"},
	{"hd", "禾"},
	{"hda", "香"},
	{"hdaiu", "穊"},
	{"hdamj", "稈"},
	{"hdb", "策"},
	{"hdbgb", "稱"},
	{"hdbgr", "稠"},
	{"hdbhx", "稻"},
	{"hdbk", "𥰡"},
	{"hdbm", "租"},
	{"hdbmp", "穩"},
	{"hdbmr", "秱"},
	{"hdbn", "箣"},
	{"hdbnd", "稃"},
	{"hdbof", "穄"},
	{"hdbt", "盉"},
	{"hdbu", "箱"},
	{"hdbwi", "穱"},
	{"hdci", "𥯆"},
	{"hdcnh", "稊"},
	{"hdcru", "稅"},
	{"hdcsh", "秎"},
	{"hdd", "箖"},
	{"hddj", "秣"},
	{"hddmq", "稦"},
	{"hdf", "秋"},
	{"hdfb", "稍"},
	{"hdfh", "秒"},
	{"hdgce", "稜"},
	{"hdgcg", "稑"},
	{"hdggu", "穘"},
	{"hdgow", "穡"},
	{"hdgr", "秸"},
	{"hdhaf", "鴸 鷍"},
	{"hdhah", "穆"},
	{"hdhd", "秝"},
	{"hdhhj", "稗"},
	{"hdhjg", "種"},
	{"hdhkb", "穚"},
	{"hdhne", "毇"},
	{"hdhp", "秅"},
	{"hdhpm", "秪"},
	{"hdhqo", "秩"},
	{"hdhqu", "秏"},
	{"hdhsb", "稨"},
	{"hdhu", "禿"},
	{"hdhvp", "秖"},
	{"hdhxc", "穥"},
	{"hdi", "私"},
	{"hdiav", "稂"},
	{"hdice", "稄"},
	{"hdihu", "𥝲"},
	{"hdiih", "穇"},
	{"hdijc", "秫"},
	{"hdije", "𥟇"},
	{"hdilb", "𥡲"},
	{"hdile", "穅"},
	{"hdipf", "穮"},
	{"hdir", "秮"},
	{"hdirm", "稢"},
	{"hditc", "穬"},
	{"hdiua", "稽"},
	{"hdiuu", "嵇"},
	{"hdjbc", "稹"},
	{"hdjbm", "稙"},
	{"hdjcr", "穃"},
	{"hdjhp", "秺"},
	{"hdjip", "穗"},
	{"hdjmf", "𥟡"},
	{"hdjmo", "稼"},
	{"hdkkb", "稀"},
	{"hdl", "秉 种"},
	{"hdlbk", "秧"},
	{"hdlc", "籟"},
	{"hdln", "利 剁"},
	{"hdlo", "簌"},
	{"hdlp", "乘"},
	{"hdlw", "秞 釉"},
	{"hdlxh", "秭"},
	{"hdm", "笨"},
	{"hdmfj", "秤"},
	{"hdmfm", "秠"},
	{"hdmig", "秷"},
	{"hdmj", "秆"},
	{"hdmq", "𥯤"},
	{"hdmrw", "稫"},
	{"hdmvn", "甈"},
	{"hdnd", "季 秄"},
	{"hdnhs", "秀"},
	{"hdnin", "移"},
	{"hdnl", "邾 鄡"},
	{"hdnmu", "臲"},
	{"hdnob", "稰"},
	{"hdnwa", "穭"},
	{"hdoae", "稪"},
	{"hdob", "䄲"},
	{"hdoe", "黍"},
	{"hdog", "稚"},
	{"hdogf", "穛"},
	{"hdoii", "秢"},
	{"hdoip", "稔"},
	{"hdoir", "䅮"},
	{"hdok", "斆"},
	{"hdomb", "稐"},
	{"hdomd", "稌"},
	{"hdomr", "秴"},
	{"hdoo", "箂"},
	{"hdp", "悉"},
	{"hdph", "秘"},
	{"hdpp", "秕"},
	{"hdppa", "稭 𥟠"},
	{"hdqmc", "積"},
	{"hdr", "和"},
	{"hdrhg", "程"},
	{"hdrhr", "稆"},
	{"hdsb", "篐"},
	{"hdsmh", "穋"},
	{"hdsp", "秜"},
	{"hdsqf", "𥡗"},
	{"hdss", "秬"},
	{"hdsyj", "稺"},
	{"hdsyq", "穉 𥣡"},
	{"hdta", "稓"},
	{"hdtcd", "𥣈"},
	{"hdtct", "䅬"},
	{"hdtmc", "稘 穔"},
	{"hdtmj", "䅿"},
	{"hdtoe", "穫"},
	{"hdtwv", "穠"},
	{"hdu", "秈"},
	{"hduce", "稯"},
	{"hdv", "委"},
	{"hdvii", "穖"},
	{"hdw", "番"},
	{"hdwce", "稷"},
	{"hdwd", "稞"},
	{"hdwhd", "稛"},
	{"hdwjr", "稒"},
	{"hdwlj", "釋"},
	{"hdye", "斅"},
	{"hdyhn", "秔"},
	{"hdyj", "科"},
	{"hdymh", "穢"},
	{"hdyrb", "稿"},
	{"hdyrd", "稕"},
	{"hdyrv", "穰"},
	{"hdyta", "䅧"},
	{"hdytg", "穜"},
	{"hdyto", "穟"},
	{"hdyx", "穧"},
	{"he", "反 夂"},
	{"heag", "篞"},
	{"heah", "簜"},
	{"hebt", "盤"},
	{"hec", "鎜"},
	{"hed", "条 槃"},
	{"heg", "垼"},
	{"heha", "箔"},
	{"hehee", "灥"},
	{"hehu", "箲"},
	{"hehw", "籓"},
	{"heii", "簿"},
	{"heir", "箈"},
	{"heks", "务"},
	{"helb", "幋"},
	{"helmi", "螌"},
	{"hemr", "磐"},
	{"henl", "鄋"},
	{"hep", "慇"},
	{"hepd", "筂"},
	{"heq", "夅 搫"},
	{"heqj", "夆"},
	{"her", "各"},
	{"hesu", "笵"},
	{"hetc", "篊"},
	{"hetlj", "鞶"},
	{"hev", "媻"},
	{"hevif", "縏"},
	{"hew", "备"},
	{"hey", "冬 处"},
	{"heyhv", "褩"},
	{"heyli", "螽"},
	{"heyr", "黏"},
	{"heyub", "黐"},
	{"hfaht", "鵿"},
	{"hfate", "鸔"},
	{"hfb", "筲"},
	{"hfbn", "箾"},
	{"hfbw", "簹"},
	{"hfc", "鍫"},
	{"hfd", "乎 釆 䲷"},
	{"hfdk", "鴃"},
	{"hfesd", "𪆫"},
	{"hffs", "簩"},
	{"hfgdi", "𪀔"},
	{"hfhaf", "鶖"},
	{"hfhn", "鳧"},
	{"hfhrb", "鶳"},
	{"hfhu", "箵"},
	{"hfhxu", "鶃"},
	{"hfhyu", "鷈"},
	{"hfice", "鵔"},
	{"hfjc", "鴥"},
	{"hfjp", "鴕"},
	{"hfks", "勳"},
	{"hflmi", "蝵"},
	{"hfmmp", "𪈳"},
	{"hfmvn", "甃"},
	{"hfn", "鳦"},
	{"hfnl", "鄔"},
	{"hfno", "歍"},
	{"hfog", "鵻"},
	{"hfomd", "鵌"},
	{"hfp", "愁"},
	{"hfq", "揫"},
	{"hfsqf", "鷌"},
	{"hftgi", "鸃"},
	{"hftmc", "鶀"},
	{"hftoe", "鸌"},
	{"hfv", "媝"},
	{"hfydk", "鷻"},
	{"hg", "壬 𡈼"},
	{"hgcr", "簭"},
	{"hgdi", "等"},
	{"hgea", "濌"},
	{"hgf", "熏"},
	{"hgfmu", "皝"},
	{"hgg", "筀"},
	{"hghne", "毀"},
	{"hghu", "先"},
	{"hgi", "丟"},
	{"hgit", "篕"},
	{"hgks", "動"},
	{"hgmbc", "顧"},
	{"hgmvn", "𤭮"},
	{"hgni", "籌"},
	{"hgnl", "𨛘"},
	{"hgpm", "筠"},
	{"hgr", "告"},
	{"hgrg", "籉"},
	{"hgrly", "靠"},
	{"hhag", "篁"},
	{"hhail", "卿"},
	{"hhbuc", "貿"},
	{"hhd", "棃"},
	{"hhdi", "射"},
	{"hhdm", "躰"},
	{"hhdn", "筣 簃"},
	{"hhfbr", "躺"},
	{"hhffs", "軂"},
	{"hhfh", "𨈘"},
	{"hhgr", "筶"},
	{"hhgu", "筅"},
	{"hhh", "彡"},
	{"hhhaf", "鵹"},
	{"hhhj", "箄"},
	{"hhhnd", "躲"},
	{"hhho", "辵"},
	{"hhhq", "犂"},
	{"hhj", "卑"},
	{"hhjm", "箠"},
	{"hhjmc", "軉"},
	{"hhjr", "筈"},
	{"hhk", "笑"},
	{"hhkb", "簥"},
	{"hhlbu", "躭"},
	{"hhlmo", "䠷"},
	{"hhlo", "笊"},
	{"hhmbc", "須"},
	{"hhmdm", "𨊛"},
	{"hhmmp", "𨉼"},
	{"hhn", "躬"},
	{"hhnwf", "鯬"},
	{"hhoe", "黎"},
	{"hhok", "䉠"},
	{"hhol", "篽"},
	{"hhon", "筕"},
	{"hhoo", "簁"},
	{"hhp", "惣"},
	{"hhpfd", "躹"},
	{"hhpp", "𨈚"},
	{"hhqm", "笙"},
	{"hhqu", "笔"},
	{"hhrb", "篩"},
	{"hhrrj", "軃"},
	{"hhs", "笮"},
	{"hhsav", "躽"},
	{"hhsb", "篇"},
	{"hhsl", "卯"},
	{"hhslc", "贕"},
	{"hhsld", "孵"},
	{"hhsle", "毈"},
	{"hhsli", "卵"},
	{"hhsmv", "躼"},
	{"hhsrr", "軀"},
	{"hhuc", "籫"},
	{"hhvo", "笟"},
	{"hhvu", "篼"},
	{"hhw", "留"},
	{"hhwd", "躶"},
	{"hhwgf", "黧"},
	{"hhwp", "篦"},
	{"hhxc", "籅"},
	{"hhyu", "篪"},
	{"hi", "么 鬼"},
	{"hiav", "筤"},
	{"hibt", "簠"},
	{"hibtv", "魍"},
	{"hifb", "魈"},
	{"hihaf", "鵝 鵞"},
	{"hihml", "鬿"},
	{"hihq", "犩"},
	{"hihr", "箴"},
	{"hihs", "筬"},
	{"hii", "箋"},
	{"hiih", "篸"},
	{"hiikk", "魃"},
	{"hiipj", "𩲭"},
	{"hiirm", "魊"},
	{"hiit", "𥵃"},
	{"hiiv", "魆"},
	{"hijb", "𥮉"},
	{"hijd", "魅"},
	{"hije", "鬾"},
	{"himlb", "魎"},
	{"himwf", "魒"},
	{"hino", "乏"},
	{"hiog", "魋"},
	{"hioll", "魀"},
	{"hipm", "𥳁"},
	{"hir", "笞"},
	{"hit", "笲"},
	{"hitb", "𥱊"},
	{"hitc", "簾"},
	{"hitf", "䉀"},
	{"hitmc", "魌"},
	{"hitwi", "𩴾"},
	{"hitxc", "魐"},
	{"hivii", "魕"},
	{"hixp", "簏"},
	{"hiyj", "魁"},
	{"hiypm", "魖"},
	{"hiyub", "魑"},
	{"hj", "千"},
	{"hjbc", "貭"},
	{"hjbu", "盾"},
	{"hjcm", "箜"},
	{"hjd", "朱 栞"},
	{"hjhaf", "鵯"},
	{"hjhne", "段"},
	{"hjhx", "臿"},
	{"hjii", "篿 簙"},
	{"hjim", "籖"},
	{"hjjj", "簳"},
	{"hjjo", "簐"},
	{"hjjr", "簵"},
	{"hjju", "範"},
	{"hjka", "箸"},
	{"hjln", "𠜱"},
	{"hjlo", "箑"},
	{"hjlp", "乖"},
	{"hjmbc", "顊"},
	{"hjmk", "簆"},
	{"hjmu", "筦"},
	{"hjnl", "郫"},
	{"hjnu", "箢"},
	{"hjr", "舌"},
	{"hjrr", "管"},
	{"hjsmm", "翱 翺"},
	{"hjtm", "垂"},
	{"hjwg", "重"},
	{"hk", "夭"},
	{"hka", "昋"},
	{"hkapv", "𦤦"},
	{"hkcf", "簝"},
	{"hkd", "棨"},
	{"hke", "叐"},
	{"hkhaf", "鴌 鸄"},
	{"hkk", "笅"},
	{"hklmi", "蚕"},
	{"hkln", "刋"},
	{"hklq", "肇"},
	{"hkoo", "筴"},
	{"hkp", "忝 懲"},
	{"hkr", "吞"},
	{"hkrbr", "喬"},
	{"hks", "竻"},
	{"hksr", "笳"},
	{"hku", "岙 嶴"},
	{"hkvif", "綮"},
	{"hkymr", "譥"},
	{"hlapv", "齃"},
	{"hlbi", "禹"},
	{"hlbuc", "質"},
	{"hldam", "齄"},
	{"hlgbo", "䶑"},
	{"hlha", "皙"},
	{"hlhdl", "𥡝"},
	{"hlhuk", "齅"},
	{"hljbv", "齉"},
	{"hlkn", "鼽"},
	{"hlks", "劤"},
	{"hlle", "齂"},
	{"hllj", "簰"},
	{"hlln", "劓 笰"},
	{"hlmbc", "頎"},
	{"hlmc", "簣"},
	{"hlmj", "鼾"},
	{"hlmmf", "禦"},
	{"hlmo", "筄"},
	{"hlmvn", "齀"},
	{"hlno", "欣"},
	{"hlo", "爪"},
	{"hlpr", "齁"},
	{"hlq", "筆"},
	{"hltwv", "齈"},
	{"hlvk", "籔"},
	{"hlvvu", "齆"},
	{"hlw", "笛"},
	{"hlwli", "斶"},
	{"hlwv", "簍"},
	{"hlx", "簫"},
	{"hlxh", "笫"},
	{"hlypm", "齇"},
	{"hm", "笁"},
	{"hmau", "巵"},
	{"hmbc", "篢"},
	{"hmbg", "籗"},
	{"hmbu", "眚"},
	{"hmd", "竽"},
	{"hmgn", "箌 籈"},
	{"hmgt", "筭"},
	{"hmhaf", "鴟 鷎"},
	{"hmhml", "斵"},
	{"hmhmm", "㽓"},
	{"hmhne", "毁"},
	{"hmhqm", "甡"},
	{"hmj", "竿"},
	{"hml", "斤"},
	{"hmlk", "筻"},
	{"hmlm", "𥮳"},
	{"hmm", "竺"},
	{"hmmk", "䈣"},
	{"hmmp", "籭"},
	{"hmmu", "笎"},
	{"hmmvn", "甀"},
	{"hmnd", "築"},
	{"hmnj", "筑"},
	{"hmnl", "筇 邸 郵"},
	{"hmnq", "篫"},
	{"hmnr", "笴"},
	{"hmoo", "筮"},
	{"hmp", "惩 憇"},
	{"hmr", "后"},
	{"hmrg", "垕"},
	{"hmsl", "笻"},
	{"hmsmb", "歸"},
	{"hmsu", "卮"},
	{"hmt", "笄"},
	{"hmua", "簪"},
	{"hmvh", "笌"},
	{"hmwd", "篥"},
	{"hmwf", "篻"},
	{"hmwj", "簟"},
	{"hmwks", "甥"},
	{"hmy", "斥"},
	{"hn", "几 凢 𠂊"},
	{"hnamh", "颺"},
	{"hnbmc", "颶"},
	{"hnbou", "䬙"},
	{"hnbuc", "𩗗"},
	{"hnc", "鋫"},
	{"hncr", "簷"},
	{"hnd", "朵 梨"},
	{"hndmq", "颹"},
	{"hndo", "箛"},
	{"hne", "凤 殳"},
	{"hnef", "篜"},
	{"hneii", "颾"},
	{"hnff", "颷"},
	{"hnfff", "飈"},
	{"hnhag", "凰"},
	{"hnhdv", "䬐"},
	{"hnhe", "笈"},
	{"hnhhh", "颩"},
	{"hnhhw", "飀"},
	{"hnhjr", "颳"},
	{"hnhli", "風"},
	{"hnhq", "犁"},
	{"hnhxe", "颼"},
	{"hni", "凡"},
	{"hnib", "筩"},
	{"hnikk", "飇"},
	{"hnir", "颱"},
	{"hnk", "风 𠘰"},
	{"hnkcf", "飉"},
	{"hnkg", "筳"},
	{"hnkm", "筵"},
	{"hnld", "篨 𥱥"},
	{"hnlh", "第"},
	{"hnmaf", "鳳"},
	{"hnmgh", "飋"},
	{"hnmm", "篛"},
	{"hnmni", "夙"},
	{"hnmnn", "颲"},
	{"hnmvh", "颬"},
	{"hnmwf", "飃"},
	{"hnoe", "㴝"},
	{"hnono", "颴"},
	{"hnot", "簦"},
	{"hnp", "愆"},
	{"hnpru", "颮"},
	{"hnq", "掣"},
	{"hnqkq", "𩗴"},
	{"hnrms", "𩖸"},
	{"hnryo", "躗"},
	{"hnshr", "䫿"},
	{"hnsmh", "飂"},
	{"hnu", "𩖞"},
	{"hnwp", "颸"},
	{"hnyhv", "製"},
	{"hnyk", "𩖰"},
	{"hnymr", "讆"},
	{"hnyr", "颭"},
	{"ho", "八 彳"},
	{"hoa", "昝"},
	{"hoahu", "𢔰"},
	{"hoami", "得"},
	{"hoamo", "徥"},
	{"hoau", "爬"},
	{"hoaue", "忁"},
	{"hoav", "很"},
	{"hobc", "籲"},
	{"hobg", "篧"},
	{"hobgn", "衢"},
	{"hobgr", "徟"},
	{"hobm", "徂"},
	{"hobou", "徭"},
	{"hobrn", "衕"},
	{"hobug", "忂"},
	{"hobvk", "徯"},
	{"hoci", "彸"},
	{"hocmn", "銜"},
	{"hodbn", "衞"},
	{"hodhe", "彼"},
	{"hodi", "符"},
	{"hodmq", "徫"},
	{"hodoo", "徠"},
	{"hodqn", "衛"},
	{"hoemn", "衍"},
	{"hof", "熧"},
	{"hofbk", "徶"},
	{"hofbr", "徜"},
	{"hogdi", "待"},
	{"hoge", "䉶"},
	{"hoggn", "街"},
	{"hoggu", "徺"},
	{"hogtj", "𢔛"},
	{"hogyo", "徒"},
	{"hohaf", "鴔 鴩"},
	{"hohag", "徨"},
	{"hohgn", "衝"},
	{"hohju", "循"},
	{"hohkn", "𧗤"},
	{"hohne", "役"},
	{"hohpm", "彽"},
	{"hohqm", "徃"},
	{"hohqo", "瓞 𤔅"},
	{"hohs", "筰"},
	{"hohsk", "徼"},
	{"hoi", "筏"},
	{"hoib", "籂"},
	{"hoice", "𢓭"},
	{"hoicn", "術"},
	{"hoii", "笭"},
	{"hoim", "籤"},
	{"hoimn", "𧗠"},
	{"hoin", "笒"},
	{"hoip", "笩"},
	{"hoir", "篬"},
	{"hoisb", "徧"},
	{"hojcn", "衠"},
	{"hojmf", "徖"},
	{"hojrn", "衚"},
	{"hojwp", "德"},
	{"hokmr", "徛"},
	{"hoks", "劮"},
	{"hold", "篠"},
	{"holii", "瓥"},
	{"holk", "筱"},
	{"holln", "彿"},
	{"holmy", "徘"},
	{"holn", "𠠬"},
	{"holq", "律"},
	{"holy", "𥮴"},
	{"homb", "籥"},
	{"homcw", "徆"},
	{"homd", "筡"},
	{"homg", "筌"},
	{"homjn", "衎"},
	{"homk", "箯"},
	{"hommn", "行"},
	{"homnf", "鴴"},
	{"homo", "簽"},
	{"homr", "答"},
	{"homrn", "衙"},
	{"homun", "衏"},
	{"homvm", "徑"},
	{"homwf", "徱"},
	{"homym", "征"},
	{"honfn", "𢖍"},
	{"honhe", "彶"},
	{"honk", "篌"},
	{"honkn", "衡 𧗽 𧗾"},
	{"honkq", "徤"},
	{"hooae", "復"},
	{"hooii", "彾"},
	{"hooma", "徻"},
	{"hoomd", "徐"},
	{"hooml", "御"},
	{"hoooo", "從"},
	{"hop", "怣 慫 𢜛"},
	{"hopa", "徇"},
	{"hopi", "彴 瓝"},
	{"hopru", "爮 瓟"},
	{"hopsh", "彻"},
	{"hoqb", "篟"},
	{"hoqkq", "𢔓"},
	{"hor", "咎"},
	{"horye", "徦"},
	{"hosj", "聳"},
	{"hosyq", "徲"},
	{"hotcn", "衖"},
	{"hotq", "徉"},
	{"houfk", "徽 鰴 黴"},
	{"houfn", "䘗"},
	{"hougk", "徵"},
	{"hourk", "徾"},
	{"houuk", "微"},
	{"hovie", "後"},
	{"howr", "徊"},
	{"hoybk", "徹"},
	{"hoybp", "徿"},
	{"hoybs", "徬"},
	{"hoyck", "㼎"},
	{"hoyg", "往"},
	{"hoyhs", "彷"},
	{"hoyin", "衒"},
	{"hoyj", "斞"},
	{"hoylo", "徙"},
	{"hoynn", "䘕"},
	{"hoyrv", "忀"},
	{"hoytj", "𢕔"},
	{"hp", "乇"},
	{"hpa", "昏 筍"},
	{"hpd", "竾"},
	{"hpdk", "筷"},
	{"hphaf", "鵖"},
	{"hphh", "笏"},
	{"hpi", "𥫩"},
	{"hpim", "笉"},
	{"hplb", "帋"},
	{"hpln", "剩"},
	{"hpm", "氐"},
	{"hpmvu", "旣"},
	{"hpnl", "鄎"},
	{"hpp", "笓"},
	{"hpr", "笱"},
	{"hpru", "笣"},
	{"hpsl", "印 卽"},
	{"hpt", "笹"},
	{"hpuu", "篘"},
	{"hq", "牛 牜"},
	{"hqate", "犦"},
	{"hqau", "筢"},
	{"hqawe", "𤛔"},
	{"hqbmc", "犋"},
	{"hqbtu", "犅"},
	{"hqbu", "看"},
	{"hqbuk", "煟"},
	{"hqby", "𤘪"},
	{"hqda", "籍"},
	{"hqfqu", "犈"},
	{"hqg", "牡"},
	{"hqgdi", "特"},
	{"hqgwc", "犢"},
	{"hqhdj", "煐"},
	{"hqhgr", "牿"},
	{"hqhj", "篺"},
	{"hqhkb", "犞"},
	{"hqhpm", "牴"},
	{"hqhq", "牪"},
	{"hqhqm", "牲"},
	{"hqhqq", "犇"},
	{"hqhqu", "牦"},
	{"hqhw", "籀"},
	{"hqi", "我"},
	{"hqipf", "犥"},
	{"hqisb", "犏"},
	{"hqiuh", "牻"},
	{"hqjbd", "㹀"},
	{"hqjbm", "犆"},
	{"hqjm", "篲"},
	{"hqjmm", "𤚗"},
	{"hqjnd", "牸"},
	{"hqjqr", "犗"},
	{"hqjr", "牯"},
	{"hqjru", "𤙥"},
	{"hqkmr", "犄"},
	{"hqks", "牞"},
	{"hqlw", "牰"},
	{"hqlxh", "牬"},
	{"hqm", "生"},
	{"hqmb", "箐"},
	{"hqmc", "簀"},
	{"hqmmr", "牾"},
	{"hqmqj", "拜"},
	{"hqmtb", "犡"},
	{"hqmvm", "牼"},
	{"hqnbg", "觕"},
	{"hqnkq", "煋"},
	{"hqo", "失"},
	{"hqok", "牧"},
	{"hqomg", "牷"},
	{"hqond", "犔"},
	{"hqp", "牝"},
	{"hqpd", "牠"},
	{"hqphh", "物"},
	{"hqpuu", "犓"},
	{"hqr", "筘 𤘘"},
	{"hqrye", "煰"},
	{"hqsb", "箍"},
	{"hqshi", "牣"},
	{"hqta", "簎"},
	{"hqtb", "簼"},
	{"hqtce", "犪"},
	{"hqtgs", "犧"},
	{"hqthb", "犕"},
	{"hqtm", "箝"},
	{"hqu", "毛"},
	{"hqvvv", "犣"},
	{"hqwj", "籜"},
	{"hqwlp", "犤"},
	{"hqwyi", "牳"},
	{"hqyaj", "𤙴"},
	{"hqybp", "𤜆"},
	{"hqyrb", "犒"},
	{"hqyrd", "犉"},
	{"hqytg", "犝"},
	{"hrbc", "篔"},
	{"hrdlc", "𦧺"},
	{"hrff", "舕"},
	{"hrgb", "舑"},
	{"hrhaf", "鴭 鴰 鵅 鵠"},
	{"hrhkp", "舔"},
	{"hrhpm", "煘 迣 錕 鬳"},
	{"hrhr", "筥"},
	{"hrhvp", "舐"},
	{"hrj", "阜"},
	{"hrks", "勂"},
	{"hrlb", "帥"},
	{"hrlmi", "蛗"},
	{"hrln", "刮 劄"},
	{"hrlr", "𨸏"},
	{"hrmbc", "頟 頧"},
	{"hrmlb", "師"},
	{"hrmr", "簬"},
	{"hrncr", "舚"},
	{"hrnl", "郈 郜"},
	{"hrog", "雒"},
	{"hrok", "啟"},
	{"hrrj", "簞"},
	{"hrtm", "甜"},
	{"hru", "峊"},
	{"hruc", "簨"},
	{"hrvp", "笢"},
	{"hrwvf", "𦧲"},
	{"hryf", "烏"},
	{"hs", "乍 戶"},
	{"hsb", "肩"},
	{"hsbr", "扃"},
	{"hsbt", "扁"},
	{"hsff", "扊"},
	{"hsfi", "𥳀"},
	{"hshaf", "𩿞"},
	{"hshml", "所"},
	{"hshne", "殷 𣪧"},
	{"hshr", "笤"},
	{"hshu", "𠒎"},
	{"hsik", "戾"},
	{"hsit", "籃"},
	{"hsj", "䇯"},
	{"hsk", "笋"},
	{"hsko", "篋"},
	{"hskr", "䇹"},
	{"hslc", "籄"},
	{"hslmy", "扉"},
	{"hsly", "篚"},
	{"hsmb", "箒"},
	{"hsmbl", "𥤃"},
	{"hsmg", "筐 籊"},
	{"hsmr", "笥"},
	{"hsog", "雇"},
	{"hsok", "敫"},
	{"hsp", "怎"},
	{"hsqf", "篤"},
	{"hsr", "笸"},
	{"hsrau", "扈"},
	{"hsru", "戺"},
	{"hssmm", "扇"},
	{"hsyhs", "房"},
	{"hsyhv", "扆"},
	{"hsyj", "戽"},
	{"hsyr", "扂"},
	{"hsyu", "𡷊"},
	{"ht", "升"},
	{"htbn", "箭"},
	{"htce", "簸"},
	{"htcg", "簊"},
	{"htcl", "簛"},
	{"hte", "𣲛"},
	{"htfq", "衅"},
	{"htg", "𡉼"},
	{"hthaf", "鷑"},
	{"htjs", "簕"},
	{"htkr", "箬"},
	{"htmc", "箕 簧"},
	{"htmf", "衃"},
	{"htmo", "篏"},
	{"htng", "衄"},
	{"htnl", "䘏"},
	{"htoho", "衆"},
	{"htshi", "衂"},
	{"htsj", "衈"},
	{"htsl", "卹"},
	{"httb", "篝"},
	{"httwi", "衊"},
	{"hubuc", "贊"},
	{"hud", "臬"},
	{"hudm", "𦤎"},
	{"huf", "毜 熈 𤆬"},
	{"huff", "毯"},
	{"huhaf", "鵚 鶂 鶞 鷉"},
	{"huhgu", "兟 毨"},
	{"huhon", "𠒣"},
	{"huhuu", "毳"},
	{"huihq", "毪"},
	{"huij", "毧"},
	{"huije", "毬"},
	{"huik", "臭"},
	{"huikk", "瞂"},
	{"huioj", "臯"},
	{"hukq", "𦤑"},
	{"hulmc", "穨"},
	{"huln", "𠜎"},
	{"humbc", "頹"},
	{"humcw", "毢"},
	{"hummu", "𠒑"},
	{"hunkq", "毽"},
	{"hunl", "郋 郳 𠒒"},
	{"huno", "歋"},
	{"hunwa", "氌"},
	{"huomn", "毺"},
	{"huooo", "臮"},
	{"hup", "息 憩"},
	{"hupru", "𣭚"},
	{"hutak", "氁"},
	{"hutca", "氆"},
	{"huu", "嵆"},
	{"huwml", "鼻"},
	{"huwp", "毸"},
	{"huyj", "𣁽"},
	{"huyr", "毡"},
	{"huytj", "辠"},
	{"huytr", "毰"},
	{"hv", "𧘇"},
	{"hvajv", "鼹"},
	{"hvbjj", "鼲"},
	{"hvbu", "覣"},
	{"hvbuc", "鼰"},
	{"hvbuk", "鼳"},
	{"hvbuu", "覛"},
	{"hvbvk", "鼷"},
	{"hvcsh", "鼢"},
	{"hve", "笯"},
	{"hvfi", "箹"},
	{"hvgdi", "鼭"},
	{"hvhey", "鼨"},
	{"hvhi", "魏"},
	{"hvhqm", "鼪"},
	{"hvhu", "兜"},
	{"hvhyu", "鼶"},
	{"hvif", "系"},
	{"hvik", "鼣"},
	{"hvikk", "鼥"},
	{"hvil", "籪"},
	{"hvio", "瓜"},
	{"hvjck", "鼵"},
	{"hvjp", "鼧"},
	{"hvlw", "鼬"},
	{"hvmmr", "鼯"},
	{"hvmr", "鼫"},
	{"hvmvn", "瑏"},
	{"hvnkg", "鼮"},
	{"hvno", "篆"},
	{"hvp", "氏"},
	{"hvpr", "鼩"},
	{"hvqmb", "鼱"},
	{"hvr", "筎"},
	{"hvsav", "鼴"},
	{"hvshr", "鼦"},
	{"hvsl", "卬"},
	{"hvsm", "鸟"},
	{"hvtxc", "鼸"},
	{"hvyk", "鼤"},
	{"hwe", "笝"},
	{"hwgti", "睾"},
	{"hwhaf", "鶹 鷭"},
	{"hwhd", "箘"},
	{"hwhu", "𠒇"},
	{"hwim", "簂"},
	{"hwjr", "箇"},
	{"hwk", "囟 筃"},
	{"hwkk", "囪"},
	{"hwks", "勫"},
	{"hwl", "笚"},
	{"hwlg", "籮"},
	{"hwli", "篾"},
	{"hwml", "箅"},
	{"hwmvs", "粵"},
	{"hwnk", "囱"},
	{"hwnl", "鄱"},
	{"hwnoo", "飜"},
	{"hwp", "悤 𥯨"},
	{"hwsmm", "翻"},
	{"hwtj", "篳"},
	{"hwww", "䉪"},
	{"hx", "臼 𦥑"},
	{"hxbc", "興"},
	{"hxbt", "盥"},
	{"hxh", "身"},
	{"hxhu", "兒"},
	{"hxjc", "輿"},
	{"hxlb", "帠"},
	{"hxle", "叟"},
	{"hxno", "歃"},
	{"hxo", "臾"},
	{"hxt", "舁"},
	{"hxu", "龜"},
	{"hxvyv", "鼠"},
	{"hxwks", "舅"},
	{"hxyc", "與"},
	{"hxyf", "舄"},
	{"hyabu", "艒"},
	{"hyau", "舥"},
	{"hybb", "簻 𥰆"},
	{"hybg", "籬"},
	{"hybmr", "𦨴"},
	{"hybnd", "艀"},
	{"hybp", "籠"},
	{"hybs", "篣"},
	{"hybuu", "䚀"},
	{"hyci", "舩"},
	{"hyck", "筊"},
	{"hycr", "船"},
	{"hydhe", "㿭 𦨭"},
	{"hydoo", "𦩑"},
	{"hyfb", "艄"},
	{"hyfbw", "艡"},
	{"hygow", "艢"},
	{"hyha", "舶"},
	{"hyhaf", "鵃"},
	{"hyhag", "艎"},
	{"hyhe", "舨"},
	{"hyhej", "艂"},
	{"hyheq", "舽"},
	{"hyhj", "篷"},
	{"hyhlo", "艞"},
	{"hyhm", "簅"},
	{"hyhn", "笐"},
	{"hyhne", "般"},
	{"hyhni", "䑺"},
	{"hyhr", "簉"},
	{"hyhs", "籩 舴"},
	{"hyhsb", "艑"},
	{"hyhxe", "艘"},
	{"hyite", "艔"},
	{"hyjp", "舵"},
	{"hyki", "舦"},
	{"hykms", "舿"},
	{"hykpb", "艜"},
	{"hyl", "舯"},
	{"hylm", "䇛"},
	{"hylw", "舳"},
	{"hylwv", "艛"},
	{"hym", "舡"},
	{"hymcw", "舾"},
	{"hymlm", "𦩒"},
	{"hymnr", "舸"},
	{"hymo", "篴"},
	{"hyndt", "艋"},
	{"hynkg", "艇"},
	{"hynri", "艬"},
	{"hyoge", "艭"},
	{"hyoii", "舲"},
	{"hyoip", "𦨮"},
	{"hyoir", "艙"},
	{"hyoj", "箤"},
	{"hyomd", "艅"},
	{"hyono", "𦩂"},
	{"hypm", "𥲤"},
	{"hypp", "舭"},
	{"hypt", "籚"},
	{"hyptd", "艓"},
	{"hypu", "箎 虒"},
	{"hyr", "笘"},
	{"hyrb", "篙"},
	{"hyrji", "艥"},
	{"hyrl", "篰"},
	{"hyrn", "籝 籯"},
	{"hyro", "籇"},
	{"hysd", "箷"},
	{"hysh", "舠"},
	{"hyshu", "艉"},
	{"hysit", "艦"},
	{"hysk", "簇"},
	{"hysm", "𥰁"},
	{"hysy", "箊"},
	{"hyt", "笠"},
	{"hytb", "𥴰"},
	{"hytbo", "艨"},
	{"hytc", "舼"},
	{"hytct", "艗"},
	{"hytgi", "艤"},
	{"hythu", "艏"},
	{"hytj", "𥭴"},
	{"hytqm", "艖"},
	{"hytwa", "艚"},
	{"hyu", "舢"},
	{"hyub", "篱"},
	{"hyuce", "艐"},
	{"hyv", "笀"},
	{"hywl", "舺"},
	{"hywv", "簑"},
	{"hyybs", "艕"},
	{"hyyhn", "航"},
	{"hyyhs", "舫"},
	{"hyyo", "籧"},
	{"hyyps", "艣"},
	{"hyypt", "艫"},
	{"hyytg", "艟"},
	{"hyyvi", "舷"},
	{"hyyx", "艩"},
	{"i", "戈"},
	{"iaie", "廄"},
	{"iaiu", "廐"},
	{"iav", "良"},
	{"ib", "禸"},
	{"ibbt", "盙"},
	{"ibcn", "廁"},
	{"ibcv", "廮"},
	{"ibd", "㮾"},
	{"ibdi", "尃"},
	{"ibg", "塱"},
	{"ibhaf", "鵏 鷛"},
	{"ibhhh", "㣑"},
	{"ibnl", "郙 鄘"},
	{"ibpp", "能"},
	{"ibuc", "貟"},
	{"icff", "𤒼"},
	{"ichaf", "𪇵"},
	{"icnl", "鄺"},
	{"icno", "廞"},
	{"icp", "怷"},
	{"id", "床"},
	{"idbbr", "𪎩"},
	{"idbu", "廂"},
	{"idf", "𤇍"},
	{"idfd", "糜"},
	{"idg", "塺"},
	{"idhd", "穈"},
	{"idhda", "黁"},
	{"idhi", "魔 麽"},
	{"idhq", "犘"},
	{"idhqu", "麾"},
	{"idjtc", "黂"},
	{"idlmy", "靡"},
	{"idlyf", "爢"},
	{"idmr", "磨"},
	{"idoo", "庲"},
	{"idq", "摩"},
	{"idrhr", "麿"},
	{"idsje", "黀"},
	{"idvi", "麼"},
	{"idvif", "縻"},
	{"ie", "氷"},
	{"iea", "昶"},
	{"iebt", "盚"},
	{"iedhe", "皴"},
	{"iehhh", "𢒋"},
	{"ieln", "剫"},
	{"ienau", "𠬍"},
	{"ienui", "㕙"},
	{"ieok", "救"},
	{"ieyhv", "裘"},
	{"if", "礻"},
	{"ifaa", "𥚕"},
	{"ifam", "𥘵"},
	{"ifamh", "禓"},
	{"ifamo", "禔"},
	{"ifasm", "禢"},
	{"ifbbr", "禍"},
	{"ifbgr", "禂"},
	{"ifbhu", "视"},
	{"ifbjj", "禈"},
	{"ifbk", "廠"},
	{"ifbm", "祖"},
	{"ifbme", "禐"},
	{"ifbuu", "視"},
	{"ifcru", "祱"},
	{"ifdmq", "禕"},
	{"iffkc", "禷"},
	{"iffmu", "𥙑"},
	{"ifg", "社"},
	{"ifgce", "祾"},
	{"ifgi", "祛"},
	{"ifgni", "禱"},
	{"ifgrc", "𥜝"},
	{"ifgrr", "禧"},
	{"ifhaf", "鷓"},
	{"ifhgr", "祰"},
	{"ifhhj", "禆"},
	{"ifhjd", "祩"},
	{"ifhk", "祅"},
	{"ifhml", "祈"},
	{"ifhn", "凴"},
	{"ifhne", "祋"},
	{"ifhpm", "祗"},
	{"ifhqi", "䄉"},
	{"ifhqo", "祑"},
	{"ifhs", "祚"},
	{"ifhuc", "禶"},
	{"ifhvp", "祇"},
	{"ifhyu", "禠"},
	{"ifikk", "祓"},
	{"ifilr", "禟"},
	{"ifit", "祴"},
	{"ifjbc", "禛"},
	{"ifjbm", "禃"},
	{"ifjd", "祙"},
	{"ifjka", "禇"},
	{"ifjr", "祜"},
	{"ifkmr", "䄎"},
	{"ifkpb", "𥛣"},
	{"ifkr", "祐"},
	{"ifl", "祌"},
	{"iflbk", "䄃"},
	{"iflmo", "祧"},
	{"iflpb", "禙"},
	{"iflpc", "𥜥"},
	{"iflwl", "神"},
	{"ifmbc", "顣"},
	{"ifmfb", "禰"},
	{"ifmk", "祆"},
	{"ifmmv", "祳"},
	{"ifmr", "祏"},
	{"ifmrw", "福"},
	{"ifmtb", "禲"},
	{"ifmwg", "禋"},
	{"ifmwj", "禫"},
	{"ifnf", "祢"},
	{"ifnhs", "礽"},
	{"ifnl", "祁 鄬"},
	{"ifnmu", "祪"},
	{"ifodi", "祔"},
	{"ifohv", "祣"},
	{"ifoll", "祄"},
	{"ifoma", "禬"},
	{"ifomb", "禴"},
	{"ifomr", "祫"},
	{"ifp", "慼 憑"},
	{"ifpd", "祂"},
	{"ifph", "祕"},
	{"ifpi", "礿"},
	{"ifpou", "祹"},
	{"ifqhk", "禊"},
	{"ifrhu", "祝"},
	{"ifrrj", "禪"},
	{"ifru", "祀"},
	{"ifryo", "蹙"},
	{"ifshr", "祒"},
	{"ifsme", "祲"},
	{"ifsmm", "祤"},
	{"ifsmr", "祠"},
	{"ifsqf", "禡"},
	{"iftcg", "禥"},
	{"iftgf", "禚"},
	{"iftgr", "𥛶"},
	{"iftmc", "祺"},
	{"iftmd", "禖"},
	{"iftq", "祥"},
	{"iftwt", "禮"},
	{"ifu", "礼"},
	{"ifvii", "禨"},
	{"ifvne", "祿"},
	{"ifvno", "禒"},
	{"ifwce", "禝"},
	{"ifwd", "祼"},
	{"ifwg", "𥚃"},
	{"ifwk", "䄄"},
	{"ifwlb", "禑"},
	{"ifwlm", "禤"},
	{"ifwp", "禗"},
	{"ifwtc", "禩"},
	{"ifybb", "禘"},
	{"ifybc", "禎"},
	{"ifyhs", "祊"},
	{"ifylm", "祉"},
	{"ifyoj", "祽"},
	{"ifyrv", "禳"},
	{"ifyto", "禭"},
	{"ig", "庄"},
	{"igb", "膺"},
	{"igce", "庱"},
	{"igdi", "庤"},
	{"ighaf", "鷹"},
	{"igi", "庒"},
	{"igit", "廅"},
	{"igow", "廧"},
	{"igp", "應"},
	{"igsk", "廒"},
	{"igti", "廚"},
	{"igyhv", "装"},
	{"ih", "戊"},
	{"ihaf", "𩾷"},
	{"ihhi", "螷 蠯"},
	{"ihhj", "庳"},
	{"ihhqu", "毿"},
	{"ihhw", "廇"},
	{"ihi", "廆 戍"},
	{"ihln", "剼"},
	{"ihm", "戌"},
	{"ihmf", "烕"},
	{"ihml", "庍"},
	{"ihmr", "咸"},
	{"ihmv", "威"},
	{"ihpm", "底"},
	{"ihq", "牟"},
	{"ihs", "成"},
	{"ihsh", "𢦓"},
	{"ihu", "允"},
	{"ihxe", "廋"},
	{"ihxo", "庾"},
	{"ihymf", "戚"},
	{"ii", "広 戔"},
	{"iib", "朗"},
	{"iibt", "盞"},
	{"iiif", "絫"},
	{"iiih", "參"},
	{"iiil", "廊"},
	{"iiip", "叅"},
	{"iiln", "剆 剗"},
	{"iinl", "郎"},
	{"iino", "欴"},
	{"iiobo", "腐"},
	{"iiuh", "庬"},
	{"iixp", "廘"},
	{"ij", "戎"},
	{"ijb", "甫"},
	{"ijc", "朮"},
	{"ijcc", "麻"},
	{"ije", "庋 求"},
	{"ijjb", "廟"},
	{"ijkd", "庨"},
	{"ijwj", "庫"},
	{"ik", "义 庆 犬"},
	{"ikbuc", "貵"},
	{"ikd", "𣘼"},
	{"ikhhh", "参"},
	{"ikhni", "飆"},
	{"ikikk", "猋"},
	{"ikjwj", "軬"},
	{"ikk", "犮"},
	{"iklq", "𦘦"},
	{"iklu", "庵"},
	{"ikmg", "𤨣"},
	{"ikmmm", "叁"},
	{"iknf", "為"},
	{"ikno", "欸"},
	{"ikp", "慦 龙"},
	{"ikpb", "廗"},
	{"ikr", "啓"},
	{"ikrm", "彧"},
	{"iku", "尤"},
	{"ikw", "畚"},
	{"ilb", "庸"},
	{"ile", "康"},
	{"ilg", "𡏅"},
	{"ilil", "州"},
	{"ilmo", "庣"},
	{"iln", "划"},
	{"ilo", "庚"},
	{"ilob", "𢉼"},
	{"iloc", "賡"},
	{"ilr", "唐"},
	{"ils", "门"},
	{"ilw", "庙"},
	{"ilwv", "廔"},
	{"im", "冫"},
	{"imbgr", "凋"},
	{"imbsd", "凈"},
	{"imc", "凎 剢"},
	{"imcw", "庮"},
	{"imdci", "凇"},
	{"imdk", "决"},
	{"imdw", "凍"},
	{"ime", "冰"},
	{"imfq", "冸"},
	{"imgce", "凌"},
	{"imgwc", "凟"},
	{"imhgu", "冼"},
	{"imice", "𠗕"},
	{"imidq", "𠘚"},
	{"imig", "庢"},
	{"imihr", "减"},
	{"imikk", "冹"},
	{"imir", "冶"},
	{"imjlv", "凄"},
	{"iml", "丬 冲"},
	{"imm", "冮"},
	{"immgi", "𤦂"},
	{"immmr", "𠗐"},
	{"immnn", "冽"},
	{"immp", "廲"},
	{"immr", "㓈"},
	{"immvh", "冴"},
	{"immvm", "冱 𠗊"},
	{"immwd", "凓"},
	{"immwg", "凐"},
	{"imnbk", "𠗫"},
	{"imndt", "𠗠"},
	{"imno", "次"},
	{"imnui", "𠗟"},
	{"imog", "准"},
	{"imoii", "冷"},
	{"imoir", "凔"},
	{"imoiv", "飡"},
	{"imomd", "凃"},
	{"imomr", "冾"},
	{"imp", "惑"},
	{"imphh", "𠖳"},
	{"impko", "凝"},
	{"imqkk", "凑"},
	{"imqmb", "凊"},
	{"imrhu", "况"},
	{"imsll", "臧"},
	{"imsqf", "馮"},
	{"imsuf", "凞 𠘑 𠘕"},
	{"imtcl", "凘"},
	{"imue", "廈"},
	{"imumt", "凒"},
	{"imuog", "凗"},
	{"imvh", "庌"},
	{"imvid", "𠘙"},
	{"imwjr", "凅"},
	{"imwk", "𠗃"},
	{"imyrf", "凉"},
	{"imywd", "凜"},
	{"imywf", "凛"},
	{"inbq", "廨"},
	{"ine", "永"},
	{"infq", "廯"},
	{"inin", "序"},
	{"inkg", "庭"},
	{"inli", "廕"},
	{"ino", "之"},
	{"inoe", "廢"},
	{"inv", "讠"},
	{"io", "庂"},
	{"iobuc", "資"},
	{"iod", "庥 栥"},
	{"iodi", "府"},
	{"iofd", "粢"},
	{"iog", "垐"},
	{"iogr", "譍"},
	{"iohaf", "鶊"},
	{"iohd", "秶"},
	{"ioin", "庈"},
	{"iok", "矣"},
	{"ioma", "廥"},
	{"iomr", "𢈈"},
	{"iomvn", "瓷"},
	{"ioog", "座"},
	{"iooiv", "餈"},
	{"iop", "恣"},
	{"ior", "咨"},
	{"iord", "楶"},
	{"iotf", "廡"},
	{"iov", "姿"},
	{"ip", "庀 弋"},
	{"ipbm", "麆"},
	{"ipbuc", "貣"},
	{"ipc", "鏖"},
	{"ipf", "熊 麃"},
	{"ipfd", "麋"},
	{"ipfdq", "麟"},
	{"ipg", "塵"},
	{"iphaf", "鳶 𪈠"},
	{"iphd", "麇"},
	{"iphda", "麘"},
	{"ipher", "𪊲"},
	{"iphhi", "麝"},
	{"iphn", "麂"},
	{"iphor", "麔"},
	{"iphqm", "𪊟"},
	{"iphxu", "麑"},
	{"ipice", "𪊴"},
	{"ipihr", "麙"},
	{"ipipp", "麤"},
	{"iplmi", "螚"},
	{"ipm", "弌 式"},
	{"ipmbr", "麢"},
	{"ipmc", "廎"},
	{"ipmm", "弍"},
	{"ipmmc", "貳"},
	{"ipmmm", "弎"},
	{"ipmmv", "麎"},
	{"ipmwd", "麜"},
	{"ipmwm", "麠"},
	{"ipnkg", "𪊶"},
	{"ipnl", "鄜"},
	{"ipnsj", "麛"},
	{"ipog", "隿"},
	{"ipp", "庇 忒 態 麀"},
	{"ippru", "麅"},
	{"ipru", "庖"},
	{"iprvk", "麌"},
	{"iprye", "麚"},
	{"iptm", "甙"},
	{"iptmc", "麒"},
	{"ipu", "庉"},
	{"ipwd", "𪊽"},
	{"ipwhd", "麕"},
	{"ipyg", "麈"},
	{"ipyiu", "麍"},
	{"ipyk", "𪊓"},
	{"ipykr", "麐 𪊺"},
	{"ipyrf", "麖"},
	{"ipytj", "麞 𪋟"},
	{"ipyx", "麡"},
	{"iqhaf", "鴾"},
	{"iqhf", "緳"},
	{"iqje", "庪"},
	{"ir", "台"},
	{"ird", "枲"},
	{"irf", "炱"},
	{"irhaf", "鶶"},
	{"irm", "或"},
	{"irmbc", "顑"},
	{"irmvn", "瓵"},
	{"irnbg", "觱"},
	{"irnl", "邰"},
	{"irp", "怠 感"},
	{"is", "户"},
	{"isa", "间"},
	{"isbt", "盛"},
	{"isgp", "廳"},
	{"ishn", "𠙖"},
	{"isja", "廜"},
	{"ismh", "廖"},
	{"isn", "戹"},
	{"isnl", "郕"},
	{"isok", "敷"},
	{"isr", "启"},
	{"isrj", "廦"},
	{"it", "弁 戒"},
	{"ita", "庴"},
	{"itcl", "廝"},
	{"ite", "度"},
	{"itf", "庶"},
	{"ithaf", "鴘"},
	{"itlb", "席"},
	{"itlm", "廑"},
	{"itmc", "廣"},
	{"itq", "庠"},
	{"itso", "庹"},
	{"itt", "庰"},
	{"itxc", "廉"},
	{"iuhhh", "尨"},
	{"iv", "戉"},
	{"ivhne", "设"},
	{"ivpa", "询"},
	{"ivug", "廱"},
	{"iwcg", "廛"},
	{"iwlb", "庽"},
	{"iwtc", "廙"},
	{"ixe", "慶"},
	{"ixf", "廌"},
	{"ixp", "鹿"},
	{"iybp", "龐"},
	{"iydl", "廓"},
	{"iyln", "劘"},
	{"iymp", "庛"},
	{"iypt", "廬"},
	{"iyr", "店"},
	{"iyrl", "廍"},
	{"iywd", "廩"},
	{"iyx", "𪗆"},
	{"j", "十"},
	{"jabuu", "覩"},
	{"jaf", "煑 煮"},
	{"jahc", "賔"},
	{"jamo", "寔"},
	{"janl", "都"},
	{"jasmm", "翥"},
	{"jav", "宴"},
	{"jb", "巿"},
	{"jbbuc", "賫 賷"},
	{"jbd", "寀"},
	{"jbhaf", "鶦"},
	{"jbhod", "櫜"},
	{"jbik", "献"},
	{"jblli", "蟗"},
	{"jbm", "宜"},
	{"jbmc", "真"},
	{"jbmm", "直"},
	{"jbmrd", "橐"},
	{"jbmri", "蠹"},
	{"jbnd", "孛"},
	{"jbof", "察"},
	{"jbrrv", "囊"},
	{"jbtj", "南"},
	{"jbvif", "索"},
	{"jbwno", "疐"},
	{"jc", "穴"},
	{"jcbbr", "窩"},
	{"jcbou", "窰"},
	{"jcbu", "窅"},
	{"jccwn", "𥦬"},
	{"jcegg", "漥 窪"},
	{"jcemd", "窏"},
	{"jcfdj", "窲"},
	{"jcgfo", "窾"},
	{"jcgg", "窐"},
	{"jcgru", "竈"},
	{"jcgwc", "竇"},
	{"jcgwu", "竃"},
	{"jchaf", "窵 鷏 䴐"},
	{"jchdb", "竊"},
	{"jchdp", "窸"},
	{"jchgr", "窖"},
	{"jchhl", "窌"},
	{"jchhn", "窮"},
	{"jchio", "窆"},
	{"jchk", "穾"},
	{"jchoo", "窳"},
	{"jchs", "窄"},
	{"jchsk", "竅"},
	{"jchuu", "竁"},
	{"jchvo", "窊"},
	{"jchwk", "窗"},
	{"jchwp", "窻"},
	{"jchxv", "竄"},
	{"jci", "戭"},
	{"jcik", "突"},
	{"jcile", "䆲"},
	{"jcip", "窓"},
	{"jcirm", "窢"},
	{"jcjbc", "窴"},
	{"jcjkd", "窙"},
	{"jcjr", "𥥖"},
	{"jckcf", "竂"},
	{"jckn", "究"},
	{"jclb", "帘"},
	{"jclmo", "窕"},
	{"jclwv", "窶"},
	{"jcm", "空"},
	{"jcmbc", "顛"},
	{"jcmd", "穻"},
	{"jcmig", "窒"},
	{"jcmmu", "竀"},
	{"jcmob", "窉"},
	{"jcmvh", "穿"},
	{"jcn", "穵 穹"},
	{"jcnhx", "窞"},
	{"jcni", "穸"},
	{"jcnlm", "窿"},
	{"jcno", "歕"},
	{"jcoju", "窑"},
	{"jcold", "窱"},
	{"jcomn", "窬"},
	{"jcor", "容"},
	{"jcpru", "窇"},
	{"jcpsh", "窃"},
	{"jcpu", "窀"},
	{"jcqhk", "窫"},
	{"jcqou", "窺"},
	{"jcsjl", "窷"},
	{"jcskr", "窘"},
	{"jcsmm", "翸"},
	{"jcsuu", "窟"},
	{"jctgf", "窯"},
	{"jctt", "穽"},
	{"jcuu", "窋"},
	{"jcvis", "窈 𥥆"},
	{"jcvmd", "𥧌"},
	{"jcvvd", "窼"},
	{"jcwd", "窠"},
	{"jcybp", "竉"},
	{"jcyck", "窔"},
	{"jcyoj", "窣"},
	{"jcyta", "窨"},
	{"jd", "宋 未"},
	{"jdci", "𡨭"},
	{"jdhaf", "鵓"},
	{"jdi", "守"},
	{"jdisy", "𣚺"},
	{"jdks", "勃"},
	{"jdmbc", "𩓐"},
	{"jdnl", "郣"},
	{"jdok", "教"},
	{"je", "支"},
	{"jed", "檕"},
	{"jeg", "墼"},
	{"jehaf", "鳷"},
	{"jejwj", "轚"},
	{"jeks", "攰"},
	{"jelmi", "蟿"},
	{"jembc", "頍"},
	{"jeoju", "罊"},
	{"jeq", "擊"},
	{"jese", "寖"},
	{"jesmi", "攳"},
	{"jesmm", "翅"},
	{"jevif", "繫"},
	{"jf", "灾"},
	{"jfb", "宵"},
	{"jgc", "䥅"},
	{"jhdw", "審"},
	{"jher", "客"},
	{"jhgu", "宪"},
	{"jhk", "宎"},
	{"jhkb", "㝯"},
	{"jhlb", "㝢"},
	{"jhn", "宂"},
	{"jhoo", "寙"},
	{"jhp", "宅"},
	{"jhq", "牢"},
	{"jhqu", "宒"},
	{"jhxf", "寫"},
	{"jibi", "博"},
	{"jid", "栽"},
	{"jidi", "專"},
	{"jif", "烖"},
	{"jihaf", "鷒"},
	{"jihs", "宬"},
	{"jijwj", "載"},
	{"jikf", "寪"},
	{"jilmi", "蛓"},
	{"jiln", "剸"},
	{"jimcw", "酨"},
	{"jimig", "臷"},
	{"jimvn", "甎"},
	{"jinl", "鄟"},
	{"jiobo", "胾"},
	{"jiog", "截"},
	{"jip", "惠"},
	{"jir", "哉"},
	{"jismm", "翝"},
	{"jiwtc", "戴"},
	{"jiyhv", "裁"},
	{"jj", "廾"},
	{"jjamh", "輰"},
	{"jjapp", "輥"},
	{"jjapv", "輵"},
	{"jjb", "朝"},
	{"jjbb", "輣"},
	{"jjbc", "寘"},
	{"jjbgr", "輖"},
	{"jjbhx", "轁"},
	{"jjbtv", "輞"},
	{"jjcor", "輍"},
	{"jjdmq", "韓"},
	{"jjeee", "輟"},
	{"jjfb", "輎"},
	{"jjfdq", "轔"},
	{"jjgce", "輘"},
	{"jjgow", "轖"},
	{"jjgrv", "轅"},
	{"jjhby", "輈"},
	{"jjhdw", "轓"},
	{"jjher", "輅"},
	{"jjhfd", "軤"},
	{"jjhg", "軠"},
	{"jjhju", "輴"},
	{"jjhkb", "轎"},
	{"jjhml", "斬"},
	{"jjhne", "軗"},
	{"jjhni", "軓"},
	{"jjhpm", "軧"},
	{"jjhqo", "軼"},
	{"jjhqu", "軞"},
	{"jjhsn", "軶"},
	{"jjhvo", "軱"},
	{"jjhvp", "軝"},
	{"jjhxu", "輗"},
	{"jji", "戟"},
	{"jjibi", "𨍭"},
	{"jjice", "𨌘"},
	{"jjihu", "𨋍"},
	{"jjii", "輚"},
	{"jjijb", "輔"},
	{"jjikk", "軷"},
	{"jjipm", "軾"},
	{"jjir", "軩"},
	{"jjirp", "轗"},
	{"jjixp", "轆"},
	{"jjjii", "轉"},
	{"jjjjj", "轟"},
	{"jjjki", "𨌆"},
	{"jjjmu", "輐"},
	{"jjjnu", "䡝"},
	{"jjjqr", "轄"},
	{"jjjr", "軲"},
	{"jjjtc", "轒"},
	{"jjk", "軑"},
	{"jjkcf", "轑"},
	{"jjki", "軚"},
	{"jjkn", "軌"},
	{"jjlbk", "軮"},
	{"jjlo", "寁"},
	{"jjlw", "軸"},
	{"jjmbb", "轜"},
	{"jjmbk", "輭"},
	{"jjmbl", "輀"},
	{"jjmbv", "𨍥"},
	{"jjmdm", "轣"},
	{"jjmfj", "軯"},
	{"jjmig", "輊"},
	{"jjmj", "軒"},
	{"jjmlb", "輛"},
	{"jjmmi", "転"},
	{"jjmnr", "軻"},
	{"jjmrw", "輻"},
	{"jjmsu", "軛"},
	{"jjmu", "軏"},
	{"jjmvm", "輕"},
	{"jjnau", "輓"},
	{"jjnhd", "輮"},
	{"jjno", "軟"},
	{"jjoae", "輹"},
	{"jjob", "軜"},
	{"jjod", "榦"},
	{"jjodi", "軵"},
	{"jjohf", "鶾"},
	{"jjohh", "軫"},
	{"jjoii", "軨"},
	{"jjoin", "軡"},
	{"jjoli", "螒"},
	{"jjomb", "輪"},
	{"jjomd", "𠏉"},
	{"jjomg", "輇"},
	{"jjomj", "幹"},
	{"jjomn", "輸"},
	{"jjon", "乾 亁"},
	{"jjoog", "雗"},
	{"jjosm", "翰 𨌺"},
	{"jjoyj", "斡"},
	{"jjpr", "軥"},
	{"jjpu", "軘"},
	{"jjpyr", "輷"},
	{"jjqjm", "轊"},
	{"jjqkd", "轃"},
	{"jjqkk", "輳"},
	{"jjqmb", "輤"},
	{"jjr", "軎"},
	{"jjrc", "軹"},
	{"jjrhu", "軦"},
	{"jjrsj", "輯"},
	{"jjshi", "軔"},
	{"jjshr", "軺"},
	{"jjsit", "轞"},
	{"jjsje", "輙"},
	{"jjsju", "輒"},
	{"jjskr", "輑"},
	{"jjsmg", "軭"},
	{"jjsmh", "轇"},
	{"jjsnd", "轏"},
	{"jjsrr", "䡱"},
	{"jjstv", "輾"},
	{"jjtav", "轕"},
	{"jjtc", "輁"},
	{"jjtco", "轐"},
	{"jjtcw", "輶"},
	{"jjtgi", "轙 轛"},
	{"jjtt", "軿"},
	{"jju", "軋"},
	{"jjumb", "輲"},
	{"jjvid", "轢"},
	{"jjvvd", "轈"},
	{"jjvvw", "輜"},
	{"jjwd", "輠"},
	{"jjwlv", "轘"},
	{"jjwot", "轀"},
	{"jjwww", "轠"},
	{"jjybk", "轍"},
	{"jjyck", "較"},
	{"jjycv", "𨍽 𨎊"},
	{"jjyg", "軴"},
	{"jjyib", "𨌯"},
	{"jjyjj", "轋"},
	{"jjypt", "轤"},
	{"jjyrf", "輬"},
	{"jjyt", "𨋢"},
	{"jjyvo", "輆"},
	{"jk", "丈 耂"},
	{"jka", "者"},
	{"jkb", "宥"},
	{"jkcf", "寮"},
	{"jkhaf", "鶟"},
	{"jkhq", "㹈"},
	{"jki", "宏"},
	{"jkmdo", "斄"},
	{"jkme", "漦"},
	{"jkmhq", "犛"},
	{"jkmhu", "氂"},
	{"jkmnd", "孷"},
	{"jkmr", "寄"},
	{"jkmsh", "剺"},
	{"jkmv", "嫠"},
	{"jkmwg", "釐"},
	{"jkn", "宄"},
	{"jknd", "孝"},
	{"jkp", "老"},
	{"jkpr", "耇"},
	{"jkss", "協"},
	{"jkys", "考"},
	{"jla", "暫"},
	{"jlc", "鏨"},
	{"jld", "槧"},
	{"jlg", "塹"},
	{"jlk", "吏"},
	{"jlln", "事"},
	{"jlmo", "宨"},
	{"jlmr", "磛"},
	{"jlp", "慙"},
	{"jlryo", "蹔"},
	{"jlu", "㟻"},
	{"jlv", "妻"},
	{"jlw", "宙"},
	{"jlwv", "寠"},
	{"jlyo", "疌"},
	{"jm", "士"},
	{"jmam", "宣"},
	{"jmbn", "寕 𡨴"},
	{"jmc", "鑋"},
	{"jmch", "寡"},
	{"jmcw", "𡧳"},
	{"jmd", "宇"},
	{"jmfc", "寳"},
	{"jmgi", "宝"},
	{"jmhaf", "鵼"},
	{"jmhc", "賓"},
	{"jmig", "室"},
	{"jmjmm", "矗"},
	{"jmlc", "寅"},
	{"jmmbc", "𩓧"},
	{"jmmc", "賨"},
	{"jmmf", "宗"},
	{"jmmu", "完"},
	{"jmmv", "宸"},
	{"jmn", "宁"},
	{"jmr", "宕"},
	{"jmrw", "富"},
	{"jmsmm", "翧"},
	{"jmso", "家"},
	{"jmtb", "𡩅"},
	{"jmuc", "寶"},
	{"jmue", "寇"},
	{"jmyo", "定"},
	{"jnd", "字"},
	{"jndhe", "麬"},
	{"jnfh", "麨"},
	{"jngi", "麮"},
	{"jnhaf", "鸋 𪄳"},
	{"jni", "宖"},
	{"jnihq", "麰"},
	{"jnijb", "麱"},
	{"jnim", "宐"},
	{"jniu", "宛"},
	{"jnln", "剚"},
	{"jnmls", "麪"},
	{"jnmwl", "麵"},
	{"jnmys", "麫"},
	{"jnon", "麧"},
	{"jnpfd", "麴"},
	{"jnpru", "麭"},
	{"jnqo", "麩"},
	{"jntw", "麯"},
	{"jnui", "寃"},
	{"jnujt", "麷"},
	{"jnup", "惌"},
	{"jny", "𪋿"},
	{"jnyr", "䴴"},
	{"jnyub", "麶"},
	{"jodi", "𡧛"},
	{"jogs", "寯"},
	{"joma", "宿"},
	{"jombc", "顁"},
	{"joni", "麥"},
	{"jose", "寑"},
	{"jp", "它"},
	{"jpa", "耆"},
	{"jpbn", "寧"},
	{"jpbq", "甯"},
	{"jpbt", "寍"},
	{"jpgb", "𡩋"},
	{"jph", "宓"},
	{"jphb", "寗"},
	{"jphi", "蜜"},
	{"jphqu", "耄"},
	{"jpht", "䀄"},
	{"jphu", "密"},
	{"jpko", "寲"},
	{"jpmig", "耋"},
	{"jppr", "耈"},
	{"jq", "车"},
	{"jqk", "実"},
	{"jqmp", "憲"},
	{"jqmr", "害"},
	{"jqomn", "输"},
	{"jqop", "轮"},
	{"jqu", "轧"},
	{"jr", "古"},
	{"jrb", "胡"},
	{"jrbhf", "鶘"},
	{"jrcor", "豁"},
	{"jrhaf", "鴣 鶷 𪃭 𪃾"},
	{"jrhne", "毄"},
	{"jrhr", "宮"},
	{"jrhu", "克"},
	{"jrln", "割"},
	{"jrlr", "官"},
	{"jrmbc", "額"},
	{"jrok", "故"},
	{"jrp", "愙"},
	{"jrrp", "悹"},
	{"jrrye", "嘏"},
	{"jrytj", "辜 𨐒"},
	{"jskr", "宭"},
	{"jsll", "宦 宧"},
	{"jsmh", "寥"},
	{"jsobo", "膥"},
	{"jt", "卉"},
	{"jtak", "寞"},
	{"jtbc", "賁"},
	{"jtbi", "寬"},
	{"jtcc", "賽"},
	{"jtcd", "寨"},
	{"jtcf", "騫 鶱"},
	{"jtcg", "塞"},
	{"jtco", "蹇"},
	{"jtcq", "搴"},
	{"jtcr", "謇"},
	{"jtcu", "寋"},
	{"jtcv", "褰"},
	{"jtcy", "寒"},
	{"jtge", "鼖"},
	{"jtoa", "𣇸"},
	{"jtv", "𡜦"},
	{"ju", "七"},
	{"judi", "尅"},
	{"juhaf", "鵷"},
	{"jujru", "兢"},
	{"juks", "勀"},
	{"juln", "剋 剜"},
	{"jv", "安"},
	{"jvd", "案"},
	{"jvhaf", "鴳 鶈"},
	{"jvmb", "寎"},
	{"jvmbc", "頞"},
	{"jvmd", "寐 寱"},
	{"jvme", "寢"},
	{"jvmr", "寣 寤"},
	{"jvnl", "郪"},
	{"jvp", "悳"},
	{"jwbuu", "覾"},
	{"jwj", "車"},
	{"jwjc", "實"},
	{"jwlb", "寓"},
	{"jwlv", "寰"},
	{"jwp", "恵"},
	{"jybc", "寊"},
	{"jybp", "寵"},
	{"jyfe", "寂"},
	{"jyk", "实"},
	{"jytj", "宰"},
	{"k", "乂 大"},
	{"kad", "橥"},
	{"kam", "疸"},
	{"kamh", "瘍"},
	{"kana", "癎"},
	{"kanb", "癇"},
	{"karrj", "奲"},
	{"kau", "疤"},
	{"kav", "痕"},
	{"kb", "冇 有"},
	{"kbb", "痭"},
	{"kbbr", "瘑"},
	{"kbcv", "癭"},
	{"kbhaf", "鵗"},
	{"kbhne", "殽"},
	{"kbhqu", "毻"},
	{"kbi", "𠕇"},
	{"kbihm", "𢒰"},
	{"kbirm", "戫"},
	{"kbm", "疽"},
	{"kbmr", "痌"},
	{"kbmvn", "瓻"},
	{"kbnl", "郁 郗 郩"},
	{"kbno", "欷"},
	{"kbof", "瘵"},
	{"kbq", "痈"},
	{"kbub", "㿜"},
	{"kbug", "癯"},
	{"kcaf", "尞"},
	{"kcano", "閷"},
	{"kchne", "殺"},
	{"kcipm", "弒"},
	{"kcln", "剎"},
	{"kcwa", "𤺧"},
	{"kd", "东"},
	{"kdbn", "𤷫"},
	{"kdd", "痳"},
	{"kdhe", "疲"},
	{"kdlc", "癩"},
	{"kdln", "瘌"},
	{"ke", "友"},
	{"kefh", "痧"},
	{"keii", "瘙"},
	{"kell", "奫"},
	{"kf", "灰 疢"},
	{"kfb", "痟"},
	{"kfbt", "盔"},
	{"kfcb", "瘠"},
	{"kff", "痰"},
	{"kffs", "癆"},
	{"kfhaf", "鷯"},
	{"kfp", "悐 𢠃"},
	{"kgdi", "痔"},
	{"kgg", "奎"},
	{"kggp", "㥣"},
	{"kghaf", "鵟"},
	{"kgp", "痣"},
	{"kh", "犭"},
	{"khaa", "猖"},
	{"khahm", "猩"},
	{"khahu", "猸"},
	{"khal", "癤"},
	{"kham", "狚"},
	{"khamj", "猂"},
	{"khapp", "猑"},
	{"khapv", "猲"},
	{"khav", "狠"},
	{"khawe", "獌"},
	{"khbbb", "猾"},
	{"khbbr", "猧"},
	{"khbm", "狙"},
	{"khbme", "猨"},
	{"khbmr", "狪"},
	{"khbn", "痸"},
	{"khbou", "牏"},
	{"khbsd", "猙"},
	{"khbtt", "狦"},
	{"khbuc", "狽"},
	{"khbue", "玃"},
	{"khdam", "猹"},
	{"khdc", "癪"},
	{"khdd", "痵"},
	{"khdh", "犲"},
	{"khdlc", "獺"},
	{"khdn", "痢"},
	{"khdu", "痜"},
	{"khdv", "痿"},
	{"khefh", "猀"},
	{"khey", "疼"},
	{"khf", "狄"},
	{"khfbk", "獙"},
	{"khggu", "獟"},
	{"khgr", "狤"},
	{"khgrv", "猿"},
	{"khhbn", "猘"},
	{"khhdn", "猁"},
	{"khher", "狢"},
	{"khhg", "狅"},
	{"khhgf", "獯"},
	{"khhhj", "猈"},
	{"khhj", "痺"},
	{"khhkb", "獢"},
	{"khhl", "奅"},
	{"khhni", "猦"},
	{"khhqm", "狌"},
	{"khhrb", "獅"},
	{"khhrk", "𤠒"},
	{"khhsb", "猏 猵"},
	{"khhsk", "獥"},
	{"khhvo", "狐"},
	{"khhw", "瘤"},
	{"khhxe", "犍"},
	{"khhxf", "獡"},
	{"khhxu", "猊"},
	{"khi", "瘣"},
	{"khiav", "狼"},
	{"khibi", "煄"},
	{"khice", "狻"},
	{"khihu", "狁"},
	{"khij", "狨"},
	{"khik", "𤜥"},
	{"khio", "疺"},
	{"khitc", "獷"},
	{"khiv", "狘"},
	{"khjc", "狖"},
	{"khjdi", "狩"},
	{"khjg", "瘇"},
	{"khjjl", "獑"},
	{"khjka", "猪"},
	{"khjkp", "狫"},
	{"khjmc", "獱"},
	{"khjpn", "獰"},
	{"khjr", "狜"},
	{"khjrb", "猢"},
	{"khkcf", "獠"},
	{"khkkb", "狶"},
	{"khkmr", "猗"},
	{"khkn", "犰"},
	{"khkoo", "狹"},
	{"khl", "狆"},
	{"khlln", "狒"},
	{"khlmo", "狣"},
	{"khmam", "狟"},
	{"khmbb", "獳"},
	{"khmbe", "獶"},
	{"khmce", "獿"},
	{"khmcw", "𤞏"},
	{"khmfb", "獮"},
	{"khmfm", "狉"},
	{"khmg", "狂"},
	{"khmhf", "煍"},
	{"khmj", "犴"},
	{"khmlk", "㹴"},
	{"khmmf", "狋"},
	{"khmto", "獗"},
	{"khmvh", "犽"},
	{"khmwd", "𤢂"},
	{"khnbq", "獬"},
	{"khndf", "煚"},
	{"khndt", "猛"},
	{"khne", "疫"},
	{"khng", "狃"},
	{"khngu", "峱"},
	{"khnhb", "獝"},
	{"khnhd", "猱"},
	{"khnhe", "𤜯"},
	{"khni", "瘋"},
	{"khnkm", "狿"},
	{"khnmb", "獼"},
	{"khnob", "𤟠"},
	{"khoii", "狑"},
	{"khoir", "犌"},
	{"khok", "癓 癥"},
	{"kholk", "𤠣"},
	{"khoma", "獪"},
	{"khomd", "狳"},
	{"khomo", "獫"},
	{"khomr", "猞"},
	{"khon", "犵"},
	{"khonk", "猴"},
	{"khoo", "瘲"},
	{"khor", "𤺥"},
	{"khpa", "痻"},
	{"khppg", "狴"},
	{"khpr", "狗"},
	{"khpru", "狍"},
	{"khqhk", "猰"},
	{"khqhl", "狾"},
	{"khqkd", "犑"},
	{"khqmb", "猜"},
	{"khrb", "狷"},
	{"khrrk", "玁"},
	{"khrye", "猳"},
	{"khs", "痄"},
	{"khsp", "狔"},
	{"khsqf", "獁"},
	{"khsu", "犯"},
	{"khtak", "獏"},
	{"khtav", "獦"},
	{"khtbo", "獴"},
	{"khtco", "獛"},
	{"khtct", "獈"},
	{"khtcw", "猶"},
	{"khtgu", "猐"},
	{"khtjl", "玂"},
	{"khtmc", "獚"},
	{"khtoe", "獲"},
	{"khtrg", "獾"},
	{"khtw", "猫"},
	{"khub", "癟"},
	{"khuc", "㿗"},
	{"khuce", "猣"},
	{"khup", "瘜"},
	{"khvno", "猭"},
	{"khvp", "疧"},
	{"khvvv", "獵"},
	{"khwb", "猬"},
	{"khwd", "猓"},
	{"khwg", "狸"},
	{"khwl", "狎"},
	{"khwlg", "玀"},
	{"khwli", "獨"},
	{"khwlv", "獧"},
	{"khwmv", "猥"},
	{"khxe", "瘦"},
	{"khxo", "瘐"},
	{"khxv", "癙"},
	{"khyck", "狡"},
	{"khye", "瘢"},
	{"khyhn", "犺"},
	{"khymh", "獩"},
	{"khymr", "狺"},
	{"khyoj", "猝"},
	{"khypu", "猇"},
	{"khyrf", "猄"},
	{"khyrk", "獄"},
	{"khyrv", "獽"},
	{"khytg", "獞"},
	{"khytj", "獐"},
	{"khytu", "獍"},
	{"khyy", "犿"},
	{"ki", "太"},
	{"kice", "痠"},
	{"kijb", "痡"},
	{"kiku", "疣"},
	{"kinl", "郄"},
	{"kiog", "雄"},
	{"kismm", "翃"},
	{"kiuh", "痝"},
	{"kiv", "奿"},
	{"kj", "夲"},
	{"kjbc", "瘨"},
	{"kjcc", "痲 癲"},
	{"kjka", "奢 瓡 瘏"},
	{"kjkd", "痚"},
	{"kjrr", "瑔 痯"},
	{"kjt", "奔"},
	{"kk", "爻"},
	{"kkb", "痏 肴"},
	{"kkcf", "療"},
	{"kkhaf", "鷞 鸑"},
	{"kkk", "𡘙"},
	{"kkkk", "爽"},
	{"kklb", "希"},
	{"kklu", "瓾 痷"},
	{"kkn", "痍"},
	{"kkog", "瘞"},
	{"kkop", "瘱"},
	{"kkrb", "瘸"},
	{"kks", "夯"},
	{"kksr", "痂"},
	{"klb", "布"},
	{"klg", "在"},
	{"klll", "夼"},
	{"klln", "疿"},
	{"klmi", "痋"},
	{"klmy", "痱"},
	{"kln", "刈"},
	{"klnd", "存"},
	{"klw", "𡘊"},
	{"klwu", "奄"},
	{"klwv", "瘻"},
	{"km", "左 疘"},
	{"kmaa", "奭"},
	{"kmbw", "癗"},
	{"kmdm", "癧"},
	{"kmfr", "痞"},
	{"kmgg", "癍 㿀"},
	{"kmlm", "瘂"},
	{"kmmf", "奈"},
	{"kmmr", "痦"},
	{"kmms", "夸 疞"},
	{"kmn", "疔"},
	{"kmnf", "𤹐"},
	{"kmnr", "奇 疴"},
	{"kmob", "病"},
	{"kmrt", "痘"},
	{"kmso", "瓿 瘃"},
	{"kmvm", "痙"},
	{"kmwf", "瘭"},
	{"kmym", "症"},
	{"kn", "九 夷 𡯁"},
	{"kna", "旭 旮"},
	{"knbk", "瘓"},
	{"kncr", "癚"},
	{"kndt", "𤷪"},
	{"knfq", "癬"},
	{"knhaf", "鳩"},
	{"kni", "丸 厹"},
	{"knib", "痛"},
	{"knin", "奓 痑"},
	{"knir", "㚚"},
	{"knl", "㽼"},
	{"knlm", "癃"},
	{"knlp", "癮"},
	{"knlr", "痾"},
	{"knmbc", "頄"},
	{"kno", "疚"},
	{"knoe", "癈"},
	{"knsv", "瘬"},
	{"knthu", "馗"},
	{"knymr", "訄"},
	{"knypu", "虓"},
	{"kobuc", "𧶘"},
	{"kog", "痽"},
	{"kogi", "奪"},
	{"kogw", "奮"},
	{"kogx", "𡚒"},
	{"kohaf", "鵊"},
	{"kohh", "疹"},
	{"koir", "瘡"},
	{"kok", "疾"},
	{"kokr", "痴"},
	{"koll", "疥"},
	{"koma", "癐"},
	{"kombc", "頰"},
	{"komg", "痊"},
	{"komn", "瘉"},
	{"komp", "癒"},
	{"kon", "疙"},
	{"konk", "瘊"},
	{"konl", "郟"},
	{"koo", "夾"},
	{"koog", "痤"},
	{"kop", "㤲"},
	{"kowy", "痗"},
	{"kp", "疕"},
	{"kpblb", "帶"},
	{"kpko", "癡"},
	{"kpp", "疪"},
	{"kpr", "痀"},
	{"kpru", "疱"},
	{"kpt", "疶"},
	{"kqhk", "瘈"},
	{"kqhp", "瘛"},
	{"kr", "右"},
	{"krb", "㾓"},
	{"krbuc", "賀"},
	{"krc", "疻"},
	{"krd", "架"},
	{"krhaf", "鴐 鵸"},
	{"krhqu", "毠"},
	{"krje", "攲"},
	{"krln", "剞"},
	{"krmbc", "䫑"},
	{"krmnr", "哿"},
	{"krno", "欹"},
	{"krrj", "癉"},
	{"krru", "癌"},
	{"krsqf", "駕"},
	{"krye", "敧 瘕"},
	{"kryhv", "袈"},
	{"ks", "力"},
	{"ksce", "癜"},
	{"kshaf", "鴮"},
	{"kshvf", "綔"},
	{"kshvo", "瓠"},
	{"ksj", "耷"},
	{"ksksb", "脅"},
	{"kskss", "劦"},
	{"ksksv", "姭"},
	{"ksln", "刳"},
	{"ksmb", "瘺"},
	{"ksmh", "瘳"},
	{"ksmi", "套"},
	{"kspru", "匏"},
	{"ksql", "𤶸"},
	{"ksr", "加"},
	{"ksrj", "癖"},
	{"ksrr", "奩"},
	{"kswp", "勰"},
	{"ktak", "瘼"},
	{"ktbc", "痶"},
	{"ktjr", "瘔"},
	{"ktlm", "瘽"},
	{"ktm", "疳"},
	{"ktmc", "癀"},
	{"ktog", "癱"},
	{"ktor", "瘩"},
	{"ktov", "癢"},
	{"ktq", "痒 羍"},
	{"ktqm", "瘥"},
	{"ktuo", "瘚"},
	{"ktwb", "癘"},
	{"ktwv", "癑"},
	{"ku", "尢 疝"},
	{"kubbb", "尳"},
	{"kuhaf", "鵪"},
	{"kuhjg", "尰"},
	{"kumg", "尪"},
	{"kuoll", "尬"},
	{"kupi", "尥"},
	{"kusit", "尷"},
	{"kveq", "𤸻"},
	{"kvfb", "癵"},
	{"kvfq", "癴"},
	{"kvug", "癰"},
	{"kwgg", "癦"},
	{"kwgt", "𤼎"},
	{"kwjr", "痼"},
	{"kwle", "瘝"},
	{"kwlv", "癏"},
	{"kwml", "痹"},
	{"kwot", "瘟"},
	{"kwr", "痐"},
	{"kwvf", "瘰"},
	{"kwwf", "癳"},
	{"kyg", "疰"},
	{"kymp", "疵"},
	{"kyoj", "瘁"},
	{"kypm", "瘧"},
	{"kyr", "痁"},
	{"kysk", "瘯"},
	{"kysy", "瘀"},
	{"kyta", "瘖"},
	{"kytj", "瘴"},
	{"kytp", "癔"},
	{"kyvi", "痃"},
	{"kyvo", "痎"},
	{"kyx", "癠"},
	{"l", "中"},
	{"la", "甴 衵"},
	{"laa", "裮"},
	{"laitb", "𢅺"},
	{"lam", "袒"},
	{"lamo", "褆"},
	{"lana", "襇"},
	{"lanb", "襉"},
	{"lanw", "襴"},
	{"laph", "裼"},
	{"lapv", "褐"},
	{"lasm", "褟"},
	{"late", "襮"},
	{"lav", "裉"},
	{"lb", "巾"},
	{"lbabu", "帽"},
	{"lbafu", "幌"},
	{"lbahu", "𢃼"},
	{"lbau", "帊"},
	{"lbawe", "幔"},
	{"lbayf", "幜"},
	{"lbbac", "幎"},
	{"lbbhx", "幍"},
	{"lbcru", "帨"},
	{"lbcsh", "帉"},
	{"lbdhe", "帔"},
	{"lbdmq", "幃"},
	{"lbfb", "帩"},
	{"lbgni", "幬"},
	{"lbgr", "裯"},
	{"lbha", "帕"},
	{"lbhal", "幯"},
	{"lbhdw", "幡"},
	{"lbhn", "㠶"},
	{"lbhni", "帆"},
	{"lbhqo", "帙"},
	{"lbigi", "幮"},
	{"lbii", "帴"},
	{"lbiih", "幓"},
	{"lbikk", "帗"},
	{"lbjj", "褌"},
	{"lbjka", "帾"},
	{"lbjmo", "幏"},
	{"lbjqp", "幰"},
	{"lbjtc", "幩"},
	{"lbk", "央"},
	{"lblbu", "帎"},
	{"lbm", "袓"},
	{"lbmbc", "幁 幊"},
	{"lbme", "褑"},
	{"lbmn", "帄"},
	{"lbmrw", "幅"},
	{"lbncr", "幨"},
	{"lbnl", "鄁"},
	{"lbog", "帷"},
	{"lbomr", "帢"},
	{"lbotf", "幠"},
	{"lbqmc", "幘"},
	{"lbqo", "㠸"},
	{"lbrrd", "幧"},
	{"lbrrj", "幝"},
	{"lbshr", "𢁾"},
	{"lbsmg", "幄"},
	{"lbsmh", "𢄪"},
	{"lbsmv", "帳"},
	{"lbstt", "幈"},
	{"lbt", "盅"},
	{"lbtak", "幙"},
	{"lbtbo", "幪"},
	{"lbtco", "幞"},
	{"lbtt", "帡"},
	{"lbtwi", "幭"},
	{"lbu", "冘"},
	{"lbv", "农"},
	{"lbwg", "𢃇"},
	{"lbwim", "幗"},
	{"lby", "袇"},
	{"lbybc", "幀"},
	{"lbyhc", "𢅳"},
	{"lbyia", "幟"},
	{"lbyr", "帖"},
	{"lbytg", "幢"},
	{"lbytj", "幛"},
	{"lcnl", "鄪"},
	{"lcor", "裕"},
	{"lcru", "裞"},
	{"lcsh", "衯"},
	{"ldbb", "襋"},
	{"lddf", "襟"},
	{"lddq", "襻"},
	{"ldhe", "被"},
	{"ldj", "袜"},
	{"ldk", "袂"},
	{"ldmq", "褘"},
	{"le", "隶"},
	{"leed", "褬"},
	{"leee", "裰"},
	{"lei", "衩"},
	{"lfbk", "襒"},
	{"lfbw", "襠"},
	{"lff", "裧"},
	{"lfq", "袢"},
	{"lfqu", "裷"},
	{"lga", "書"},
	{"lgam", "晝"},
	{"lgb", "袡"},
	{"lgce", "裬"},
	{"lgg", "袿"},
	{"lggu", "襓"},
	{"lggy", "褂"},
	{"lgi", "袪"},
	{"lgr", "袺"},
	{"lgrc", "襭"},
	{"lgrv", "褤"},
	{"lgwc", "襩"},
	{"lgwm", "畫"},
	{"lha", "袙"},
	{"lhbk", "襖"},
	{"lhbt", "裇"},
	{"lhcj", "襷"},
	{"lheq", "袶"},
	{"lher", "袼"},
	{"lhg", "衽"},
	{"lhhh", "衫"},
	{"lhhj", "裨"},
	{"lhjd", "袾"},
	{"lhk", "袄"},
	{"lhmo", "长"},
	{"lhoo", "褷"},
	{"lhpm", "袛"},
	{"lhqo", "袟"},
	{"lhsb", "褊"},
	{"lhul", "襣"},
	{"lhvp", "衹"},
	{"lhws", "𧞄"},
	{"lhyu", "褫"},
	{"lia", "蚎"},
	{"liabu", "蝐"},
	{"liahu", "蝞"},
	{"liail", "蝍"},
	{"liamh", "蝪"},
	{"liamo", "蝭"},
	{"liana", "𧒄"},
	{"liaph", "蜴"},
	{"liapv", "蝎"},
	{"liau", "蚆"},
	{"liav", "蛝"},
	{"liavo", "蠍"},
	{"liawe", "蟃"},
	{"libac", "螟"},
	{"libbb", "螖"},
	{"libbr", "蝸"},
	{"libcv", "蠳"},
	{"libdi", "蛶"},
	{"libgr", "蜩"},
	{"libm", "蛆"},
	{"libme", "蝯"},
	{"libnd", "蜉"},
	{"libp", "褦"},
	{"libue", "蠼"},
	{"libug", "蠷"},
	{"libuu", "蜆"},
	{"libvk", "螇"},
	{"liby", "蚒"},
	{"lici", "蚣"},
	{"licim", "螉"},
	{"lick", "蚥"},
	{"licru", "蛻"},
	{"licsh", "蚡"},
	{"lid", "蚞"},
	{"lidci", "蜙"},
	{"lidhe", "蚾"},
	{"lidhl", "蜥"},
	{"lidk", "蚗"},
	{"lidw", "蝀"},
	{"lieee", "蝃"},
	{"liesd", "蟝"},
	{"lifb", "蛸"},
	{"lifbg", "螳"},
	{"lifbw", "蟷"},
	{"liffd", "蠑"},
	{"liffs", "蟧"},
	{"lifqu", "蜷"},
	{"ligb", "蚺"},
	{"ligg", "蛙"},
	{"liggu", "蟯"},
	{"ligr", "蛣"},
	{"ligrr", "蟢"},
	{"ligth", "蟛"},
	{"lihad", "蟂"},
	{"lihag", "蝗"},
	{"lihdj", "蝌"},
	{"lihdn", "蜊"},
	{"lihdp", "蟋"},
	{"lihdv", "蜲"},
	{"lihdw", "蟠"},
	{"lihej", "蜂"},
	{"lihhj", "蜱"},
	{"lihi", "螝"},
	{"lihjd", "蛛"},
	{"lihje", "𧎚"},
	{"lihjg", "蝩"},
	{"lihjr", "蛞"},
	{"lihkb", "蟜"},
	{"lihlb", "蝺"},
	{"lihml", "蚚"},
	{"lihmy", "蚸"},
	{"lihn", "虮"},
	{"lihnd", "𧊶"},
	{"lihp", "虴"},
	{"lihpm", "蚳"},
	{"lihqi", "蛾"},
	{"lihqo", "蛈"},
	{"lihqu", "蚝"},
	{"lihrb", "螄"},
	{"lihrf", "螐"},
	{"lihs", "蚱"},
	{"lihsb", "蝙"},
	{"lihsk", "蜧"},
	{"lihsu", "蚅"},
	{"lihuk", "螑"},
	{"lihup", "螅"},
	{"lihvo", "蛌"},
	{"lihvp", "蚔"},
	{"lihwp", "蟌"},
	{"lihxe", "螋"},
	{"lihxu", "蜺"},
	{"lihyu", "螔"},
	{"liiav", "蜋"},
	{"liih", "襂"},
	{"liihf", "䗩"},
	{"liihq", "蛑"},
	{"liihv", "蝛"},
	{"liiil", "螂"},
	{"liijb", "蜅"},
	{"liije", "蛷"},
	{"liikf", "蟡"},
	{"liikk", "蛂"},
	{"liiku", "蚘"},
	{"liilr", "螗"},
	{"liioc", "蠀"},
	{"liirm", "蜮"},
	{"liitc", "蠊"},
	{"liitf", "蟅"},
	{"liitu", "蝷"},
	{"liiuh", "蛖"},
	{"liixp", "螰"},
	{"lijb", "補"},
	{"lijbj", "蝻"},
	{"lijcg", "螲"},
	{"lije", "蚑"},
	{"lijig", "蠘"},
	{"lijip", "蟪"},
	{"lijj", "褲"},
	{"lijjl", "螹"},
	{"lijka", "蝫"},
	{"lijkp", "蛯"},
	{"lijlo", "蜨"},
	{"lijmc", "螾 蠙"},
	{"lijmm", "蝖"},
	{"lijnu", "蜿"},
	{"lijp", "蛇"},
	{"lijqp", "䘆"},
	{"lijqr", "螛"},
	{"lijr", "蛄"},
	{"lijrb", "蝴"},
	{"lijtc", "蟦"},
	{"likcf", "蟟"},
	{"likgg", "蝰"},
	{"likk", "袚"},
	{"likn", "蛦"},
	{"likok", "螏"},
	{"likoo", "蛺"},
	{"likpb", "螮"},
	{"liksr", "𧊀"},
	{"lilii", "蟲"},
	{"lilit", "蠱"},
	{"lille", "蝂"},
	{"lilmq", "蝆"},
	{"lilw", "蚰"},
	{"lilwl", "𧊋"},
	{"lilwv", "螻"},
	{"lilxl", "蜵"},
	{"lim", "虹"},
	{"lima", "蛨"},
	{"limbb", "蠕"},
	{"limbc", "蝢"},
	{"limbk", "蝡"},
	{"limfj", "蚲"},
	{"limfm", "蚽"},
	{"limhf", "螈"},
	{"limig", "蛭"},
	{"limj", "虷"},
	{"limmi", "蟵"},
	{"limmu", "蚖"},
	{"limmv", "蜄"},
	{"limn", "虰"},
	{"limnn", "蛚"},
	{"limnr", "蚵"},
	{"limob", "蛃"},
	{"limrw", "蝠"},
	{"limtb", "蠣"},
	{"limvh", "蚜"},
	{"limvm", "蛵"},
	{"limwf", "螵"},
	{"limwj", "蟫"},
	{"limwl", "蝒"},
	{"limy", "虾"},
	{"linao", "蟓"},
	{"linbc", "蝜"},
	{"linbq", "蠏"},
	{"lincr", "蟾"},
	{"lindt", "蜢"},
	{"linhb", "𧑐"},
	{"linhd", "蝚"},
	{"linhx", "蜭"},
	{"linib", "蛹"},
	{"linkg", "蜓"},
	{"linkm", "蜒"},
	{"linl", "蚓"},
	{"linmu", "蛫"},
	{"linob", "蝑"},
	{"linue", "蜬"},
	{"lioae", "蝮"},
	{"liob", "蚋"},
	{"liodi", "蚹"},
	{"liog", "蜼"},
	{"liogf", "蟭"},
	{"lioii", "蛉"},
	{"lioin", "蚙"},
	{"lioir", "螥"},
	{"liokr", "蜘"},
	{"liold", "螩"},
	{"lioll", "蚧"},
	{"liom", "蚯"},
	{"liomb", "蜦"},
	{"liomd", "蜍"},
	{"liomg", "𧊲"},
	{"liomn", "蝓"},
	{"liomr", "蛤"},
	{"lion", "虼"},
	{"liono", "蜁"},
	{"liopc", "蟘"},
	{"liosk", "蛜"},
	{"lioyb", "蠄"},
	{"lipi", "虳"},
	{"lipim", "蚐"},
	{"lipou", "蜪"},
	{"lipp", "蚍"},
	{"lippa", "蝔"},
	{"lippg", "蜌"},
	{"lipr", "蚼"},
	{"liptd", "蝶"},
	{"liqj", "蚌"},
	{"liqka", "蝽"},
	{"liqkd", "螓"},
	{"liqmb", "蜻"},
	{"liqmy", "蝳"},
	{"liqo", "蚨"},
	{"lirb", "蜎"},
	{"lirks", "𧊅"},
	{"lirrj", "蟬"},
	{"liruc", "蟤"},
	{"lirvk", "蜈"},
	{"lirxu", "蠅"},
	{"lirye", "蝦"},
	{"lisav", "蝘"},
	{"lisem", "蠮"},
	{"lish", "虭"},
	{"lishr", "蛁"},
	{"lishu", "𧋦"},
	{"lisjr", "蜛"},
	{"lismg", "蠗"},
	{"lismh", "蟉"},
	{"lismi", "蟳"},
	{"liso", "蚇"},
	{"lisp", "蚭"},
	{"lisqf", "螞"},
	{"lisrg", "蟶"},
	{"liss", "蚷"},
	{"lisyi", "蠾"},
	{"lita", "蜡"},
	{"litak", "蟆"},
	{"litb", "褯"},
	{"litbo", "蠓"},
	{"litcl", "蟖"},
	{"litcw", "蝤"},
	{"litgi", "蟻"},
	{"litgr", "蟮"},
	{"litgu", "蜣"},
	{"litit", "蟒"},
	{"litlb", "蟎"},
	{"litlk", "蝧"},
	{"litlm", "螼"},
	{"litlx", "蠨"},
	{"litm", "蚶"},
	{"litmc", "蜞 蟥"},
	{"litoe", "蠖"},
	{"litpd", "蠂"},
	{"litq", "蛘"},
	{"litrg", "蠸"},
	{"litt", "蛢"},
	{"litvi", "螆"},
	{"litw", "蛐"},
	{"litwa", "螬"},
	{"litwi", "蠛 𧒆"},
	{"liu", "虬"},
	{"liuce", "蝬"},
	{"liumt", "螘"},
	{"liuob", "蠵"},
	{"livfi", "𧖣"},
	{"livii", "蟣"},
	{"livis", "蚴"},
	{"livl", "虯"},
	{"livno", "蝝"},
	{"livvv", "蠟"},
	{"liwb", "蝟"},
	{"liwd", "蜾"},
	{"liwgf", "蟔"},
	{"liwhd", "蜠"},
	{"liwim", "蟈"},
	{"liwli", "蠋"},
	{"liwlj", "蠌"},
	{"liwlv", "蠉"},
	{"liwot", "蝹"},
	{"liwr", "蛔"},
	{"liwvf", "螺"},
	{"liwww", "蠝"},
	{"liy", "虲"},
	{"liyav", "螁"},
	{"liybp", "蠬"},
	{"liybs", "螃"},
	{"liycb", "螪"},
	{"liyck", "蛟"},
	{"liyg", "蛀"},
	{"liyhn", "蚢"},
	{"liyia", "蟙"},
	{"liyij", "蟀"},
	{"liyj", "蚪"},
	{"liyk", "蚊"},
	{"liypt", "蠦"},
	{"liyr", "蛅"},
	{"liyra", "蠩"},
	{"liyrd", "蜳"},
	{"liyrn", "蝏"},
	{"liyro", "蠔"},
	{"liyru", "𧐢"},
	{"liyrv", "蠰"},
	{"liysd", "蝣"},
	{"liyso", "蜨"},
	{"liytj", "蟑"},
	{"liyub", "螭"},
	{"liyv", "虻"},
	{"liyvi", "蚿"},
	{"liywm", "蟺"},
	{"liyx", "蠐"},
	{"lj", "𦘒"},
	{"ljc", "袕"},
	{"ljcr", "褣"},
	{"ljd", "𧙕"},
	{"lje", "衼"},
	{"ljic", "襶"},
	{"ljka", "褚"},
	{"ljp", "袉"},
	{"ljr", "𧙖"},
	{"lk", "史"},
	{"lkbt", "盎"},
	{"lkhaf", "鴦"},
	{"lki", "𧘹"},
	{"lkld", "袸"},
	{"lklu", "裺"},
	{"lkm", "袏"},
	{"lkma", "襫"},
	{"lkmr", "裿"},
	{"lkms", "袴"},
	{"lkoo", "裌"},
	{"lkpb", "𧜵"},
	{"lkr", "𧙗"},
	{"ll", "串 衶"},
	{"llamh", "暢"},
	{"llaph", "𣈱"},
	{"llbu", "衴"},
	{"llbuu", "覑"},
	{"lldwf", "朄"},
	{"llfq", "牉"},
	{"llgwc", "牘"},
	{"llhe", "版"},
	{"llhhj", "牌"},
	{"llhjx", "牐"},
	{"llhsb", "牖"},
	{"llhwp", "牕"},
	{"llii", "牋"},
	{"llilb", "牗"},
	{"lll", "川"},
	{"lllc", "順"},
	{"llml", "片"},
	{"llmy", "裶"},
	{"lln", "弗"},
	{"llomn", "煃"},
	{"llp", "患"},
	{"llpb", "褙"},
	{"llptd", "牒"},
	{"llshr", "牊"},
	{"llw", "袖"},
	{"llwv", "褸"},
	{"llww", "丳"},
	{"llxl", "裫"},
	{"llybs", "牓"},
	{"llytv", "𤗈"},
	{"lm", "丄"},
	{"lma", "袹"},
	{"lmbb", "襦"},
	{"lmbuc", "貴"},
	{"lmfbc", "賮"},
	{"lmfbt", "盡"},
	{"lmi", "虫"},
	{"lmlb", "裲"},
	{"lmln", "劃"},
	{"lmmm", "韭"},
	{"lmmp", "襹"},
	{"lmmv", "裖"},
	{"lmp", "北"},
	{"lmpnl", "邶"},
	{"lmrt", "裋"},
	{"lmrw", "褔"},
	{"lmuo", "兆"},
	{"lmuoc", "頫"},
	{"lmuou", "覜"},
	{"lmvi", "褥"},
	{"lmwf", "褾"},
	{"lmwu", "褼"},
	{"lmyq", "羋"},
	{"lmyyn", "剕"},
	{"lmyyy", "非"},
	{"ln", "刂 鬥"},
	{"lnao", "襐"},
	{"lnbuc", "費"},
	{"lncr", "襜"},
	{"lnhe", "衱"},
	{"lnhs", "𧘌"},
	{"lnhxu", "鬩"},
	{"lnib", "𧚔"},
	{"lnii", "襁"},
	{"lnln", "刜"},
	{"lnmjk", "鬫"},
	{"lnmti", "鬪"},
	{"lnnau", "艴"},
	{"lnnxu", "鬮"},
	{"lnoe", "襏"},
	{"lnrml", "鬭"},
	{"lntc", "鬨"},
	{"lnylb", "鬧"},
	{"loae", "複"},
	{"lob", "衲"},
	{"lof", "袮"},
	{"logd", "襍"},
	{"logte", "鼗"},
	{"lohg", "袵"},
	{"lohh", "袗"},
	{"loik", "袱"},
	{"loim", "襳"},
	{"loin", "衿"},
	{"loma", "襘"},
	{"lomn", "褕"},
	{"lomo", "襝"},
	{"lomr", "袷"},
	{"lopd", "袘"},
	{"lord", "褓"},
	{"loto", "襥"},
	{"lp", "忠"},
	{"lpb", "背"},
	{"lpd", "衪"},
	{"lph", "袐"},
	{"lphu", "兠"},
	{"lpim", "袀"},
	{"lpq", "𠤖"},
	{"lpr", "袧"},
	{"lpru", "袍"},
	{"lptd", "褋"},
	{"lpwtc", "冀"},
	{"lq", "聿"},
	{"lqhk", "褉"},
	{"lqmat", "衋"},
	{"lqmv", "裱"},
	{"lqo", "衭"},
	{"lrb", "裐"},
	{"lrhg", "裎"},
	{"lrrd", "襙"},
	{"lrrj", "襌"},
	{"lsav", "褗"},
	{"lseg", "𧜶"},
	{"lsh", "初"},
	{"lshr", "袑"},
	{"lsit", "襤"},
	{"lsjr", "裾"},
	{"lskr", "裙"},
	{"lsma", "褶"},
	{"lsmi", "襑"},
	{"ltbi", "襺"},
	{"ltco", "襆"},
	{"ltgi", "襼"},
	{"ltlb", "襔"},
	{"ltmc", "褀"},
	{"ltor", "褡"},
	{"ltwi", "襪"},
	{"ltwv", "襛"},
	{"lu", "儿"},
	{"lue", "沊"},
	{"luhaf", "鴆"},
	{"lumbc", "䪴"},
	{"lunl", "邥"},
	{"lvbu", "胤"},
	{"lvhaf", "鷜"},
	{"lvhqu", "氀"},
	{"lvii", "𧝞"},
	{"lvis", "袎"},
	{"lvno", "褖"},
	{"lvok", "數"},
	{"lvr", "袽"},
	{"lw", "由"},
	{"lwb", "冑 胄"},
	{"lwd", "裍 裸"},
	{"lwg", "裡"},
	{"lwk", "裀"},
	{"lwl", "申"},
	{"lwlg", "𧟌"},
	{"lwli", "襡"},
	{"lwlj", "襗"},
	{"lwlm", "𧝁"},
	{"lwlp", "襬"},
	{"lwlv", "婁"},
	{"lwmbc", "頔"},
	{"lwmvs", "甹"},
	{"lwnl", "邮"},
	{"lwot", "褞"},
	{"lwp", "曳"},
	{"lwu", "电"},
	{"lx", "肅"},
	{"lxh", "𠂔"},
	{"lxhaf", "鷫"},
	{"lxno", "歗"},
	{"ly", "补"},
	{"lyav", "褪"},
	{"lybb", "褅"},
	{"lybp", "襱"},
	{"lybu", "𦚯"},
	{"lycv", "䙛"},
	{"lyd", "棐"},
	{"lydu", "襯"},
	{"lygq", "𧞅"},
	{"lyhq", "㹃"},
	{"lyhqu", "靟"},
	{"lyiu", "裗"},
	{"lyjj", "褳"},
	{"lyjwj", "輩"},
	{"lyk", "奜"},
	{"lylm", "𧘲"},
	{"lylmi", "蜚"},
	{"lymgi", "㻗"},
	{"lynd", "𩇫"},
	{"lyoiv", "餥"},
	{"lyp", "悲"},
	{"lysmm", "翡"},
	{"lyto", "襚"},
	{"lyub", "褵"},
	{"lyv", "婓"},
	{"lyvi", "袨"},
	{"lywm", "襢"},
	{"lyyhv", "裴"},
	{"lyyk", "斐"},
	{"m", "一"},
	{"ma", "百"},
	{"mabk", "厭"},
	{"mad", "櫫"},
	{"mahl", "㪽"},
	{"mahr", "厬"},
	{"mai", "戩 戬"},
	{"maiu", "厩"},
	{"maln", "㔆"},
	{"mam", "亘"},
	{"mama", "皕"},
	{"mamaa", "𤾩"},
	{"mamgi", "𤧥"},
	{"mamr", "碧"},
	{"mand", "厚"},
	{"manl", "鄑"},
	{"mbawe", "𩅍"},
	{"mbbhg", "霾"},
	{"mbbhv", "霢"},
	{"mbbie", "霡"},
	{"mbbmo", "霥"},
	{"mbbuu", "覼 𧢝"},
	{"mbcc", "𠫍"},
	{"mbchj", "𩆨"},
	{"mbcn", "厠"},
	{"mbcsh", "雰"},
	{"mbdbu", "霜"},
	{"mbdci", "𩃭"},
	{"mbdd", "霖"},
	{"mbddh", "霦"},
	{"mbdi", "耐"},
	{"mbebg", "霪"},
	{"mbebr", "霘"},
	{"mbed", "霂"},
	{"mbejb", "霈"},
	{"mbelu", "霃"},
	{"mbely", "𩄼"},
	{"mbemj", "䨵"},
	{"mbemm", "靋"},
	{"mbeni", "霐"},
	{"mbetc", "霟"},
	{"mbetv", "霮"},
	{"mbeyr", "霑"},
	{"mbeys", "霶"},
	{"mbfb", "霄"},
	{"mbg", "壐"},
	{"mbhaf", "鴯 鷊 鸍"},
	{"mbhdf", "𩄍"},
	{"mbhey", "𩂓"},
	{"mbhfd", "雽"},
	{"mbhhh", "耏"},
	{"mbhhw", "霤"},
	{"mbhml", "𩂋"},
	{"mbhok", "霺"},
	{"mbhxu", "霓"},
	{"mbijb", "鬴"},
	{"mbimo", "䨏"},
	{"mbjlv", "霋"},
	{"mbk", "耎"},
	{"mbkmr", "𩃤"},
	{"mbks", "勵"},
	{"mblbk", "雵"},
	{"mbll", "而"},
	{"mblmi", "融"},
	{"mblmo", "雿"},
	{"mblmy", "霏"},
	{"mbm", "亙"},
	{"mbmbc", "顬"},
	{"mbmbl", "需"},
	{"mbmdm", "靂"},
	{"mbmgi", "璽"},
	{"mbmin", "𩃬"},
	{"mbmmi", "雲"},
	{"mbmms", "雩"},
	{"mbmmv", "震"},
	{"mbnhs", "霧"},
	{"mbnhu", "霿"},
	{"mbnib", "霱"},
	{"mbnih", "雺"},
	{"mbnkg", "霆"},
	{"mbnkm", "𩃀"},
	{"mbnl", "邴"},
	{"mbnlq", "𩄐"},
	{"mbnnn", "霛"},
	{"mbnoo", "䬠"},
	{"mbnot", "霯"},
	{"mbo", "页"},
	{"mboah", "鬺"},
	{"mbod", "𩂯"},
	{"mbog", "霍"},
	{"mbogg", "靃"},
	{"mbohb", "𩃥"},
	{"mboii", "零"},
	{"mbowy", "霉"},
	{"mbp", "恧 𩂈"},
	{"mbphe", "憂"},
	{"mbpru", "雹"},
	{"mbqmb", "䨝"},
	{"mbrbc", "霣"},
	{"mbrji", "霵"},
	{"mbrmr", "露"},
	{"mbrrg", "𤫊"},
	{"mbrri", "𩆜"},
	{"mbrrm", "靈"},
	{"mbrrr", "霝"},
	{"mbrrv", "孁"},
	{"mbrye", "霞"},
	{"mbsfi", "霨"},
	{"mbsm", "雪"},
	{"mbsma", "霫"},
	{"mbsmm", "翮"},
	{"mbsmr", "𠻸"},
	{"mbsrj", "霹"},
	{"mbtbk", "霰"},
	{"mbtbo", "靀"},
	{"mbtcl", "𩅰"},
	{"mbtjb", "霸"},
	{"mbtlk", "霙"},
	{"mbtm", "雸"},
	{"mbuc", "貢 頁"},
	{"mbuce", "鬷"},
	{"mbv", "耍"},
	{"mbvr", "𩂰"},
	{"mbw", "雷"},
	{"mbwtc", "霬"},
	{"mbwu", "電"},
	{"mbwww", "靁"},
	{"mbybp", "靇"},
	{"mbydl", "霩"},
	{"mbyhj", "𩅛"},
	{"mbyhs", "雱"},
	{"mbyhv", "𩂱"},
	{"mbyk", "雯"},
	{"mbylw", "䨤"},
	{"mbymr", "霅"},
	{"mbyrv", "靄"},
	{"mbyt", "雴"},
	{"mbytn", "霠"},
	{"mbytv", "霎"},
	{"mbyx", "霽"},
	{"mca", "晋"},
	{"mche", "夒"},
	{"mchq", "㹕"},
	{"mcml", "顨"},
	{"mcp", "慐 𢥧 𢦀"},
	{"mcw", "西"},
	{"mcwm", "酉"},
	{"md", "于"},
	{"mda", "曆"},
	{"mdbt", "盂"},
	{"mdbu", "厢"},
	{"mddo", "𠪴"},
	{"mdhaf", "鷅"},
	{"mdm", "五"},
	{"mdmgi", "㻺"},
	{"mdmr", "磿"},
	{"mdnl", "邘"},
	{"mdp", "𢟍"},
	{"mdylm", "歴 歷"},
	{"me", "汞"},
	{"mec", "𨫣"},
	{"mem", "亟"},
	{"menl", "鄾"},
	{"mer", "唘"},
	{"mf", "不 𣎴"},
	{"mfbk", "厰 爾"},
	{"mfbq", "甭"},
	{"mfbt", "盃"},
	{"mfbuc", "贗"},
	{"mfbuu", "覔 覝"},
	{"mfhaf", "鴀"},
	{"mfhhh", "彯"},
	{"mfhni", "飄"},
	{"mfhvo", "瓢"},
	{"mfj", "平"},
	{"mfjbm", "𠁆"},
	{"mfk", "奀"},
	{"mfks", "勡"},
	{"mfln", "剽"},
	{"mfm", "丕"},
	{"mfmbc", "願 顠"},
	{"mfmmf", "祘"},
	{"mfmym", "歪"},
	{"mfnl", "鄢"},
	{"mfomi", "𠀾"},
	{"mfp", "愿"},
	{"mfr", "否"},
	{"mfrbc", "𧶏"},
	{"mfsmm", "翲"},
	{"mfvnd", "孬"},
	{"mfyiu", "𥜆"},
	{"mg", "王 𤣩"},
	{"mgaa", "琩"},
	{"mgabt", "瑥"},
	{"mgabu", "瑁"},
	{"mgahm", "瑋"},
	{"mgahu", "瑊"},
	{"mgamh", "獂"},
	{"mgamo", "瑅"},
	{"mgana", "𤩎"},
	{"mganw", "瓓"},
	{"mgaph", "㻛"},
	{"mgapp", "琨"},
	{"mgau", "琶"},
	{"mgav", "珢"},
	{"mgawe", "㻴"},
	{"mgayf", "璟"},
	{"mgayk", "琝"},
	{"mgb", "再 玥"},
	{"mgbb", "㻚"},
	{"mgbbe", "璦"},
	{"mgbbq", "𤩥"},
	{"mgbcd", "琛"},
	{"mgbcv", "瓔"},
	{"mgbgr", "琱"},
	{"mgbhn", "𤤌"},
	{"mgbhx", "瑫"},
	{"mgbjj", "琿"},
	{"mgbm", "珇"},
	{"mgbme", "猺"},
	{"mgbnd", "琈"},
	{"mgbou", "瑤 瑶"},
	{"mgbsd", "琤"},
	{"mgbt", "珊"},
	{"mgbuc", "珼"},
	{"mgbuu", "現"},
	{"mgby", "玬"},
	{"mgc", "𨨖"},
	{"mgci", "玜"},
	{"mgcnh", "珶"},
	{"mgcsh", "玢"},
	{"mgcwa", "璔"},
	{"mgd", "琹"},
	{"mgdd", "琳"},
	{"mgddo", "璴"},
	{"mgdhe", "玻"},
	{"mgdk", "玦"},
	{"mgdmq", "猼"},
	{"mgdoo", "琜"},
	{"mgdwf", "瑓"},
	{"mgea", "𤦊"},
	{"mgegi", "琺"},
	{"mgeii", "瑵"},
	{"mgemn", "𤤾"},
	{"mgfb", "琑"},
	{"mgfbb", "瑺"},
	{"mgfbc", "瑣"},
	{"mgfbw", "璫"},
	{"mgfdq", "璘"},
	{"mgff", "琰"},
	{"mgffd", "𤪤"},
	{"mgffg", "㼆"},
	{"mgffs", "𤩂"},
	{"mgfmu", "珖"},
	{"mgfqu", "𤦔"},
	{"mgg", "厓 𤣰"},
	{"mggb", "珃"},
	{"mggce", "𤦫"},
	{"mggg", "珪"},
	{"mgggu", "𤩊"},
	{"mggi", "珐"},
	{"mggnf", "瓙"},
	{"mggni", "璹"},
	{"mggp", "𤥴"},
	{"mggsk", "璈"},
	{"mgha", "珀"},
	{"mghae", "瑑"},
	{"mghaf", "鳿 鵄 𪆒"},
	{"mghag", "瑝"},
	{"mghbr", "珦"},
	{"mghby", "珘"},
	{"mghdd", "㻑"},
	{"mghdf", "𤧐"},
	{"mghdg", "𤩏"},
	{"mghdl", "𤦋"},
	{"mghdn", "琍"},
	{"mghds", "琇"},
	{"mghdw", "璠"},
	{"mghej", "琒"},
	{"mgher", "珞"},
	{"mghgr", "𤥢"},
	{"mghgu", "珗"},
	{"mghhe", "瓈"},
	{"mghhj", "琕"},
	{"mghhl", "珋"},
	{"mghhw", "瑠"},
	{"mghi", "瑰"},
	{"mghj", "𤣳"},
	{"mghjd", "珠"},
	{"mghje", "瑖"},
	{"mghjr", "𤪔"},
	{"mghkb", "𤩝"},
	{"mghlb", "獀"},
	{"mghnb", "珮"},
	{"mghnf", "𤪧"},
	{"mghoh", "𤨤 𤪱"},
	{"mghon", "珩 𤦷"},
	{"mghoo", "瑽"},
	{"mghqi", "珴"},
	{"mghuc", "瓚"},
	{"mghwp", "璁"},
	{"mghxc", "璵"},
	{"mghxu", "𤦤"},
	{"mgi", "玉 玊 㺨"},
	{"mgiav", "琅"},
	{"mgice", "㻐"},
	{"mgihr", "犎"},
	{"mgihs", "珹 臹"},
	{"mgihu", "玧"},
	{"mgii", "琖"},
	{"mgiib", "𤨡"},
	{"mgiil", "瑯"},
	{"mgije", "球"},
	{"mgilg", "班"},
	{"mgilr", "瑭"},
	{"mgine", "𤤯"},
	{"mging", "𤧻"},
	{"mgir", "珆"},
	{"mgirm", "琙"},
	{"mgisb", "㻞"},
	{"mgisk", "璷"},
	{"mgjbc", "瑱"},
	{"mgjbm", "𤦌"},
	{"mgjch", "獊"},
	{"mgjcr", "瑢"},
	{"mgjhw", "𤪺"},
	{"mgjii", "瑼"},
	{"mgjip", "璤"},
	{"mgjkp", "珯"},
	{"mgjkr", "𤨥"},
	{"mgjmc", "璌 璸"},
	{"mgjmf", "琮"},
	{"mgjmm", "犐"},
	{"mgjmo", "琔 𤨎"},
	{"mgjmu", "𤩷"},
	{"mgjnu", "琬"},
	{"mgjpn", "𤪥"},
	{"mgjrb", "瑚"},
	{"mgjrr", "琯"},
	{"mgjru", "𤥣"},
	{"mgjv", "𤥃"},
	{"mgjyu", "𤪓"},
	{"mgkb", "珛"},
	{"mgkcf", "璙"},
	{"mgkhr", "𤨦"},
	{"mgkkb", "琋"},
	{"mgkld", "珔 臶"},
	{"mgkmr", "琦"},
	{"mgkoo", "𤥵"},
	{"mgks", "玏"},
	{"mgksr", "珈"},
	{"mgkss", "珕"},
	{"mgle", "㻖"},
	{"mglll", "玔"},
	{"mglln", "𤤖"},
	{"mglmo", "珧"},
	{"mglmt", "璶"},
	{"mglmy", "琲"},
	{"mgln", "到"},
	{"mglq", "珒"},
	{"mglwl", "珅"},
	{"mglx", "璛"},
	{"mgm", "玒"},
	{"mgma", "𤤿"},
	{"mgmbb", "瓀"},
	{"mgmbc", "頊"},
	{"mgmbe", "𤫑"},
	{"mgmbm", "𤫩"},
	{"mgmbr", "𤫢"},
	{"mgmd", "玗"},
	{"mgmf", "𦤹"},
	{"mgmfj", "玶"},
	{"mgmg", "玨"},
	{"mgmgh", "璱"},
	{"mgmgi", "珏"},
	{"mgmhl", "琊"},
	{"mgmia", "瑨"},
	{"mgmig", "臸"},
	{"mgmj", "玕"},
	{"mgmlm", "𤦩"},
	{"mgmmp", "𤫟"},
	{"mgmmr", "珸"},
	{"mgmmu", "玩"},
	{"mgmn", "玎"},
	{"mgmnr", "珂"},
	{"mgmpm", "珷"},
	{"mgmso", "琢"},
	{"mgmt", "𤣿"},
	{"mgmtb", "𤪲"},
	{"mgmue", "𤧶"},
	{"mgmvh", "玡"},
	{"mgmvn", "甄"},
	{"mgmwd", "瑮"},
	{"mgmwf", "𤨧"},
	{"mgmwj", "㻼"},
	{"mgnau", "㻊"},
	{"mgnbe", "瓊"},
	{"mgnbk", "瑒"},
	{"mgnd", "㺭"},
	{"mgne", "𤣻"},
	{"mgnf", "珎"},
	{"mgnhb", "璚"},
	{"mgnhd", "瑈"},
	{"mgnin", "𤥀"},
	{"mgnir", "𤥁"},
	{"mgnj", "𤣲"},
	{"mgnkg", "珽"},
	{"mgnkm", "𤥻"},
	{"mgnkq", "𤧣"},
	{"mgnl", "郅 鄄"},
	{"mgno", "歅 玖"},
	{"mgnot", "璒"},
	{"mgnqd", "㻧"},
	{"mgo", "珡"},
	{"mgog", "琟"},
	{"mgohb", "𤦍"},
	{"mgohh", "珍"},
	{"mgoii", "玲"},
	{"mgoin", "玪 琴"},
	{"mgoip", "玳 𤦬"},
	{"mgoir", "琀 瑲"},
	{"mgoj", "玝"},
	{"mgoju", "珤"},
	{"mgok", "玫 致"},
	{"mgoll", "玠"},
	{"mgoma", "璯"},
	{"mgomb", "𤦎"},
	{"mgomd", "㻌"},
	{"mgomg", "㻇"},
	{"mgomn", "瑜"},
	{"mgomr", "珨"},
	{"mgono", "琁"},
	{"mgord", "𤦸"},
	{"mgotq", "𤪕"},
	{"mgowy", "珻"},
	{"mgoyk", "𤨨"},
	{"mgpa", "珣"},
	{"mgph", "珌 瑟"},
	{"mgphp", "𤦏"},
	{"mgpi", "玓"},
	{"mgpko", "𤪦"},
	{"mgpkp", "𤧚"},
	{"mgpp", "玭 琵"},
	{"mgppa", "瑄"},
	{"mgpru", "玸"},
	{"mgpt", "玴"},
	{"mgptd", "㻡"},
	{"mgpu", "𤤀"},
	{"mgqhf", "𤩦"},
	{"mgqj", "玤"},
	{"mgqjm", "㻰"},
	{"mgqjp", "𤪳"},
	{"mgqka", "瑃"},
	{"mgqkd", "瑧 臻"},
	{"mgqkq", "琫"},
	{"mgqmb", "𤦭"},
	{"mgqmw", "瑇"},
	{"mgqo", "玞"},
	{"mgrb", "琄"},
	{"mgrhg", "珵"},
	{"mgrmr", "璐"},
	{"mgrpa", "瑉"},
	{"mgrr", "噩"},
	{"mgrrd", "璪"},
	{"mgrrj", "𤩧"},
	{"mgrvp", "珉"},
	{"mgrye", "瑕"},
	{"mgryo", "珿"},
	{"mgshr", "玿"},
	{"mgsj", "珥"},
	{"mgsjr", "琚"},
	{"mgsk", "厫"},
	{"mgskr", "珺"},
	{"mgsll", "㺿"},
	{"mgsmh", "璆"},
	{"mgsmi", "璕"},
	{"mgsmj", "璻"},
	{"mgsmm", "珝"},
	{"mgsp", "𤤗"},
	{"mgsqf", "瑪"},
	{"mgsql", "𤥶"},
	{"mgstt", "𤧅"},
	{"mgstv", "𤧷"},
	{"mgsu", "玘 𤣱"},
	{"mgt", "弄"},
	{"mgtbc", "琠"},
	{"mgtbn", "獉"},
	{"mgtc", "珙"},
	{"mgtcf", "𤪌"},
	{"mgtcg", "璂"},
	{"mgtch", "𤦈"},
	{"mgtcl", "𤩐"},
	{"mgtco", "璞"},
	{"mgtgk", "𤧞"},
	{"mgtgt", "瓂"},
	{"mgtgu", "琷"},
	{"mgthn", "㻳"},
	{"mgti", "㕑"},
	{"mgtio", "𤦧"},
	{"mgtjs", "𤨕"},
	{"mgtlb", "璊"},
	{"mgtlf", "𤫇"},
	{"mgtlk", "瑛"},
	{"mgtlm", "瑾"},
	{"mgtlo", "𤨢"},
	{"mgtm", "玵"},
	{"mgtmc", "琪 璜"},
	{"mgtmj", "璍"},
	{"mgtnk", "𤩸"},
	{"mgtod", "瑹 𤨓"},
	{"mgtoe", "瓁"},
	{"mgtq", "珜"},
	{"mgtqg", "𤨩"},
	{"mgtqm", "瑳"},
	{"mgtrg", "瓘"},
	{"mgtrk", "璥"},
	{"mgtt", "㻂"},
	{"mgtvi", "𤧹"},
	{"mgtxc", "㻩"},
	{"mgtyj", "𤪼"},
	{"mgu", "玌"},
	{"mguap", "𤨾"},
	{"mgufk", "𤪖"},
	{"mgumb", "瑞"},
	{"mgumt", "𤧸"},
	{"mguob", "瓗"},
	{"mguog", "璀"},
	{"mguon", "琌"},
	{"mgutn", "𤩑"},
	{"mgvid", "瓅"},
	{"mgvii", "璣"},
	{"mgvio", "𤤳"},
	{"mgviw", "㼄"},
	{"mgvl", "㺩"},
	{"mgvne", "琭"},
	{"mgvno", "猻"},
	{"mgvvd", "璅"},
	{"mgvvw", "瑙"},
	{"mgwg", "理"},
	{"mgwk", "珚"},
	{"mgwkp", "𤨒"},
	{"mgwl", "玾"},
	{"mgwli", "㻿"},
	{"mgwlv", "環"},
	{"mgwtj", "㻫"},
	{"mgwww", "瓃"},
	{"mgy", "㺪"},
	{"mgyaj", "琸"},
	{"mgybc", "𤦹"},
	{"mgybj", "璭"},
	{"mgybk", "瓛"},
	{"mgybp", "瓏"},
	{"mgybr", "𤩅"},
	{"mgybs", "𤧭"},
	{"mgybu", "璿 𤪻"},
	{"mgyck", "珓"},
	{"mgyed", "璨 𤨪"},
	{"mgyfe", "琡"},
	{"mgygq", "㼀"},
	{"mgyhs", "𤤁"},
	{"mgyiu", "珫 琉"},
	{"mgyjj", "璉"},
	{"mgyk", "玟"},
	{"mgykg", "斑"},
	{"mgykh", "珳"},
	{"mgylc", "𤥂"},
	{"mgymp", "玼"},
	{"mgymr", "琂"},
	{"mgyog", "璡"},
	{"mgyoj", "琗"},
	{"mgyok", "𤥿"},
	{"mgypo", "璩"},
	{"mgypt", "瓐"},
	{"mgypu", "琥"},
	{"mgyr", "玷"},
	{"mgyrf", "琼"},
	{"mgyrn", "𤧟"},
	{"mgyru", "𤦻"},
	{"mgyrv", "瓖"},
	{"mgysd", "㻢"},
	{"mgyso", "璇"},
	{"mgytj", "璋"},
	{"mgyto", "璲"},
	{"mgytr", "琣 𤦺"},
	{"mgyub", "璃"},
	{"mgyvi", "玹"},
	{"mgywv", "瓌"},
	{"mgyx", "璾"},
	{"mgyyb", "瓋"},
	{"mh", "厂"},
	{"mhaf", "原"},
	{"mhdd", "厤"},
	{"mhgu", "𠀡"},
	{"mhhaf", "鴉"},
	{"mhjm", "厜"},
	{"mhlv", "𥘅"},
	{"mhnl", "邪"},
	{"mhog", "雅"},
	{"mhoiv", "餮"},
	{"mhpm", "厎"},
	{"mhs", "厏"},
	{"mibbe", "靉"},
	{"mig", "至"},
	{"mihaf", "䲰"},
	{"mihi", "魂"},
	{"miia", "晉"},
	{"miks", "动"},
	{"mimgi", "𤤴"},
	{"minl", "鄏"},
	{"mioin", "霒"},
	{"mipt", "𤤙"},
	{"mitgi", "𤩺"},
	{"miuh", "厖"},
	{"miyle", "靆"},
	{"mj", "干"},
	{"mjbc", "厧"},
	{"mjf", "烎"},
	{"mjhaf", "鳱 鷣"},
	{"mjixp", "麉"},
	{"mjln", "刊"},
	{"mjmbc", "頇"},
	{"mjn", "𢏗"},
	{"mjnl", "邗"},
	{"mjok", "敢"},
	{"mjwj", "厙"},
	{"mk", "天"},
	{"mkdhe", "𥀬"},
	{"mkg", "壓 𡍶"},
	{"mkhi", "魘"},
	{"mkhqm", "甦"},
	{"mkmwl", "靨"},
	{"mknl", "郠"},
	{"mkoiv", "饜"},
	{"mkp", "憨"},
	{"mkq", "擪"},
	{"mks", "功"},
	{"mku", "无"},
	{"mkv", "嬮"},
	{"mkwgf", "黶"},
	{"mkwl", "厴"},
	{"ml", "丌"},
	{"mlbo", "兩"},
	{"mlbu", "両"},
	{"mlby", "雨"},
	{"mllm", "亞"},
	{"mllw", "覀"},
	{"mlm", "工"},
	{"mlmy", "厞"},
	{"mlvs", "丏"},
	{"mlwk", "更"},
	{"mm", "二"},
	{"mmbb", "丽"},
	{"mmbbp", "麗"},
	{"mmbc", "項"},
	{"mmf", "示"},
	{"mmg", "堊"},
	{"mmhaf", "鵛 鵡"},
	{"mmi", "云"},
	{"mmig", "厔"},
	{"mmks", "勁"},
	{"mml", "亓"},
	{"mmlmi", "蝁"},
	{"mmln", "剄"},
	{"mmm", "三"},
	{"mmmbc", "頸"},
	{"mmmm", "㠭"},
	{"mmmv", "辰"},
	{"mmn", "亍"},
	{"mmnl", "邳"},
	{"mmok", "政"},
	{"mmp", "惡 𢘫"},
	{"mmqmb", "靕"},
	{"mmr", "吾"},
	{"mmti", "厨"},
	{"mmu", "元"},
	{"mmue", "厦"},
	{"mmuu", "黿"},
	{"mmvh", "厊"},
	{"mmvn", "瓨"},
	{"mmvs", "巧"},
	{"mmyiu", "巰"},
	{"mmypu", "虣"},
	{"mn", "丁"},
	{"mnbm", "殂"},
	{"mnbnd", "殍"},
	{"mnc", "銎"},
	{"mncsh", "瓰"},
	{"mnf", "烈"},
	{"mng", "型"},
	{"mngbt", "殪"},
	{"mngwc", "殰"},
	{"mnhaf", "殦 鴷"},
	{"mnhbt", "殈"},
	{"mnhjd", "殊"},
	{"mnhk", "殀"},
	{"mnhne", "殁"},
	{"mnhpa", "殙"},
	{"mnhqu", "瓱"},
	{"mnhuk", "殠"},
	{"mni", "歹"},
	{"mnii", "殘"},
	{"mnije", "殏"},
	{"mnir", "殆"},
	{"mnj", "瓧"},
	{"mnjbm", "殖"},
	{"mnjmc", "殥 殯"},
	{"mnjru", "殑"},
	{"mnk", "𣧂"},
	{"mnklu", "殗"},
	{"mnkoo", "殎"},
	{"mnkpb", "殢"},
	{"mnl", "邛"},
	{"mnlbk", "殃"},
	{"mnle", "殔"},
	{"mnlmi", "蛩"},
	{"mnln", "列"},
	{"mnlq", "肂"},
	{"mnma", "瓸"},
	{"mnmbc", "頂"},
	{"mnmem", "殛"},
	{"mnmvm", "殌"},
	{"mnmwg", "甅"},
	{"mnmwm", "殭"},
	{"mnne", "歿"},
	{"mnnwf", "鮤"},
	{"mnoah", "殤"},
	{"mnohh", "殄"},
	{"mnoim", "殲"},
	{"mnoiv", "飱"},
	{"mnomo", "殮"},
	{"mnp", "恐 死 𢢭"},
	{"mnpa", "殉"},
	{"mnphh", "歾"},
	{"mnpu", "瓲"},
	{"mnq", "㧬"},
	{"mnr", "可"},
	{"mnrbc", "殞"},
	{"mnrrj", "殫"},
	{"mnryo", "跫"},
	{"mntlj", "鞏"},
	{"mntlm", "殣"},
	{"mnv", "姴"},
	{"mnwot", "殟"},
	{"mnyfu", "殧"},
	{"mnyhv", "裂"},
	{"mnytr", "殕"},
	{"mo", "仄"},
	{"moau", "豝"},
	{"moav", "豤"},
	{"mob", "丙"},
	{"mobuu", "覡"},
	{"mobvk", "豯"},
	{"mof", "燹"},
	{"mogbt", "豷"},
	{"mogc", "贋"},
	{"mogf", "㷳"},
	{"mohaf", "鵐 鷢"},
	{"mohf", "鴈"},
	{"mohoo", "豵"},
	{"mohsn", "豟"},
	{"mojka", "豬"},
	{"mojtc", "豶"},
	{"moju", "厒"},
	{"mok", "攻"},
	{"mokkb", "豨"},
	{"molmi", "蟨"},
	{"moln", "劂"},
	{"momhf", "豲"},
	{"momso", "豩"},
	{"momt", "豜"},
	{"moo", "巫"},
	{"moob", "两"},
	{"moog", "雁"},
	{"mook", "𢽴"},
	{"morye", "豭"},
	{"moryo", "蹷"},
	{"moumb", "䝎"},
	{"mowot", "豱"},
	{"moyvo", "豥"},
	{"mphaf", "鸝"},
	{"mphhh", "彲"},
	{"mpnl", "酈"},
	{"mpylm", "武"},
	{"mr", "石"},
	{"mramh", "碭"},
	{"mrami", "碍"},
	{"mrana", "磵"},
	{"mrapv", "碣"},
	{"mrav", "硍"},
	{"mrbb", "硼"},
	{"mrbbm", "𥑬"},
	{"mrbbr", "碢"},
	{"mrbgr", "碉"},
	{"mrbhx", "𥔿"},
	{"mrbj", "鞷"},
	{"mrbl", "鬲"},
	{"mrbm", "砠"},
	{"mrbmr", "硐"},
	{"mrbou", "磘"},
	{"mrbq", "砽"},
	{"mrbsd", "碀"},
	{"mrbtu", "碙"},
	{"mrbuc", "𧵔"},
	{"mrbuu", "硯"},
	{"mrbvk", "磎"},
	{"mrby", "砃"},
	{"mrc", "𥐙"},
	{"mrcsh", "砏"},
	{"mrcwa", "磳"},
	{"mrdam", "碴"},
	{"mrdci", "硹"},
	{"mrdd", "碄"},
	{"mrddo", "礎"},
	{"mrdhe", "破"},
	{"mrdj", "砞"},
	{"mrdm", "砵"},
	{"mre", "泵 砅"},
	{"mrea", "䂿"},
	{"mreed", "磉"},
	{"mresd", "磲"},
	{"mrfb", "硝"},
	{"mrfbw", "礑"},
	{"mrfdq", "磷"},
	{"mrfdr", "𥕝"},
	{"mrfff", "礯"},
	{"mrffs", "磱"},
	{"mrfh", "砂"},
	{"mrfmu", "硄"},
	{"mrgg", "硅"},
	{"mrggu", "磽"},
	{"mrgi", "砝"},
	{"mrgit", "磕"},
	{"mrgr", "硈"},
	{"mrgrr", "礂"},
	{"mrgsk", "磝"},
	{"mrhdw", "磻"},
	{"mrher", "硌"},
	{"mrhgr", "硞"},
	{"mrhhj", "碑"},
	{"mrhi", "磈"},
	{"mrhio", "砭"},
	{"mrhjd", "硃"},
	{"mrhje", "碫"},
	{"mrhjm", "硾"},
	{"mrhkb", "礄"},
	{"mrhlc", "礩"},
	{"mrhml", "斫"},
	{"mrhmy", "䂨"},
	{"mrhn", "𥐥"},
	{"mrhne", "砓"},
	{"mrhni", "矾 碸"},
	{"mrhnk", "砜"},
	{"mrhp", "矺"},
	{"mrhpa", "碈"},
	{"mrhpm", "砥"},
	{"mrhqi", "硪"},
	{"mrhs", "砟"},
	{"mrhsb", "碥"},
	{"mrhse", "磤"},
	{"mrhsk", "礉"},
	{"mrhsn", "砨"},
	{"mrhuc", "礸"},
	{"mrhwk", "硇"},
	{"mrhwp", "磇"},
	{"mrhyu", "磃"},
	{"mriav", "硠"},
	{"mribi", "磗"},
	{"mridr", "礳"},
	{"mridy", "䃺"},
	{"mrie", "砯"},
	{"mrihf", "磩"},
	{"mrihr", "碱"},
	{"mriih", "磣"},
	{"mrilr", "磄"},
	{"mrism", "𥔱"},
	{"mritc", "礦"},
	{"mriuh", "硥"},
	{"mrjbc", "磌"},
	{"mrjcm", "硿"},
	{"mrjii", "磚"},
	{"mrjkp", "硓"},
	{"mrjmc", "礗"},
	{"mrjmm", "碹"},
	{"mrjmo", "碇"},
	{"mrjnu", "碗"},
	{"mrjp", "砣"},
	{"mrjqr", "磍"},
	{"mrjr", "𥑮"},
	{"mrjwj", "硨"},
	{"mrkkk", "磢"},
	{"mrkmr", "碕"},
	{"mrkoo", "硤"},
	{"mrksr", "𥑆"},
	{"mrlln", "砩"},
	{"mrlq", "硉"},
	{"mrlwl", "砷"},
	{"mrm", "矼"},
	{"mrmbb", "礝"},
	{"mrmbc", "碩"},
	{"mrmbg", "礭"},
	{"mrmbs", "𥗠"},
	{"mrmbu", "礵"},
	{"mrmbw", "礌"},
	{"mrmcw", "硒"},
	{"mrmfj", "砰"},
	{"mrmgi", "砡"},
	{"mrmgt", "硦"},
	{"mrmj", "矸"},
	{"mrmlk", "硬"},
	{"mrmmi", "𥐯"},
	{"mrmn", "矴"},
	{"mrmnr", "砢"},
	{"mrmpm", "碔"},
	{"mrmr", "砳"},
	{"mrmrr", "磊"},
	{"mrmso", "硺"},
	{"mrmsu", "砈"},
	{"mrmt", "研"},
	{"mrmtb", "礪"},
	{"mrmtn", "硎"},
	{"mrmu", "矹"},
	{"mrmvb", "磭"},
	{"mrmvh", "砑"},
	{"mrmvm", "硜"},
	{"mrmwj", "磹"},
	{"mrmwm", "礓"},
	{"mrnbg", "确"},
	{"mrnd", "矷"},
	{"mrnhe", "砐"},
	{"mrni", "矽"},
	{"mrnl", "郚 酃"},
	{"mrnmu", "硊"},
	{"mrno", "歌 砍"},
	{"mrnot", "磴"},
	{"mrnqd", "磔"},
	{"mrnr", "哥"},
	{"mrobg", "確"},
	{"mrog", "碓"},
	{"mrogd", "磼"},
	{"mrogf", "礁"},
	{"mroii", "砱"},
	{"mrok", "敔"},
	{"mroll", "砎"},
	{"mrom", "砼"},
	{"mromb", "碖"},
	{"mromd", "硢"},
	{"mromg", "硂"},
	{"mromo", "礆"},
	{"mron", "矻"},
	{"mrpko", "礙"},
	{"mrpp", "砒"},
	{"mrppa", "䃈"},
	{"mrpru", "砲"},
	{"mrpsh", "砌"},
	{"mrptd", "碟"},
	{"mrpu", "砘"},
	{"mrqhk", "碶"},
	{"mrqmb", "碃"},
	{"mrqmc", "磧"},
	{"mrqmy", "碡"},
	{"mrqo", "砆"},
	{"mrrbc", "磒"},
	{"mrrrj", "磾"},
	{"mrrrk", "礹"},
	{"mrrye", "碬"},
	{"mrryo", "𨀂"},
	{"mrsec", "礥"},
	{"mrseg", "䃘"},
	{"mrsfk", "礮"},
	{"mrsit", "礛"},
	{"mrsk", "𥐰"},
	{"mrslb", "砸"},
	{"mrsmh", "磟"},
	{"mrsmv", "䂻"},
	{"mrsqf", "碼"},
	{"mrsrj", "礔"},
	{"mrsrr", "𥕥"},
	{"mrstv", "碾"},
	{"mrt", "豆"},
	{"mrta", "碏"},
	{"mrtbc", "碘"},
	{"mrtbf", "礤"},
	{"mrtbk", "䃟"},
	{"mrtbo", "礞"},
	{"mrtc", "硔"},
	{"mrtcg", "𥕛"},
	{"mrtei", "礴"},
	{"mrtgi", "礒"},
	{"mrtgo", "𥖄"},
	{"mrtgr", "磰"},
	{"mrtii", "礡"},
	{"mrtju", "𥕜"},
	{"mrtk", "砹"},
	{"mrtlf", "𥗕"},
	{"mrtlk", "碤"},
	{"mrtmc", "磺"},
	{"mrtmv", "碪"},
	{"mrtqm", "磋"},
	{"mrtrg", "礶"},
	{"mrtt", "硑"},
	{"mrttc", "碰"},
	{"mrtvi", "磁 𥔵"},
	{"mrtvs", "磡"},
	{"mrtwa", "𥕢"},
	{"mrtwi", "礣 𥖁"},
	{"mrtxc", "磏"},
	{"mrtyv", "硭"},
	{"mrubb", "磞"},
	{"mrumf", "碳"},
	{"mrumt", "磑"},
	{"mruob", "磮"},
	{"mruog", "磪"},
	{"mrvid", "礫"},
	{"mrvii", "磯"},
	{"mrvne", "碌"},
	{"mrvvw", "碯"},
	{"mrwd", "硱"},
	{"mrwhd", "碅"},
	{"mrwmv", "碨"},
	{"mrwvf", "磥"},
	{"mrwww", "礧"},
	{"mrwyc", "𥖏"},
	{"mrwyi", "砪"},
	{"mrybb", "碲"},
	{"mrybp", "礲"},
	{"mrybs", "磅"},
	{"mrycv", "𥕦"},
	{"mrydk", "礅"},
	{"mryg", "砫"},
	{"mryhr", "磓"},
	{"mryiu", "硫"},
	{"mryoj", "碎"},
	{"mryr", "砧"},
	{"mryrb", "碻"},
	{"mryrn", "碠"},
	{"mryt", "砬"},
	{"mrytj", "𥕞"},
	{"mrytr", "碚"},
	{"mryvo", "硋"},
	{"mrywi", "磠"},
	{"ms", "万"},
	{"mshjg", "𩅞"},
	{"msho", "豕"},
	{"msko", "豖"},
	{"msl", "卭"},
	{"msnl", "鄠"},
	{"msok", "攷"},
	{"msu", "厄"},
	{"msv", "𠩐"},
	{"mt", "幵"},
	{"mta", "厝 晉"},
	{"mtc", "亚"},
	{"mtcl", "厮"},
	{"mthaf", "鳽"},
	{"mthhh", "形"},
	{"mthhj", "豍"},
	{"mtje", "豉"},
	{"mtjnu", "豌"},
	{"mtlm", "厪"},
	{"mtln", "刑"},
	{"mtm", "豇"},
	{"mtmbc", "頭"},
	{"mtnl", "邢 郖"},
	{"mtog", "雃"},
	{"mtq", "揅"},
	{"mttxc", "豏"},
	{"mtuo", "厥"},
	{"mtwb", "厲"},
	{"mu", "兀 兀"},
	{"mua", "朁"},
	{"muali", "蠶"},
	{"mub", "襾"},
	{"muf", "炁"},
	{"muhaf", "鸘 䲮"},
	{"muhe", "夏"},
	{"mui", "戛"},
	{"mukll", "奡"},
	{"mulmi", "虺"},
	{"muln", "刓"},
	{"mumbc", "頑"},
	{"mumrb", "鬵"},
	{"mumso", "豗"},
	{"munl", "邧"},
	{"munmu", "卼"},
	{"musmm", "𦒘"},
	{"muw", "画"},
	{"mv", "匚 匸"},
	{"mvb", "脣"},
	{"mvdh", "牙"},
	{"mvdi", "辱"},
	{"mvku", "旡"},
	{"mvlmi", "蜃"},
	{"mvni", "瓦"},
	{"mvnm", "互"},
	{"mvphh", "覅"},
	{"mvr", "唇"},
	{"mvvm", "巠"},
	{"mwahm", "醒"},
	{"mwaj", "覃"},
	{"mwamo", "醍"},
	{"mwapp", "醌"},
	{"mwbdi", "酹"},
	{"mwbmr", "酮"},
	{"mwbuc", "賈"},
	{"mwbuu", "靦"},
	{"mwbwi", "釂"},
	{"mwcsh", "酚"},
	{"mwd", "栗"},
	{"mwdd", "醂"},
	{"mwdi", "酎"},
	{"mweee", "醊"},
	{"mwfd", "粟"},
	{"mwg", "厘 垔"},
	{"mwgg", "㕓"},
	{"mwgni", "醻"},
	{"mwhaf", "鶝"},
	{"mwhd", "酥"},
	{"mwher", "酪"},
	{"mwhgf", "醺"},
	{"mwhgr", "酷"},
	{"mwhgu", "酰"},
	{"mwhi", "醜"},
	{"mwhio", "覂"},
	{"mwhne", "酘"},
	{"mwhoe", "覆"},
	{"mwhqu", "酕"},
	{"mwhs", "酢"},
	{"mwhsk", "覈"},
	{"mwhxe", "醙"},
	{"mwice", "酸"},
	{"mwidd", "醾"},
	{"mwidy", "釄"},
	{"mwihr", "醎"},
	{"mwii", "醆"},
	{"mwijb", "酺"},
	{"mwik", "䣭"},
	{"mwiku", "𨠄"},
	{"mwill", "酬"},
	{"mwilr", "醣"},
	{"mwjcs", "醡"},
	{"mwjdi", "酧"},
	{"mwjka", "醏"},
	{"mwjkd", "酵"},
	{"mwjp", "酡"},
	{"mwjr", "酤"},
	{"mwjrb", "醐"},
	{"mwki", "酞"},
	{"mwklu", "醃"},
	{"mwkrt", "醢"},
	{"mwks", "𠡳"},
	{"mwlbu", "酖"},
	{"mwlii", "蠠"},
	{"mwlkt", "醠"},
	{"mwln", "副"},
	{"mwlut", "醓"},
	{"mwmbb", "醹"},
	{"mwmbr", "醽"},
	{"mwmd", "酑"},
	{"mwmj", "酐"},
	{"mwmm", "畺"},
	{"mwmmf", "票"},
	{"mwmmp", "釃"},
	{"mwmn", "酊"},
	{"mwmnr", "酠"},
	{"mwmwf", "醥"},
	{"mwmwj", "醰"},
	{"mwnir", "酩"},
	{"mwnob", "醑"},
	{"mwnoe", "醱"},
	{"mwnok", "䤆"},
	{"mwog", "醀"},
	{"mwogf", "醮"},
	{"mwomd", "酴"},
	{"mwomo", "醶"},
	{"mwowy", "酶"},
	{"mwpa", "酯"},
	{"mwpd", "酏"},
	{"mwpi", "酌"},
	{"mwpou", "醄"},
	{"mwqo", "酜"},
	{"mwrb", "䣺"},
	{"mwrhg", "酲"},
	{"mwrrk", "釅"},
	{"mwsmh", "醪"},
	{"mwsmr", "䣳"},
	{"mwsrr", "醧"},
	{"mwsu", "配"},
	{"mwta", "醋"},
	{"mwtco", "醭"},
	{"mwtjb", "覇"},
	{"mwtjf", "覊"},
	{"mwtjr", "覉"},
	{"mwtlf", "醼"},
	{"mwtm", "酣"},
	{"mwtmc", "䤑"},
	{"mwtog", "醛"},
	{"mwtqm", "醝"},
	{"mwtwa", "醩"},
	{"mwtwt", "醴"},
	{"mwtwv", "醲"},
	{"mwuk", "酗"},
	{"mwv", "要"},
	{"mwvib", "酳"},
	{"mwvne", "醁"},
	{"mwwlj", "醳"},
	{"mwwot", "醞"},
	{"mwyfd", "醚"},
	{"mwyiu", "酼"},
	{"mwyj", "酙"},
	{"mwyl", "面"},
	{"mwyoj", "醉"},
	{"mwypo", "醵"},
	{"mwyr", "酟"},
	{"mwyrd", "醇"},
	{"mwyrv", "釀"},
	{"mwytp", "醷"},
	{"mwytr", "醅"},
	{"mwyub", "醨"},
	{"mwyut", "醯"},
	{"my", "下"},
	{"mybp", "龎"},
	{"mylf", "焉"},
	{"mylm", "正"},
	{"myo", "𤴓"},
	{"myp", "忑"},
	{"mypt", "𠫂"},
	{"mytj", "厗"},
	{"myvs", "丐"},
	{"n", "弓"},
	{"na", "𣄽"},
	{"nahu", "免"},
	{"napo", "象"},
	{"nau", "弝 色"},
	{"nbam", "觛"},
	{"nbb", "弸"},
	{"nbbue", "敻 𢿌"},
	{"nbdk", "觖"},
	{"nbdl", "觫"},
	{"nbfmu", "觥"},
	{"nbg", "墮 角"},
	{"nbgg", "觟"},
	{"nbhaf", "鷸"},
	{"nbher", "觡"},
	{"nbhpm", "觝"},
	{"nbhq", "𧣈"},
	{"nbhqu", "氄"},
	{"nbhvo", "觚"},
	{"nbhxu", "觬"},
	{"nbije", "觩"},
	{"nbjka", "觰"},
	{"nbk", "奐"},
	{"nbkmr", "觭"},
	{"nbks", "勇 觔"},
	{"nblmi", "触"},
	{"nbln", "劀"},
	{"nbme", "觨"},
	{"nbmgi", "瓕"},
	{"nbnbe", "觼"},
	{"nbnhe", "觙"},
	{"nbnmu", "觤"},
	{"nboah", "觴"},
	{"nbogs", "𧤤"},
	{"nboo", "𧢲"},
	{"nbop", "隳"},
	{"nbp", "恿"},
	{"nbrrj", "觶"},
	{"nbshq", "解"},
	{"nbtgq", "觲"},
	{"nbtlf", "觾"},
	{"nbtq", "觧"},
	{"nbu", "嶞"},
	{"nbuc", "負"},
	{"nbue", "彏"},
	{"nbuob", "觿"},
	{"nbvid", "觻"},
	{"nbvl", "觓"},
	{"nbwli", "觸"},
	{"nbyj", "斛"},
	{"nc", "小"},
	{"ncymr", "詹"},
	{"nd", "子"},
	{"ndbt", "孟"},
	{"ndbuc", "孭"},
	{"ndhaf", "鶔"},
	{"ndhvf", "孫"},
	{"ndhvo", "孤"},
	{"ndjmf", "孮"},
	{"ndlmt", "孻"},
	{"ndln", "刴"},
	{"ndmbb", "孺"},
	{"ndmlm", "孲"},
	{"ndnau", "㝃"},
	{"ndnbc", "𡥼"},
	{"ndnd", "孖"},
	{"ndnda", "孴"},
	{"ndndd", "孨"},
	{"ndok", "孜"},
	{"ndpru", "孢"},
	{"ndr", "𡥄"},
	{"ndtlb", "𡦖"},
	{"ndu", "孔"},
	{"ndwyi", "𣫮"},
	{"ndymr", "𡥪"},
	{"ndyvo", "孩"},
	{"ne", "氶 氹"},
	{"neg", "𡍵"},
	{"nem", "丞"},
	{"nemb", "脀"},
	{"nemf", "烝"},
	{"nemsu", "巹"},
	{"nf", "尔"},
	{"nfaa", "鯧"},
	{"nfabt", "鰛"},
	{"nfagi", "鰣"},
	{"nfail", "鯽"},
	{"nfamo", "鯷"},
	{"nfapp", "鯤"},
	{"nfasm", "鰨"},
	{"nfau", "䰾"},
	{"nfawe", "鰻"},
	{"nfb", "弰"},
	{"nfbcn", "鰂"},
	{"nfbgr", "鯛"},
	{"nfbmr", "鮦"},
	{"nfbof", "鰶"},
	{"nfbou", "鰩"},
	{"nfcru", "鮵"},
	{"nfcsh", "魵"},
	{"nfdhe", "鮍"},
	{"nfdn", "粥"},
	{"nfdoo", "鯠"},
	{"nfdwf", "鰊"},
	{"nfeii", "鰠"},
	{"nfemw", "䲤"},
	{"nffb", "鮹"},
	{"nffba", "鱨"},
	{"nffdq", "鱗"},
	{"nffh", "魦"},
	{"nfg", "𩵚"},
	{"nfgce", "鯪"},
	{"nfgcg", "鯥"},
	{"nfgg", "鮭"},
	{"nfggu", "鱙"},
	{"nfgi", "魼"},
	{"nfgr", "鮚"},
	{"nfhag", "鰉"},
	{"nfhd", "穌"},
	{"nfhdd", "鯚"},
	{"nfhdf", "鰍"},
	{"nfhdn", "鯏"},
	{"nfhdw", "鱕"},
	{"nfhe", "魬"},
	{"nfher", "鮥"},
	{"nfhey", "鮗"},
	{"nfhhw", "鰡"},
	{"nfhir", "鱵"},
	{"nfhjd", "鮢"},
	{"nfhje", "𩹨"},
	{"nfhkb", "鱎"},
	{"nfhor", "鯦"},
	{"nfhp", "魠"},
	{"nfhqm", "鮏"},
	{"nfhrb", "鰤"},
	{"nfhs", "鮓"},
	{"nfhvf", "鯀"},
	{"nfhxc", "鱮"},
	{"nfhxh", "鯓"},
	{"nfhxu", "鯢"},
	{"nfihr", "鰔"},
	{"nfiih", "鰺"},
	{"nfijb", "鯆"},
	{"nfije", "鯄"},
	{"nfikk", "鮁"},
	{"nfiku", "魷"},
	{"nfilb", "鱅"},
	{"nfir", "鮐"},
	{"nfirm", "䱛"},
	{"nfisb", "鯿"},
	{"nfisk", "𩸭"},
	{"nfjcr", "鰫"},
	{"nfjd", "鮇"},
	{"nfjii", "鱄"},
	{"nfjmu", "鯇"},
	{"nfjp", "鮀"},
	{"nfjpa", "鰭"},
	{"nfjr", "鮕"},
	{"nfjrb", "鰗"},
	{"nfjtc", "鱝"},
	{"nfjv", "鮟"},
	{"nfkb", "鮪"},
	{"nfke", "𩵼"},
	{"nfklu", "𩸆"},
	{"nfksr", "𩶛"},
	{"nflmo", "鮡"},
	{"nflmy", "鯡"},
	{"nflw", "鮋"},
	{"nflx", "鱐"},
	{"nfm", "魟"},
	{"nfmbl", "鮞"},
	{"nfmbm", "鱈"},
	{"nfmfj", "鮃"},
	{"nfmfm", "魾"},
	{"nfmgi", "玺"},
	{"nfmgr", "鱷"},
	{"nfmlk", "鯁"},
	{"nfmmp", "鱺"},
	{"nfmmr", "鯃"},
	{"nfmnr", "魺"},
	{"nfmtb", "鱱"},
	{"nfmto", "鱖"},
	{"nfmvm", "魱"},
	{"nfmwf", "鰾"},
	{"nfmwj", "鱏"},
	{"nfnao", "鱌"},
	{"nfnau", "鮸"},
	{"nfndt", "鯭"},
	{"nfnff", "鱻"},
	{"nfnhb", "鱊"},
	{"nfnhd", "鰇"},
	{"nfnkq", "鰎"},
	{"nfnmi", "鯴"},
	{"nfnmm", "鰯"},
	{"nfnmu", "鮠"},
	{"nfnoe", "鱍"},
	{"nfoae", "鰒"},
	{"nfob", "魶"},
	{"nfodi", "鮒"},
	{"nfoii", "魿"},
	{"nfoip", "鯰"},
	{"nfoir", "䱽"},
	{"nfok", "䰻"},
	{"nfold", "鰷"},
	{"nfoma", "鱠"},
	{"nfomb", "鯩"},
	{"nfomd", "鮽"},
	{"nfomr", "鮯"},
	{"nfonk", "鯸"},
	{"nfop", "魤"},
	{"nfp", "愻"},
	{"nfpa", "鮨"},
	{"nfph", "鮅"},
	{"nfphh", "魩"},
	{"nfpi", "魡"},
	{"nfpmm", "䱭"},
	{"nfpr", "鮈"},
	{"nfpru", "鮑"},
	{"nfptd", "鰈"},
	{"nfpu", "魨"},
	{"nfqka", "鰆"},
	{"nfqmb", "鯖"},
	{"nfqmc", "鰿"},
	{"nfrrd", "鱢"},
	{"nfrrj", "鱓"},
	{"nfrrs", "鰐"},
	{"nfrxu", "鱦"},
	{"nfrye", "鰕"},
	{"nfsav", "鰋"},
	{"nfseg", "鰹"},
	{"nfsfi", "䲁"},
	{"nfsh", "魛"},
	{"nfsje", "鯫"},
	{"nfsju", "鮿"},
	{"nfskr", "鮶"},
	{"nfsma", "鰼"},
	{"nfsmb", "鯞"},
	{"nfsmi", "鱘"},
	{"nftcw", "鰌"},
	{"nftgr", "鱔"},
	{"nftjs", "鰳"},
	{"nftm", "魽"},
	{"nftmc", "鯕"},
	{"nftq", "鮮"},
	{"nftrg", "鱹"},
	{"nftvi", "鰦"},
	{"nftvp", "𩼰"},
	{"nftwa", "鰽"},
	{"nftwi", "鱒 鱴"},
	{"nftwt", "鱧"},
	{"nftxc", "鰜"},
	{"nftyv", "𩷶"},
	{"nfujf", "𩻃"},
	{"nfvid", "鱳"},
	{"nfvvv", "鱲"},
	{"nfvvw", "鯔"},
	{"nfwg", "鯉"},
	{"nfwjr", "鯝"},
	{"nfwl", "魻"},
	{"nfwlb", "鰅"},
	{"nfwle", "鰥"},
	{"nfwlv", "鱞"},
	{"nfwo", "鮂"},
	{"nfwp", "鰓"},
	{"nfwr", "鮰"},
	{"nfybb", "𩼣"},
	{"nfybs", "鰟"},
	{"nfyck", "鮫"},
	{"nfyhn", "魧"},
	{"nfyhr", "𩺬"},
	{"nfyhs", "魴"},
	{"nfyjj", "鰱"},
	{"nfyk", "魰"},
	{"nfyle", "𩻸"},
	{"nfymf", "鮛"},
	{"nfymo", "鱁"},
	{"nfypk", "鰬"},
	{"nfypm", "鱋"},
	{"nfypt", "鱸"},
	{"nfypu", "鯱"},
	{"nfyr", "鮎"},
	{"nfyrb", "鰝"},
	{"nfyrd", "鯙"},
	{"nfyrf", "鯨"},
	{"nfyt", "𩶘"},
	{"nfytj", "鱆"},
	{"nfytv", "鯜"},
	{"nfywm", "鱣"},
	{"nfyx", "鱭"},
	{"ng", "丑"},
	{"ngmbc", "頲"},
	{"ngmwm", "疆"},
	{"nhbcr", "矞"},
	{"nhd", "柔"},
	{"nhe", "及"},
	{"nhli", "虱"},
	{"nhlii", "蟊"},
	{"nhoii", "矝"},
	{"nhoin", "矜"},
	{"nhoks", "務"},
	{"nhpm", "弤"},
	{"nhs", "乃"},
	{"nhsqf", "騭"},
	{"nhta", "矠"},
	{"nhv", "𡛺"},
	{"nhvo", "弧"},
	{"ni", "夕 弘"},
	{"niail", "𡖖"},
	{"nibq", "甬"},
	{"nihaf", "鵵"},
	{"nihq", "犟"},
	{"nijmc", "夤"},
	{"nili", "強"},
	{"niln", "劖"},
	{"ninh", "矛"},
	{"nini", "多"},
	{"ninii", "𠓗"},
	{"ninl", "酁"},
	{"ninn", "予"},
	{"nioiv", "飧"},
	{"niq", "舛"},
	{"nir", "名"},
	{"nisu", "夗"},
	{"nitc", "彍"},
	{"niv", "婱"},
	{"nixp", "麁"},
	{"niy", "外"},
	{"niymr", "謽 𧥧"},
	{"niyo", "癶"},
	{"nj", "卂"},
	{"njhaf", "鳵"},
	{"njlii", "蝨"},
	{"nk", "又 夊 廴"},
	{"nkbcr", "𢌡"},
	{"nkbr", "㢠"},
	{"nkbu", "瞀"},
	{"nkc", "鍪"},
	{"nkd", "楘"},
	{"nkf", "煞"},
	{"nkg", "堥"},
	{"nkha", "廹"},
	{"nkhaf", "鶩"},
	{"nkhg", "廷"},
	{"nkhml", "郔"},
	{"nkhym", "延"},
	{"nki", "戣"},
	{"nklmi", "蝥"},
	{"nklq", "建"},
	{"nklw", "廸"},
	{"nkmcw", "廼"},
	{"nknl", "鄈"},
	{"nkrhg", "𢌥"},
	{"nksqf", "騖"},
	{"nktlj", "鞪"},
	{"nkv", "婺"},
	{"nkwr", "廻"},
	{"nl", "弔 引 阝"},
	{"nla", "阳"},
	{"nlafu", "𨻙"},
	{"nlamh", "陽"},
	{"nlamo", "隄"},
	{"nlav", "限"},
	{"nlavf", "隰"},
	{"nlbhx", "䧟"},
	{"nlbi", "𢏐"},
	{"nlbm", "阻"},
	{"nlbmp", "隱"},
	{"nlbof", "際"},
	{"nlbt", "盄"},
	{"nlcnh", "𨹥"},
	{"nldhe", "陂"},
	{"nldw", "陳"},
	{"nldwk", "敶"},
	{"nlfdq", "隣"},
	{"nlfhf", "隙"},
	{"nlgce", "陵"},
	{"nlgcg", "陸"},
	{"nlggu", "隢"},
	{"nlgi", "阹"},
	{"nlgsk", "隞"},
	{"nlgyo", "陡"},
	{"nlhag", "隍"},
	{"nlhbk", "隩"},
	{"nlhe", "阪"},
	{"nlhem", "隆"},
	{"nlheq", "降"},
	{"nlhhj", "陴"},
	{"nlhhw", "𨻧"},
	{"nlhi", "隗"},
	{"nlhj", "阡"},
	{"nlhjd", "陎"},
	{"nlhjg", "隀"},
	{"nlhjm", "陲"},
	{"nlhlb", "𨺲"},
	{"nlhpm", "阺"},
	{"nlhrf", "隖"},
	{"nlhs", "阼"},
	{"nlhtg", "陞"},
	{"nlhxg", "隉"},
	{"nlice", "陖"},
	{"nlihu", "阭"},
	{"nlihv", "隇"},
	{"nlisn", "阸"},
	{"nljip", "䧥"},
	{"nljka", "陼"},
	{"nljmu", "院"},
	{"nljp", "陀"},
	{"nljwj", "陣"},
	{"nlkb", "陏"},
	{"nlkmb", "隋"},
	{"nlkmm", "隓"},
	{"nlkmr", "陭"},
	{"nlkms", "陓"},
	{"nlkoo", "陜 陝"},
	{"nlks", "阞"},
	{"nllmc", "隤"},
	{"nllmy", "陫"},
	{"nlma", "陌"},
	{"nlmbk", "陾"},
	{"nlmbl", "陑"},
	{"nlmbv", "陋"},
	{"nlmfb", "隬"},
	{"nlmfj", "𨸶"},
	{"nlmfm", "𨸹"},
	{"nlmmf", "际"},
	{"nlmmu", "阮"},
	{"nlmnr", "阿"},
	{"nlmob", "陃"},
	{"nlmrb", "隔"},
	{"nlmsu", "阨"},
	{"nlmu", "阢"},
	{"nlmvm", "陘"},
	{"nlmwg", "陻"},
	{"nlnbs", "𨺳"},
	{"nlnhx", "陷"},
	{"nlnin", "陊"},
	{"nlnj", "阠"},
	{"nlnot", "隥"},
	{"nlodi", "附"},
	{"nloii", "陰"},
	{"nlomb", "陯"},
	{"nlomd", "除"},
	{"nlomm", "险"},
	{"nlomn", "隃"},
	{"nlomo", "險"},
	{"nlon", "阣"},
	{"nlopd", "陁"},
	{"nlpd", "阤"},
	{"nlpfd", "陱"},
	{"nlpou", "陶"},
	{"nlpp", "阰"},
	{"nlppa", "階"},
	{"nlppg", "陛"},
	{"nlrbc", "隕"},
	{"nlrd", "𨹦"},
	{"nlsav", "隁"},
	{"nlsje", "陬"},
	{"nltct", "隘"},
	{"nltgi", "䧧"},
	{"nltpo", "隊"},
	{"nltt", "阱"},
	{"nltxc", "隒"},
	{"nlumt", "隑"},
	{"nlwlb", "隅"},
	{"nlwmv", "隈"},
	{"nlwol", "𨺬"},
	{"nlybp", "隴"},
	{"nlyhm", "隡"},
	{"nlyhn", "阬"},
	{"nlyhs", "防"},
	{"nlykb", "随 隨"},
	{"nlylh", "陟"},
	{"nlylm", "阯"},
	{"nlylo", "𨺗"},
	{"nlyr", "阽"},
	{"nlytj", "障"},
	{"nlyto", "隧"},
	{"nlytr", "陪"},
	{"nlyvo", "陔"},
	{"nlyx", "隮"},
	{"nman", "弼"},
	{"nmbn", "𢏺"},
	{"nmdl", "疎"},
	{"nmfb", "彌"},
	{"nmhqo", "𡘓"},
	{"nmice", "骏"},
	{"nmlmi", "蜑"},
	{"nmm", "彐"},
	{"nmnim", "弱"},
	{"nmnmf", "鶸"},
	{"nmok", "矦"},
	{"nmsu", "危"},
	{"nmvm", "弳"},
	{"nmwm", "彊"},
	{"nmyiu", "疏"},
	{"nn", "了 亇"},
	{"nnhe", "𢎽"},
	{"nnkf", "㷇"},
	{"nnm", "孑"},
	{"nnmbc", "預"},
	{"nnmrb", "鬻 𩱳"},
	{"nnnao", "豫"},
	{"nno", "孓"},
	{"nnpr", "夠"},
	{"nnqo", "承 𠄘"},
	{"nnr", "叾"},
	{"nnsmm", "翗"},
	{"nnu", "𠙶"},
	{"nnvvu", "郺"},
	{"no", "久 欠 飞"},
	{"noam", "疍"},
	{"nob", "胥"},
	{"noc", "鐆"},
	{"nodi", "弣"},
	{"nof", "弥 灸 𤉋"},
	{"nog", "墜 墬"},
	{"nohne", "癹"},
	{"nohto", "飛"},
	{"nolmi", "蛋"},
	{"nomk", "癸"},
	{"nomku", "発"},
	{"nomrn", "凳"},
	{"nomrt", "登"},
	{"nonhe", "發"},
	{"nop", "𢝵"},
	{"noph", "𢞵"},
	{"npd", "弛"},
	{"nq", "丮 𢩦"},
	{"nqd", "桀"},
	{"nqlmi", "蟹"},
	{"nrli", "强"},
	{"nrmvn", "甔"},
	{"nrog", "𨿅"},
	{"nrpp", "㲋"},
	{"nrppi", "毚"},
	{"nrrj", "彈"},
	{"nsbt", "盈"},
	{"nsbul", "鼐"},
	{"nsd", "争 朶 檃"},
	{"nse", "夃 𠃮"},
	{"nsf", "尕"},
	{"nshr", "弨"},
	{"nsj", "弭"},
	{"nsmv", "張"},
	{"nsnd", "孕"},
	{"nsp", "急"},
	{"nsrr", "彄"},
	{"nsv", "㜈"},
	{"nti", "戤"},
	{"ntks", "勐"},
	{"ntmc", "彉"},
	{"ntnl", "鄧 𨜏"},
	{"nu", "乙"},
	{"nuab", "𡦀"},
	{"nubt", "盌"},
	{"nubu", "眢"},
	{"nue", "函 弢 弢"},
	{"nuhaf", "鴛"},
	{"nui", "兔"},
	{"nuks", "勉"},
	{"numbc", "頠 顄"},
	{"nup", "怨"},
	{"nusqf", "駌"},
	{"nuv", "妴"},
	{"nv", "饣"},
	{"nvsm", "马"},
	{"nw", "乪"},
	{"nwbue", "𡕷"},
	{"nwf", "魚"},
	{"nwfa", "魯"},
	{"nwks", "勇"},
	{"nwlmi", "螴"},
	{"nwlu", "亀"},
	{"nwlv", "彋"},
	{"nwm", "鱼"},
	{"nwtj", "彃"},
	{"nwu", "龟"},
	{"nx", "卍"},
	{"nxff", "燄"},
	{"nxhaf", "鵮"},
	{"nxno", "欿"},
	{"nxu", "龜"},
	{"nybn", "㣃"},
	{"nyo", "疋"},
	{"nyrf", "弶"},
	{"nyvi", "弦"},
	{"o", "人"},
	{"oaa", "倡"},
	{"oahe", "复"},
	{"oahu", "𠋥"},
	{"oaln", "劊"},
	{"oam", "但"},
	{"oamo", "偍"},
	{"oan", "們"},
	{"oana", "僴"},
	{"oanb", "僩"},
	{"oanl", "鄶"},
	{"oapp", "倱"},
	{"oapv", "偈"},
	{"oasm", "傝"},
	{"oate", "儤"},
	{"oav", "佷"},
	{"oavf", "儑"},
	{"oawe", "僈"},
	{"oayf", "𠎠"},
	{"ob", "仴 內"},
	{"obau", "俷"},
	{"obb", "倗"},
	{"obbb", "傦"},
	{"obbe", "僾"},
	{"obch", "儩"},
	{"obcn", "側"},
	{"obgb", "偁"},
	{"obgr", "倜"},
	{"obhaf", "鸙"},
	{"obhd", "龢"},
	{"obhu", "伔"},
	{"obhyu", "𧈛"},
	{"obm", "伹"},
	{"obmbc", "龥"},
	{"obmc", "俱"},
	{"obmr", "侗"},
	{"obnd", "俘"},
	{"obo", "肉"},
	{"obof", "傺"},
	{"obou", "傜"},
	{"obp", "憊"},
	{"obppa", "龤"},
	{"obq", "佣"},
	{"obsmm", "𦒈"},
	{"obuu", "俔"},
	{"obv", "俀"},
	{"obvk", "傒"},
	{"obyr", "㑾"},
	{"oc", "仈"},
	{"ocb", "佾"},
	{"oci", "伀"},
	{"ocnh", "俤"},
	{"ocor", "俗"},
	{"ocru", "侻"},
	{"ocsh", "份"},
	{"ocwa", "僧"},
	{"od", "休"},
	{"odbuc", "賲"},
	{"odc", "鎥"},
	{"odci", "倯"},
	{"oddf", "僸"},
	{"oddo", "儊"},
	{"ode", "叙"},
	{"odf", "溣 烋 㷛"},
	{"odg", "堡"},
	{"odh", "𠆫"},
	{"odhf", "鵂"},
	{"odi", "付"},
	{"odm", "体"},
	{"odmq", "偉"},
	{"odog", "雓"},
	{"odoj", "𠓼"},
	{"odok", "敘"},
	{"odoo", "倈"},
	{"odp", "怹 恷"},
	{"odsmg", "糴"},
	{"odw", "𤲞"},
	{"odye", "敍"},
	{"odyj", "斜"},
	{"oe", "氽 汆"},
	{"of", "伙 尒 尓"},
	{"ofb", "俏"},
	{"ofbc", "償"},
	{"ofbf", "儻"},
	{"ofbg", "㑽"},
	{"ofbr", "倘"},
	{"ofbw", "儅"},
	{"ofd", "籴"},
	{"ofdq", "僯"},
	{"off", "倓"},
	{"offg", "𠐓"},
	{"offs", "僗"},
	{"ofhaf", "鷡 鷦"},
	{"ofhu", "偗"},
	{"ofln", "劁"},
	{"ofmbc", "顦"},
	{"ofmu", "侊"},
	{"ofmvn", "甒"},
	{"ofnl", "鄦"},
	{"ofp", "您"},
	{"ofq", "伴"},
	{"ofqu", "倦"},
	{"ofw", "畲"},
	{"og", "仕 隹"},
	{"ogbuc", "賃"},
	{"ogce", "倰"},
	{"ogd", "栠 集"},
	{"ogdi", "侍"},
	{"oge", "隻 雙"},
	{"ogf", "焦"},
	{"ogg", "佳"},
	{"oggu", "僥"},
	{"oghaf", "鵀 鶴 䳡"},
	{"oghn", "凭"},
	{"oghq", "犨"},
	{"ogi", "佉"},
	{"ogj", "隼"},
	{"oglms", "雋"},
	{"ogln", "剉"},
	{"ognhs", "隽"},
	{"ogni", "儔"},
	{"ogog", "雔"},
	{"ogogg", "雥 𠓾"},
	{"ogp", "恁"},
	{"ogr", "佶 售"},
	{"ogrg", "儓"},
	{"ogrr", "僖 𠏼"},
	{"ogsk", "傲"},
	{"ogtj", "倖"},
	{"ogwc", "儥"},
	{"ogymr", "讐"},
	{"ogyrg", "讎"},
	{"oh", "入"},
	{"oha", "伯"},
	{"ohag", "偟"},
	{"ohbt", "侐"},
	{"ohby", "侜"},
	{"ohce", "傻"},
	{"ohdf", "偢"},
	{"ohdi", "俬"},
	{"ohdn", "俐"},
	{"ohdp", "僁"},
	{"ohdr", "俰"},
	{"ohdv", "倭"},
	{"ohdw", "僠"},
	{"ohe", "仮"},
	{"oher", "佫"},
	{"ohey", "佟"},
	{"ohfp", "僽"},
	{"ohg", "任"},
	{"ohgi", "𠑥"},
	{"ohgr", "俈"},
	{"ohgs", "働"},
	{"ohgu", "侁"},
	{"ohhj", "俾"},
	{"ohi", "仫 傀"},
	{"ohj", "仟"},
	{"ohjd", "侏"},
	{"ohjg", "偅"},
	{"ohjm", "倕"},
	{"ohjr", "佸"},
	{"ohjx", "偛"},
	{"ohk", "仸"},
	{"ohkb", "僑"},
	{"ohkl", "侨"},
	{"ohlb", "偊"},
	{"ohlo", "俽"},
	{"ohml", "伒"},
	{"ohn", "仉"},
	{"ohnb", "佩"},
	{"ohnf", "𠏵"},
	{"ohni", "偑 𠆩"},
	{"ohoa", "偺"},
	{"ohoi", "偫"},
	{"ohoo", "傱"},
	{"ohor", "倃"},
	{"ohpm", "低"},
	{"ohq", "件"},
	{"ohqi", "俄"},
	{"ohqo", "佚"},
	{"ohqu", "𠇔"},
	{"ohrf", "𠌥"},
	{"ohs", "作"},
	{"ohsb", "偏"},
	{"ohsg", "僱"},
	{"ohsk", "儌"},
	{"ohuc", "儹"},
	{"ohvf", "係"},
	{"ohvl", "仰"},
	{"ohwp", "傯"},
	{"ohxe", "傁"},
	{"ohxu", "倪"},
	{"ohyu", "傂"},
	{"oi", "伐"},
	{"oiabt", "饂"},
	{"oiai", "飠"},
	{"oiamh", "餳"},
	{"oiapp", "餛"},
	{"oiapv", "餲"},
	{"oiar", "倉"},
	{"oiav", "俍 食"},
	{"oiawe", "饅"},
	{"oibhx", "饀"},
	{"oibi", "傅"},
	{"oibjj", "餫"},
	{"oibmr", "餇"},
	{"oibv", "餒"},
	{"oice", "俊"},
	{"oicyo", "餩"},
	{"oid", "𠇲"},
	{"oidam", "餷"},
	{"oidl", "餗"},
	{"oieee", "餟"},
	{"oifbd", "饓"},
	{"oiff", "餤"},
	{"oig", "垡"},
	{"oigbt", "饐"},
	{"oiggu", "饒"},
	{"oigit", "饁"},
	{"oigrr", "饎"},
	{"oihaf", "鴒"},
	{"oihag", "餭"},
	{"oihbr", "餉"},
	{"oihdv", "餧"},
	{"oihe", "飯"},
	{"oiher", "餎"},
	{"oihf", "傶"},
	{"oihg", "飪"},
	{"oihhl", "飹"},
	{"oihhw", "餾"},
	{"oihi", "餽"},
	{"oihjr", "餂"},
	{"oihk", "飫"},
	{"oihn", "飢"},
	{"oihon", "餰"},
	{"oihp", "侂 飥"},
	{"oihq", "侔"},
	{"oihqi", "餓"},
	{"oihs", "飵 𠉛"},
	{"oihuc", "饡"},
	{"oihxe", "餿"},
	{"oii", "俴"},
	{"oiibi", "餺"},
	{"oiice", "餕"},
	{"oiidr", "饝"},
	{"oiii", "餞"},
	{"oiijb", "餔"},
	{"oiilr", "餹"},
	{"oiir", "飴"},
	{"oijb", "俌"},
	{"oijbd", "餑"},
	{"oijbf", "𩟔"},
	{"oijbv", "饢"},
	{"oije", "俅"},
	{"oijrb", "餬"},
	{"oijrr", "館"},
	{"oijtc", "饙"},
	{"oik", "仪 伏"},
	{"oikf", "偽"},
	{"oikkb", "餙 餚"},
	{"oiku", "优"},
	{"oilb", "傭"},
	{"oilbk", "䬬"},
	{"oilmc", "饋"},
	{"oilmi", "蝕"},
	{"oilmm", "韱"},
	{"oimbc", "領"},
	{"oimbk", "餪"},
	{"oimgi", "㺸"},
	{"oimj", "飦"},
	{"oimn", "飣"},
	{"oimo", "佽"},
	{"oimrt", "餖"},
	{"oimvn", "瓴"},
	{"oin", "今"},
	{"oinc", "貪"},
	{"oindo", "𡦈"},
	{"oinhx", "餡"},
	{"oini", "令"},
	{"oinin", "䬷"},
	{"oinl", "邻"},
	{"oino", "飲"},
	{"oinp", "念"},
	{"oinr", "含"},
	{"oinri", "饞"},
	{"oint", "盦"},
	{"oinv", "衾"},
	{"oinw", "酓"},
	{"oioae", "𩜲"},
	{"oioi", "俯"},
	{"oiok", "俟"},
	{"oioks", "飭"},
	{"oiolb", "飾"},
	{"oiomd", "餘"},
	{"oiond", "餼"},
	{"oionk", "餱"},
	{"oip", "代 怤"},
	{"oipf", "儦"},
	{"oiph", "飶"},
	{"oipru", "飽"},
	{"oipu", "飩"},
	{"oir", "佁"},
	{"oiruc", "饌"},
	{"oisj", "餌"},
	{"oismm", "翎"},
	{"oismr", "飼"},
	{"oisrr", "饇"},
	{"oitak", "饃"},
	{"oitbk", "饊"},
	{"oitbo", "饛"},
	{"oitgf", "餻"},
	{"oitgr", "饍"},
	{"oitk", "餀"},
	{"oitlm", "饉"},
	{"oitqg", "饈"},
	{"oitt", "餅"},
	{"oiumr", "𩜠"},
	{"oiv", "姇"},
	{"oivii", "饑"},
	{"oivno", "餯"},
	{"oiwd", "餜"},
	{"oiwmv", "餵"},
	{"oiyck", "餃"},
	{"oiymh", "饖"},
	{"oiyrv", "饟"},
	{"oiytk", "餸"},
	{"oiywm", "饘"},
	{"oj", "什 午"},
	{"ojb", "伂"},
	{"ojbc", "傎"},
	{"ojbm", "值 𠊙"},
	{"ojcm", "倥"},
	{"ojcr", "傛"},
	{"ojd", "佅"},
	{"oje", "伎"},
	{"ojhaf", "鶽"},
	{"ojhhh", "𢒑"},
	{"ojhp", "侘"},
	{"ojii", "傳"},
	{"ojij", "儎"},
	{"ojip", "僡"},
	{"ojk", "仗"},
	{"ojka", "偖"},
	{"ojkf", "𠐟"},
	{"ojkp", "佬"},
	{"ojlk", "使"},
	{"ojln", "倳"},
	{"ojlo", "倢"},
	{"ojmc", "儐"},
	{"ojmf", "倧"},
	{"ojmm", "𠊿"},
	{"ojmmr", "啎"},
	{"ojmn", "佇"},
	{"ojmo", "傢 𠉵"},
	{"ojnu", "倇"},
	{"ojon", "𠍅"},
	{"ojp", "佗"},
	{"ojpn", "儜"},
	{"ojr", "估"},
	{"ojrk", "做"},
	{"ojrr", "倌"},
	{"ojtc", "僨"},
	{"ojtg", "僿"},
	{"oju", "缶"},
	{"ojv", "侒"},
	{"ojwj", "俥"},
	{"ok", "攵 矢"},
	{"okb", "侑"},
	{"okcf", "僚"},
	{"okcwa", "矰"},
	{"okf", "焂"},
	{"okhae", "瀪"},
	{"okhaf", "鴙 𪄴"},
	{"okhdv", "矮"},
	{"okhg", "俇"},
	{"okhk", "矨"},
	{"okhkb", "矯"},
	{"oki", "㑀"},
	{"okjt", "倴"},
	{"okkb", "俙"},
	{"okkk", "傸"},
	{"oklb", "佈"},
	{"oklu", "俺"},
	{"okm", "佐"},
	{"okmf", "倷"},
	{"okmr", "倚"},
	{"okmrt", "短"},
	{"okms", "侉"},
	{"okn", "仇 侇"},
	{"oknd", "𢻯"},
	{"oknl", "矧"},
	{"oknwf", "鰵"},
	{"okog", "雉"},
	{"okoo", "俠"},
	{"okoog", "矬"},
	{"okp", "悠 慜"},
	{"okr", "佑 知"},
	{"okryo", "跾"},
	{"oks", "仂"},
	{"oksr", "伽"},
	{"okss", "矩"},
	{"oktoe", "矱"},
	{"okvif", "繁"},
	{"okwlp", "矲"},
	{"ol", "个 仲"},
	{"olbk", "佒"},
	{"oll", "介"},
	{"olln", "佛"},
	{"olmc", "僓"},
	{"olmo", "佻"},
	{"olmt", "儘"},
	{"olmy", "俳"},
	{"olnk", "候"},
	{"olob", "脩"},
	{"olod", "條"},
	{"olof", "儵 絛 鯈"},
	{"oloh", "修"},
	{"oloj", "鞗"},
	{"olok", "倏 攸"},
	{"olom", "翛"},
	{"olp", "𠊞"},
	{"olpb", "偝"},
	{"olw", "伷"},
	{"olwl", "伸"},
	{"olws", "俜"},
	{"olwv", "僂"},
	{"om", "丘 亼 仜 仝"},
	{"oma", "佰"},
	{"omami", "𦉡"},
	{"ombb", "儒"},
	{"ombe", "優"},
	{"ombl", "侕"},
	{"ombn", "俞"},
	{"ombp", "愈 𢜒"},
	{"ombt", "侖"},
	{"ombv", "兪"},
	{"omc", "兵"},
	{"omd", "余 㐵"},
	{"omdm", "伍 儮"},
	{"omdp", "悆"},
	{"omdu", "峹 嵞"},
	{"omdw", "畬"},
	{"omf", "伓"},
	{"omfj", "伻"},
	{"omfm", "伾"},
	{"omfr", "俖"},
	{"omg", "全"},
	{"omgb", "侢"},
	{"omgk", "𠊷"},
	{"omgn", "倒"},
	{"omh", "乒"},
	{"omi", "乓"},
	{"omig", "侄"},
	{"omjr", "舍"},
	{"omjv", "钅"},
	{"omlb", "倆 𠉴"},
	{"omlk", "便"},
	{"omlm", "俹"},
	{"omm", "仁"},
	{"ommf", "佘"},
	{"ommi", "会 伝"},
	{"ommm", "仨"},
	{"ommp", "儷"},
	{"ommr", "俉"},
	{"ommv", "佞 侲"},
	{"omn", "仃 气"},
	{"omnl", "邱"},
	{"omnn", "例"},
	{"omno", "歙"},
	{"omnr", "何"},
	{"ompm", "倵"},
	{"omr", "合"},
	{"omrb", "龠"},
	{"omrl", "命"},
	{"omrm", "翕"},
	{"omro", "僉"},
	{"omrp", "龕"},
	{"omrq", "拿 搻"},
	{"omrr", "樖"},
	{"omrt", "弇 盒"},
	{"omru", "𥅽"},
	{"omrw", "偪 畣"},
	{"omsl", "卸"},
	{"omsp", "屔"},
	{"omtn", "侀"},
	{"omu", "岳"},
	{"omua", "僭"},
	{"omvh", "伢"},
	{"omvm", "俓"},
	{"omvn", "佤"},
	{"omwa", "會"},
	{"omwc", "價"},
	{"omwd", "傈 僳"},
	{"omwf", "僄"},
	{"omwl", "偭"},
	{"omwm", "僵"},
	{"omwu", "僊"},
	{"omwv", "偠"},
	{"omyf", "傿"},
	{"omym", "佂"},
	{"on", "乞 亿"},
	{"ona", "氜"},
	{"onamh", "氱"},
	{"onao", "像"},
	{"onau", "俛"},
	{"onbc", "偩"},
	{"onbs", "𠋀"},
	{"onbuu", "覦"},
	{"oncr", "儋"},
	{"oncsh", "氛"},
	{"ond", "仔"},
	{"onf", "你"},
	{"onfd", "氣"},
	{"onff", "氮"},
	{"ong", "𡌅"},
	{"onhaf", "鳹"},
	{"onhb", "僪"},
	{"onhe", "伋"},
	{"onhey", "氡"},
	{"onhqu", "毹"},
	{"onhs", "仍"},
	{"onib", "俑"},
	{"onin", "伃 侈"},
	{"onir", "佲"},
	{"onjru", "氪"},
	{"onjv", "氨"},
	{"onkg", "侹"},
	{"onkl", "鄇"},
	{"onkq", "健"},
	{"onl", "伄 氕 𠇁"},
	{"onll", "氘"},
	{"onlll", "氚"},
	{"onlln", "氟"},
	{"onln", "刉"},
	{"onlwl", "氠"},
	{"onmcw", "氥"},
	{"onmk", "侯"},
	{"onmlm", "氬"},
	{"onmu", "佹"},
	{"onmvm", "氫"},
	{"onnhs", "氖"},
	{"onnl", "鄃"},
	{"onno", "歈"},
	{"onob", "偦 氝"},
	{"onog", "雂"},
	{"onp", "忥"},
	{"onqd", "傑"},
	{"onqmb", "氰"},
	{"onri", "儳"},
	{"ontq", "氧"},
	{"onu", "氙"},
	{"onvne", "氯"},
	{"onwa", "𠐔"},
	{"onwd", "𣱣"},
	{"onwk", "氤"},
	{"onwot", "氳"},
	{"onyvo", "氦"},
	{"oo", "从"},
	{"ooah", "傷"},
	{"oobg", "傕"},
	{"oobm", "俎"},
	{"oobo", "肏"},
	{"oog", "倠 坐"},
	{"ooge", "夎"},
	{"oogf", "僬"},
	{"oogs", "儁 㑺"},
	{"ooic", "僋"},
	{"ooii", "伶"},
	{"ooin", "仱"},
	{"ooir", "傖"},
	{"ooj", "仵"},
	{"ooll", "价"},
	{"ooln", "劍"},
	{"ooma", "儈"},
	{"oomb", "倫"},
	{"oombc", "顩"},
	{"oomg", "佺"},
	{"oomn", "偷"},
	{"oomo", "儉"},
	{"oomr", "佮"},
	{"oon", "仡"},
	{"oono", "歛"},
	{"ooo", "众"},
	{"ooog", "侳"},
	{"oooj", "傘"},
	{"oook", "斂"},
	{"oooo", "𠈌"},
	{"oosk", "劔"},
	{"oou", "佡"},
	{"oowy", "侮"},
	{"ooyk", "𠍁"},
	{"op", "伈 化"},
	{"opa", "侚"},
	{"opbuc", "貨 貸"},
	{"opd", "他 柋"},
	{"opg", "垈"},
	{"oph", "佖"},
	{"ophq", "牮"},
	{"opim", "伨"},
	{"opj", "华"},
	{"opko", "儗"},
	{"opkp", "偬"},
	{"oplb", "帒"},
	{"opmc", "傾"},
	{"opok", "敜"},
	{"opp", "仳"},
	{"oppa", "偕"},
	{"opr", "佝"},
	{"opt", "伳"},
	{"optd", "偞"},
	{"opu", "伅 岱"},
	{"opuu", "㑳"},
	{"opwgf", "黛"},
	{"opyhv", "袋"},
	{"oq", "年"},
	{"oqhf", "𠎧"},
	{"oqhk", "偰"},
	{"oqka", "偆"},
	{"oqke", "傣"},
	{"oqkq", "俸"},
	{"oqmb", "倩"},
	{"oqmc", "債"},
	{"oqmf", "傃"},
	{"oqmv", "俵"},
	{"oqo", "伕"},
	{"oqoa", "僣"},
	{"ora", "智"},
	{"orau", "俋"},
	{"orc", "伿"},
	{"ord", "保"},
	{"orhaf", "鴿 鵨 鶬"},
	{"orhr", "侶"},
	{"orhu", "侃"},
	{"ori", "戧"},
	{"orijb", "舖"},
	{"orjrr", "舘"},
	{"orln", "創"},
	{"ormbc", "頜 頷"},
	{"ornin", "舒"},
	{"ornl", "郃"},
	{"orno", "欱"},
	{"orp", "𢜔"},
	{"orrj", "僤"},
	{"orrk", "儼"},
	{"orrr", "偘"},
	{"orsj", "偮"},
	{"oruc", "僎"},
	{"orvk", "俁"},
	{"orxu", "僶"},
	{"orye", "假 敆"},
	{"oryo", "促"},
	{"osav", "偃 𠍾"},
	{"osd", "榘"},
	{"oshi", "仞"},
	{"oshr", "佋"},
	{"osj", "佴"},
	{"osjl", "倻"},
	{"osjr", "倨"},
	{"osk", "伊"},
	{"oskr", "侰"},
	{"osll", "𠈄"},
	{"osme", "侵"},
	{"osmg", "偓 㑌"},
	{"osmgi", "㺱"},
	{"osmh", "僇"},
	{"osmr", "伺"},
	{"osmv", "倀"},
	{"osnd", "僝"},
	{"oso", "伬"},
	{"osp", "伲"},
	{"osqf", "傌"},
	{"osrj", "僻"},
	{"osrr", "傴"},
	{"oss", "佢"},
	{"ossr", "侷"},
	{"ostt", "偋"},
	{"osuu", "倔"},
	{"ota", "借"},
	{"otbc", "倎"},
	{"otc", "供"},
	{"otch", "𠊠"},
	{"otco", "僕 僛"},
	{"otcw", "偤"},
	{"otdd", "橆"},
	{"otf", "無"},
	{"otgi", "儀"},
	{"otgr", "僐"},
	{"othb", "備"},
	{"othn", "𠍆"},
	{"otif", "儰"},
	{"otkr", "偌"},
	{"otlk", "偀"},
	{"otlm", "僅"},
	{"otlo", "傼"},
	{"otmc", "倛 僙"},
	{"otmv", "偡"},
	{"otniq", "舞"},
	{"otog", "儺"},
	{"otq", "佯"},
	{"otqm", "傞"},
	{"otrk", "儆"},
	{"otsj", "傇"},
	{"ott", "併"},
	{"ottb", "傋"},
	{"otw", "㑤"},
	{"otwa", "傮"},
	{"otwb", "㒖"},
	{"otwi", "僔"},
	{"otwn", "儚"},
	{"otwt", "僼 𥂝"},
	{"otwv", "儂"},
	{"otxc", "傔"},
	{"ou", "仙 仚 屳"},
	{"ouami", "罎"},
	{"oubb", "傰"},
	{"oubtu", "罁"},
	{"ouce", "儍"},
	{"oudk", "缺"},
	{"oudm", "缽"},
	{"ouf", "缹"},
	{"oufbh", "𦉘"},
	{"oufbq", "罉"},
	{"ouhmr", "缿"},
	{"oujt", "㒥"},
	{"oulmo", "罀"},
	{"oum", "缸"},
	{"oumb", "偳"},
	{"oumbc", "𩓥"},
	{"oumwj", "罈"},
	{"ouog", "催"},
	{"ouon", "侺"},
	{"ousl", "缷"},
	{"outrg", "罐"},
	{"outt", "缾"},
	{"outwi", "罇"},
	{"ouypd", "罅"},
	{"ouypt", "罏"},
	{"ouypu", "𧇍"},
	{"ovav", "银"},
	{"ovbk", "钢"},
	{"ovbmr", "铜"},
	{"ovhqo", "铁"},
	{"ovii", "僟"},
	{"ovio", "似"},
	{"ovjbc", "镇"},
	{"ovjmo", "锭"},
	{"ovl", "钟"},
	{"ovoii", "铃"},
	{"ovr", "侞"},
	{"ovvv", "儠"},
	{"ow", "佃"},
	{"owbp", "𠏋"},
	{"owd", "倮"},
	{"owg", "俚"},
	{"owjc", "𠍿"},
	{"owjr", "個"},
	{"owks", "侽"},
	{"owlb", "偶"},
	{"owlg", "儸"},
	{"owlv", "儇"},
	{"owmv", "偎"},
	{"owp", "偲"},
	{"owr", "佪"},
	{"owwf", "儽"},
	{"owww", "儡"},
	{"owyi", "每"},
	{"owyta", "韽"},
	{"oy", "仆"},
	{"oyaj", "倬"},
	{"oybc", "偵"},
	{"oybp", "儱"},
	{"oybs", "傍"},
	{"oyck", "佼"},
	{"oydu", "儭"},
	{"oyed", "𠍇"},
	{"oyfe", "俶"},
	{"oyfu", "僦"},
	{"oyg", "住"},
	{"oygq", "㒓"},
	{"oyhn", "伉"},
	{"oyhs", "仿"},
	{"oyhv", "依"},
	{"oyhvf", "緐"},
	{"oyjj", "僆"},
	{"oyk", "伩"},
	{"oykk", "傚"},
	{"oyks", "俲"},
	{"oylm", "企"},
	{"oym", "仩"},
	{"oymp", "佌"},
	{"oymr", "信"},
	{"oymt", "𠈔"},
	{"oymy", "佧"},
	{"oyoj", "倅"},
	{"oyok", "敏"},
	{"oypd", "偨"},
	{"oypp", "儢"},
	{"oyqd", "𠎀"},
	{"oyr", "佔"},
	{"oyra", "儲"},
	{"oyrb", "傐"},
	{"oyrf", "倞"},
	{"oyrn", "停"},
	{"oyro", "儫"},
	{"oyrv", "偯 儴"},
	{"oysk", "倣"},
	{"oyt", "位"},
	{"oyta", "偣"},
	{"oytg", "僮"},
	{"oytj", "傽"},
	{"oyto", "𠎵"},
	{"oytp", "億"},
	{"oytr", "倍"},
	{"oyub", "禽"},
	{"oyvi", "伭"},
	{"oyvo", "侅"},
	{"oyvv", "侫"},
	{"oywm", "儃"},
	{"oyx", "儕"},
	{"oyyib", "𣫺"},
	{"oyyiu", "毓"},
	{"p", "心"},
	{"pa", "旨 旬"},
	{"pafu", "愰"},
	{"pahaf", "鶛"},
	{"pahm", "惺"},
	{"paiu", "慨"},
	{"paks", "勓"},
	{"pam", "怛"},
	{"pamh", "愓"},
	{"pamj", "悍"},
	{"pamo", "惿"},
	{"panb", "憪"},
	{"pank", "憫"},
	{"panl", "郇"},
	{"paph", "惕"},
	{"papp", "惃"},
	{"papv", "愒"},
	{"pate", "懪"},
	{"pav", "恨"},
	{"pawe", "慢"},
	{"payf", "憬"},
	{"pbac", "慏"},
	{"pbbb", "愲"},
	{"pbbe", "懓"},
	{"pbcn", "惻"},
	{"pbg", "墯"},
	{"pbgr", "惆"},
	{"pbhx", "慆"},
	{"pbjj", "惲"},
	{"pbm", "怚"},
	{"pbmc", "惧"},
	{"pbme", "愋"},
	{"pbmp", "懚"},
	{"pbmr", "恫"},
	{"pbou", "愮"},
	{"pbsd", "𢛵"},
	{"pbtu", "𢜟"},
	{"pbtv", "惘"},
	{"pbue", "戄"},
	{"pbug", "懼"},
	{"pbvc", "眞"},
	{"pbvk", "慀"},
	{"pc", "惍"},
	{"pci", "忪"},
	{"pcks", "勩"},
	{"pcnh", "悌"},
	{"pcp", "𢣁"},
	{"pcru", "悅"},
	{"pcwa", "憎"},
	{"pd", "也"},
	{"pdd", "惏"},
	{"pddo", "憷"},
	{"pdhaf", "鵴 𪃸"},
	{"pdi", "忖"},
	{"pdk", "快"},
	{"pdl", "悚"},
	{"pdlc", "懶"},
	{"pdmbc", "穎"},
	{"pdmq", "愇"},
	{"pdwyi", "乸"},
	{"peee", "惙"},
	{"peg", "怪"},
	{"peii", "慅"},
	{"pembc", "潁"},
	{"pfb", "悄"},
	{"pfbf", "戃"},
	{"pfbr", "惝"},
	{"pfd", "匊"},
	{"pfdq", "憐"},
	{"pff", "惔"},
	{"pffr", "𢥏"},
	{"pfmbc", "熲 頴 顈"},
	{"pfmu", "恍"},
	{"pfq", "怑"},
	{"pfqu", "惓"},
	{"pgbt", "㦉"},
	{"pgdi", "恃"},
	{"pggu", "憢"},
	{"pgi", "怯"},
	{"pgni", "懤"},
	{"pgp", "𢙺"},
	{"pgr", "恄"},
	{"pgrr", "憘"},
	{"pgsk", "慠"},
	{"pgth", "憉"},
	{"pgtj", "悻"},
	{"ph", "必"},
	{"pha", "怕 曶"},
	{"phag", "惶"},
	{"phbk", "懊"},
	{"phbq", "甮"},
	{"phbr", "恦"},
	{"phbt", "恤"},
	{"phbuu", "覕"},
	{"phcn", "懰"},
	{"phdb", "憡"},
	{"phdd", "悸"},
	{"phdf", "愀"},
	{"phdn", "悧"},
	{"pher", "恪"},
	{"phgr", "悎"},
	{"phgs", "慟"},
	{"phh", "勿"},
	{"phhn", "匑"},
	{"phi", "愧"},
	{"phj", "忏"},
	{"phjr", "恬"},
	{"phkb", "憍"},
	{"phkp", "悿"},
	{"phlc", "懫"},
	{"phln", "刎"},
	{"phlo", "惞"},
	{"phml", "忻"},
	{"phmr", "㤧"},
	{"phmy", "𢘛"},
	{"phn", "𢖯 𢖾"},
	{"phni", "忛 𢞁"},
	{"phnl", "邲"},
	{"php", "忽"},
	{"phpa", "惛"},
	{"phqm", "性"},
	{"phqo", "怢"},
	{"phs", "怍"},
	{"phsb", "惼"},
	{"phsk", "悷 憿"},
	{"phvp", "忯"},
	{"phwp", "憁"},
	{"phyhv", "袃"},
	{"pi", "勺 勾"},
	{"piav", "悢"},
	{"pibi", "愽"},
	{"pice", "悛"},
	{"pihf", "慽"},
	{"piih", "慘"},
	{"pijb", "匍"},
	{"pijc", "怵"},
	{"pikh", "惨"},
	{"pilb", "慵"},
	{"pile", "慷"},
	{"pim", "勻"},
	{"pir", "怡"},
	{"pirp", "憾"},
	{"pitc", "懭"},
	{"piv", "怴"},
	{"piyr", "惦"},
	{"pjbc", "慎"},
	{"pjbd", "悖"},
	{"pjbo", "懥"},
	{"pjcm", "悾"},
	{"pje", "忮"},
	{"pjhaf", "鴇"},
	{"pjhr", "愘"},
	{"pjii", "慱"},
	{"pjip", "憓"},
	{"pjjl", "慚"},
	{"pjkp", "恅"},
	{"pjlv", "悽"},
	{"pjmf", "悰"},
	{"pjmm", "愃"},
	{"pjnu", "惋"},
	{"pjpn", "懧"},
	{"pjr", "怙"},
	{"pjrr", "悺"},
	{"pjsqf", "駂"},
	{"pjtc", "憤"},
	{"pk", "匁 忕"},
	{"pkcf", "憭"},
	{"pkf", "恢"},
	{"pkk", "匆"},
	{"pkkb", "悕"},
	{"pkkk", "慡"},
	{"pklb", "怖"},
	{"pkld", "𢙨"},
	{"pklq", "肄"},
	{"pklu", "匎 㤿"},
	{"pkmb", "惰"},
	{"pkmbc", "𩓙"},
	{"pkn", "勼 恞"},
	{"pknio", "疑"},
	{"pkno", "欵"},
	{"pkp", "怱"},
	{"pksb", "愶"},
	{"pkss", "恊"},
	{"pl", "忡"},
	{"plbk", "怏"},
	{"plbu", "忱"},
	{"plln", "怫"},
	{"plmc", "憒"},
	{"plmo", "恌"},
	{"plmy", "悱"},
	{"plpc", "懻"},
	{"plw", "怞"},
	{"plwv", "慺"},
	{"pmak", "懨"},
	{"pmam", "恒"},
	{"pmbb", "懦"},
	{"pmbc", "愩 頃"},
	{"pmbe", "懮"},
	{"pmbm", "恆"},
	{"pmcw", "恓"},
	{"pmf", "怀"},
	{"pmfj", "匉 怦"},
	{"pmfm", "怌"},
	{"pmmr", "悟"},
	{"pmmu", "忨"},
	{"pmob", "怲"},
	{"pmrw", "匐 愊"},
	{"pmua", "憯"},
	{"pmwd", "慄 憟"},
	{"pmwf", "慓"},
	{"pmwj", "憛"},
	{"pmwl", "愐"},
	{"pmym", "怔"},
	{"pn", "乜"},
	{"pnau", "悗"},
	{"pnbk", "愌"},
	{"pnbq", "懈"},
	{"pncr", "憺"},
	{"pndt", "𢛴"},
	{"png", "忸"},
	{"pnhb", "憰"},
	{"pnhe", "忣"},
	{"pnib", "悀"},
	{"pnin", "恀"},
	{"pnlb", "憜"},
	{"pno", "忺"},
	{"pnot", "憕"},
	{"pnyi", "惤"},
	{"poae", "愎"},
	{"poah", "慯"},
	{"pod", "恘"},
	{"podi", "㤔"},
	{"pog", "惟"},
	{"poge", "愯"},
	{"pogf", "憔"},
	{"pogs", "懏"},
	{"poii", "怜"},
	{"poim", "懺"},
	{"poin", "忴"},
	{"poip", "惗"},
	{"poir", "愴"},
	{"poj", "忤"},
	{"poju", "匋"},
	{"poma", "懀"},
	{"pomb", "惀"},
	{"pomd", "悇"},
	{"pomg", "恮"},
	{"pomn", "愉"},
	{"pomo", "憸"},
	{"pomr", "恰"},
	{"pon", "忔"},
	{"ponbg", "觺"},
	{"pond", "愾"},
	{"potf", "憮"},
	{"powy", "悔"},
	{"pp", "比 㤈"},
	{"ppa", "恂 恉"},
	{"ppad", "惸"},
	{"ppfd", "粊"},
	{"ppg", "坒"},
	{"pph", "怭"},
	{"ppha", "皆"},
	{"pphp", "惚"},
	{"pphqu", "毞"},
	{"ppp", "惢"},
	{"pppd", "橤"},
	{"pppf", "繠"},
	{"ppph", "毖"},
	{"ppr", "怐"},
	{"ppru", "怉"},
	{"pptd", "惵"},
	{"ppu", "忳"},
	{"ppuk", "恟"},
	{"pqmb", "情"},
	{"pqmf", "愫"},
	{"pr", "句"},
	{"prau", "悒"},
	{"prb", "悁"},
	{"prhaf", "鴝"},
	{"prhg", "悜"},
	{"prhml", "斪"},
	{"prhu", "怳"},
	{"prks", "劬"},
	{"prnin", "够"},
	{"prno", "欨"},
	{"prog", "雊"},
	{"prpa", "惽"},
	{"prrd", "懆"},
	{"prrj", "憚"},
	{"prrs", "愕"},
	{"pru", "包"},
	{"prvk", "悞"},
	{"prvp", "怋"},
	{"prxu", "憴"},
	{"psav", "愝"},
	{"pseg", "慳"},
	{"psh", "切 忉"},
	{"pshr", "怊"},
	{"psit", "懢"},
	{"psjj", "懾"},
	{"psko", "愜"},
	{"psma", "慴"},
	{"psmg", "恇 𢣷"},
	{"psmh", "憀"},
	{"psmi", "憳"},
	{"psmr", "𢘜"},
	{"psmv", "悵"},
	{"psp", "怩"},
	{"psrr", "慪"},
	{"pt", "世"},
	{"pta", "惜"},
	{"ptak", "慔"},
	{"ptbo", "懞"},
	{"ptbuc", "貰"},
	{"pthg", "懂"},
	{"ptkr", "𢜪"},
	{"ptlb", "慲"},
	{"ptlj", "愅"},
	{"ptlm", "慬"},
	{"ptmc", "㥍"},
	{"ptmj", "㦊"},
	{"ptmv", "愖"},
	{"ptor", "匒"},
	{"ptov", "懩"},
	{"ptrg", "懽"},
	{"ptt", "恲"},
	{"ptwa", "慒"},
	{"ptwi", "懱"},
	{"ptwu", "懵"},
	{"ptwv", "憹"},
	{"ptxc", "慊"},
	{"ptyg", "𢤦"},
	{"ptyu", "慌"},
	{"ptyv", "恾"},
	{"pu", "屯"},
	{"puce", "惾"},
	{"pudhe", "皺"},
	{"puf", "炰"},
	{"puhaf", "鶵"},
	{"puk", "匈 忷"},
	{"puln", "刨"},
	{"pumb", "惴"},
	{"pumbc", "頓"},
	{"pumt", "愷"},
	{"punl", "邨 鄒"},
	{"puog", "慛 雛"},
	{"pupu", "芻"},
	{"pve", "怓"},
	{"pvid", "㦡"},
	{"pvis", "怮"},
	{"pvvw", "惱"},
	{"pw", "甸"},
	{"pwbp", "㦙"},
	{"pwc", "怬"},
	{"pwd", "悃 惈"},
	{"pwg", "悝"},
	{"pwim", "慖"},
	{"pwjc", "慣"},
	{"pwkp", "𢞴"},
	{"pwlj", "懌"},
	{"pwlr", "㦒"},
	{"pwls", "愣"},
	{"pwlv", "懁"},
	{"pwmv", "愄"},
	{"pwot", "慍"},
	{"pwp", "愢"},
	{"pwr", "恛"},
	{"pyaj", "悼"},
	{"pyck", "恔"},
	{"pyfu", "憱"},
	{"pyg", "𠣕"},
	{"pyhj", "㦀"},
	{"pyhr", "慥"},
	{"pyia", "𢡠"},
	{"pyk", "忟"},
	{"pymr", "訇 𢚘"},
	{"pyoj", "悴"},
	{"pypo", "懅"},
	{"pyr", "怗"},
	{"pyrd", "惇"},
	{"pyrf", "惊"},
	{"pyrv", "懹"},
	{"pyta", "愔"},
	{"pytg", "憧"},
	{"pytj", "慞"},
	{"pytp", "憶"},
	{"pyv", "忙"},
	{"pyvw", "慉"},
	{"pywd", "懍"},
	{"pywv", "懐 懷"},
	{"pyx", "懠"},
	{"pyy", "忭"},
	{"q", "手"},
	{"qa", "抇"},
	{"qabt", "揾 擝"},
	{"qafu", "㨪"},
	{"qahaf", "𪂹"},
	{"qail", "揤"},
	{"qaiu", "摡"},
	{"qam", "担"},
	{"qame", "𢸶"},
	{"qamh", "揚"},
	{"qamj", "捍"},
	{"qamo", "提"},
	{"qan", "捫"},
	{"qana", "𢵧"},
	{"qanb", "撊"},
	{"qang", "撋"},
	{"qank", "捑"},
	{"qanr", "擱"},
	{"qanw", "攔"},
	{"qapp", "掍"},
	{"qapv", "揭"},
	{"qase", "撮"},
	{"qasm", "搨"},
	{"qate", "㩧"},
	{"qau", "把"},
	{"qav", "拫"},
	{"qawe", "摱"},
	{"qb", "抈"},
	{"qbb", "掤"},
	{"qbbb", "搰"},
	{"qbbe", "授"},
	{"qbbr", "𢰸"},
	{"qbbsd", "靜"},
	{"qbbuu", "靚"},
	{"qbcd", "探"},
	{"qbcv", "攖"},
	{"qbd", "採"},
	{"qbdi", "捋"},
	{"qbfmu", "靗"},
	{"qbhaf", "鶄"},
	{"qbhhh", "𩇕"},
	{"qbhx", "搯"},
	{"qbjj", "揮"},
	{"qbjmo", "靛"},
	{"qbkf", "撚"},
	{"qbm", "抯"},
	{"qbme", "援"},
	{"qbmr", "挏"},
	{"qbnau", "靘"},
	{"qbnd", "捊"},
	{"qbnl", "郬"},
	{"qbond", "靝"},
	{"qbou", "搖"},
	{"qbq", "拥"},
	{"qbsd", "掙"},
	{"qbu", "𢫏"},
	{"qbue", "攫"},
	{"qbuu", "挸"},
	{"qbv", "挼"},
	{"qc", "扒"},
	{"qchq", "掰"},
	{"qcks", "勣"},
	{"qcnh", "挮"},
	{"qcno", "撳"},
	{"qcru", "挩"},
	{"qcsh", "扮"},
	{"qd", "耒"},
	{"qdam", "揸"},
	{"qdau", "耙"},
	{"qdb", "拺"},
	{"qdbm", "耝"},
	{"qdbms", "耡"},
	{"qdd", "㨆"},
	{"qddf", "㩒"},
	{"qdfbr", "耥"},
	{"qdffs", "耮"},
	{"qdfh", "耖"},
	{"qdhe", "披"},
	{"qdhqu", "耗"},
	{"qdidr", "耱"},
	{"qdir", "耛"},
	{"qdj", "抹"},
	{"qdk", "抉"},
	{"qdksr", "耞"},
	{"qdln", "揦"},
	{"qdlwv", "耬"},
	{"qdmbc", "頛"},
	{"qdmbe", "耰"},
	{"qdmmi", "耘"},
	{"qdmvi", "耨"},
	{"qdnd", "耔"},
	{"qdomr", "耠"},
	{"qdqdd", "䆐"},
	{"qdrlr", "耜"},
	{"qdss", "耟"},
	{"qdta", "耤"},
	{"qdtoe", "耯"},
	{"qdtt", "耕"},
	{"qdttb", "耩"},
	{"qdtvi", "𦔒"},
	{"qdwf", "揀"},
	{"qdwlb", "耦"},
	{"qdybs", "耪"},
	{"qec", "鋬"},
	{"qeed", "搡"},
	{"qeee", "掇"},
	{"qeem", "𢶣"},
	{"qefh", "挱"},
	{"qei", "扠"},
	{"qeii", "搔"},
	{"qfb", "捎"},
	{"qfbf", "攩"},
	{"qfbg", "摚"},
	{"qfbk", "撇"},
	{"qfbq", "撐 撑"},
	{"qfbw", "擋"},
	{"qff", "掞"},
	{"qffd", "㩞"},
	{"qffs", "撈"},
	{"qfh", "抄"},
	{"qfhs", "挘"},
	{"qfhu", "㨘"},
	{"qfq", "拌"},
	{"qfqu", "捲"},
	{"qfyaj", "繛"},
	{"qgb", "抩"},
	{"qgdi", "持"},
	{"qgg", "挂"},
	{"qggu", "撓"},
	{"qggy", "掛"},
	{"qgi", "抾"},
	{"qgit", "搕"},
	{"qgji", "𢴇"},
	{"qglc", "捇"},
	{"qgni", "擣"},
	{"qgr", "拮"},
	{"qgrc", "擷"},
	{"qgrg", "擡"},
	{"qgsk", "𢳆"},
	{"qha", "拍"},
	{"qhag", "揘"},
	{"qhai", "𢯊"},
	{"qhal", "擳"},
	{"qham", "𢴈"},
	{"qhau", "搗"},
	{"qhbf", "攥"},
	{"qhbk", "擙"},
	{"qhbu", "攪"},
	{"qhcq", "攑"},
	{"qhd", "栔"},
	{"qhdf", "揪"},
	{"qhdv", "捼"},
	{"qhdw", "播"},
	{"qhe", "扳 洯"},
	{"qhej", "捀"},
	{"qher", "挌"},
	{"qhfb", "𢶠"},
	{"qhgr", "捁"},
	{"qhgu", "㧥"},
	{"qhhj", "捭"},
	{"qhhv", "挀"},
	{"qhio", "抸"},
	{"qhj", "扦"},
	{"qhjg", "揰"},
	{"qhjm", "捶"},
	{"qhjr", "括"},
	{"qhju", "揗"},
	{"qhjx", "插"},
	{"qhk", "契 扷"},
	{"qhkb", "撟"},
	{"qhkm", "𢶍"},
	{"qhkp", "掭"},
	{"qhlmi", "蛪"},
	{"qhlo", "抓 掀"},
	{"qhml", "折"},
	{"qhmy", "拆"},
	{"qhnbg", "觢"},
	{"qhne", "投"},
	{"qhoa", "揝"},
	{"qhoo", "摐 𢲛"},
	{"qhor", "撘"},
	{"qhp", "恝 托"},
	{"qhpm", "抵"},
	{"qhq", "挈"},
	{"qhqo", "抶"},
	{"qhrf", "摀"},
	{"qhs", "拃"},
	{"qhsb", "掮 揙"},
	{"qhsk", "捩 撽"},
	{"qhsm", "搧"},
	{"qhuc", "攢"},
	{"qhul", "擤"},
	{"qhuo", "擨"},
	{"qhuu", "撬"},
	{"qhv", "㛃"},
	{"qhvif", "絜"},
	{"qhvl", "抑"},
	{"qhvp", "扺"},
	{"qhwp", "摠"},
	{"qhxe", "搜"},
	{"qhxm", "捏 揑"},
	{"qhxu", "掜"},
	{"qhye", "搬"},
	{"qhymu", "齧"},
	{"qhyu", "搋"},
	{"qi", "找"},
	{"qibi", "搏"},
	{"qice", "捘"},
	{"qidy", "攠"},
	{"qihf", "搣 摵"},
	{"qihm", "掋"},
	{"qihu", "抁"},
	{"qihv", "揻"},
	{"qiih", "摻"},
	{"qiil", "𢲲"},
	{"qij", "𢫨"},
	{"qijb", "捕"},
	{"qije", "捄"},
	{"qikf", "撝"},
	{"qikk", "拔"},
	{"qiku", "扰"},
	{"qilr", "搪"},
	{"qine", "𢫕"},
	{"qing", "㨩"},
	{"qioi", "捬"},
	{"qiok", "挨"},
	{"qipd", "攗"},
	{"qipm", "拭"},
	{"qipw", "攟"},
	{"qir", "抬"},
	{"qirm", "掝"},
	{"qirp", "撼"},
	{"qis", "护"},
	{"qit", "拚 𢬿"},
	{"qitc", "擴"},
	{"qitf", "摭"},
	{"qixp", "摝"},
	{"qiyr", "掂"},
	{"qj", "丯 丰"},
	{"qjbc", "搷"},
	{"qjbd", "挬"},
	{"qjbf", "擦 𢱢"},
	{"qjbj", "揇"},
	{"qjbm", "㨁"},
	{"qjbv", "攮"},
	{"qjck", "𢲷"},
	{"qjcm", "控"},
	{"qjcn", "挖"},
	{"qjco", "搲 𢱑"},
	{"qjcs", "搾"},
	{"qjcv", "攛"},
	{"qje", "技"},
	{"qjhp", "挓"},
	{"qjhr", "揢"},
	{"qjhu", "抭"},
	{"qjii", "摶"},
	{"qjji", "撠"},
	{"qjjj", "搟 擀"},
	{"qjjl", "摲"},
	{"qjjn", "㨴"},
	{"qjk", "扙"},
	{"qjks", "拷"},
	{"qjlo", "捷"},
	{"qjlv", "捿"},
	{"qjmc", "擯"},
	{"qjmm", "揎"},
	{"qjmo", "掟"},
	{"qjmr", "砉"},
	{"qjmu", "捖"},
	{"qjnl", "邦 鄻"},
	{"qjnu", "捥"},
	{"qjoa", "摍"},
	{"qjp", "拕"},
	{"qjpa", "搘"},
	{"qjpn", "擰"},
	{"qjqp", "攇"},
	{"qjqr", "搳"},
	{"qjru", "𢭪"},
	{"qjsm", "彗"},
	{"qjsmf", "熭"},
	{"qjsmp", "慧"},
	{"qjto", "攓"},
	{"qjtv", "攐"},
	{"qjv", "按"},
	{"qjwj", "捙"},
	{"qka", "春"},
	{"qkali", "蠢"},
	{"qkap", "惷"},
	{"qkce", "摋"},
	{"qkcf", "撩"},
	{"qkdi", "寿"},
	{"qke", "泰"},
	{"qkf", "拻"},
	{"qkhd", "秦"},
	{"qkhk", "奏"},
	{"qkhx", "舂"},
	{"qkhxp", "憃"},
	{"qkja", "撦"},
	{"qkjt", "捹"},
	{"qkkb", "𢯎"},
	{"qklb", "抪"},
	{"qkld", "拵"},
	{"qklu", "掩"},
	{"qkmf", "捺"},
	{"qkmr", "掎"},
	{"qkms", "挎"},
	{"qkoo", "挾"},
	{"qkq", "奉"},
	{"qkrd", "𢱌"},
	{"qks", "扐"},
	{"qksb", "搚"},
	{"qksj", "𢱕"},
	{"qkso", "摦"},
	{"qkss", "拹"},
	{"qkus", "拋"},
	{"qla", "晢"},
	{"qlbk", "抰"},
	{"qlbu", "抌"},
	{"qlc", "銴"},
	{"qle", "捸"},
	{"qlf", "焎"},
	{"qllb", "帮"},
	{"qllmi", "蜇"},
	{"qlln", "拂"},
	{"qlmc", "撌"},
	{"qlmo", "挑"},
	{"qlmr", "硩"},
	{"qlmy", "排"},
	{"qlp", "悊"},
	{"qlpb", "揹"},
	{"qlr", "哲"},
	{"qlryo", "踅"},
	{"qlvk", "擻"},
	{"qlw", "抽"},
	{"qlwl", "抻"},
	{"qlwp", "拽"},
	{"qlwv", "摟"},
	{"qlx", "㩋"},
	{"qlyhv", "裚"},
	{"qlymr", "誓"},
	{"qm", "扛"},
	{"qma", "𢫦"},
	{"qmak", "擫"},
	{"qmam", "𢬎"},
	{"qmb", "青"},
	{"qmbb", "擩"},
	{"qmbc", "摃"},
	{"qmbe", "擾"},
	{"qmbg", "攉"},
	{"qmblm", "靑"},
	{"qmbs", "摴"},
	{"qmbuc", "責"},
	{"qmbv", "𢸍"},
	{"qmbw", "擂"},
	{"qmd", "扜"},
	{"qmdm", "攊"},
	{"qmf", "抔"},
	{"qmfj", "抨"},
	{"qmg", "抂"},
	{"qmgg", "捱"},
	{"qmgn", "捯"},
	{"qmgt", "挵"},
	{"qmhe", "麦"},
	{"qmia", "搢"},
	{"qmig", "挃"},
	{"qmj", "扞"},
	{"qmjk", "撖"},
	{"qmlk", "挭"},
	{"qmlm", "掗"},
	{"qmmi", "抎"},
	{"qmmp", "攦"},
	{"qmmr", "捂"},
	{"qmmu", "抏"},
	{"qmmv", "振"},
	{"qmn", "打"},
	{"qmob", "抦"},
	{"qmr", "拓"},
	{"qmrb", "搹"},
	{"qmre", "揼"},
	{"qmrt", "𢭃"},
	{"qmrw", "揊"},
	{"qmso", "㧻"},
	{"qmsu", "扼"},
	{"qmto", "撅"},
	{"qmu", "扤"},
	{"qmua", "撍"},
	{"qmv", "表"},
	{"qmvif", "素"},
	{"qmvm", "挳"},
	{"qmwd", "搮"},
	{"qmwf", "摽"},
	{"qmwj", "撢"},
	{"qmwyf", "纛"},
	{"qmwyi", "毒"},
	{"qnau", "挽"},
	{"qnbg", "捔"},
	{"qnbk", "換"},
	{"qnbq", "𢶷"},
	{"qncr", "擔"},
	{"qndf", "搎"},
	{"qndt", "掹"},
	{"qnem", "拯"},
	{"qng", "扭"},
	{"qnhd", "揉"},
	{"qnhe", "扱"},
	{"qnhs", "扔"},
	{"qnhx", "掐"},
	{"qnib", "捅"},
	{"qnin", "抒 拸"},
	{"qnkg", "挺"},
	{"qnkm", "挻"},
	{"qnkq", "揵"},
	{"qnlb", "撱"},
	{"qnlo", "𢵌"},
	{"qnmm", "搦"},
	{"qno", "扻"},
	{"qnob", "揟"},
	{"qnoe", "撥"},
	{"qnok", "揆"},
	{"qnot", "撜"},
	{"qnri", "攙"},
	{"qnwa", "擼"},
	{"qo", "夫"},
	{"qoa", "替"},
	{"qoah", "摥"},
	{"qob", "抐"},
	{"qobg", "搉"},
	{"qobuc", "賛"},
	{"qobuu", "規"},
	{"qodi", "拊"},
	{"qog", "推"},
	{"qogb", "㩦"},
	{"qogs", "携"},
	{"qohaf", "鳺"},
	{"qohg", "拰"},
	{"qohh", "抮"},
	{"qoii", "拎"},
	{"qoim", "攕"},
	{"qoin", "扲"},
	{"qoip", "捻"},
	{"qoir", "搶"},
	{"qoiv", "搇"},
	{"qojwj", "輦"},
	{"qoll", "扴"},
	{"qomb", "掄"},
	{"qomd", "捈"},
	{"qomg", "拴"},
	{"qomn", "揄"},
	{"qomo", "撿"},
	{"qomq", "𢲡"},
	{"qomr", "拾 捨"},
	{"qomt", "揜"},
	{"qon", "扢"},
	{"qonl", "邞"},
	{"qooa", "𢵄"},
	{"qoog", "挫"},
	{"qopd", "拖"},
	{"qorq", "搿"},
	{"qotf", "撫"},
	{"qowy", "挴"},
	{"qoya", "摿"},
	{"qoyb", "擒"},
	{"qpa", "指"},
	{"qpd", "扡"},
	{"qpfd", "掬"},
	{"qphp", "㧾"},
	{"qpi", "扚 抅"},
	{"qpko", "擬"},
	{"qpmm", "揯"},
	{"qpou", "掏"},
	{"qpp", "批"},
	{"qppa", "揩"},
	{"qpr", "拘"},
	{"qpru", "抱"},
	{"qpt", "抴"},
	{"qptd", "揲"},
	{"qpu", "扽"},
	{"qpuu", "搊"},
	{"qpyr", "揈"},
	{"qqhk", "揳"},
	{"qqjl", "挷"},
	{"qqka", "𢰦"},
	{"qqkd", "搸"},
	{"qqkk", "揍"},
	{"qqkq", "捧"},
	{"qqmb", "掅"},
	{"qqo", "扶"},
	{"qqoj", "攆"},
	{"qqou", "摫"},
	{"qqq", "掱"},
	{"qqu", "扥"},
	{"qr", "扣"},
	{"qrau", "挹"},
	{"qrb", "捐"},
	{"qrbc", "損"},
	{"qrlb", "𢬢"},
	{"qrln", "剨"},
	{"qrrd", "操"},
	{"qrrj", "撣"},
	{"qrsh", "拐"},
	{"qrsj", "揖"},
	{"qrsn", "捌"},
	{"qruc", "撰"},
	{"qrvp", "抿"},
	{"qryo", "捉"},
	{"qs", "韦"},
	{"qsav", "揠"},
	{"qseg", "摼 擓"},
	{"qshe", "𢲈"},
	{"qshi", "扨"},
	{"qshr", "招"},
	{"qshu", "捤"},
	{"qsit", "㩜"},
	{"qsj", "挕"},
	{"qsje", "掫"},
	{"qsjj", "攝"},
	{"qsjl", "揶"},
	{"qsjr", "据"},
	{"qskr", "捃"},
	{"qslb", "㧜"},
	{"qsll", "挋"},
	{"qsma", "摺"},
	{"qsmb", "掃"},
	{"qsmg", "握 擢"},
	{"qsmh", "摎"},
	{"qsmi", "撏"},
	{"qsmv", "掁"},
	{"qsp", "抳"},
	{"qsql", "挪"},
	{"qsrj", "擗"},
	{"qsrr", "摳"},
	{"qss", "拒"},
	{"qssr", "挶"},
	{"qstt", "摒"},
	{"qstv", "搌"},
	{"qsuu", "掘"},
	{"qswu", "攬"},
	{"qsyq", "摨"},
	{"qta", "措"},
	{"qtak", "摸"},
	{"qtav", "擖"},
	{"qtbc", "捵"},
	{"qtbf", "攃 𢶕"},
	{"qtbk", "撒"},
	{"qtbn", "揃"},
	{"qtc", "拱"},
	{"qtce", "𢹸"},
	{"qtcl", "撕"},
	{"qtco", "撲"},
	{"qtct", "搤"},
	{"qtcw", "揂"},
	{"qtgi", "𢷮"},
	{"qtjp", "𢶤"},
	{"qtkl", "擲"},
	{"qtm", "拑"},
	{"qtmc", "掑 撗"},
	{"qtmj", "撶"},
	{"qtmv", "揕"},
	{"qtod", "搽"},
	{"qtoe", "擭"},
	{"qtog", "攤"},
	{"qtor", "搭"},
	{"qtov", "攁"},
	{"qtpd", "擛"},
	{"qtqm", "搓"},
	{"qtqu", "撯"},
	{"qtrk", "擏"},
	{"qtt", "拼"},
	{"qttb", "搆"},
	{"qttc", "掽"},
	{"qtub", "搠"},
	{"qtw", "描"},
	{"qtwi", "撙"},
	{"qtwv", "擃"},
	{"qtxc", "搛"},
	{"qu", "扎"},
	{"qud", "槼"},
	{"qumb", "揣"},
	{"qumrb", "鬹"},
	{"quob", "攜"},
	{"quog", "摧"},
	{"quos", "㩗 𢹂"},
	{"quu", "拙"},
	{"quv", "嫢"},
	{"quvif", "紥"},
	{"qvfe", "𢲩"},
	{"qvfi", "𢺳"},
	{"qvid", "擽"},
	{"qvio", "拟"},
	{"qvis", "抝 拗"},
	{"qvno", "掾"},
	{"qvoi", "攭"},
	{"qvvd", "摷"},
	{"qvvn", "拶"},
	{"qvvv", "擸"},
	{"qwd", "捆 捰"},
	{"qwg", "捚"},
	{"qwhr", "撂"},
	{"qwim", "摑"},
	{"qwjc", "摜"},
	{"qwk", "㧢"},
	{"qwkp", "摁"},
	{"qwl", "押"},
	{"qwlg", "攞"},
	{"qwli", "擉"},
	{"qwlj", "擇"},
	{"qwlp", "擺"},
	{"qwlv", "擐"},
	{"qwmv", "揋"},
	{"qwot", "搵"},
	{"qwp", "揌"},
	{"qwtj", "𢳂"},
	{"qwvf", "摞"},
	{"qwwv", "攌"},
	{"qwyi", "拇"},
	{"qy", "扑"},
	{"qyaj", "掉"},
	{"qybb", "揥 撾"},
	{"qybc", "揁"},
	{"qybg", "攡"},
	{"qybk", "撤"},
	{"qybp", "攏"},
	{"qybs", "搒"},
	{"qycb", "摘"},
	{"qyck", "挍"},
	{"qydk", "撴"},
	{"qyg", "拄"},
	{"qygq", "撻"},
	{"qyhj", "摓"},
	{"qyhn", "抗"},
	{"qyhr", "搥"},
	{"qyhv", "挔"},
	{"qyij", "摔"},
	{"qyj", "抖"},
	{"qyjj", "摙"},
	{"qyk", "抆"},
	{"qylh", "捗"},
	{"qylm", "扯"},
	{"qymb", "掯"},
	{"qyoj", "捽"},
	{"qyok", "掖"},
	{"qypo", "據"},
	{"qypp", "攄"},
	{"qyps", "擄"},
	{"qypt", "攎"},
	{"qyr", "拈"},
	{"qyrb", "搞"},
	{"qyrd", "㨃"},
	{"qyrf", "掠 𢴒"},
	{"qyrn", "揨 攍 㧸"},
	{"qyrv", "攘"},
	{"qysd", "揓 𢰧"},
	{"qyso", "㨗"},
	{"qyt", "拉"},
	{"qyta", "揞"},
	{"qytg", "撞"},
	{"qytr", "掊"},
	{"qytu", "摬"},
	{"qytv", "接"},
	{"qyub", "摛"},
	{"qyvg", "擁"},
	{"qyvw", "搐"},
	{"qywm", "擅"},
	{"qyx", "擠"},
	{"qyy", "抃"},
	{"qyyb", "擿"},
	{"r", "口"},
	{"raa", "唱"},
	{"rail", "唧"},
	{"raiu", "嘅"},
	{"rajv", "𠹵"},
	{"ram", "呾"},
	{"ramj", "哻"},
	{"ranh", "𠻻"},
	{"rank", "㘚"},
	{"ranx", "嚪"},
	{"rapv", "喝"},
	{"rase", "嘬"},
	{"rate", "嚗"},
	{"rau", "吧 邑"},
	{"rav", "哏"},
	{"rawe", "𠼦"},
	{"raye", "敯"},
	{"rayf", "𠾶"},
	{"rb", "肙"},
	{"rbbb", "嗗"},
	{"rbbe", "噯"},
	{"rbbr", "喎"},
	{"rbcv", "嚶"},
	{"rbd", "啋"},
	{"rbdi", "哷"},
	{"rbgr", "啁"},
	{"rbhaf", "鵑"},
	{"rbhx", "㗖"},
	{"rbm", "咀"},
	{"rbmr", "哃"},
	{"rbou", "嗂"},
	{"rbsd", "𠲜"},
	{"rbsmr", "嗣"},
	{"rbss", "𠱂"},
	{"rbtk", "𠹻"},
	{"rbuc", "員 唄"},
	{"rbuu", "哯"},
	{"rbv", "哸"},
	{"rbvk", "嗘"},
	{"rbwi", "嚼"},
	{"rbyp", "𡄯"},
	{"rc", "只 叭 唫"},
	{"rcah", "𡃶"},
	{"rcim", "嗡"},
	{"rckn", "嗲"},
	{"rcks", "勛"},
	{"rcl", "吖"},
	{"rcms", "𠯋"},
	{"rcnl", "鄖"},
	{"rcor", "唂"},
	{"rcsh", "吩"},
	{"rcte", "𡆇"},
	{"rcwa", "噌"},
	{"rcyq", "𡅈"},
	{"rd", "呆 㕲"},
	{"rdam", "喳"},
	{"rdd", "啉"},
	{"rddf", "噤"},
	{"rdhqu", "氉"},
	{"rdhr", "𠺝"},
	{"rdi", "吋"},
	{"rdk", "吷"},
	{"rdlc", "𡃤"},
	{"rdln", "劋 喇"},
	{"rdlo", "嗽"},
	{"rdm", "呠"},
	{"rdmg", "𠶖"},
	{"rdmk", "𠼰"},
	{"rdmq", "喡"},
	{"rdnl", "鄵"},
	{"rdoo", "唻"},
	{"rdqq", "𠾴"},
	{"rdrd", "槑"},
	{"rdrj", "𡀞"},
	{"rdyn", "𠵉"},
	{"rea", "𠴲"},
	{"rebb", "𠿭"},
	{"rede", "啵"},
	{"reed", "嗓"},
	{"reee", "啜"},
	{"refh", "唦"},
	{"rehp", "𠻹"},
	{"reiv", "𠺘"},
	{"rejf", "𡄽"},
	{"reoy", "嗨"},
	{"rf", "吙"},
	{"rfb", "哨"},
	{"rfba", "嚐"},
	{"rfbc", "嗩"},
	{"rfbg", "嘡"},
	{"rfbn", "𠸑"},
	{"rfbw", "噹"},
	{"rfd", "咪"},
	{"rfdj", "𠺫"},
	{"rfdq", "噒"},
	{"rff", "啖"},
	{"rffs", "嘮"},
	{"rfh", "吵"},
	{"rfkt", "𡃇"},
	{"rfmu", "咣"},
	{"rfog", "𠻘"},
	{"rfqu", "啳"},
	{"rg", "吐"},
	{"rgb", "呥"},
	{"rgbt", "噎"},
	{"rgcc", "嚇"},
	{"rgg", "哇"},
	{"rggu", "嘵"},
	{"rggy", "啩"},
	{"rghaf", "鷕"},
	{"rgi", "呿"},
	{"rgis", "𠲵"},
	{"rgit", "嗑"},
	{"rgkc", "嚽"},
	{"rglc", "哧"},
	{"rgni", "嚋"},
	{"rgnl", "郢"},
	{"rgob", "𡁻"},
	{"rgou", "𠺬"},
	{"rgpd", "哋"},
	{"rgr", "咭"},
	{"rgrr", "嘻"},
	{"rgsk", "嗷"},
	{"rgth", "嘭"},
	{"rgtj", "啈"},
	{"rgwc", "𡂝"},
	{"rgwg", "𠹺"},
	{"rgyo", "唗"},
	{"rha", "㕷"},
	{"rhad", "嘄"},
	{"rhaf", "鳴"},
	{"rhag", "喤"},
	{"rhai", "啲"},
	{"rhaj", "嗥"},
	{"rhal", "㘉"},
	{"rhap", "唣"},
	{"rhbk", "噢"},
	{"rhbn", "𠶜"},
	{"rhbr", "响"},
	{"rhbu", "咱"},
	{"rhdf", "啾"},
	{"rhdn", "唎"},
	{"rhdp", "𡀝"},
	{"rhdr", "啝"},
	{"rhdw", "噃"},
	{"rher", "咯"},
	{"rhey", "咚"},
	{"rhfb", "𠿫"},
	{"rhfd", "呼"},
	{"rhg", "呈"},
	{"rhgi", "𠲍"},
	{"rhgr", "哠"},
	{"rhhe", "嚟"},
	{"rhhj", "啤"},
	{"rhhk", "㗛"},
	{"rhhv", "哌"},
	{"rhi", "𠺌 吆"},
	{"rhjd", "咮"},
	{"rhjm", "唾"},
	{"rhjr", "咶"},
	{"rhjx", "喢"},
	{"rhk", "㕭"},
	{"rhkb", "嘺"},
	{"rhkp", "㖭"},
	{"rhml", "听"},
	{"rhmo", "噬"},
	{"rhnd", "哚 𠼝"},
	{"rhoa", "喒"},
	{"rhoo", "嘥"},
	{"rhoq", "𠷈"},
	{"rhor", "㗳"},
	{"rhp", "吒"},
	{"rhpm", "呧"},
	{"rhq", "吽"},
	{"rhqi", "哦"},
	{"rhqu", "㕰"},
	{"rhr", "呂"},
	{"rhrf", "嗚"},
	{"rhrn", "𠵯"},
	{"rhs", "咋"},
	{"rhsk", "唳 噭"},
	{"rht", "呏"},
	{"rhu", "兄"},
	{"rhuc", "囋"},
	{"rhuj", "嘷"},
	{"rhuk", "嗅"},
	{"rhul", "嚊"},
	{"rhvo", "呱"},
	{"rhwg", "囖"},
	{"rhxe", "嗖"},
	{"rhxu", "唲"},
	{"rhyu", "嗁"},
	{"ri", "𠯫"},
	{"ribp", "𠹌"},
	{"rice", "唆"},
	{"ridi", "嚒"},
	{"ridq", "嚤"},
	{"rifb", "𡁜"},
	{"rift", "𡅏"},
	{"rihf", "嘁"},
	{"rihq", "哞"},
	{"rihr", "喊"},
	{"rihu", "吮"},
	{"rihv", "喴"},
	{"riil", "啷"},
	{"rijb", "哺"},
	{"rijc", "嘛"},
	{"rik", "吠"},
	{"rikf", "噅"},
	{"rill", "㖄"},
	{"rimi", "唥"},
	{"rine", "咏"},
	{"riog", "雖"},
	{"riok", "唉"},
	{"ripp", "𠳓"},
	{"rir", "咍"},
	{"ritc", "嚝"},
	{"rite", "喥"},
	{"ritf", "嗻"},
	{"riuh", "哤"},
	{"riyr", "𠶧"},
	{"rj", "叶"},
	{"rjal", "嘟"},
	{"rjbc", "嗔"},
	{"rjbd", "哱"},
	{"rjbf", "嗦 嚓"},
	{"rjbj", "喃"},
	{"rjbm", "𠵌"},
	{"rjbo", "嚏"},
	{"rjbv", "囔"},
	{"rjca", "噾"},
	{"rjd", "味"},
	{"rje", "吱"},
	{"rjhaf", "鷤"},
	{"rjhp", "咤"},
	{"rjhr", "喀"},
	{"rji", "戢 戰"},
	{"rjig", "𡁶"},
	{"rjjb", "嘲"},
	{"rjji", "囀 𠽤"},
	{"rjjj", "𡆀"},
	{"rjka", "啫"},
	{"rjkd", "哮"},
	{"rjkp", "咾"},
	{"rjks", "𠱼"},
	{"rjlo", "啑"},
	{"rjmm", "喧"},
	{"rjmmv", "辴"},
	{"rjmo", "啶 𠺢"},
	{"rjmu", "唍"},
	{"rjnl", "鄲"},
	{"rjon", "嘜"},
	{"rjp", "咜"},
	{"rjpa", "嗜"},
	{"rjpn", "嚀"},
	{"rjpu", "嘧"},
	{"rjqr", "嗐"},
	{"rjr", "咕"},
	{"rjrb", "㗅"},
	{"rjrc", "𡅅"},
	{"rjrr", "𠴨"},
	{"rjru", "𠳭"},
	{"rjstv", "囅"},
	{"rjt", "𠱥"},
	{"rjtc", "噴"},
	{"rjtg", "噻"},
	{"rjv", "咹"},
	{"rjwj", "唓"},
	{"rka", "暋"},
	{"rkbl", "喐"},
	{"rkbu", "睯"},
	{"rkcf", "嘹"},
	{"rkf", "咴"},
	{"rkgg", "喹"},
	{"rki", "吰 呔"},
	{"rkkb", "唏"},
	{"rklb", "咘"},
	{"rklu", "唵"},
	{"rkm", "咗"},
	{"rkmr", "𠵇"},
	{"rkn", "咦"},
	{"rkoi", "𡁯"},
	{"rkoo", "唊"},
	{"rkp", "愍"},
	{"rkrd", "㗎"},
	{"rkrf", "𡃉"},
	{"rks", "另 叻"},
	{"rksb", "嗋"},
	{"rksj", "𠸊"},
	{"rksr", "咖"},
	{"rlb", "吊"},
	{"rlgm", "㗲"},
	{"rlln", "咈"},
	{"rlmc", "嘳"},
	{"rlmo", "咷"},
	{"rlmt", "嚍"},
	{"rlmy", "啡"},
	{"rlon", "𠸐"},
	{"rlwl", "呻"},
	{"rlwu", "黾"},
	{"rlwv", "嘍"},
	{"rlx", "嘯"},
	{"rmam", "咺"},
	{"rmamh", "踼"},
	{"rmamo", "踶"},
	{"rmanw", "躝"},
	{"rmaph", "踢"},
	{"rmasm", "蹋"},
	{"rmau", "跁"},
	{"rmav", "跟"},
	{"rmb", "跀"},
	{"rmbb", "嚅 𨂃"},
	{"rmbbb", "𨃴"},
	{"rmbc", "嗊"},
	{"rmbd", "踩"},
	{"rmbe", "嚘"},
	{"rmbg", "嚯"},
	{"rmbhx", "蹈"},
	{"rmbi", "嘠"},
	{"rmbkf", "蹨"},
	{"rmbm", "跙 𠽌"},
	{"rmbsd", "踭"},
	{"rmbt", "跚"},
	{"rmbue", "躩"},
	{"rmbug", "躣"},
	{"rmbvk", "蹊"},
	{"rmc", "趴"},
	{"rmcw", "哂 唒"},
	{"rmcwa", "蹭"},
	{"rmd", "吁"},
	{"rmdam", "蹅"},
	{"rmdhe", "跛"},
	{"rmdk", "趹"},
	{"rmdm", "嚦"},
	{"rmdoo", "𨂐"},
	{"rmea", "踏"},
	{"rmei", "䟕"},
	{"rmf", "吥"},
	{"rmfb", "踃"},
	{"rmfbg", "蹚"},
	{"rmfbh", "𨅝"},
	{"rmfbr", "䠀"},
	{"rmfbw", "𨆉"},
	{"rmfcb", "蹐"},
	{"rmfdq", "蹸"},
	{"rmffe", "躞"},
	{"rmfj", "呯"},
	{"rmfm", "呸"},
	{"rmfq", "跘"},
	{"rmfqu", "踡"},
	{"rmfr", "𠳝"},
	{"rmgce", "踜"},
	{"rmgcg", "踛"},
	{"rmgdi", "跱"},
	{"rmgg", "啀 跬"},
	{"rmggu", "蹺"},
	{"rmgni", "躊"},
	{"rmgt", "哢"},
	{"rmgyo", "跿"},
	{"rmhdf", "踿"},
	{"rmhdv", "踒"},
	{"rmhdw", "蹯"},
	{"rmher", "路"},
	{"rmhgu", "跣"},
	{"rmhhj", "䠋"},
	{"rmhhw", "蹓"},
	{"rmhjd", "跦"},
	{"rmhjg", "踵"},
	{"rmhk", "跃"},
	{"rmhkb", "蹻"},
	{"rmhlb", "踽"},
	{"rmhlc", "躓"},
	{"rmhml", "斲"},
	{"rmhmy", "跅"},
	{"rmhnd", "跺"},
	{"rmhoo", "蹝 蹤"},
	{"rmhqo", "跌"},
	{"rmhs", "䟭"},
	{"rmhsb", "蹁"},
	{"rmhsk", "躈"},
	{"rmhuc", "躦"},
	{"rmhyu", "蹏"},
	{"rmiav", "踉"},
	{"rmice", "踆"},
	{"rmig", "咥"},
	{"rmigi", "躕"},
	{"rmii", "踐"},
	{"rmikk", "跋"},
	{"rmir", "跆"},
	{"rmism", "𨃩"},
	{"rmite", "踱"},
	{"rmitf", "蹠"},
	{"rmiwg", "躔"},
	{"rmixp", "蹗"},
	{"rmiyr", "踮"},
	{"rmjbc", "蹎"},
	{"rmjbj", "𨂾"},
	{"rmjcv", "躥"},
	{"rmje", "跂"},
	{"rmjk", "噉"},
	{"rmjkd", "踍"},
	{"rmjlo", "踕"},
	{"rmjmf", "踪"},
	{"rmjmn", "𨀉"},
	{"rmjnu", "踠"},
	{"rmjoa", "蹜"},
	{"rmjp", "跎"},
	{"rmjr", "跍"},
	{"rmk", "吴"},
	{"rmkmr", "踦"},
	{"rmkms", "跨"},
	{"rmkn", "跠"},
	{"rmkpb", "蹛"},
	{"rmksr", "跏"},
	{"rmlb", "啢"},
	{"rmlk", "哽"},
	{"rmlm", "啞"},
	{"rmlmc", "蹪"},
	{"rmlmo", "跳"},
	{"rmlq", "𨀞"},
	{"rmlwp", "跩"},
	{"rmmcw", "跴"},
	{"rmmd", "趶"},
	{"rmmf", "呩"},
	{"rmmfb", "躎"},
	{"rmmfr", "踎"},
	{"rmmgi", "𨆼"},
	{"rmmi", "呍"},
	{"rmmig", "跮"},
	{"rmmlk", "𨁈"},
	{"rmmmp", "躧"},
	{"rmmmv", "䟴"},
	{"rmmp", "噁"},
	{"rmmr", "唔 跖"},
	{"rmmre", "𨂽"},
	{"rmmrw", "踾"},
	{"rmmt", "趼"},
	{"rmmto", "蹶"},
	{"rmmv", "㖘"},
	{"rmmvm", "踁"},
	{"rmn", "叮"},
	{"rmnbs", "踴"},
	{"rmnhd", "蹂"},
	{"rmnhe", "趿"},
	{"rmnib", "踊"},
	{"rmnin", "跢"},
	{"rmnkq", "踺"},
	{"rmnmu", "跪"},
	{"rmnn", "咧"},
	{"rmnoe", "蹳"},
	{"rmnot", "蹬"},
	{"rmnr", "呵"},
	{"rmodi", "跗"},
	{"rmog", "踓"},
	{"rmohh", "跈"},
	{"rmoi", "𡁷"},
	{"rmoip", "踗"},
	{"rmoir", "蹌"},
	{"rmokr", "踟"},
	{"rmomb", "踚"},
	{"rmomg", "跧"},
	{"rmomn", "踰"},
	{"rmomr", "跲"},
	{"rmon", "趷"},
	{"rmooo", "踨"},
	{"rmoto", "𨆯"},
	{"rmotq", "躌"},
	{"rmou", "𠶲"},
	{"rmowy", "踇"},
	{"rmoym", "𨀣"},
	{"rmpfd", "踘"},
	{"rmpi", "趵"},
	{"rmpmc", "蹞"},
	{"rmpr", "跔"},
	{"rmpru", "跑"},
	{"rmpt", "跇"},
	{"rmptd", "蹀"},
	{"rmqd", "𨀤"},
	{"rmqka", "踳"},
	{"rmqkx", "蹖"},
	{"rmqmc", "蹟"},
	{"rmqo", "趺"},
	{"rmr", "𠰴"},
	{"rmrb", "嗝"},
	{"rmrj", "𠹶"},
	{"rmrr", "𠹭"},
	{"rmrrd", "躁"},
	{"rmrt", "哣"},
	{"rmryo", "踀"},
	{"rmsje", "踙"},
	{"rmsjj", "躡"},
	{"rmsjr", "踞"},
	{"rmsju", "踂"},
	{"rmsmg", "躍"},
	{"rmso", "啄"},
	{"rmsp", "跜"},
	{"rmss", "距"},
	{"rmssr", "跼"},
	{"rmstv", "蹍"},
	{"rmsu", "呃"},
	{"rmsup", "跽"},
	{"rmswu", "𨈇"},
	{"rmt", "咞"},
	{"rmta", "踖"},
	{"rmtag", "躪"},
	{"rmtb", "𡂖"},
	{"rmtce", "躨"},
	{"rmtco", "蹼"},
	{"rmtja", "躇"},
	{"rmtkl", "躑"},
	{"rmtlb", "蹣"},
	{"rmtmc", "踑"},
	{"rmtmj", "𨅯"},
	{"rmtmv", "踸"},
	{"rmto", "噘"},
	{"rmtqa", "躤"},
	{"rmtqm", "蹉"},
	{"rmtt", "跰"},
	{"rmttc", "踫"},
	{"rmtwa", "蹧"},
	{"rmtwi", "蹲"},
	{"rmua", "噆"},
	{"rmubb", "蹦"},
	{"rmue", "嗄"},
	{"rmuhi", "𨅏"},
	{"rmui", "嘎"},
	{"rmumb", "踹"},
	{"rmuw", "𠵾"},
	{"rmvh", "呀"},
	{"rmvi", "嗕"},
	{"rmvid", "躒"},
	{"rmvim", "躖"},
	{"rmvmi", "蹡"},
	{"rmvn", "咓"},
	{"rmvs", "号"},
	{"rmvvv", "躐"},
	{"rmwc", "𠿪"},
	{"rmwd", "踝"},
	{"rmwf", "嘌"},
	{"rmwg", "喱"},
	{"rmwj", "嘾"},
	{"rmwjc", "躀"},
	{"rmwl", "喕"},
	{"rmwli", "躅"},
	{"rmwtj", "蹕"},
	{"rmwv", "喓"},
	{"rmwyi", "𧿹"},
	{"rmy", "吓"},
	{"rmyaj", "踔"},
	{"rmyav", "蹆"},
	{"rmybb", "蹄"},
	{"rmybp", "躘"},
	{"rmycb", "蹢"},
	{"rmyck", "跤"},
	{"rmydk", "蹾"},
	{"rmyf", "嘕"},
	{"rmyfe", "踧"},
	{"rmyfu", "蹴"},
	{"rmyg", "跓"},
	{"rmygq", "躂"},
	{"rmyij", "𨄮"},
	{"rmyjj", "蹥"},
	{"rmylc", "跡"},
	{"rmylh", "踄"},
	{"rmylm", "趾"},
	{"rmymp", "跐"},
	{"rmymu", "躚"},
	{"rmyoj", "踤"},
	{"rmypo", "躆"},
	{"rmyr", "跕"},
	{"rmyrv", "躟"},
	{"rmytg", "蹱"},
	{"rmytr", "踣"},
	{"rmytv", "踥"},
	{"rmyx", "躋"},
	{"rnbg", "唃 𡃏"},
	{"rnbj", "嘝"},
	{"rnbk", "喚"},
	{"rncr", "噡"},
	{"rnd", "吇"},
	{"rndt", "𠵼"},
	{"rndu", "吼"},
	{"rne", "𠱁"},
	{"rng", "吜 𡋾"},
	{"rnhb", "噊"},
	{"rnhe", "吸"},
	{"rnhs", "𠮨"},
	{"rnhx", "啗"},
	{"rnin", "哆"},
	{"rnir", "𠱷"},
	{"rniy", "𠰻"},
	{"rnkm", "唌"},
	{"rnl", "吲"},
	{"rnlb", "𡃴"},
	{"rnlf", "𡁸"},
	{"rnlm", "唨 𠾐"},
	{"rnlr", "啊"},
	{"rnmu", "𠱓"},
	{"rnn", "𠮩"},
	{"rno", "吹"},
	{"rnot", "噔"},
	{"rnqd", "𠹳"},
	{"rnri", "嚵"},
	{"rnsp", "喼"},
	{"rnwa", "嚕"},
	{"rnxu", "𪚩"},
	{"rob", "吶"},
	{"robq", "𤰉"},
	{"rod", "咻"},
	{"rodi", "咐"},
	{"rog", "唯"},
	{"rogd", "㗱"},
	{"rogf", "噍"},
	{"rohe", "𠿬"},
	{"rohf", "喺"},
	{"roic", "嗿"},
	{"roif", "𠼮"},
	{"roii", "呤"},
	{"roin", "吟"},
	{"roip", "唸 𠰺"},
	{"roir", "唅 嗆"},
	{"roiv", "喰 𠹸"},
	{"roj", "吘"},
	{"roll", "吤"},
	{"rom", "𠰋"},
	{"roma", "噲"},
	{"romd", "唋"},
	{"roml", "啣 𠵴"},
	{"romm", "噏"},
	{"romn", "喻"},
	{"romo", "噞"},
	{"romq", "嗱"},
	{"romr", "哈 啥"},
	{"romt", "啽"},
	{"romv", "喩"},
	{"ron", "吃"},
	{"rond", "𠺪"},
	{"ronk", "喉"},
	{"roob", "𠹹"},
	{"roog", "唑"},
	{"rop", "吪"},
	{"roq", "哖"},
	{"rosk", "咿"},
	{"ross", "𠳔"},
	{"rotf", "嘸"},
	{"roto", "𡂈"},
	{"roud", "嚹"},
	{"roum", "𠼭"},
	{"rowr", "嗰"},
	{"royb", "噙"},
	{"royv", "𠵱"},
	{"rp", "叱 吣"},
	{"rpa", "咰"},
	{"rpd", "吔"},
	{"rph", "咇"},
	{"rphaf", "鴖"},
	{"rphh", "吻"},
	{"rphp", "唿"},
	{"rpim", "呁"},
	{"rplii", "蟁"},
	{"rpln", "刡"},
	{"rpmbc", "䪸"},
	{"rpok", "敃"},
	{"rpou", "啕"},
	{"rpp", "吡"},
	{"rppa", "喈"},
	{"rpr", "呴"},
	{"rpru", "咆"},
	{"rpt", "呭"},
	{"rptd", "喋"},
	{"rpu", "吨"},
	{"rpuc", "噸"},
	{"rpuk", "哅"},
	{"rqam", "𠵆"},
	{"rqbu", "𡃁"},
	{"rqde", "𠵿"},
	{"rqdm", "𠾵"},
	{"rqfh", "𠳕"},
	{"rqha", "啪"},
	{"rqhk", "喫"},
	{"rqhl", "哳"},
	{"rqhu", "囓"},
	{"rqhw", "𡃓"},
	{"rqjm", "嘒"},
	{"rqkd", "嗪"},
	{"rqkq", "唪"},
	{"rqmc", "嘖"},
	{"rqmf", "嗉"},
	{"rqmm", "𠻺"},
	{"rqmn", "咑"},
	{"rqne", "𠳖"},
	{"rqo", "呋"},
	{"rqyg", "𡃵"},
	{"rqyj", "唞"},
	{"rqym", "𠳏"},
	{"rqyt", "啦"},
	{"rrau", "唈"},
	{"rrbyj", "斝"},
	{"rrf", "喣"},
	{"rrhaf", "鷺"},
	{"rrhn", "咒"},
	{"rrhu", "呪"},
	{"rrik", "哭 獸"},
	{"rrikr", "器"},
	{"rrill", "喌"},
	{"rrmcr", "囂"},
	{"rrmjs", "咢"},
	{"rrmmk", "嚴"},
	{"rrmms", "咢"},
	{"rrmr", "噐 𡀔"},
	{"rrms", "呺"},
	{"rrnl", "郘"},
	{"rrr", "品"},
	{"rrrd", "喿 噪"},
	{"rrrh", "𠻝"},
	{"rrrj", "嘽"},
	{"rrrr", "碞 㗊"},
	{"rrrs", "㗁"},
	{"rrru", "喦 嵒"},
	{"rrslr", "嚚"},
	{"rrsqf", "駡"},
	{"rruc", "噀"},
	{"rrvlr", "嘂"},
	{"rrvp", "呡"},
	{"rrwj", "單"},
	{"rrwmu", "鼉"},
	{"rrye", "㗇"},
	{"rryo", "哫"},
	{"rsbn", "唰"},
	{"rsef", "𡁵"},
	{"rsf", "𤏩"},
	{"rsh", "叨"},
	{"rshaf", "鴞 鶚"},
	{"rshu", "𠳿"},
	{"rsit", "嚂"},
	{"rsj", "咠 咡"},
	{"rsjj", "囁"},
	{"rsjl", "㖿"},
	{"rsjr", "啹"},
	{"rsk", "吚"},
	{"rsl", "叩"},
	{"rslb", "咂"},
	{"rsll", "𠱸"},
	{"rsln", "別"},
	{"rsm", "叼"},
	{"rsmbc", "顎"},
	{"rsme", "唚"},
	{"rsmg", "哐 喔 嚁"},
	{"rsmh", "嘐"},
	{"rsmi", "噚"},
	{"rsmj", "噿"},
	{"rsnl", "鄂"},
	{"rso", "呎"},
	{"rsp", "呢"},
	{"rsqf", "嗎"},
	{"rsql", "哪"},
	{"rsrj", "噼"},
	{"rsro", "𡂿"},
	{"rsrr", "嘔"},
	{"rss", "𠰠"},
	{"rssl", "卾"},
	{"rssu", "𠱃"},
	{"rsuu", "啒"},
	{"rsyi", "囑"},
	{"rsypu", "號"},
	{"rta", "唶"},
	{"rtak", "嗼"},
	{"rtav", "噶"},
	{"rtbo", "𡁏"},
	{"rtc", "哄"},
	{"rtcg", "𠼻"},
	{"rtcl", "嘶"},
	{"rtco", "噗"},
	{"rtct", "嗌"},
	{"rtgf", "㗝"},
	{"rtgi", "嚉 囈"},
	{"rtgk", "𠸍"},
	{"rtgu", "唴"},
	{"rthv", "𠾭"},
	{"rtj", "𠯢"},
	{"rtjg", "嚡"},
	{"rtjp", "㗾"},
	{"rtjs", "嘞"},
	{"rtk", "咲 哎"},
	{"rtkr", "喏 𠸏"},
	{"rtlf", "嚥"},
	{"rtlk", "𠸄"},
	{"rtlo", "嘆"},
	{"rtm", "咁"},
	{"rtmc", "唭"},
	{"rtmj", "嘩"},
	{"rtmv", "啿"},
	{"rtnd", "囌"},
	{"rtod", "嗏"},
	{"rtoe", "嚄"},
	{"rtoi", "𠸖"},
	{"rtor", "嗒 嗬"},
	{"rtox", "嚿"},
	{"rtq", "咩"},
	{"rtqm", "嗟"},
	{"rtrg", "嚾"},
	{"rtub", "嗍"},
	{"rtvi", "嗞"},
	{"rtw", "喵"},
	{"rtwa", "嘈"},
	{"rtwi", "噂 囆"},
	{"rtwv", "噥"},
	{"rtxc", "嗛"},
	{"rtyb", "嚆"},
	{"rtyj", "𡂴"},
	{"ru", "巳 𠮿"},
	{"rubb", "嘣"},
	{"ruhjj", "𢁅"},
	{"ruhr", "𠸉"},
	{"rukb", "𨚼"},
	{"rumb", "喘"},
	{"rumi", "嗤"},
	{"rumr", "啱"},
	{"runl", "鄳"},
	{"ruog", "嗺"},
	{"ruoiv", "饕"},
	{"ruon", "㖗"},
	{"rutc", "巽"},
	{"ruu", "咄"},
	{"rv", "𠯆"},
	{"rve", "呶"},
	{"rveq", "𠸎"},
	{"rvfb", "𠺶"},
	{"rvff", "噝"},
	{"rvfh", "𠴕"},
	{"rvfi", "喲"},
	{"rvfj", "𡃈"},
	{"rvfu", "𠾼"},
	{"rvhi", "𠹷"},
	{"rvi", "吆"},
	{"rvii", "嘰"},
	{"rvis", "呦 𠯻"},
	{"rvjd", "𠵈"},
	{"rvjr", "𠵎"},
	{"rvl", "叫"},
	{"rvnk", "吳"},
	{"rvno", "喙"},
	{"rvp", "民"},
	{"rvvu", "嗈"},
	{"rwb", "喟"},
	{"rwc", "呬"},
	{"rwg", "哩"},
	{"rwgf", "嘿"},
	{"rwgg", "嚜"},
	{"rwgn", "嘢"},
	{"rwhd", "㖥"},
	{"rwim", "嘓"},
	{"rwjr", "𠴱"},
	{"rwk", "咽"},
	{"rwkp", "嗯"},
	{"rwks", "𠲸"},
	{"rwl", "呷"},
	{"rwlb", "喁"},
	{"rwlc", "嘪"},
	{"rwlg", "囉"},
	{"rwli", "噣"},
	{"rwlv", "噮"},
	{"rwmv", "喂"},
	{"rwnl", "鄙"},
	{"rwot", "嗢"},
	{"rwtj", "嗶"},
	{"rwvf", "𠼱"},
	{"rwyi", "呣"},
	{"rxu", "黽"},
	{"ry", "卟"},
	{"ryaj", "啅"},
	{"ryao", "噷"},
	{"rybb", "啼 㗻"},
	{"rybp", "嚨"},
	{"rybs", "嗙"},
	{"ryc", "𠯿"},
	{"rycb", "嘀"},
	{"ryck", "咬"},
	{"rydg", "囃"},
	{"rydl", "噺"},
	{"rydu", "嚫"},
	{"ryfu", "噈"},
	{"ryg", "𠰍"},
	{"rygq", "噠"},
	{"ryhc", "嚬"},
	{"ryhh", "喭"},
	{"ryhn", "吭"},
	{"ryhv", "𠲖"},
	{"ryib", "唷"},
	{"ryid", "𠾍"},
	{"ryjj", "嗹"},
	{"ryk", "呅"},
	{"rymb", "啃"},
	{"rymh", "噦"},
	{"rymp", "呲"},
	{"rymr", "唁"},
	{"rymu", "嚙"},
	{"rymy", "咔"},
	{"rynb", "嗵"},
	{"ryo", "足"},
	{"ryoe", "𡃀"},
	{"ryoj", "啐"},
	{"ryok", "㖡"},
	{"rypb", "嘴"},
	{"rypd", "喍 嘑"},
	{"rypk", "噳"},
	{"rypm", "噓"},
	{"rypo", "噱"},
	{"rypt", "嚧"},
	{"rypu", "唬"},
	{"ryr", "呫"},
	{"ryrb", "嗃"},
	{"ryrd", "啍"},
	{"ryrn", "哼"},
	{"ryro", "嚎"},
	{"ryru", "喨"},
	{"ryrv", "嚷 㗒"},
	{"ryse", "叚"},
	{"rysk", "嗾"},
	{"ryso", "𠸝"},
	{"rysy", "唹"},
	{"ryt", "㕸"},
	{"ryta", "喑"},
	{"ryti", "嚱"},
	{"rytp", "噫"},
	{"rytv", "唼"},
	{"ryub", "𠻗"},
	{"ryvg", "噰"},
	{"ryvo", "咳"},
	{"rywe", "嚃"},
	{"rywo", "𠺖"},
	{"ryx", "嚌"},
	{"s", "尸"},
	{"sahaf", "鷵"},
	{"sahni", "飁"},
	{"sammu", "翫"},
	{"sanl", "䣝"},
	{"sav", "匽"},
	{"sbcc", "屭"},
	{"sbhg", "朢"},
	{"sbln", "刷"},
	{"sbuc", "屓"},
	{"sbug", "匷"},
	{"sc", "匹"},
	{"schaf", "鴄"},
	{"schne", "殿"},
	{"scwa", "層"},
	{"se", "尿"},
	{"seb", "腎 臀"},
	{"sebuc", "賢 贀"},
	{"sec", "鋻"},
	{"sed", "棸"},
	{"sef", "焣"},
	{"seg", "埾 堅 壂"},
	{"sehaf", "鷖"},
	{"selmi", "蜸"},
	{"semcw", "醫"},
	{"semgi", "瑿 𤩱"},
	{"semoo", "毉"},
	{"semr", "硻"},
	{"semrt", "豎"},
	{"seog", "匯"},
	{"seooo", "聚"},
	{"seq", "掔"},
	{"sesmm", "翳"},
	{"sev", "娶 婜 嫛"},
	{"sevif", "緊 繄"},
	{"sewgf", "黳"},
	{"seyt", "竪"},
	{"sfa", "馹"},
	{"sfaa", "䮖"},
	{"sfabt", "𩥈"},
	{"sfajv", "騴"},
	{"sfamj", "駻"},
	{"sfamo", "騠"},
	{"sfapp", "騉"},
	{"sfapv", "騔"},
	{"sfb", "屑"},
	{"sfbbr", "騧"},
	{"sfbcr", "䮐"},
	{"sfbgr", "騆"},
	{"sfbjj", "䮝"},
	{"sfbm", "駔"},
	{"sfbmr", "駧"},
	{"sfbr", "駉"},
	{"sfbvk", "騱"},
	{"sfcru", "駾"},
	{"sfcsh", "䭻"},
	{"sfcwa", "驓"},
	{"sfd", "屎"},
	{"sfdi", "尉 㷉"},
	{"sfdk", "駃"},
	{"sfdl", "駷"},
	{"sfdoo", "騋"},
	{"sfe", "馭"},
	{"sfeii", "騷"},
	{"sffdq", "驎"},
	{"sffqf", "驣"},
	{"sfgcg", "𩣱"},
	{"sfggu", "驍"},
	{"sfhae", "騡"},
	{"sfhag", "騜"},
	{"sfhdp", "騬"},
	{"sfher", "駱"},
	{"sfhgu", "駪"},
	{"sfhhl", "駠"},
	{"sfhhw", "騮"},
	{"sfhi", "騩"},
	{"sfhkb", "驕"},
	{"sfhml", "馸"},
	{"sfhni", "颿"},
	{"sfhp", "馲"},
	{"sfhsb", "騙"},
	{"sfhsm", "騸"},
	{"sfhwp", "驄"},
	{"sfhxe", "騪"},
	{"sfiav", "駺"},
	{"sfice", "駿"},
	{"sfihu", "馻"},
	{"sfiih", "驂"},
	{"sfij", "駥"},
	{"sfik", "䭾"},
	{"sfiok", "騃"},
	{"sfiop", "𩥝"},
	{"sfipf", "䮽"},
	{"sfir", "駘"},
	{"sfist", "𩦝"},
	{"sfit", "駴"},
	{"sfitc", "𩧉"},
	{"sfiuh", "駹"},
	{"sfixp", "騼"},
	{"sfjig", "驖"},
	{"sfjmc", "驞"},
	{"sfjmf", "騌"},
	{"sfjp", "駝"},
	{"sfjv", "𩣑"},
	{"sfk", "馱"},
	{"sfki", "駄"},
	{"sfkk", "駁"},
	{"sfkkb", "䮎"},
	{"sfkkk", "騻"},
	{"sfkmr", "騎"},
	{"sfl", "馽"},
	{"sflbk", "駚"},
	{"sflk", "駛"},
	{"sflll", "馴"},
	{"sflmo", "駣"},
	{"sflmy", "騑"},
	{"sflpc", "驥"},
	{"sflw", "駎"},
	{"sflws", "騁"},
	{"sflx", "驌"},
	{"sfmbu", "驦"},
	{"sfmfj", "駍"},
	{"sfmfm", "駓"},
	{"sfmgi", "𩢤"},
	{"sfmhf", "騵"},
	{"sfmig", "駤"},
	{"sfmj", "馯"},
	{"sfmlm", "𩤃"},
	{"sfmmp", "驪"},
	{"sfmtb", "𩧃"},
	{"sfmvm", "𩣪"},
	{"sfmwf", "驃"},
	{"sfmwj", "驔"},
	{"sfmwv", "騕"},
	{"sfmx", "駵"},
	{"sfnhb", "驈"},
	{"sfnhd", "騥"},
	{"sfnhe", "馺"},
	{"sfnkq", "騝"},
	{"sfnok", "騤"},
	{"sfnoo", "騛"},
	{"sfodi", "駙"},
	{"sfog", "騅"},
	{"sfohh", "駗"},
	{"sfoii", "駖"},
	{"sfoip", "騐"},
	{"sfok", "駇"},
	{"sfomd", "駼"},
	{"sfomg", "駩"},
	{"sfomn", "騟"},
	{"sfomo", "驗"},
	{"sfomr", "騇"},
	{"sfpd", "馳"},
	{"sfph", "駜"},
	{"sfpi", "馰"},
	{"sfpou", "騊"},
	{"sfpr", "駒"},
	{"sfpuu", "騶"},
	{"sfqjr", "騞"},
	{"sfrb", "駽"},
	{"sfrrj", "驒"},
	{"sfrye", "騢"},
	{"sfseo", "驟"},
	{"sfsff", "驫"},
	{"sfshr", "駋"},
	{"sfsj", "駬"},
	{"sfsjj", "䯀"},
	{"sfsjr", "𩤅"},
	{"sfsma", "騽"},
	{"sfsme", "駸"},
	{"sfsnd", "驏"},
	{"sfso", "駅"},
	{"sfsrr", "驅"},
	{"sfss", "駏"},
	{"sfssr", "駶"},
	{"sfstv", "𩥇"},
	{"sft", "馵"},
	{"sftaj", "騲"},
	{"sftbn", "騚"},
	{"sftcd", "驜"},
	{"sftjd", "驧"},
	{"sftlf", "驠"},
	{"sftlm", "騹"},
	{"sftmc", "騏"},
	{"sftmj", "驊"},
	{"sftrg", "驩"},
	{"sftt", "駢"},
	{"sfuce", "騣"},
	{"sfuhj", "𩥪"},
	{"sfumj", "䮗"},
	{"sfumt", "𩥉"},
	{"sfuob", "驨"},
	{"sfvne", "騄"},
	{"sfwc", "駟"},
	{"sfwd", "騍"},
	{"sfwk", "駰"},
	{"sfwlj", "驛"},
	{"sfwp", "騦"},
	{"sfwtj", "驆"},
	{"sfwvf", "騾"},
	{"sfyaj", "䮓"},
	{"sfybp", "䮾"},
	{"sfybs", "騯"},
	{"sfyck", "駮"},
	{"sfydk", "驐"},
	{"sfyg", "駐"},
	{"sfyhv", "褧"},
	{"sfyk", "馼"},
	{"sfypm", "驉"},
	{"sfypt", "驢"},
	{"sfyrv", "驤"},
	{"sfytj", "騂 騿"},
	{"sfyvo", "駭"},
	{"sfywm", "驙"},
	{"sghaf", "鸐"},
	{"sgi", "戳"},
	{"sgjwp", "聽"},
	{"sgks", "劻"},
	{"sgln", "剭"},
	{"sh", "刀"},
	{"shaf", "鳲"},
	{"shaph", "鬄"},
	{"shawe", "鬘"},
	{"shbb", "鬅"},
	{"shbt", "匴"},
	{"shby", "𩬅"},
	{"shc", "刅"},
	{"shcwa", "鬙"},
	{"shdbn", "鬎"},
	{"shdci", "鬆"},
	{"shdhe", "髲"},
	{"shefh", "髿"},
	{"shfb", "髾"},
	{"shfqu", "鬈"},
	{"shgb", "髯"},
	{"shgr", "髻"},
	{"shhaf", "鳭 鷚"},
	{"shhdf", "鬏"},
	{"shhdn", "鬁"},
	{"shhej", "髼"},
	{"shhg", "𩬎"},
	{"shhhc", "鬚"},
	{"shhjr", "髺"},
	{"shhn", "髠"},
	{"shhqu", "髦"},
	{"shi", "刃 戮"},
	{"shiih", "鬖"},
	{"shikk", "髮"},
	{"shjbc", "鬒"},
	{"shjka", "䰇"},
	{"shjmc", "鬢"},
	{"shjmf", "鬃"},
	{"shjpa", "鬐"},
	{"shjrb", "鬍"},
	{"shkmb", "鬌"},
	{"shks", "勠"},
	{"shlb", "属"},
	{"shlbu", "髧"},
	{"shlln", "髴"},
	{"shlmc", "䰎"},
	{"shln", "剹"},
	{"shmbc", "顟"},
	{"shmfm", "髬"},
	{"shml", "匠"},
	{"shmu", "髡"},
	{"shnih", "髳"},
	{"shnl", "鄝"},
	{"shnmu", "𩯕"},
	{"shob", "屩"},
	{"shod", "屧 髹"},
	{"shoe", "屐 履"},
	{"shog", "雡"},
	{"shoma", "鬠"},
	{"shomc", "鬂"},
	{"shoo", "屣"},
	{"shoog", "髽"},
	{"shot", "屜"},
	{"shov", "屨"},
	{"shpd", "髢"},
	{"shpru", "髱"},
	{"shqka", "鬊"},
	{"shqu", "尾"},
	{"shr", "召"},
	{"shsb", "匾"},
	{"shshr", "髫"},
	{"shsj", "髶"},
	{"shtak", "鬕"},
	{"shtbn", "鬋"},
	{"shtlb", "鬗"},
	{"shtw", "髷"},
	{"shtwv", "鬞"},
	{"shtxc", "鬑"},
	{"shuce", "鬉"},
	{"shvvv", "鬣"},
	{"shwlv", "鬟"},
	{"shwp", "䰄"},
	{"shyhj", "鬔"},
	{"shyhs", "髣"},
	{"shymp", "髭"},
	{"shyrv", "鬤"},
	{"sibt", "監"},
	{"sibuu", "覧"},
	{"sic", "鍳"},
	{"sif", "熨"},
	{"sihhh", "髟"},
	{"sihk", "镺"},
	{"sihml", "斸"},
	{"sihq", "犚"},
	{"sihqo", "镻"},
	{"sije", "㞗"},
	{"sikcf", "镽"},
	{"silmi", "螱"},
	{"siln", "劚"},
	{"silq", "肆"},
	{"simgi", "𤧬"},
	{"sinl", "鄩"},
	{"sip", "忍 慰"},
	{"sisuu", "镼"},
	{"siwc", "䦉"},
	{"siyhv", "褽"},
	{"sj", "耳"},
	{"sjb", "臂"},
	{"sjbmm", "耼"},
	{"sjc", "屄 鐾"},
	{"sjcim", "聬"},
	{"sjcip", "聡"},
	{"sjd", "檗"},
	{"sje", "取"},
	{"sjenl", "郰"},
	{"sjf", "耿"},
	{"sjfd", "糪"},
	{"sjff", "𦖠"},
	{"sjg", "壁"},
	{"sjgb", "聃"},
	{"sjgr", "聐"},
	{"sjhaf", "鷿"},
	{"sjhbn", "䎺"},
	{"sjhhj", "聛"},
	{"sjhhl", "聊"},
	{"sjhjr", "聒"},
	{"sjhqu", "毦"},
	{"sjhwp", "聰"},
	{"sjhxu", "聣"},
	{"sjirm", "聝"},
	{"sjjcm", "聜"},
	{"sjjmo", "聢"},
	{"sjjn", "匭"},
	{"sjjpn", "聹"},
	{"sjjyj", "䏁"},
	{"sjka", "屠"},
	{"sjkf", "屪"},
	{"sjki", "耾"},
	{"sjlb", "幦"},
	{"sjlbu", "耽"},
	{"sjlmc", "聵"},
	{"sjln", "刵"},
	{"sjlws", "聘"},
	{"sjmbc", "顳"},
	{"sjmbl", "聏"},
	{"sjmg", "𤩹"},
	{"sjmgi", "璧"},
	{"sjmn", "耵"},
	{"sjmvn", "甓"},
	{"sjmym", "聇"},
	{"sjncr", "聸"},
	{"sjnl", "耶"},
	{"sjnok", "聧"},
	{"sjoii", "聆"},
	{"sjoin", "耹"},
	{"sjok", "𣀳"},
	{"sjomn", "𦖭"},
	{"sjomr", "𦕲"},
	{"sjp", "恥 憵"},
	{"sjpkp", "聦"},
	{"sjq", "擘"},
	{"sjr", "居"},
	{"sjrxu", "鼊"},
	{"sjryo", "躄"},
	{"sjsh", "劈"},
	{"sjsj", "聑"},
	{"sjsjj", "聶"},
	{"sjtk", "联"},
	{"sjtor", "𦖿"},
	{"sju", "耴"},
	{"sjv", "嬖"},
	{"sjvif", "繴"},
	{"sjvis", "聈"},
	{"sjvit", "聯"},
	{"sjyhv", "襞"},
	{"sjyia", "職"},
	{"sjylm", "耻"},
	{"sjymr", "譬"},
	{"sjyrn", "聤"},
	{"sk", "尹"},
	{"skcf", "㞠"},
	{"skn", "尻"},
	{"skoo", "匧"},
	{"skr", "君"},
	{"skrr", "匲"},
	{"sl", "卩"},
	{"slb", "匝"},
	{"sle", "臤"},
	{"slmbc", "頣 頤"},
	{"slmc", "匱"},
	{"slmy", "匪 屝"},
	{"slo", "臥"},
	{"slorr", "臨"},
	{"slqmc", "賾"},
	{"slsl", "臣"},
	{"slsll", "臦"},
	{"slvif", "綤"},
	{"slw", "届"},
	{"slwv", "屢"},
	{"sly", "卧"},
	{"sm", "刁"},
	{"smamo", "翨"},
	{"smbjj", "翬 𦑩"},
	{"smblb", "帚"},
	{"smcsh", "翂"},
	{"smdhe", "翍"},
	{"smf", "灵"},
	{"smg", "匡"},
	{"smgi", "匤"},
	{"smha", "習"},
	{"smhaf", "翵"},
	{"smhqo", "翐"},
	{"smhqu", "毣"},
	{"smht", "𦐒"},
	{"smi", "镸 𦐂"},
	{"smig", "屋"},
	{"smikk", "翇"},
	{"smip", "𦏵"},
	{"smkoo", "翜"},
	{"sml", "翀 𠁨"},
	{"smm", "羾"},
	{"smmbc", "頨"},
	{"smmri", "尋"},
	{"smnp", "屍"},
	{"smog", "翟"},
	{"smohh", "翏"},
	{"smonk", "翭"},
	{"smpd", "𦏸"},
	{"smpr", "翑"},
	{"smqjm", "𦒄"},
	{"smqmb", "𦑊"},
	{"smr", "司"},
	{"smsim", "羽"},
	{"smso", "𡱰"},
	{"smt", "羿"},
	{"smuce", "翪"},
	{"smv", "長"},
	{"smwtc", "翼"},
	{"smyjj", "翴"},
	{"smyk", "𦐐"},
	{"smyoj", "翠"},
	{"smyrb", "翯"},
	{"smyrf", "翞"},
	{"smyt", "翋 翌"},
	{"smytv", "翣"},
	{"sndd", "孱"},
	{"snlr", "屙"},
	{"so", "尺"},
	{"sok", "医"},
	{"somn", "匬"},
	{"somo", "匳"},
	{"somr", "匼"},
	{"sonl", "鄹"},
	{"soog", "𠥔"},
	{"sorc", "咫"},
	{"sp", "尼"},
	{"spbuc", "贒"},
	{"spd", "匜"},
	{"sphaf", "鵋"},
	{"sphh", "匢"},
	{"spp", "屁"},
	{"spt", "屉"},
	{"sqnl", "那"},
	{"sqsf", "馬"},
	{"sr", "叵 𡰪"},
	{"srbt", "盬"},
	{"srbuu", "覗"},
	{"srf", "焄 𤍥"},
	{"srhaf", "鵘 鶋 鷗"},
	{"srhg", "聖"},
	{"srhne", "毆"},
	{"srhrf", "𠥹"},
	{"srks", "劭"},
	{"srlb", "屌"},
	{"srln", "刟"},
	{"srmbc", "頵"},
	{"srmvn", "甌"},
	{"srnl", "邵 郡"},
	{"srno", "歐"},
	{"srp", "慝"},
	{"srrau", "𨛦"},
	{"srrj", "匰"},
	{"srrr", "區"},
	{"srsl", "卲"},
	{"srtq", "羣 群"},
	{"srye", "敺"},
	{"sryjf", "鸊"},
	{"srymr", "䛐"},
	{"srytj", "辟"},
	{"ss", "巨"},
	{"ssf", "燛"},
	{"sskll", "臩"},
	{"sslii", "螶"},
	{"ssr", "局"},
	{"ssu", "凹"},
	{"stkr", "匿 𡲢"},
	{"stqq", "羼"},
	{"stt", "屏"},
	{"stv", "展"},
	{"su", "己 已 㔾"},
	{"suf", "熙 𤋮"},
	{"sug", "屆"},
	{"suhaf", "鶌"},
	{"suhqm", "𡲥"},
	{"suhu", "兕"},
	{"sund", "屘"},
	{"sunl", "邔"},
	{"suok", "改"},
	{"sup", "忌"},
	{"sut", "异"},
	{"sutc", "𢁉"},
	{"suu", "屈"},
	{"suv", "妀 媐"},
	{"svhaf", "鶠"},
	{"svnl", "郾"},
	{"svryo", "𨃨"},
	{"sw", "屇"},
	{"swbt", "鹽"},
	{"swbuu", "覽"},
	{"swc", "鑒"},
	{"swl", "匣"},
	{"swq", "擥"},
	{"syhn", "匟"},
	{"syp", "𢛶"},
	{"sytj", "屖"},
	{"syyi", "屬"},
	{"syyq", "犀"},
	{"syyu", "𡲬"},
	{"t", "廿"},
	{"ta", "昔"},
	{"taa", "菖"},
	{"taaa", "蕌"},
	{"tab", "萌"},
	{"tabt", "蒀"},
	{"tabu", "萺"},
	{"tadhe", "皵"},
	{"tagi", "蒔"},
	{"tahaf", "鵲"},
	{"tahml", "斮"},
	{"tahs", "葃"},
	{"tahu", "葿"},
	{"taiu", "蔇"},
	{"taj", "草"},
	{"tak", "莫"},
	{"taka", "暮"},
	{"takb", "幕"},
	{"takf", "驀"},
	{"takg", "墓"},
	{"taki", "𦻒"},
	{"takp", "慕"},
	{"takq", "摹"},
	{"taks", "募"},
	{"talk", "𦴤"},
	{"taln", "剒"},
	{"tan", "菛"},
	{"tana", "蕳"},
	{"tanb", "蕑"},
	{"tang", "藺"},
	{"tanp", "蕄"},
	{"tanv", "蔅"},
	{"tanw", "蘭"},
	{"taph", "䓪"},
	{"tapp", "菎"},
	{"tapv", "葛"},
	{"tase", "蕞"},
	{"tau", "芭"},
	{"tav", "茛"},
	{"tawe", "蔓"},
	{"tbac", "蓂"},
	{"tbau", "萉"},
	{"tbb", "萠"},
	{"tbbb", "蓇"},
	{"tbbe", "薆"},
	{"tbbq", "蕣"},
	{"tbbr", "萵"},
	{"tbbu", "薍"},
	{"tbbuu", "覯"},
	{"tbc", "典 蓥"},
	{"tbcn", "萴"},
	{"tbcsh", "黺"},
	{"tbcv", "蘡"},
	{"tbd", "槊 荣 菜"},
	{"tbdh", "𦹮"},
	{"tbfe", "藤"},
	{"tbff", "虅"},
	{"tbfs", "蕂"},
	{"tbg", "塑"},
	{"tbgr", "䓟"},
	{"tbhg", "薶"},
	{"tbhq", "荦"},
	{"tbhs", "葄"},
	{"tbhu", "藐"},
	{"tbhx", "蓞"},
	{"tbijb", "黼"},
	{"tbikk", "黻"},
	{"tbjj", "葷"},
	{"tbkf", "䔳"},
	{"tbks", "勱"},
	{"tbli", "繭 萤"},
	{"tbln", "前 蒯"},
	{"tbm", "苴"},
	{"tbmbc", "顜 顢"},
	{"tbme", "萲"},
	{"tbmg", "莹"},
	{"tbmo", "蒙"},
	{"tbmr", "茼"},
	{"tbms", "莇"},
	{"tbmw", "蒏"},
	{"tbnd", "莩"},
	{"tbnf", "煎"},
	{"tbnh", "剪"},
	{"tbni", "蒬"},
	{"tbnm", "翦"},
	{"tbof", "蔡"},
	{"tbok", "散"},
	{"tbou", "䔄"},
	{"tbp", "愬 𦽳"},
	{"tbpr", "葋"},
	{"tbr", "苘"},
	{"tbse", "菔"},
	{"tbtv", "菵"},
	{"tbu", "苜"},
	{"tbud", "蔝"},
	{"tbuf", "蘨"},
	{"tbuk", "藈"},
	{"tbul", "薡"},
	{"tbut", "萛"},
	{"tbuu", "莧"},
	{"tbv", "荽"},
	{"tbvf", "萦"},
	{"tby", "䒟"},
	{"tbyj", "斠"},
	{"tc", "业 共 菳"},
	{"tca", "普"},
	{"tcb", "朞 期"},
	{"tcbt", "益"},
	{"tcbuu", "覥"},
	{"tcd", "棊"},
	{"tcfb", "黹"},
	{"tcg", "基"},
	{"tchaf", "鶼 鷬 䳍"},
	{"tche", "夔"},
	{"tchml", "斯"},
	{"tcim", "蓊"},
	{"tcjwj", "輂"},
	{"tclbu", "黆"},
	{"tclmi", "蛬"},
	{"tcmr", "碁"},
	{"tcno", "欺 歉"},
	{"tcok", "敟"},
	{"tcp", "恭 惎"},
	{"tcq", "拲"},
	{"tcru", "巷 莌"},
	{"tcsd", "棻"},
	{"tcsh", "芬"},
	{"tcst", "葐"},
	{"tctd", "業"},
	{"tcte", "叢"},
	{"tcvif", "綦"},
	{"tcwm", "酋"},
	{"tcyg", "黈"},
	{"tcyj", "斢"},
	{"tcymr", "諅"},
	{"tcyr", "黇"},
	{"tdav", "𦶠"},
	{"tdb", "茦"},
	{"tdbb", "蕀"},
	{"tdbk", "蓛"},
	{"tdbn", "莿"},
	{"tdbu", "葙"},
	{"tdci", "菘"},
	{"tdd", "菻"},
	{"tdhaf", "鷋"},
	{"tdhl", "菥"},
	{"tdj", "茉"},
	{"tdje", "䓩"},
	{"tdk", "芵"},
	{"tdlc", "藾"},
	{"tdlo", "蔌"},
	{"tdm", "苯"},
	{"tdmq", "葦"},
	{"tdnl", "鄴"},
	{"tdof", "藮"},
	{"tdoo", "萊"},
	{"tdqt", "𧄧"},
	{"tdr", "莕"},
	{"tdrd", "𦹂"},
	{"tdsr", "藲"},
	{"tdte", "𧁒"},
	{"tdw", "菄"},
	{"tdwf", "萰"},
	{"teae", "䕕"},
	{"teah", "蕩"},
	{"teap", "𦹲"},
	{"teat", "蕰"},
	{"teav", "䔽"},
	{"tebd", "𦷰"},
	{"tebm", "菹"},
	{"tebv", "𦷪"},
	{"tec", "鑿"},
	{"ted", "莯"},
	{"tede", "菠"},
	{"tefd", "糳"},
	{"tefh", "莎"},
	{"tege", "蔆"},
	{"teha", "萡"},
	{"tehl", "䓅"},
	{"tehp", "𦿞"},
	{"tehr", "落 萿 𦶡"},
	{"teht", "蘯"},
	{"tehv", "蒎"},
	{"tehw", "藩"},
	{"teib", "蒲"},
	{"teii", "薄"},
	{"teir", "菭"},
	{"teiv", "蒗"},
	{"teln", "劐"},
	{"telu", "莐"},
	{"tem", "茳"},
	{"temf", "薸"},
	{"temj", "萍 藫"},
	{"temn", "𦭑"},
	{"temr", "菏"},
	{"tene", "莈"},
	{"teod", "蒤"},
	{"teom", "虃"},
	{"teon", "蕍"},
	{"teot", "蒞"},
	{"teoy", "𦷫"},
	{"tepa", "𦴥"},
	{"teqb", "蔳"},
	{"terd", "藻"},
	{"tesd", "蕖"},
	{"tese", "蓡"},
	{"tesr", "菬"},
	{"tess", "菃"},
	{"tesu", "范"},
	{"tetc", "葓"},
	{"tett", "蓱"},
	{"tewb", "蕅"},
	{"tewj", "䕪"},
	{"tewt", "薀"},
	{"teyb", "薃"},
	{"teye", "蔋"},
	{"teyp", "𦴢"},
	{"teyr", "𦹃"},
	{"teyt", "𦲷"},
	{"teyu", "蓅"},
	{"teyv", "茫"},
	{"tf", "苂"},
	{"tfa", "㬫"},
	{"tfaj", "蔊"},
	{"tfb", "莦"},
	{"tfbk", "蔽"},
	{"tfbn", "萷"},
	{"tff", "菼"},
	{"tfff", "藀"},
	{"tfk", "𡙡"},
	{"tfkc", "蘱"},
	{"tfku", "虌"},
	{"tfmc", "薠"},
	{"tfmu", "茪"},
	{"tfnl", "酀"},
	{"tfpi", "䓎"},
	{"tfqu", "菤"},
	{"tfyj", "𦻐"},
	{"tg", "芏 𦍌"},
	{"tgb", "苒"},
	{"tgbt", "盖"},
	{"tgbuu", "觀"},
	{"tgce", "菱"},
	{"tgdi", "對"},
	{"tgea", "𧅥"},
	{"tgeno", "羨"},
	{"tgf", "羔"},
	{"tgfo", "羮"},
	{"tgftk", "羹"},
	{"tgg", "茥"},
	{"tggi", "葑 蓺"},
	{"tggu", "蕘"},
	{"tghaf", "鸛"},
	{"tghds", "羲"},
	{"tghi", "羗 𦍑"},
	{"tghml", "𣂷 𣂼"},
	{"tghni", "飌"},
	{"tghqi", "義"},
	{"tghu", "羌"},
	{"tgif", "爇"},
	{"tgii", "藝"},
	{"tgimo", "羡"},
	{"tgine", "羕"},
	{"tgit", "蓋"},
	{"tgje", "蕔"},
	{"tgji", "蓻"},
	{"tgk", "美"},
	{"tgks", "勸"},
	{"tglln", "羛"},
	{"tglmi", "𧕴"},
	{"tgmbc", "顴"},
	{"tgmj", "𦱾"},
	{"tgni", "薵"},
	{"tgnl", "酄"},
	{"tgno", "歡 羑 莰"},
	{"tgobo", "臡"},
	{"tgow", "薔"},
	{"tgp", "恙 戁"},
	{"tgpm", "荺"},
	{"tgq", "𢺋"},
	{"tgr", "䓀"},
	{"tgrg", "薹"},
	{"tgrr", "䕒"},
	{"tgsk", "蔜"},
	{"tgte", "薣"},
	{"tgtr", "善"},
	{"tgum", "𧄍"},
	{"tgv", "姜"},
	{"tgwc", "藚"},
	{"tgyr", "𦹷"},
	{"tgyv", "蘾"},
	{"thaa", "藠"},
	{"thae", "葲 𧄦"},
	{"thaf", "蔦 蘤"},
	{"thag", "葟"},
	{"thai", "菂"},
	{"thau", "葩"},
	{"thbh", "虋"},
	{"thbk", "薁"},
	{"thbu", "首"},
	{"thcn", "藰"},
	{"thda", "萫"},
	{"thdb", "蕱"},
	{"thdd", "䔉"},
	{"thde", "薐"},
	{"thdf", "萩"},
	{"thdg", "𦻓"},
	{"thdh", "菞 蕛"},
	{"thdm", "蒩"},
	{"thdn", "莉"},
	{"thds", "莠"},
	{"thdv", "萎 藒"},
	{"thdw", "蕃"},
	{"thej", "莑"},
	{"ther", "茖"},
	{"they", "苳"},
	{"thfd", "苸"},
	{"thfs", "蘍"},
	{"thg", "𦯀"},
	{"thgf", "薰"},
	{"thhaf", "鶜"},
	{"thhc", "蕦"},
	{"thhd", "蔾"},
	{"thhe", "藜"},
	{"thhj", "萆"},
	{"thhl", "茆 𦺄"},
	{"thhq", "𦺙"},
	{"thi", "蒐"},
	{"thj", "芊"},
	{"thjd", "孽 糵 茱 蘖"},
	{"thje", "葮"},
	{"thjg", "董"},
	{"thjm", "菙"},
	{"thjo", "躠"},
	{"thjr", "䒷"},
	{"thk", "芺"},
	{"thkb", "蕎"},
	{"thkp", "菾"},
	{"thlb", "萭"},
	{"thlf", "蘌"},
	{"thlo", "𦲽"},
	{"thmb", "蘬"},
	{"thml", "芹"},
	{"thmr", "茩"},
	{"thmy", "𦭐"},
	{"thnd", "䔧"},
	{"thne", "芟"},
	{"thni", "芃"},
	{"thod", "蒣"},
	{"thoe", "蕧"},
	{"thok", "薇 藢 𦱿 𧃸"},
	{"thol", "蓹"},
	{"thon", "荇 葕 蘅 𦸇"},
	{"thoo", "蓏 蓗 蓯 蓰"},
	{"thoq", "葎"},
	{"thpl", "茚"},
	{"thpm", "茋"},
	{"thqi", "莪"},
	{"thqm", "苼"},
	{"thqo", "苵"},
	{"thqu", "芼"},
	{"thrb", "蒒"},
	{"thrj", "薛"},
	{"ths", "苲"},
	{"thsb", "菺 萹"},
	{"thse", "蒑"},
	{"thsk", "薂"},
	{"thsu", "蔰"},
	{"thup", "蒠"},
	{"thvi", "蘶"},
	{"thvl", "䒢"},
	{"thvo", "苽"},
	{"thvp", "芪"},
	{"thvu", "蔸"},
	{"thwp", "蓖 蔥"},
	{"thxc", "藇"},
	{"thxf", "蕮"},
	{"thxo", "萸"},
	{"thxu", "萖"},
	{"thye", "蒰"},
	{"thyn", "𦶢"},
	{"tiav", "莨"},
	{"tibi", "蒪"},
	{"tic", "𨮝"},
	{"tice", "荾"},
	{"tidd", "蔴"},
	{"tidf", "䕷"},
	{"tidq", "藦"},
	{"tidr", "蘑"},
	{"tidy", "蘼"},
	{"tifm", "䔃"},
	{"tih", "茂"},
	{"tihaf", "鷀 鷷"},
	{"tihc", "蕆"},
	{"tihi", "荗"},
	{"tihm", "菧"},
	{"tihr", "葴 蒧"},
	{"tihs", "荿"},
	{"tihv", "葳"},
	{"tiib", "蓢"},
	{"tiih", "蔘"},
	{"tiit", "𦾟"},
	{"tij", "茙"},
	{"tijb", "莆"},
	{"tije", "莍"},
	{"tikf", "蒍"},
	{"tikk", "茇"},
	{"tikt", "莽"},
	{"tiku", "𦬓"},
	{"tilo", "菮"},
	{"tilr", "蓎"},
	{"time", "蓤"},
	{"timo", "茨"},
	{"tims", "藏"},
	{"tino", "芝"},
	{"tioc", "薋"},
	{"tip", "懟 芅"},
	{"tipd", "蘪"},
	{"tipf", "藨"},
	{"tir", "苔"},
	{"tird", "葈"},
	{"tis", "芦"},
	{"tist", "𦼦"},
	{"titb", "蓆"},
	{"titc", "薕"},
	{"titf", "蔗"},
	{"tixf", "薦"},
	{"tixp", "蔍"},
	{"tj", "卅"},
	{"tjam", "靼"},
	{"tjamo", "鞮"},
	{"tjapv", "鞨"},
	{"tjau", "靶"},
	{"tjav", "鞎"},
	{"tjavf", "韅"},
	{"tjb", "芾"},
	{"tjbc", "蒖"},
	{"tjbd", "荸"},
	{"tjbhx", "鞱"},
	{"tjbj", "萳"},
	{"tjbm", "萓 靻"},
	{"tjck", "葖"},
	{"tjcn", "藭"},
	{"tjcr", "蓉"},
	{"tjd", "苿"},
	{"tjdhe", "鞁"},
	{"tjdj", "靺"},
	{"tjds", "葧"},
	{"tje", "芰"},
	{"tjea", "鞜"},
	{"tjef", "蘻"},
	{"tjfb", "鞘"},
	{"tjfbg", "鞺"},
	{"tjfbr", "鞝"},
	{"tjfq", "靽"},
	{"tjgg", "鞋"},
	{"tjgr", "鞊"},
	{"tjgwc", "韇"},
	{"tjhaf", "鷨"},
	{"tjhd", "鞂"},
	{"tjhdf", "鞦"},
	{"tjhhj", "鞞"},
	{"tjhkb", "鞽"},
	{"tjhml", "靳"},
	{"tjhr", "𦴦"},
	{"tjii", "蓴"},
	{"tjip", "蕙"},
	{"tjixf", "韀"},
	{"tjjcm", "鞚"},
	{"tjjj", "蓒"},
	{"tjjl", "蔪"},
	{"tjjv", "鞍"},
	{"tjka", "著"},
	{"tjkp", "荖"},
	{"tjks", "勒"},
	{"tjlbk", "鞅"},
	{"tjlmo", "鞉"},
	{"tjlo", "萐"},
	{"tjlv", "萋"},
	{"tjlwv", "鞻"},
	{"tjmc", "蔩 𧅤"},
	{"tjmd", "荢"},
	{"tjme", "蔻"},
	{"tjmj", "靬"},
	{"tjmm", "萱"},
	{"tjmn", "苧 靪"},
	{"tjmo", "萣"},
	{"tjmr", "菪"},
	{"tjmu", "莞 靰"},
	{"tjmv", "𦸅"},
	{"tjmwm", "韁"},
	{"tjnau", "鞔"},
	{"tjncr", "韂"},
	{"tjnhd", "鞣"},
	{"tjnhe", "靸"},
	{"tjni", "鞃"},
	{"tjnkq", "鞬"},
	{"tjnl", "鄿 靷"},
	{"tjnu", "菀"},
	{"tjoa", "蓿"},
	{"tjoin", "靲"},
	{"tjomk", "鞭"},
	{"tjomr", "鞈"},
	{"tjomt", "鞥"},
	{"tjop", "靴"},
	{"tjpa", "蓍"},
	{"tjpfd", "鞠"},
	{"tjpi", "靮"},
	{"tjpn", "薴"},
	{"tjpru", "鞄"},
	{"tjpt", "靾"},
	{"tjptd", "鞢"},
	{"tjpu", "蔤"},
	{"tjpyr", "鞫"},
	{"tjqp", "藼"},
	{"tjqyt", "鞡"},
	{"tjr", "苦"},
	{"tjrb", "葫 鞙"},
	{"tjrr", "菅"},
	{"tjshi", "靭"},
	{"tjshr", "鞀"},
	{"tjsk", "靱"},
	{"tjtc", "蕡"},
	{"tjthb", "鞴"},
	{"tjtif", "韉"},
	{"tjtmj", "鞾"},
	{"tjtoe", "韄"},
	{"tjtor", "鞳"},
	{"tjtq", "藆"},
	{"tjttb", "鞲"},
	{"tjtwm", "韈"},
	{"tjv", "荌"},
	{"tjvii", "鞿"},
	{"tjvis", "靿"},
	{"tjwj", "莗"},
	{"tjwk", "鞇"},
	{"tjwtj", "鞸"},
	{"tjydl", "鞹"},
	{"tjygq", "韃"},
	{"tjymu", "韆"},
	{"tjyrd", "鞟"},
	{"tjytr", "鞛"},
	{"tk", "艾"},
	{"tkce", "蔱"},
	{"tkd", "檠"},
	{"tke", "苃"},
	{"tkhaf", "鴱 鶧 𪅐 𪆴"},
	{"tkhf", "荻"},
	{"tkhg", "莥"},
	{"tkhi", "藱"},
	{"tkhr", "𦸒"},
	{"tkhw", "蕕"},
	{"tkit", "葢"},
	{"tkjt", "莾"},
	{"tkkb", "莃"},
	{"tkld", "荐"},
	{"tklg", "茬"},
	{"tklmi", "蟼"},
	{"tklu", "菴"},
	{"tkmf", "萘"},
	{"tkmr", "䓫"},
	{"tkms", "荂"},
	{"tkn", "艽 荑"},
	{"tkni", "芄"},
	{"tknl", "鄚 鄭 䣐"},
	{"tkok", "蒺"},
	{"tkoo", "莢"},
	{"tkp", "憼"},
	{"tkpb", "蔕"},
	{"tkq", "擎"},
	{"tkr", "若"},
	{"tkrp", "惹"},
	{"tks", "艻"},
	{"tksc", "苏"},
	{"tksqf", "驚"},
	{"tksr", "茄"},
	{"tkss", "荔"},
	{"tkymr", "警"},
	{"tl", "𦬕"},
	{"tlb", "芇"},
	{"tlbk", "英"},
	{"tlbo", "㒼"},
	{"tlbr", "萜"},
	{"tlj", "革"},
	{"tlkf", "𩤯 𪃳"},
	{"tllmi", "蟴"},
	{"tlln", "茀"},
	{"tlmc", "蕢"},
	{"tlmi", "茧"},
	{"tlmm", "韮"},
	{"tlmt", "藎"},
	{"tlmy", "菲"},
	{"tlpf", "燕 鷰 㷼"},
	{"tlqm", "堇"},
	{"tlvk", "藪"},
	{"tlw", "苖"},
	{"tlwc", "黄"},
	{"tlwv", "蔞"},
	{"tlx", "蕭"},
	{"tlyk", "𦻔"},
	{"tm", "甘"},
	{"tmam", "荁"},
	{"tmbb", "薷"},
	{"tmbg", "藿"},
	{"tmbi", "蕓 蕶"},
	{"tmbk", "䓴"},
	{"tmbl", "荋"},
	{"tmbm", "䖅"},
	{"tmbr", "蘦 虂"},
	{"tmbuu", "覲"},
	{"tmbw", "蕾"},
	{"tmcw", "茜 莤"},
	{"tmd", "某 芋"},
	{"tmdm", "藶"},
	{"tmf", "芣"},
	{"tmfb", "薾"},
	{"tmff", "蒜"},
	{"tmfj", "苹"},
	{"tmfm", "苤"},
	{"tmgf", "蘸"},
	{"tmgn", "菿 薽"},
	{"tmgr", "蘁"},
	{"tmhf", "蒝"},
	{"tmhg", "蕥"},
	{"tmhml", "斳"},
	{"tmig", "荎"},
	{"tmjo", "𦮖"},
	{"tmks", "勤"},
	{"tmlb", "𦲸"},
	{"tmlm", "菫"},
	{"tmmc", "其"},
	{"tmmi", "芸"},
	{"tmms", "葝"},
	{"tmmu", "芫"},
	{"tmmv", "甚"},
	{"tmn", "艼"},
	{"tmnf", "𦶣"},
	{"tmnh", "薚"},
	{"tmnj", "茿"},
	{"tmnl", "邯 鄞"},
	{"tmnm", "薤"},
	{"tmnn", "茢"},
	{"tmnr", "苛"},
	{"tmnv", "蒆 薞"},
	{"tmoa", "藸"},
	{"tmob", "苪"},
	{"tmom", "蕤"},
	{"tmoo", "莁"},
	{"tmpg", "塟"},
	{"tmpt", "葬"},
	{"tmrb", "蒚"},
	{"tmrm", "䕢"},
	{"tmrr", "藞"},
	{"tmrt", "荳"},
	{"tmrw", "葍"},
	{"tmsu", "苊"},
	{"tmtj", "華"},
	{"tmtn", "荊"},
	{"tmto", "蕨"},
	{"tmue", "𦷜"},
	{"tmvh", "芽"},
	{"tmvi", "蓐"},
	{"tmvm", "莖"},
	{"tmwc", "黃"},
	{"tmwf", "蔈"},
	{"tmwj", "蕈"},
	{"tmwm", "薑"},
	{"tmwt", "𧂯"},
	{"tmwv", "葽"},
	{"tmy", "芐"},
	{"tmyf", "蔫"},
	{"tmym", "𦭒"},
	{"tmymu", "齹"},
	{"tn", "艺 芎"},
	{"tnau", "莬"},
	{"tnbc", "萯"},
	{"tnbe", "藑"},
	{"tnbq", "薢"},
	{"tncr", "薝"},
	{"tnd", "芓"},
	{"tndf", "蓀"},
	{"tndo", "菰"},
	{"tndt", "䓝"},
	{"tndu", "芤"},
	{"tnef", "蒸"},
	{"tnfd", "蘇"},
	{"tnfn", "薊"},
	{"tnfq", "蘚"},
	{"tnhd", "葇"},
	{"tnhe", "芨"},
	{"tnhs", "艿 蓩"},
	{"tnhx", "萏"},
	{"tni", "苰"},
	{"tnih", "茅"},
	{"tnii", "蔃"},
	{"tnin", "芧 茤"},
	{"tniq", "荈"},
	{"tnir", "茗"},
	{"tniu", "苑"},
	{"tniv", "蕵"},
	{"tnkg", "莛"},
	{"tnkm", "莚"},
	{"tnlc", "藬"},
	{"tnld", "蒢"},
	{"tnle", "䔖"},
	{"tnlh", "苐"},
	{"tnli", "蔭 䕃"},
	{"tnlm", "蕯 薩"},
	{"tnlp", "蘟 𦻕"},
	{"tnlu", "𦶤"},
	{"tnlw", "蔯"},
	{"tnmm", "蒻"},
	{"tnmu", "蔬"},
	{"tnnc", "蕷"},
	{"tnnl", "鄸"},
	{"tno", "芡"},
	{"tnoe", "蕟"},
	{"tnok", "葵"},
	{"tnoo", "𦴧"},
	{"tnqd", "𦵴"},
	{"tnsj", "葞"},
	{"tnst", "萾"},
	{"tntg", "虇"},
	{"tnue", "菡"},
	{"tnui", "菟"},
	{"tnup", "葾"},
	{"tnus", "葂"},
	{"toav", "艱"},
	{"tob", "芮"},
	{"tobg", "蒮"},
	{"tod", "茠 茶"},
	{"todi", "苻"},
	{"tof", "苶"},
	{"tog", "茌 萑 雈"},
	{"togf", "蕉"},
	{"togx", "舊"},
	{"tohaf", "鸏"},
	{"tohg", "荏"},
	{"tohj", "𦭛"},
	{"tohqu", "氋"},
	{"tohs", "莋"},
	{"toi", "茷"},
	{"toiav", "養"},
	{"toie", "葰"},
	{"toii", "苓"},
	{"toik", "茯"},
	{"toin", "芩"},
	{"toip", "菍"},
	{"toir", "蒼"},
	{"tokf", "蘩"},
	{"tokg", "薙"},
	{"tokp", "𧁋"},
	{"tol", "茽"},
	{"tolb", "蓨"},
	{"told", "蓧"},
	{"tolh", "蓚"},
	{"tolk", "莜"},
	{"toll", "芥"},
	{"toma", "薈"},
	{"tomb", "菕 蘥"},
	{"tomd", "荼"},
	{"tomg", "荃"},
	{"tomm", "芢"},
	{"tomn", "芞 萮"},
	{"tomo", "薟"},
	{"tomr", "荅 荷"},
	{"tomt", "葊"},
	{"tonk", "葔"},
	{"tono", "歎"},
	{"tons", "芿"},
	{"tonwf", "鯗"},
	{"tooe", "蓌"},
	{"toog", "莝 難"},
	{"took", "蘞"},
	{"toom", "葅"},
	{"top", "花"},
	{"toqb", "蒨"},
	{"tord", "葆"},
	{"tose", "葠"},
	{"tosr", "𦴨"},
	{"totf", "蕪"},
	{"totv", "𧁓"},
	{"tou", "苮"},
	{"touk", "蒛"},
	{"towy", "莓"},
	{"toym", "𦮳"},
	{"toyr", "蓓 𦴩"},
	{"toyt", "莅"},
	{"toyv", "𦲤"},
	{"tp", "芯"},
	{"tpa", "荀 𦮂"},
	{"tpdc", "蘔"},
	{"tpfc", "蘏"},
	{"tpfd", "菊"},
	{"tph", "苾"},
	{"tphh", "芴"},
	{"tphp", "䓤"},
	{"tpi", "芍 芶"},
	{"tpib", "葡"},
	{"tpir", "𦲀"},
	{"tpko", "薿"},
	{"tpkp", "葱"},
	{"tpmw", "蔔"},
	{"tpou", "萄"},
	{"tpp", "芘"},
	{"tppa", "蒈"},
	{"tppd", "蘂"},
	{"tppp", "蕊"},
	{"tpr", "苟 茍"},
	{"tpru", "苞"},
	{"tpt", "𦭓"},
	{"tptd", "葉"},
	{"tpu", "芚"},
	{"tpua", "萅"},
	{"tpuu", "蒭"},
	{"tpyv", "蘹 𦮝"},
	{"tq", "羊 𦍋"},
	{"tqapv", "羯"},
	{"tqau", "羓"},
	{"tqbd", "𧂮"},
	{"tqbu", "着"},
	{"tqcsh", "羒"},
	{"tqda", "藉"},
	{"tqdb", "藕"},
	{"tqdi", "𦶮 𧂭"},
	{"tqfh", "莏"},
	{"tqhaf", "鴹"},
	{"tqhdw", "羳"},
	{"tqhhh", "羏"},
	{"tqhk", "葜"},
	{"tqhne", "羖"},
	{"tqhpm", "羝"},
	{"tqhr", "葀"},
	{"tqib", "蒱"},
	{"tqice", "羧"},
	{"tqihr", "羬"},
	{"tqij", "羢"},
	{"tqik", "菝"},
	{"tqixe", "羻"},
	{"tqj", "䒠"},
	{"tqjm", "蔧"},
	{"tqjmn", "羜"},
	{"tqjmu", "羦"},
	{"tqjtc", "羵"},
	{"tqka", "萶"},
	{"tqkd", "蓁"},
	{"tqkn", "羠"},
	{"tqkq", "菶"},
	{"tqlmo", "䍮"},
	{"tqlw", "菗"},
	{"tqm", "差"},
	{"tqmb", "菁"},
	{"tqmbb", "羺"},
	{"tqmhf", "羱"},
	{"tqmvm", "羥"},
	{"tqng", "羞"},
	{"tqo", "芙"},
	{"tqog", "蓷"},
	{"tqoii", "羚"},
	{"tqomn", "羭"},
	{"tqomo", "羷"},
	{"tqpu", "菢"},
	{"tqqo", "荴"},
	{"tqrd", "𧂈"},
	{"tqsmm", "翔"},
	{"tqsr", "萔"},
	{"tqsyq", "𦎾"},
	{"tqtqq", "羴"},
	{"tqumf", "羰"},
	{"tqwj", "蘀"},
	{"tqyt", "菈"},
	{"tqywm", "羶"},
	{"tr", "𦬅"},
	{"trhr", "莒"},
	{"trjd", "菋"},
	{"trji", "蕺"},
	{"trjl", "蘄"},
	{"trln", "剳"},
	{"trlr", "苢"},
	{"trmr", "蕗"},
	{"trnl", "鄀 鄯"},
	{"trog", "蓶"},
	{"trok", "敬"},
	{"tron", "荶"},
	{"trrg", "雚"},
	{"trrj", "蕇"},
	{"trrr", "虈"},
	{"trrs", "萼 蕚"},
	{"trsj", "葺"},
	{"tru", "𦬊"},
	{"trvp", "苠"},
	{"trye", "葭"},
	{"tsec", "藖"},
	{"tsem", "蘙"},
	{"tseo", "藂"},
	{"tsfi", "蔚"},
	{"tsh", "芀"},
	{"tshh", "茘"},
	{"tshr", "苕"},
	{"tsic", "蕻"},
	{"tsip", "荵 藯"},
	{"tsiq", "蕼"},
	{"tsit", "藍"},
	{"tsj", "茸"},
	{"tsja", "蘵"},
	{"tsjd", "蘗"},
	{"tsje", "菆"},
	{"tsjl", "𦳃"},
	{"tsk", "芛"},
	{"tskr", "莙"},
	{"tsle", "菣"},
	{"tsll", "茝 茞"},
	{"tsmg", "藋 䒰"},
	{"tsmh", "蓼"},
	{"tsmi", "蕁"},
	{"tsmj", "䕜"},
	{"tsmv", "萇"},
	{"tso", "𦬨"},
	{"tsp", "懃 苨"},
	{"tsql", "𦰡"},
	{"tsrf", "蔒"},
	{"tsrj", "薜"},
	{"tsrr", "蓲"},
	{"tss", "苣"},
	{"tsu", "芑"},
	{"tt", "井 卌 并"},
	{"ttbn", "葥"},
	{"ttc", "並"},
	{"ttcf", "藄"},
	{"ttcg", "蘣 蘳 𦸀"},
	{"ttcl", "䔮"},
	{"ttcnh", "豑"},
	{"ttgb", "冓"},
	{"ttgf", "蓔"},
	{"ttgi", "薱"},
	{"tthaf", "鵧 鷁"},
	{"tti", "丼"},
	{"ttjd", "蘜"},
	{"ttlm", "蓳"},
	{"ttm", "苷"},
	{"ttmbc", "頩"},
	{"ttmc", "萁"},
	{"ttmd", "𦳑"},
	{"ttmv", "葚"},
	{"ttmvn", "瓶"},
	{"ttnau", "艵 艶"},
	{"ttnl", "郱"},
	{"ttq", "𦭵"},
	{"ttqm", "蒫"},
	{"ttshi", "刱 剙"},
	{"ttt", "荓"},
	{"ttub", "蒴"},
	{"ttvb", "蘛"},
	{"ttwa", "蓸"},
	{"ttwi", "䔿"},
	{"ttwli", "蠲"},
	{"ttxc", "蒹"},
	{"tub", "朔"},
	{"tuirm", "馘"},
	{"tujt", "蘴"},
	{"tuu", "茁"},
	{"tvfa", "𦻖"},
	{"tvff", "蕬"},
	{"tvfh", "尠 蒶 䔋 𦯷"},
	{"tvfi", "葤 葯"},
	{"tvfm", "葒"},
	{"tvfp", "𧄉"},
	{"tvfr", "𦹄 𦿟"},
	{"tvft", "蘊"},
	{"tvfu", "蒓 蕝"},
	{"tvfv", "䕑"},
	{"tvfy", "蔠"},
	{"tvhi", "𦶥"},
	{"tvhl", "薌"},
	{"tvi", "戡"},
	{"tvid", "孳 孶 藥"},
	{"tvif", "鶿"},
	{"tvii", "兹 茲"},
	{"tvio", "苡"},
	{"tvip", "慈 慈"},
	{"tvis", "苭"},
	{"tvjd", "𦳀"},
	{"tvjr", "菇"},
	{"tvju", "𦹅"},
	{"tvks", "勘"},
	{"tvlk", "荍"},
	{"tvmg", "莊"},
	{"tvmi", "药 蔣 薅"},
	{"tvmw", "葘 蘠"},
	{"tvne", "菉"},
	{"tvno", "歁"},
	{"tvr", "茹"},
	{"tvrf", "蕠"},
	{"tvrq", "蒘"},
	{"tvsl", "𦶦"},
	{"tvsp", "𦲁"},
	{"tvuk", "𦾡"},
	{"tvvv", "葌"},
	{"tvvw", "菑"},
	{"tvyj", "斟"},
	{"tvyv", "𦴣"},
	{"tw", "曲 苗"},
	{"twa", "曹"},
	{"twbi", "蠆"},
	{"twbo", "躉 𧄌"},
	{"twcb", "莔"},
	{"twd", "菓"},
	{"twdi", "尊"},
	{"twfu", "蔨"},
	{"twgv", "薗"},
	{"twhaf", "鶓"},
	{"twhd", "菌"},
	{"twik", "猷"},
	{"twiku", "𨠫"},
	{"twim", "蔮"},
	{"twk", "奠 茵"},
	{"twkp", "蒽"},
	{"twks", "莮"},
	{"twla", "薯"},
	{"twlb", "萬"},
	{"twlc", "蕒"},
	{"twle", "蘉"},
	{"twlg", "蘿"},
	{"twli", "蔑 薎"},
	{"twlii", "蠤"},
	{"twln", "夢 甍 藅 蘮"},
	{"twlp", "薨 藣"},
	{"twlu", "瞢"},
	{"twmmv", "農"},
	{"twmrt", "豊"},
	{"twmv", "葨"},
	{"two", "苬"},
	{"twp", "葸"},
	{"twr", "茴"},
	{"twtj", "蓽"},
	{"twv", "𦮗"},
	{"twvf", "蔂"},
	{"twwf", "虆"},
	{"twwg", "蘲"},
	{"twww", "藟"},
	{"twyi", "苺"},
	{"txc", "兼"},
	{"tyaj", "䓬"},
	{"tybb", "蒂 薖"},
	{"tybg", "蘺"},
	{"tybo", "藃"},
	{"tybp", "蘢"},
	{"tybs", "蒡"},
	{"tybu", "𦾾"},
	{"tycb", "蔏 蔐"},
	{"tycj", "𧅵"},
	{"tyck", "茭"},
	{"tycu", "萒"},
	{"tycv", "蔉 𦶧"},
	{"tydk", "䔻"},
	{"tydl", "薪"},
	{"tydo", "藗"},
	{"tydu", "藽"},
	{"tyfd", "蒾"},
	{"tyfe", "菽"},
	{"tygq", "薘"},
	{"tygv", "薳"},
	{"tyhc", "蘋"},
	{"tyhj", "蓬"},
	{"tyhn", "苀"},
	{"tyhs", "芳"},
	{"tyib", "𦱀"},
	{"tyiu", "茺"},
	{"tyjj", "蓮"},
	{"tyk", "芠"},
	{"tylm", "芷"},
	{"tymh", "薉"},
	{"tymm", "蕋"},
	{"tymo", "蓫"},
	{"tymp", "茈"},
	{"tynb", "蓪"},
	{"tyoe", "藙"},
	{"tyog", "𦻗"},
	{"tyoj", "萃"},
	{"type", "𧃍"},
	{"typf", "䔝"},
	{"typm", "蔖"},
	{"typp", "藘"},
	{"typt", "蘆"},
	{"tyr", "苫"},
	{"tyra", "藷"},
	{"tyrb", "蒿 𧀎"},
	{"tyrd", "藁"},
	{"tyre", "蔎 蕸 蘐 𦻑"},
	{"tyrl", "蔀"},
	{"tyrn", "葶"},
	{"tyrp", "薧"},
	{"tyrv", "藹 蘘"},
	{"tysd", "葹"},
	{"tysk", "蔟"},
	{"tysm", "虀"},
	{"tyso", "蔙"},
	{"tysp", "𦴪"},
	{"tysy", "菸"},
	{"tyt", "苙"},
	{"tyta", "萻"},
	{"tytb", "𦽴"},
	{"tytg", "蕫"},
	{"tyti", "𦲂 𦵑"},
	{"tytj", "莘"},
	{"tytp", "薏"},
	{"tytr", "菩 蒟"},
	{"tytv", "菨"},
	{"tyue", "𡖂 䕫"},
	{"tyv", "芒"},
	{"tyvg", "蕹"},
	{"tyvo", "荄"},
	{"tyvp", "莣"},
	{"tyvu", "荒"},
	{"tyvw", "蓄"},
	{"tywi", "蓾"},
	{"tywv", "蓑"},
	{"tyx", "薺"},
	{"tyy", "苄"},
	{"tyyb", "藡"},
	{"tyyo", "蘧"},
	{"u", "山"},
	{"uahu", "嵋"},
	{"uamh", "崵"},
	{"uamo", "崼"},
	{"uana", "𡼏"},
	{"uapp", "崐 崑"},
	{"uapv", "嵑"},
	{"uau", "岜"},
	{"uav", "峎"},
	{"ubb", "崩"},
	{"ubcn", "崱"},
	{"ubln", "剬 剻"},
	{"ubm", "岨"},
	{"ubmbc", "顓"},
	{"ubme", "嵈"},
	{"ubmr", "峒"},
	{"ubnl", "酅"},
	{"ubno", "歂"},
	{"ubsd", "崢"},
	{"ubtu", "崗"},
	{"ubuu", "峴 𡷹"},
	{"uc", "崟 崯"},
	{"ucno", "嶔"},
	{"ucor", "峪"},
	{"ucwa", "嶒"},
	{"udam", "嵖"},
	{"udci", "崧"},
	{"udhe", "岥"},
	{"udmq", "𡺨"},
	{"udoo", "崍"},
	{"udsmg", "糶"},
	{"udw", "崠 崬"},
	{"udyg", "嵀"},
	{"ue", "凼"},
	{"ufb", "峭"},
	{"ufcb", "嵴"},
	{"ufdq", "嶙"},
	{"uffd", "嶸"},
	{"uffr", "巆"},
	{"uffs", "嶗"},
	{"ufgi", "巀"},
	{"ufok", "𪑛"},
	{"ufua", "𡾡"},
	{"ugce", "崚"},
	{"ugdi", "峙"},
	{"uggi", "崶"},
	{"uggu", "嶢 嶤"},
	{"ugni", "嶹"},
	{"ugno", "崁"},
	{"uh", "匕"},
	{"uha", "岶"},
	{"uhaf", "嶋"},
	{"uhag", "崲"},
	{"uhaj", "㟸"},
	{"uhdj", "嵙"},
	{"uhdp", "嵊"},
	{"uhdv", "崣"},
	{"uhdw", "嶓"},
	{"uhe", "岅"},
	{"uhej", "峯 峰"},
	{"uheq", "𡶶"},
	{"uher", "峈 峉"},
	{"uhey", "峂"},
	{"uhhj", "崥"},
	{"uhhl", "峁"},
	{"uhhw", "嵧"},
	{"uhi", "嵬"},
	{"uhk", "岆"},
	{"uhkb", "嶠"},
	{"uhmb", "巋"},
	{"uhml", "岓"},
	{"uhnb", "𡶺"},
	{"uhni", "嵐 𡺤"},
	{"uhnk", "岚"},
	{"uhok", "嶶 𡽪"},
	{"uhoo", "嵷"},
	{"uhoq", "嵂"},
	{"uhpa", "崏"},
	{"uhqi", "峨 峩"},
	{"uhrf", "嵨"},
	{"uhrj", "嶭"},
	{"uhs", "岝 岞"},
	{"uhuc", "巑"},
	{"uhud", "嵲"},
	{"uhvi", "巍"},
	{"uhxc", "嶼"},
	{"uiav", "崀"},
	{"uice", "峻"},
	{"uihf", "𡻕"},
	{"uihh", "嵗"},
	{"uihr", "嵅"},
	{"uihs", "峸 𡷫"},
	{"uihv", "崴"},
	{"uiih", "嵾"},
	{"uijb", "峬"},
	{"uile", "嵻"},
	{"uilr", "嵣"},
	{"uimo", "𡷑"},
	{"uip", "鬯"},
	{"ujbm", "𡸜 𡸽"},
	{"ujc", "岤"},
	{"ujcc", "巔"},
	{"ujcm", "崆"},
	{"ujcr", "嵱"},
	{"ujd", "櫱"},
	{"uje", "岐"},
	{"ujfd", "糱"},
	{"ujjl", "嶄"},
	{"ujki", "峵"},
	{"ujkp", "峔"},
	{"ujlmi", "蠥"},
	{"ujlo", "崨"},
	{"ujmf", "崇"},
	{"ujmrt", "豐"},
	{"ujnd", "孼"},
	{"ujp", "岮"},
	{"ujr", "岵"},
	{"ujv", "峖"},
	{"uk", "凶"},
	{"ukb", "峟"},
	{"ukcf", "嶚"},
	{"ukg", "峚"},
	{"ukhk", "嶽"},
	{"ukhu", "兇"},
	{"ukjj", "輋"},
	{"ukkb", "崤"},
	{"uklu", "崦"},
	{"ukmr", "崎"},
	{"ukn", "峓"},
	{"ukoo", "峽"},
	{"ukpb", "嵽"},
	{"uks", "屴"},
	{"uksr", "𡶐"},
	{"ul", "屮 屮"},
	{"ulbk", "岟"},
	{"ulln", "岪"},
	{"ulw", "岫"},
	{"ulwv", "嶁"},
	{"umam", "峘"},
	{"umbc", "崸"},
	{"umbl", "峏 耑"},
	{"umbs", "嶀"},
	{"umf", "炭"},
	{"umfm", "岯"},
	{"umgg", "崕 崖"},
	{"umhf", "㟲"},
	{"umig", "峌"},
	{"umli", "蚩"},
	{"ummj", "岸"},
	{"ummr", "峿"},
	{"ummu", "岏"},
	{"umnc", "嵿"},
	{"umnn", "峛"},
	{"umnr", "岢 㞹"},
	{"umoo", "豳"},
	{"umr", "岩"},
	{"umrt", "豈"},
	{"umt", "岍"},
	{"umtb", "巁"},
	{"umtj", "崋"},
	{"umto", "嶡"},
	{"umu", "屼"},
	{"umua", "嶜"},
	{"umvh", "岈"},
	{"umwg", "𡺉"},
	{"umwv", "崾"},
	{"unbq", "嶰"},
	{"unhe", "岋 岌"},
	{"unii", "嵹"},
	{"unmu", "峗 峞"},
	{"unne", "凾"},
	{"unot", "嶝"},
	{"unqd", "嵥"},
	{"unri", "巉"},
	{"unsd", "峥"},
	{"uog", "崔"},
	{"uogb", "巂 雟"},
	{"uogf", "嶕"},
	{"uogs", "嶲 𡼕"},
	{"uoic", "嶺"},
	{"uoii", "岭 岺"},
	{"uoin", "岑 岒"},
	{"uoir", "嵢"},
	{"uoll", "岕"},
	{"uomb", "崘 崙"},
	{"uomg", "峑"},
	{"uomn", "崳 嵛"},
	{"uomo", "嶮"},
	{"uomr", "峆 峇"},
	{"uon", "屹"},
	{"upa", "峋"},
	{"uphh", "岉"},
	{"upko", "嶷"},
	{"upr", "岣"},
	{"uqkd", "𡻈"},
	{"uqmb", "崝"},
	{"uqog", "嶊"},
	{"urji", "嶯"},
	{"urog", "嶉"},
	{"urrk", "巖 巗"},
	{"urrs", "崿"},
	{"uru", "𡵆"},
	{"urvp", "岷"},
	{"urytj", "辥"},
	{"usfi", "嶎"},
	{"ushi", "屻"},
	{"ushr", "岧"},
	{"usjr", "崌"},
	{"uskr", "峮"},
	{"usma", "嶍"},
	{"usmh", "嵺"},
	{"usp", "㞾"},
	{"usrr", "嶇"},
	{"uss", "岠"},
	{"usu", "屺"},
	{"usuu", "崛"},
	{"utav", "嶱"},
	{"utbuu", "覬"},
	{"utcd", "嶪 嶫"},
	{"utcw", "崷"},
	{"utgi", "嶬"},
	{"utgit", "豔"},
	{"utgs", "𡾞"},
	{"uthn", "凱"},
	{"uthni", "颽"},
	{"uthv", "巕"},
	{"utik", "獃"},
	{"utln", "剴"},
	{"utmbc", "顗"},
	{"utmc", "𡸷"},
	{"utmj", "㠏"},
	{"utmo", "嵌"},
	{"utmv", "嵁"},
	{"utnau", "艷"},
	{"utnl", "酆"},
	{"utok", "敳"},
	{"utqm", "嵯"},
	{"utrg", "巏"},
	{"utvi", "嵫"},
	{"utwa", "嶆"},
	{"utwi", "嶟"},
	{"utwv", "嶩"},
	{"utxc", "嵰"},
	{"uu", "出 屾 艸"},
	{"uuce", "嵕"},
	{"uufd", "粜"},
	{"uummf", "祟"},
	{"uuok", "𣁋"},
	{"uuu", "芔"},
	{"uuuu", "茻"},
	{"uuyhs", "芳"},
	{"uvii", "幽"},
	{"uvis", "岰"},
	{"uvmi", "嶈"},
	{"uvvw", "崰"},
	{"uwjr", "崮"},
	{"uwl", "岬"},
	{"uwlb", "嵎"},
	{"uwlj", "嶧"},
	{"uwly", "嶵"},
	{"uwp", "崽"},
	{"uybb", "崹"},
	{"uybk", "巘"},
	{"uybp", "巃"},
	{"uyhh", "嵃"},
	{"uyhm", "嵼"},
	{"uyoj", "崒"},
	{"uypt", "㠠"},
	{"uyrb", "嵩"},
	{"uyrd", "崞"},
	{"uyrn", "嵉"},
	{"uyro", "㠙"},
	{"uysd", "崺"},
	{"uyt", "岦"},
	{"uyti", "巇"},
	{"uytj", "峷 嶂"},
	{"uyvo", "峐"},
	{"v", "女"},
	{"vaa", "娼"},
	{"vab", "𡝭"},
	{"vabu", "媢"},
	{"vahm", "𡟙"},
	{"vahu", "媚"},
	{"vam", "妲"},
	{"vamh", "婸"},
	{"vamo", "媞"},
	{"vana", "𡢃"},
	{"vanb", "嫺"},
	{"vand", "嫻"},
	{"vank", "𡢄"},
	{"vanw", "孄"},
	{"vapp", "婫"},
	{"vawe", "嫚"},
	{"vayf", "𡡡"},
	{"vbac", "嫇"},
	{"vbbe", "嬡"},
	{"vbbq", "𡡞"},
	{"vbbr", "媧"},
	{"vbcv", "孆"},
	{"vbd", "婇"},
	{"vbgb", "㛵"},
	{"vbgr", "婤"},
	{"vbhg", "婬"},
	{"vbhx", "嫍"},
	{"vbjj", "媈"},
	{"vbkf", "㜣"},
	{"vbm", "姐"},
	{"vbme", "媛"},
	{"vbmr", "姛"},
	{"vbou", "媱"},
	{"vbq", "𡛾"},
	{"vbsd", "婙"},
	{"vbt", "姍"},
	{"vbuc", "㛝"},
	{"vbuu", "娊"},
	{"vbuv", "𡢞"},
	{"vbv", "娞"},
	{"vbwd", "𢑥"},
	{"vby", "𡛓"},
	{"vci", "妐"},
	{"vcim", "𡟸"},
	{"vcnh", "娣"},
	{"vcru", "娧"},
	{"vcsh", "妢"},
	{"vdam", "㜁"},
	{"vdd", "㛦"},
	{"vddf", "𡢾"},
	{"vddo", "𡢟"},
	{"vdj", "妺"},
	{"vdks", "勦"},
	{"vdl", "娕"},
	{"vdlc", "嬾"},
	{"vdlk", "嫩"},
	{"vdln", "剿"},
	{"vdlo", "嫰"},
	{"vdmf", "𡞫"},
	{"vdmq", "媁"},
	{"vdnl", "鄛"},
	{"vdoo", "婡"},
	{"vdr", "𡜺"},
	{"vdwf", "媡"},
	{"ve", "奴"},
	{"vea", "㛥"},
	{"vebt", "盝"},
	{"vec", "𨥬"},
	{"veks", "努"},
	{"velb", "帑"},
	{"veln", "剝"},
	{"vemr", "砮"},
	{"ven", "弩"},
	{"vend", "孥"},
	{"veobo", "胬"},
	{"vep", "怒"},
	{"veq", "拏"},
	{"vesqf", "駑"},
	{"vfa", "曫"},
	{"vfabs", "𦄡"},
	{"vfamo", "緹"},
	{"vfaph", "緆"},
	{"vfapp", "緄"},
	{"vfase", "繓"},
	{"vfawe", "縵"},
	{"vfb", "娋"},
	{"vfbb", "嫦 綳"},
	{"vfbbb", "縎"},
	{"vfbbe", "綬"},
	{"vfbbr", "緺"},
	{"vfbcr", "綗"},
	{"vfbcv", "纓"},
	{"vfbd", "綵 𡡢"},
	{"vfbg", "𡠠"},
	{"vfbgr", "綢"},
	{"vfbhx", "縚"},
	{"vfbjj", "緷"},
	{"vfbm", "組"},
	{"vfbme", "緩"},
	{"vfbmr", "絧"},
	{"vfbnd", "綒"},
	{"vfbof", "縩"},
	{"vfbr", "絅"},
	{"vfbsh", "絼"},
	{"vfbtu", "綱"},
	{"vfbtv", "網"},
	{"vfbu", "矕"},
	{"vfbuh", "緲"},
	{"vfbuo", "繉"},
	{"vfbv", "綏 𡣖"},
	{"vfbw", "㜭"},
	{"vfc", "鑾"},
	{"vfcip", "総"},
	{"vfcnh", "綈"},
	{"vfcor", "綌"},
	{"vfcsh", "紛"},
	{"vfcwa", "繒"},
	{"vfd", "欒"},
	{"vfdbu", "緗"},
	{"vfdd", "綝"},
	{"vfdi", "紂"},
	{"vfdl", "綀"},
	{"vfdm", "絊"},
	{"vfdmq", "緯"},
	{"vfdq", "嫾"},
	{"vfdv", "𡞱"},
	{"vfdwf", "練"},
	{"vfeed", "縔"},
	{"vfeee", "綴"},
	{"vff", "婒 𤓖"},
	{"vffb", "綃"},
	{"vffbr", "緔"},
	{"vffd", "嬫"},
	{"vffdq", "繗"},
	{"vfff", "緂"},
	{"vffff", "𦇝"},
	{"vffh", "紗"},
	{"vffmu", "絖"},
	{"vffq", "絆"},
	{"vffqu", "綣"},
	{"vfgce", "綾"},
	{"vfgg", "絓"},
	{"vfggu", "繞"},
	{"vfgi", "紶"},
	{"vfgow", "繬"},
	{"vfgr", "結"},
	{"vfgrc", "纈"},
	{"vfgrr", "繥"},
	{"vfgwc", "續"},
	{"vfh", "妙"},
	{"vfhab", "綿"},
	{"vfhae", "線"},
	{"vfhaf", "鷥 鸞 𪆓"},
	{"vfhce", "繌"},
	{"vfhds", "綉"},
	{"vfhdv", "緌"},
	{"vfhdw", "繙"},
	{"vfheq", "絳"},
	{"vfher", "絡"},
	{"vfhey", "終"},
	{"vfhg", "紝"},
	{"vfhgf", "纁"},
	{"vfhhj", "綼"},
	{"vfhj", "䊹"},
	{"vfhjd", "絑"},
	{"vfhje", "緞"},
	{"vfhjg", "緟"},
	{"vfhjm", "綞"},
	{"vfhkb", "繑"},
	{"vfhon", "絎"},
	{"vfhoo", "縰 縱"},
	{"vfhor", "綹"},
	{"vfhpa", "緍"},
	{"vfhqo", "紩"},
	{"vfhsb", "編"},
	{"vfhsk", "綟 繳"},
	{"vfhuc", "纘"},
	{"vfhvp", "紙"},
	{"vfhwp", "總"},
	{"vfibi", "縛"},
	{"vfihr", "緘"},
	{"vfii", "綫"},
	{"vfiih", "縿"},
	{"vfij", "絨"},
	{"vfije", "絿"},
	{"vfik", "紁 紎"},
	{"vfikk", "紱"},
	{"vfiku", "紌"},
	{"vfill", "絒"},
	{"vfimo", "絘"},
	{"vfir", "紿"},
	{"vfirm", "緎"},
	{"vfish", "𦆲"},
	{"vfitc", "纊"},
	{"vfiwg", "纏"},
	{"vfjbc", "縝"},
	{"vfjbd", "綍"},
	{"vfjbj", "䋻"},
	{"vfjcm", "𦁈"},
	{"vfjii", "縳"},
	{"vfjim", "纎"},
	{"vfjip", "繐"},
	{"vfjka", "緒"},
	{"vfjki", "綋"},
	{"vfjlo", "緁"},
	{"vfjlv", "緀"},
	{"vfjmc", "縯 繽"},
	{"vfjmf", "綜"},
	{"vfjmm", "縇"},
	{"vfjmn", "紵 𦅜"},
	{"vfjmo", "綻"},
	{"vfjmu", "綄"},
	{"vfjnu", "綩"},
	{"vfjoa", "縮"},
	{"vfjp", "紽"},
	{"vfjpn", "𦆭"},
	{"vfjqr", "縖"},
	{"vfjrr", "綰"},
	{"vfjyj", "縡"},
	{"vfk", "奱"},
	{"vfkcf", "繚"},
	{"vfki", "紘"},
	{"vfkkb", "絺"},
	{"vfkmr", "綺"},
	{"vfkms", "絝"},
	{"vfkn", "䊵"},
	{"vfkni", "紈"},
	{"vfkpb", "𦄂"},
	{"vfks", "糼"},
	{"vflbi", "𥿢"},
	{"vflbk", "紻"},
	{"vflbu", "紞"},
	{"vflgm", "繣"},
	{"vflll", "紃"},
	{"vflln", "紼"},
	{"vflmc", "繢"},
	{"vflmi", "蠻"},
	{"vflmo", "絩"},
	{"vflmy", "緋"},
	{"vflw", "紬"},
	{"vflwl", "紳"},
	{"vflwp", "絏"},
	{"vflwv", "縷"},
	{"vflx", "繡"},
	{"vfm", "紅"},
	{"vfma", "絔"},
	{"vfmbb", "繻"},
	{"vfmbe", "纋"},
	{"vfmbi", "繧"},
	{"vfmbk", "緛 𦅙"},
	{"vfmbm", "絚"},
	{"vfmd", "紆"},
	{"vfmf", "紑"},
	{"vfmgk", "緻"},
	{"vfmhf", "縓"},
	{"vfmia", "縉"},
	{"vfmig", "絰"},
	{"vfmlb", "緉"},
	{"vfmlk", "綆"},
	{"vfmmi", "紜"},
	{"vfmmp", "纚"},
	{"vfmn", "糽"},
	{"vfmre", "𦂥"},
	{"vfmu", "姯"},
	{"vfmvi", "縟"},
	{"vfmvm", "經"},
	{"vfmwf", "縹"},
	{"vfmwg", "緾 纒"},
	{"vfmwl", "緬"},
	{"vfmwm", "繮"},
	{"vfn", "彎"},
	{"vfnau", "絻"},
	{"vfnbq", "繲"},
	{"vfnd", "孿"},
	{"vfng", "紐"},
	{"vfnhb", "繘"},
	{"vfnhd", "䋴"},
	{"vfnhe", "級"},
	{"vfnii", "繈"},
	{"vfnin", "紓"},
	{"vfnkf", "繺"},
	{"vfnkg", "綎"},
	{"vfnkm", "綖"},
	{"vfnl", "紖"},
	{"vfnob", "縃"},
	{"vfnri", "纔"},
	{"vfnst", "䋼"},
	{"vfoae", "緮"},
	{"vfob", "納"},
	{"vfobo", "臠"},
	{"vfodi", "紨"},
	{"vfog", "維"},
	{"vfohg", "絍"},
	{"vfohh", "紾"},
	{"vfoim", "纖"},
	{"vfoin", "紟"},
	{"vfoip", "𦁤"},
	{"vfok", "變"},
	{"vfold", "縧"},
	{"vfoll", "紒"},
	{"vfoma", "繪"},
	{"vfomb", "綸"},
	{"vfomg", "絟"},
	{"vfomk", "緶"},
	{"vfomn", "緰"},
	{"vfomr", "給"},
	{"vfon", "紇"},
	{"vfonk", "緱"},
	{"vfopd", "絁"},
	{"vford", "緥"},
	{"vfoto", "纀"},
	{"vfp", "戀"},
	{"vfpa", "絢"},
	{"vfpi", "約"},
	{"vfpmm", "緪"},
	{"vfpou", "綯"},
	{"vfpp", "紕"},
	{"vfpr", "絇"},
	{"vfpt", "紲"},
	{"vfptd", "緤"},
	{"vfpu", "純"},
	{"vfpuu", "縐"},
	{"vfq", "姅 攣"},
	{"vfqjl", "綁"},
	{"vfqkd", "縥"},
	{"vfqmb", "綪"},
	{"vfqmc", "績"},
	{"vfqmf", "縤"},
	{"vfqu", "婘 𡡀"},
	{"vfr", "轡 㘘"},
	{"vfrb", "絹"},
	{"vfrbc", "縜"},
	{"vfrhr", "絽"},
	{"vfrpa", "緡"},
	{"vfrrd", "繰"},
	{"vfrrj", "繟"},
	{"vfrsj", "緝"},
	{"vfrxu", "繩"},
	{"vfshi", "紉"},
	{"vfshr", "紹"},
	{"vfshu", "絕"},
	{"vfsit", "繿"},
	{"vfsiu", "䌫"},
	{"vfsje", "緅 𦀩"},
	{"vfsme", "綅"},
	{"vfsmh", "繆"},
	{"vfsmi", "𦅛"},
	{"vfsp", "𥿡"},
	{"vfstt", "𦂤"},
	{"vfsu", "紀"},
	{"vfswu", "纜"},
	{"vftak", "縸"},
	{"vftbk", "繖"},
	{"vftct", "縊"},
	{"vftcw", "緧"},
	{"vftgr", "繕"},
	{"vftlj", "緙"},
	{"vftlk", "緓"},
	{"vftm", "紺"},
	{"vftmc", "綨"},
	{"vftqm", "縒"},
	{"vftt", "絣"},
	{"vftwi", "繜"},
	{"vftwv", "繷"},
	{"vftxc", "縑"},
	{"vfu", "巒"},
	{"vfubb", "繃"},
	{"vfuce", "緵"},
	{"vfufk", "𦆮"},
	{"vfuob", "纗"},
	{"vfuog", "繀"},
	{"vfuu", "絀"},
	{"vfv", "孌"},
	{"vfvif", "絲"},
	{"vfvl", "糾"},
	{"vfvne", "綠"},
	{"vfvno", "緣"},
	{"vfvvd", "繅"},
	{"vfvvi", "繼"},
	{"vfvvw", "緇"},
	{"vfw", "細"},
	{"vfwd", "綑"},
	{"vfwgg", "纆"},
	{"vfwk", "絪"},
	{"vfwlg", "纙"},
	{"vfwlj", "繹"},
	{"vfwlv", "繯"},
	{"vfwot", "縕"},
	{"vfwp", "緦"},
	{"vfwtj", "縪"},
	{"vfwvf", "縲"},
	{"vfyaj", "綽"},
	{"vfybb", "締"},
	{"vfybc", "緽"},
	{"vfybs", "縍"},
	{"vfyck", "絞"},
	{"vfyg", "紸"},
	{"vfygq", "繨"},
	{"vfyhj", "縫"},
	{"vfyhr", "縋"},
	{"vfyhs", "紡"},
	{"vfyia", "織"},
	{"vfyij", "繂"},
	{"vfyiu", "統"},
	{"vfyj", "紏"},
	{"vfyjj", "縺"},
	{"vfyk", "紋"},
	{"vfylm", "䊼"},
	{"vfylr", "繾"},
	{"vfyoj", "綷"},
	{"vfypt", "纑"},
	{"vfyrb", "縞"},
	{"vfyrd", "綧"},
	{"vfyrf", "綡"},
	{"vfyrn", "𦂃"},
	{"vfyrv", "纕"},
	{"vfyso", "縼"},
	{"vfyto", "繸"},
	{"vfytp", "繶"},
	{"vfytu", "縌"},
	{"vfyub", "縭"},
	{"vfyvi", "絃"},
	{"vfyvo", "絯"},
	{"vfyvq", "縴"},
	{"vfywm", "繵"},
	{"vfywv", "縗"},
	{"vgb", "姌"},
	{"vgc", "銺"},
	{"vgce", "婈"},
	{"vgf", "焋"},
	{"vgg", "娃"},
	{"vggu", "嬈"},
	{"vgk", "奊 奘"},
	{"vgni", "嬦"},
	{"vgow", "嬙"},
	{"vgp", "娡"},
	{"vgr", "姞"},
	{"vgrg", "嬯"},
	{"vgrr", "嬉 𡣗"},
	{"vgrv", "媴"},
	{"vgsk", "㜜"},
	{"vgtj", "婞"},
	{"vgv", "娤"},
	{"vgyhv", "裝"},
	{"vhab", "婂"},
	{"vhaf", "𡡅"},
	{"vhag", "媓"},
	{"vhav", "嬝"},
	{"vhbr", "姠"},
	{"vhbu", "𡜍"},
	{"vhcn", "嬼"},
	{"vhcq", "𡤒"},
	{"vhd", "姀"},
	{"vhdn", "娳"},
	{"vhds", "㛢"},
	{"vhdv", "婑"},
	{"vhdw", "嬏"},
	{"vhej", "㛔"},
	{"vhey", "㚵"},
	{"vhg", "妊"},
	{"vhgu", "姺"},
	{"vhhj", "婢"},
	{"vhhl", "㚹"},
	{"vhhw", "媹"},
	{"vhi", "媿 𡚸"},
	{"vhiil", "鄉"},
	{"vhj", "奷"},
	{"vhjd", "姝"},
	{"vhjg", "媑"},
	{"vhjm", "娷"},
	{"vhjr", "姡"},
	{"vhk", "妖"},
	{"vhkb", "嬌"},
	{"vhkp", "婖"},
	{"vhml", "妡"},
	{"vhmr", "姤"},
	{"vhnb", "姵"},
	{"vhnh", "𡠨"},
	{"vhp", "奼"},
	{"vhpa", "婚"},
	{"vhqi", "娥"},
	{"vhqm", "姓"},
	{"vhqo", "妷"},
	{"vhqu", "㚪"},
	{"vhs", "妒 妰"},
	{"vhsb", "媥"},
	{"vhsk", "嬓"},
	{"vhuc", "㜺"},
	{"vhup", "媳"},
	{"vhwp", "媲"},
	{"vhxe", "嫂"},
	{"vhxs", "𡞲"},
	{"vhxu", "婗"},
	{"vi", "厶 幺"},
	{"viav", "娘"},
	{"vic", "𨫥"},
	{"vice", "㛖"},
	{"vid", "槳 樂"},
	{"vidd", "嫲"},
	{"vidi", "嬤"},
	{"vidy", "孊"},
	{"vie", "漿"},
	{"vif", "糸 糹 𢇃"},
	{"vifd", "䊢"},
	{"vig", "墏 㛇"},
	{"vihe", "发"},
	{"vihi", "幾 𡜐"},
	{"vihml", "斷"},
	{"vihs", "娍"},
	{"vihv", "媙"},
	{"viik", "獎"},
	{"viil", "嫏"},
	{"vij", "娀"},
	{"vikf", "媯"},
	{"viks", "幼"},
	{"viksf", "鴢"},
	{"vilb", "嫞"},
	{"vile", "嫝"},
	{"vilmi", "螿"},
	{"viln", "劙"},
	{"vilr", "㜍"},
	{"vimcw", "醬"},
	{"vine", "𡛻"},
	{"vio", "以"},
	{"viok", "娭"},
	{"vir", "始"},
	{"vis", "幻"},
	{"vitc", "嬚"},
	{"vitf", "嫬"},
	{"viuh", "娏"},
	{"viv", "𡛟"},
	{"viw", "畿"},
	{"vjb", "姉"},
	{"vjbc", "嫃"},
	{"vjbj", "婻"},
	{"vjbm", "𡝮"},
	{"vjcb", "𡢠"},
	{"vjcr", "嫆"},
	{"vjd", "妹 𡜻"},
	{"vje", "妓"},
	{"vjhp", "姹"},
	{"vjhw", "嬸"},
	{"vjii", "嫥"},
	{"vjka", "媎"},
	{"vjkp", "姥"},
	{"vjks", "㛈"},
	{"vjlo", "婕"},
	{"vjmc", "嬪 𡤧"},
	{"vjmf", "婃"},
	{"vjmi", "𡝬"},
	{"vjmm", "媗"},
	{"vjmo", "婝 嫁"},
	{"vjmu", "㛡"},
	{"vjnu", "婉"},
	{"vjpn", "嬣"},
	{"vjr", "姑"},
	{"vjrb", "媩"},
	{"vjrj", "嫴"},
	{"vjrr", "婠"},
	{"vjtc", "𡤐"},
	{"vjuc", "𡣑"},
	{"vjv", "姲"},
	{"vkb", "姷"},
	{"vkbt", "盭"},
	{"vkcf", "嫽"},
	{"vke", "𡛀"},
	{"vki", "𡛕"},
	{"vkk", "𡘾"},
	{"vkkb", "㛓"},
	{"vkmb", "媠"},
	{"vkmr", "婍"},
	{"vkms", "姱"},
	{"vkn", "姨"},
	{"vkni", "𡚺"},
	{"vkok", "嫉"},
	{"vkpb", "𡠹"},
	{"vl", "凵"},
	{"vlbk", "姎"},
	{"vlbu", "妉"},
	{"vle", "𡝯"},
	{"vlgm", "嫿"},
	{"vlhbr", "嚮"},
	{"vlllm", "丱"},
	{"vllmi", "蠁"},
	{"vlm", "爿"},
	{"vlmc", "嬇"},
	{"vlmo", "姚"},
	{"vlmt", "嬧"},
	{"vlmy", "婔"},
	{"vloiv", "饗"},
	{"vlok", "收"},
	{"vlw", "妯"},
	{"vlwl", "妽"},
	{"vlws", "娉"},
	{"vlwv", "㜢"},
	{"vlxh", "姊"},
	{"vlxl", "婣"},
	{"vlyta", "響"},
	{"vm", "妅"},
	{"vmam", "姮"},
	{"vmbb", "嬬"},
	{"vmbdi", "將"},
	{"vmbe", "𡤕"},
	{"vmbi", "𡢅"},
	{"vmbk", "媆"},
	{"vmbm", "𡠭"},
	{"vmbs", "嫮"},
	{"vmbu", "孀"},
	{"vmbwd", "彙"},
	{"vmd", "牀 㚥"},
	{"vmf", "妚"},
	{"vmfb", "嬭"},
	{"vmfft", "彝"},
	{"vmfhk", "𢑱"},
	{"vmfht", "彜"},
	{"vmfj", "㛁"},
	{"vmfm", "㚰"},
	{"vmg", "壯"},
	{"vmgg", "娾"},
	{"vmgi", "𡛼"},
	{"vmgk", "𡟹"},
	{"vmgow", "牆"},
	{"vmhf", "嫄"},
	{"vmhj", "纤"},
	{"vmhml", "斨"},
	{"vmi", "戕"},
	{"vmig", "姪 𤕸"},
	{"vmik", "狀"},
	{"vmj", "奸"},
	{"vmjj", "姸"},
	{"vmlii", "蠿"},
	{"vmliu", "缆"},
	{"vmlm", "婭"},
	{"vmmi", "妘"},
	{"vmmnr", "牁"},
	{"vmmp", "孋"},
	{"vmmr", "娪"},
	{"vmmu", "妧"},
	{"vmmv", "娠"},
	{"vmn", "奵"},
	{"vmnom", "经"},
	{"vmnr", "妸"},
	{"vmob", "𡛦"},
	{"vmoir", "牄"},
	{"vmpm", "娬"},
	{"vmpop", "彘"},
	{"vmqs", "纬"},
	{"vmr", "妬"},
	{"vmrc", "织"},
	{"vmrr", "𡟵"},
	{"vmt", "妍"},
	{"vmtq", "牂"},
	{"vmue", "𡟺"},
	{"vmv", "妝"},
	{"vmvi", "媷"},
	{"vmvm", "娙"},
	{"vmwf", "嫖"},
	{"vmwl", "媔"},
	{"vmwv", "婹"},
	{"vmyf", "嫣"},
	{"vmyhs", "纺"},
	{"vmyiu", "统"},
	{"vmym", "姃"},
	{"vnau", "娩"},
	{"vnbk", "𡞵"},
	{"vnbp", "嫓"},
	{"vncr", "㜬"},
	{"vnd", "好"},
	{"vnf", "妳"},
	{"vng", "妞"},
	{"vnhd", "媃"},
	{"vnhs", "奶"},
	{"vnin", "妤 姼"},
	{"vnir", "姳"},
	{"vnkg", "娗"},
	{"vnkm", "娫"},
	{"vnlb", "嫷"},
	{"vnlr", "婀"},
	{"vnm", "彑"},
	{"vnme", "彔"},
	{"vnmm", "嫋"},
	{"vnmo", "彖"},
	{"vnmu", "姽"},
	{"vnob", "婿"},
	{"vnok", "𡞳"},
	{"vnot", "嬁"},
	{"vnst", "𡟚"},
	{"vnum", "嬔"},
	{"vnyi", "娹"},
	{"vob", "妠"},
	{"voge", "孇"},
	{"vogf", "嫶"},
	{"vohaf", "鶨"},
	{"vohg", "姙"},
	{"vohh", "𡛧"},
	{"voii", "姈"},
	{"voim", "孅"},
	{"voin", "妗"},
	{"volii", "蠡"},
	{"voll", "妎"},
	{"vom", "㚱"},
	{"vomb", "婨"},
	{"vomg", "姾"},
	{"vomn", "媮"},
	{"vomo", "嬐"},
	{"vomr", "姶"},
	{"vomt", "媕"},
	{"vomv", "婾"},
	{"voq", "姩"},
	{"vord", "媬"},
	{"votf", "嫵"},
	{"vowy", "娒"},
	{"voyr", "㜃"},
	{"vpa", "姰"},
	{"vpd", "她"},
	{"vpfd", "婅"},
	{"vph", "妼"},
	{"vphh", "𡛁"},
	{"vpi", "妁"},
	{"vpim", "㚬"},
	{"vpkp", "𡟟"},
	{"vpp", "妣"},
	{"vpr", "姁"},
	{"vptd", "媟"},
	{"vpuu", "媰"},
	{"vqj", "妦"},
	{"vqjp", "𡣺"},
	{"vqka", "媋"},
	{"vqkd", "嫀"},
	{"vqmb", "婧"},
	{"vqmf", "嫊"},
	{"vqmv", "婊"},
	{"vqyt", "𡝰"},
	{"vr", "如"},
	{"vrb", "娟"},
	{"vrd", "桇"},
	{"vrhaf", "鴽"},
	{"vrlb", "帤"},
	{"vrp", "恕"},
	{"vrq", "挐 𢳉"},
	{"vrrd", "嬠"},
	{"vrrj", "嬋"},
	{"vrrk", "孍"},
	{"vrvif", "絮"},
	{"vrvk", "娛"},
	{"vrvp", "姄"},
	{"vrye", "婽"},
	{"vryo", "娖"},
	{"vsbt", "𥁒"},
	{"vseg", "𡠩"},
	{"vshaf", "鶭"},
	{"vshr", "妱"},
	{"vshu", "娓"},
	{"vsj", "㛅"},
	{"vsje", "娵"},
	{"vsjr", "婮"},
	{"vsk", "𡛂"},
	{"vskp", "嫕"},
	{"vskr", "𡝗"},
	{"vsll", "姫 姬"},
	{"vsmb", "婦"},
	{"vsmg", "嬥"},
	{"vsmh", "嫪"},
	{"vsp", "妮"},
	{"vsqf", "媽"},
	{"vsql", "娜"},
	{"vsrq", "𡢡"},
	{"vsrr", "嫗"},
	{"vss", "姖"},
	{"vstr", "嫟"},
	{"vstt", "𡟛"},
	{"vstv", "㜊"},
	{"vsu", "妃"},
	{"vsyi", "孎"},
	{"vtab", "𡤃"},
	{"vtad", "𡤄"},
	{"vtak", "嫫"},
	{"vtaw", "孏"},
	{"vtbc", "婰"},
	{"vtbn", "媊"},
	{"vtc", "娂"},
	{"vtch", "𡝱"},
	{"vtcl", "𡡒"},
	{"vtco", "𡣘"},
	{"vtge", "𡡷"},
	{"vtgi", "嬟"},
	{"vtgk", "媄"},
	{"vtgr", "嫸"},
	{"vtgv", "𡟜"},
	{"vtgw", "𡤑"},
	{"vthg", "嬞"},
	{"vtio", "𡝳"},
	{"vtkr", "婼"},
	{"vtlb", "𡠪"},
	{"vtlf", "嬿"},
	{"vtlk", "媖"},
	{"vtlm", "嫤"},
	{"vtlo", "嫨"},
	{"vtm", "姏"},
	{"vtmc", "娸 嫹"},
	{"vtmd", "媒"},
	{"vtmj", "嬅 𡞴"},
	{"vtmu", "𡝴"},
	{"vtnu", "𡟃"},
	{"vtpd", "𡡣"},
	{"vtsj", "媶"},
	{"vtt", "姘"},
	{"vttb", "媾"},
	{"vtvi", "𡞰"},
	{"vtvp", "嬨"},
	{"vtw", "媌"},
	{"vtwk", "𡟻"},
	{"vtwv", "𡢿"},
	{"vtxc", "嫌"},
	{"vu", "奾"},
	{"vuau", "𡡻"},
	{"vugk", "嬍"},
	{"vuhi", "𡟶"},
	{"vumb", "媏"},
	{"vumi", "媸"},
	{"vumj", "婩"},
	{"vuob", "孈"},
	{"vuog", "雝"},
	{"vuuk", "媺"},
	{"vv", "奻"},
	{"vvf", "災"},
	{"vvff", "𡤻"},
	{"vvid", "㜰"},
	{"vvii", "𡡤"},
	{"vvio", "姒"},
	{"vvm", "纟"},
	{"vvmbu", "𩠐"},
	{"vvne", "娽"},
	{"vvno", "𡟇 𡟼"},
	{"vvrau", "邕"},
	{"vvv", "姦 巛"},
	{"vvw", "甾"},
	{"vvwd", "巢"},
	{"vw", "㚼"},
	{"vwb", "媦"},
	{"vwd", "婐"},
	{"vwg", "娌"},
	{"vwhaf", "鶅"},
	{"vwjlo", "疀"},
	{"vwjr", "婟"},
	{"vwk", "姻"},
	{"vwkp", "𡟯"},
	{"vwks", "娚"},
	{"vwlc", "㜥"},
	{"vwlg", "𡤢"},
	{"vwlj", "嬕"},
	{"vwlk", "嬽"},
	{"vwlv", "嬛"},
	{"vwot", "媼"},
	{"vwvf", "嫘"},
	{"vwyi", "姆"},
	{"vwyl", "𡜼"},
	{"vyaj", "婥"},
	{"vybb", "媂"},
	{"vybc", "媜"},
	{"vybs", "嫎"},
	{"vycb", "嫡"},
	{"vyck", "姣"},
	{"vydu", "𡤅"},
	{"vyfe", "婌"},
	{"vyg", "妵"},
	{"vyhn", "妔"},
	{"vyhr", "𡠻"},
	{"vyhs", "妨"},
	{"vyhv", "㛄"},
	{"vyia", "嬂"},
	{"vyk", "妏"},
	{"vymr", "娮"},
	{"vymy", "𡛨"},
	{"vypd", "嫭"},
	{"vypk", "𡢢"},
	{"vyrf", "婛"},
	{"vyrn", "婷 㜲"},
	{"vyrv", "孃"},
	{"vyso", "媫 嫙"},
	{"vytj", "嫜"},
	{"vytp", "嬑"},
	{"vytr", "婄"},
	{"vyvi", "妶"},
	{"vywm", "嬗"},
	{"vywv", "㜳"},
	{"vyx", "𡣙"},
	{"w", "田"},
	{"wb", "胃"},
	{"wbb", "朙"},
	{"wbmbc", "顒"},
	{"wbp", "愚"},
	{"wc", "四"},
	{"wcb", "囧"},
	{"wchaf", "鷶"},
	{"wche", "畟"},
	{"wcys", "圀"},
	{"wd", "困 果"},
	{"wdh", "团"},
	{"wdhv", "褁"},
	{"wdmbc", "顆"},
	{"wdmq", "圍"},
	{"wdnin", "夥"},
	{"wdye", "敤"},
	{"weee", "瑆 畷"},
	{"wfdq", "疄"},
	{"wfgr", "黠"},
	{"wfgwc", "黷"},
	{"wfice", "黢"},
	{"wfiih", "黲"},
	{"wfik", "默"},
	{"wfip", "黓"},
	{"wfjbc", "黰"},
	{"wfjnu", "黦"},
	{"wfklu", "黤"},
	{"wflbu", "黕"},
	{"wfmvu", "黖"},
	{"wfmwg", "黫"},
	{"wfncr", "黵"},
	{"wfnin", "黟"},
	{"wfoin", "黔"},
	{"wfomt", "黭"},
	{"wfq", "畔"},
	{"wfqu", "圈"},
	{"wftm", "黚"},
	{"wftmv", "黮"},
	{"wfuu", "黜"},
	{"wfvis", "黝"},
	{"wfyg", "𪐴"},
	{"wfypt", "黸"},
	{"wfyr", "點"},
	{"wfyrf", "黥"},
	{"wfyta", "黯"},
	{"wg", "里"},
	{"wgdi", "畤"},
	{"wgf", "黑"},
	{"wgfg", "墨"},
	{"wgg", "畦"},
	{"wgit", "圔"},
	{"wgni", "疇"},
	{"wgnin", "野"},
	{"wgrv", "園"},
	{"wgtj", "圉"},
	{"whd", "囷"},
	{"whe", "畈"},
	{"wher", "略 畧"},
	{"whgi", "𤴆"},
	{"whjg", "畽"},
	{"whnd", "𡇙"},
	{"wice", "畯"},
	{"wihaf", "鸀"},
	{"wihu", "㽙"},
	{"wijb", "圃"},
	{"wik", "畎"},
	{"wino", "歜"},
	{"wirm", "國 㽣"},
	{"wiye", "斀"},
	{"wj", "毋 毌"},
	{"wjbuc", "貫"},
	{"wjhaf", "鷝 鸅"},
	{"wjii", "團"},
	{"wjnu", "瑂 畹"},
	{"wjok", "斁"},
	{"wjr", "固"},
	{"wk", "因"},
	{"wkb", "囿"},
	{"wkmr", "畸"},
	{"wkno", "欭"},
	{"wkp", "恩"},
	{"wks", "男"},
	{"wl", "甲"},
	{"wlbi", "禺"},
	{"wlbm", "罝"},
	{"wlbnd", "罦"},
	{"wlbuc", "買"},
	{"wlcwa", "罾"},
	{"wldd", "罧"},
	{"wleee", "罬"},
	{"wlga", "圕"},
	{"wlgg", "罣"},
	{"wlggy", "罫"},
	{"wlgrv", "瞏"},
	{"wlgtj", "睪"},
	{"wlhaf", "鴨"},
	{"wlhhw", "罶"},
	{"wlhvo", "罛"},
	{"wlibp", "罷"},
	{"wlipf", "羆"},
	{"wlirm", "罭"},
	{"wljbj", "罱"},
	{"wljbm", "置"},
	{"wljka", "署"},
	{"wljr", "罟"},
	{"wlklu", "罨"},
	{"wll", "罒"},
	{"wlll", "甽"},
	{"wllmy", "罪"},
	{"wlln", "𠝹"},
	{"wlmc", "圚"},
	{"wlmf", "罘"},
	{"wlmfn", "罽"},
	{"wlmrv", "睘"},
	{"wlmym", "罡"},
	{"wlnih", "罞"},
	{"wlooo", "眾"},
	{"wlpli", "蜀"},
	{"wlpog", "罹"},
	{"wlrb", "罥"},
	{"wlrvp", "罠"},
	{"wlsfi", "罻"},
	{"wlsqf", "罵"},
	{"wltab", "羃"},
	{"wltjf", "羈"},
	{"wltjr", "羇"},
	{"wlvff", "羉"},
	{"wlvfg", "羅"},
	{"wlvvd", "罺"},
	{"wlwp", "罳"},
	{"wlwtj", "罼"},
	{"wlwwk", "奰"},
	{"wlwww", "𦌵"},
	{"wlyaj", "罩"},
	{"wlyg", "罜"},
	{"wlymr", "詈"},
	{"wlyri", "罸"},
	{"wlyrn", "罰"},
	{"wlytg", "罿"},
	{"wmg", "囯"},
	{"wmgi", "国"},
	{"wml", "畀"},
	{"wmln", "㓻"},
	{"wmmr", "圄"},
	{"wmmu", "园"},
	{"wmn", "町"},
	{"wmso", "圂"},
	{"wmv", "畏"},
	{"wnd", "囝"},
	{"wng", "墅"},
	{"wno", "畂"},
	{"wo", "囚"},
	{"wohh", "畛"},
	{"woii", "囹"},
	{"wok", "畋"},
	{"woll", "界 畍"},
	{"womb", "圇"},
	{"womd", "畭"},
	{"wop", "囮 慁"},
	{"wowy", "畮"},
	{"wp", "思"},
	{"wphh", "囫"},
	{"wpim", "畇"},
	{"wpmbc", "顋"},
	{"wpp", "毗 毘"},
	{"wpu", "囤"},
	{"wqmb", "圊 𤲟"},
	{"wr", "回"},
	{"wrb", "㘣"},
	{"wrbc", "圓"},
	{"wryw", "圖"},
	{"wsvws", "嬲"},
	{"wtc", "異"},
	{"wtj", "畢"},
	{"wtju", "𤳙"},
	{"wtlo", "𤳉"},
	{"wtt", "畊"},
	{"wumb", "圌"},
	{"wv", "囡"},
	{"wvfd", "圞"},
	{"wvff", "圝"},
	{"wvhaf", "䴉"},
	{"wvif", "累"},
	{"wvsmm", "翾"},
	{"ww", "畕"},
	{"wwhaf", "鸓"},
	{"wwlj", "圛"},
	{"wwlv", "圜"},
	{"www", "畾"},
	{"wwwc", "𨯔"},
	{"wwwd", "櫐"},
	{"wwwf", "纍"},
	{"wwwg", "壘"},
	{"wwwm", "疊"},
	{"wwwr", "礨"},
	{"wwwu", "罍"},
	{"wwwwg", "壨"},
	{"wybuc", "貫"},
	{"wyhn", "囥 㽘"},
	{"wyi", "母"},
	{"wymr", "圁"},
	{"wynd", "㝀 𡥘"},
	{"wytg", "疃"},
	{"wyv", "甿"},
	{"xb", "冂 冖 爫"},
	{"xc", "丷"},
	{"xe", "氵 氺"},
	{"xf", "灬"},
	{"xh", "𠂆"},
	{"xi", "丶 广"},
	{"xj", "宀"},
	{"xk", "疒 𠂇"},
	{"xl", "丨 丿 肀 衤"},
	{"xn", "乛 亅"},
	{"xo", "亻"},
	{"xp", "勹 忄 㣺"},
	{"xq", "扌"},
	{"xs", "𠃌"},
	{"xt", "卝 艹"},
	{"xu", "乚"},
	{"xy", "亠 辶"},
	{"y", "卜"},
	{"ya", "𨑨"},
	{"yaayf", "𩐿"},
	{"yad", "桌"},
	{"yahag", "韹"},
	{"yahej", "韸"},
	{"yai", "戠"},
	{"yaitc", "𩑈"},
	{"yaj", "卓"},
	{"yalb", "𢂚"},
	{"yambc", "𩐳"},
	{"yamh", "逿"},
	{"yano", "歆"},
	{"yaog", "暹"},
	{"yaph", "逷"},
	{"yapim", "韵"},
	{"yapr", "𩐝"},
	{"yapv", "遏"},
	{"yarbc", "韻"},
	{"yashr", "韶"},
	{"yasm", "遢"},
	{"yatc", "𩐠"},
	{"yatlk", "韺"},
	{"yatoe", "頀"},
	{"yav", "退"},
	{"yb", "迌"},
	{"ybaht", "髜"},
	{"ybbr", "過"},
	{"ybcr", "䢛"},
	{"ybd", "槀"},
	{"ybgr", "週"},
	{"ybhaf", "鶙"},
	{"ybhd", "稾"},
	{"ybhg", "望"},
	{"ybhne", "毃"},
	{"ybhu", "邈"},
	{"ybik", "獻"},
	{"ybikp", "𢅛"},
	{"ybjj", "運"},
	{"ybkb", "𥜽"},
	{"yblb", "帝"},
	{"yblbr", "啻"},
	{"ybmcu", "睿"},
	{"ybmo", "遯"},
	{"ybmr", "迵"},
	{"ybmvn", "甋 甗"},
	{"ybnl", "鄗"},
	{"ybno", "欳 歊 歒"},
	{"ybog", "離"},
	{"ybok", "敵"},
	{"ybou", "遙"},
	{"ybr", "迥"},
	{"ybuc", "貞"},
	{"ybye", "敲"},
	{"ybyhs", "旁"},
	{"ybysp", "龍 㡣"},
	{"yc", "六"},
	{"ycbr", "商 啇"},
	{"ycc", "銮"},
	{"ycd", "栾"},
	{"yce", "变"},
	{"ychaf", "鵉 鶐"},
	{"ychhj", "顰"},
	{"yciu", "兖"},
	{"yciv", "衮"},
	{"yck", "交 奕"},
	{"yclb", "帟"},
	{"ycnh", "递"},
	{"ycnl", "𨜓"},
	{"ycobo", "脔"},
	{"ycp", "戇 𢥫"},
	{"ycrhu", "兗"},
	{"ycrhv", "袞"},
	{"yct", "弈"},
	{"ydbuu", "親"},
	{"ydhaf", "鶉"},
	{"ydhhh", "虨"},
	{"ydhml", "新"},
	{"ydkni", "孰"},
	{"ydl", "速"},
	{"ydlk", "遫"},
	{"ydlo", "遬"},
	{"ydmq", "違"},
	{"ydnl", "郭"},
	{"ydno", "歑"},
	{"ydod", "𨔼"},
	{"ydog", "雜"},
	{"ydok", "敦 敹"},
	{"ydrrj", "嚲"},
	{"ye", "攴"},
	{"yebu", "督"},
	{"yec", "錖"},
	{"yefd", "粲"},
	{"yefh", "逤"},
	{"yeg", "壑"},
	{"yelmm", "韰"},
	{"yeoiv", "餐"},
	{"yep", "惄"},
	{"yeyhv", "裻"},
	{"yfb", "逍"},
	{"yfd", "迷"},
	{"yfdq", "遴"},
	{"yfe", "叔"},
	{"yfhaf", "鶁"},
	{"yfiku", "就"},
	{"yfks", "勍"},
	{"yfln", "剠"},
	{"yfye", "敊"},
	{"yg", "主"},
	{"ygcg", "逵"},
	{"yggu", "遶"},
	{"yghne", "殶"},
	{"yghqu", "氃"},
	{"ygiv", "褻"},
	{"ygmms", "虧"},
	{"ygr", "迼"},
	{"ygrv", "遠"},
	{"ygsk", "遨"},
	{"ygsmm", "𦒍"},
	{"ygtq", "達"},
	{"yha", "迫"},
	{"yhaf", "鳪"},
	{"yhag", "遑"},
	{"yhbm", "亹"},
	{"yhbr", "逈"},
	{"yhds", "透"},
	{"yhdv", "褎 襃 逶"},
	{"yhe", "返"},
	{"yhee", "邍"},
	{"yhej", "逢"},
	{"yheq", "逄"},
	{"yhg", "𨑳"},
	{"yhgr", "造 𨘥"},
	{"yhgv", "𨘻"},
	{"yhhhh", "彥"},
	{"yhhqm", "產"},
	{"yhhv", "裦"},
	{"yhhw", "遛"},
	{"yhiv", "褢"},
	{"yhj", "迁"},
	{"yhjr", "适"},
	{"yhju", "遁"},
	{"yhk", "迗"},
	{"yhln", "劌"},
	{"yhmbc", "頻 顏 顪"},
	{"yhml", "近"},
	{"yhmo", "遾"},
	{"yhmr", "逅"},
	{"yhn", "亢"},
	{"yhqo", "迭"},
	{"yhqv", "袠"},
	{"yhrr", "追"},
	{"yhs", "方 迮"},
	{"yhsb", "遍"},
	{"yhsd", "𨘋"},
	{"yhsk", "邀"},
	{"yhsmm", "翽"},
	{"yhus", "邊"},
	{"yhv", "衣"},
	{"yhvl", "迎"},
	{"yhxc", "亷"},
	{"yhxv", "裒"},
	{"yhym", "𨒂"},
	{"yhyu", "遞"},
	{"yib", "育"},
	{"yice", "逡"},
	{"yif", "熟"},
	{"yifh", "玅"},
	{"yig", "塾"},
	{"yihu", "充"},
	{"yihxo", "斔 螤"},
	{"yijb", "逋"},
	{"yijc", "述"},
	{"yije", "逑"},
	{"yik", "迖"},
	{"yiohv", "玈"},
	{"yioj", "率"},
	{"yir", "迨"},
	{"yirv", "袬"},
	{"yitd", "棄"},
	{"yitf", "遮"},
	{"yiyvi", "玆"},
	{"yj", "斗 辻"},
	{"yjbj", "遖"},
	{"yjco", "邃"},
	{"yjdl", "辣"},
	{"yjhaf", "鵫"},
	{"yjhec", "贛"},
	{"yjhee", "竷"},
	{"yjhhh", "彰"},
	{"yjhoj", "瓣"},
	{"yji", "㦸"},
	{"yjilj", "辨"},
	{"yjksj", "辦"},
	{"yjlii", "蠭"},
	{"yjmbc", "贑 顇"},
	{"yjmy", "𠁎"},
	{"yjnl", "鄣"},
	{"yjrr", "逭"},
	{"yjshj", "辧"},
	{"yjvfj", "辮"},
	{"yjwj", "連"},
	{"yjyjj", "𣁾"},
	{"yjyrj", "辯"},
	{"yk", "头 文 达"},
	{"ykanw", "斕"},
	{"ykb", "迶"},
	{"ykcf", "遼"},
	{"ykg", "墪"},
	{"ykhaf", "鳼 鵁 鷟 鸆"},
	{"ykhbm", "斖"},
	{"ykhf", "逖"},
	{"ykhg", "逛"},
	{"ykhhh", "彣"},
	{"ykhq", "𣁄"},
	{"ykhsb", "斒"},
	{"yki", "迏"},
	{"ykks", "効"},
	{"ykll", "齐"},
	{"yklm", "斉"},
	{"ykmbc", "頝"},
	{"ykmbl", "斋"},
	{"ykmpm", "斌"},
	{"yknd", "斈"},
	{"yknl", "郊"},
	{"ykok", "效"},
	{"ykp", "忞 憝"},
	{"ykpb", "遰"},
	{"ykq", "撉"},
	{"ykr", "吝"},
	{"yks", "边"},
	{"yksmm", "𦐑"},
	{"yksr", "迦"},
	{"ykvif", "紊"},
	{"ykymu", "齾"},
	{"yl", "迚"},
	{"ylb", "市"},
	{"yle", "逮"},
	{"ylhv", "衷"},
	{"yll", "亣"},
	{"ylm", "止"},
	{"ylmc", "遺"},
	{"ylmh", "步"},
	{"ylmo", "逃"},
	{"ylmr", "遣"},
	{"ylmv", "裵"},
	{"ylnc", "亦"},
	{"ylw", "迪"},
	{"ym", "上 辷"},
	{"ymb", "肯"},
	{"ymbuc", "贇"},
	{"ymbuu", "覷"},
	{"ymbw", "䢮"},
	{"ymcu", "𥈠"},
	{"ymcw", "迺"},
	{"ymd", "迂"},
	{"ymdhe", "皻 皽"},
	{"ymfb", "邇"},
	{"ymg", "迋"},
	{"ymgc", "𨘀"},
	{"ymgdi", "歭"},
	{"ymhaf", "鸇"},
	{"ymhqu", "氈"},
	{"ymihh", "歲"},
	{"ymje", "歧"},
	{"ymks", "勯"},
	{"ymlb", "迊"},
	{"ymln", "剷"},
	{"ymmbc", "顫"},
	{"ymmi", "运"},
	{"ymmp", "邐"},
	{"ymmr", "言 逜"},
	{"ymnn", "迾"},
	{"ymno", "歔"},
	{"ymomg", "𣁦"},
	{"ymp", "忐 此"},
	{"ympog", "雌"},
	{"ymrt", "逗"},
	{"ymrw", "逼"},
	{"ymso", "逐"},
	{"ymufd", "歯"},
	{"ymuo", "齿"},
	{"ymuoo", "齒"},
	{"ymvh", "迓"},
	{"ymvm", "逕"},
	{"ymwu", "遷"},
	{"ymy", "卡"},
	{"ynbq", "邂"},
	{"yndf", "遜"},
	{"ynhb", "遹"},
	{"ynhs", "辸"},
	{"ynhv", "袤"},
	{"yni", "歺"},
	{"ynib", "通"},
	{"ynin", "迻"},
	{"yniv", "袲"},
	{"ynj", "迅"},
	{"ynmbc", "頏"},
	{"ynnl", "邟"},
	{"ynot", "邆"},
	{"ynqd", "椉"},
	{"ynui", "逸"},
	{"yo", "込"},
	{"yobuc", "賌"},
	{"yodv", "褒"},
	{"yog", "進"},
	{"yohne", "毅 𣫛"},
	{"yoj", "迕"},
	{"yoks", "劾"},
	{"yoln", "刻 劇"},
	{"yombc", "頦"},
	{"yomd", "途"},
	{"yomn", "逾"},
	{"yon", "迄"},
	{"yonk", "夜"},
	{"yono", "欬"},
	{"yooj", "卒"},
	{"yopd", "迤"},
	{"yp", "虍"},
	{"ypa", "迿"},
	{"ypbu", "眥"},
	{"ypbuc", "貲"},
	{"ypc", "鈭"},
	{"ypd", "柴 迆 㰍"},
	{"ypg", "壟 㘹"},
	{"yphaf", "鷾 鸗"},
	{"yphen", "處"},
	{"yphfd", "虖"},
	{"yphu", "虎"},
	{"ypks", "勴"},
	{"yplmi", "蠪"},
	{"ypmk", "龑"},
	{"ypmm", "些"},
	{"ypmmf", "祡 龒"},
	{"ypmr", "砦 礱"},
	{"ypmrb", "骿"},
	{"ypmso", "豦"},
	{"ypnbg", "觜"},
	{"ypni", "㱔"},
	{"ypnwf", "鮆"},
	{"ypobo", "胔"},
	{"ypoiv", "飺"},
	{"ypph", "虙"},
	{"ypr", "呰"},
	{"yprvk", "虞"},
	{"ypsj", "聾"},
	{"ypsm", "虐"},
	{"ypt", "衧"},
	{"yptc", "龔"},
	{"yptm", "虛"},
	{"yptmc", "虡"},
	{"ypu", "迍"},
	{"ypuv", "袌"},
	{"ypvif", "紫"},
	{"ypwb", "膚"},
	{"ypwbt", "盧"},
	{"ypwks", "虜"},
	{"ypwlb", "歶"},
	{"ypwp", "慮"},
	{"ypybp", "龘"},
	{"ypyhv", "襲"},
	{"ypyk", "虔"},
	{"ypymr", "訾 讋"},
	{"yqhl", "逝"},
	{"yr", "占"},
	{"yraa", "誯"},
	{"yramo", "諟"},
	{"yrana", "𧬘"},
	{"yranb", "譋"},
	{"yranw", "讕"},
	{"yrapv", "謁"},
	{"yrav", "裛"},
	{"yrawe", "謾"},
	{"yrbb", "膏"},
	{"yrbbe", "䛵"},
	{"yrbbn", "贏"},
	{"yrbcd", "𧨾"},
	{"yrbgr", "調"},
	{"yrbhn", "鸁"},
	{"yrbhx", "謟"},
	{"yrbjj", "諢"},
	{"yrbln", "蠃"},
	{"yrbm", "詛"},
	{"yrbme", "諼"},
	{"yrbmr", "詷"},
	{"yrbn", "亭"},
	{"yrbo", "豪"},
	{"yrbou", "謠"},
	{"yrbp", "亳"},
	{"yrbr", "詗 高"},
	{"yrbsd", "諍"},
	{"yrbsn", "驘"},
	{"yrbtn", "羸"},
	{"yrbu", "亮 毫"},
	{"yrbuu", "覘"},
	{"yrbvk", "謑"},
	{"yrbvn", "嬴"},
	{"yrbwn", "臝"},
	{"yrci", "訟"},
	{"yrcmt", "諡"},
	{"yrcru", "說"},
	{"yrcsh", "訜"},
	{"yrdd", "諃"},
	{"yrdhe", "詖"},
	{"yrdi", "討"},
	{"yrdk", "訣"},
	{"yrdmq", "諱"},
	{"yrdoo", "誺"},
	{"yrdwf", "諫"},
	{"yre", "㕡"},
	{"yrea", "誻"},
	{"yrf", "京 点"},
	{"yrfb", "誚"},
	{"yrfbf", "讜"},
	{"yrff", "談"},
	{"yrfh", "訬"},
	{"yrfq", "詊"},
	{"yrfqr", "𧬸"},
	{"yrgcr", "讟"},
	{"yrgdi", "詩"},
	{"yrgg", "詿"},
	{"yrggu", "譊"},
	{"yrgni", "譸"},
	{"yrgp", "誌"},
	{"yrgr", "詰"},
	{"yrgrr", "譆"},
	{"yrgwc", "讀"},
	{"yrhag", "諻"},
	{"yrhd", "訸"},
	{"yrhdn", "謻"},
	{"yrhds", "誘"},
	{"yrhdv", "諉"},
	{"yrhdw", "譒"},
	{"yrhej", "𧧽"},
	{"yrher", "詻"},
	{"yrhg", "逞"},
	{"yrhge", "譭"},
	{"yrhgr", "誥"},
	{"yrhgu", "詵"},
	{"yrhhh", "㣌"},
	{"yrhhi", "謝"},
	{"yrhhj", "諀"},
	{"yrhjd", "誅"},
	{"yrhjm", "諈"},
	{"yrhjr", "話"},
	{"yrhk", "訞"},
	{"yrhkb", "譑"},
	{"yrhml", "訢"},
	{"yrhmr", "詬"},
	{"yrhmy", "訴"},
	{"yrhne", "設"},
	{"yrhni", "諷"},
	{"yrhor", "譗"},
	{"yrhp", "託"},
	{"yrhpa", "諙"},
	{"yrhpm", "詆"},
	{"yrhqi", "誐"},
	{"yrhqo", "詄"},
	{"yrhs", "詐"},
	{"yrhsb", "諞"},
	{"yrhsm", "謆"},
	{"yrhuc", "讚"},
	{"yrhv", "哀"},
	{"yrhwp", "謥"},
	{"yrhxe", "謏"},
	{"yrhxo", "諛"},
	{"yrhxu", "誽"},
	{"yrhyu", "謕"},
	{"yriav", "誏"},
	{"yrice", "誜"},
	{"yrihr", "諴"},
	{"yrihs", "誠"},
	{"yrii", "諓"},
	{"yrijb", "誧"},
	{"yrijc", "訹"},
	{"yrikf", "譌"},
	{"yrikk", "詙"},
	{"yriku", "訧"},
	{"yrill", "詶"},
	{"yrine", "詠"},
	{"yriok", "誒"},
	{"yrior", "諮"},
	{"yripm", "試"},
	{"yrir", "詒"},
	{"yrit", "誡"},
	{"yritc", "譧"},
	{"yritf", "謶"},
	{"yrj", "計"},
	{"yrjbc", "謓"},
	{"yrjbd", "誖"},
	{"yrjbj", "諵"},
	{"yrjbm", "誼"},
	{"yrjhp", "詫"},
	{"yrjhw", "讅"},
	{"yrjip", "譓"},
	{"yrjjb", "謿"},
	{"yrjka", "諸"},
	{"yrjmf", "誴"},
	{"yrjmm", "諠"},
	{"yrjmo", "諚"},
	{"yrjmu", "𧨎"},
	{"yrjp", "詑"},
	{"yrjpn", "𧭈"},
	{"yrjr", "詁"},
	{"yrkb", "詴"},
	{"yrkf", "詼"},
	{"yrkhg", "誑"},
	{"yrkja", "譇"},
	{"yrkms", "誇"},
	{"yrlll", "訓"},
	{"yrlmo", "誂"},
	{"yrlmy", "誹"},
	{"yrln", "剖"},
	{"yrlwv", "謱"},
	{"yrm", "訌"},
	{"yrmbc", "頕"},
	{"yrmbs", "謣"},
	{"yrmca", "𧪽"},
	{"yrmd", "訏"},
	{"yrmdm", "讈"},
	{"yrmfj", "評"},
	{"yrmhf", "謜"},
	{"yrmhs", "𧨊"},
	{"yrmj", "訐"},
	{"yrmjk", "譀"},
	{"yrmmh", "𧧝"},
	{"yrmmr", "語"},
	{"yrmmv", "誫"},
	{"yrmn", "訂"},
	{"yrmnr", "訶"},
	{"yrmoo", "誣"},
	{"yrmrr", "謌"},
	{"yrmrw", "諨"},
	{"yrmso", "諑"},
	{"yrmsu", "𧦠"},
	{"yrmua", "譖"},
	{"yrmvh", "訝"},
	{"yrmvm", "誙"},
	{"yrmvn", "瑀"},
	{"yrmwf", "謤"},
	{"yrmwg", "諲"},
	{"yrmwj", "譚"},
	{"yrmym", "証"},
	{"yrnbe", "讂"},
	{"yrncr", "譫"},
	{"yrnd", "享"},
	{"yrndf", "𧪾"},
	{"yrnf", "烹"},
	{"yrnhb", "譎"},
	{"yrnhx", "諂"},
	{"yrnib", "誦"},
	{"yrnin", "誃"},
	{"yrnir", "詺"},
	{"yrnj", "訊"},
	{"yrnkg", "誔"},
	{"yrnkm", "誕 𧩙"},
	{"yrnl", "部"},
	{"yrnlp", "讔"},
	{"yrnmu", "詭"},
	{"yrnn", "亨"},
	{"yrnob", "諝"},
	{"yrnoe", "𧬋"},
	{"yrnot", "證"},
	{"yrnqd", "謋"},
	{"yrnri", "讒"},
	{"yrnyi", "誸"},
	{"yrob", "訥"},
	{"yrog", "誰"},
	{"yroge", "謢"},
	{"yrogf", "譙"},
	{"yrohh", "診"},
	{"yroii", "詅"},
	{"yroim", "讖"},
	{"yroip", "諗"},
	{"yroir", "謒"},
	{"yroj", "許"},
	{"yrok", "敨"},
	{"yromb", "論"},
	{"yromg", "詮"},
	{"yromn", "諭"},
	{"yromo", "譣"},
	{"yron", "訖"},
	{"yrop", "訛"},
	{"yrotf", "譕"},
	{"yrowy", "誨"},
	{"yroyr", "𧪄"},
	{"yrp", "訫"},
	{"yrpa", "詢 詣"},
	{"yrpd", "訑"},
	{"yrphp", "𧩓"},
	{"yrpht", "謐"},
	{"yrpim", "𧥺"},
	{"yrpko", "譺"},
	{"yrppa", "諧"},
	{"yrpr", "訽"},
	{"yrpt", "詍"},
	{"yrptd", "諜"},
	{"yrpu", "訰"},
	{"yrpuk", "詾"},
	{"yrpuu", "謅"},
	{"yrqd", "誄"},
	{"yrqjp", "譿"},
	{"yrqmb", "請"},
	{"yrqmc", "謮"},
	{"yrqmv", "諘"},
	{"yrqoc", "讃"},
	{"yrrrd", "譟"},
	{"yrrrj", "譂"},
	{"yrrrs", "諤"},
	{"yrrs", "遌"},
	{"yrrsj", "諿"},
	{"yrru", "遻 𨕬"},
	{"yrruc", "譔"},
	{"yrrv", "襄"},
	{"yrrvk", "誤"},
	{"yrrxu", "譝"},
	{"yrshi", "訒"},
	{"yrshr", "詔"},
	{"yrsim", "譅"},
	{"yrsip", "認"},
	{"yrsje", "諏"},
	{"yrsjj", "讘"},
	{"yrsma", "謵"},
	{"yrsmg", "誆"},
	{"yrsmh", "謬"},
	{"yrsmm", "詡"},
	{"yrsmr", "詞"},
	{"yrsp", "䛏"},
	{"yrsrr", "謳"},
	{"yrss", "詎"},
	{"yrsu", "記"},
	{"yrsup", "誋"},
	{"yrsyj", "謘"},
	{"yrtak", "謨"},
	{"yrtam", "𧫴"},
	{"yrtav", "譪"},
	{"yrtbh", "謭"},
	{"yrtbm", "譾"},
	{"yrtca", "譜"},
	{"yrtct", "謚"},
	{"yrtgi", "議 讛"},
	{"yrtgr", "𧬆"},
	{"yrtkr", "諾"},
	{"yrtlf", "讌"},
	{"yrtlm", "謹"},
	{"yrtm", "詌"},
	{"yrtmc", "諆"},
	{"yrtmd", "謀"},
	{"yrtmj", "譁"},
	{"yrtmv", "諶"},
	{"yrtoe", "護"},
	{"yrtpd", "䜓"},
	{"yrtq", "詳"},
	{"yrtrg", "讙"},
	{"yrtrk", "䜘"},
	{"yrtt", "誁"},
	{"yrttb", "講"},
	{"yrtwi", "譐"},
	{"yrtwt", "𧬹"},
	{"yrtwv", "譨"},
	{"yrtxc", "謙"},
	{"yrtyb", "𧬺"},
	{"yrtyu", "謊"},
	{"yru", "乩 訕"},
	{"yruc", "選"},
	{"yruk", "訩"},
	{"yrumb", "諯"},
	{"yruu", "詘"},
	{"yrve", "詉"},
	{"yrvii", "譏"},
	{"yrvis", "詏"},
	{"yrwb", "謂"},
	{"yrwce", "謖"},
	{"yrwd", "課"},
	{"yrwlj", "譯"},
	{"yrwlv", "譞"},
	{"yrwp", "諰"},
	{"yrwww", "讄"},
	{"yry", "訃"},
	{"yrybb", "諦"},
	{"yrybk", "讞"},
	{"yrybs", "謗"},
	{"yrycb", "謪 謫"},
	{"yryck", "詨"},
	{"yrydk", "譈"},
	{"yrye", "敁 遐 㪗"},
	{"yryfd", "謎"},
	{"yryfe", "諔"},
	{"yryg", "註"},
	{"yryhh", "諺"},
	{"yryhs", "訪"},
	{"yryia", "識"},
	{"yryjj", "謰"},
	{"yrylr", "譴"},
	{"yrymp", "訿"},
	{"yrymr", "誩"},
	{"yryoj", "誶"},
	{"yrypd", "謼"},
	{"yrypm", "謔 謯 譃"},
	{"yrypu", "諕"},
	{"yryr", "詀"},
	{"yryrb", "謞"},
	{"yryrd", "諄"},
	{"yryrf", "諒"},
	{"yryrn", "諪"},
	{"yryro", "譹"},
	{"yryrv", "讓"},
	{"yrysd", "𧩹"},
	{"yryta", "諳"},
	{"yryto", "譢"},
	{"yrytp", "譩"},
	{"yryub", "謧"},
	{"yryvo", "該"},
	{"yrywm", "譠"},
	{"yryyb", "讁"},
	{"ys", "迉"},
	{"ysfv", "褭"},
	{"ysg", "堃 𡑔"},
	{"ysh", "辺"},
	{"yshr", "迢"},
	{"yskmr", "旑"},
	{"ysm", "与"},
	{"ysmvn", "瓬"},
	{"ysnkq", "旔"},
	{"ysnl", "邡"},
	{"ysoby", "旃"},
	{"ysofb", "旓"},
	{"ysohc", "旟"},
	{"ysohl", "旂"},
	{"ysohm", "旌"},
	{"ysohn", "斻"},
	{"ysohu", "旄"},
	{"ysohv", "旅"},
	{"ysohw", "旛"},
	{"ysojb", "旆"},
	{"ysok", "放"},
	{"ysokr", "旖"},
	{"ysolb", "斾"},
	{"ysolo", "旐"},
	{"ysomf", "旚"},
	{"ysond", "斿"},
	{"ysono", "旋"},
	{"ysooa", "旝"},
	{"ysooi", "旍"},
	{"ysook", "族"},
	{"ysopd", "施"},
	{"ysosp", "旎"},
	{"ysotc", "旗"},
	{"ysoy", "於"},
	{"ysoyu", "旒"},
	{"ysp", "迡"},
	{"ysqf", "遤"},
	{"ysrj", "避"},
	{"ystmc", "𣄃"},
	{"ysyhn", "𣃚"},
	{"ysyoo", "旞"},
	{"ysyq", "遲"},
	{"yt", "立 𨑬"},
	{"yta", "音"},
	{"ytahu", "竟"},
	{"ytaj", "章"},
	{"ytap", "意"},
	{"ytapv", "竭"},
	{"ytbsd", "竫"},
	{"ytcw", "遒"},
	{"ytdl", "竦"},
	{"ytdq", "𨗨"},
	{"ytggu", "𥪯"},
	{"ytgo", "䢭"},
	{"ythaf", "鴗 鸕"},
	{"ythdl", "𥪕"},
	{"ythj", "竏"},
	{"ythni", "颯"},
	{"ythqu", "竓"},
	{"ythu", "道"},
	{"ythxh", "竧"},
	{"yti", "戲"},
	{"ytice", "竣"},
	{"ytii", "䇊"},
	{"ytiok", "竢"},
	{"ytj", "辛"},
	{"ytjbm", "竩"},
	{"ytjki", "竤"},
	{"ytjmn", "竚"},
	{"ytk", "送"},
	{"ytki", "竑"},
	{"ytkr", "逽 𨔽"},
	{"ytmbc", "顱"},
	{"ytnl", "𨚪"},
	{"ytog", "遳"},
	{"ytoii", "竛"},
	{"yton", "䇄"},
	{"ytpo", "遂"},
	{"ytpr", "竘"},
	{"ytqmb", "靖"},
	{"ytr", "咅"},
	{"ytsmm", "翊"},
	{"ytstt", "竮"},
	{"ytt", "迸"},
	{"yttb", "遘"},
	{"ytu", "逆"},
	{"ytub", "遡"},
	{"ytumb", "端"},
	{"ytv", "妾"},
	{"ytwa", "遭"},
	{"ytwb", "邁"},
	{"ytwg", "童"},
	{"ytwi", "遵"},
	{"ytwu", "竜"},
	{"ytyr", "站"},
	{"ytyrd", "䇏"},
	{"ytyrn", "𥪜"},
	{"ytyt", "竝"},
	{"ytytj", "𥪮"},
	{"yu", "辿"},
	{"yuav", "齦"},
	{"yubm", "齟"},
	{"yubuc", "贙"},
	{"yubuu", "覤"},
	{"yudi", "導"},
	{"yue", "叡 𠮏"},
	{"yuemi", "𤫀"},
	{"yuhaf", "鷲"},
	{"yuhgr", "䶜"},
	{"yuhhh", "彪"},
	{"yuhlb", "齲"},
	{"yuhml", "齗"},
	{"yuhs", "齚"},
	{"yuhxu", "齯"},
	{"yuii", "虥"},
	{"yuir", "齝"},
	{"yujbc", "齻"},
	{"yujbm", "𪘲"},
	{"yukb", "离"},
	{"yukmr", "齮"},
	{"yulwp", "齥"},
	{"yumb", "遄"},
	{"yummr", "齬"},
	{"yumvh", "齖"},
	{"yuoii", "齡 齢"},
	{"yuolf", "虪"},
	{"yuoll", "齘"},
	{"yuomr", "𪘁"},
	{"yuon", "齕"},
	{"yup", "齔"},
	{"yupr", "齣"},
	{"yupru", "齙"},
	{"yupt", "齛"},
	{"yupuu", "齺"},
	{"yurc", "齞"},
	{"yurrs", "齶"},
	{"yuryo", "蹵 齪"},
	{"yushr", "齠"},
	{"yusje", "齱"},
	{"yusmg", "齷"},
	{"yustr", "𪙛"},
	{"yuta", "齰"},
	{"yutct", "齸"},
	{"yutm", "瑎 甝"},
	{"yutxc", "𪙊"},
	{"yuu", "齓"},
	{"yuwd", "齫"},
	{"yuwlb", "齵"},
	{"yuyck", "齩"},
	{"yuye", "㪫"},
	{"yuyhh", "齴"},
	{"yuymp", "齜"},
	{"yuypu", "虤"},
	{"yuytu", "競"},
	{"yv", "亡"},
	{"yvb", "肓 膂"},
	{"yvbcr", "裔"},
	{"yvbq", "牽"},
	{"yvbu", "盲"},
	{"yvd", "杗"},
	{"yvgg", "壅"},
	{"yvgn", "甕"},
	{"yvgu", "罋"},
	{"yvgv", "饔"},
	{"yvhbt", "衁"},
	{"yvhg", "雍"},
	{"yvhlu", "巟"},
	{"yvho", "亥 𠀅"},
	{"yvhvo", "瓤"},
	{"yvi", "玄"},
	{"yviw", "畜"},
	{"yvks", "勷"},
	{"yvlii", "蝱"},
	{"yvne", "逯"},
	{"yvnl", "邙"},
	{"yvp", "忘"},
	{"yvrvp", "氓"},
	{"yvsl", "𠨑"},
	{"yvv", "妄"},
	{"yvvv", "巡 邋"},
	{"ywdv", "裹"},
	{"ywgv", "裏"},
	{"ywi", "畆"},
	{"ywihr", "鹹"},
	{"ywii", "鹵"},
	{"ywk", "卤"},
	{"ywlb", "遇"},
	{"ywle", "遝"},
	{"ywlg", "邏 𨗴"},
	{"ywlv", "褱 還"},
	{"ywmmf", "禀"},
	{"ywmv", "衰"},
	{"ywni", "𠧧"},
	{"ywnl", "鄐"},
	{"ywno", "畝"},
	{"ywomo", "鹼"},
	{"ywr", "迴"},
	{"ywrd", "稟"},
	{"ywrm", "亶"},
	{"yws", "卣"},
	{"ywtqm", "鹺"},
	{"ywtxc", "鹻"},
	{"yx", "齊"},
	{"yxbt", "齍"},
	{"yxbuc", "齎"},
	{"yxf", "齋 齌"},
	{"yxlmm", "韲 齏"},
	{"yxln", "劑"},
	{"yxyhv", "𪗋"},
	{"yy", "卞"},
	{"yyaj", "逴"},
	{"yybc", "遉"},
	{"yycb", "適"},
	{"yyhn", "迒"},
	{"yyib", "逳"},
	{"yylc", "迹"},
	{"yymr", "這"},
	{"yypo", "遽"},
	{"yyr", "迠"},
	{"yysd", "遊"},
	{"yytj", "遧"},
	{"yywm", "邅"},
	{"yywn", "𨔁"},
	{"yyws", "逌"},
	{"yyyhv", "𧜏"},
	{NIL_PTR}
};
