/********************************************************
*  main.c
*
*  Source file for Matrox video parameters tuning utility.
*  Main function and other util. functions.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Stephane Duguay
*  Last modified : April 2001.
*********************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#include <X11/extensions/xf86vmode.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <stdarg.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/file.h>
#include "interface.h"
#include "support.h"

#include "mgaXaction.h"

#include "global.h"

/* Minimum extension version required : took from xvidtune. */
#define MINMAJOR 0
#define MINMINOR 6

static void CleanUp(Display *dpy);
static void CatchSig(int signal);
void set_window_back(GtkWidget* this_window, GtkWidget* fixed);
void ExitMsgBox(char* title, char* msg);

static void CleanUp(Display *dpy)
{
    /* Make sure mode switching is not locked out at exit */
    XF86VidModeLockModeSwitch(dpy, DefaultScreen(dpy), FALSE);
    XFlush(dpy);
    mode_line.flags &= 0x7FFFFFFF;
}

static void CatchSig(int signal)
{
    CleanUp(pDisp);
    exit(3);
}

void set_window_back(GtkWidget* this_window, GtkWidget* fixed)
{
    #include "../pixmaps/pdbkgnd.xpm"

    GtkStyle *style;
    GdkBitmap *mask;

    gtk_widget_realize(this_window);

    style = gtk_style_copy(gtk_widget_get_style(this_window));

    style->bg_pixmap[GTK_STATE_NORMAL] =
               gdk_pixmap_create_from_xpm_d(this_window->window, &mask,
                  &style->bg[GTK_STATE_NORMAL], pdbkgnd_xpm);

    gtk_widget_set_style(this_window, style);
    gtk_widget_set_style(fixed, style);

    gtk_style_unref(style);

    return;
}

int
main (int argc, char *argv[])
{
	GtkWidget *winOpen;

	int MajorVersion, MinorVersion;
	int EventBase, ErrorBase;
	int fd;
	int lock;
	
	/* Must be root... */
	if(getuid() != 0)
	{
		printf("\nmgapdesk : You need root privileges to run this application.\n");
		printf("Please, log in as root or execute \"su root\" before running it again...\n\n");

		exit(0);
	}
	else
	{
 
    /* Make sure only one instance runs at a time */
	fd = open ("/tmp/mgapdesk.lock", O_CREAT | O_WRONLY);

	if (fd <= 0)
	{
	    printf("\nError Opening file\n");
	    exit(0);
	}

	lock = lockf(fd,F_TLOCK,0);
	if (lock != 0) {
	    printf("\nmgapdesk: PowerDesk is already running on this system\n");
	    exit(0);
	}
		pDisp =  XOpenDisplay(NULL);

		gtk_set_locale ();
		gtk_init (&argc, &argv);

		add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
		add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");
	
		/* Get the XF86 Video extensions version. */
		if (!XF86VidModeQueryVersion(pDisp, &MajorVersion, &MinorVersion))
		{
			fprintf(stderr, "mgaXconf : Unable to query video extension version...\n");
			return 2;
		}

		if (!XF86VidModeQueryExtension(pDisp, &EventBase, &ErrorBase))
		{
			fprintf(stderr, "mgaXconf : Unable to query video extension information...\n");
			return 2;
		}

		/* Fail if the Xserver extension version is too old for mgaXconf (based on xvidtune src...) */
		if (MajorVersion < MINMAJOR || (MajorVersion == MINMAJOR && MinorVersion < MINMINOR))
		{
			fprintf(stderr,
				"mgaXconf : Your Xserver is running an old XFree86-VidModeExtension  : version"
				" (%d.%d).\n", MajorVersion, MinorVersion);
			fprintf(stderr, "Minimum required version is %d.%d\n\nPlease upgrade and run this program again.",
				MINMAJOR, MINMINOR);
			exit(2);
		}

		/* Ensure no mode switching while configuring one... security. */
		/* Will be unlocked on exit of this program. */
		if (!XF86VidModeLockModeSwitch(pDisp, DefaultScreen ( pDisp), TRUE))
		{
			fprintf(stderr, "mgaXconf : Failed to disable mode-switch hot-keys.\n");
			return 2;
		}

		/* Catch signals to unlock modes switching */
		signal(SIGINT, CatchSig);
		signal(SIGQUIT, CatchSig);
		signal(SIGTERM, CatchSig);
		signal(SIGHUP, CatchSig);

		/* Get the current mode parameters */
		if (!XF86VidModeGetModeLine (pDisp, DefaultScreen (pDisp), &device_info.dot_clock, &mode_line))
		{
			fprintf(stderr, "mgaXconf : Unable to get mode informations.\n");
			CleanUp(pDisp);
			return 2;
		}

		/* Must remain here as mode_line must by valid when showing the Window. */
		/* For further info, check on_winMain_show function in callbacks.c */
		winOpen = create_winOpen();
		set_window_back(winOpen, lookup_widget(winOpen,"fixed5"));
		gtk_widget_show(winOpen);

		gtk_main ();
		CleanUp(pDisp);

		return 0;
	}

	return 0; /* precaution */
}

/* Functions that the parser requires */

void
VErrorF(const char *f, va_list args)
{
	vfprintf(stderr, f, args);
}

void
ErrorF(const char *f, ...)
{
	va_list args;

	va_start(args, f);
	vfprintf(stderr, f, args);
	va_end(args);
}

