/********************************************************
*  io.c
*
*  Header file for Matrox video parameters tuning utility.
*  Functions to access io. Reads BIOS version and BusID.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Luugi Marsan and Stephane Duguay.
*  Last modified : March 2001.
*********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

#define PCIBIOS_SUCCESSFUL                0x01
#define PAGE_OFFSET 0x40000000
#define __io_virt(x)		((void *)(PAGE_OFFSET | (unsigned long)(x)))
#define readb(addr) (*(volatile unsigned char *) __io_virt(addr))
#define readl(addr) (*(volatile unsigned int *) __io_virt(addr))

// type 1 Access

#define CONFIG_CMD(bus, device_fn, where)  (0x80000000 | (bus << 16) | (device_fn << 11) | (where & ~3))


unsigned long getBiosVersion();
void DisplayBiosVersion(char* buffer, int bufferLen);
int getMatroxPci(int* deviceNum, int* busNum, int* deviceId, unsigned char* revision); /* returns 0 if not found, 1 if found. */

