/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef BUTTONS_H_
#define BUTTONS_H_

#include <iomanip>
#include <gtk/gtk.h>
#include <mffm/LinkList.H>

class labelFuncData {
public:
  char *str;
  void (*func)(void *arg1, void *arg2);
  gpointer data;
};
#define BUTTONLABELSTRUCT (labelFuncData)

#define GDKPIXMAPCREATE(win, ref) gdk_pixmap_create_from_xpm_d(win->window,NULL,NULL,ref)
#define GTKPIXMAPCREATE(pixGdk) (GtkPixmap*)gtk_pixmap_new(pixGdk, NULL)

class pixmapFuncData {
public:
  GtkPixmap *pixGtk;
  void (*func)(void *arg1, void *arg2);
  gpointer data;
};
#define BUTTONPIXMAPSTRUCT (pixmapFuncData)

class toggleFuncData {
public:
  char *str;
  void (*func)(void *arg1, void *arg2);
  gpointer data;
};
#define BUTTONTOGGLESTRUCT (toggleFuncData)

class Buttons : public LinkList<GtkWidget *> {
public:

  void signalConnectAfter(labelFuncData nf){
    if (nf.func)
      gtk_signal_connect(GTK_OBJECT((GtkButton*)current()), "released",GTK_SIGNAL_FUNC(nf.func), nf.data);
  }

  Buttons& operator <<(labelFuncData nf) {
    LinkList<GtkWidget *>::add(gtk_button_new_with_label(nf.str));
    if (nf.func)
      gtk_signal_connect(GTK_OBJECT((GtkButton*)current()), "released",GTK_SIGNAL_FUNC(nf.func), nf.data);
    gtk_widget_show(current());
    return *this;
  }

  Buttons& operator <<(const pixmapFuncData nf) {
    LinkList<GtkWidget *>::add(gtk_button_new());
    gtk_container_add (GTK_CONTAINER(current()), GTK_WIDGET(nf.pixGtk));
    gtk_widget_show(GTK_WIDGET(nf.pixGtk));
    //if (pixGtk) delete pixGtk;

    if (nf.func)
      gtk_signal_connect(GTK_OBJECT(current()), "released",GTK_SIGNAL_FUNC(nf.func), nf.data);
    //    cout<<"connect with data "<<nf.data<<endl;
    gtk_widget_show(current());
    return *this;
  }

  Buttons& operator <<(toggleFuncData nf) {
    LinkList<GtkWidget *>::add(gtk_toggle_button_new_with_label(nf.str));
    if (nf.func)
      gtk_signal_connect(GTK_OBJECT((GtkButton*)current()), "released",GTK_SIGNAL_FUNC(nf.func), nf.data);
    gtk_widget_show(current());
    return *this;
  }

};
#endif //BUTTONS_H_

