/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */


#ifndef mir_util_Assert_h
#define mir_util_Assert_h

#include "eckit/exception/Exceptions.h"

#define ASSERT_KEYWORD_GRID_SIZE(size) ASSERT_MSG(size == 2, "keyword 'grid' expected size=2")
#define ASSERT_KEYWORD_AREA_SIZE(size) ASSERT_MSG(size == 4, "keyword 'area' expected size=4")
#define ASSERT_KEYWORD_ROTATION_SIZE(size) ASSERT_MSG(size == 2, "keyword 'rotation' expected size=2")

#define ASSERT_VALUES_SIZE_EQ_ITERATOR_COUNT(m, size, count) \
    ASSERT_MSG((size) == (count), m ": values size equals iterator count")
#define ASSERT_VALUES_SIZE_EQ_NUMBER_OF_COEFFS(m, size, count) \
    ASSERT_MSG((size) == (count), m ": values size equals number of coefficients")

#endif
