/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QApplication>
#include <iostream>

#include "FlextraExaminer.h"
#include "Metview.h"
#include "MvQService.h"

using namespace std;

// Globals
int          ac;
char       **av;

class Base : public MvQService
{
protected:
	Base(char* a) : MvQService(a) {};
};

class MvFlextraExaminer : public Base
{	
public:
	MvFlextraExaminer() : Base("FLEXTRA_FILE") {};
	void serve(MvRequest&,MvRequest&);
};

void MvFlextraExaminer::serve( MvRequest& in, MvRequest& )
{
cout << "--------------FlextraExaminer::serve()--------------" << endl;
in.print();

	string iconPath;
	char *mvdir=getenv("METVIEW_USER_DIRECTORY");
	if(mvdir)
	{
		iconPath=string(mvdir);
		const char* iconName=in("_NAME");
		if(iconName)
		{
		  	iconPath=string(mvdir) + "/" + iconName;
		}		  
	}

	//Create the qt application
	QApplication app(ac, av);

	//Initialise resorces from a static library (libMvQtGui)
	Q_INIT_RESOURCE(examiner);
	Q_INIT_RESOURCE(window);
	Q_INIT_RESOURCE(find);

	// Get Flextra file name
	const char* name = in("PATH");

	//Create the flextra browser, initialize it and show it
	FlextraExaminer *browser = new FlextraExaminer;
	browser->initData(name,iconPath);
	browser->show();
	
	//Listen to the mars event loop!
	setupSocketNotifier();
	
	// Send reply to MetviewUI
	// To turn icon to green; otherwise, it will stay orange
	if( strcmp( getenv("METVIEW_MODE"), "examine" ) != 0 )
	{
	  	MvRequest req;
		sendReplyFromInteractive(req);
	}
	
	//Enter the app loop
	app.exec();
}

int main( int argc, char **argv )
{
	ac = argc;
	av = argv;
	
	MvApplication theApp( argc, argv );

	MvFlextraExaminer lextra;
	
	theApp.run();
}
