/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQTextLine.h"

#include "MvQRequestPanelHelp.h"
#include "MvQLineEdit.h"

#include "LineFactory.h"
#include "Parameter.h"
#include "RequestPanel.h"

#include <QDebug>

MvQTextLine::MvQTextLine(RequestPanel& owner,const Parameter& param) :
		   MvQRequestPanelLine(owner,param) 
{
	lineEdit_ = new MvQLineEdit(parentWidget_);
	owner_.addWidget(lineEdit_,row_,3);	
	
	connect(lineEdit_,SIGNAL(textEdited(const QString&)),
		this,SLOT(slotTextEdited(const QString&)));
		
	connect(lineEdit_,SIGNAL(textCleared()),
		this,SLOT(slotCleared()));	
}

void MvQTextLine::refresh(const vector<string>& values)
{
	string s;
	for(vector<string>::const_iterator j = values.begin(); j != values.end(); ++j)
	{
			if(s.length()) s += "/";
			s += *j;
	}
	
	if(s != lineEdit_->text().toStdString())
	{
		if(s.empty() || s + "." != lineEdit_->text().toStdString())
		{
		  	lineEdit_->setText(s.c_str());
			updateHelper();
		}	
	}
}

void MvQTextLine::dispatchChange()
{	  
	vector<string> vals;
	QString txt=lineEdit_->text();
	foreach(QString s,txt.split("/"))
	{
		vals.push_back(s.toStdString());
	}
		
	owner_.set(param_.name(),vals);
}	

void MvQTextLine::updateHelper()
{
  	if(!helper_)
		return;
	
	
	vector<string> vals;
	QString txt=lineEdit_->text();
	foreach(QString s,txt.split("/"))
	{
		vals.push_back(s.toStdString());
		helper_->refresh(vals);
	}
	helper_->refresh(vals);
}  		

void MvQTextLine::slotCleared()
{
 	dispatchChange();
	updateHelper();
}  

void MvQTextLine::slotTextEdited(const QString& /*text*/)
{
	dispatchChange();
	updateHelper();
}  
	
void MvQTextLine::slotHelperEdited(const vector<string>& values,const vector<string>& noValues)
{
	QString txt=lineEdit_->text();
	QStringList lst=txt.split("/");
	
	qDebug() << lst;
	
	for(vector<string>::const_iterator it = values.begin(); it != values.end(); it++)
	{  
		QString s(it->c_str());
		qDebug() << s;
		if(!lst.contains(s))
			lst << s;
	}
	
	qDebug() << lst;
	
	for(vector<string>::const_iterator it = noValues.begin(); it != noValues.end(); it++)
	{  
		QString s(it->c_str());
		qDebug() << s;
		if(lst.contains(s))
			lst.removeAll(s);
	}
	
	qDebug() << lst;
	
	QString res=lst.join("/");
	if(res.startsWith("/"))
	  	res.remove(0,1);
	
	
	qDebug() << res;
	
	if(res != txt)
	{	
		lineEdit_->setText(res);
		dispatchChange();
	}	
}  
	
void MvQTextLine::slotHelperEdited(const vector<string>& values)
{
  	if(values.size() > 0) 
	{
	  	QString s(values[0].c_str());
		lineEdit_->setText(s);
		dispatchChange();
	}
  
}  
	
static LineMaker<MvQTextLine> maker1("text");

